const RATIOX = 16;
const RATIOY = 9;

window.addEventListener("load", load);
window.addEventListener("resize", resize);

function load(){
	
	resize();
	
	window.addEventListener('beforeunload', (event) => {
		event.returnValue = "Sure?";
		return "Sure?";
	});
}

function resize() {
	
	let canvas = document.getElementById("unity-canvas");	
	let viewportWidth = window.innerWidth;
	let viewportHeight = window.innerHeight;
	
	let newCanvasWidth;
	let newCanvasHeight;
	
	if (RATIOY / RATIOX > viewportHeight / viewportWidth) {
		
		newCanvasWidth = (RATIOX / RATIOY * viewportHeight);
		newCanvasHeight = viewportHeight;

	} else {
		
		newCanvasWidth = viewportWidth;
		newCanvasHeight = (RATIOY / RATIOX * viewportWidth);
		
	}	
	canvas.style.width = newCanvasWidth + "px";
	canvas.style.height = newCanvasHeight + "px";
	
	let marginLeft = (viewportWidth - newCanvasWidth) / 2;
	let marginTop = (viewportHeight - newCanvasHeight) / 2;
	canvas.style.marginLeft = marginLeft + "px";
	canvas.style.marginTop = marginTop + "px";
}
