// Generated by Construct, the game and app creator :: https://www.construct.net
// ../3rdparty/glmatrix.js
{
/*
 @fileoverview gl-matrix - High performance matrix and vector operations
@author Brandon Jones
@author Colin MacKenzie IV
@version 3.4.1

Copyright (c) 2015-2021, Brandon Jones, Colin MacKenzie IV.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.glMatrix={}))})(this,function(exports){var EPSILON=1E-6;var ARRAY_TYPE=typeof Float32Array!=="undefined"?Float32Array:Array;var RANDOM=Math.random;var ANGLE_ORDER="zyx";function setMatrixArrayType(type){ARRAY_TYPE=type}var degree=Math.PI/180;function toRadian(a){return a*
degree}function equals$9(a,b){return Math.abs(a-b)<=EPSILON*Math.max(1,Math.abs(a),Math.abs(b))}if(!Math.hypot)Math.hypot=function(){var y=0,i=arguments.length;while(i--)y+=arguments[i]*arguments[i];return Math.sqrt(y)};var common=Object.freeze({__proto__:null,EPSILON:EPSILON,get ARRAY_TYPE(){return ARRAY_TYPE},RANDOM:RANDOM,ANGLE_ORDER:ANGLE_ORDER,setMatrixArrayType:setMatrixArrayType,toRadian:toRadian,equals:equals$9});function create$8(){var out=new ARRAY_TYPE(4);if(ARRAY_TYPE!=Float32Array){out[1]=
0;out[2]=0}out[0]=1;out[3]=1;return out}function clone$8(a){var out=new ARRAY_TYPE(4);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function copy$8(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function identity$5(out){out[0]=1;out[1]=0;out[2]=0;out[3]=1;return out}function fromValues$8(m00,m01,m10,m11){var out=new ARRAY_TYPE(4);out[0]=m00;out[1]=m01;out[2]=m10;out[3]=m11;return out}function set$8(out,m00,m01,m10,m11){out[0]=m00;out[1]=m01;out[2]=m10;out[3]=m11;return out}
function transpose$2(out,a){if(out===a){var a1=a[1];out[1]=a[2];out[2]=a1}else{out[0]=a[0];out[1]=a[2];out[2]=a[1];out[3]=a[3]}return out}function invert$5(out,a){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var det=a0*a3-a2*a1;if(!det)return null;det=1/det;out[0]=a3*det;out[1]=-a1*det;out[2]=-a2*det;out[3]=a0*det;return out}function adjoint$2(out,a){var a0=a[0];out[0]=a[3];out[1]=-a[1];out[2]=-a[2];out[3]=a0;return out}function determinant$3(a){return a[0]*a[3]-a[2]*a[1]}function multiply$8(out,a,b){var a0=
a[0],a1=a[1],a2=a[2],a3=a[3];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];out[0]=a0*b0+a2*b1;out[1]=a1*b0+a3*b1;out[2]=a0*b2+a2*b3;out[3]=a1*b2+a3*b3;return out}function rotate$4(out,a,rad){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var s=Math.sin(rad);var c=Math.cos(rad);out[0]=a0*c+a2*s;out[1]=a1*c+a3*s;out[2]=a0*-s+a2*c;out[3]=a1*-s+a3*c;return out}function scale$8(out,a,v){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var v0=v[0],v1=v[1];out[0]=a0*v0;out[1]=a1*v0;out[2]=a2*v1;out[3]=a3*v1;return out}function fromRotation$4(out,
rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=-s;out[3]=c;return out}function fromScaling$3(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=v[1];return out}function str$8(a){return"mat2("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+")"}function frob$3(a){return Math.hypot(a[0],a[1],a[2],a[3])}function LDU(L,D,U,a){L[2]=a[2]/a[0];U[0]=a[0];U[1]=a[1];U[3]=a[3]-L[2]*U[1];return[L,D,U]}function add$8(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];return out}function subtract$6(out,
a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];return out}function exactEquals$8(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]}function equals$8(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),
Math.abs(b3))}function multiplyScalar$3(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;return out}function multiplyScalarAndAdd$3(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;return out}var mul$8=multiply$8;var sub$6=subtract$6;var mat2=Object.freeze({__proto__:null,create:create$8,clone:clone$8,copy:copy$8,identity:identity$5,fromValues:fromValues$8,set:set$8,transpose:transpose$2,invert:invert$5,adjoint:adjoint$2,determinant:determinant$3,
multiply:multiply$8,rotate:rotate$4,scale:scale$8,fromRotation:fromRotation$4,fromScaling:fromScaling$3,str:str$8,frob:frob$3,LDU:LDU,add:add$8,subtract:subtract$6,exactEquals:exactEquals$8,equals:equals$8,multiplyScalar:multiplyScalar$3,multiplyScalarAndAdd:multiplyScalarAndAdd$3,mul:mul$8,sub:sub$6});function create$7(){var out=new ARRAY_TYPE(6);if(ARRAY_TYPE!=Float32Array){out[1]=0;out[2]=0;out[4]=0;out[5]=0}out[0]=1;out[3]=1;return out}function clone$7(a){var out=new ARRAY_TYPE(6);out[0]=a[0];
out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];return out}function copy$7(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];return out}function identity$4(out){out[0]=1;out[1]=0;out[2]=0;out[3]=1;out[4]=0;out[5]=0;return out}function fromValues$7(a,b,c,d,tx,ty){var out=new ARRAY_TYPE(6);out[0]=a;out[1]=b;out[2]=c;out[3]=d;out[4]=tx;out[5]=ty;return out}function set$7(out,a,b,c,d,tx,ty){out[0]=a;out[1]=b;out[2]=c;out[3]=d;out[4]=tx;out[5]=ty;return out}function invert$4(out,
a){var aa=a[0],ab=a[1],ac=a[2],ad=a[3];var atx=a[4],aty=a[5];var det=aa*ad-ab*ac;if(!det)return null;det=1/det;out[0]=ad*det;out[1]=-ab*det;out[2]=-ac*det;out[3]=aa*det;out[4]=(ac*aty-ad*atx)*det;out[5]=(ab*atx-aa*aty)*det;return out}function determinant$2(a){return a[0]*a[3]-a[1]*a[2]}function multiply$7(out,a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5];out[0]=a0*b0+a2*b1;out[1]=a1*b0+a3*b1;out[2]=a0*b2+a2*b3;out[3]=a1*b2+a3*b3;out[4]=
a0*b4+a2*b5+a4;out[5]=a1*b4+a3*b5+a5;return out}function rotate$3(out,a,rad){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var s=Math.sin(rad);var c=Math.cos(rad);out[0]=a0*c+a2*s;out[1]=a1*c+a3*s;out[2]=a0*-s+a2*c;out[3]=a1*-s+a3*c;out[4]=a4;out[5]=a5;return out}function scale$7(out,a,v){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var v0=v[0],v1=v[1];out[0]=a0*v0;out[1]=a1*v0;out[2]=a2*v1;out[3]=a3*v1;out[4]=a4;out[5]=a5;return out}function translate$3(out,a,v){var a0=a[0],a1=a[1],
a2=a[2],a3=a[3],a4=a[4],a5=a[5];var v0=v[0],v1=v[1];out[0]=a0;out[1]=a1;out[2]=a2;out[3]=a3;out[4]=a0*v0+a2*v1+a4;out[5]=a1*v0+a3*v1+a5;return out}function fromRotation$3(out,rad){var s=Math.sin(rad),c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=-s;out[3]=c;out[4]=0;out[5]=0;return out}function fromScaling$2(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=v[1];out[4]=0;out[5]=0;return out}function fromTranslation$3(out,v){out[0]=1;out[1]=0;out[2]=0;out[3]=1;out[4]=v[0];out[5]=v[1];return out}function str$7(a){return"mat2d("+
a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+")"}function frob$2(a){return Math.hypot(a[0],a[1],a[2],a[3],a[4],a[5],1)}function add$7(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];return out}function subtract$5(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];out[4]=a[4]-b[4];out[5]=a[5]-b[5];return out}function multiplyScalar$2(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;out[4]=
a[4]*b;out[5]=a[5]*b;return out}function multiplyScalarAndAdd$2(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;out[4]=a[4]+b[4]*scale;out[5]=a[5]+b[5]*scale;return out}function exactEquals$7(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]}function equals$7(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5];return Math.abs(a0-b0)<=EPSILON*Math.max(1,
Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),Math.abs(b4))&&Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))}var mul$7=multiply$7;var sub$5=subtract$5;var mat2d=Object.freeze({__proto__:null,create:create$7,clone:clone$7,copy:copy$7,identity:identity$4,fromValues:fromValues$7,
set:set$7,invert:invert$4,determinant:determinant$2,multiply:multiply$7,rotate:rotate$3,scale:scale$7,translate:translate$3,fromRotation:fromRotation$3,fromScaling:fromScaling$2,fromTranslation:fromTranslation$3,str:str$7,frob:frob$2,add:add$7,subtract:subtract$5,multiplyScalar:multiplyScalar$2,multiplyScalarAndAdd:multiplyScalarAndAdd$2,exactEquals:exactEquals$7,equals:equals$7,mul:mul$7,sub:sub$5});function create$6(){var out=new ARRAY_TYPE(9);if(ARRAY_TYPE!=Float32Array){out[1]=0;out[2]=0;out[3]=
0;out[5]=0;out[6]=0;out[7]=0}out[0]=1;out[4]=1;out[8]=1;return out}function fromMat4$1(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[4];out[4]=a[5];out[5]=a[6];out[6]=a[8];out[7]=a[9];out[8]=a[10];return out}function clone$6(a){var out=new ARRAY_TYPE(9);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];return out}function copy$6(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=
a[8];return out}function fromValues$6(m00,m01,m02,m10,m11,m12,m20,m21,m22){var out=new ARRAY_TYPE(9);out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m10;out[4]=m11;out[5]=m12;out[6]=m20;out[7]=m21;out[8]=m22;return out}function set$6(out,m00,m01,m02,m10,m11,m12,m20,m21,m22){out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m10;out[4]=m11;out[5]=m12;out[6]=m20;out[7]=m21;out[8]=m22;return out}function identity$3(out){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=1;out[5]=0;out[6]=0;out[7]=0;out[8]=1;return out}function transpose$1(out,
a){if(out===a){var a01=a[1],a02=a[2],a12=a[5];out[1]=a[3];out[2]=a[6];out[3]=a01;out[5]=a[7];out[6]=a02;out[7]=a12}else{out[0]=a[0];out[1]=a[3];out[2]=a[6];out[3]=a[1];out[4]=a[4];out[5]=a[7];out[6]=a[2];out[7]=a[5];out[8]=a[8]}return out}function invert$3(out,a){var a00=a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];var b01=a22*a11-a12*a21;var b11=-a22*a10+a12*a20;var b21=a21*a10-a11*a20;var det=a00*b01+a01*b11+a02*b21;if(!det)return null;det=1/det;out[0]=b01*
det;out[1]=(-a22*a01+a02*a21)*det;out[2]=(a12*a01-a02*a11)*det;out[3]=b11*det;out[4]=(a22*a00-a02*a20)*det;out[5]=(-a12*a00+a02*a10)*det;out[6]=b21*det;out[7]=(-a21*a00+a01*a20)*det;out[8]=(a11*a00-a01*a10)*det;return out}function adjoint$1(out,a){var a00=a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];out[0]=a11*a22-a12*a21;out[1]=a02*a21-a01*a22;out[2]=a01*a12-a02*a11;out[3]=a12*a20-a10*a22;out[4]=a00*a22-a02*a20;out[5]=a02*a10-a00*a12;out[6]=a10*a21-a11*a20;
out[7]=a01*a20-a00*a21;out[8]=a00*a11-a01*a10;return out}function determinant$1(a){var a00=a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];return a00*(a22*a11-a12*a21)+a01*(-a22*a10+a12*a20)+a02*(a21*a10-a11*a20)}function multiply$6(out,a,b){var a00=a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];var b00=b[0],b01=b[1],b02=b[2];var b10=b[3],b11=b[4],b12=b[5];var b20=b[6],b21=b[7],b22=b[8];out[0]=b00*a00+b01*a10+b02*a20;out[1]=
b00*a01+b01*a11+b02*a21;out[2]=b00*a02+b01*a12+b02*a22;out[3]=b10*a00+b11*a10+b12*a20;out[4]=b10*a01+b11*a11+b12*a21;out[5]=b10*a02+b11*a12+b12*a22;out[6]=b20*a00+b21*a10+b22*a20;out[7]=b20*a01+b21*a11+b22*a21;out[8]=b20*a02+b21*a12+b22*a22;return out}function translate$2(out,a,v){var a00=a[0],a01=a[1],a02=a[2],a10=a[3],a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],x=v[0],y=v[1];out[0]=a00;out[1]=a01;out[2]=a02;out[3]=a10;out[4]=a11;out[5]=a12;out[6]=x*a00+y*a10+a20;out[7]=x*a01+y*a11+a21;out[8]=x*
a02+y*a12+a22;return out}function rotate$2(out,a,rad){var a00=a[0],a01=a[1],a02=a[2],a10=a[3],a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],s=Math.sin(rad),c=Math.cos(rad);out[0]=c*a00+s*a10;out[1]=c*a01+s*a11;out[2]=c*a02+s*a12;out[3]=c*a10-s*a00;out[4]=c*a11-s*a01;out[5]=c*a12-s*a02;out[6]=a20;out[7]=a21;out[8]=a22;return out}function scale$6(out,a,v){var x=v[0],y=v[1];out[0]=x*a[0];out[1]=x*a[1];out[2]=x*a[2];out[3]=y*a[3];out[4]=y*a[4];out[5]=y*a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];return out}
function fromTranslation$2(out,v){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=1;out[5]=0;out[6]=v[0];out[7]=v[1];out[8]=1;return out}function fromRotation$2(out,rad){var s=Math.sin(rad),c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=0;out[3]=-s;out[4]=c;out[5]=0;out[6]=0;out[7]=0;out[8]=1;return out}function fromScaling$1(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=0;out[4]=v[1];out[5]=0;out[6]=0;out[7]=0;out[8]=1;return out}function fromMat2d(out,a){out[0]=a[0];out[1]=a[1];out[2]=0;out[3]=a[2];out[4]=a[3];
out[5]=0;out[6]=a[4];out[7]=a[5];out[8]=1;return out}function fromQuat$1(out,q){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;var yx=y*x2;var yy=y*y2;var zx=z*x2;var zy=z*y2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;out[0]=1-yy-zz;out[3]=yx-wz;out[6]=zx+wy;out[1]=yx+wz;out[4]=1-xx-zz;out[7]=zy-wx;out[2]=zx-wy;out[5]=zy+wx;out[8]=1-xx-yy;return out}function normalFromMat4(out,a){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=
a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b00=a00*a11-a01*a10;var b01=a00*a12-a02*a10;var b02=a00*a13-a03*a10;var b03=a01*a12-a02*a11;var b04=a01*a13-a03*a11;var b05=a02*a13-a03*a12;var b06=a20*a31-a21*a30;var b07=a20*a32-a22*a30;var b08=a20*a33-a23*a30;var b09=a21*a32-a22*a31;var b10=a21*a33-a23*a31;var b11=a22*a33-a23*a32;var det=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06;if(!det)return null;det=1/det;out[0]=(a11*b11-a12*b10+a13*b09)*det;out[1]=(a12*
b08-a10*b11-a13*b07)*det;out[2]=(a10*b10-a11*b08+a13*b06)*det;out[3]=(a02*b10-a01*b11-a03*b09)*det;out[4]=(a00*b11-a02*b08+a03*b07)*det;out[5]=(a01*b08-a00*b10-a03*b06)*det;out[6]=(a31*b05-a32*b04+a33*b03)*det;out[7]=(a32*b02-a30*b05-a33*b01)*det;out[8]=(a30*b04-a31*b02+a33*b00)*det;return out}function projection(out,width,height){out[0]=2/width;out[1]=0;out[2]=0;out[3]=0;out[4]=-2/height;out[5]=0;out[6]=-1;out[7]=1;out[8]=1;return out}function str$6(a){return"mat3("+a[0]+", "+a[1]+", "+a[2]+", "+
a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+", "+a[8]+")"}function frob$1(a){return Math.hypot(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8])}function add$6(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];out[6]=a[6]+b[6];out[7]=a[7]+b[7];out[8]=a[8]+b[8];return out}function subtract$4(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];out[4]=a[4]-b[4];out[5]=a[5]-b[5];out[6]=a[6]-b[6];out[7]=a[7]-b[7];out[8]=
a[8]-b[8];return out}function multiplyScalar$1(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;out[4]=a[4]*b;out[5]=a[5]*b;out[6]=a[6]*b;out[7]=a[7]*b;out[8]=a[8]*b;return out}function multiplyScalarAndAdd$1(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;out[4]=a[4]+b[4]*scale;out[5]=a[5]+b[5]*scale;out[6]=a[6]+b[6]*scale;out[7]=a[7]+b[7]*scale;out[8]=a[8]+b[8]*scale;return out}function exactEquals$6(a,b){return a[0]===b[0]&&
a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]&&a[6]===b[6]&&a[7]===b[7]&&a[8]===b[8]}function equals$6(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5],a6=a[6],a7=a[7],a8=a[8];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5],b6=b[6],b7=b[7],b8=b[8];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*
Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),Math.abs(b4))&&Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))&&Math.abs(a6-b6)<=EPSILON*Math.max(1,Math.abs(a6),Math.abs(b6))&&Math.abs(a7-b7)<=EPSILON*Math.max(1,Math.abs(a7),Math.abs(b7))&&Math.abs(a8-b8)<=EPSILON*Math.max(1,Math.abs(a8),Math.abs(b8))}var mul$6=multiply$6;var sub$4=subtract$4;var mat3=Object.freeze({__proto__:null,create:create$6,fromMat4:fromMat4$1,clone:clone$6,copy:copy$6,
fromValues:fromValues$6,set:set$6,identity:identity$3,transpose:transpose$1,invert:invert$3,adjoint:adjoint$1,determinant:determinant$1,multiply:multiply$6,translate:translate$2,rotate:rotate$2,scale:scale$6,fromTranslation:fromTranslation$2,fromRotation:fromRotation$2,fromScaling:fromScaling$1,fromMat2d:fromMat2d,fromQuat:fromQuat$1,normalFromMat4:normalFromMat4,projection:projection,str:str$6,frob:frob$1,add:add$6,subtract:subtract$4,multiplyScalar:multiplyScalar$1,multiplyScalarAndAdd:multiplyScalarAndAdd$1,
exactEquals:exactEquals$6,equals:equals$6,mul:mul$6,sub:sub$4});function create$5(){var out=new ARRAY_TYPE(16);if(ARRAY_TYPE!=Float32Array){out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[11]=0;out[12]=0;out[13]=0;out[14]=0}out[0]=1;out[5]=1;out[10]=1;out[15]=1;return out}function clone$5(a){var out=new ARRAY_TYPE(16);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];out[9]=a[9];out[10]=a[10];out[11]=a[11];out[12]=
a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15];return out}function copy$5(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];out[9]=a[9];out[10]=a[10];out[11]=a[11];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15];return out}function fromValues$5(m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33){var out=new ARRAY_TYPE(16);out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m03;out[4]=m10;out[5]=m11;out[6]=m12;out[7]=m13;out[8]=
m20;out[9]=m21;out[10]=m22;out[11]=m23;out[12]=m30;out[13]=m31;out[14]=m32;out[15]=m33;return out}function set$5(out,m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33){out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m03;out[4]=m10;out[5]=m11;out[6]=m12;out[7]=m13;out[8]=m20;out[9]=m21;out[10]=m22;out[11]=m23;out[12]=m30;out[13]=m31;out[14]=m32;out[15]=m33;return out}function identity$2(out){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=1;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=1;out[11]=
0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function transpose(out,a){if(out===a){var a01=a[1],a02=a[2],a03=a[3];var a12=a[6],a13=a[7];var a23=a[11];out[1]=a[4];out[2]=a[8];out[3]=a[12];out[4]=a01;out[6]=a[9];out[7]=a[13];out[8]=a02;out[9]=a12;out[11]=a[14];out[12]=a03;out[13]=a13;out[14]=a23}else{out[0]=a[0];out[1]=a[4];out[2]=a[8];out[3]=a[12];out[4]=a[1];out[5]=a[5];out[6]=a[9];out[7]=a[13];out[8]=a[2];out[9]=a[6];out[10]=a[10];out[11]=a[14];out[12]=a[3];out[13]=a[7];out[14]=a[11];out[15]=
a[15]}return out}function invert$2(out,a){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b00=a00*a11-a01*a10;var b01=a00*a12-a02*a10;var b02=a00*a13-a03*a10;var b03=a01*a12-a02*a11;var b04=a01*a13-a03*a11;var b05=a02*a13-a03*a12;var b06=a20*a31-a21*a30;var b07=a20*a32-a22*a30;var b08=a20*a33-a23*a30;var b09=a21*a32-a22*a31;var b10=a21*a33-a23*a31;var b11=a22*a33-a23*a32;var det=
b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06;if(!det)return null;det=1/det;out[0]=(a11*b11-a12*b10+a13*b09)*det;out[1]=(a02*b10-a01*b11-a03*b09)*det;out[2]=(a31*b05-a32*b04+a33*b03)*det;out[3]=(a22*b04-a21*b05-a23*b03)*det;out[4]=(a12*b08-a10*b11-a13*b07)*det;out[5]=(a00*b11-a02*b08+a03*b07)*det;out[6]=(a32*b02-a30*b05-a33*b01)*det;out[7]=(a20*b05-a22*b02+a23*b01)*det;out[8]=(a10*b10-a11*b08+a13*b06)*det;out[9]=(a01*b08-a00*b10-a03*b06)*det;out[10]=(a30*b04-a31*b02+a33*b00)*det;out[11]=(a21*b02-
a20*b04-a23*b00)*det;out[12]=(a11*b07-a10*b09-a12*b06)*det;out[13]=(a00*b09-a01*b07+a02*b06)*det;out[14]=(a31*b01-a30*b03-a32*b00)*det;out[15]=(a20*b03-a21*b01+a22*b00)*det;return out}function adjoint(out,a){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b00=a00*a11-a01*a10;var b01=a00*a12-a02*a10;var b02=a00*a13-a03*a10;var b03=a01*a12-a02*a11;var b04=a01*a13-a03*a11;var b05=
a02*a13-a03*a12;var b06=a20*a31-a21*a30;var b07=a20*a32-a22*a30;var b08=a20*a33-a23*a30;var b09=a21*a32-a22*a31;var b10=a21*a33-a23*a31;var b11=a22*a33-a23*a32;out[0]=a11*b11-a12*b10+a13*b09;out[1]=a02*b10-a01*b11-a03*b09;out[2]=a31*b05-a32*b04+a33*b03;out[3]=a22*b04-a21*b05-a23*b03;out[4]=a12*b08-a10*b11-a13*b07;out[5]=a00*b11-a02*b08+a03*b07;out[6]=a32*b02-a30*b05-a33*b01;out[7]=a20*b05-a22*b02+a23*b01;out[8]=a10*b10-a11*b08+a13*b06;out[9]=a01*b08-a00*b10-a03*b06;out[10]=a30*b04-a31*b02+a33*b00;
out[11]=a21*b02-a20*b04-a23*b00;out[12]=a11*b07-a10*b09-a12*b06;out[13]=a00*b09-a01*b07+a02*b06;out[14]=a31*b01-a30*b03-a32*b00;out[15]=a20*b03-a21*b01+a22*b00;return out}function determinant(a){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b0=a00*a11-a01*a10;var b1=a00*a12-a02*a10;var b2=a01*a12-a02*a11;var b3=a20*a31-a21*a30;var b4=a20*a32-a22*a30;var b5=a21*a32-a22*a31;var b6=
a00*b5-a01*b4+a02*b3;var b7=a10*b5-a11*b4+a12*b3;var b8=a20*b2-a21*b1+a22*b0;var b9=a30*b2-a31*b1+a32*b0;return a13*b6-a03*b7+a33*b8-a23*b9}function multiply$5(out,a,b){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];out[0]=b0*a00+b1*a10+b2*a20+b3*a30;out[1]=b0*a01+b1*a11+b2*a21+b3*a31;out[2]=b0*a02+b1*a12+b2*a22+b3*a32;out[3]=b0*a03+b1*a13+b2*a23+
b3*a33;b0=b[4];b1=b[5];b2=b[6];b3=b[7];out[4]=b0*a00+b1*a10+b2*a20+b3*a30;out[5]=b0*a01+b1*a11+b2*a21+b3*a31;out[6]=b0*a02+b1*a12+b2*a22+b3*a32;out[7]=b0*a03+b1*a13+b2*a23+b3*a33;b0=b[8];b1=b[9];b2=b[10];b3=b[11];out[8]=b0*a00+b1*a10+b2*a20+b3*a30;out[9]=b0*a01+b1*a11+b2*a21+b3*a31;out[10]=b0*a02+b1*a12+b2*a22+b3*a32;out[11]=b0*a03+b1*a13+b2*a23+b3*a33;b0=b[12];b1=b[13];b2=b[14];b3=b[15];out[12]=b0*a00+b1*a10+b2*a20+b3*a30;out[13]=b0*a01+b1*a11+b2*a21+b3*a31;out[14]=b0*a02+b1*a12+b2*a22+b3*a32;out[15]=
b0*a03+b1*a13+b2*a23+b3*a33;return out}function translate$1(out,a,v){var x=v[0],y=v[1],z=v[2];var a00,a01,a02,a03;var a10,a11,a12,a13;var a20,a21,a22,a23;if(a===out){out[12]=a[0]*x+a[4]*y+a[8]*z+a[12];out[13]=a[1]*x+a[5]*y+a[9]*z+a[13];out[14]=a[2]*x+a[6]*y+a[10]*z+a[14];out[15]=a[3]*x+a[7]*y+a[11]*z+a[15]}else{a00=a[0];a01=a[1];a02=a[2];a03=a[3];a10=a[4];a11=a[5];a12=a[6];a13=a[7];a20=a[8];a21=a[9];a22=a[10];a23=a[11];out[0]=a00;out[1]=a01;out[2]=a02;out[3]=a03;out[4]=a10;out[5]=a11;out[6]=a12;out[7]=
a13;out[8]=a20;out[9]=a21;out[10]=a22;out[11]=a23;out[12]=a00*x+a10*y+a20*z+a[12];out[13]=a01*x+a11*y+a21*z+a[13];out[14]=a02*x+a12*y+a22*z+a[14];out[15]=a03*x+a13*y+a23*z+a[15]}return out}function scale$5(out,a,v){var x=v[0],y=v[1],z=v[2];out[0]=a[0]*x;out[1]=a[1]*x;out[2]=a[2]*x;out[3]=a[3]*x;out[4]=a[4]*y;out[5]=a[5]*y;out[6]=a[6]*y;out[7]=a[7]*y;out[8]=a[8]*z;out[9]=a[9]*z;out[10]=a[10]*z;out[11]=a[11]*z;out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15];return out}function rotate$1(out,
a,rad,axis){var x=axis[0],y=axis[1],z=axis[2];var len=Math.hypot(x,y,z);var s,c,t;var a00,a01,a02,a03;var a10,a11,a12,a13;var a20,a21,a22,a23;var b00,b01,b02;var b10,b11,b12;var b20,b21,b22;if(len<EPSILON)return null;len=1/len;x*=len;y*=len;z*=len;s=Math.sin(rad);c=Math.cos(rad);t=1-c;a00=a[0];a01=a[1];a02=a[2];a03=a[3];a10=a[4];a11=a[5];a12=a[6];a13=a[7];a20=a[8];a21=a[9];a22=a[10];a23=a[11];b00=x*x*t+c;b01=y*x*t+z*s;b02=z*x*t-y*s;b10=x*y*t-z*s;b11=y*y*t+c;b12=z*y*t+x*s;b20=x*z*t+y*s;b21=y*z*t-x*
s;b22=z*z*t+c;out[0]=a00*b00+a10*b01+a20*b02;out[1]=a01*b00+a11*b01+a21*b02;out[2]=a02*b00+a12*b01+a22*b02;out[3]=a03*b00+a13*b01+a23*b02;out[4]=a00*b10+a10*b11+a20*b12;out[5]=a01*b10+a11*b11+a21*b12;out[6]=a02*b10+a12*b11+a22*b12;out[7]=a03*b10+a13*b11+a23*b12;out[8]=a00*b20+a10*b21+a20*b22;out[9]=a01*b20+a11*b21+a21*b22;out[10]=a02*b20+a12*b21+a22*b22;out[11]=a03*b20+a13*b21+a23*b22;if(a!==out){out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15]}return out}function rotateX$3(out,a,rad){var s=
Math.sin(rad);var c=Math.cos(rad);var a10=a[4];var a11=a[5];var a12=a[6];var a13=a[7];var a20=a[8];var a21=a[9];var a22=a[10];var a23=a[11];if(a!==out){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15]}out[4]=a10*c+a20*s;out[5]=a11*c+a21*s;out[6]=a12*c+a22*s;out[7]=a13*c+a23*s;out[8]=a20*c-a10*s;out[9]=a21*c-a11*s;out[10]=a22*c-a12*s;out[11]=a23*c-a13*s;return out}function rotateY$3(out,a,rad){var s=Math.sin(rad);var c=Math.cos(rad);var a00=a[0];
var a01=a[1];var a02=a[2];var a03=a[3];var a20=a[8];var a21=a[9];var a22=a[10];var a23=a[11];if(a!==out){out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15]}out[0]=a00*c-a20*s;out[1]=a01*c-a21*s;out[2]=a02*c-a22*s;out[3]=a03*c-a23*s;out[8]=a00*s+a20*c;out[9]=a01*s+a21*c;out[10]=a02*s+a22*c;out[11]=a03*s+a23*c;return out}function rotateZ$3(out,a,rad){var s=Math.sin(rad);var c=Math.cos(rad);var a00=a[0];var a01=a[1];var a02=a[2];var a03=a[3];var a10=
a[4];var a11=a[5];var a12=a[6];var a13=a[7];if(a!==out){out[8]=a[8];out[9]=a[9];out[10]=a[10];out[11]=a[11];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15]}out[0]=a00*c+a10*s;out[1]=a01*c+a11*s;out[2]=a02*c+a12*s;out[3]=a03*c+a13*s;out[4]=a10*c-a00*s;out[5]=a11*c-a01*s;out[6]=a12*c-a02*s;out[7]=a13*c-a03*s;return out}function fromTranslation$1(out,v){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=1;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=1;out[11]=0;out[12]=v[0];out[13]=v[1];out[14]=
v[2];out[15]=1;return out}function fromScaling(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=v[1];out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=v[2];out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromRotation$1(out,rad,axis){var x=axis[0],y=axis[1],z=axis[2];var len=Math.hypot(x,y,z);var s,c,t;if(len<EPSILON)return null;len=1/len;x*=len;y*=len;z*=len;s=Math.sin(rad);c=Math.cos(rad);t=1-c;out[0]=x*x*t+c;out[1]=y*x*t+z*s;out[2]=z*x*t-y*s;out[3]=0;out[4]=x*y*t-z*
s;out[5]=y*y*t+c;out[6]=z*y*t+x*s;out[7]=0;out[8]=x*z*t+y*s;out[9]=y*z*t-x*s;out[10]=z*z*t+c;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromXRotation(out,rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=c;out[6]=s;out[7]=0;out[8]=0;out[9]=-s;out[10]=c;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromYRotation(out,rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=c;out[1]=0;out[2]=-s;out[3]=0;out[4]=
0;out[5]=1;out[6]=0;out[7]=0;out[8]=s;out[9]=0;out[10]=c;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromZRotation(out,rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=0;out[3]=0;out[4]=-s;out[5]=c;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=1;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromRotationTranslation$1(out,q,v){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;var xy=x*y2;var xz=x*z2;var yy=
y*y2;var yz=y*z2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;out[0]=1-(yy+zz);out[1]=xy+wz;out[2]=xz-wy;out[3]=0;out[4]=xy-wz;out[5]=1-(xx+zz);out[6]=yz+wx;out[7]=0;out[8]=xz+wy;out[9]=yz-wx;out[10]=1-(xx+yy);out[11]=0;out[12]=v[0];out[13]=v[1];out[14]=v[2];out[15]=1;return out}function fromQuat2(out,a){var translation=new ARRAY_TYPE(3);var bx=-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7];var magnitude=bx*bx+by*by+bz*bz+bw*bw;if(magnitude>0){translation[0]=(ax*bw+aw*bx+ay*bz-
az*by)*2/magnitude;translation[1]=(ay*bw+aw*by+az*bx-ax*bz)*2/magnitude;translation[2]=(az*bw+aw*bz+ax*by-ay*bx)*2/magnitude}else{translation[0]=(ax*bw+aw*bx+ay*bz-az*by)*2;translation[1]=(ay*bw+aw*by+az*bx-ax*bz)*2;translation[2]=(az*bw+aw*bz+ax*by-ay*bx)*2}fromRotationTranslation$1(out,a,translation);return out}function getTranslation$1(out,mat){out[0]=mat[12];out[1]=mat[13];out[2]=mat[14];return out}function getScaling(out,mat){var m11=mat[0];var m12=mat[1];var m13=mat[2];var m21=mat[4];var m22=
mat[5];var m23=mat[6];var m31=mat[8];var m32=mat[9];var m33=mat[10];out[0]=Math.hypot(m11,m12,m13);out[1]=Math.hypot(m21,m22,m23);out[2]=Math.hypot(m31,m32,m33);return out}function getRotation(out,mat){var scaling=new ARRAY_TYPE(3);getScaling(scaling,mat);var is1=1/scaling[0];var is2=1/scaling[1];var is3=1/scaling[2];var sm11=mat[0]*is1;var sm12=mat[1]*is2;var sm13=mat[2]*is3;var sm21=mat[4]*is1;var sm22=mat[5]*is2;var sm23=mat[6]*is3;var sm31=mat[8]*is1;var sm32=mat[9]*is2;var sm33=mat[10]*is3;var trace=
sm11+sm22+sm33;var S=0;if(trace>0){S=Math.sqrt(trace+1)*2;out[3]=.25*S;out[0]=(sm23-sm32)/S;out[1]=(sm31-sm13)/S;out[2]=(sm12-sm21)/S}else if(sm11>sm22&&sm11>sm33){S=Math.sqrt(1+sm11-sm22-sm33)*2;out[3]=(sm23-sm32)/S;out[0]=.25*S;out[1]=(sm12+sm21)/S;out[2]=(sm31+sm13)/S}else if(sm22>sm33){S=Math.sqrt(1+sm22-sm11-sm33)*2;out[3]=(sm31-sm13)/S;out[0]=(sm12+sm21)/S;out[1]=.25*S;out[2]=(sm23+sm32)/S}else{S=Math.sqrt(1+sm33-sm11-sm22)*2;out[3]=(sm12-sm21)/S;out[0]=(sm31+sm13)/S;out[1]=(sm23+sm32)/S;out[2]=
.25*S}return out}function decompose(out_r,out_t,out_s,mat){out_t[0]=mat[12];out_t[1]=mat[13];out_t[2]=mat[14];var m11=mat[0];var m12=mat[1];var m13=mat[2];var m21=mat[4];var m22=mat[5];var m23=mat[6];var m31=mat[8];var m32=mat[9];var m33=mat[10];out_s[0]=Math.hypot(m11,m12,m13);out_s[1]=Math.hypot(m21,m22,m23);out_s[2]=Math.hypot(m31,m32,m33);var is1=1/out_s[0];var is2=1/out_s[1];var is3=1/out_s[2];var sm11=m11*is1;var sm12=m12*is2;var sm13=m13*is3;var sm21=m21*is1;var sm22=m22*is2;var sm23=m23*is3;
var sm31=m31*is1;var sm32=m32*is2;var sm33=m33*is3;var trace=sm11+sm22+sm33;var S=0;if(trace>0){S=Math.sqrt(trace+1)*2;out_r[3]=.25*S;out_r[0]=(sm23-sm32)/S;out_r[1]=(sm31-sm13)/S;out_r[2]=(sm12-sm21)/S}else if(sm11>sm22&&sm11>sm33){S=Math.sqrt(1+sm11-sm22-sm33)*2;out_r[3]=(sm23-sm32)/S;out_r[0]=.25*S;out_r[1]=(sm12+sm21)/S;out_r[2]=(sm31+sm13)/S}else if(sm22>sm33){S=Math.sqrt(1+sm22-sm11-sm33)*2;out_r[3]=(sm31-sm13)/S;out_r[0]=(sm12+sm21)/S;out_r[1]=.25*S;out_r[2]=(sm23+sm32)/S}else{S=Math.sqrt(1+
sm33-sm11-sm22)*2;out_r[3]=(sm12-sm21)/S;out_r[0]=(sm31+sm13)/S;out_r[1]=(sm23+sm32)/S;out_r[2]=.25*S}return out_r}function fromRotationTranslationScale(out,q,v,s){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;var xy=x*y2;var xz=x*z2;var yy=y*y2;var yz=y*z2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;var sx=s[0];var sy=s[1];var sz=s[2];out[0]=(1-(yy+zz))*sx;out[1]=(xy+wz)*sx;out[2]=(xz-wy)*sx;out[3]=0;out[4]=(xy-wz)*sy;out[5]=(1-(xx+zz))*sy;out[6]=(yz+wx)*sy;out[7]=
0;out[8]=(xz+wy)*sz;out[9]=(yz-wx)*sz;out[10]=(1-(xx+yy))*sz;out[11]=0;out[12]=v[0];out[13]=v[1];out[14]=v[2];out[15]=1;return out}function fromRotationTranslationScaleOrigin(out,q,v,s,o){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;var xy=x*y2;var xz=x*z2;var yy=y*y2;var yz=y*z2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;var sx=s[0];var sy=s[1];var sz=s[2];var ox=o[0];var oy=o[1];var oz=o[2];var out0=(1-(yy+zz))*sx;var out1=(xy+wz)*sx;var out2=(xz-wy)*sx;var out4=
(xy-wz)*sy;var out5=(1-(xx+zz))*sy;var out6=(yz+wx)*sy;var out8=(xz+wy)*sz;var out9=(yz-wx)*sz;var out10=(1-(xx+yy))*sz;out[0]=out0;out[1]=out1;out[2]=out2;out[3]=0;out[4]=out4;out[5]=out5;out[6]=out6;out[7]=0;out[8]=out8;out[9]=out9;out[10]=out10;out[11]=0;out[12]=v[0]+ox-(out0*ox+out4*oy+out8*oz);out[13]=v[1]+oy-(out1*ox+out5*oy+out9*oz);out[14]=v[2]+oz-(out2*ox+out6*oy+out10*oz);out[15]=1;return out}function fromQuat(out,q){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=
x*x2;var yx=y*x2;var yy=y*y2;var zx=z*x2;var zy=z*y2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;out[0]=1-yy-zz;out[1]=yx+wz;out[2]=zx-wy;out[3]=0;out[4]=yx-wz;out[5]=1-xx-zz;out[6]=zy+wx;out[7]=0;out[8]=zx+wy;out[9]=zy-wx;out[10]=1-xx-yy;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function frustum(out,left,right,bottom,top,near,far){var rl=1/(right-left);var tb=1/(top-bottom);var nf=1/(near-far);out[0]=near*2*rl;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=near*2*tb;out[6]=0;out[7]=
0;out[8]=(right+left)*rl;out[9]=(top+bottom)*tb;out[10]=(far+near)*nf;out[11]=-1;out[12]=0;out[13]=0;out[14]=far*near*2*nf;out[15]=0;return out}function perspectiveNO(out,fovy,aspect,near,far){var f=1/Math.tan(fovy/2);out[0]=f/aspect;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=f;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[11]=-1;out[12]=0;out[13]=0;out[15]=0;if(far!=null&&far!==Infinity){var nf=1/(near-far);out[10]=(far+near)*nf;out[14]=2*far*near*nf}else{out[10]=-1;out[14]=-2*near}return out}var perspective=
perspectiveNO;function perspectiveZO(out,fovy,aspect,near,far){var f=1/Math.tan(fovy/2);out[0]=f/aspect;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=f;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[11]=-1;out[12]=0;out[13]=0;out[15]=0;if(far!=null&&far!==Infinity){var nf=1/(near-far);out[10]=far*nf;out[14]=far*near*nf}else{out[10]=-1;out[14]=-near}return out}function perspectiveFromFieldOfView(out,fov,near,far){var upTan=Math.tan(fov.upDegrees*Math.PI/180);var downTan=Math.tan(fov.downDegrees*Math.PI/180);
var leftTan=Math.tan(fov.leftDegrees*Math.PI/180);var rightTan=Math.tan(fov.rightDegrees*Math.PI/180);var xScale=2/(leftTan+rightTan);var yScale=2/(upTan+downTan);out[0]=xScale;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=yScale;out[6]=0;out[7]=0;out[8]=-((leftTan-rightTan)*xScale*.5);out[9]=(upTan-downTan)*yScale*.5;out[10]=far/(near-far);out[11]=-1;out[12]=0;out[13]=0;out[14]=far*near/(near-far);out[15]=0;return out}function orthoNO(out,left,right,bottom,top,near,far){var lr=1/(left-right);var bt=
1/(bottom-top);var nf=1/(near-far);out[0]=-2*lr;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=-2*bt;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=2*nf;out[11]=0;out[12]=(left+right)*lr;out[13]=(top+bottom)*bt;out[14]=(far+near)*nf;out[15]=1;return out}var ortho=orthoNO;function orthoZO(out,left,right,bottom,top,near,far){var lr=1/(left-right);var bt=1/(bottom-top);var nf=1/(near-far);out[0]=-2*lr;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=-2*bt;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=nf;out[11]=0;
out[12]=(left+right)*lr;out[13]=(top+bottom)*bt;out[14]=near*nf;out[15]=1;return out}function lookAt(out,eye,center,up){var x0,x1,x2,y0,y1,y2,z0,z1,z2,len;var eyex=eye[0];var eyey=eye[1];var eyez=eye[2];var upx=up[0];var upy=up[1];var upz=up[2];var centerx=center[0];var centery=center[1];var centerz=center[2];if(Math.abs(eyex-centerx)<EPSILON&&Math.abs(eyey-centery)<EPSILON&&Math.abs(eyez-centerz)<EPSILON)return identity$2(out);z0=eyex-centerx;z1=eyey-centery;z2=eyez-centerz;len=1/Math.hypot(z0,z1,
z2);z0*=len;z1*=len;z2*=len;x0=upy*z2-upz*z1;x1=upz*z0-upx*z2;x2=upx*z1-upy*z0;len=Math.hypot(x0,x1,x2);if(!len){x0=0;x1=0;x2=0}else{len=1/len;x0*=len;x1*=len;x2*=len}y0=z1*x2-z2*x1;y1=z2*x0-z0*x2;y2=z0*x1-z1*x0;len=Math.hypot(y0,y1,y2);if(!len){y0=0;y1=0;y2=0}else{len=1/len;y0*=len;y1*=len;y2*=len}out[0]=x0;out[1]=y0;out[2]=z0;out[3]=0;out[4]=x1;out[5]=y1;out[6]=z1;out[7]=0;out[8]=x2;out[9]=y2;out[10]=z2;out[11]=0;out[12]=-(x0*eyex+x1*eyey+x2*eyez);out[13]=-(y0*eyex+y1*eyey+y2*eyez);out[14]=-(z0*
eyex+z1*eyey+z2*eyez);out[15]=1;return out}function targetTo(out,eye,target,up){var eyex=eye[0],eyey=eye[1],eyez=eye[2],upx=up[0],upy=up[1],upz=up[2];var z0=eyex-target[0],z1=eyey-target[1],z2=eyez-target[2];var len=z0*z0+z1*z1+z2*z2;if(len>0){len=1/Math.sqrt(len);z0*=len;z1*=len;z2*=len}var x0=upy*z2-upz*z1,x1=upz*z0-upx*z2,x2=upx*z1-upy*z0;len=x0*x0+x1*x1+x2*x2;if(len>0){len=1/Math.sqrt(len);x0*=len;x1*=len;x2*=len}out[0]=x0;out[1]=x1;out[2]=x2;out[3]=0;out[4]=z1*x2-z2*x1;out[5]=z2*x0-z0*x2;out[6]=
z0*x1-z1*x0;out[7]=0;out[8]=z0;out[9]=z1;out[10]=z2;out[11]=0;out[12]=eyex;out[13]=eyey;out[14]=eyez;out[15]=1;return out}function str$5(a){return"mat4("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+", "+a[8]+", "+a[9]+", "+a[10]+", "+a[11]+", "+a[12]+", "+a[13]+", "+a[14]+", "+a[15]+")"}function frob(a){return Math.hypot(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],a[11],a[12],a[13],a[14],a[15])}function add$5(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=
a[2]+b[2];out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];out[6]=a[6]+b[6];out[7]=a[7]+b[7];out[8]=a[8]+b[8];out[9]=a[9]+b[9];out[10]=a[10]+b[10];out[11]=a[11]+b[11];out[12]=a[12]+b[12];out[13]=a[13]+b[13];out[14]=a[14]+b[14];out[15]=a[15]+b[15];return out}function subtract$3(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];out[4]=a[4]-b[4];out[5]=a[5]-b[5];out[6]=a[6]-b[6];out[7]=a[7]-b[7];out[8]=a[8]-b[8];out[9]=a[9]-b[9];out[10]=a[10]-b[10];out[11]=a[11]-b[11];out[12]=
a[12]-b[12];out[13]=a[13]-b[13];out[14]=a[14]-b[14];out[15]=a[15]-b[15];return out}function multiplyScalar(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;out[4]=a[4]*b;out[5]=a[5]*b;out[6]=a[6]*b;out[7]=a[7]*b;out[8]=a[8]*b;out[9]=a[9]*b;out[10]=a[10]*b;out[11]=a[11]*b;out[12]=a[12]*b;out[13]=a[13]*b;out[14]=a[14]*b;out[15]=a[15]*b;return out}function multiplyScalarAndAdd(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;out[4]=
a[4]+b[4]*scale;out[5]=a[5]+b[5]*scale;out[6]=a[6]+b[6]*scale;out[7]=a[7]+b[7]*scale;out[8]=a[8]+b[8]*scale;out[9]=a[9]+b[9]*scale;out[10]=a[10]+b[10]*scale;out[11]=a[11]+b[11]*scale;out[12]=a[12]+b[12]*scale;out[13]=a[13]+b[13]*scale;out[14]=a[14]+b[14]*scale;out[15]=a[15]+b[15]*scale;return out}function exactEquals$5(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]&&a[6]===b[6]&&a[7]===b[7]&&a[8]===b[8]&&a[9]===b[9]&&a[10]===b[10]&&a[11]===b[11]&&a[12]===
b[12]&&a[13]===b[13]&&a[14]===b[14]&&a[15]===b[15]}function equals$5(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var a4=a[4],a5=a[5],a6=a[6],a7=a[7];var a8=a[8],a9=a[9],a10=a[10],a11=a[11];var a12=a[12],a13=a[13],a14=a[14],a15=a[15];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];var b4=b[4],b5=b[5],b6=b[6],b7=b[7];var b8=b[8],b9=b[9],b10=b[10],b11=b[11];var b12=b[12],b13=b[13],b14=b[14],b15=b[15];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),
Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),Math.abs(b4))&&Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))&&Math.abs(a6-b6)<=EPSILON*Math.max(1,Math.abs(a6),Math.abs(b6))&&Math.abs(a7-b7)<=EPSILON*Math.max(1,Math.abs(a7),Math.abs(b7))&&Math.abs(a8-b8)<=EPSILON*Math.max(1,Math.abs(a8),Math.abs(b8))&&Math.abs(a9-b9)<=EPSILON*Math.max(1,Math.abs(a9),
Math.abs(b9))&&Math.abs(a10-b10)<=EPSILON*Math.max(1,Math.abs(a10),Math.abs(b10))&&Math.abs(a11-b11)<=EPSILON*Math.max(1,Math.abs(a11),Math.abs(b11))&&Math.abs(a12-b12)<=EPSILON*Math.max(1,Math.abs(a12),Math.abs(b12))&&Math.abs(a13-b13)<=EPSILON*Math.max(1,Math.abs(a13),Math.abs(b13))&&Math.abs(a14-b14)<=EPSILON*Math.max(1,Math.abs(a14),Math.abs(b14))&&Math.abs(a15-b15)<=EPSILON*Math.max(1,Math.abs(a15),Math.abs(b15))}var mul$5=multiply$5;var sub$3=subtract$3;var mat4=Object.freeze({__proto__:null,
create:create$5,clone:clone$5,copy:copy$5,fromValues:fromValues$5,set:set$5,identity:identity$2,transpose:transpose,invert:invert$2,adjoint:adjoint,determinant:determinant,multiply:multiply$5,translate:translate$1,scale:scale$5,rotate:rotate$1,rotateX:rotateX$3,rotateY:rotateY$3,rotateZ:rotateZ$3,fromTranslation:fromTranslation$1,fromScaling:fromScaling,fromRotation:fromRotation$1,fromXRotation:fromXRotation,fromYRotation:fromYRotation,fromZRotation:fromZRotation,fromRotationTranslation:fromRotationTranslation$1,
fromQuat2:fromQuat2,getTranslation:getTranslation$1,getScaling:getScaling,getRotation:getRotation,decompose:decompose,fromRotationTranslationScale:fromRotationTranslationScale,fromRotationTranslationScaleOrigin:fromRotationTranslationScaleOrigin,fromQuat:fromQuat,frustum:frustum,perspectiveNO:perspectiveNO,perspective:perspective,perspectiveZO:perspectiveZO,perspectiveFromFieldOfView:perspectiveFromFieldOfView,orthoNO:orthoNO,ortho:ortho,orthoZO:orthoZO,lookAt:lookAt,targetTo:targetTo,str:str$5,frob:frob,
add:add$5,subtract:subtract$3,multiplyScalar:multiplyScalar,multiplyScalarAndAdd:multiplyScalarAndAdd,exactEquals:exactEquals$5,equals:equals$5,mul:mul$5,sub:sub$3});function create$4(){var out=new ARRAY_TYPE(3);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0;out[2]=0}return out}function clone$4(a){var out=new ARRAY_TYPE(3);out[0]=a[0];out[1]=a[1];out[2]=a[2];return out}function length$4(a){var x=a[0];var y=a[1];var z=a[2];return Math.hypot(x,y,z)}function fromValues$4(x,y,z){var out=new ARRAY_TYPE(3);
out[0]=x;out[1]=y;out[2]=z;return out}function copy$4(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];return out}function set$4(out,x,y,z){out[0]=x;out[1]=y;out[2]=z;return out}function add$4(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];return out}function subtract$2(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];return out}function multiply$4(out,a,b){out[0]=a[0]*b[0];out[1]=a[1]*b[1];out[2]=a[2]*b[2];return out}function divide$2(out,a,b){out[0]=a[0]/b[0];out[1]=a[1]/b[1];
out[2]=a[2]/b[2];return out}function ceil$2(out,a){out[0]=Math.ceil(a[0]);out[1]=Math.ceil(a[1]);out[2]=Math.ceil(a[2]);return out}function floor$2(out,a){out[0]=Math.floor(a[0]);out[1]=Math.floor(a[1]);out[2]=Math.floor(a[2]);return out}function min$2(out,a,b){out[0]=Math.min(a[0],b[0]);out[1]=Math.min(a[1],b[1]);out[2]=Math.min(a[2],b[2]);return out}function max$2(out,a,b){out[0]=Math.max(a[0],b[0]);out[1]=Math.max(a[1],b[1]);out[2]=Math.max(a[2],b[2]);return out}function round$2(out,a){out[0]=
Math.round(a[0]);out[1]=Math.round(a[1]);out[2]=Math.round(a[2]);return out}function scale$4(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;return out}function scaleAndAdd$2(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;return out}function distance$2(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];return Math.hypot(x,y,z)}function squaredDistance$2(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];return x*x+y*y+z*z}function squaredLength$4(a){var x=
a[0];var y=a[1];var z=a[2];return x*x+y*y+z*z}function negate$2(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=-a[2];return out}function inverse$2(out,a){out[0]=1/a[0];out[1]=1/a[1];out[2]=1/a[2];return out}function normalize$4(out,a){var x=a[0];var y=a[1];var z=a[2];var len=x*x+y*y+z*z;if(len>0)len=1/Math.sqrt(len);out[0]=a[0]*len;out[1]=a[1]*len;out[2]=a[2]*len;return out}function dot$4(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]}function cross$2(out,a,b){var ax=a[0],ay=a[1],az=a[2];var bx=b[0],by=b[1],
bz=b[2];out[0]=ay*bz-az*by;out[1]=az*bx-ax*bz;out[2]=ax*by-ay*bx;return out}function lerp$4(out,a,b,t){var ax=a[0];var ay=a[1];var az=a[2];out[0]=ax+t*(b[0]-ax);out[1]=ay+t*(b[1]-ay);out[2]=az+t*(b[2]-az);return out}function slerp$1(out,a,b,t){var angle=Math.acos(Math.min(Math.max(dot$4(a,b),-1),1));var sinTotal=Math.sin(angle);var ratioA=Math.sin((1-t)*angle)/sinTotal;var ratioB=Math.sin(t*angle)/sinTotal;out[0]=ratioA*a[0]+ratioB*b[0];out[1]=ratioA*a[1]+ratioB*b[1];out[2]=ratioA*a[2]+ratioB*b[2];
return out}function hermite(out,a,b,c,d,t){var factorTimes2=t*t;var factor1=factorTimes2*(2*t-3)+1;var factor2=factorTimes2*(t-2)+t;var factor3=factorTimes2*(t-1);var factor4=factorTimes2*(3-2*t);out[0]=a[0]*factor1+b[0]*factor2+c[0]*factor3+d[0]*factor4;out[1]=a[1]*factor1+b[1]*factor2+c[1]*factor3+d[1]*factor4;out[2]=a[2]*factor1+b[2]*factor2+c[2]*factor3+d[2]*factor4;return out}function bezier(out,a,b,c,d,t){var inverseFactor=1-t;var inverseFactorTimesTwo=inverseFactor*inverseFactor;var factorTimes2=
t*t;var factor1=inverseFactorTimesTwo*inverseFactor;var factor2=3*t*inverseFactorTimesTwo;var factor3=3*factorTimes2*inverseFactor;var factor4=factorTimes2*t;out[0]=a[0]*factor1+b[0]*factor2+c[0]*factor3+d[0]*factor4;out[1]=a[1]*factor1+b[1]*factor2+c[1]*factor3+d[1]*factor4;out[2]=a[2]*factor1+b[2]*factor2+c[2]*factor3+d[2]*factor4;return out}function random$3(out,scale){scale=scale||1;var r=RANDOM()*2*Math.PI;var z=RANDOM()*2-1;var zScale=Math.sqrt(1-z*z)*scale;out[0]=Math.cos(r)*zScale;out[1]=
Math.sin(r)*zScale;out[2]=z*scale;return out}function transformMat4$2(out,a,m){var x=a[0],y=a[1],z=a[2];var w=m[3]*x+m[7]*y+m[11]*z+m[15];w=w||1;out[0]=(m[0]*x+m[4]*y+m[8]*z+m[12])/w;out[1]=(m[1]*x+m[5]*y+m[9]*z+m[13])/w;out[2]=(m[2]*x+m[6]*y+m[10]*z+m[14])/w;return out}function transformMat3$1(out,a,m){var x=a[0],y=a[1],z=a[2];out[0]=x*m[0]+y*m[3]+z*m[6];out[1]=x*m[1]+y*m[4]+z*m[7];out[2]=x*m[2]+y*m[5]+z*m[8];return out}function transformQuat$1(out,a,q){var qx=q[0],qy=q[1],qz=q[2],qw=q[3];var x=
a[0],y=a[1],z=a[2];var uvx=qy*z-qz*y,uvy=qz*x-qx*z,uvz=qx*y-qy*x;var uuvx=qy*uvz-qz*uvy,uuvy=qz*uvx-qx*uvz,uuvz=qx*uvy-qy*uvx;var w2=qw*2;uvx*=w2;uvy*=w2;uvz*=w2;uuvx*=2;uuvy*=2;uuvz*=2;out[0]=x+uvx+uuvx;out[1]=y+uvy+uuvy;out[2]=z+uvz+uuvz;return out}function rotateX$2(out,a,b,rad){var p=[],r=[];p[0]=a[0]-b[0];p[1]=a[1]-b[1];p[2]=a[2]-b[2];r[0]=p[0];r[1]=p[1]*Math.cos(rad)-p[2]*Math.sin(rad);r[2]=p[1]*Math.sin(rad)+p[2]*Math.cos(rad);out[0]=r[0]+b[0];out[1]=r[1]+b[1];out[2]=r[2]+b[2];return out}function rotateY$2(out,
a,b,rad){var p=[],r=[];p[0]=a[0]-b[0];p[1]=a[1]-b[1];p[2]=a[2]-b[2];r[0]=p[2]*Math.sin(rad)+p[0]*Math.cos(rad);r[1]=p[1];r[2]=p[2]*Math.cos(rad)-p[0]*Math.sin(rad);out[0]=r[0]+b[0];out[1]=r[1]+b[1];out[2]=r[2]+b[2];return out}function rotateZ$2(out,a,b,rad){var p=[],r=[];p[0]=a[0]-b[0];p[1]=a[1]-b[1];p[2]=a[2]-b[2];r[0]=p[0]*Math.cos(rad)-p[1]*Math.sin(rad);r[1]=p[0]*Math.sin(rad)+p[1]*Math.cos(rad);r[2]=p[2];out[0]=r[0]+b[0];out[1]=r[1]+b[1];out[2]=r[2]+b[2];return out}function angle$1(a,b){var ax=
a[0],ay=a[1],az=a[2],bx=b[0],by=b[1],bz=b[2],mag=Math.sqrt((ax*ax+ay*ay+az*az)*(bx*bx+by*by+bz*bz)),cosine=mag&&dot$4(a,b)/mag;return Math.acos(Math.min(Math.max(cosine,-1),1))}function zero$2(out){out[0]=0;out[1]=0;out[2]=0;return out}function str$4(a){return"vec3("+a[0]+", "+a[1]+", "+a[2]+")"}function exactEquals$4(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]}function equals$4(a,b){var a0=a[0],a1=a[1],a2=a[2];var b0=b[0],b1=b[1],b2=b[2];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),
Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))}var sub$2=subtract$2;var mul$4=multiply$4;var div$2=divide$2;var dist$2=distance$2;var sqrDist$2=squaredDistance$2;var len$4=length$4;var sqrLen$4=squaredLength$4;var forEach$2=function(){var vec=create$4();return function(a,stride,offset,count,fn,arg){var i,l;if(!stride)stride=3;if(!offset)offset=0;if(count)l=Math.min(count*stride+offset,a.length);else l=a.length;
for(i=offset;i<l;i+=stride){vec[0]=a[i];vec[1]=a[i+1];vec[2]=a[i+2];fn(vec,vec,arg);a[i]=vec[0];a[i+1]=vec[1];a[i+2]=vec[2]}return a}}();var vec3=Object.freeze({__proto__:null,create:create$4,clone:clone$4,length:length$4,fromValues:fromValues$4,copy:copy$4,set:set$4,add:add$4,subtract:subtract$2,multiply:multiply$4,divide:divide$2,ceil:ceil$2,floor:floor$2,min:min$2,max:max$2,round:round$2,scale:scale$4,scaleAndAdd:scaleAndAdd$2,distance:distance$2,squaredDistance:squaredDistance$2,squaredLength:squaredLength$4,
negate:negate$2,inverse:inverse$2,normalize:normalize$4,dot:dot$4,cross:cross$2,lerp:lerp$4,slerp:slerp$1,hermite:hermite,bezier:bezier,random:random$3,transformMat4:transformMat4$2,transformMat3:transformMat3$1,transformQuat:transformQuat$1,rotateX:rotateX$2,rotateY:rotateY$2,rotateZ:rotateZ$2,angle:angle$1,zero:zero$2,str:str$4,exactEquals:exactEquals$4,equals:equals$4,sub:sub$2,mul:mul$4,div:div$2,dist:dist$2,sqrDist:sqrDist$2,len:len$4,sqrLen:sqrLen$4,forEach:forEach$2});function create$3(){var out=
new ARRAY_TYPE(4);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0;out[2]=0;out[3]=0}return out}function clone$3(a){var out=new ARRAY_TYPE(4);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function fromValues$3(x,y,z,w){var out=new ARRAY_TYPE(4);out[0]=x;out[1]=y;out[2]=z;out[3]=w;return out}function copy$3(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function set$3(out,x,y,z,w){out[0]=x;out[1]=y;out[2]=z;out[3]=w;return out}function add$3(out,a,b){out[0]=a[0]+b[0];
out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];return out}function subtract$1(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];return out}function multiply$3(out,a,b){out[0]=a[0]*b[0];out[1]=a[1]*b[1];out[2]=a[2]*b[2];out[3]=a[3]*b[3];return out}function divide$1(out,a,b){out[0]=a[0]/b[0];out[1]=a[1]/b[1];out[2]=a[2]/b[2];out[3]=a[3]/b[3];return out}function ceil$1(out,a){out[0]=Math.ceil(a[0]);out[1]=Math.ceil(a[1]);out[2]=Math.ceil(a[2]);out[3]=Math.ceil(a[3]);return out}
function floor$1(out,a){out[0]=Math.floor(a[0]);out[1]=Math.floor(a[1]);out[2]=Math.floor(a[2]);out[3]=Math.floor(a[3]);return out}function min$1(out,a,b){out[0]=Math.min(a[0],b[0]);out[1]=Math.min(a[1],b[1]);out[2]=Math.min(a[2],b[2]);out[3]=Math.min(a[3],b[3]);return out}function max$1(out,a,b){out[0]=Math.max(a[0],b[0]);out[1]=Math.max(a[1],b[1]);out[2]=Math.max(a[2],b[2]);out[3]=Math.max(a[3],b[3]);return out}function round$1(out,a){out[0]=Math.round(a[0]);out[1]=Math.round(a[1]);out[2]=Math.round(a[2]);
out[3]=Math.round(a[3]);return out}function scale$3(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;return out}function scaleAndAdd$1(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;return out}function distance$1(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];var w=b[3]-a[3];return Math.hypot(x,y,z,w)}function squaredDistance$1(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];var w=b[3]-a[3];return x*x+y*y+z*z+w*
w}function length$3(a){var x=a[0];var y=a[1];var z=a[2];var w=a[3];return Math.hypot(x,y,z,w)}function squaredLength$3(a){var x=a[0];var y=a[1];var z=a[2];var w=a[3];return x*x+y*y+z*z+w*w}function negate$1(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=-a[2];out[3]=-a[3];return out}function inverse$1(out,a){out[0]=1/a[0];out[1]=1/a[1];out[2]=1/a[2];out[3]=1/a[3];return out}function normalize$3(out,a){var x=a[0];var y=a[1];var z=a[2];var w=a[3];var len=x*x+y*y+z*z+w*w;if(len>0)len=1/Math.sqrt(len);out[0]=
x*len;out[1]=y*len;out[2]=z*len;out[3]=w*len;return out}function dot$3(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3]}function cross$1(out,u,v,w){var A=v[0]*w[1]-v[1]*w[0],B=v[0]*w[2]-v[2]*w[0],C=v[0]*w[3]-v[3]*w[0],D=v[1]*w[2]-v[2]*w[1],E=v[1]*w[3]-v[3]*w[1],F=v[2]*w[3]-v[3]*w[2];var G=u[0];var H=u[1];var I=u[2];var J=u[3];out[0]=H*F-I*E+J*D;out[1]=-(G*F)+I*C-J*B;out[2]=G*E-H*C+J*A;out[3]=-(G*D)+H*B-I*A;return out}function lerp$3(out,a,b,t){var ax=a[0];var ay=a[1];var az=a[2];var aw=a[3];out[0]=
ax+t*(b[0]-ax);out[1]=ay+t*(b[1]-ay);out[2]=az+t*(b[2]-az);out[3]=aw+t*(b[3]-aw);return out}function random$2(out,scale){scale=scale||1;var v1,v2,v3,v4;var s1,s2;do{v1=RANDOM()*2-1;v2=RANDOM()*2-1;s1=v1*v1+v2*v2}while(s1>=1);do{v3=RANDOM()*2-1;v4=RANDOM()*2-1;s2=v3*v3+v4*v4}while(s2>=1);var d=Math.sqrt((1-s1)/s2);out[0]=scale*v1;out[1]=scale*v2;out[2]=scale*v3*d;out[3]=scale*v4*d;return out}function transformMat4$1(out,a,m){var x=a[0],y=a[1],z=a[2],w=a[3];out[0]=m[0]*x+m[4]*y+m[8]*z+m[12]*w;out[1]=
m[1]*x+m[5]*y+m[9]*z+m[13]*w;out[2]=m[2]*x+m[6]*y+m[10]*z+m[14]*w;out[3]=m[3]*x+m[7]*y+m[11]*z+m[15]*w;return out}function transformQuat(out,a,q){var x=a[0],y=a[1],z=a[2];var qx=q[0],qy=q[1],qz=q[2],qw=q[3];var ix=qw*x+qy*z-qz*y;var iy=qw*y+qz*x-qx*z;var iz=qw*z+qx*y-qy*x;var iw=-qx*x-qy*y-qz*z;out[0]=ix*qw+iw*-qx+iy*-qz-iz*-qy;out[1]=iy*qw+iw*-qy+iz*-qx-ix*-qz;out[2]=iz*qw+iw*-qz+ix*-qy-iy*-qx;out[3]=a[3];return out}function zero$1(out){out[0]=0;out[1]=0;out[2]=0;out[3]=0;return out}function str$3(a){return"vec4("+
a[0]+", "+a[1]+", "+a[2]+", "+a[3]+")"}function exactEquals$3(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]}function equals$3(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))}var sub$1=subtract$1;
var mul$3=multiply$3;var div$1=divide$1;var dist$1=distance$1;var sqrDist$1=squaredDistance$1;var len$3=length$3;var sqrLen$3=squaredLength$3;var forEach$1=function(){var vec=create$3();return function(a,stride,offset,count,fn,arg){var i,l;if(!stride)stride=4;if(!offset)offset=0;if(count)l=Math.min(count*stride+offset,a.length);else l=a.length;for(i=offset;i<l;i+=stride){vec[0]=a[i];vec[1]=a[i+1];vec[2]=a[i+2];vec[3]=a[i+3];fn(vec,vec,arg);a[i]=vec[0];a[i+1]=vec[1];a[i+2]=vec[2];a[i+3]=vec[3]}return a}}();
var vec4=Object.freeze({__proto__:null,create:create$3,clone:clone$3,fromValues:fromValues$3,copy:copy$3,set:set$3,add:add$3,subtract:subtract$1,multiply:multiply$3,divide:divide$1,ceil:ceil$1,floor:floor$1,min:min$1,max:max$1,round:round$1,scale:scale$3,scaleAndAdd:scaleAndAdd$1,distance:distance$1,squaredDistance:squaredDistance$1,length:length$3,squaredLength:squaredLength$3,negate:negate$1,inverse:inverse$1,normalize:normalize$3,dot:dot$3,cross:cross$1,lerp:lerp$3,random:random$2,transformMat4:transformMat4$1,
transformQuat:transformQuat,zero:zero$1,str:str$3,exactEquals:exactEquals$3,equals:equals$3,sub:sub$1,mul:mul$3,div:div$1,dist:dist$1,sqrDist:sqrDist$1,len:len$3,sqrLen:sqrLen$3,forEach:forEach$1});function create$2(){var out=new ARRAY_TYPE(4);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0;out[2]=0}out[3]=1;return out}function identity$1(out){out[0]=0;out[1]=0;out[2]=0;out[3]=1;return out}function setAxisAngle(out,axis,rad){rad=rad*.5;var s=Math.sin(rad);out[0]=s*axis[0];out[1]=s*axis[1];out[2]=s*
axis[2];out[3]=Math.cos(rad);return out}function getAxisAngle(out_axis,q){var rad=Math.acos(q[3])*2;var s=Math.sin(rad/2);if(s>EPSILON){out_axis[0]=q[0]/s;out_axis[1]=q[1]/s;out_axis[2]=q[2]/s}else{out_axis[0]=1;out_axis[1]=0;out_axis[2]=0}return rad}function getAngle(a,b){var dotproduct=dot$2(a,b);return Math.acos(2*dotproduct*dotproduct-1)}function multiply$2(out,a,b){var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bx=b[0],by=b[1],bz=b[2],bw=b[3];out[0]=ax*bw+aw*bx+ay*bz-az*by;out[1]=ay*bw+aw*by+az*bx-
ax*bz;out[2]=az*bw+aw*bz+ax*by-ay*bx;out[3]=aw*bw-ax*bx-ay*by-az*bz;return out}function rotateX$1(out,a,rad){rad*=.5;var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bx=Math.sin(rad),bw=Math.cos(rad);out[0]=ax*bw+aw*bx;out[1]=ay*bw+az*bx;out[2]=az*bw-ay*bx;out[3]=aw*bw-ax*bx;return out}function rotateY$1(out,a,rad){rad*=.5;var ax=a[0],ay=a[1],az=a[2],aw=a[3];var by=Math.sin(rad),bw=Math.cos(rad);out[0]=ax*bw-az*by;out[1]=ay*bw+aw*by;out[2]=az*bw+ax*by;out[3]=aw*bw-ay*by;return out}function rotateZ$1(out,a,
rad){rad*=.5;var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bz=Math.sin(rad),bw=Math.cos(rad);out[0]=ax*bw+ay*bz;out[1]=ay*bw-ax*bz;out[2]=az*bw+aw*bz;out[3]=aw*bw-az*bz;return out}function calculateW(out,a){var x=a[0],y=a[1],z=a[2];out[0]=x;out[1]=y;out[2]=z;out[3]=Math.sqrt(Math.abs(1-x*x-y*y-z*z));return out}function exp(out,a){var x=a[0],y=a[1],z=a[2],w=a[3];var r=Math.sqrt(x*x+y*y+z*z);var et=Math.exp(w);var s=r>0?et*Math.sin(r)/r:0;out[0]=x*s;out[1]=y*s;out[2]=z*s;out[3]=et*Math.cos(r);return out}
function ln(out,a){var x=a[0],y=a[1],z=a[2],w=a[3];var r=Math.sqrt(x*x+y*y+z*z);var t=r>0?Math.atan2(r,w)/r:0;out[0]=x*t;out[1]=y*t;out[2]=z*t;out[3]=.5*Math.log(x*x+y*y+z*z+w*w);return out}function pow(out,a,b){ln(out,a);scale$2(out,out,b);exp(out,out);return out}function slerp(out,a,b,t){var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bx=b[0],by=b[1],bz=b[2],bw=b[3];var omega,cosom,sinom,scale0,scale1;cosom=ax*bx+ay*by+az*bz+aw*bw;if(cosom<0){cosom=-cosom;bx=-bx;by=-by;bz=-bz;bw=-bw}if(1-cosom>EPSILON){omega=
Math.acos(cosom);sinom=Math.sin(omega);scale0=Math.sin((1-t)*omega)/sinom;scale1=Math.sin(t*omega)/sinom}else{scale0=1-t;scale1=t}out[0]=scale0*ax+scale1*bx;out[1]=scale0*ay+scale1*by;out[2]=scale0*az+scale1*bz;out[3]=scale0*aw+scale1*bw;return out}function random$1(out){var u1=RANDOM();var u2=RANDOM();var u3=RANDOM();var sqrt1MinusU1=Math.sqrt(1-u1);var sqrtU1=Math.sqrt(u1);out[0]=sqrt1MinusU1*Math.sin(2*Math.PI*u2);out[1]=sqrt1MinusU1*Math.cos(2*Math.PI*u2);out[2]=sqrtU1*Math.sin(2*Math.PI*u3);
out[3]=sqrtU1*Math.cos(2*Math.PI*u3);return out}function invert$1(out,a){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var dot=a0*a0+a1*a1+a2*a2+a3*a3;var invDot=dot?1/dot:0;out[0]=-a0*invDot;out[1]=-a1*invDot;out[2]=-a2*invDot;out[3]=a3*invDot;return out}function conjugate$1(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=-a[2];out[3]=a[3];return out}function fromMat3(out,m){var fTrace=m[0]+m[4]+m[8];var fRoot;if(fTrace>0){fRoot=Math.sqrt(fTrace+1);out[3]=.5*fRoot;fRoot=.5/fRoot;out[0]=(m[5]-m[7])*fRoot;out[1]=(m[6]-
m[2])*fRoot;out[2]=(m[1]-m[3])*fRoot}else{var i=0;if(m[4]>m[0])i=1;if(m[8]>m[i*3+i])i=2;var j=(i+1)%3;var k=(i+2)%3;fRoot=Math.sqrt(m[i*3+i]-m[j*3+j]-m[k*3+k]+1);out[i]=.5*fRoot;fRoot=.5/fRoot;out[3]=(m[j*3+k]-m[k*3+j])*fRoot;out[j]=(m[j*3+i]+m[i*3+j])*fRoot;out[k]=(m[k*3+i]+m[i*3+k])*fRoot}return out}function fromEuler(out,x,y,z){var order=arguments.length>4&&arguments[4]!==undefined?arguments[4]:ANGLE_ORDER;var halfToRad=Math.PI/360;x*=halfToRad;z*=halfToRad;y*=halfToRad;var sx=Math.sin(x);var cx=
Math.cos(x);var sy=Math.sin(y);var cy=Math.cos(y);var sz=Math.sin(z);var cz=Math.cos(z);switch(order){case "xyz":out[0]=sx*cy*cz+cx*sy*sz;out[1]=cx*sy*cz-sx*cy*sz;out[2]=cx*cy*sz+sx*sy*cz;out[3]=cx*cy*cz-sx*sy*sz;break;case "xzy":out[0]=sx*cy*cz-cx*sy*sz;out[1]=cx*sy*cz-sx*cy*sz;out[2]=cx*cy*sz+sx*sy*cz;out[3]=cx*cy*cz+sx*sy*sz;break;case "yxz":out[0]=sx*cy*cz+cx*sy*sz;out[1]=cx*sy*cz-sx*cy*sz;out[2]=cx*cy*sz-sx*sy*cz;out[3]=cx*cy*cz+sx*sy*sz;break;case "yzx":out[0]=sx*cy*cz+cx*sy*sz;out[1]=cx*sy*
cz+sx*cy*sz;out[2]=cx*cy*sz-sx*sy*cz;out[3]=cx*cy*cz-sx*sy*sz;break;case "zxy":out[0]=sx*cy*cz-cx*sy*sz;out[1]=cx*sy*cz+sx*cy*sz;out[2]=cx*cy*sz+sx*sy*cz;out[3]=cx*cy*cz-sx*sy*sz;break;case "zyx":out[0]=sx*cy*cz-cx*sy*sz;out[1]=cx*sy*cz+sx*cy*sz;out[2]=cx*cy*sz-sx*sy*cz;out[3]=cx*cy*cz+sx*sy*sz;break;default:throw new Error("Unknown angle order "+order);}return out}function str$2(a){return"quat("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+")"}var clone$2=clone$3;var fromValues$2=fromValues$3;var copy$2=copy$3;
var set$2=set$3;var add$2=add$3;var mul$2=multiply$2;var scale$2=scale$3;var dot$2=dot$3;var lerp$2=lerp$3;var length$2=length$3;var len$2=length$2;var squaredLength$2=squaredLength$3;var sqrLen$2=squaredLength$2;var normalize$2=normalize$3;var exactEquals$2=exactEquals$3;function equals$2(a,b){return Math.abs(dot$3(a,b))>=1-EPSILON}var rotationTo=function(){var tmpvec3=create$4();var xUnitVec3=fromValues$4(1,0,0);var yUnitVec3=fromValues$4(0,1,0);return function(out,a,b){var dot=dot$4(a,b);if(dot<
-.999999){cross$2(tmpvec3,xUnitVec3,a);if(len$4(tmpvec3)<1E-6)cross$2(tmpvec3,yUnitVec3,a);normalize$4(tmpvec3,tmpvec3);setAxisAngle(out,tmpvec3,Math.PI);return out}else if(dot>.999999){out[0]=0;out[1]=0;out[2]=0;out[3]=1;return out}else{cross$2(tmpvec3,a,b);out[0]=tmpvec3[0];out[1]=tmpvec3[1];out[2]=tmpvec3[2];out[3]=1+dot;return normalize$2(out,out)}}}();var sqlerp=function(){var temp1=create$2();var temp2=create$2();return function(out,a,b,c,d,t){slerp(temp1,a,d,t);slerp(temp2,b,c,t);slerp(out,
temp1,temp2,2*t*(1-t));return out}}();var setAxes=function(){var matr=create$6();return function(out,view,right,up){matr[0]=right[0];matr[3]=right[1];matr[6]=right[2];matr[1]=up[0];matr[4]=up[1];matr[7]=up[2];matr[2]=-view[0];matr[5]=-view[1];matr[8]=-view[2];return normalize$2(out,fromMat3(out,matr))}}();var quat=Object.freeze({__proto__:null,create:create$2,identity:identity$1,setAxisAngle:setAxisAngle,getAxisAngle:getAxisAngle,getAngle:getAngle,multiply:multiply$2,rotateX:rotateX$1,rotateY:rotateY$1,
rotateZ:rotateZ$1,calculateW:calculateW,exp:exp,ln:ln,pow:pow,slerp:slerp,random:random$1,invert:invert$1,conjugate:conjugate$1,fromMat3:fromMat3,fromEuler:fromEuler,str:str$2,clone:clone$2,fromValues:fromValues$2,copy:copy$2,set:set$2,add:add$2,mul:mul$2,scale:scale$2,dot:dot$2,lerp:lerp$2,length:length$2,len:len$2,squaredLength:squaredLength$2,sqrLen:sqrLen$2,normalize:normalize$2,exactEquals:exactEquals$2,equals:equals$2,rotationTo:rotationTo,sqlerp:sqlerp,setAxes:setAxes});function create$1(){var dq=
new ARRAY_TYPE(8);if(ARRAY_TYPE!=Float32Array){dq[0]=0;dq[1]=0;dq[2]=0;dq[4]=0;dq[5]=0;dq[6]=0;dq[7]=0}dq[3]=1;return dq}function clone$1(a){var dq=new ARRAY_TYPE(8);dq[0]=a[0];dq[1]=a[1];dq[2]=a[2];dq[3]=a[3];dq[4]=a[4];dq[5]=a[5];dq[6]=a[6];dq[7]=a[7];return dq}function fromValues$1(x1,y1,z1,w1,x2,y2,z2,w2){var dq=new ARRAY_TYPE(8);dq[0]=x1;dq[1]=y1;dq[2]=z1;dq[3]=w1;dq[4]=x2;dq[5]=y2;dq[6]=z2;dq[7]=w2;return dq}function fromRotationTranslationValues(x1,y1,z1,w1,x2,y2,z2){var dq=new ARRAY_TYPE(8);
dq[0]=x1;dq[1]=y1;dq[2]=z1;dq[3]=w1;var ax=x2*.5,ay=y2*.5,az=z2*.5;dq[4]=ax*w1+ay*z1-az*y1;dq[5]=ay*w1+az*x1-ax*z1;dq[6]=az*w1+ax*y1-ay*x1;dq[7]=-ax*x1-ay*y1-az*z1;return dq}function fromRotationTranslation(out,q,t){var ax=t[0]*.5,ay=t[1]*.5,az=t[2]*.5,bx=q[0],by=q[1],bz=q[2],bw=q[3];out[0]=bx;out[1]=by;out[2]=bz;out[3]=bw;out[4]=ax*bw+ay*bz-az*by;out[5]=ay*bw+az*bx-ax*bz;out[6]=az*bw+ax*by-ay*bx;out[7]=-ax*bx-ay*by-az*bz;return out}function fromTranslation(out,t){out[0]=0;out[1]=0;out[2]=0;out[3]=
1;out[4]=t[0]*.5;out[5]=t[1]*.5;out[6]=t[2]*.5;out[7]=0;return out}function fromRotation(out,q){out[0]=q[0];out[1]=q[1];out[2]=q[2];out[3]=q[3];out[4]=0;out[5]=0;out[6]=0;out[7]=0;return out}function fromMat4(out,a){var outer=create$2();getRotation(outer,a);var t=new ARRAY_TYPE(3);getTranslation$1(t,a);fromRotationTranslation(out,outer,t);return out}function copy$1(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];return out}function identity(out){out[0]=
0;out[1]=0;out[2]=0;out[3]=1;out[4]=0;out[5]=0;out[6]=0;out[7]=0;return out}function set$1(out,x1,y1,z1,w1,x2,y2,z2,w2){out[0]=x1;out[1]=y1;out[2]=z1;out[3]=w1;out[4]=x2;out[5]=y2;out[6]=z2;out[7]=w2;return out}var getReal=copy$2;function getDual(out,a){out[0]=a[4];out[1]=a[5];out[2]=a[6];out[3]=a[7];return out}var setReal=copy$2;function setDual(out,q){out[4]=q[0];out[5]=q[1];out[6]=q[2];out[7]=q[3];return out}function getTranslation(out,a){var ax=a[4],ay=a[5],az=a[6],aw=a[7],bx=-a[0],by=-a[1],bz=
-a[2],bw=a[3];out[0]=(ax*bw+aw*bx+ay*bz-az*by)*2;out[1]=(ay*bw+aw*by+az*bx-ax*bz)*2;out[2]=(az*bw+aw*bz+ax*by-ay*bx)*2;return out}function translate(out,a,v){var ax1=a[0],ay1=a[1],az1=a[2],aw1=a[3],bx1=v[0]*.5,by1=v[1]*.5,bz1=v[2]*.5,ax2=a[4],ay2=a[5],az2=a[6],aw2=a[7];out[0]=ax1;out[1]=ay1;out[2]=az1;out[3]=aw1;out[4]=aw1*bx1+ay1*bz1-az1*by1+ax2;out[5]=aw1*by1+az1*bx1-ax1*bz1+ay2;out[6]=aw1*bz1+ax1*by1-ay1*bx1+az2;out[7]=-ax1*bx1-ay1*by1-az1*bz1+aw2;return out}function rotateX(out,a,rad){var bx=
-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7],ax1=ax*bw+aw*bx+ay*bz-az*by,ay1=ay*bw+aw*by+az*bx-ax*bz,az1=az*bw+aw*bz+ax*by-ay*bx,aw1=aw*bw-ax*bx-ay*by-az*bz;rotateX$1(out,a,rad);bx=out[0];by=out[1];bz=out[2];bw=out[3];out[4]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[5]=ay1*bw+aw1*by+az1*bx-ax1*bz;out[6]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[7]=aw1*bw-ax1*bx-ay1*by-az1*bz;return out}function rotateY(out,a,rad){var bx=-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7],ax1=ax*bw+aw*bx+
ay*bz-az*by,ay1=ay*bw+aw*by+az*bx-ax*bz,az1=az*bw+aw*bz+ax*by-ay*bx,aw1=aw*bw-ax*bx-ay*by-az*bz;rotateY$1(out,a,rad);bx=out[0];by=out[1];bz=out[2];bw=out[3];out[4]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[5]=ay1*bw+aw1*by+az1*bx-ax1*bz;out[6]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[7]=aw1*bw-ax1*bx-ay1*by-az1*bz;return out}function rotateZ(out,a,rad){var bx=-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7],ax1=ax*bw+aw*bx+ay*bz-az*by,ay1=ay*bw+aw*by+az*bx-ax*bz,az1=az*bw+aw*bz+ax*by-ay*bx,aw1=aw*bw-
ax*bx-ay*by-az*bz;rotateZ$1(out,a,rad);bx=out[0];by=out[1];bz=out[2];bw=out[3];out[4]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[5]=ay1*bw+aw1*by+az1*bx-ax1*bz;out[6]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[7]=aw1*bw-ax1*bx-ay1*by-az1*bz;return out}function rotateByQuatAppend(out,a,q){var qx=q[0],qy=q[1],qz=q[2],qw=q[3],ax=a[0],ay=a[1],az=a[2],aw=a[3];out[0]=ax*qw+aw*qx+ay*qz-az*qy;out[1]=ay*qw+aw*qy+az*qx-ax*qz;out[2]=az*qw+aw*qz+ax*qy-ay*qx;out[3]=aw*qw-ax*qx-ay*qy-az*qz;ax=a[4];ay=a[5];az=a[6];aw=a[7];out[4]=ax*
qw+aw*qx+ay*qz-az*qy;out[5]=ay*qw+aw*qy+az*qx-ax*qz;out[6]=az*qw+aw*qz+ax*qy-ay*qx;out[7]=aw*qw-ax*qx-ay*qy-az*qz;return out}function rotateByQuatPrepend(out,q,a){var qx=q[0],qy=q[1],qz=q[2],qw=q[3],bx=a[0],by=a[1],bz=a[2],bw=a[3];out[0]=qx*bw+qw*bx+qy*bz-qz*by;out[1]=qy*bw+qw*by+qz*bx-qx*bz;out[2]=qz*bw+qw*bz+qx*by-qy*bx;out[3]=qw*bw-qx*bx-qy*by-qz*bz;bx=a[4];by=a[5];bz=a[6];bw=a[7];out[4]=qx*bw+qw*bx+qy*bz-qz*by;out[5]=qy*bw+qw*by+qz*bx-qx*bz;out[6]=qz*bw+qw*bz+qx*by-qy*bx;out[7]=qw*bw-qx*bx-qy*
by-qz*bz;return out}function rotateAroundAxis(out,a,axis,rad){if(Math.abs(rad)<EPSILON)return copy$1(out,a);var axisLength=Math.hypot(axis[0],axis[1],axis[2]);rad=rad*.5;var s=Math.sin(rad);var bx=s*axis[0]/axisLength;var by=s*axis[1]/axisLength;var bz=s*axis[2]/axisLength;var bw=Math.cos(rad);var ax1=a[0],ay1=a[1],az1=a[2],aw1=a[3];out[0]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[1]=ay1*bw+aw1*by+az1*bx-ax1*bz;out[2]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[3]=aw1*bw-ax1*bx-ay1*by-az1*bz;var ax=a[4],ay=a[5],az=a[6],
aw=a[7];out[4]=ax*bw+aw*bx+ay*bz-az*by;out[5]=ay*bw+aw*by+az*bx-ax*bz;out[6]=az*bw+aw*bz+ax*by-ay*bx;out[7]=aw*bw-ax*bx-ay*by-az*bz;return out}function add$1(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];out[6]=a[6]+b[6];out[7]=a[7]+b[7];return out}function multiply$1(out,a,b){var ax0=a[0],ay0=a[1],az0=a[2],aw0=a[3],bx1=b[4],by1=b[5],bz1=b[6],bw1=b[7],ax1=a[4],ay1=a[5],az1=a[6],aw1=a[7],bx0=b[0],by0=b[1],bz0=b[2],bw0=b[3];out[0]=ax0*
bw0+aw0*bx0+ay0*bz0-az0*by0;out[1]=ay0*bw0+aw0*by0+az0*bx0-ax0*bz0;out[2]=az0*bw0+aw0*bz0+ax0*by0-ay0*bx0;out[3]=aw0*bw0-ax0*bx0-ay0*by0-az0*bz0;out[4]=ax0*bw1+aw0*bx1+ay0*bz1-az0*by1+ax1*bw0+aw1*bx0+ay1*bz0-az1*by0;out[5]=ay0*bw1+aw0*by1+az0*bx1-ax0*bz1+ay1*bw0+aw1*by0+az1*bx0-ax1*bz0;out[6]=az0*bw1+aw0*bz1+ax0*by1-ay0*bx1+az1*bw0+aw1*bz0+ax1*by0-ay1*bx0;out[7]=aw0*bw1-ax0*bx1-ay0*by1-az0*bz1+aw1*bw0-ax1*bx0-ay1*by0-az1*bz0;return out}var mul$1=multiply$1;function scale$1(out,a,b){out[0]=a[0]*b;
out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;out[4]=a[4]*b;out[5]=a[5]*b;out[6]=a[6]*b;out[7]=a[7]*b;return out}var dot$1=dot$2;function lerp$1(out,a,b,t){var mt=1-t;if(dot$1(a,b)<0)t=-t;out[0]=a[0]*mt+b[0]*t;out[1]=a[1]*mt+b[1]*t;out[2]=a[2]*mt+b[2]*t;out[3]=a[3]*mt+b[3]*t;out[4]=a[4]*mt+b[4]*t;out[5]=a[5]*mt+b[5]*t;out[6]=a[6]*mt+b[6]*t;out[7]=a[7]*mt+b[7]*t;return out}function invert(out,a){var sqlen=squaredLength$1(a);out[0]=-a[0]/sqlen;out[1]=-a[1]/sqlen;out[2]=-a[2]/sqlen;out[3]=a[3]/sqlen;out[4]=
-a[4]/sqlen;out[5]=-a[5]/sqlen;out[6]=-a[6]/sqlen;out[7]=a[7]/sqlen;return out}function conjugate(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=-a[2];out[3]=a[3];out[4]=-a[4];out[5]=-a[5];out[6]=-a[6];out[7]=a[7];return out}var length$1=length$2;var len$1=length$1;var squaredLength$1=squaredLength$2;var sqrLen$1=squaredLength$1;function normalize$1(out,a){var magnitude=squaredLength$1(a);if(magnitude>0){magnitude=Math.sqrt(magnitude);var a0=a[0]/magnitude;var a1=a[1]/magnitude;var a2=a[2]/magnitude;var a3=
a[3]/magnitude;var b0=a[4];var b1=a[5];var b2=a[6];var b3=a[7];var a_dot_b=a0*b0+a1*b1+a2*b2+a3*b3;out[0]=a0;out[1]=a1;out[2]=a2;out[3]=a3;out[4]=(b0-a0*a_dot_b)/magnitude;out[5]=(b1-a1*a_dot_b)/magnitude;out[6]=(b2-a2*a_dot_b)/magnitude;out[7]=(b3-a3*a_dot_b)/magnitude}return out}function str$1(a){return"quat2("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+")"}function exactEquals$1(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===
b[5]&&a[6]===b[6]&&a[7]===b[7]}function equals$1(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5],a6=a[6],a7=a[7];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5],b6=b[6],b7=b[7];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),
Math.abs(b4))&&Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))&&Math.abs(a6-b6)<=EPSILON*Math.max(1,Math.abs(a6),Math.abs(b6))&&Math.abs(a7-b7)<=EPSILON*Math.max(1,Math.abs(a7),Math.abs(b7))}var quat2=Object.freeze({__proto__:null,create:create$1,clone:clone$1,fromValues:fromValues$1,fromRotationTranslationValues:fromRotationTranslationValues,fromRotationTranslation:fromRotationTranslation,fromTranslation:fromTranslation,fromRotation:fromRotation,fromMat4:fromMat4,copy:copy$1,identity:identity,
set:set$1,getReal:getReal,getDual:getDual,setReal:setReal,setDual:setDual,getTranslation:getTranslation,translate:translate,rotateX:rotateX,rotateY:rotateY,rotateZ:rotateZ,rotateByQuatAppend:rotateByQuatAppend,rotateByQuatPrepend:rotateByQuatPrepend,rotateAroundAxis:rotateAroundAxis,add:add$1,multiply:multiply$1,mul:mul$1,scale:scale$1,dot:dot$1,lerp:lerp$1,invert:invert,conjugate:conjugate,length:length$1,len:len$1,squaredLength:squaredLength$1,sqrLen:sqrLen$1,normalize:normalize$1,str:str$1,exactEquals:exactEquals$1,
equals:equals$1});function create(){var out=new ARRAY_TYPE(2);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0}return out}function clone(a){var out=new ARRAY_TYPE(2);out[0]=a[0];out[1]=a[1];return out}function fromValues(x,y){var out=new ARRAY_TYPE(2);out[0]=x;out[1]=y;return out}function copy(out,a){out[0]=a[0];out[1]=a[1];return out}function set(out,x,y){out[0]=x;out[1]=y;return out}function add(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];return out}function subtract(out,a,b){out[0]=a[0]-b[0];out[1]=
a[1]-b[1];return out}function multiply(out,a,b){out[0]=a[0]*b[0];out[1]=a[1]*b[1];return out}function divide(out,a,b){out[0]=a[0]/b[0];out[1]=a[1]/b[1];return out}function ceil(out,a){out[0]=Math.ceil(a[0]);out[1]=Math.ceil(a[1]);return out}function floor(out,a){out[0]=Math.floor(a[0]);out[1]=Math.floor(a[1]);return out}function min(out,a,b){out[0]=Math.min(a[0],b[0]);out[1]=Math.min(a[1],b[1]);return out}function max(out,a,b){out[0]=Math.max(a[0],b[0]);out[1]=Math.max(a[1],b[1]);return out}function round(out,
a){out[0]=Math.round(a[0]);out[1]=Math.round(a[1]);return out}function scale(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;return out}function scaleAndAdd(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;return out}function distance(a,b){var x=b[0]-a[0],y=b[1]-a[1];return Math.hypot(x,y)}function squaredDistance(a,b){var x=b[0]-a[0],y=b[1]-a[1];return x*x+y*y}function length(a){var x=a[0],y=a[1];return Math.hypot(x,y)}function squaredLength(a){var x=a[0],y=a[1];return x*x+y*y}function negate(out,
a){out[0]=-a[0];out[1]=-a[1];return out}function inverse(out,a){out[0]=1/a[0];out[1]=1/a[1];return out}function normalize(out,a){var x=a[0],y=a[1];var len=x*x+y*y;if(len>0)len=1/Math.sqrt(len);out[0]=a[0]*len;out[1]=a[1]*len;return out}function dot(a,b){return a[0]*b[0]+a[1]*b[1]}function cross(out,a,b){var z=a[0]*b[1]-a[1]*b[0];out[0]=out[1]=0;out[2]=z;return out}function lerp(out,a,b,t){var ax=a[0],ay=a[1];out[0]=ax+t*(b[0]-ax);out[1]=ay+t*(b[1]-ay);return out}function random(out,scale){scale=scale||
1;var r=RANDOM()*2*Math.PI;out[0]=Math.cos(r)*scale;out[1]=Math.sin(r)*scale;return out}function transformMat2(out,a,m){var x=a[0],y=a[1];out[0]=m[0]*x+m[2]*y;out[1]=m[1]*x+m[3]*y;return out}function transformMat2d(out,a,m){var x=a[0],y=a[1];out[0]=m[0]*x+m[2]*y+m[4];out[1]=m[1]*x+m[3]*y+m[5];return out}function transformMat3(out,a,m){var x=a[0],y=a[1];out[0]=m[0]*x+m[3]*y+m[6];out[1]=m[1]*x+m[4]*y+m[7];return out}function transformMat4(out,a,m){var x=a[0];var y=a[1];out[0]=m[0]*x+m[4]*y+m[12];out[1]=
m[1]*x+m[5]*y+m[13];return out}function rotate(out,a,b,rad){var p0=a[0]-b[0],p1=a[1]-b[1],sinC=Math.sin(rad),cosC=Math.cos(rad);out[0]=p0*cosC-p1*sinC+b[0];out[1]=p0*sinC+p1*cosC+b[1];return out}function angle(a,b){var x1=a[0],y1=a[1],x2=b[0],y2=b[1],mag=Math.sqrt((x1*x1+y1*y1)*(x2*x2+y2*y2)),cosine=mag&&(x1*x2+y1*y2)/mag;return Math.acos(Math.min(Math.max(cosine,-1),1))}function zero(out){out[0]=0;out[1]=0;return out}function str(a){return"vec2("+a[0]+", "+a[1]+")"}function exactEquals(a,b){return a[0]===
b[0]&&a[1]===b[1]}function equals(a,b){var a0=a[0],a1=a[1];var b0=b[0],b1=b[1];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))}var len=length;var sub=subtract;var mul=multiply;var div=divide;var dist=distance;var sqrDist=squaredDistance;var sqrLen=squaredLength;var forEach=function(){var vec=create();return function(a,stride,offset,count,fn,arg){var i,l;if(!stride)stride=2;if(!offset)offset=0;if(count)l=Math.min(count*
stride+offset,a.length);else l=a.length;for(i=offset;i<l;i+=stride){vec[0]=a[i];vec[1]=a[i+1];fn(vec,vec,arg);a[i]=vec[0];a[i+1]=vec[1]}return a}}();var vec2=Object.freeze({__proto__:null,create:create,clone:clone,fromValues:fromValues,copy:copy,set:set,add:add,subtract:subtract,multiply:multiply,divide:divide,ceil:ceil,floor:floor,min:min,max:max,round:round,scale:scale,scaleAndAdd:scaleAndAdd,distance:distance,squaredDistance:squaredDistance,length:length,squaredLength:squaredLength,negate:negate,
inverse:inverse,normalize:normalize,dot:dot,cross:cross,lerp:lerp,random:random,transformMat2:transformMat2,transformMat2d:transformMat2d,transformMat3:transformMat3,transformMat4:transformMat4,rotate:rotate,angle:angle,zero:zero,str:str,exactEquals:exactEquals,equals:equals,len:len,sub:sub,mul:mul,div:div,dist:dist,sqrDist:sqrDist,sqrLen:sqrLen,forEach:forEach});exports.glMatrix=common;exports.mat2=mat2;exports.mat2d=mat2d;exports.mat3=mat3;exports.mat4=mat4;exports.quat=quat;exports.quat2=quat2;
exports.vec2=vec2;exports.vec3=vec3;exports.vec4=vec4;Object.defineProperty(exports,"__esModule",{value:true})});

}

// ../3rdparty/grapheme-splitter.js
{
function GraphemeSplitter(){function h(a,c){void 0===c&&(c=0);var b=a.charCodeAt(c);if(55296<=b&&56319>=b&&c<a.length-1){var d=b;a=a.charCodeAt(c+1);return 56320<=a&&57343>=a?1024*(d-55296)+(a-56320)+65536:d}return 56320<=b&&57343>=b&&1<=c?(d=a.charCodeAt(c-1),a=b,55296<=d&&56319>=d?1024*(d-55296)+(a-56320)+65536:a):b}function l(a,c,b){var d=[a].concat(c).concat([b]),e=d[d.length-2],g=d.lastIndexOf(14);if(1<g&&d.slice(1,g).every(function(f){return 3==f})&&-1==[3,13,17].indexOf(a))return 2;a=d.lastIndexOf(4);
if(0<a&&d.slice(1,a).every(function(f){return 4==f})&&-1==[12,4].indexOf(e))return 1==d.filter(function(f){return 4==f}).length%2?3:4;if(0==e&&1==b)return 0;if(2==e||0==e||1==e)return 14==b&&c.every(function(f){return 3==f})?2:1;if(2==b||0==b||1==b)return 1;if(6!=e||6!=b&&7!=b&&9!=b&&10!=b)if(9!=e&&7!=e||7!=b&&8!=b)if(10!=e&&8!=e||8!=b){if(3==b||15==b||5==b||12==e)return 0}else return 0;else return 0;else return 0;a=-1!=d.indexOf(3)?d.lastIndexOf(3)-1:d.length-2;return-1!=[13,17].indexOf(d[a])&&d.slice(a+
1,-1).every(function(f){return 3==f})&&14==b||15==e&&-1!=[16,17].indexOf(b)?0:-1!=c.indexOf(4)?2:4==e&&4==b?0:1}function k(a){return 1536<=a&&1541>=a||1757==a||1807==a||2274==a||3406==a||69821==a||70082<=a&&70083>=a||72250==a||72326<=a&&72329>=a||73030==a?12:13==a?0:10==a?1:0<=a&&9>=a||11<=a&&12>=a||14<=a&&31>=a||127<=a&&159>=a||173==a||1564==a||6158==a||8203==a||8206<=a&&8207>=a||8232==a||8233==a||8234<=a&&8238>=a||8288<=a&&8292>=a||8293==a||8294<=a&&8303>=a||55296<=a&&57343>=a||65279==a||65520<=
a&&65528>=a||65529<=a&&65531>=a||113824<=a&&113827>=a||119155<=a&&119162>=a||917504==a||917505==a||917506<=a&&917535>=a||917632<=a&&917759>=a||918E3<=a&&921599>=a?2:768<=a&&879>=a||1155<=a&&1159>=a||1160<=a&&1161>=a||1425<=a&&1469>=a||1471==a||1473<=a&&1474>=a||1476<=a&&1477>=a||1479==a||1552<=a&&1562>=a||1611<=a&&1631>=a||1648==a||1750<=a&&1756>=a||1759<=a&&1764>=a||1767<=a&&1768>=a||1770<=a&&1773>=a||1809==a||1840<=a&&1866>=a||1958<=a&&1968>=a||2027<=a&&2035>=a||2070<=a&&2073>=a||2075<=a&&2083>=
a||2085<=a&&2087>=a||2089<=a&&2093>=a||2137<=a&&2139>=a||2260<=a&&2273>=a||2275<=a&&2306>=a||2362==a||2364==a||2369<=a&&2376>=a||2381==a||2385<=a&&2391>=a||2402<=a&&2403>=a||2433==a||2492==a||2494==a||2497<=a&&2500>=a||2509==a||2519==a||2530<=a&&2531>=a||2561<=a&&2562>=a||2620==a||2625<=a&&2626>=a||2631<=a&&2632>=a||2635<=a&&2637>=a||2641==a||2672<=a&&2673>=a||2677==a||2689<=a&&2690>=a||2748==a||2753<=a&&2757>=a||2759<=a&&2760>=a||2765==a||2786<=a&&2787>=a||2810<=a&&2815>=a||2817==a||2876==a||2878==
a||2879==a||2881<=a&&2884>=a||2893==a||2902==a||2903==a||2914<=a&&2915>=a||2946==a||3006==a||3008==a||3021==a||3031==a||3072==a||3134<=a&&3136>=a||3142<=a&&3144>=a||3146<=a&&3149>=a||3157<=a&&3158>=a||3170<=a&&3171>=a||3201==a||3260==a||3263==a||3266==a||3270==a||3276<=a&&3277>=a||3285<=a&&3286>=a||3298<=a&&3299>=a||3328<=a&&3329>=a||3387<=a&&3388>=a||3390==a||3393<=a&&3396>=a||3405==a||3415==a||3426<=a&&3427>=a||3530==a||3535==a||3538<=a&&3540>=a||3542==a||3551==a||3633==a||3636<=a&&3642>=a||3655<=
a&&3662>=a||3761==a||3764<=a&&3769>=a||3771<=a&&3772>=a||3784<=a&&3789>=a||3864<=a&&3865>=a||3893==a||3895==a||3897==a||3953<=a&&3966>=a||3968<=a&&3972>=a||3974<=a&&3975>=a||3981<=a&&3991>=a||3993<=a&&4028>=a||4038==a||4141<=a&&4144>=a||4146<=a&&4151>=a||4153<=a&&4154>=a||4157<=a&&4158>=a||4184<=a&&4185>=a||4190<=a&&4192>=a||4209<=a&&4212>=a||4226==a||4229<=a&&4230>=a||4237==a||4253==a||4957<=a&&4959>=a||5906<=a&&5908>=a||5938<=a&&5940>=a||5970<=a&&5971>=a||6002<=a&&6003>=a||6068<=a&&6069>=a||6071<=
a&&6077>=a||6086==a||6089<=a&&6099>=a||6109==a||6155<=a&&6157>=a||6277<=a&&6278>=a||6313==a||6432<=a&&6434>=a||6439<=a&&6440>=a||6450==a||6457<=a&&6459>=a||6679<=a&&6680>=a||6683==a||6742==a||6744<=a&&6750>=a||6752==a||6754==a||6757<=a&&6764>=a||6771<=a&&6780>=a||6783==a||6832<=a&&6845>=a||6846==a||6912<=a&&6915>=a||6964==a||6966<=a&&6970>=a||6972==a||6978==a||7019<=a&&7027>=a||7040<=a&&7041>=a||7074<=a&&7077>=a||7080<=a&&7081>=a||7083<=a&&7085>=a||7142==a||7144<=a&&7145>=a||7149==a||7151<=a&&7153>=
a||7212<=a&&7219>=a||7222<=a&&7223>=a||7376<=a&&7378>=a||7380<=a&&7392>=a||7394<=a&&7400>=a||7405==a||7412==a||7416<=a&&7417>=a||7616<=a&&7673>=a||7675<=a&&7679>=a||8204==a||8400<=a&&8412>=a||8413<=a&&8416>=a||8417==a||8418<=a&&8420>=a||8421<=a&&8432>=a||11503<=a&&11505>=a||11647==a||11744<=a&&11775>=a||12330<=a&&12333>=a||12334<=a&&12335>=a||12441<=a&&12442>=a||42607==a||42608<=a&&42610>=a||42612<=a&&42621>=a||42654<=a&&42655>=a||42736<=a&&42737>=a||43010==a||43014==a||43019==a||43045<=a&&43046>=
a||43204<=a&&43205>=a||43232<=a&&43249>=a||43302<=a&&43309>=a||43335<=a&&43345>=a||43392<=a&&43394>=a||43443==a||43446<=a&&43449>=a||43452==a||43493==a||43561<=a&&43566>=a||43569<=a&&43570>=a||43573<=a&&43574>=a||43587==a||43596==a||43644==a||43696==a||43698<=a&&43700>=a||43703<=a&&43704>=a||43710<=a&&43711>=a||43713==a||43756<=a&&43757>=a||43766==a||44005==a||44008==a||44013==a||64286==a||65024<=a&&65039>=a||65056<=a&&65071>=a||65438<=a&&65439>=a||66045==a||66272==a||66422<=a&&66426>=a||68097<=a&&
68099>=a||68101<=a&&68102>=a||68108<=a&&68111>=a||68152<=a&&68154>=a||68159==a||68325<=a&&68326>=a||69633==a||69688<=a&&69702>=a||69759<=a&&69761>=a||69811<=a&&69814>=a||69817<=a&&69818>=a||69888<=a&&69890>=a||69927<=a&&69931>=a||69933<=a&&69940>=a||70003==a||70016<=a&&70017>=a||70070<=a&&70078>=a||70090<=a&&70092>=a||70191<=a&&70193>=a||70196==a||70198<=a&&70199>=a||70206==a||70367==a||70371<=a&&70378>=a||70400<=a&&70401>=a||70460==a||70462==a||70464==a||70487==a||70502<=a&&70508>=a||70512<=a&&70516>=
a||70712<=a&&70719>=a||70722<=a&&70724>=a||70726==a||70832==a||70835<=a&&70840>=a||70842==a||70845==a||70847<=a&&70848>=a||70850<=a&&70851>=a||71087==a||71090<=a&&71093>=a||71100<=a&&71101>=a||71103<=a&&71104>=a||71132<=a&&71133>=a||71219<=a&&71226>=a||71229==a||71231<=a&&71232>=a||71339==a||71341==a||71344<=a&&71349>=a||71351==a||71453<=a&&71455>=a||71458<=a&&71461>=a||71463<=a&&71467>=a||72193<=a&&72198>=a||72201<=a&&72202>=a||72243<=a&&72248>=a||72251<=a&&72254>=a||72263==a||72273<=a&&72278>=a||
72281<=a&&72283>=a||72330<=a&&72342>=a||72344<=a&&72345>=a||72752<=a&&72758>=a||72760<=a&&72765>=a||72767==a||72850<=a&&72871>=a||72874<=a&&72880>=a||72882<=a&&72883>=a||72885<=a&&72886>=a||73009<=a&&73014>=a||73018==a||73020<=a&&73021>=a||73023<=a&&73029>=a||73031==a||92912<=a&&92916>=a||92976<=a&&92982>=a||94095<=a&&94098>=a||113821<=a&&113822>=a||119141==a||119143<=a&&119145>=a||119150<=a&&119154>=a||119163<=a&&119170>=a||119173<=a&&119179>=a||119210<=a&&119213>=a||119362<=a&&119364>=a||121344<=
a&&121398>=a||121403<=a&&121452>=a||121461==a||121476==a||121499<=a&&121503>=a||121505<=a&&121519>=a||122880<=a&&122886>=a||122888<=a&&122904>=a||122907<=a&&122913>=a||122915<=a&&122916>=a||122918<=a&&122922>=a||125136<=a&&125142>=a||125252<=a&&125258>=a||917536<=a&&917631>=a||917760<=a&&917999>=a?3:127462<=a&&127487>=a?4:2307==a||2363==a||2366<=a&&2368>=a||2377<=a&&2380>=a||2382<=a&&2383>=a||2434<=a&&2435>=a||2495<=a&&2496>=a||2503<=a&&2504>=a||2507<=a&&2508>=a||2563==a||2622<=a&&2624>=a||2691==
a||2750<=a&&2752>=a||2761==a||2763<=a&&2764>=a||2818<=a&&2819>=a||2880==a||2887<=a&&2888>=a||2891<=a&&2892>=a||3007==a||3009<=a&&3010>=a||3014<=a&&3016>=a||3018<=a&&3020>=a||3073<=a&&3075>=a||3137<=a&&3140>=a||3202<=a&&3203>=a||3262==a||3264<=a&&3265>=a||3267<=a&&3268>=a||3271<=a&&3272>=a||3274<=a&&3275>=a||3330<=a&&3331>=a||3391<=a&&3392>=a||3398<=a&&3400>=a||3402<=a&&3404>=a||3458<=a&&3459>=a||3536<=a&&3537>=a||3544<=a&&3550>=a||3570<=a&&3571>=a||3635==a||3763==a||3902<=a&&3903>=a||3967==a||4145==
a||4155<=a&&4156>=a||4182<=a&&4183>=a||4228==a||6070==a||6078<=a&&6085>=a||6087<=a&&6088>=a||6435<=a&&6438>=a||6441<=a&&6443>=a||6448<=a&&6449>=a||6451<=a&&6456>=a||6681<=a&&6682>=a||6741==a||6743==a||6765<=a&&6770>=a||6916==a||6965==a||6971==a||6973<=a&&6977>=a||6979<=a&&6980>=a||7042==a||7073==a||7078<=a&&7079>=a||7082==a||7143==a||7146<=a&&7148>=a||7150==a||7154<=a&&7155>=a||7204<=a&&7211>=a||7220<=a&&7221>=a||7393==a||7410<=a&&7411>=a||7415==a||43043<=a&&43044>=a||43047==a||43136<=a&&43137>=a||
43188<=a&&43203>=a||43346<=a&&43347>=a||43395==a||43444<=a&&43445>=a||43450<=a&&43451>=a||43453<=a&&43456>=a||43567<=a&&43568>=a||43571<=a&&43572>=a||43597==a||43755==a||43758<=a&&43759>=a||43765==a||44003<=a&&44004>=a||44006<=a&&44007>=a||44009<=a&&44010>=a||44012==a||69632==a||69634==a||69762==a||69808<=a&&69810>=a||69815<=a&&69816>=a||69932==a||70018==a||70067<=a&&70069>=a||70079<=a&&70080>=a||70188<=a&&70190>=a||70194<=a&&70195>=a||70197==a||70368<=a&&70370>=a||70402<=a&&70403>=a||70463==a||70465<=
a&&70468>=a||70471<=a&&70472>=a||70475<=a&&70477>=a||70498<=a&&70499>=a||70709<=a&&70711>=a||70720<=a&&70721>=a||70725==a||70833<=a&&70834>=a||70841==a||70843<=a&&70844>=a||70846==a||70849==a||71088<=a&&71089>=a||71096<=a&&71099>=a||71102==a||71216<=a&&71218>=a||71227<=a&&71228>=a||71230==a||71340==a||71342<=a&&71343>=a||71350==a||71456<=a&&71457>=a||71462==a||72199<=a&&72200>=a||72249==a||72279<=a&&72280>=a||72343==a||72751==a||72766==a||72873==a||72881==a||72884==a||94033<=a&&94078>=a||119142==
a||119149==a?5:4352<=a&&4447>=a||43360<=a&&43388>=a?6:4448<=a&&4519>=a||55216<=a&&55238>=a?7:4520<=a&&4607>=a||55243<=a&&55291>=a?8:44032==a||44060==a||44088==a||44116==a||44144==a||44172==a||44200==a||44228==a||44256==a||44284==a||44312==a||44340==a||44368==a||44396==a||44424==a||44452==a||44480==a||44508==a||44536==a||44564==a||44592==a||44620==a||44648==a||44676==a||44704==a||44732==a||44760==a||44788==a||44816==a||44844==a||44872==a||44900==a||44928==a||44956==a||44984==a||45012==a||45040==a||
45068==a||45096==a||45124==a||45152==a||45180==a||45208==a||45236==a||45264==a||45292==a||45320==a||45348==a||45376==a||45404==a||45432==a||45460==a||45488==a||45516==a||45544==a||45572==a||45600==a||45628==a||45656==a||45684==a||45712==a||45740==a||45768==a||45796==a||45824==a||45852==a||45880==a||45908==a||45936==a||45964==a||45992==a||46020==a||46048==a||46076==a||46104==a||46132==a||46160==a||46188==a||46216==a||46244==a||46272==a||46300==a||46328==a||46356==a||46384==a||46412==a||46440==a||46468==
a||46496==a||46524==a||46552==a||46580==a||46608==a||46636==a||46664==a||46692==a||46720==a||46748==a||46776==a||46804==a||46832==a||46860==a||46888==a||46916==a||46944==a||46972==a||47E3==a||47028==a||47056==a||47084==a||47112==a||47140==a||47168==a||47196==a||47224==a||47252==a||47280==a||47308==a||47336==a||47364==a||47392==a||47420==a||47448==a||47476==a||47504==a||47532==a||47560==a||47588==a||47616==a||47644==a||47672==a||47700==a||47728==a||47756==a||47784==a||47812==a||47840==a||47868==a||
47896==a||47924==a||47952==a||47980==a||48008==a||48036==a||48064==a||48092==a||48120==a||48148==a||48176==a||48204==a||48232==a||48260==a||48288==a||48316==a||48344==a||48372==a||48400==a||48428==a||48456==a||48484==a||48512==a||48540==a||48568==a||48596==a||48624==a||48652==a||48680==a||48708==a||48736==a||48764==a||48792==a||48820==a||48848==a||48876==a||48904==a||48932==a||48960==a||48988==a||49016==a||49044==a||49072==a||49100==a||49128==a||49156==a||49184==a||49212==a||49240==a||49268==a||49296==
a||49324==a||49352==a||49380==a||49408==a||49436==a||49464==a||49492==a||49520==a||49548==a||49576==a||49604==a||49632==a||49660==a||49688==a||49716==a||49744==a||49772==a||49800==a||49828==a||49856==a||49884==a||49912==a||49940==a||49968==a||49996==a||50024==a||50052==a||50080==a||50108==a||50136==a||50164==a||50192==a||50220==a||50248==a||50276==a||50304==a||50332==a||50360==a||50388==a||50416==a||50444==a||50472==a||50500==a||50528==a||50556==a||50584==a||50612==a||50640==a||50668==a||50696==a||
50724==a||50752==a||50780==a||50808==a||50836==a||50864==a||50892==a||50920==a||50948==a||50976==a||51004==a||51032==a||51060==a||51088==a||51116==a||51144==a||51172==a||51200==a||51228==a||51256==a||51284==a||51312==a||51340==a||51368==a||51396==a||51424==a||51452==a||51480==a||51508==a||51536==a||51564==a||51592==a||51620==a||51648==a||51676==a||51704==a||51732==a||51760==a||51788==a||51816==a||51844==a||51872==a||51900==a||51928==a||51956==a||51984==a||52012==a||52040==a||52068==a||52096==a||52124==
a||52152==a||52180==a||52208==a||52236==a||52264==a||52292==a||52320==a||52348==a||52376==a||52404==a||52432==a||52460==a||52488==a||52516==a||52544==a||52572==a||52600==a||52628==a||52656==a||52684==a||52712==a||52740==a||52768==a||52796==a||52824==a||52852==a||52880==a||52908==a||52936==a||52964==a||52992==a||53020==a||53048==a||53076==a||53104==a||53132==a||53160==a||53188==a||53216==a||53244==a||53272==a||53300==a||53328==a||53356==a||53384==a||53412==a||53440==a||53468==a||53496==a||53524==a||
53552==a||53580==a||53608==a||53636==a||53664==a||53692==a||53720==a||53748==a||53776==a||53804==a||53832==a||53860==a||53888==a||53916==a||53944==a||53972==a||54E3==a||54028==a||54056==a||54084==a||54112==a||54140==a||54168==a||54196==a||54224==a||54252==a||54280==a||54308==a||54336==a||54364==a||54392==a||54420==a||54448==a||54476==a||54504==a||54532==a||54560==a||54588==a||54616==a||54644==a||54672==a||54700==a||54728==a||54756==a||54784==a||54812==a||54840==a||54868==a||54896==a||54924==a||54952==
a||54980==a||55008==a||55036==a||55064==a||55092==a||55120==a||55148==a||55176==a?9:44033<=a&&44059>=a||44061<=a&&44087>=a||44089<=a&&44115>=a||44117<=a&&44143>=a||44145<=a&&44171>=a||44173<=a&&44199>=a||44201<=a&&44227>=a||44229<=a&&44255>=a||44257<=a&&44283>=a||44285<=a&&44311>=a||44313<=a&&44339>=a||44341<=a&&44367>=a||44369<=a&&44395>=a||44397<=a&&44423>=a||44425<=a&&44451>=a||44453<=a&&44479>=a||44481<=a&&44507>=a||44509<=a&&44535>=a||44537<=a&&44563>=a||44565<=a&&44591>=a||44593<=a&&44619>=
a||44621<=a&&44647>=a||44649<=a&&44675>=a||44677<=a&&44703>=a||44705<=a&&44731>=a||44733<=a&&44759>=a||44761<=a&&44787>=a||44789<=a&&44815>=a||44817<=a&&44843>=a||44845<=a&&44871>=a||44873<=a&&44899>=a||44901<=a&&44927>=a||44929<=a&&44955>=a||44957<=a&&44983>=a||44985<=a&&45011>=a||45013<=a&&45039>=a||45041<=a&&45067>=a||45069<=a&&45095>=a||45097<=a&&45123>=a||45125<=a&&45151>=a||45153<=a&&45179>=a||45181<=a&&45207>=a||45209<=a&&45235>=a||45237<=a&&45263>=a||45265<=a&&45291>=a||45293<=a&&45319>=a||
45321<=a&&45347>=a||45349<=a&&45375>=a||45377<=a&&45403>=a||45405<=a&&45431>=a||45433<=a&&45459>=a||45461<=a&&45487>=a||45489<=a&&45515>=a||45517<=a&&45543>=a||45545<=a&&45571>=a||45573<=a&&45599>=a||45601<=a&&45627>=a||45629<=a&&45655>=a||45657<=a&&45683>=a||45685<=a&&45711>=a||45713<=a&&45739>=a||45741<=a&&45767>=a||45769<=a&&45795>=a||45797<=a&&45823>=a||45825<=a&&45851>=a||45853<=a&&45879>=a||45881<=a&&45907>=a||45909<=a&&45935>=a||45937<=a&&45963>=a||45965<=a&&45991>=a||45993<=a&&46019>=a||46021<=
a&&46047>=a||46049<=a&&46075>=a||46077<=a&&46103>=a||46105<=a&&46131>=a||46133<=a&&46159>=a||46161<=a&&46187>=a||46189<=a&&46215>=a||46217<=a&&46243>=a||46245<=a&&46271>=a||46273<=a&&46299>=a||46301<=a&&46327>=a||46329<=a&&46355>=a||46357<=a&&46383>=a||46385<=a&&46411>=a||46413<=a&&46439>=a||46441<=a&&46467>=a||46469<=a&&46495>=a||46497<=a&&46523>=a||46525<=a&&46551>=a||46553<=a&&46579>=a||46581<=a&&46607>=a||46609<=a&&46635>=a||46637<=a&&46663>=a||46665<=a&&46691>=a||46693<=a&&46719>=a||46721<=a&&
46747>=a||46749<=a&&46775>=a||46777<=a&&46803>=a||46805<=a&&46831>=a||46833<=a&&46859>=a||46861<=a&&46887>=a||46889<=a&&46915>=a||46917<=a&&46943>=a||46945<=a&&46971>=a||46973<=a&&46999>=a||47001<=a&&47027>=a||47029<=a&&47055>=a||47057<=a&&47083>=a||47085<=a&&47111>=a||47113<=a&&47139>=a||47141<=a&&47167>=a||47169<=a&&47195>=a||47197<=a&&47223>=a||47225<=a&&47251>=a||47253<=a&&47279>=a||47281<=a&&47307>=a||47309<=a&&47335>=a||47337<=a&&47363>=a||47365<=a&&47391>=a||47393<=a&&47419>=a||47421<=a&&47447>=
a||47449<=a&&47475>=a||47477<=a&&47503>=a||47505<=a&&47531>=a||47533<=a&&47559>=a||47561<=a&&47587>=a||47589<=a&&47615>=a||47617<=a&&47643>=a||47645<=a&&47671>=a||47673<=a&&47699>=a||47701<=a&&47727>=a||47729<=a&&47755>=a||47757<=a&&47783>=a||47785<=a&&47811>=a||47813<=a&&47839>=a||47841<=a&&47867>=a||47869<=a&&47895>=a||47897<=a&&47923>=a||47925<=a&&47951>=a||47953<=a&&47979>=a||47981<=a&&48007>=a||48009<=a&&48035>=a||48037<=a&&48063>=a||48065<=a&&48091>=a||48093<=a&&48119>=a||48121<=a&&48147>=a||
48149<=a&&48175>=a||48177<=a&&48203>=a||48205<=a&&48231>=a||48233<=a&&48259>=a||48261<=a&&48287>=a||48289<=a&&48315>=a||48317<=a&&48343>=a||48345<=a&&48371>=a||48373<=a&&48399>=a||48401<=a&&48427>=a||48429<=a&&48455>=a||48457<=a&&48483>=a||48485<=a&&48511>=a||48513<=a&&48539>=a||48541<=a&&48567>=a||48569<=a&&48595>=a||48597<=a&&48623>=a||48625<=a&&48651>=a||48653<=a&&48679>=a||48681<=a&&48707>=a||48709<=a&&48735>=a||48737<=a&&48763>=a||48765<=a&&48791>=a||48793<=a&&48819>=a||48821<=a&&48847>=a||48849<=
a&&48875>=a||48877<=a&&48903>=a||48905<=a&&48931>=a||48933<=a&&48959>=a||48961<=a&&48987>=a||48989<=a&&49015>=a||49017<=a&&49043>=a||49045<=a&&49071>=a||49073<=a&&49099>=a||49101<=a&&49127>=a||49129<=a&&49155>=a||49157<=a&&49183>=a||49185<=a&&49211>=a||49213<=a&&49239>=a||49241<=a&&49267>=a||49269<=a&&49295>=a||49297<=a&&49323>=a||49325<=a&&49351>=a||49353<=a&&49379>=a||49381<=a&&49407>=a||49409<=a&&49435>=a||49437<=a&&49463>=a||49465<=a&&49491>=a||49493<=a&&49519>=a||49521<=a&&49547>=a||49549<=a&&
49575>=a||49577<=a&&49603>=a||49605<=a&&49631>=a||49633<=a&&49659>=a||49661<=a&&49687>=a||49689<=a&&49715>=a||49717<=a&&49743>=a||49745<=a&&49771>=a||49773<=a&&49799>=a||49801<=a&&49827>=a||49829<=a&&49855>=a||49857<=a&&49883>=a||49885<=a&&49911>=a||49913<=a&&49939>=a||49941<=a&&49967>=a||49969<=a&&49995>=a||49997<=a&&50023>=a||50025<=a&&50051>=a||50053<=a&&50079>=a||50081<=a&&50107>=a||50109<=a&&50135>=a||50137<=a&&50163>=a||50165<=a&&50191>=a||50193<=a&&50219>=a||50221<=a&&50247>=a||50249<=a&&50275>=
a||50277<=a&&50303>=a||50305<=a&&50331>=a||50333<=a&&50359>=a||50361<=a&&50387>=a||50389<=a&&50415>=a||50417<=a&&50443>=a||50445<=a&&50471>=a||50473<=a&&50499>=a||50501<=a&&50527>=a||50529<=a&&50555>=a||50557<=a&&50583>=a||50585<=a&&50611>=a||50613<=a&&50639>=a||50641<=a&&50667>=a||50669<=a&&50695>=a||50697<=a&&50723>=a||50725<=a&&50751>=a||50753<=a&&50779>=a||50781<=a&&50807>=a||50809<=a&&50835>=a||50837<=a&&50863>=a||50865<=a&&50891>=a||50893<=a&&50919>=a||50921<=a&&50947>=a||50949<=a&&50975>=a||
50977<=a&&51003>=a||51005<=a&&51031>=a||51033<=a&&51059>=a||51061<=a&&51087>=a||51089<=a&&51115>=a||51117<=a&&51143>=a||51145<=a&&51171>=a||51173<=a&&51199>=a||51201<=a&&51227>=a||51229<=a&&51255>=a||51257<=a&&51283>=a||51285<=a&&51311>=a||51313<=a&&51339>=a||51341<=a&&51367>=a||51369<=a&&51395>=a||51397<=a&&51423>=a||51425<=a&&51451>=a||51453<=a&&51479>=a||51481<=a&&51507>=a||51509<=a&&51535>=a||51537<=a&&51563>=a||51565<=a&&51591>=a||51593<=a&&51619>=a||51621<=a&&51647>=a||51649<=a&&51675>=a||51677<=
a&&51703>=a||51705<=a&&51731>=a||51733<=a&&51759>=a||51761<=a&&51787>=a||51789<=a&&51815>=a||51817<=a&&51843>=a||51845<=a&&51871>=a||51873<=a&&51899>=a||51901<=a&&51927>=a||51929<=a&&51955>=a||51957<=a&&51983>=a||51985<=a&&52011>=a||52013<=a&&52039>=a||52041<=a&&52067>=a||52069<=a&&52095>=a||52097<=a&&52123>=a||52125<=a&&52151>=a||52153<=a&&52179>=a||52181<=a&&52207>=a||52209<=a&&52235>=a||52237<=a&&52263>=a||52265<=a&&52291>=a||52293<=a&&52319>=a||52321<=a&&52347>=a||52349<=a&&52375>=a||52377<=a&&
52403>=a||52405<=a&&52431>=a||52433<=a&&52459>=a||52461<=a&&52487>=a||52489<=a&&52515>=a||52517<=a&&52543>=a||52545<=a&&52571>=a||52573<=a&&52599>=a||52601<=a&&52627>=a||52629<=a&&52655>=a||52657<=a&&52683>=a||52685<=a&&52711>=a||52713<=a&&52739>=a||52741<=a&&52767>=a||52769<=a&&52795>=a||52797<=a&&52823>=a||52825<=a&&52851>=a||52853<=a&&52879>=a||52881<=a&&52907>=a||52909<=a&&52935>=a||52937<=a&&52963>=a||52965<=a&&52991>=a||52993<=a&&53019>=a||53021<=a&&53047>=a||53049<=a&&53075>=a||53077<=a&&53103>=
a||53105<=a&&53131>=a||53133<=a&&53159>=a||53161<=a&&53187>=a||53189<=a&&53215>=a||53217<=a&&53243>=a||53245<=a&&53271>=a||53273<=a&&53299>=a||53301<=a&&53327>=a||53329<=a&&53355>=a||53357<=a&&53383>=a||53385<=a&&53411>=a||53413<=a&&53439>=a||53441<=a&&53467>=a||53469<=a&&53495>=a||53497<=a&&53523>=a||53525<=a&&53551>=a||53553<=a&&53579>=a||53581<=a&&53607>=a||53609<=a&&53635>=a||53637<=a&&53663>=a||53665<=a&&53691>=a||53693<=a&&53719>=a||53721<=a&&53747>=a||53749<=a&&53775>=a||53777<=a&&53803>=a||
53805<=a&&53831>=a||53833<=a&&53859>=a||53861<=a&&53887>=a||53889<=a&&53915>=a||53917<=a&&53943>=a||53945<=a&&53971>=a||53973<=a&&53999>=a||54001<=a&&54027>=a||54029<=a&&54055>=a||54057<=a&&54083>=a||54085<=a&&54111>=a||54113<=a&&54139>=a||54141<=a&&54167>=a||54169<=a&&54195>=a||54197<=a&&54223>=a||54225<=a&&54251>=a||54253<=a&&54279>=a||54281<=a&&54307>=a||54309<=a&&54335>=a||54337<=a&&54363>=a||54365<=a&&54391>=a||54393<=a&&54419>=a||54421<=a&&54447>=a||54449<=a&&54475>=a||54477<=a&&54503>=a||54505<=
a&&54531>=a||54533<=a&&54559>=a||54561<=a&&54587>=a||54589<=a&&54615>=a||54617<=a&&54643>=a||54645<=a&&54671>=a||54673<=a&&54699>=a||54701<=a&&54727>=a||54729<=a&&54755>=a||54757<=a&&54783>=a||54785<=a&&54811>=a||54813<=a&&54839>=a||54841<=a&&54867>=a||54869<=a&&54895>=a||54897<=a&&54923>=a||54925<=a&&54951>=a||54953<=a&&54979>=a||54981<=a&&55007>=a||55009<=a&&55035>=a||55037<=a&&55063>=a||55065<=a&&55091>=a||55093<=a&&55119>=a||55121<=a&&55147>=a||55149<=a&&55175>=a||55177<=a&&55203>=a?10:9757==
a||9977==a||9994<=a&&9997>=a||127877==a||127938<=a&&127940>=a||127943==a||127946<=a&&127948>=a||128066<=a&&128067>=a||128070<=a&&128080>=a||128110==a||128112<=a&&128120>=a||128124==a||128129<=a&&128131>=a||128133<=a&&128135>=a||128170==a||128372<=a&&128373>=a||128378==a||128400==a||128405<=a&&128406>=a||128581<=a&&128583>=a||128587<=a&&128591>=a||128675==a||128692<=a&&128694>=a||128704==a||128716==a||129304<=a&&129308>=a||129310<=a&&129311>=a||129318==a||129328<=a&&129337>=a||129341<=a&&129342>=a||
129489<=a&&129501>=a?13:127995<=a&&127999>=a?14:8205==a?15:9792==a||9794==a||9877<=a&&9878>=a||9992==a||10084==a||127752==a||127806==a||127859==a||127891==a||127908==a||127912==a||127979==a||127981==a||128139==a||128187<=a&&128188>=a||128295==a||128300==a||128488==a||128640==a||128658==a?16:128102<=a&&128105>=a?17:11}this.nextBreak=function(a,c){void 0===c&&(c=0);if(0>c)return 0;if(c>=a.length-1)return a.length;var b=k(h(a,c)),d=[];for(c+=1;c<a.length;c++){var e=a,g=c-1;if(!(55296<=e.charCodeAt(g)&&
56319>=e.charCodeAt(g)&&56320<=e.charCodeAt(g+1)&&57343>=e.charCodeAt(g+1))){e=k(h(a,c));if(l(b,d,e))return c;d.push(e)}}return a.length};this.splitGraphemes=function(a){for(var c=[],b=0,d;(d=this.nextBreak(a,b))<a.length;)c.push(a.slice(b,d)),b=d;b<a.length&&c.push(a.slice(b));return c};this.iterateGraphemes=function(a){var c=0,b={next:function(){var d;if((d=this.nextBreak(a,c))<a.length){var e=a.slice(c,d);c=d;return{value:e,done:!1}}return c<a.length?(e=a.slice(c),c=a.length,{value:e,done:!1}):
{value:void 0,done:!0}}.bind(this)};"undefined"!==typeof Symbol&&Symbol.iterator&&(b[Symbol.iterator]=function(){return b});return b};this.countGraphemes=function(a){for(var c=0,b=0,d;(d=this.nextBreak(a,b))<a.length;)b=d,c++;b<a.length&&c++;return c};return this}self.GraphemeSplitter=GraphemeSplitter;

}

// 3rdparty/poly-decomp.js
{
'use strict';function lineInt(l1,l2,precision){precision=precision||0;var i=[0,0];var a1,b1,c1,a2,b2,c2,det;a1=l1[1][1]-l1[0][1];b1=l1[0][0]-l1[1][0];c1=a1*l1[0][0]+b1*l1[0][1];a2=l2[1][1]-l2[0][1];b2=l2[0][0]-l2[1][0];c2=a2*l2[0][0]+b2*l2[0][1];det=a1*b2-a2*b1;if(!scalar_eq(det,0,precision)){i[0]=(b2*c1-b1*c2)/det;i[1]=(a1*c2-a2*c1)/det}return i}
function lineSegmentsIntersect(p1,p2,q1,q2){var dx=p2[0]-p1[0];var dy=p2[1]-p1[1];var da=q2[0]-q1[0];var db=q2[1]-q1[1];if(da*dy-db*dx===0)return false;var s=(dx*(q1[1]-p1[1])+dy*(p1[0]-q1[0]))/(da*dy-db*dx);var t=(da*(p1[1]-q1[1])+db*(q1[0]-p1[0]))/(db*dx-da*dy);return s>=0&&s<=1&&t>=0&&t<=1}function triangleArea(a,b,c){return(b[0]-a[0])*(c[1]-a[1])-(c[0]-a[0])*(b[1]-a[1])}function isLeft(a,b,c){return triangleArea(a,b,c)>0}function isLeftOn(a,b,c){return triangleArea(a,b,c)>=0}
function isRight(a,b,c){return triangleArea(a,b,c)<0}function isRightOn(a,b,c){return triangleArea(a,b,c)<=0}var tmpPoint1=[],tmpPoint2=[];
function collinear(a,b,c,thresholdAngle){if(!thresholdAngle)return triangleArea(a,b,c)===0;else{var ab=tmpPoint1,bc=tmpPoint2;ab[0]=b[0]-a[0];ab[1]=b[1]-a[1];bc[0]=c[0]-b[0];bc[1]=c[1]-b[1];var dot=ab[0]*bc[0]+ab[1]*bc[1],magA=Math.sqrt(ab[0]*ab[0]+ab[1]*ab[1]),magB=Math.sqrt(bc[0]*bc[0]+bc[1]*bc[1]),angle=Math.acos(dot/(magA*magB));return angle<thresholdAngle}}function sqdist(a,b){var dx=b[0]-a[0];var dy=b[1]-a[1];return dx*dx+dy*dy}
function polygonAt(polygon,i){var s=polygon.length;return polygon[i<0?i%s+s:i%s]}function polygonClear(polygon){polygon.length=0}function polygonAppend(polygon,poly,from,to){for(var i=from;i<to;i++)polygon.push(poly[i])}
function polygonMakeCCW(polygon){var br=0,v=polygon;for(var i=1;i<polygon.length;++i)if(v[i][1]<v[br][1]||v[i][1]===v[br][1]&&v[i][0]>v[br][0])br=i;if(!isLeft(polygonAt(polygon,br-1),polygonAt(polygon,br),polygonAt(polygon,br+1))){polygonReverse(polygon);return true}else return false}function polygonReverse(polygon){var tmp=[];var N=polygon.length;for(var i=0;i!==N;i++)tmp.push(polygon.pop());for(var i=0;i!==N;i++)polygon[i]=tmp[i]}
function polygonIsReflex(polygon,i){return isRight(polygonAt(polygon,i-1),polygonAt(polygon,i),polygonAt(polygon,i+1))}var tmpLine1=[],tmpLine2=[];
function polygonCanSee(polygon,a,b){var p,dist,l1=tmpLine1,l2=tmpLine2;if(isLeftOn(polygonAt(polygon,a+1),polygonAt(polygon,a),polygonAt(polygon,b))&&isRightOn(polygonAt(polygon,a-1),polygonAt(polygon,a),polygonAt(polygon,b)))return false;dist=sqdist(polygonAt(polygon,a),polygonAt(polygon,b));for(var i=0;i!==polygon.length;++i){if((i+1)%polygon.length===a||i===a)continue;if(isLeftOn(polygonAt(polygon,a),polygonAt(polygon,b),polygonAt(polygon,i+1))&&isRightOn(polygonAt(polygon,a),polygonAt(polygon,
b),polygonAt(polygon,i))){l1[0]=polygonAt(polygon,a);l1[1]=polygonAt(polygon,b);l2[0]=polygonAt(polygon,i);l2[1]=polygonAt(polygon,i+1);p=lineInt(l1,l2);if(sqdist(polygonAt(polygon,a),p)<dist)return false}}return true}
function polygonCanSee2(polygon,a,b){for(var i=0;i!==polygon.length;++i){if(i===a||i===b||(i+1)%polygon.length===a||(i+1)%polygon.length===b)continue;if(lineSegmentsIntersect(polygonAt(polygon,a),polygonAt(polygon,b),polygonAt(polygon,i),polygonAt(polygon,i+1)))return false}return true}
function polygonCopy(polygon,i,j,targetPoly){var p=targetPoly||[];polygonClear(p);if(i<j)for(var k=i;k<=j;k++)p.push(polygon[k]);else{for(var k=0;k<=j;k++)p.push(polygon[k]);for(var k=i;k<polygon.length;k++)p.push(polygon[k])}return p}
function polygonGetCutEdges(polygon){var min=[],tmp1=[],tmp2=[],tmpPoly=[];var nDiags=Number.MAX_VALUE;for(var i=0;i<polygon.length;++i)if(polygonIsReflex(polygon,i))for(var j=0;j<polygon.length;++j)if(polygonCanSee(polygon,i,j)){tmp1=polygonGetCutEdges(polygonCopy(polygon,i,j,tmpPoly));tmp2=polygonGetCutEdges(polygonCopy(polygon,j,i,tmpPoly));for(var k=0;k<tmp2.length;k++)tmp1.push(tmp2[k]);if(tmp1.length<nDiags){min=tmp1;nDiags=tmp1.length;min.push([polygonAt(polygon,i),polygonAt(polygon,j)])}}return min}
function polygonDecomp(polygon){var edges=polygonGetCutEdges(polygon);if(edges.length>0)return polygonSlice(polygon,edges);else return[polygon]}
function polygonSlice(polygon,cutEdges){if(cutEdges.length===0)return[polygon];if(cutEdges instanceof Array&&cutEdges.length&&cutEdges[0]instanceof Array&&cutEdges[0].length===2&&cutEdges[0][0]instanceof Array){var polys=[polygon];for(var i=0;i<cutEdges.length;i++){var cutEdge=cutEdges[i];for(var j=0;j<polys.length;j++){var poly=polys[j];var result=polygonSlice(poly,cutEdge);if(result){polys.splice(j,1);polys.push(result[0],result[1]);break}}}return polys}else{var cutEdge=cutEdges;var i=polygon.indexOf(cutEdge[0]);
var j=polygon.indexOf(cutEdge[1]);if(i!==-1&&j!==-1)return[polygonCopy(polygon,i,j),polygonCopy(polygon,j,i)];else return false}}function polygonIsSimple(polygon){var path=polygon,i;for(i=0;i<path.length-1;i++)for(var j=0;j<i-1;j++)if(lineSegmentsIntersect(path[i],path[i+1],path[j],path[j+1]))return false;for(i=1;i<path.length-2;i++)if(lineSegmentsIntersect(path[0],path[path.length-1],path[i],path[i+1]))return false;return true}
function getIntersectionPoint(p1,p2,q1,q2,delta){delta=delta||0;var a1=p2[1]-p1[1];var b1=p1[0]-p2[0];var c1=a1*p1[0]+b1*p1[1];var a2=q2[1]-q1[1];var b2=q1[0]-q2[0];var c2=a2*q1[0]+b2*q1[1];var det=a1*b2-a2*b1;if(!scalar_eq(det,0,delta))return[(b2*c1-b1*c2)/det,(a1*c2-a2*c1)/det];else return[0,0]}
function polygonQuickDecomp(polygon,result,reflexVertices,steinerPoints,delta,maxlevel,level){maxlevel=maxlevel||100;level=level||0;delta=delta||25;result=typeof result!=="undefined"?result:[];reflexVertices=reflexVertices||[];steinerPoints=steinerPoints||[];var upperInt=[0,0],lowerInt=[0,0],p=[0,0];var upperDist=0,lowerDist=0,d=0,closestDist=0;var upperIndex=0,lowerIndex=0,closestIndex=0;var lowerPoly=[],upperPoly=[];var poly=polygon,v=polygon;if(v.length<3)return result;level++;if(level>maxlevel){console.warn("quickDecomp: max level ("+
maxlevel+") reached.");return result}for(var i=0;i<polygon.length;++i)if(polygonIsReflex(poly,i)){reflexVertices.push(poly[i]);upperDist=lowerDist=Number.MAX_VALUE;for(var j=0;j<polygon.length;++j){if(isLeft(polygonAt(poly,i-1),polygonAt(poly,i),polygonAt(poly,j))&&isRightOn(polygonAt(poly,i-1),polygonAt(poly,i),polygonAt(poly,j-1))){p=getIntersectionPoint(polygonAt(poly,i-1),polygonAt(poly,i),polygonAt(poly,j),polygonAt(poly,j-1));if(isRight(polygonAt(poly,i+1),polygonAt(poly,i),p)){d=sqdist(poly[i],
p);if(d<lowerDist){lowerDist=d;lowerInt=p;lowerIndex=j}}}if(isLeft(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j+1))&&isRightOn(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j))){p=getIntersectionPoint(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j),polygonAt(poly,j+1));if(isLeft(polygonAt(poly,i-1),polygonAt(poly,i),p)){d=sqdist(poly[i],p);if(d<upperDist){upperDist=d;upperInt=p;upperIndex=j}}}}if(lowerIndex===(upperIndex+1)%polygon.length){p[0]=(lowerInt[0]+upperInt[0])/2;
p[1]=(lowerInt[1]+upperInt[1])/2;steinerPoints.push(p);if(i<upperIndex){polygonAppend(lowerPoly,poly,i,upperIndex+1);lowerPoly.push(p);upperPoly.push(p);if(lowerIndex!==0)polygonAppend(upperPoly,poly,lowerIndex,poly.length);polygonAppend(upperPoly,poly,0,i+1)}else{if(i!==0)polygonAppend(lowerPoly,poly,i,poly.length);polygonAppend(lowerPoly,poly,0,upperIndex+1);lowerPoly.push(p);upperPoly.push(p);polygonAppend(upperPoly,poly,lowerIndex,i+1)}}else{if(lowerIndex>upperIndex)upperIndex+=polygon.length;
closestDist=Number.MAX_VALUE;if(upperIndex<lowerIndex)return result;for(var j=lowerIndex;j<=upperIndex;++j)if(isLeftOn(polygonAt(poly,i-1),polygonAt(poly,i),polygonAt(poly,j))&&isRightOn(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j))){d=sqdist(polygonAt(poly,i),polygonAt(poly,j));if(d<closestDist&&polygonCanSee2(poly,i,j)){closestDist=d;closestIndex=j%polygon.length}}if(i<closestIndex){polygonAppend(lowerPoly,poly,i,closestIndex+1);if(closestIndex!==0)polygonAppend(upperPoly,poly,closestIndex,
v.length);polygonAppend(upperPoly,poly,0,i+1)}else{if(i!==0)polygonAppend(lowerPoly,poly,i,v.length);polygonAppend(lowerPoly,poly,0,closestIndex+1);polygonAppend(upperPoly,poly,closestIndex,i+1)}}if(lowerPoly.length<upperPoly.length){polygonQuickDecomp(lowerPoly,result,reflexVertices,steinerPoints,delta,maxlevel,level);polygonQuickDecomp(upperPoly,result,reflexVertices,steinerPoints,delta,maxlevel,level)}else{polygonQuickDecomp(upperPoly,result,reflexVertices,steinerPoints,delta,maxlevel,level);polygonQuickDecomp(lowerPoly,
result,reflexVertices,steinerPoints,delta,maxlevel,level)}return result}result.push(polygon);return result}function polygonRemoveCollinearPoints(polygon,precision){var num=0;for(var i=polygon.length-1;polygon.length>3&&i>=0;--i)if(collinear(polygonAt(polygon,i-1),polygonAt(polygon,i),polygonAt(polygon,i+1),precision)){polygon.splice(i%polygon.length,1);num++}return num}
function polygonRemoveDuplicatePoints(polygon,precision){for(var i=polygon.length-1;i>=1;--i){var pi=polygon[i];for(var j=i-1;j>=0;--j)if(points_eq(pi,polygon[j],precision)){polygon.splice(i,1);continue}}}function scalar_eq(a,b,precision){precision=precision||0;return Math.abs(a-b)<=precision}function points_eq(a,b,precision){return scalar_eq(a[0],b[0],precision)&&scalar_eq(a[1],b[1],precision)}
self.polyDecomp={decomp:polygonDecomp,quickDecomp:polygonQuickDecomp,isSimple:polygonIsSimple,removeCollinearPoints:polygonRemoveCollinearPoints,removeDuplicatePoints:polygonRemoveDuplicatePoints,makeCCW:polygonMakeCCW};

}

// lib/c3.js
{
'use strict';let isReady=false;let hasAppStarted=false;let buildMode="dev";const C3=self.C3=class C3{constructor(){throw TypeError("static class can't be instantiated");}static SetReady(){isReady=true}static IsReady(){return isReady}static SetAppStarted(){hasAppStarted=true}static HasAppStarted(){return hasAppStarted}static SetBuildMode(m){buildMode=m}static GetBuildMode(){return buildMode}static IsReleaseBuild(){return buildMode==="final"}};C3.isDebug=false;C3.isDebugDefend=false;
C3.hardwareConcurrency=navigator.hardwareConcurrency||2;self.C3X={};

}

// ../lib/queryParser.js
{
'use strict';const C3=self.C3;
C3.QueryParser=class QueryParser{constructor(queryString){this._queryString=queryString;this._parameters=new Map;this._Parse()}_Parse(){let str=this._queryString;if(str.startsWith("?")||str.startsWith("#"))str=str.substr(1);const arr=str.split("&");for(const p of arr)this._ParseParameter(p)}_ParseParameter(p){if(!p)return;if(!p.includes("=")){this._parameters.set(p,null);return}const i=p.indexOf("=");const parameterName=decodeURIComponent(p.substring(0,i));const parameterValue=decodeURIComponent(p.substring(i+
1));this._parameters.set(parameterName,parameterValue)}LogAll(){for(const e of this._parameters)console.log("[QueryParser] Parameter '"+e[0]+"' = "+(e[1]===null?"null":"'"+e[1]+"'"))}Has(name){return this._parameters.has(name)}Get(name){const ret=this._parameters.get(name);if(typeof ret==="undefined")return null;else return ret}ClearHash(){history.replaceState("",document.title,location.pathname+location.search)}Reparse(str){this._queryString=str;this._parameters.clear();this._Parse()}};
C3.QueryString=new C3.QueryParser(location.search);C3.LocationHashString=new C3.QueryParser(location.hash);if(C3.QueryString.Has("perf"))C3.isPerformanceProfiling=true;if(C3.QueryString.Get("mode")!=="dev")C3.SetBuildMode("final");

}

// ../lib/detect/detect.js
{
'use strict';const C3=self.C3;const UNKNOWN="(unknown)";C3.Platform={OS:UNKNOWN,OSVersion:UNKNOWN,Browser:UNKNOWN,BrowserVersion:UNKNOWN,BrowserVersionNumber:NaN,BrowserEngine:UNKNOWN,Context:"browser",IsDesktop:true,IsMobile:false,IsAppleOS:false,IsIpadOS:false,GetDetailedInfo:async()=>{}};const windowsNTVerMap=new Map([[5,"2000"],[5.1,"XP"],[5.2,"XP"],[6,"Vista"],[6.1,"7"],[6.2,"8"],[6.3,"8.1"],[10,"10"]]);
function GetWindowsNTVersionName(ntVer){const num=parseFloat(ntVer);const ret=windowsNTVerMap.get(num);if(ret)return ret;if(num>=13)return"11";return"NT "+ntVer}const uaStr=navigator.userAgent;const uaData=navigator["userAgentData"];
if(uaData&&uaData["brands"].length>0){C3.Platform.OS=uaData["platform"];C3.Platform.IsMobile=uaData["mobile"];C3.Platform.IsDesktop=!C3.Platform.IsMobile;const RECOGNIZED_BROWSERS=new Map([["Google Chrome","Chrome"],["Microsoft Edge","Edge"],["Opera","Opera"],["Opera GX","Opera GX"],["Mozilla Firefox","Firefox"],["Apple Safari","Safari"],["NW.js","NW.js"]]);const RECOGNIZED_ENGINES=new Map([["Chromium","Chromium"],["Gecko","Gecko"],["WebKit","WebKit"]]);function ReadBrandList(brands){let browser=
"";let browser_version="";let engine="";let engine_version="";for(const o of brands){const recognizedBrowser=RECOGNIZED_BROWSERS.get(o["brand"]);if(!browser&&recognizedBrowser){browser=recognizedBrowser;browser_version=o["version"]}const recognizedEngine=RECOGNIZED_ENGINES.get(o["brand"]);if(!engine&&recognizedEngine){engine=recognizedEngine;engine_version=o["version"]}}if(!browser&&engine==="Chromium"){C3.Platform.Browser="Chromium";C3.Platform.BrowserVersion=engine_version}C3.Platform.Browser=browser||
UNKNOWN;C3.Platform.BrowserVersion=browser_version||UNKNOWN;C3.Platform.BrowserEngine=engine||UNKNOWN}ReadBrandList(uaData["brands"]);let didGetDetailedInfo=false;C3.Platform.GetDetailedInfo=async()=>{if(didGetDetailedInfo)return;try{const details=await navigator["userAgentData"]["getHighEntropyValues"](["platformVersion","fullVersionList"]);ReadBrandList(details["fullVersionList"]);if(C3.Platform.OS==="Windows")C3.Platform.OSVersion=GetWindowsNTVersionName(details["platformVersion"]);else C3.Platform.OSVersion=
details["platformVersion"];didGetDetailedInfo=true}catch(err){console.warn("Failed to get detailed user agent information: ",err)}}}else{function RunTest(regex_or_arr,handler){const arr=Array.isArray(regex_or_arr)?regex_or_arr:[regex_or_arr];for(const regex of arr){const result=regex.exec(uaStr);if(result){handler(result);break}}}RunTest(/windows\s+nt\s+([\d\.]+)/i,result=>{C3.Platform.OS="Windows";const ntVer=result[1];C3.Platform.OSVersion=GetWindowsNTVersionName(ntVer)});RunTest(/mac\s+os\s+x\s+([\d\._]+)/i,
result=>{C3.Platform.OS="macOS";C3.Platform.OSVersion=result[1].replace(/_/g,".")});RunTest(/CrOS/,()=>{C3.Platform.OS="Chrome OS"});RunTest(/linux|openbsd|freebsd|netbsd/i,()=>{C3.Platform.OS="Linux"});RunTest(/android/i,()=>{C3.Platform.OS="Android"});RunTest(/android\s+([\d\.]+)/i,result=>{C3.Platform.OS="Android";C3.Platform.OSVersion=result[1]});if(C3.Platform.OS===UNKNOWN){RunTest(/(iphone|ipod|ipad)/i,result=>{C3.Platform.OS="iOS"});RunTest([/iphone\s+os\s+([\d\._]+)/i,/ipad[^)]*os\s+([\d\._]+)/i],
result=>{C3.Platform.OS="iOS";C3.Platform.OSVersion=result[1].replace(/_/g,".")})}const hasChrome=/chrome\//i.test(uaStr);const hasChromium=/chromium\//i.test(uaStr);const hasEdge=/edg\//i.test(uaStr);const hasOpera=/OPR\//.test(uaStr);const hasNWjs=/nwjs/i.test(uaStr);const hasSafari=/safari\//i.test(uaStr);const hasWebKit=/webkit/i.test(uaStr);if(!hasEdge&&!hasOpera)RunTest(/chrome\/([\d\.]+)/i,result=>{C3.Platform.Browser="Chrome";C3.Platform.BrowserVersion=result[1];C3.Platform.BrowserEngine=
"Chromium"});RunTest(/edg\/([\d\.]+)/i,result=>{C3.Platform.Browser="Edge";C3.Platform.BrowserVersion=result[1];C3.Platform.BrowserEngine="Chromium"});RunTest(/OPR\/([\d\.]+)/,result=>{C3.Platform.Browser="Opera";C3.Platform.BrowserVersion=result[1];C3.Platform.BrowserEngine="Chromium"});RunTest(/chromium\/([\d\.]+)/i,result=>{C3.Platform.Browser="Chromium";C3.Platform.BrowserVersion=result[1];C3.Platform.BrowserEngine="Chromium"});RunTest(/nwjs\/[0-9.]+/i,result=>{C3.Platform.Browser="NW.js";C3.Platform.BrowserVersion=
result[1];C3.Platform.BrowserEngine="Chromium";C3.Platform.Context="nwjs"});RunTest(/firefox\/([\d\.]+)/i,result=>{C3.Platform.Browser="Firefox";C3.Platform.BrowserVersion=result[1];C3.Platform.BrowserEngine="Gecko"});if(hasSafari&&!hasChrome&&!hasChromium&&!hasEdge&&!hasOpera&&!hasNWjs){C3.Platform.Browser="Safari";C3.Platform.BrowserEngine="WebKit";RunTest(/version\/([\d\.]+)/i,result=>{C3.Platform.BrowserVersion=result[1]});RunTest(/crios\/([\d\.]+)/i,result=>{C3.Platform.Browser="Chrome for iOS";
C3.Platform.BrowserVersion=result[1]});RunTest(/fxios\/([\d\.]+)/i,result=>{C3.Platform.Browser="Firefox for iOS";C3.Platform.BrowserVersion=result[1]});RunTest(/edgios\/([\d\.]+)/i,result=>{C3.Platform.Browser="Edge for iOS";C3.Platform.BrowserVersion=result[1]})}if(C3.Platform.BrowserEngine===UNKNOWN&&hasWebKit)C3.Platform.BrowserEngine="WebKit";if(C3.Platform.OS==="Android"&&C3.Platform.Browser==="Safari")C3.Platform.Browser="Stock";const desktopOSs=new Set(["Windows","macOS","Linux","Chrome OS"]);
const isDesktop=desktopOSs.has(C3.Platform.OS)||C3.Platform.Context==="nwjs";C3.Platform.IsDesktop=isDesktop;C3.Platform.IsMobile=!isDesktop}if(C3.Platform.Browser==="Chrome"&&C3.Platform.Context==="browser"&&/wv\)/.test(uaStr))C3.Platform.Context="webview";if(C3.Platform.Context!=="nwjs"&&typeof window!=="undefined"&&(window.matchMedia&&window.matchMedia("(display-mode: standalone)").matches||navigator["standalone"]))C3.Platform.Context="webapp";C3.Platform.BrowserVersionNumber=parseFloat(C3.Platform.BrowserVersion);
const looksLikeIPadOS=C3.Platform.OS==="macOS"&&navigator["maxTouchPoints"]&&navigator["maxTouchPoints"]>2;if(looksLikeIPadOS){C3.Platform.OS="iOS";C3.Platform.OSVersion=C3.Platform.BrowserVersion;C3.Platform.IsDesktop=false;C3.Platform.IsMobile=true;C3.Platform.IsIpadOS=true}C3.Platform.IsAppleOS=C3.Platform.OS==="macOS"||C3.Platform.OS==="iOS";

}

// ../lib/storage/kvStorage.js
{
'use strict';{const VERSION=2;const STORE_NAME="keyvaluepairs";const DATABASE_PROMISE_MAP=new Map;const SUPPORTS_GETALL=typeof IDBObjectStore!=="undefined"&&typeof IDBObjectStore.prototype.getAll==="function";const SUPPORTS_GETALLKEYS=typeof IDBObjectStore!=="undefined"&&typeof IDBObjectStore.prototype.getAllKeys==="function";function asyncifyRequest(request){return new Promise((res,rej)=>{request.onsuccess=()=>res(request.result);request.onerror=()=>rej(request.error)})}function asyncifyTransaction(tx){return new Promise((res,
rej)=>{tx.oncomplete=()=>res();tx.onerror=()=>rej(tx.error);tx.onabort=()=>rej(tx.error)})}function openReadOnlyTransaction(name,method){return openTransaction(name,method)}function openWriteTransaction(name,method){return openTransaction(name,method,true)}async function openTransaction(name,method,write=false,allowRetry=true){const db=await lazyOpenDatabase(name);try{const tx=db.transaction([STORE_NAME],write?"readwrite":"readonly");return method(tx)}catch(err){if(allowRetry&&err["name"]==="InvalidStateError"){DATABASE_PROMISE_MAP.delete(name);
return openTransaction(name,method,write,false)}else throw err;}}function lazyOpenDatabase(name){RequireString(name);let dbPromise=DATABASE_PROMISE_MAP.get(name);if(!(dbPromise instanceof Promise)){dbPromise=openDatabase(name);DATABASE_PROMISE_MAP.set(name,dbPromise);dbPromise.catch(err=>DATABASE_PROMISE_MAP.delete(name))}return dbPromise}async function openDatabase(name){RequireString(name);const openRequest=indexedDB.open(name,VERSION);openRequest.addEventListener("upgradeneeded",e=>{try{const db=
e.target.result;db.createObjectStore(STORE_NAME)}catch(err){console.error(`Failed to create objectstore for database ${name}`,err)}});return asyncifyRequest(openRequest)}function RequireString(x){if(typeof x!=="string")throw new TypeError("expected string");}function getEntriesFromCursor(tx,type){const request=tx.objectStore(STORE_NAME).openCursor();return new Promise(resolve=>{const results=[];request.onsuccess=event=>{const cursor=event.target.result;if(cursor){switch(type){case "entries":results.push([cursor.key,
cursor.value]);break;case "keys":results.push(cursor.key);break;case "values":results.push(cursor.value);break}cursor.continue()}else resolve(results)}})}class KVStorageContainer{constructor(name){RequireString(name);this.name=name}async ready(){await lazyOpenDatabase(this.name)}set(key,value){RequireString(key);return openWriteTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).put(value,key);const requestPromise=asyncifyRequest(request);const txPromise=asyncifyTransaction(tx);
await Promise.all([txPromise,requestPromise])})}get(key){RequireString(key);return openReadOnlyTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).get(key);const requestPromise=asyncifyRequest(request);const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}delete(key){RequireString(key);return openWriteTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).delete(key);const requestPromise=asyncifyRequest(request);
const txPromise=asyncifyTransaction(tx);await Promise.all([txPromise,requestPromise])})}clear(){return openWriteTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).clear();const requestPromise=asyncifyRequest(request);const txPromise=asyncifyTransaction(tx);await Promise.all([txPromise,requestPromise])})}keys(){return openReadOnlyTransaction(this.name,async tx=>{let requestPromise;if(SUPPORTS_GETALLKEYS){const request=tx.objectStore(STORE_NAME).getAllKeys();requestPromise=asyncifyRequest(request)}else requestPromise=
getEntriesFromCursor(tx,"keys");const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}values(){return openReadOnlyTransaction(this.name,async tx=>{let requestPromise;if(SUPPORTS_GETALL){const request=tx.objectStore(STORE_NAME).getAll();requestPromise=asyncifyRequest(request)}else requestPromise=getEntriesFromCursor(tx,"values");const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}entries(){return openReadOnlyTransaction(this.name,
async tx=>{const requestPromise=getEntriesFromCursor(tx,"entries");const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}}self.KVStorageContainer=KVStorageContainer};

}

// ../lib/storage/localForageAdaptor.js
{
'use strict';{const KVStorageContainer=self.KVStorageContainer;const CRITICAL_ERRORS=[/no available storage method found/i,/an attempt was made to break through the security policy of the user agent/i,/the user denied permission to access the database/i,/a mutation operation was attempted on a database that did not allow mutations/i,/idbfactory\.open\(\) called in an invalid security context/i];const memoryStorage=new WeakMap;let isInMemory=false;if(typeof indexedDB==="undefined"){isInMemory=true;
console.warn("Unable to use local storage because indexedDB is not defined")}function NOT_IMPLEMENTED(name){throw new Error(`"${name}" is not implemented`);}function DISALLOW_CALLBACK(fn){if(typeof fn==="function")throw new Error(`localforage callback API is not implemented; please use the promise API instead`);}function StructuredClone(value){if(typeof value==="object")return new Promise(resolve=>{const {port1,port2}=new MessageChannel;port2.onmessage=ev=>resolve(ev.data);port1.postMessage(value)});
else return Promise.resolve(value)}class ForageAdaptor{constructor(inst){this._inst=inst;memoryStorage.set(this,new Map)}_MaybeSwitchToMemoryFallback(err){if(isInMemory)return;for(const regex of CRITICAL_ERRORS)if(err&&regex.test(err.message)){console.error("Unable to use local storage, reverting to in-memory store: ",err,err.message);isInMemory=true;break}}async _getItemFallback(name){const value=memoryStorage.get(this).get(name);const ret=await StructuredClone(value);return typeof ret==="undefined"?
null:ret}async _setItemFallback(name,value){value=await StructuredClone(value);memoryStorage.get(this).set(name,value)}_removeItemFallback(name){memoryStorage.get(this).delete(name)}_clearFallback(){memoryStorage.get(this).clear()}_keysFallback(){return Array.from(memoryStorage.get(this).keys())}IsUsingFallback(){return isInMemory}async getItem(key,successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory)return await this._getItemFallback(key);let result;try{result=await this._inst.get(key)}catch(err){this._MaybeSwitchToMemoryFallback(err);
if(isInMemory)return await this._getItemFallback(key);else{console.error(`Error reading '${key}' from storage, returning null: `,err);return null}}return typeof result==="undefined"?null:result}async setItem(key,value,successCallback){DISALLOW_CALLBACK(successCallback);if(typeof value==="undefined")value=null;if(isInMemory){await this._setItemFallback(key,value);return}try{await this._inst.set(key,value)}catch(err){this._MaybeSwitchToMemoryFallback(err);if(isInMemory)await this._setItemFallback(key,
value);else throw err;}}async removeItem(key,successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory){this._removeItemFallback(key);return}try{await this._inst.delete(key)}catch(err){this._MaybeSwitchToMemoryFallback(err);if(isInMemory)this._removeItemFallback(key);else console.error(`Error removing '${key}' from storage: `,err)}}async clear(successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory){this._clearFallback();return}try{await this._inst.clear()}catch(err){this._MaybeSwitchToMemoryFallback(err);
if(isInMemory)this._clearFallback();else console.error(`Error clearing storage: `,err)}}async keys(successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory)return this._keysFallback();let result=[];try{result=await this._inst.keys()}catch(err){this._MaybeSwitchToMemoryFallback(err);if(isInMemory)return this._keysFallback();else console.error(`Error getting storage keys: `,err)}return result}ready(successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory)return Promise.resolve(true);
else return this._inst.ready()}createInstance(options){if(typeof options!=="object")throw new TypeError("invalid options object");const name=options["name"];if(typeof name!=="string")throw new TypeError("invalid store name");const inst=new KVStorageContainer(name);return new ForageAdaptor(inst)}length(successCallback){NOT_IMPLEMENTED("localforage.length()")}key(index,successCallback){NOT_IMPLEMENTED("localforage.key()")}iterate(iteratorCallback,successCallback){NOT_IMPLEMENTED("localforage.iterate()")}setDriver(driverName){NOT_IMPLEMENTED("localforage.setDriver()")}config(options){NOT_IMPLEMENTED("localforage.config()")}defineDriver(customDriver){NOT_IMPLEMENTED("localforage.defineDriver()")}driver(){NOT_IMPLEMENTED("localforage.driver()")}supports(driverName){NOT_IMPLEMENTED("localforage.supports()")}dropInstance(){NOT_IMPLEMENTED("localforage.dropInstance()")}disableMemoryMode(){isInMemory=
false}}self["localforage"]=new ForageAdaptor(new KVStorageContainer("localforage"))};

}

// ../lib/misc/supports.js
{
'use strict';const C3=self.C3;C3.Supports={};C3.Supports.WebAnimations=(()=>{try{if(C3.Platform.Browser==="Safari")return false;if(typeof document==="undefined")return false;const e=document.createElement("div");if(typeof e.animate==="undefined")return false;const player=e.animate([{opacity:"0"},{opacity:"1"}],1E3);return typeof player.reverse!=="undefined"}catch(e){return false}})();C3.Supports.DialogElement=typeof HTMLDialogElement!=="undefined";C3.Supports.RequestIdleCallback=!!self.requestIdleCallback;
C3.Supports.ImageBitmap=!!self.createImageBitmap;C3.Supports.ImageBitmapOptions=false;C3.Supports.ImageBitmapOptionsResize=false;
if(C3.Supports.ImageBitmap){try{self.createImageBitmap(new ImageData(32,32),{"premultiplyAlpha":"none"}).then(()=>{C3.Supports.ImageBitmapOptions=true}).catch(()=>{C3.Supports.ImageBitmapOptions=false})}catch(err){C3.Supports.ImageBitmapOptions=false}try{self.createImageBitmap(new ImageData(32,32),{"resizeWidth":10,"resizeHeight":10}).then(imageBitmap=>{C3.Supports.ImageBitmapOptionsResize=imageBitmap.width===10&&imageBitmap.height===10}).catch(()=>{C3.Supports.ImageBitmapOptionsResize=false})}catch(err){C3.Supports.ImageBitmapOptionsResize=
false}}C3.Supports.ClipboardReadText=!!(navigator["clipboard"]&&navigator["clipboard"]["readText"]&&C3.Platform.Browser!=="Firefox");C3.Supports.PermissionsQuery=!!(navigator["permissions"]&&navigator["permissions"]["query"]);C3.Supports.ClipboardPermissionsQuery=false;if(C3.Supports.PermissionsQuery){const permission={"name":"clipboard-read"};navigator["permissions"]["query"](permission).then(()=>{C3.Supports.ClipboardPermissionsQuery=true}).catch(()=>{C3.Supports.ClipboardPermissionsQuery=false})}
C3.Supports.AsyncClipboardApi=!!(navigator["permissions"]&&navigator["clipboard"]&&self["ClipboardItem"]);C3.Supports.Proxies=typeof Proxy!=="undefined";C3.Supports.DownloadAttribute=(()=>{if(typeof document==="undefined")return false;const a=document.createElement("a");return typeof a.download!=="undefined"})();C3.Supports.Fetch=typeof fetch==="function";C3.Supports.PersistentStorage=!!(self.isSecureContext&&C3.Platform.Browser!=="Opera"&&(navigator["storage"]&&navigator["storage"]["persist"]));
C3.Supports.StorageQuotaEstimate=!!(self.isSecureContext&&(navigator["storage"]&&navigator["storage"]["estimate"]));C3.Supports.Fullscreen=(()=>{if(typeof document==="undefined")return false;if(C3.Platform.OS==="iOS")return false;const elem=document.documentElement;return!!(elem.requestFullscreen||elem.msRequestFullscreen||elem.mozRequestFullScreen||elem.webkitRequestFullscreen)})();C3.Supports.ImageDecoder=typeof self["ImageDecoder"]!=="undefined";C3.Supports.WebCodecs=!!self["VideoEncoder"];
C3.Supports.NativeFileSystemAPI=!!self["showOpenFilePicker"];C3.Supports.QueryLocalFonts=!!self["queryLocalFonts"];C3.Supports.UserActivation=!!navigator["userActivation"];C3.Supports.CanvasToBlobWebP=false;
(async()=>{let canvas;if(typeof document==="undefined")canvas=new OffscreenCanvas(32,32);else{canvas=document.createElement("canvas");canvas.width=32;canvas.height=32}const ctx=canvas.getContext("2d");ctx.fillStyle="blue";ctx.fillRect(0,0,32,32);let blob=null;try{if(canvas.toBlob)blob=await new Promise(resolve=>canvas.toBlob(resolve,"image/webp",1));else if(canvas["convertToBlob"])blob=await canvas["convertToBlob"]({"type":"image/webp","quality":1});C3.Supports.CanvasToBlobWebP=blob&&blob.type===
"image/webp"}catch(err){C3.Supports.CanvasToBlobWebP=false}})();

}

// ../lib/misc/polyfills.js
{
'use strict';const C3=self.C3;if(!String.prototype.trimStart){const startWhitespace=/^[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]*/;String.prototype.trimStart=function trimStart(){return this.replace(startWhitespace,"")}}
if(!String.prototype.trimEnd){const endWhitespace=/[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]*$/;String.prototype.trimEnd=function trimEnd(){return this.replace(endWhitespace,"")}}if(!String.prototype.replaceAll)String.prototype.replaceAll=function replaceAll(find,replace){return this.replace(new RegExp(C3.EscapeRegex(find),"g"),replace)};if(!Array.prototype.values)Array.prototype.values=function*(){for(const i of this)yield i};
if(!Array.prototype.flat){function arrayFlat(arr,depth){return arr.reduce((acc,val)=>{if(depth>0&&Array.isArray(val)){Array.prototype.push.apply(acc,arrayFlat(val,depth-1));return acc}else{acc.push(val);return acc}},[])}Array.prototype.flat=function(depth=1){return arrayFlat(this,depth)}}if(!Array.prototype.at)Array.prototype.at=function at(n){n=Math.trunc(n)||0;if(n<0)n+=this.length;if(n<0||n>=this.length)return undefined;return this[n]};
if(!String.prototype.at)String.prototype.at=function at(n){n=Math.trunc(n)||0;if(n<0)n+=this.length;if(n<0||n>=this.length)return undefined;return this[n]};if(!RegExp.escape)RegExp.escape=function(s){return String(s).replace(/[\\^$*+?.()|[\]{}]/g,"\\$&")};
if(navigator["storage"]&&!navigator["storage"]["estimate"]&&navigator["webkitTemporaryStorage"]&&navigator["webkitTemporaryStorage"]["queryUsageAndQuota"])navigator["storage"]["estimate"]=function(){return new Promise((resolve,reject)=>{return navigator["webkitTemporaryStorage"]["queryUsageAndQuota"]((usage,quota)=>resolve({"usage":usage,"quota":quota}),reject)})};if(typeof self.isSecureContext==="undefined")self.isSecureContext=location.protocol==="https:";
if(typeof self["globalThis"]==="undefined")self["globalThis"]=self;

}

// lib/misc/assert.js
{
'use strict';const C3=self.C3;function assertFail(msg_){let stack=C3.GetCallStack();let msg="Assertion failure: "+msg_+"\n\nStack trace:\n"+stack;console.error(msg)}self.assert=function assert(cnd_,msg_){if(!cnd_)assertFail(msg_)};

}

// ../lib/misc/typeChecks.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;C3.IsNumber=function IsNumber(x){return typeof x==="number"};C3.IsFiniteNumber=function IsFiniteNumber(x){return C3.IsNumber(x)&&isFinite(x)};C3.RequireNumber=function RequireNumber(x){if(!C3.IsNumber(x))throw new TypeError("expected number");};C3.RequireOptionalNumber=function RequireOptionalNumber(x){if(C3.IsNullOrUndefined(x))return};
C3.RequireNumberInRange=function RequireNumberInRange(x,low,high){if(!C3.IsNumber(x)||isNaN(x)||low>x||high<x)throw new RangeError("number outside of range");};C3.RequireAllNumber=function RequireAllNumber(...args){for(let a of args);};C3.RequireFiniteNumber=function RequireFiniteNumber(x){if(!C3.IsFiniteNumber(x))throw new TypeError("expected finite number");};C3.RequireOptionalFiniteNumber=function RequireOptionalFiniteNumber(x){if(C3.IsNullOrUndefined(x))return};
C3.RequireAllFiniteNumber=function RequireAllFiniteNumber(...args){for(let a of args);};C3.IsString=function IsString(x){return typeof x==="string"};C3.RequireString=function RequireString(x){if(!C3.IsString(x))throw new TypeError("expected string");};C3.RequireOptionalString=function RequireOptionalString(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllString=function RequireAllString(...args){for(let a of args);};
C3.IsSimpleObject=function IsSimpleObject(x){if(typeof x!=="object"||x===null)return false;let proto=Object.getPrototypeOf(x);return proto?proto.constructor===Object:proto===null};C3.RequireSimpleObject=function RequireSimpleObject(x){if(!C3.IsSimpleObject(x))throw new TypeError("expected simple object");};C3.RequireOptionalSimpleObject=function RequireSimpleObject(x){if(C3.IsNullOrUndefined(x))return;if(!C3.IsSimpleObject(x))throw new TypeError("expected simple object");};
C3.IsObject=function IsObject(x){return typeof x==="object"&&x!==null&&!Array.isArray(x)};C3.RequireObject=function RequireObject(x){if(!C3.IsObject(x))throw new TypeError("expected object");};C3.RequireOptionalObject=function RequireOptionalObject(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllObject=function RequireAllObject(...args){for(let a of args);};C3.IsFileLike=function IsFileLike(x){return C3.WeakIsInstanceOf(x,Blob)&&typeof x["name"]==="string"};
C3.RequireFileLike=function RequireFileLike(x){if(!C3.IsFileLike(x))throw new TypeError("expected file");};C3.RequireOptionalFileLike=function RequireOptionalFileLike(x){if(C3.IsNullOrUndefined(x))return};C3.IsArray=function IsArray(x){return Array.isArray(x)};C3.RequireArray=function RequireArray(x){if(!C3.IsArray(x))throw new TypeError("expected array");};C3.RequireOptionalArray=function RequireOptionalArray(x){if(C3.IsNullOrUndefined(x))return};
C3.RequireAllArray=function RequireAllArray(...args){for(let a of args);};C3.Is2DArray=function(x){if(!C3.IsArray(x))return false;if(!x.length)return true;if(!C3.IsArray(x[0]))return false;return true};C3.Require2DArray=function Require2DArray(x){if(!C3.Is2DArray(x))throw new TypeError("expected 2d array");for(let arr of x)if(!C3.IsArray(arr))throw new TypeError("expected 2d array");};C3.RequireOptional2DArray=function Require2DArray(x){if(C3.IsNullOrUndefined(x))return};
C3.IsFunction=function IsFunction(x){return typeof x==="function"};C3.RequireFunction=function RequireFunction(x,f){if(!C3.IsFunction(x))throw new TypeError("expected function");if(!C3.IsNullOrUndefined(f))if(x!==f)throw new TypeError("expected same function reference");};C3.RequireOptionalFunction=function RequireOptionalFunction(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllFunction=function RequireAllFunction(...args){for(let a of args);};
C3.RequireAnyFunction=function RequireAllFunction(x,...args){if(!C3.IsFunction(x))throw new TypeError("expected function");if(!args.length)throw new Error("missing comparison functions");for(let a of args)if(!C3.IsNullOrUndefined(a))if(x===a)return;throw new TypeError("expected same function reference");};C3.RequireOptionalAllFunction=function RequireAllFunction(...args){if(C3.IsNullOrUndefined(args))return;for(let a of args);};C3.IsInstanceOf=function IsInstanceOf(x,t){return x instanceof t};
C3.IsInstanceOfAny=function IsInstanceOfAny(x,...args){for(let t of args)if(C3.IsInstanceOf(x,t))return true;return false};C3.RequireInstanceOf=function RequireInstanceOf(x,t){if(!C3.IsInstanceOf(x,t))throw new TypeError("unexpected type");};C3.RequireOptionalInstanceOf=function RequireOptionalInstanceOf(x,t){if(C3.IsNullOrUndefined(x))return};C3.RequireAllInstanceOf=function RequireAllInstanceOf(t,...args){for(let a of args);};
C3.RequireAnyInstanceOf=function RequireAnyInstanceOf(x,...args){if(!C3.IsInstanceOfAny(x,...args))throw new TypeError("unexpected type");};C3.RequireAnyOptionalInstanceOf=function RequireAnyOptionalInstanceOf(x,...args){if(C3.IsNullOrUndefined(x))return;if(!C3.IsInstanceOfAny(x,...args))throw new TypeError("unexpected type");};C3.IsArrayOf=function IsArrayOf(x,t){for(let i of x)if(!C3.IsInstanceOf(i,t))return false;return true};
C3.IsArrayOfFiniteNumbers=function IsArrayOfFiniteNumbers(x){for(let i of x)if(!C3.IsFiniteNumber(i))return false;return true};C3.RequireArrayOf=function RequireArrayOf(x,t){for(let i of x);};C3.RequireOptionalArrayOf=function RequireOptionalArrayOf(x,t){if(C3.IsNullOrUndefined(x))return;for(let i of x);};C3.RequireArrayOfAny=function RequireArrayOf(x,...args){for(let i of x);};
C3.RequireOptionalArrayOfAny=function RequireOptionalArrayOfAny(x,...args){if(C3.IsNullOrUndefined(x))return;for(let i of x);};C3.IsDOMNode=function IsDOMNode(d,n){if(C3.IsNullOrUndefined(d)||!C3.IsString(d.nodeName))return false;return!n||C3.equalsNoCase(d.nodeName,n)};C3.RequireDOMNode=function RequireDOMNode(d,n){if(C3.IsNullOrUndefined(d)||!C3.IsString(d.nodeName))throw new TypeError("expected DOM node");if(n&&!C3.equalsNoCase(d.nodeName,n))throw new TypeError(`expected DOM '${n}' node`);};
C3.RequireOptionalDOMNode=function RequireOptionalDOMNode(d,n){if(C3.IsNullOrUndefined(d))return};C3.IsHTMLElement=function IsHTMLElement(e,t){if(C3.IsNullOrUndefined(e)||!C3.IsString(e.tagName))return false;return!t||C3.equalsNoCase(e.tagName,t)};C3.RequireHTMLElement=function RequireHTMLElement(e,t){if(C3.IsNullOrUndefined(e)||!C3.IsString(e.tagName))throw new TypeError("expected HTML element");if(t&&!C3.equalsNoCase(e.tagName,t))throw new TypeError(`expected HTML '${t}' element`);};
C3.RequireOptionalHTMLElement=function RequireOptionalHTMLElement(e,t){if(C3.IsNullOrUndefined(e))return};C3.IsDrawable=function IsDrawable(d){return C3.IsHTMLElement(d,"img")||C3.IsHTMLElement(d,"canvas")||C3.IsHTMLElement(d,"video")||typeof OffscreenCanvas!=="undefined"&&d instanceof OffscreenCanvas||typeof ImageBitmap!=="undefined"&&d instanceof ImageBitmap};C3.RequireDrawable=function RequireDrawable(d){if(!C3.IsDrawable(d))throw new TypeError("expected drawable");};
C3.RequireOptionalDrawable=function RequireOptionalDrawable(d){if(C3.IsNullOrUndefined(d))return};C3.IsDrawableOrImageData=function IsDrawableOrImageData(x){if(x instanceof ImageData)return true;return C3.IsDrawable(x)};C3.RequireDrawableOrImageData=function RequireDrawableOrImageData(d){if(!C3.IsDrawableOrImageData(d))throw new TypeError("expected drawable or image data");};
C3.RequireOptionalDrawableOrImageData=function RequireOptionalDrawableOrImageData(d){if(C3.IsNullOrUndefined(d))return;if(!C3.IsDrawableOrImageData(d))throw new TypeError("expected drawable or image data");};C3.IsStringLike=function IsStringLike(x){return typeof x==="string"||C3.HtmlString&&x instanceof C3.HtmlString||x instanceof C3.BBString};C3.RequireStringLike=function RequireStringLike(x){if(!C3.IsStringLike(x))throw new TypeError("expected string-like");};C3.RequireOptionalStringLike=function RequireOptionalStringLike(x){if(C3.IsNullOrUndefined(x))return};
C3.RequireAllStringLike=function RequireAllStringLike(...args){for(let a of args);};C3.RequireOverride=function RequireOverride(){throw new Error("must be overridden");};C3.NotYetImplemented=function NotYetImplemented(){throw new Error("not yet implemented");};C3.IsDefined=function isDefined(obj,...follow){let currentObject=obj;if(typeof currentObject==="undefined")return false;for(let key of follow){if(typeof currentObject[key]==="undefined")return false;currentObject=currentObject[key]}return true};
C3.IsNullOrUndefined=function(x){return typeof x==="undefined"||x===null};C3.AreArrayElementsOfSameType=function(arr){let type=arr[0].constructor;for(let x of arr)if(x.constructor!==type)return false;return type};C3.AreArrayElementsOfType=function(arr,t){for(let x of arr)if(!(x instanceof t))return false;return true};const TypedArray=Object.getPrototypeOf(Uint8Array);C3.IsTypedArray=function(view){return C3.IsInstanceOf(view,TypedArray)};C3.RequireTypedArray=function(view){};
C3.WeakRequireTypedArray=function WeakRequireTypedArray(inst){C3.WeakRequireInstanceOf(inst,TypedArray)};C3.WeakRequireAnyInstanceOf=function WeakRequireAnyInstanceOf(inst,...ctors){if(!C3.WeakIsAnyInstanceOf(inst,...ctors))throw new TypeError("unexpected type");};C3.WeakIsAnyInstanceOf=function WeakIsAnyInstanceOf(inst,...ctors){for(const ctor of ctors)if(C3.WeakIsInstanceOf(inst,ctor))return true;return false};
C3.WeakRequireInstanceOf=function WeakRequireInstanceOf(inst,ctor){if(!C3.WeakIsInstanceOf(inst,ctor))throw new TypeError("unexpected type");};C3.WeakIsInstanceOf=function WeakIsInstanceOf(inst,ctor){while(inst=Object.getPrototypeOf(inst))if(inst.constructor.name===ctor.name)return true;return false};C3X.RequireNumber=C3.RequireNumber;C3X.RequireOptionalNumber=C3.RequireOptionalNumber;C3X.RequireFiniteNumber=C3.RequireFiniteNumber;C3X.RequireOptionalFiniteNumber=C3.RequireOptionalFiniteNumber;
C3X.RequireString=C3.RequireString;C3X.RequireOptionalString=C3.RequireOptionalString;C3X.RequireObject=C3.RequireObject;C3X.RequireOptionalObject=C3.RequireOptionalObject;C3X.RequireArray=C3.RequireArray;C3X.RequireOptionalArray=C3.RequireOptionalArray;C3X.RequireFunction=C3.RequireFunction;C3X.RequireOptionalFunction=C3.RequireOptionalFunction;C3X.RequireInstanceOf=C3.RequireInstanceOf;C3X.RequireOptionalInstanceOf=C3.RequireOptionalInstanceOf;C3X.IsNullOrUndefined=C3.IsNullOrUndefined;

}

// ../lib/misc/jsutil.js
{
'use strict';const C3=self.C3;const logRafIds=new Map;C3.ColorLog=function(message,color){console.log(`%c${message}`,`font-weight: bold; color:${color}`)};C3.RafLog=function RaFLog(name,...args){if(!logRafIds.has(name))logRafIds.set(name,-1);if(logRafIds.get(name)===-1)logRafIds.set(name,requestAnimationFrame(()=>{console.log(`%c${name}`,"font-weight: bold",...args);logRafIds.set(name,-1)}))};let measures;
C3.StartMeasure=function StartMeasure(name){performance.mark(name);if(!measures)measures=new Map;if(!measures.has(name))measures.set(name,{current:0,total:0,average:0,calls:1,toString:function(){return`${name} :: current => ${this.current.toPrecision(3)} :: average => ${this.average.toPrecision(3)} :: calls => ${this.calls}`}})};
C3.EndMeasure=function EndMeasure(name){performance.measure(`measure-${name}`,name);const entry=performance.getEntriesByName(`measure-${name}`)[0];const m=measures.get(name);m.current=entry.duration;m.total+=m.current;m.average=m.total/m.calls;console.log(m.toString());m.calls++;performance.clearMarks(name);performance.clearMeasures(`measure-${name}`)};C3.GetCallStack=function GetCallStack(){return(new Error).stack};C3.Debugger=function Debugger(){debugger};
C3.cast=function cast(o,T){if(o&&o instanceof T)return o;else return null};
C3.getName=function getName(o){if(typeof o==="undefined")return"undefined";if(o===null)return"null";if(typeof o==="boolean")return"<boolean>";if(C3.IsNumber(o))return"<number>";if(C3.IsString(o))return"<string>";if(C3.IsArray(o))return"<array>";if(typeof o==="symbol")return"<"+o.toString()+">";if(C3.IsFunction(o)){if(o.name&&o.name!=="Function")return o.name;return"<anonymous function>"}if(typeof o==="object"){if(o.constructor&&o.constructor.name&&o.constructor.name!=="Object")return o.constructor.name;
return"<anonymous object>"}return"<unknown>"};C3.getType=function getType(o){if(o===null)return"null";if(Array.isArray(o))return"array";return typeof o};C3.range=function*range(a,b){if(!isFinite(Math.abs(a-b)))throw new Error("Invalid parameters");if(a>b)for(let i=a-1;i>=b;i--)yield i;else for(let i=a;i<b;i++)yield i};
function isValidTypeChange(from,to){let fromType=C3.getType(from);let toType=C3.getType(to);if(fromType==="null"||toType==="null")return true;if(fromType==="undefined"||toType==="undefined")return false;return fromType===toType}let ctorObjectToProxy=new Map;let ctorProxyToObject=new Map;let proxyToObject=new WeakMap;let releasedObjects=new WeakMap;C3.DefendHandler={};const VALID_GET_MISSING_KEYS=new Set(["then","splice"]);
function logDefendedObjectWarning(msg){console.warn("[Defence] "+msg+" @",C3.GetCallStack())}
C3.DefendHandler.get=function defended_get(target,key){if(!(key in target)&&typeof key!=="symbol"&&!VALID_GET_MISSING_KEYS.has(key))logDefendedObjectWarning(`Accessed missing property '${key}' from defended object '${C3.getName(target)}', returning undefined`);if(releasedObjects.has(target)&&typeof key!=="symbol"&&!VALID_GET_MISSING_KEYS.has(key))logDefendedObjectWarning(`Accessed property '${key}' on a released object '${C3.getName(target)}'\nObject was originally released at: ${releasedObjects.get(target)})\nCall stack at access: `);return target[key]};
C3.DefendHandler.set=function defended_set(target,key,value){if(!(key in target)&&!ctorObjectToProxy.has(target))logDefendedObjectWarning(`Set non-existent property '${key}' to '${value}' on defended object '${C3.getName(target)}'`);if(!isValidTypeChange(target[key],value)&&!ctorObjectToProxy.has(target))logDefendedObjectWarning(`Set '${C3.getType(target[key])}' property '${key}' to type '${C3.getType(value)}' on defended object '${C3.getName(target)}'`);if(releasedObjects.has(target))logDefendedObjectWarning(`Set property '${key}' on a released object '${C3.getName(target)}'\nObject was originally released at: ${releasedObjects.get(target)})\nCall stack at access: `);
target[key]=value;return true};C3.DefendHandler.deleteProperty=function defended_deleteProperty(target,key){throw new ReferenceError(`Cannot delete property '${key}' from defended object '${C3.getName(target)}'`);};C3.DefendHandler.defineProperty=function defended_defineProperty(target,key,desc){throw new ReferenceError(`Cannot define property '${key}' on defended object '${C3.getName(target)}'`);};
C3.DefendHandler.enumerate=function defended_enumerate(target){throw new ReferenceError(`Cannot enumerate defended object '${C3.getName(target)}'`);};let checkRafId=-1;
function CheckDefendedObjectsUsedCorrectly(){checkRafId=-1;if(ctorObjectToProxy.size>0||ctorProxyToObject.size>0){let uniqueNames=new Set([...ctorObjectToProxy.keys()].map(o=>C3.getName(o)));let leftoverNames=[...uniqueNames].join(",");console.warn(`An object derived from DefendedBase was not protected with debugDefend(). This will disable some checks. See the coding guidelines! Possible affected class names: ${leftoverNames}`);ctorObjectToProxy.clear();ctorProxyToObject.clear()}}
C3.DefendedBase=class DefendedBase{constructor(){if(!C3.isDebugDefend||!C3.Supports.Proxies)return;let newTarget=new.target;let realObject=Object.create(newTarget.prototype);let proxy=new Proxy(realObject,C3.DefendHandler);ctorObjectToProxy.set(realObject,proxy);ctorProxyToObject.set(proxy,realObject);proxyToObject.set(proxy,realObject);if(checkRafId===-1)checkRafId=requestAnimationFrame(CheckDefendedObjectsUsedCorrectly);return proxy}};
C3.debugDefend=function debugDefend(o){if(C3.isDebugDefend&&C3.Supports.Proxies&&o instanceof C3.DefendedBase){if(!ctorProxyToObject.has(o))return o;let realObject=ctorProxyToObject.get(o);ctorProxyToObject.delete(o);ctorObjectToProxy.delete(realObject);return o}else if(C3.isDebug)return Object.seal(o);else return o};
C3.New=function New(Type,...args){let o;try{o=new Type(...args)}catch(e){ctorProxyToObject.clear();ctorObjectToProxy.clear();throw e;}if(C3.isDebugDefend)VerifyObjectPropertiesConsistent(Type,o);return C3.debugDefend(o)};C3.Release=function Release(o){let realObject=proxyToObject.get(o);if(realObject)releasedObjects.set(realObject,C3.GetCallStack())};C3.WasReleased=function(o){let realObject=proxyToObject.get(o);if(!realObject)return false;return!!releasedObjects.get(realObject)};
let typeProperties=new Map;function getObjectPropertySet(o){let ret=new Set;for(let k in o)ret.add(k);return ret}
function VerifyObjectPropertiesConsistent(Type,o){let properties=getObjectPropertySet(o);let existingProperties=typeProperties.get(Type);if(existingProperties){let inconsistentProperties=[];for(let k of existingProperties.values())if(properties.has(k))properties.delete(k);else inconsistentProperties.push(k);C3.appendArray(inconsistentProperties,[...properties]);if(inconsistentProperties.length)console.warn(`[Defence] '${C3.getName(Type)}' constructor creates inconsistent properties: ${inconsistentProperties.join(", ")}`)}else typeProperties.set(Type,properties)}
C3.PerfMark=class PerfMark{constructor(name){this._name="";if(name)this.start(name)}start(name){if(!C3.isPerformanceProfiling)return;this._name=name;performance.mark(this._name+"-Start")}end(){if(!C3.isPerformanceProfiling)return;performance.mark(this._name+"-End");performance.measure(this._name,this._name+"-Start",this._name+"-End")}next(name){if(!C3.isPerformanceProfiling)return;this.end();this._name=name;performance.mark(this._name+"-Start")}};

}

// ../lib/misc/mathutil.js
{
'use strict';const C3=self.C3;const TWO_PI=Math.PI*2;const D_TO_R=Math.PI/180;const R_TO_D=180/Math.PI;C3.wrap=function wrap(x,min,max){x=Math.floor(x);min=Math.floor(min);max=Math.floor(max);const diff=max-min;if(diff===0)return max;if(x<min){const r=max-(min-x)%diff;return r===max?0:r}else return min+(x-min)%diff};C3.mapToRange=function mapToRange(x,inMin,inMax,outMin,outMax){return(x-inMin)*(outMax-outMin)/(inMax-inMin)+outMin};
C3.normalize=function normalize(value,minimum,maximum){return(value-minimum)/(maximum-minimum)};C3.clamp=function clamp(x,a,b){if(x<a)return a;else if(x>b)return b;else return x};C3.clampAngle=function clampAngle(a){a%=TWO_PI;if(a<0)a+=TWO_PI;return a};C3.toRadians=function toRadians(x){return x*D_TO_R};C3.toDegrees=function toDegrees(x){return x*R_TO_D};C3.distanceTo=function distanceTo(x1,y1,x2,y2){return Math.hypot(x2-x1,y2-y1)};
C3.distanceSquared=function distanceSquared(x1,y1,x2,y2){const dx=x2-x1;const dy=y2-y1;return dx*dx+dy*dy};C3.angleTo=function angleTo(x1,y1,x2,y2){return Math.atan2(y2-y1,x2-x1)};C3.angleDiff=function angleDiff(a1,a2){if(a1===a2)return 0;let s1=Math.sin(a1);let c1=Math.cos(a1);let s2=Math.sin(a2);let c2=Math.cos(a2);let n=s1*s2+c1*c2;if(n>=1)return 0;if(n<=-1)return Math.PI;return Math.acos(n)};
C3.angleRotate=function angleRotate(start,end,step){let ss=Math.sin(start);let cs=Math.cos(start);let se=Math.sin(end);let ce=Math.cos(end);if(Math.acos(ss*se+cs*ce)>step)if(cs*se-ss*ce>0)return C3.clampAngle(start+step);else return C3.clampAngle(start-step);else return C3.clampAngle(end)};C3.angleClockwise=function angleClockwise(a1,a2){let s1=Math.sin(a1);let c1=Math.cos(a1);let s2=Math.sin(a2);let c2=Math.cos(a2);return c1*s2-s1*c2<=0};
C3.angleLerp=function angleLerp(a,b,x,r=0){let diff=C3.angleDiff(a,b);const revs=TWO_PI*r;if(C3.angleClockwise(b,a))return C3.clampAngle(a+(diff+revs)*x);else return C3.clampAngle(a-(diff+revs)*x)};C3.angleLerpClockwise=function angleLerpClockwise(a,b,x,r=0){const diff=C3.angleDiff(a,b);const revs=TWO_PI*r;if(C3.angleClockwise(b,a))return C3.clampAngle(a+(diff+revs)*x);return C3.clampAngle(a+(TWO_PI-diff+revs)*x)};
C3.angleLerpAntiClockwise=function angleLerpAntiClockwise(a,b,x,r=0){const diff=C3.angleDiff(a,b);const revs=TWO_PI*r;if(C3.angleClockwise(b,a))return C3.clampAngle(a-(-TWO_PI+diff-revs)*x);return C3.clampAngle(a-(diff+revs)*x)};C3.angleReflect=function angleReflect(a,b){const diff=C3.angleDiff(a,b);if(C3.angleClockwise(a,b))return C3.clampAngle(b-diff);else return C3.clampAngle(b+diff)};C3.lerp=function lerp(a,b,x){return a+x*(b-a)};
C3.unlerp=function unlerp(a,b,x){if(a===b)return 0;return(x-a)/(b-a)};C3.relerp=function relerp(a,b,x,c,d){return C3.lerp(c,d,C3.unlerp(a,b,x))};C3.qarp=function qarp(a,b,c,x){return C3.lerp(C3.lerp(a,b,x),C3.lerp(b,c,x),x)};C3.cubic=function cubic(a,b,c,d,x){return C3.lerp(C3.qarp(a,b,c,x),C3.qarp(b,c,d,x),x)};C3.cosp=function cosp(a,b,x){return(a+b+(a-b)*Math.cos(x*Math.PI))/2};C3.isPOT=function isPOT(x){return x>0&&(x-1&x)===0};
C3.nextHighestPowerOfTwo=function nextHighestPowerOfTwo(x){--x;for(let i=1;i<32;i<<=1)x=x|x>>i;return x+1};C3.roundToNearestFraction=function roundToNearestFraction(x,n){return Math.round(x*n)/n};C3.floorToNearestFraction=function floorToNearestFraction(x,n){return Math.floor(x*n)/n};C3.roundToDp=function roundToDp(x,dp){dp=Math.max(Math.floor(dp),0);const m=Math.pow(10,dp);return Math.round(x*m)/m};
C3.toFixed=function toFixed(n,dp){let ret=n.toFixed(dp);let last=ret.length-1;for(;last>=0&&ret.charAt(last)==="0";--last);if(last>=0&&ret.charAt(last)===".")--last;if(last<0)return ret;return ret.substr(0,last+1)};C3.PackRGB=function PackRGB(red,green,blue){return C3.clamp(red,0,255)|C3.clamp(green,0,255)<<8|C3.clamp(blue,0,255)<<16};const ALPHAEX_SHIFT=1024;const ALPHAEX_MAX=1023;const RGBEX_SHIFT=16384;const RGBEX_MAX=8191;const RGBEX_MIN=-8192;
C3.PackRGBAEx=function PackRGBAEx(red,green,blue,alpha){red=C3.clamp(Math.floor(red*1024),RGBEX_MIN,RGBEX_MAX);green=C3.clamp(Math.floor(green*1024),RGBEX_MIN,RGBEX_MAX);blue=C3.clamp(Math.floor(blue*1024),RGBEX_MIN,RGBEX_MAX);alpha=C3.clamp(Math.floor(alpha*ALPHAEX_MAX),0,ALPHAEX_MAX);if(red<0)red+=RGBEX_SHIFT;if(green<0)green+=RGBEX_SHIFT;if(blue<0)blue+=RGBEX_SHIFT;return-(red*RGBEX_SHIFT*RGBEX_SHIFT*ALPHAEX_SHIFT+green*RGBEX_SHIFT*ALPHAEX_SHIFT+blue*ALPHAEX_SHIFT+alpha)};
C3.PackRGBEx=function PackRGBEx(red,green,blue){return C3.PackRGBAEx(red,green,blue,1)};function isNegativeZero(x){return x===0&&1/x<0}C3.GetRValue=function GetRValue(rgb){if(rgb>=0)return(rgb&255)/255;else{let v=Math.floor(-rgb/(RGBEX_SHIFT*RGBEX_SHIFT*ALPHAEX_SHIFT));if(v>RGBEX_MAX)v-=RGBEX_SHIFT;return v/1024}};
C3.GetGValue=function GetGValue(rgb){if(rgb>=0)return((rgb&65280)>>8)/255;else{let v=Math.floor(-rgb%(RGBEX_SHIFT*RGBEX_SHIFT*ALPHAEX_SHIFT)/(RGBEX_SHIFT*ALPHAEX_SHIFT));if(v>RGBEX_MAX)v-=RGBEX_SHIFT;return v/1024}};C3.GetBValue=function GetBValue(rgb){if(rgb>=0)return((rgb&16711680)>>16)/255;else{let v=Math.floor(-rgb%(RGBEX_SHIFT*ALPHAEX_SHIFT)/ALPHAEX_SHIFT);if(v>RGBEX_MAX)v-=RGBEX_SHIFT;return v/1024}};
C3.GetAValue=function GetAValue(rgb){if(isNegativeZero(rgb))return 0;else if(rgb>=0)return 1;else{const v=Math.floor(-rgb%ALPHAEX_SHIFT);return v/ALPHAEX_MAX}};C3.greatestCommonDivisor=function greatestCommonDivisor(a,b){a=Math.floor(a);b=Math.floor(b);while(b!==0){let t=b;b=a%b;a=t}return a};const COMMON_ASPECT_RATIOS=[[3,2],[4,3],[5,4],[5,3],[6,5],[14,9],[16,9],[16,10],[21,9]];
C3.getAspectRatio=function getAspectRatio(w,h){w=Math.floor(w);h=Math.floor(h);if(w===h)return[1,1];for(let aspect of COMMON_ASPECT_RATIOS){let approxH=w/aspect[0]*aspect[1];if(Math.abs(h-approxH)<1)return aspect.slice(0);approxH=w/aspect[1]*aspect[0];if(Math.abs(h-approxH)<1)return[aspect[1],aspect[0]]}let gcd=C3.greatestCommonDivisor(w,h);return[w/gcd,h/gcd]};
C3.segmentsIntersect=function segmentsIntersect(a1x,a1y,a2x,a2y,b1x,b1y,b2x,b2y){const min_ax=Math.min(a1x,a2x);const max_ax=Math.max(a1x,a2x);const min_bx=Math.min(b1x,b2x);const max_bx=Math.max(b1x,b2x);if(max_ax<min_bx||min_ax>max_bx)return false;const min_ay=Math.min(a1y,a2y);const max_ay=Math.max(a1y,a2y);const min_by=Math.min(b1y,b2y);const max_by=Math.max(b1y,b2y);if(max_ay<min_by||min_ay>max_by)return false;const dpx=b1x-a1x+b2x-a2x;const dpy=b1y-a1y+b2y-a2y;const qax=a2x-a1x;const qay=a2y-
a1y;const qbx=b2x-b1x;const qby=b2y-b1y;const d=Math.abs(qay*qbx-qby*qax);const la=qbx*dpy-qby*dpx;if(Math.abs(la)>d)return false;const lb=qax*dpy-qay*dpx;return Math.abs(lb)<=d};
C3.segmentsIntersectPreCalc=function segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,min_ax,max_ax,min_ay,max_ay,b1x,b1y,b2x,b2y){const min_bx=Math.min(b1x,b2x);const max_bx=Math.max(b1x,b2x);if(max_ax<min_bx||min_ax>max_bx)return false;const min_by=Math.min(b1y,b2y);const max_by=Math.max(b1y,b2y);if(max_ay<min_by||min_ay>max_by)return false;const dpx=b1x-a1x+b2x-a2x;const dpy=b1y-a1y+b2y-a2y;const qax=a2x-a1x;const qay=a2y-a1y;const qbx=b2x-b1x;const qby=b2y-b1y;const d=Math.abs(qay*qbx-qby*qax);const la=
qbx*dpy-qby*dpx;if(Math.abs(la)>d)return false;const lb=qax*dpy-qay*dpx;return Math.abs(lb)<=d};
C3.segmentIntersectsQuad=function segmentIntersectsQuad(x1,y1,x2,y2,q){const min_x=Math.min(x1,x2);const max_x=Math.max(x1,x2);const min_y=Math.min(y1,y2);const max_y=Math.max(y1,y2);const tlx=q.getTlx(),tly=q.getTly(),trx=q.getTrx(),try_=q.getTry(),brx=q.getBrx(),bry=q.getBry(),blx=q.getBlx(),bly=q.getBly();return C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,tlx,tly,trx,try_)||C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,trx,try_,brx,bry)||C3.segmentsIntersectPreCalc(x1,
y1,x2,y2,min_x,max_x,min_y,max_y,brx,bry,blx,bly)||C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,blx,bly,tlx,tly)};
C3.segmentIntersectsAnyN=function segmentIntersectsAnyN(x1,y1,x2,y2,points){const min_x=Math.min(x1,x2);const max_x=Math.max(x1,x2);const min_y=Math.min(y1,y2);const max_y=Math.max(y1,y2);let i=0;for(let last=points.length-4;i<=last;i+=2)if(C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,points[i],points[i+1],points[i+2],points[i+3]))return true;return C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,points[i],points[i+1],points[0],points[1])};const NO_HIT=2;
const PADDING=1E-6;C3.rayIntersect=function rayIntersect(rx1,ry1,rx2,ry2,sx1,sy1,sx2,sy2){const rdx=rx2-rx1;const rdy=ry2-ry1;const sdx=sx2-sx1;const sdy=sy2-sy1;const det=rdx*sdy-rdy*sdx;if(det===0)return NO_HIT;const gamma=((ry1-ry2)*(sx2-rx1)+rdx*(sy2-ry1))/det;if(0<gamma&&gamma<1+PADDING)return(sdy*(sx2-rx1)+(sx1-sx2)*(sy2-ry1))/det;return NO_HIT};
C3.rayIntersectExtended=function rayIntersect(rx1,ry1,rx2,ry2,sx1,sy1,sx2,sy2,f){const dx=(sx2-sx1)*f;const dy=(sy2-sy1)*f;return C3.rayIntersect(rx1,ry1,rx2,ry2,sx1-dx,sy1-dy,sx2+dx,sy2+dy)};
C3.isPointInTriangleInclusive=function isPointInTriangleInclusive(px,py,tx1,ty1,tx2,ty2,tx3,ty3){const v0x=tx2-tx1;const v0y=ty2-ty1;const v1x=tx3-tx1;const v1y=ty3-ty1;const v2x=px-tx1;const v2y=py-ty1;const dot00=v0x*v0x+v0y*v0y;const dot01=v0x*v1x+v0y*v1y;const dot02=v0x*v2x+v0y*v2y;const dot11=v1x*v1x+v1y*v1y;const dot12=v1x*v2x+v1y*v2y;const invDenom=1/(dot00*dot11-dot01*dot01);const u=(dot11*dot02-dot01*dot12)*invDenom;const v=(dot00*dot12-dot01*dot02)*invDenom;return u>=0&&v>=0&&u+v<=1};
C3.triangleCartesianToBarycentric=function triangleCartesianToBarycentric(px,py,tx1,ty1,tx2,ty2,tx3,ty3){const v0x=tx2-tx1;const v0y=ty2-ty1;const v1x=tx3-tx1;const v1y=ty3-ty1;const v2x=px-tx1;const v2y=py-ty1;const dot00=v0x*v0x+v0y*v0y;const dot01=v0x*v1x+v0y*v1y;const dot11=v1x*v1x+v1y*v1y;const dot20=v2x*v0x+v2y*v0y;const dot21=v2x*v1x+v2y*v1y;const denom=dot00*dot11-dot01*dot01;const v=(dot11*dot20-dot01*dot21)/denom;const w=(dot00*dot21-dot01*dot20)/denom;const u=1-v-w;return[u,v,w]};
C3.triangleBarycentricToCartesian3d=function triangleBarycentricToCartesian3d(u,v,w,tx1,ty1,tz1,tx2,ty2,tz2,tx3,ty3,tz3){return[u*tx1+v*tx2+w*tx3,u*ty1+v*ty2+w*ty3,u*tz1+v*tz2+w*tz3]};

}

// ../lib/misc/miscutil.js
{
'use strict';const C3=self.C3;let mainDocument=null;let baseHref="";if(typeof document!=="undefined"){mainDocument=document;const baseElem=document.querySelector("base");baseHref=baseElem&&baseElem.hasAttribute("href")?baseElem.getAttribute("href"):"";if(baseHref){if(baseHref.startsWith("/"))baseHref=baseHref.substr(1);if(!baseHref.endsWith("/"))baseHref+="/"}}C3.GetBaseHref=function GetBaseHref(){return baseHref};
C3.GetBaseURL=function GetBaseURL(){if(!mainDocument)return"";const loc=mainDocument.location;return C3.GetPathFromURL(loc.origin+loc.pathname)+baseHref};C3.GetPathFromURL=function GetPathFromURL(url){if(!url.length)return url;if(url.endsWith("/")||url.endsWith("\\"))return url;const lastSlash=Math.max(url.lastIndexOf("/"),url.lastIndexOf("\\"));if(lastSlash===-1)return"";return url.substr(0,lastSlash+1)};
C3.GetFilenameFromURL=function GetFilenameFromURL(url){if(!url.length)return url;if(url.endsWith("/")||url.endsWith("\\"))return"";const lastSlash=Math.max(url.lastIndexOf("/"),url.lastIndexOf("\\"));if(lastSlash===-1)return url;return url.substr(lastSlash+1)};C3.GetFileExtension=function GetFileExtension(filename){let i=filename.lastIndexOf(".");if(i<1)return"";else return filename.substr(i)};
C3.SetFileExtension=function SetFileExtension(filename,newExt){const i=filename.lastIndexOf(".");if(i===-1)return filename+"."+newExt;else return filename.substr(0,i+1)+newExt};C3.GetFileNamePart=function GetFileNamePart(filename){let i=filename.lastIndexOf(".");if(i<1)return filename;else return filename.substr(0,i)};C3.NormalizeFileSeparator=function NormalizeFileSeparator(path){return path.replace(/\\/g,"/")};
C3.IsFileExtension=function IsFileExtension(filename,extension){const ext=filename?C3.GetFileExtension(filename).slice(1):"";return extension===ext};
C3.FileNameEquals=function FileNameEquals(file_or_filename,other_file_or_filename){let firstName;let secondName;if(C3.IsFileLike(file_or_filename))firstName=C3.GetFileNamePart(file_or_filename["name"]);if(C3.IsString(file_or_filename))firstName=C3.GetFileNamePart(file_or_filename);if(C3.IsFileLike(other_file_or_filename))secondName=C3.GetFileNamePart(other_file_or_filename["name"]);if(C3.IsString(other_file_or_filename))secondName=C3.GetFileNamePart(other_file_or_filename);return firstName===secondName};
C3.ParseFilePath=function ParseFilePath(path){path=C3.NormalizeFileSeparator(path);let root=/^\w:\//.exec(path);if(root){root=root[0];path=path.slice(3);if(path[0]!=="/")path="/"+path}else root="";path=path.replace(/\/{2,}/g,"/");if(path.length>1&&path.slice(-1)==="/")path=path.slice(0,-1);const start=path.lastIndexOf("/")+1;let dir="",base=path,name,ext="";if(start>0){dir=path.slice(0,start);base=path.slice(start)}name=base;const end=base.lastIndexOf(".");if(end>0){ext=base.slice(end);name=base.slice(0,
-ext.length)}const full=root+dir+base;return{dir,base,name,root,ext,full}};C3.Wait=function Wait(delay,argument){return new Promise((resolve,reject)=>{self.setTimeout(resolve,delay,argument)})};C3.swallowException=function swallowException(f){try{f()}catch(e){if(C3.isDebug)console.warn("Swallowed exception: ",e)}};C3.noop=function noop(){};C3.equalsNoCase=function equalsNoCase(a,b){if(typeof a!=="string"||typeof b!=="string")return false;return a===b||a.normalize().toLowerCase()===b.normalize().toLowerCase()};
C3.equalsCase=function equalsCase(a,b){if(typeof a!=="string"||typeof b!=="string")return false;if(a===b)return true;return a.normalize()===b.normalize()};C3.typedArraySet16=function typedArraySet16(dest,src,i){dest[i++]=src[0];dest[i++]=src[1];dest[i++]=src[2];dest[i++]=src[3];dest[i++]=src[4];dest[i++]=src[5];dest[i++]=src[6];dest[i++]=src[7];dest[i++]=src[8];dest[i++]=src[9];dest[i++]=src[10];dest[i++]=src[11];dest[i++]=src[12];dest[i++]=src[13];dest[i++]=src[14];dest[i]=src[15]};
C3.truncateArray=function truncateArray(arr,index){arr.length=index};C3.clearArray=function clearArray(arr){if(!arr)return;if(arr.length===0)return;C3.truncateArray(arr,0)};C3.clear2DArray=function clear2DArray(arr){if(!arr)return;for(let i=0;i<arr.length;i++){let a=arr[i];C3.truncateArray(a,0)}C3.truncateArray(arr,0)};C3.extendArray=function extendArray(arr,len,filler){len=len|0;const arrayLength=arr.length;if(len<=arrayLength)return;for(let i=arrayLength;i<len;++i)arr.push(filler)};
C3.resizeArray=function resizeArray(arr,len,filler){len=len|0;const arrayLength=arr.length;if(len<arrayLength)C3.truncateArray(arr,len);else if(len>arrayLength)C3.extendArray(arr,len,filler)};C3.shallowAssignArray=function shallowAssignArray(dest,src){C3.clearArray(dest);C3.appendArray(dest,src)};C3.appendArray=function appendArray(a,b){if(b.length<1E4)a.push(...b);else for(let i=0,len=b.length;i<len;++i)a.push(b[i])};
C3.arrayRemove=function(arr,index){index=Math.floor(index);if(index<0||index>=arr.length)return;let len=arr.length-1;for(let i=index;i<len;++i)arr[i]=arr[i+1];C3.truncateArray(arr,len)};C3.arrayFindRemove=function arrayFindRemove(a,o){let i=a.indexOf(o);if(i>=0)a.splice(i,1)};C3.arraysEqual=function arraysEqual(a,b){let len=a.length;if(b.length!==len)return false;for(let i=0;i<len;++i)if(a[i]!==b[i])return false;return true};
C3.arrayFilterOut=function arrayFilterOut(arr,callback){let ret=[];let j=0;for(let i=0,len=arr.length;i<len;++i){let item=arr[i];if(callback(item))ret.push(item);else{arr[j]=item;++j}}C3.truncateArray(arr,j);return ret};C3.arrayRemoveAllInSet=function arrayRemoveAllInSet(arr,s){const oldLen=arr.length;let j=0;for(let i=0,len=arr.length;i<len;++i){let item=arr[i];if(!s.has(item))arr[j++]=item}C3.truncateArray(arr,j);return oldLen-j};
C3.isArrayIndexInBounds=function isArrayIndexInBounds(index,array){if(index!==Math.floor(index))return false;return index>=0&&index<array.length};C3.validateArrayIndex=function validateArrayIndex(index,array){if(!C3.isArrayIndexInBounds(index,array))throw new RangeError("array index out of bounds");};C3.cloneArray=function cloneArray(array){return array.slice()};
C3.deepCloneArray=function deepCloneArray(array,f){let ret=[];for(let e of array)if(C3.IsObject(e)){let clone=f(e);if(!clone)throw new Error("missing clone");if(clone.constructor!==e.constructor)throw new Error("object is not a clone");ret.push(clone)}else if(C3.IsArray(e))ret.push(C3.deepCloneArray(e,f));else ret.push(e);return ret};C3.clone2DArray=function cloneArray(array){let ret=[];for(let arr of array)ret.push(arr.slice());return ret};
C3.mergeSets=function mergeSets(set1,set2){return new Set([...set1,...set2])};C3.mergeSetsInPlace=function mergeSetsInPlace(set1,set2){for(const item of set2)set1.add(item);return set1};C3.first=function first(iterable){for(let i of iterable)return i;return null};C3.xor=function(x,y){return!x!==!y};C3.compare=function compare(x,cmp,y){switch(cmp){case 0:return x===y;case 1:return x!==y;case 2:return x<y;case 3:return x<=y;case 4:return x>y;case 5:return x>=y;default:return false}};
C3.hasAnyOwnProperty=function hasAnyOwnProperty(o){for(let p in o)if(o.hasOwnProperty(p))return true;return false};
C3.PromiseAllWithProgress=function PromiseAllWithProgress(arr,progressCallback){if(!arr.length)return Promise.resolve([]);return new Promise((resolve,reject)=>{const results=[];let numberCompleted=0;let cancelled=false;for(let i=0,len=arr.length;i<len;++i){results.push(void 0);arr[i].then(result=>{if(cancelled)return;results[i]=result;++numberCompleted;if(numberCompleted===arr.length)resolve(results);else progressCallback(numberCompleted,arr.length)}).catch(err=>{cancelled=true;reject(err)})}})};
let memoryCallbacks=[];C3.AddLibraryMemoryCallback=function AddLibraryMemoryCallback(f){memoryCallbacks.push(f)};C3.GetEstimatedLibraryMemoryUsage=function GetEstimatedLibraryMemoryUsage(){let ret=0;for(let f of memoryCallbacks){let m=f();ret+=m}return Math.floor(ret)};let nextTaskId=1;const activeTaskIds=new Map;const taskMessageChannel=new MessageChannel;taskMessageChannel.port2.onmessage=function OnTask(e){const id=e.data;const callback=activeTaskIds.get(id);activeTaskIds.delete(id);if(callback)callback(performance.now())};
C3.RequestUnlimitedAnimationFrame=function RequestUnlimitedAnimationFrame(callback){const id=nextTaskId++;activeTaskIds.set(id,callback);taskMessageChannel.port1.postMessage(id);return id};C3.CancelUnlimitedAnimationFrame=function CancelUnlimitedAnimationFrame(id){activeTaskIds.delete(id)};C3.PostTask=C3.RequestUnlimitedAnimationFrame;C3.WaitForNextTask=function WaitForNextTask(){return new Promise(resolve=>C3.PostTask(resolve))};const activeRPAFids=new Set;
C3.RequestPostAnimationFrame=function RequestPostAnimationFrame(callback){const id=self.requestAnimationFrame(async timestamp=>{await C3.WaitForNextTask();if(!activeRPAFids.has(id))return;activeRPAFids.delete(id);callback(timestamp)});activeRPAFids.add(id);return id};C3.CancelPostAnimationFrame=function CancelPostAnimationFrame(id){if(!activeRPAFids.has(id))return;self.cancelAnimationFrame(id);activeRPAFids.delete(id)};

}

// lib/misc/runtimeutil.js
{
'use strict';const C3=self.C3;C3.IsAbsoluteURL=function IsAbsoluteURL(url){return/^(?:[a-z\-]+:)?\/\//.test(url)||url.substr(0,5)==="data:"||url.substr(0,5)==="blob:"};C3.IsRelativeURL=function IsRelativeURL(url){return!C3.IsAbsoluteURL(url)};C3.ThrowIfNotOk=function ThrowIfNotOk(response){if(!response.ok)throw new Error(`fetch '${response.url}' response returned ${response.status} ${response.statusText}`);};
C3.FetchOk=function FetchOk(url,init){return fetch(url,init).then(response=>{C3.ThrowIfNotOk(response);return response})};C3.FetchText=function FetchText(url){return C3.FetchOk(url).then(response=>response.text())};C3.FetchJson=function FetchJson(url){return C3.FetchOk(url).then(response=>response.json())};C3.FetchBlob=function FetchBlob(url){return C3.FetchOk(url).then(response=>response.blob())};C3.FetchArrayBuffer=function FetchArrayBuffer(url){return C3.FetchOk(url).then(response=>response.arrayBuffer())};
C3.FetchImage=function FetchImage(url){return new Promise((resolve,reject)=>{const img=new Image;img.onload=()=>resolve(img);img.onerror=err=>reject(err);img.src=url})};C3.BlobToArrayBuffer=function BlobToArrayBuffer(blob){if(typeof blob["arrayBuffer"]==="function")return blob["arrayBuffer"]();else return new Promise((resolve,reject)=>{const fileReader=new FileReader;fileReader.onload=()=>resolve(fileReader.result);fileReader.onerror=()=>reject(fileReader.error);fileReader.readAsArrayBuffer(blob)})};
C3.BlobToString=function BlobToString(blob){if(typeof blob["text"]==="function")return blob["text"]();else return new Promise((resolve,reject)=>{const fileReader=new FileReader;fileReader.onload=()=>resolve(fileReader.result);fileReader.onerror=()=>reject(fileReader.error);fileReader.readAsText(blob)})};C3.BlobToJson=function BlobToJson(blob){return C3.BlobToString(blob).then(text=>JSON.parse(text))};
C3.BlobToImage=async function BlobToImage(blob,decodeImage){let blobUrl=URL.createObjectURL(blob);try{const img=await C3.FetchImage(blobUrl);URL.revokeObjectURL(blobUrl);blobUrl="";if(decodeImage&&typeof img["decode"]==="function")await img["decode"]();return img}finally{if(blobUrl)URL.revokeObjectURL(blobUrl)}};
C3.CreateCanvas=function CreateCanvas(width,height){if(typeof document!=="undefined"&&typeof document.createElement==="function"){const canvas=document.createElement("canvas");canvas.width=width;canvas.height=height;return canvas}else return new OffscreenCanvas(width,height)};
C3.CanvasToBlob=function CanvasToBlob(canvas,type,quality){if(typeof quality!=="number")quality=1;type=type||"image/png";quality=C3.clamp(quality,0,1);if(canvas.toBlob)return new Promise(resolve=>canvas.toBlob(resolve,type,quality));else if(canvas["convertToBlob"])return canvas["convertToBlob"]({"type":type,"quality":quality});else throw new Error("could not convert canvas to blob");};
C3.DrawableToBlob=function DrawableToBlob(drawable,type,quality){const canvas=C3.CreateCanvas(drawable.width,drawable.height);const ctx=canvas.getContext("2d");ctx.drawImage(drawable,0,0);return C3.CanvasToBlob(canvas,type,quality)};
C3.ImageDataToBlob=function ImageDataToBlob(imageData,type,quality){if(C3.Supports.ImageBitmapOptions)return createImageBitmap(imageData,{"premultiplyAlpha":"none"}).then(imageBitmap=>C3.DrawableToBlob(imageBitmap,type,quality));else if(C3.Supports.ImageBitmap)return createImageBitmap(imageData).then(imageBitmap=>C3.DrawableToBlob(imageBitmap,type,quality));else{const canvas=C3.CreateCanvas(imageData.width,imageData.height);const ctx=canvas.getContext("2d");ctx.putImageData(imageData,0,0);return C3.CanvasToBlob(canvas,
type,quality)}};C3.CopySet=function CopySet(dest,src){dest.clear();for(const x of src)dest.add(x)};C3.MapToObject=function MapToObject(map){const ret=Object.create(null);for(const [k,v]of map.entries())ret[k]=v;return ret};C3.ObjectToMap=function ObjectToMap(o,map){map.clear();for(const [k,v]of Object.entries(o))map.set(k,v)};
C3.ToSuperJSON=function ToSuperJSON(v){if(typeof v==="object"&&v!==null)if(v instanceof Set)return{"_c3type_":"set","data":[...v].map(o=>ToSuperJSON(o))};else if(v instanceof Map)return{"_c3type_":"map","data":[...v].map(pair=>[pair[0],ToSuperJSON(pair[1])])};else{const ret=Object.create(null);for(const [key,value]of Object.entries(v))ret[key]=ToSuperJSON(value);return ret}return v};
C3.FromSuperJSON=function FromSuperJSON(v){if(typeof v==="object"&v!==null)if(v["_c3type_"]==="set")return new Set(v["data"].map(o=>FromSuperJSON(o)));else if(v["_c3type_"]==="map")return new Map(v["data"].map(pair=>[pair[0],FromSuperJSON(pair[1])]));else{const ret=Object.create(null);for(const [key,value]of Object.entries(v))ret[key]=FromSuperJSON(value);return ret}return v};
C3.CSSToCamelCase=function(str){if(str.startsWith("--"))return str;let ret="";let isAfterHyphen=false;for(const ch of str)if(ch==="-")isAfterHyphen=true;else if(isAfterHyphen){ret+=ch.toUpperCase();isAfterHyphen=false}else ret+=ch;return ret};C3.IsIterator=function(o){return typeof o==="object"&&typeof o.next==="function"};
C3.MakeFilledArray=function MakeFilledArray(len,data){const ret=[];if(typeof data==="function")for(let i=0;i<len;++i)ret.push(data());else for(let i=0;i<len;++i)ret.push(data);return ret};

}

// ../lib/misc/color.js
{
'use strict';const C3=self.C3;const HSL_TEST=/([0-9.]+),([0-9.]+)%?,([0-9.]+)%?/i;const HSLA_TEST=/([0-9.]+),([0-9.]+)%?,([0-9.]+)%?,([0-9.])/i;function padTwoDigits(str){if(str.length===0)return"00";else if(str.length===1)return"0"+str;else return str}function hueToRGB(p,q,t){if(t<0)t+=1;if(t>1)t-=1;if(t<1/6)return p+(q-p)*6*t;if(t<1/2)return q;if(t<2/3)return p+(q-p)*(2/3-t)*6;return p}
C3.Color=class Color{constructor(r,g,b,a){this._r=NaN;this._g=NaN;this._b=NaN;this._a=NaN;this._r=0;this._g=0;this._b=0;this._a=0;if(r instanceof C3.Color)this.set(r);else this.setRgba(r||0,g||0,b||0,a||0)}setRgb(r,g,b){this._r=+r;this._g=+g;this._b=+b;this.clamp();return this}setRgba(r,g,b,a){this._r=+r;this._g=+g;this._b=+b;this._a=+a;this.clamp();return this}set(c){this._r=c._r;this._g=c._g;this._b=c._b;this._a=c._a;return this}copy(c){return this.set(c)}add(c){this._r+=c._r;this._g+=c._g;this._b+=
c._b;this._a+=c._a;this.clamp()}addRgb(r,g,b,a=0){this._r+=+r;this._g+=+g;this._b+=+b;this._a+=+a;this.clamp()}diff(c){this.setR(Math.max(this._r,c._r)-Math.min(this._r,c._r));this.setG(Math.max(this._g,c._g)-Math.min(this._g,c._g));this.setB(Math.max(this._b,c._b)-Math.min(this._b,c._b));this.setA(Math.max(this._a,c._a)-Math.min(this._a,c._a));this.clamp()}copyRgb(c){this._r=c._r;this._g=c._g;this._b=c._b}setR(r){this._r=C3.clamp(+r,0,1)}getR(){return this._r}setG(g){this._g=C3.clamp(+g,0,1)}getG(){return this._g}setB(b){this._b=
C3.clamp(+b,0,1)}getB(){return this._b}setA(a){this._a=C3.clamp(+a,0,1)}getA(){return this._a}clone(){return C3.New(C3.Color,this._r,this._g,this._b,this._a)}toArray(){return[this._r,this._g,this._b,this._a]}toTypedArray(){return new Float64Array(this.toArray())}writeToTypedArray(ta,i){ta[i++]=this._r;ta[i++]=this._g;ta[i++]=this._b;ta[i]=this._a}writeRGBToTypedArray(ta,i){ta[i++]=this._r;ta[i++]=this._g;ta[i]=this._b}equals(c){return this._r===c._r&&this._g===c._g&&this._b===c._b&&this._a===c._a}equalsIgnoringAlpha(c){return this._r===
c._r&&this._g===c._g&&this._b===c._b}equalsRgb(r,g,b){return this._r===r&&this._g===g&&this._b===b}equalsRgba(r,g,b,a){return this._r===r&&this._g===g&&this._b===b&&this._a===a}equalsF32Array(arr,offset){return arr[offset]===Math.fround(this._r)&&arr[offset+1]===Math.fround(this._g)&&arr[offset+2]===Math.fround(this._b)&&arr[offset+3]===Math.fround(this._a)}equalsRGBF32Array(arr,offset){return arr[offset]===Math.fround(this._r)&&arr[offset+1]===Math.fround(this._g)&&arr[offset+2]===Math.fround(this._b)}multiply(c){this._r*=
c._r;this._g*=c._g;this._b*=c._b;this._a*=c._a}multiplyAlpha(a){this._r*=a;this._g*=a;this._b*=a;this._a*=a}premultiply(){this._r*=this._a;this._g*=this._a;this._b*=this._a;return this}unpremultiply(){this._r/=this._a;this._g/=this._a;this._b/=this._a;return this}clamp(){this._r=C3.clamp(this._r,0,1);this._g=C3.clamp(this._g,0,1);this._b=C3.clamp(this._b,0,1);this._a=C3.clamp(this._a,0,1);return this}setFromRgbValue(rgb){this._r=C3.GetRValue(rgb);this._g=C3.GetGValue(rgb);this._b=C3.GetBValue(rgb);
this._a=C3.GetAValue(rgb)}getCssRgb(_r,_g,_b){const r=C3.IsFiniteNumber(_r)?_r:this.getR();const g=C3.IsFiniteNumber(_g)?_g:this.getG();const b=C3.IsFiniteNumber(_b)?_b:this.getB();return`rgb(${r*100}%, ${g*100}%, ${b*100}%)`}getCssRgba(_r,_g,_b,_a){const r=C3.IsFiniteNumber(_r)?_r:this.getR();const g=C3.IsFiniteNumber(_g)?_g:this.getG();const b=C3.IsFiniteNumber(_b)?_b:this.getB();const a=C3.IsFiniteNumber(_a)?_a:this.getA();return`rgba(${r*100}%, ${g*100}%, ${b*100}%, ${a})`}toHexString(){const rh=
Math.round(this.getR()*255);const gh=Math.round(this.getG()*255);const bh=Math.round(this.getB()*255);return"#"+padTwoDigits(rh.toString(16))+padTwoDigits(gh.toString(16))+padTwoDigits(bh.toString(16))}parseHexString(str){if(typeof str!=="string")return false;str=str.trim();if(str.charAt(0)==="#")str=str.substr(1);let rv;let gv;let bv;if(str.length===3){rv=parseInt(str[0],16)/15;gv=parseInt(str[1],16)/15;bv=parseInt(str[2],16)/15}else if(str.length===6){rv=parseInt(str.substr(0,2),16)/255;gv=parseInt(str.substr(2,
2),16)/255;bv=parseInt(str.substr(4,2),16)/255}else return false;if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);this.setA(1);return true}toCommaSeparatedRgb(){const rv=Math.round(this.getR()*255);const gv=Math.round(this.getG()*255);const bv=Math.round(this.getB()*255);return`${rv}, ${gv}, ${bv}`}toRgbArray(){const rv=Math.round(this.getR()*255);const gv=Math.round(this.getG()*255);const bv=Math.round(this.getB()*255);return[rv,gv,bv]}parseCommaSeparatedRgb(str){if(typeof str!==
"string")return false;str=str.replace(/^rgb\(|\)|%/,"");const arr=str.split(",");if(arr.length<3)return false;const rv=parseInt(arr[0].trim(),10)/255;const gv=parseInt(arr[1].trim(),10)/255;const bv=parseInt(arr[2].trim(),10)/255;if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);this.setA(1);return true}parseCommaSeparatedPercentageRgb(str){if(typeof str!=="string")return false;str=str.replace(/^rgb\(|\)|%/,"");const arr=str.split(",");if(arr.length<3)return false;
const rv=parseInt(arr[0].trim(),10)/100;const gv=parseInt(arr[1].trim(),10)/100;const bv=parseInt(arr[2].trim(),10)/100;if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);this.setA(1);return true}parseCommaSeparatedRgba(str){if(typeof str!=="string")return false;str=str.replace(/^rgba\(|\)|%/,"");const arr=str.split(",");if(arr.length<4)return false;const rv=parseInt(arr[0].trim(),10)/255;const gv=parseInt(arr[1].trim(),10)/255;const bv=parseInt(arr[2].trim(),
10)/255;const av=parseFloat(arr[3].trim());if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);if(isFinite(av))this.setA(av);return true}parseCommaSeparatedPercentageRgba(str){if(typeof str!=="string")return false;str=str.replace(/^rgba\(|\)|%/,"");const arr=str.split(",");if(arr.length<4)return false;const rv=parseInt(arr[0].trim(),10)/100;const gv=parseInt(arr[1].trim(),10)/100;const bv=parseInt(arr[2].trim(),10)/100;const av=parseFloat(arr[3].trim());if(isFinite(rv))this.setR(rv);
if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);if(isFinite(av))this.setA(av);return true}parseString(str){if(typeof str!=="string")return false;str=str.replace(/\s+/,"");if(str.includes(","))if(str.startsWith("rgb("))if(str.includes("%"))return this.parseCommaSeparatedPercentageRgb(str);else return this.parseCommaSeparatedRgb(str);else if(str.startsWith("rgba("))if(str.includes("%"))return this.parseCommaSeparatedPercentageRgba(str);else return this.parseCommaSeparatedRgba(str);else if(str.startsWith("hsl(")||
str.startsWith("hsla("))return this.parseHSLString(str);else{const components=str.split(",");if(str.includes("%")){if(components.length===3)return this.parseCommaSeparatedPercentageRgb(str);else if(components.length===4)return this.parseCommaSeparatedPercentageRgba(str);return false}else{if(components.length===3)return this.parseCommaSeparatedRgb(str);else if(components.length===4)return this.parseCommaSeparatedRgba(str);return false}}else return this.parseHexString(str)}toJSON(){return[this._r,this._g,
this._b,this._a]}setFromHSLA(h,s,l,a){let r;let g;let b;h%=360;s=C3.clamp(s,0,100);l=C3.clamp(l,0,100);a=C3.clamp(a,0,1);h/=360;s/=100;l/=100;if(s===0)r=g=b=l;else{const q=l<.5?l*(1+s):l+s-l*s;const p=2*l-q;r=hueToRGB(p,q,h+1/3);g=hueToRGB(p,q,h);b=hueToRGB(p,q,h-1/3)}this.setR(r);this.setG(g);this.setB(b);this.setA(a);return this}parseHSLString(str){const cleanString=str.replace(/ |hsl|hsla|\(|\)|;/gi,"");const hsl=HSL_TEST.exec(cleanString);const hsla=HSLA_TEST.exec(cleanString);if(hsl&&hsl.length===
4){this.setFromHSLA(+hsl[1],+hsl[2],+hsl[3],1);return true}else if(hsla&&hsla.length===5){this.setFromHSLA(+hsl[1],+hsl[2],+hsl[3],+hsl[4]);return true}return false}toHSLAString(){const r=this._r;const g=this._g;const b=this._b;const a=this._a;const h=C3.Color.GetHue(r,g,b);const s=C3.Color.GetSaturation(r,g,b);const l=C3.Color.GetLuminosity(r,g,b);return`hsla(${h}, ${s}%, ${l}%, ${a})`}toHSLAArray(){const r=this._r;const g=this._g;const b=this._b;return[C3.Color.GetHue(r,g,b),C3.Color.GetSaturation(r,
g,b),C3.Color.GetLuminosity(r,g,b),this._a]}setFromJSON(arr){if(!Array.isArray(arr))return;if(arr.length<3)return;this._r=arr[0];this._g=arr[1];this._b=arr[2];if(arr.length>=4)this._a=arr[3];else this._a=1}set r(r){this.setR(r)}get r(){return this.getR()}set g(g){this.setG(g)}get g(){return this.getG()}set b(b){this.setB(b)}get b(){return this.getB()}set a(a){this.setA(a)}get a(){return this.getA()}setAtIndex(i,v){switch(i){case 0:this.setR(v);break;case 1:this.setG(v);break;case 2:this.setB(v);break;
case 3:this.setA(v);break;default:throw new RangeError("invalid color index");}}getAtIndex(i){switch(i){case 0:return this.getR();case 1:return this.getG();case 2:return this.getB();case 3:return this.getA();default:throw new RangeError("invalid color index");}}static Equals(color_or_json_1,color_or_json_2){let c1;let c2;if(Array.isArray(color_or_json_1)){c1=new C3.Color;c1.setFromJSON(color_or_json_1)}else if(color_or_json_1 instanceof C3.Color)c1=color_or_json_1;else throw new Error("unexpected type");
if(Array.isArray(color_or_json_2)){c2=new C3.Color;c2.setFromJSON(color_or_json_2)}else if(color_or_json_2 instanceof C3.Color)c2=color_or_json_2;else throw new Error("unexpected type");return c1.equals(c2)}static DiffChannel(channel1,channel2){return C3.clamp(Math.max(channel1,channel2)-Math.min(channel1,channel2),0,1)}static Diff(c1,c2){const ret=new C3.Color;ret.setR(Math.max(c1._r,c2._r)-Math.min(c1._r,c2._r));ret.setG(Math.max(c1._g,c2._g)-Math.min(c1._g,c2._g));ret.setB(Math.max(c1._b,c2._b)-
Math.min(c1._b,c2._b));ret.setA(Math.max(c1._a,c2._a)-Math.min(c1._a,c2._a));return ret}static DiffNoAlpha(c1,c2){const ret=new C3.Color(0,0,0,1);ret.setR(Math.max(c1._r,c2._r)-Math.min(c1._r,c2._r));ret.setG(Math.max(c1._g,c2._g)-Math.min(c1._g,c2._g));ret.setB(Math.max(c1._b,c2._b)-Math.min(c1._b,c2._b));return ret}static GetHue(r,g,b){const max=Math.max(r,g,b);const min=Math.min(r,g,b);if(max===min)return 0;let h=0;switch(max){case r:h=(g-b)/(max-min)+(g<b?6:0);break;case g:h=(b-r)/(max-min)+2;
break;case b:h=(r-g)/(max-min)+4;break}return Math.round(h/6*360)}static GetSaturation(r,g,b){const max=Math.max(r,g,b);const min=Math.min(r,g,b);if(max===min)return 0;const l=(max+min)/2;const d=max-min;const s=l>.5?d/(2-max-min):d/(max+min);return Math.round(s*100)}static GetLuminosity(r,g,b){const max=Math.max(r,g,b);const min=Math.min(r,g,b);const l=(max+min)/2;if(!max)return 0;return Math.round(l*100)}};C3.Color.White=Object.freeze(C3.New(C3.Color,1,1,1,1));
C3.Color.Black=Object.freeze(C3.New(C3.Color,0,0,0,1));C3.Color.TransparentBlack=Object.freeze(C3.New(C3.Color,0,0,0,0));

}

// ../lib/misc/vector2.js
{
'use strict';const C3=self.C3;
C3.Vector2=class Vector2{constructor(x,y){this._x=0;this._y=0;if(x instanceof C3.Vector2)this.copy(x);else this.set(x||0,y||0)}set(x,y){this._x=+x;this._y=+y}copy(v){this._x=v._x;this._y=v._y}equals(v){return this._x===v._x&&this._y===v._y}equalsValues(x,y){return this._x===x&&this._y===y}equalsF32Array(arr,offset){return arr[offset]===Math.fround(this._x)&&arr[offset+1]===Math.fround(this._y)}setX(x){this._x=+x}getX(){return this._x}setY(y){this._y=+y}getY(){return this._y}toArray(){return[this._x,this._y]}toTypedArray(){return new Float64Array(this.toArray())}writeToTypedArray(ta,
i){ta[i++]=this._x;ta[i]=this._y}offset(x,y){this._x+=+x;this._y+=+y}scale(x,y){this._x*=x;this._y*=y}divide(x,y){this._x/=x;this._y/=y}round(){this._x=Math.round(this._x);this._y=Math.round(this._y)}floor(){this._x=Math.floor(this._x);this._y=Math.floor(this._y)}ceil(){this._x=Math.ceil(this._x);this._y=Math.ceil(this._y)}angle(){return C3.angleTo(0,0,this._x,this._y)}lengthSquared(){return this._x*this._x+this._y*this._y}length(){return Math.hypot(this._x,this._y)}rotatePrecalc(sin_a,cos_a){const temp=
this._x*cos_a-this._y*sin_a;this._y=this._y*cos_a+this._x*sin_a;this._x=temp}rotate(a){if(a===0)return;this.rotatePrecalc(Math.sin(a),Math.cos(a))}rotateAbout(a,x,y){if(a===0||x===this._x&&y===this._y)return;this._x-=x;this._y-=y;this.rotatePrecalc(Math.sin(a),Math.cos(a));this._x+=+x;this._y+=+y}move(a,dist){if(dist===0)return;this._x+=Math.cos(a)*dist;this._y+=Math.sin(a)*dist}normalize(){const m=this.length();if(m!==0&&m!==1){this._x/=m;this._y/=m}}clamp(lower,upper){this._x=C3.clamp(this._x,lower,
upper);this._y=C3.clamp(this._y,lower,upper)}};

}

// ../lib/misc/rect.js
{
'use strict';const C3=self.C3;
C3.Rect=class Rect{constructor(left,top,right,bottom){this._left=NaN;this._top=NaN;this._right=NaN;this._bottom=NaN;this._left=0;this._top=0;this._right=0;this._bottom=0;if(left instanceof C3.Rect)this.copy(left);else this.set(left||0,top||0,right||0,bottom||0)}set(left,top,right,bottom){this._left=+left;this._top=+top;this._right=+right;this._bottom=+bottom}setWH(left,top,width,height){left=+left;top=+top;this._left=left;this._top=top;this._right=left+ +width;this._bottom=top+ +height}copy(rect){this._left=
+rect._left;this._top=+rect._top;this._right=+rect._right;this._bottom=+rect._bottom}clone(){return new C3.Rect(this._left,this._top,this._right,this._bottom)}static Merge(first,second){const ret=new C3.Rect;ret.setLeft(Math.min(first._left,second._left));ret.setTop(Math.min(first._top,second._top));ret.setRight(Math.max(first._right,second._right));ret.setBottom(Math.max(first._bottom,second._bottom));return ret}static FromObject(o){return new C3.Rect(o.left,o.top,o.right,o.bottom)}equals(rect){return this._left===
rect._left&&this._top===rect._top&&this._right===rect._right&&this._bottom===rect._bottom}equalsWH(x,y,w,h){return this._left===x&&this._top===y&&this.width()===w&&this.height()===h}equalsF32Array(arr,offset){return arr[offset]===Math.fround(this._left)&&arr[offset+1]===Math.fround(this._top)&&arr[offset+2]===Math.fround(this._right)&&arr[offset+3]===Math.fround(this._bottom)}setLeft(l){this._left=+l}getLeft(){return this._left}setTop(t){this._top=+t}getTop(){return this._top}setRight(r){this._right=
+r}getRight(){return this._right}setBottom(b){this._bottom=+b}getBottom(){return this._bottom}toArray(){return[this._left,this._top,this._right,this._bottom]}toTypedArray(){return new Float64Array(this.toArray())}toDOMRect(){return new DOMRect(this._left,this._top,this.width(),this.height())}writeToTypedArray(ta,i){ta[i++]=this._left;ta[i++]=this._top;ta[i++]=this._right;ta[i]=this._bottom}writeAsQuadToTypedArray(ta,i){ta[i++]=this._left;ta[i++]=this._top;ta[i++]=this._right;ta[i++]=this._top;ta[i++]=
this._right;ta[i++]=this._bottom;ta[i++]=this._left;ta[i]=this._bottom}writeAsQuadToTypedArray3D(ta,i,z){ta[i++]=this._left;ta[i++]=this._top;ta[i++]=z;ta[i++]=this._right;ta[i++]=this._top;ta[i++]=z;ta[i++]=this._right;ta[i++]=this._bottom;ta[i++]=z;ta[i++]=this._left;ta[i++]=this._bottom;ta[i]=z}width(){return this._right-this._left}height(){return this._bottom-this._top}midX(){return(this._left+this._right)/2}midY(){return(this._top+this._bottom)/2}offset(x,y){x=+x;y=+y;this._left+=x;this._top+=
y;this._right+=x;this._bottom+=y}offsetLeft(x){this._left+=+x}offsetTop(y){this._top+=+y}offsetRight(x){this._right+=+x}offsetBottom(y){this._bottom+=+y}toSquare(axis){if(axis!=="x")throw new Error("invalid axis, only 'x' supported");if(this._top<this._bottom)if(this._left<this._right)this._bottom=this._top+this.width();else this._bottom=this._top-this.width();else if(this._left<this._right)this._bottom=this._top-this.width();else this._bottom=this._top+this.width()}inflate(x,y){x=+x;y=+y;this._left-=
x;this._top-=y;this._right+=x;this._bottom+=y}deflate(x,y){x=+x;y=+y;this._left+=x;this._top+=y;this._right-=x;this._bottom-=y}multiply(x,y){this._left*=x;this._top*=y;this._right*=x;this._bottom*=y}divide(x,y){this._left/=x;this._top/=y;this._right/=x;this._bottom/=y}mirrorAround(origin){this._left=+origin-this._left;this._right=+origin-this._right}flipAround(origin){this._top=+origin-this._top;this._bottom=+origin-this._bottom}rotate90DegreesAround(normalizedX,normalizedY){const w=this.width();
const h=this.height();const cx=this.getLeft()+w*normalizedX;const cy=this.getTop()+h*normalizedY;this.setWH(cx-h*normalizedY,cy-w*normalizedX,h,w)}swapLeftRight(){const temp=this._left;this._left=this._right;this._right=temp}swapTopBottom(){const temp=this._top;this._top=this._bottom;this._bottom=temp}shuntY(h){const top=this._top;this._top=+h-this._bottom;this._bottom=+h-top}round(){this._left=Math.round(this._left);this._top=Math.round(this._top);this._right=Math.round(this._right);this._bottom=
Math.round(this._bottom)}roundInner(){this._left=Math.ceil(this._left);this._top=Math.ceil(this._top);this._right=Math.floor(this._right);this._bottom=Math.floor(this._bottom)}roundOuter(){this._left=Math.floor(this._left);this._top=Math.floor(this._top);this._right=Math.ceil(this._right);this._bottom=Math.ceil(this._bottom)}floor(){this._left=Math.floor(this._left);this._top=Math.floor(this._top);this._right=Math.floor(this._right);this._bottom=Math.floor(this._bottom)}ceil(){this._left=Math.ceil(this._left);
this._top=Math.ceil(this._top);this._right=Math.ceil(this._right);this._bottom=Math.ceil(this._bottom)}clamp(l,t,r,b){if(this._left<l)this._left=+l;if(this._top<t)this._top=+t;if(this._right>r)this._right=+r;if(this._bottom>b)this._bottom=+b}clampFlipped(l,t,r,b){if(this._left<l)this._left=+l;if(this._top>t)this._top=+t;if(this._right>r)this._right=+r;if(this._bottom<b)this._bottom=+b}normalize(){if(this._left>this._right)this.swapLeftRight();if(this._top>this._bottom)this.swapTopBottom()}intersectsRect(rect){return!(rect._right<
this._left||rect._bottom<this._top||rect._left>this._right||rect._top>this._bottom)}intersectsRectOffset(rect,x,y){return!(rect._right+x<this._left||rect._bottom+y<this._top||rect._left+x>this._right||rect._top+y>this._bottom)}containsPoint(x,y){return x>=this._left&&x<=this._right&&y>=this._top&&y<=this._bottom}containsRect(rect){return rect._left>=this._left&&rect._top>=this._top&&rect._right<=this._right&&rect._bottom<=this._bottom}expandToContain(rect){if(rect._left<this._left)this._left=+rect._left;
if(rect._top<this._top)this._top=+rect._top;if(rect._right>this._right)this._right=+rect._right;if(rect._bottom>this._bottom)this._bottom=+rect._bottom}lerpInto(rect){this._left=C3.lerp(rect._left,rect._right,this._left);this._top=C3.lerp(rect._top,rect._bottom,this._top);this._right=C3.lerp(rect._left,rect._right,this._right);this._bottom=C3.lerp(rect._top,rect._bottom,this._bottom)}};

}

// ../lib/misc/quad.js
{
'use strict';const C3=self.C3;
C3.Quad=class Quad{constructor(tlx,tly,trx,try_,brx,bry,blx,bly){this._tlx=NaN;this._tly=NaN;this._trx=NaN;this._try=NaN;this._brx=NaN;this._bry=NaN;this._blx=NaN;this._bly=NaN;this._tlx=0;this._tly=0;this._trx=0;this._try=0;this._brx=0;this._bry=0;this._blx=0;this._bly=0;if(tlx instanceof C3.Quad)this.copy(tlx);else this.set(tlx||0,tly||0,trx||0,try_||0,brx||0,bry||0,blx||0,bly||0)}set(tlx,tly,trx,try_,brx,bry,blx,bly){this._tlx=+tlx;this._tly=+tly;this._trx=+trx;this._try=+try_;this._brx=+brx;this._bry=
+bry;this._blx=+blx;this._bly=+bly}setRect(left,top,right,bottom){this.set(left,top,right,top,right,bottom,left,bottom)}copy(q){this._tlx=q._tlx;this._tly=q._tly;this._trx=q._trx;this._try=q._try;this._brx=q._brx;this._bry=q._bry;this._blx=q._blx;this._bly=q._bly}equals(q){return this._tlx===q._tlx&&this._tly===q._tly&&this._trx===q._trx&&this._try===q._try&&this._brx===q._brx&&this._bry===q._bry&&this._blx===q._blx&&this._bly===q._bly}setTlx(v){this._tlx=+v}getTlx(){return this._tlx}setTly(v){this._tly=
+v}getTly(){return this._tly}setTrx(v){this._trx=+v}getTrx(){return this._trx}setTry(v){this._try=+v}getTry(){return this._try}setBrx(v){this._brx=+v}getBrx(){return this._brx}setBry(v){this._bry=+v}getBry(){return this._bry}setBlx(v){this._blx=+v}getBlx(){return this._blx}setBly(v){this._bly=+v}getBly(){return this._bly}toDOMQuad(){return new DOMQuad(new DOMPoint(this._tlx,this._tly),new DOMPoint(this._trx,this._try),new DOMPoint(this._brx,this._bry),new DOMPoint(this._blx,this._bly))}toArray(){return[this._tlx,
this._tly,this._trx,this._try,this._brx,this._bry,this._blx,this._bly]}toTypedArray(){return new Float64Array(this.toArray())}writeToTypedArray(ta,i){ta[i++]=this._tlx;ta[i++]=this._tly;ta[i++]=this._trx;ta[i++]=this._try;ta[i++]=this._brx;ta[i++]=this._bry;ta[i++]=this._blx;ta[i]=this._bly}writeToTypedArray3D(ta,i,z){ta[i++]=this._tlx;ta[i++]=this._tly;ta[i++]=z;ta[i++]=this._trx;ta[i++]=this._try;ta[i++]=z;ta[i++]=this._brx;ta[i++]=this._bry;ta[i++]=z;ta[i++]=this._blx;ta[i++]=this._bly;ta[i]=z}offset(x,
y){x=+x;y=+y;this._tlx+=x;this._tly+=y;this._trx+=x;this._try+=y;this._brx+=x;this._bry+=y;this._blx+=x;this._bly+=y}round(){this._tlx=Math.round(this._tlx);this._tly=Math.round(this._tly);this._trx=Math.round(this._trx);this._try=Math.round(this._try);this._brx=Math.round(this._brx);this._bry=Math.round(this._bry);this._blx=Math.round(this._blx);this._bly=Math.round(this._bly)}floor(){this._tlx=Math.floor(this._tlx);this._tly=Math.floor(this._tly);this._trx=Math.floor(this._trx);this._try=Math.floor(this._try);
this._brx=Math.floor(this._brx);this._bry=Math.floor(this._bry);this._blx=Math.floor(this._blx);this._bly=Math.floor(this._bly)}ceil(){this._tlx=Math.ceil(this._tlx);this._tly=Math.ceil(this._tly);this._trx=Math.ceil(this._trx);this._try=Math.ceil(this._try);this._brx=Math.ceil(this._brx);this._bry=Math.ceil(this._bry);this._blx=Math.ceil(this._blx);this._bly=Math.ceil(this._bly)}setFromRect(rect){this._tlx=rect._left;this._tly=rect._top;this._trx=rect._right;this._try=rect._top;this._brx=rect._right;
this._bry=rect._bottom;this._blx=rect._left;this._bly=rect._bottom}setFromRotatedRect(rect,a){if(a===0)this.setFromRect(rect);else this.setFromRotatedRectPrecalc(rect,Math.sin(a),Math.cos(a))}setFromRotatedRectPrecalc(rect,sin_a,cos_a){const left_sin_a=rect._left*sin_a;const top_sin_a=rect._top*sin_a;const right_sin_a=rect._right*sin_a;const bottom_sin_a=rect._bottom*sin_a;const left_cos_a=rect._left*cos_a;const top_cos_a=rect._top*cos_a;const right_cos_a=rect._right*cos_a;const bottom_cos_a=rect._bottom*
cos_a;this._tlx=left_cos_a-top_sin_a;this._tly=top_cos_a+left_sin_a;this._trx=right_cos_a-top_sin_a;this._try=top_cos_a+right_sin_a;this._brx=right_cos_a-bottom_sin_a;this._bry=bottom_cos_a+right_sin_a;this._blx=left_cos_a-bottom_sin_a;this._bly=bottom_cos_a+left_sin_a}getBoundingBox(rect){rect.set(Math.min(this._tlx,this._trx,this._brx,this._blx),Math.min(this._tly,this._try,this._bry,this._bly),Math.max(this._tlx,this._trx,this._brx,this._blx),Math.max(this._tly,this._try,this._bry,this._bly))}containsPoint(x,
y){let v0x=this._trx-this._tlx;let v0y=this._try-this._tly;const v1x=this._brx-this._tlx;const v1y=this._bry-this._tly;const v2x=x-this._tlx;const v2y=y-this._tly;let dot00=v0x*v0x+v0y*v0y;let dot01=v0x*v1x+v0y*v1y;let dot02=v0x*v2x+v0y*v2y;const dot11=v1x*v1x+v1y*v1y;const dot12=v1x*v2x+v1y*v2y;let invDenom=1/(dot00*dot11-dot01*dot01);let u=(dot11*dot02-dot01*dot12)*invDenom;let v=(dot00*dot12-dot01*dot02)*invDenom;if(u>=0&&v>0&&u+v<1)return true;v0x=this._blx-this._tlx;v0y=this._bly-this._tly;dot00=
v0x*v0x+v0y*v0y;dot01=v0x*v1x+v0y*v1y;dot02=v0x*v2x+v0y*v2y;invDenom=1/(dot00*dot11-dot01*dot01);u=(dot11*dot02-dot01*dot12)*invDenom;v=(dot00*dot12-dot01*dot02)*invDenom;return u>=0&&v>0&&u+v<1}midX(){return(this._tlx+this._trx+this._brx+this._blx)/4}midY(){return(this._tly+this._try+this._bry+this._bly)/4}intersectsSegment(x1,y1,x2,y2){if(this.containsPoint(x1,y1)||this.containsPoint(x2,y2))return true;return C3.segmentIntersectsQuad(x1,y1,x2,y2,this)}intersectsQuad(rhs){let midX=rhs.midX();let midY=
rhs.midY();if(this.containsPoint(midX,midY))return true;midX=this.midX();midY=this.midY();if(rhs.containsPoint(midX,midY))return true;const tlx=this._tlx,tly=this._tly,trx=this._trx,try_=this._try,brx=this._brx,bry=this._bry,blx=this._blx,bly=this._bly;return C3.segmentIntersectsQuad(tlx,tly,trx,try_,rhs)||C3.segmentIntersectsQuad(trx,try_,brx,bry,rhs)||C3.segmentIntersectsQuad(brx,bry,blx,bly,rhs)||C3.segmentIntersectsQuad(blx,bly,tlx,tly,rhs)}rotatePointsAnticlockwise(){const tlx=this._tlx;const tly=
this._tly;this._tlx=this._trx;this._tly=this._try;this._trx=this._brx;this._try=this._bry;this._brx=this._blx;this._bry=this._bly;this._blx=tlx;this._bly=tly}mirror(){this._swap(0,2);this._swap(1,3);this._swap(6,4);this._swap(7,5)}flip(){this._swap(0,6);this._swap(1,7);this._swap(2,4);this._swap(3,5)}diag(){this._swap(2,6);this._swap(3,7)}_swap(i,j){const tmp=this._getAtIndex(i);this._setAtIndex(i,this._getAtIndex(j));this._setAtIndex(j,tmp)}_getAtIndex(i){switch(i){case 0:return this._tlx;case 1:return this._tly;
case 2:return this._trx;case 3:return this._try;case 4:return this._brx;case 5:return this._bry;case 6:return this._blx;case 7:return this._bly;default:throw new RangeError("invalid quad point index");}}_setAtIndex(i,v){v=+v;switch(i){case 0:this._tlx=v;break;case 1:this._tly=v;break;case 2:this._trx=v;break;case 3:this._try=v;break;case 4:this._brx=v;break;case 5:this._bry=v;break;case 6:this._blx=v;break;case 7:this._bly=v;break;default:throw new RangeError("invalid quad point index");}}};

}

// lib/misc/collisionPoly.js
{
'use strict';const C3=self.C3;const assert=self.assert;const DEFAULT_POLY_POINTS=[0,0,1,0,1,1,0,1];const tempQuad=C3.New(C3.Quad);
C3.CollisionPoly=class CollisionPoly extends C3.DefendedBase{constructor(pointsArr,enabled=true){super();if(!pointsArr)pointsArr=DEFAULT_POLY_POINTS;this._ptsArr=Float64Array.from(pointsArr);this._bbox=new C3.Rect;this._isBboxChanged=true;this._enabled=enabled}Release(){}pointsArr(){return this._ptsArr}pointCount(){return this._ptsArr.length/2}setPoints(pointsArr){if(this._ptsArr.length===pointsArr.length)this._ptsArr.set(pointsArr);else this._ptsArr=Float64Array.from(pointsArr);this._isBboxChanged=
true}setDefaultPoints(){this.setPoints(DEFAULT_POLY_POINTS)}copy(poly){this.setPoints(poly._ptsArr)}setBboxChanged(){this._isBboxChanged=true}_updateBbox(){if(!this._isBboxChanged)return;const ptsArr=this._ptsArr;let left=ptsArr[0];let top=ptsArr[1];let right=left;let bottom=top;for(let i=0,len=ptsArr.length;i<len;i+=2){const x=ptsArr[i];const y=ptsArr[i+1];if(x<left)left=x;if(x>right)right=x;if(y<top)top=y;if(y>bottom)bottom=y}this._bbox.set(left,top,right,bottom);this._isBboxChanged=false}setFromRect(rc,
offX,offY){let ptsArr=this._ptsArr;if(ptsArr.length!==8){ptsArr=new Float64Array(8);this._ptsArr=ptsArr}ptsArr[0]=rc.getLeft()-offX;ptsArr[1]=rc.getTop()-offY;ptsArr[2]=rc.getRight()-offX;ptsArr[3]=rc.getTop()-offY;ptsArr[4]=rc.getRight()-offX;ptsArr[5]=rc.getBottom()-offY;ptsArr[6]=rc.getLeft()-offX;ptsArr[7]=rc.getBottom()-offY;this._bbox.copy(rc);if(offX!==0||offY!==0)this._bbox.offset(-offX,-offY);this._isBboxChanged=false}setFromQuad(q,offX,offY){tempQuad.copy(q);tempQuad.offset(offX,offY);this.setPoints(tempQuad.toArray());
this._isBboxChanged=true}transform(w,h,a){let sina=0;let cosa=1;if(a!==0){sina=Math.sin(a);cosa=Math.cos(a)}this.transformPrecalc(w,h,sina,cosa)}transformPrecalc(w,h,sina,cosa){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=i+1;const x=ptsArr[i]*w;const y=ptsArr[j]*h;ptsArr[i]=x*cosa-y*sina;ptsArr[j]=y*cosa+x*sina}this._isBboxChanged=true}offset(x,y){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){ptsArr[i]+=x;ptsArr[i+1]+=y}}containsPoint(a2x,a2y){const ptsArr=
this._ptsArr;if(a2x===ptsArr[0]&&a2y===ptsArr[1])return true;this._updateBbox();const bbox=this._bbox;const a1x=bbox.getLeft()-110;const a1y=bbox.getTop()-101;const a3x=bbox.getRight()+131;const a3y=bbox.getBottom()+120;let minAx12=0;let minAy12=0;let maxAx12=0;let maxAy12=0;let minAx32=0;let minAy32=0;let maxAx32=0;let maxAy32=0;if(a1x<a2x){minAx12=a1x;maxAx12=a2x}else{minAx12=a2x;maxAx12=a1x}if(a1y<a2y){minAy12=a1y;maxAy12=a2y}else{minAy12=a2y;maxAy12=a1y}if(a3x<a2x){minAx32=a3x;maxAx32=a2x}else{minAx32=
a2x;maxAx32=a3x}if(a3y<a2y){minAy32=a3y;maxAy32=a2y}else{minAy32=a2y;maxAy32=a3y}let count1=0;let count2=0;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=(i+2)%len;const b1x=ptsArr[i];const b1y=ptsArr[i+1];const b2x=ptsArr[j];const b2y=ptsArr[j+1];if(C3.segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,minAx12,maxAx12,minAy12,maxAy12,b1x,b1y,b2x,b2y))++count1;if(C3.segmentsIntersectPreCalc(a3x,a3y,a2x,a2y,minAx32,maxAx32,minAy32,maxAy32,b1x,b1y,b2x,b2y))++count2}return count1%2===1||count2%2===1}intersectsPoly(poly,
offX,offY){const rPts=poly._ptsArr;const lPts=this._ptsArr;if(this.containsPoint(rPts[0]+offX,rPts[1]+offY))return true;if(poly.containsPoint(lPts[0]-offX,lPts[1]-offY))return true;for(let i=0,leni=lPts.length;i<leni;i+=2){const j=(i+2)%leni;const a1x=lPts[i];const a1y=lPts[i+1];const a2x=lPts[j];const a2y=lPts[j+1];let minAx=0;let minAy=0;let maxAx=0;let maxAy=0;if(a1x<a2x){minAx=a1x;maxAx=a2x}else{minAx=a2x;maxAx=a1x}if(a1y<a2y){minAy=a1y;maxAy=a2y}else{minAy=a2y;maxAy=a1y}for(let k=0,lenk=rPts.length;k<
lenk;k+=2){const l=(k+2)%lenk;const b1x=rPts[k]+offX;const b1y=rPts[k+1]+offY;const b2x=rPts[l]+offX;const b2y=rPts[l+1]+offY;if(C3.segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,minAx,maxAx,minAy,maxAy,b1x,b1y,b2x,b2y))return true}}return false}intersectsSegment(offX,offY,a1x,a1y,a2x,a2y){if(this.containsPoint(a1x-offX,a1y-offY))return true;if(this.containsPoint(a2x-offX,a2y-offY))return true;let minAx=0;let minAy=0;let maxAx=0;let maxAy=0;if(a1x<a2x){minAx=a1x;maxAx=a2x}else{minAx=a2x;maxAx=a1x}if(a1y<
a2y){minAy=a1y;maxAy=a2y}else{minAy=a2y;maxAy=a1y}const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=(i+2)%len;const b1x=ptsArr[i]+offX;const b1y=ptsArr[i+1]+offY;const b2x=ptsArr[j]+offX;const b2y=ptsArr[j+1]+offY;if(C3.segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,minAx,maxAx,minAy,maxAy,b1x,b1y,b2x,b2y))return true}return false}mirror(px){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2)ptsArr[i]=px*2-ptsArr[i];this._isBboxChanged=true}flip(py){const ptsArr=
this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=i+1;ptsArr[j]=py*2-ptsArr[j]}this._isBboxChanged=true}diag(){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=i+1;const temp=ptsArr[i];ptsArr[i]=ptsArr[j];ptsArr[j]=temp}this._isBboxChanged=true}GetMidX(){const ptsArr=this._ptsArr;let ret=0;for(let i=0,len=ptsArr.length;i<len;i+=2)ret+=ptsArr[i];return ret/this.pointCount()}GetMidY(){const ptsArr=this._ptsArr;let ret=0;for(let i=0,len=ptsArr.length;i<len;i+=
2)ret+=ptsArr[i+1];return ret/this.pointCount()}GetPointsArray(){return this._ptsArr}GetPointCount(){return this.pointCount()}IsEnabled(){return this._enabled}};

}

// lib/misc/pairMap.js
{
'use strict';const C3=self.C3;
C3.PairMap=class PairMap extends C3.DefendedBase{constructor(iterable){super();this._firstMap=new Map;if(iterable)for(const [x,y,value]of iterable)this.Set(x,y,value)}Release(){this.Clear();this._firstMap=null}Clear(){const firstMap=this._firstMap;for(const secondMap of firstMap.values())secondMap.clear();firstMap.clear()}Set(x,y,value){const firstMap=this._firstMap;let secondMap=firstMap.get(x);if(!secondMap){secondMap=new Map;firstMap.set(x,secondMap)}secondMap.set(y,value)}Get(x,y){const secondMap=
this._firstMap.get(x);if(!secondMap)return secondMap;return secondMap.get(y)}Has(x,y){const secondMap=this._firstMap.get(x);if(!secondMap)return false;return secondMap.has(y)}Delete(x,y){const firstMap=this._firstMap;const secondMap=firstMap.get(x);if(!secondMap)return false;const ret=secondMap.delete(y);if(ret&&secondMap.size===0)firstMap.delete(x);return ret}DeleteEither(k){const firstMap=this._firstMap;const secondMap=firstMap.get(k);if(secondMap){secondMap.clear();firstMap.delete(k)}for(const [x,
secondMap]of firstMap.entries())if(secondMap.delete(k)&&secondMap.size===0)firstMap.delete(x)}GetSize(){let ret=0;for(const secondMap of this._firstMap.values())ret+=secondMap.size;return ret}*values(){for(const secondMap of this._firstMap.values())yield*secondMap.values()}*keyPairs(){for(const [x,secondMap]of this._firstMap.entries())for(const y of secondMap.keys())yield[x,y]}*entries(){for(const [x,secondMap]of this._firstMap.entries())for(const [y,value]of secondMap.entries())yield[x,y,value]}};

}

// lib/misc/arraySet.js
{
'use strict';const C3=self.C3;
C3.ArraySet=class ArraySet extends C3.DefendedBase{constructor(){super();this._set=new Set;this._arr=[];this._needToRebuildArray=false}Release(){this.Clear()}Clear(){this._set.clear();C3.clearArray(this._arr);this._needToRebuildArray=false}Add(v){if(this._set.has(v))return;this._set.add(v);if(!this._needToRebuildArray)this._arr.push(v)}Has(v){return this._set.has(v)}Delete(v){if(this._set.delete(v))this._needToRebuildArray=true}GetSize(){return this._set.size}IsEmpty(){return this._set.size===0}GetArray(){if(this._needToRebuildArray){this._RebuildArray();
this._needToRebuildArray=false}return this._arr}_RebuildArray(){const arr=this._arr;C3.clearArray(arr);for(const v of this._set)arr.push(v)}};

}

// ../lib/misc/ease.js
{
'use strict';const C3=self.C3;const EASE_MAP=new Map;const PREDEFINED_EASE_MAP=new Map;const CUSTOM_EASE_EDITOR_MAP=new Map;const CUSTOM_EASE_RUNTIME_MAP=new Map;const PRIVATE_EASE_MAP=new Map;const BUILT_IN_TRANSITION_MAP=new Map;const ALIAS_MAP=new Map;ALIAS_MAP.set("linear","noease");ALIAS_MAP.set("default","noease");
const EASE_TRANSLATION_KEYS=["default","noease","easeinquad","easeoutquad","easeinoutquad","easeincubic","easeoutcubic","easeinoutcubic","easeinquart","easeoutquart","easeinoutquart","easeinquint","easeoutquint","easeinoutquint","easeinsine","easeoutsine","easeinoutsine","easeinexpo","easeoutexpo","easeinoutexpo","easeincirc","easeoutcirc","easeinoutcirc","easeinelastic","easeoutelastic","easeinoutelastic","easeinback","easeoutback","easeinoutback","easeinbounce","easeoutbounce","easeinoutbounce"];
const SHORT_EASE_TRANSLATION_KEYS=["default","noease","quad","cubic","quart","quint","sine","expo","circ","elastic","back","bounce"];
const EASE_API2INTERNAL_NAMES=new Map([["linear","noease"],["in-sine","easeinsine"],["out-sine","easeoutsine"],["in-out-sine","easeinoutsine"],["in-elastic","easeinelastic"],["out-elastic","easeoutelastic"],["in-out-elastic","easeinoutelastic"],["in-back","easeinback"],["out-back","easeoutback"],["in-out-back","easeinoutback"],["in-bounce","easeinbounce"],["out-bounce","easeoutbounce"],["in-out-bounce","easeinoutbounce"],["in-cubic","easeincubic"],["out-cubic","easeoutcubic"],["in-out-cubic","easeinoutcubic"],
["in-quadratic","easeinquad"],["out-quadratic","easeoutquad"],["in-out-quadratic","easeinoutquad"],["in-quartic","easeinquart"],["out-quartic","easeoutquart"],["in-out-quartic","easeinoutquart"],["in-quintic","easeinquint"],["out-quintic","easeoutquint"],["in-out-quintic","easeinoutquint"],["in-circular","easeincirc"],["out-circular","easeoutcirc"],["in-out-circular","easeinoutcirc"],["in-exponential","easeinexpo"],["out-exponential","easeoutexpo"],["in-out-exponential","easeinoutexpo"]]);
self.Ease=class Ease{constructor(){}static InheritEase(){return"default"}static DefaultEase(){return"noease"}static ToInternal(ease){return EASE_API2INTERNAL_NAMES.get(ease)}static GetEditorEaseNames(project,...filter){this._CreateEaseMap();let customEaseMap;if(project){if(!CUSTOM_EASE_EDITOR_MAP.has(project))CUSTOM_EASE_EDITOR_MAP.set(project,new Map);customEaseMap=CUSTOM_EASE_EDITOR_MAP.get(project)}else customEaseMap=CUSTOM_EASE_RUNTIME_MAP;const sortedCustomEases=[...customEaseMap.keys()];sortedCustomEases.sort();
return[...PREDEFINED_EASE_MAP.keys()].concat(sortedCustomEases).filter(ease=>!filter.includes(ease))}static GetRuntimeEaseNames(){this._CreateEaseMap();const sortedCustomEases=[...CUSTOM_EASE_RUNTIME_MAP.keys()];sortedCustomEases.sort();return[...PREDEFINED_EASE_MAP.keys()].concat(sortedCustomEases)}static GetCustomRuntimeEaseNames(){this._CreateEaseMap();const sortedCustomEases=[...CUSTOM_EASE_RUNTIME_MAP.keys()];sortedCustomEases.sort();return sortedCustomEases}static IsPredefinedTranslatedName(easeName){for(const k of EASE_TRANSLATION_KEYS){const translatedName=
self.lang(`ui.bars.timeline.eases.${k}`);if(translatedName===easeName)return true}for(const k of SHORT_EASE_TRANSLATION_KEYS){const translatedName=self.lang(`ui.bars.timeline.short-eases.${k}`);if(translatedName===easeName)return true}}static IsNamePredefined(easeName){this._CreateEaseMap();return[...PREDEFINED_EASE_MAP.keys()].includes(easeName)}static _GetEase(easeName){const realEaseName=ALIAS_MAP.get(easeName);if(realEaseName)return EASE_MAP.get(realEaseName);if(Ease.IsNamePredefined(easeName))return EASE_MAP.get(easeName);
if(PRIVATE_EASE_MAP.has(easeName))return PRIVATE_EASE_MAP.get(easeName)}static GetBuiltInTransition(builtInTransitionName){this._CreateEaseMap();return BUILT_IN_TRANSITION_MAP.get(builtInTransitionName)}static GetEditorEase(easeName,project){this._CreateEaseMap();const ease=Ease._GetEase(easeName);if(ease)return ease;if(!project)throw new Error("missing ease function");return CUSTOM_EASE_EDITOR_MAP.get(project).get(easeName)}static HasEditorEase(easeName,project){this._CreateEaseMap();const ease=
Ease._GetEase(easeName);if(ease)return true;return!!CUSTOM_EASE_EDITOR_MAP.get(project).get(easeName)}static GetRuntimeEase(easeName){this._CreateEaseMap();const ease=Ease._GetEase(easeName);if(ease)return ease;return CUSTOM_EASE_RUNTIME_MAP.get(easeName)}static GetEaseFromIndex(index){this._CreateEaseMap();const names=this.GetRuntimeEaseNames();return names[index]}static GetIndexForEase(name,project){this._CreateEaseMap();const names=this.GetEditorEaseNames(project);return names.indexOf(name)}static GetIndexForEaseAtRuntime(name){return this.GetIndexForEase(name)}static _CreateEaseMap(){if(EASE_MAP.size!==
0)return;this._AddPredifinedEase("default",()=>{});this._AddPredifinedEase("noease",[{"x":0,"y":0,"sax":.336,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.336,"eay":0,"se":false,"ee":true}],true);this._AddPredifinedEase("easeinsine",[{"x":0,"y":0,"sax":.485,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.038,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutsine",[{"x":0,"y":0,"sax":.038,"say":0,"eax":0,"eay":0,
"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.485,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutsine",[{"x":0,"y":0,"sax":.336,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.336,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinelastic",[{"x":0,"y":0,"sax":.018,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":.116,"y":.002,"sax":.025,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":.266,"y":-.005,"sax":.024,"say":0,
"eax":-.021,"eay":0,"se":true,"ee":true},{"x":.416,"y":.016,"sax":.024,"say":0,"eax":-.026,"eay":0,"se":true,"ee":true},{"x":.566,"y":-.045,"sax":.061,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":.716,"y":.132,"sax":.072,"say":-.004,"eax":-.045,"eay":0,"se":true,"ee":true},{"x":.866,"y":-.373,"sax":.06,"say":0,"eax":-.049,"eay":-.002,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.038,"eay":-.263,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutelastic",[{"x":0,"y":0,"sax":.038,
"say":.263,"eax":0,"eay":0,"se":true,"ee":false},{"x":.136,"y":1.373,"sax":.049,"say":.002,"eax":-.06,"eay":0,"se":true,"ee":true},{"x":.286,"y":.868,"sax":.045,"say":0,"eax":-.072,"eay":.004,"se":true,"ee":true},{"x":.436,"y":1.045,"sax":.025,"say":0,"eax":-.061,"eay":0,"se":true,"ee":true},{"x":.586,"y":.984,"sax":.026,"say":0,"eax":-.024,"eay":0,"se":true,"ee":true},{"x":.736,"y":1.005,"sax":.021,"say":0,"eax":-.024,"eay":0,"se":true,"ee":true},{"x":.886,"y":.998,"sax":.025,"say":0,"eax":-.025,
"eay":0,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.018,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutelastic",[{"x":0,"y":0,"sax":.025,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":.067,"y":.001,"sax":.025,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":.18,"y":-.005,"sax":.025,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":.292,"y":.025,"sax":.053,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":.405,"y":-.118,"sax":.069,"say":0,"eax":-.027,
"eay":0,"se":true,"ee":true},{"x":.597,"y":1.118,"sax":.027,"say":0,"eax":-.069,"eay":0,"se":true,"ee":true},{"x":.71,"y":.975,"sax":.025,"say":0,"eax":-.053,"eay":0,"se":true,"ee":true},{"x":.822,"y":1.005,"sax":.025,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":.935,"y":.999,"sax":.025,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.025,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinback",[{"x":0,"y":0,"sax":.35,"say":0,"eax":0,"eay":0,
"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.34,"eay":-1.579,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutback",[{"x":0,"y":0,"sax":.34,"say":1.579,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.35,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutback",[{"x":0,"y":0,"sax":.035,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":.242,"y":-.1,"sax":.258,"say":0,"eax":-.025,"eay":0,"se":true,"ee":true},{"x":.76,"y":1.1,"sax":.025,"say":0,
"eax":-.26,"eay":0,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.035,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinbounce",[{"x":0,"y":0,"sax":.033,"say":.025,"eax":0,"eay":0,"se":true,"ee":false},{"x":.092,"y":0,"sax":.026,"say":.078,"eax":-.033,"eay":.025,"se":true,"ee":true},{"x":.274,"y":0,"sax":.097,"say":.319,"eax":-.026,"eay":.078,"se":true,"ee":true},{"x":.637,"y":0,"sax":.105,"say":.625,"eax":-.097,"eay":.319,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,
"eax":-.125,"eay":-.004,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutbounce",[{"x":0,"y":0,"sax":.125,"say":.004,"eax":0,"eay":0,"se":true,"ee":false},{"x":.365,"y":1,"sax":.097,"say":-.319,"eax":-.105,"eay":-.625,"se":true,"ee":true},{"x":.728,"y":1,"sax":.026,"say":-.078,"eax":-.097,"eay":-.319,"se":true,"ee":true},{"x":.91,"y":1,"sax":.033,"say":-.025,"eax":-.026,"eay":-.078,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.033,"eay":-.025,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutbounce",
[{"x":0,"y":0,"sax":.01,"say":.006,"eax":0,"eay":0,"se":true,"ee":false},{"x":.046,"y":0,"sax":.021,"say":.038,"eax":-.01,"eay":.006,"se":true,"ee":true},{"x":.137,"y":0,"sax":.059,"say":.158,"eax":-.021,"eay":.038,"se":true,"ee":true},{"x":.319,"y":0,"sax":.117,"say":.744,"eax":-.059,"eay":.158,"se":true,"ee":true},{"x":.683,"y":1,"sax":.059,"say":-.158,"eax":-.117,"eay":-.744,"se":true,"ee":true},{"x":.865,"y":1,"sax":.021,"say":-.038,"eax":-.059,"eay":-.158,"se":true,"ee":true},{"x":.956,"y":1,
"sax":.01,"say":-.006,"eax":-.021,"eay":-.038,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.01,"eay":-.006,"se":false,"ee":true}]);this._AddPredifinedEase("easeincubic",[{"x":0,"y":0,"sax":.75,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.138,"eay":-.321,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutcubic",[{"x":0,"y":0,"sax":.138,"say":.321,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.75,"eay":0,"se":false,"ee":true}]);
this._AddPredifinedEase("easeinoutcubic",[{"x":0,"y":0,"sax":.285,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":.5,"y":.5,"sax":.081,"say":.272,"eax":-.081,"eay":-.272,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.285,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinquad",[{"x":0,"y":0,"sax":.4,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.178,"eay":-.392,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutquad",[{"x":0,"y":0,
"sax":.178,"say":.392,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.4,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutquad",[{"x":0,"y":0,"sax":.25,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":.5,"y":.5,"sax":.03,"say":.065,"eax":-.03,"eay":-.065,"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.25,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinquart",[{"x":0,"y":0,"sax":.264,"say":.079,"eax":0,"eay":0,"se":true,"ee":false},
{"x":1,"y":1,"sax":0,"say":0,"eax":-.329,"eay":-1.287,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutquart",[{"x":0,"y":0,"sax":.329,"say":1.287,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.264,"eay":-.079,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutquart",[{"x":0,"y":0,"sax":.765,"say":.03,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.765,"eay":-.03,"se":false,"ee":true}]);this._AddPredifinedEase("easeinquint",[{"x":0,
"y":0,"sax":.6,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.2,"eay":-1,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutquint",[{"x":0,"y":0,"sax":.2,"say":1,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.6,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutquint",[{"eax":0,"eay":0,"ee":false,"sax":.84,"say":0,"se":true,"x":0,"y":0},{"eax":-.84,"eay":0,"ee":true,"sax":0,"say":0,"se":false,"x":1,"y":1}]);this._AddPredifinedEase("easeincirc",
[{"x":0,"y":0,"sax":.25,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.024,"eay":-.808,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutcirc",[{"x":0,"y":0,"sax":.024,"say":.808,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.25,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutcirc",[{"x":0,"y":0,"sax":.125,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":.5,"y":.5,"sax":.02,"say":.428,"eax":-.02,"eay":-.428,
"se":true,"ee":true},{"x":1,"y":1,"sax":0,"say":0,"eax":-.125,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinexpo",[{"x":0,"y":0,"sax":.66,"say":0,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.14,"eay":-1,"se":false,"ee":true}]);this._AddPredifinedEase("easeoutexpo",[{"x":0,"y":0,"sax":.14,"say":1,"eax":0,"eay":0,"se":true,"ee":false},{"x":1,"y":1,"sax":0,"say":0,"eax":-.66,"eay":0,"se":false,"ee":true}]);this._AddPredifinedEase("easeinoutexpo",[{"eax":0,
"eay":0,"ee":false,"sax":.345,"say":0,"se":true,"x":0,"y":0},{"eax":-.06,"eay":-.5,"ee":true,"sax":.06,"say":.5,"se":true,"x":.5,"y":.5},{"eax":-.335,"eay":0,"ee":true,"sax":0,"say":0,"se":false,"x":1,"y":1}]);this._AddPrivateCustomEase("cubicbezier",this.EaseCubicBezier);this._AddPrivateCustomEase("spline",this.EaseSpline)}static _AddPredifinedEase(name,dataArray_or_function,linear=false){if(typeof dataArray_or_function==="function")Ease._AddEase(name,dataArray_or_function,"predefined");else if(C3.IsArray(dataArray_or_function))if(self.BuiltInTransition){const builtInTransition=
C3.New(self.BuiltInTransition,name,linear);builtInTransition.SetFromJson(dataArray_or_function);Ease._AddEase(name,(t,sv,dv,tt)=>builtInTransition.Interpolate(t,sv,dv,tt),"predefined");BUILT_IN_TRANSITION_MAP.set(name,builtInTransition)}else{const builtInTransition=C3.New(C3.Transition,[name,dataArray_or_function.map(data=>{return[data["x"],data["y"],data["sax"],data["say"],data["eax"],data["eay"],data["se"],data["ee"]]})],false);builtInTransition.MakeLinear(linear);Ease._AddEase(name,(t,sv,dv,tt)=>
builtInTransition.Interpolate(t,sv,dv,tt),"predefined")}else throw new Error("unexpected arguments");}static _AddPrivateCustomEase(name,func){Ease._AddEase(name,func,"private")}static AddCustomEase(name,func,project){this._CreateEaseMap();Ease._AddEase(name,func,"custom",project)}static RemoveCustomEase(name,project){if(this.IsNamePredefined(name))return;if([...PRIVATE_EASE_MAP.keys()].includes(name))return;const customEaseMap=CUSTOM_EASE_EDITOR_MAP.get(project);if(customEaseMap)customEaseMap.delete(name)}static _AddEase(name,
func,mode,project){switch(mode){case "predefined":{EASE_MAP.set(name,func);PREDEFINED_EASE_MAP.set(name,func);break}case "custom":{if(project){if(!CUSTOM_EASE_EDITOR_MAP.has(project))CUSTOM_EASE_EDITOR_MAP.set(project,new Map);const customEaseMap=CUSTOM_EASE_EDITOR_MAP.get(project);customEaseMap.set(name,func)}else CUSTOM_EASE_RUNTIME_MAP.set(name,func);break}case "private":{EASE_MAP.set(name,func);PRIVATE_EASE_MAP.set(name,func);break}default:throw new Error("unexpected ease mode");}}static NoEase(t,
b,c,d){return c*t/d+b}static EaseInQuad(t,b,c,d){return c*(t/=d)*t+b}static EaseOutQuad(t,b,c,d){return-c*(t/=d)*(t-2)+b}static EaseInOutQuad(t,b,c,d){if((t/=d/2)<1)return c/2*t*t+b;return-c/2*(--t*(t-2)-1)+b}static EaseInCubic(t,b,c,d){return c*(t/=d)*t*t+b}static EaseOutCubic(t,b,c,d){return c*((t=t/d-1)*t*t+1)+b}static EaseInOutCubic(t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t+b;return c/2*((t-=2)*t*t+2)+b}static EaseInQuart(t,b,c,d){return c*(t/=d)*t*t*t+b}static EaseOutQuart(t,b,c,d){return-c*((t=
t/d-1)*t*t*t-1)+b}static EaseInOutQuart(t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t*t+b;return-c/2*((t-=2)*t*t*t-2)+b}static EaseInQuint(t,b,c,d){return c*(t/=d)*t*t*t*t+b}static EaseOutQuint(t,b,c,d){return c*((t=t/d-1)*t*t*t*t+1)+b}static EaseInOutQuint(t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t*t*t+b;return c/2*((t-=2)*t*t*t*t+2)+b}static EaseInSine(t,b,c,d){return-c*Math.cos(t/d*(Math.PI/2))+c+b}static EaseOutSine(t,b,c,d){return c*Math.sin(t/d*(Math.PI/2))+b}static EaseInOutSine(t,b,c,d){return-c/2*
(Math.cos(Math.PI*t/d)-1)+b}static EaseInExpo(t,b,c,d){return t===0?b:c*Math.pow(2,10*(t/d-1))+b}static EaseOutExpo(t,b,c,d){return t===d?b+c:c*(-Math.pow(2,-10*t/d)+1)+b}static EaseInOutExpo(t,b,c,d){if(t===0)return b;if(t===d)return b+c;if((t/=d/2)<1)return c/2*Math.pow(2,10*(t-1))+b;return c/2*(-Math.pow(2,-10*--t)+2)+b}static EaseInCirc(t,b,c,d){return-c*(Math.sqrt(1-(t/=d)*t)-1)+b}static EaseOutCirc(t,b,c,d){return c*Math.sqrt(1-(t=t/d-1)*t)+b}static EaseInOutCirc(t,b,c,d){if((t/=d/2)<1)return-c/
2*(Math.sqrt(1-t*t)-1)+b;return c/2*(Math.sqrt(1-(t-=2)*t)+1)+b}static EaseInElastic(t,b,c,d){let s=1.70158;let p=0;let a=c;if(t===0)return b;if((t/=d)===1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;s=p/4}else s=p/(2*Math.PI)*Math.asin(c/a);return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b}static EaseOutElastic(t,b,c,d){let s=1.70158;let p=0;let a=c;if(t===0)return b;if((t/=d)===1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;s=p/4}else s=p/(2*Math.PI)*Math.asin(c/a);return a*
Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b}static EaseInOutElastic(t,b,c,d){let s=1.70158;let p=0;let a=c;if(t===0)return b;if((t/=d/2)===2)return b+c;if(!p)p=d*(.3*1.5);if(a<Math.abs(c)){a=c;s=p/4}else s=p/(2*Math.PI)*Math.asin(c/a);if(t<1)return-.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*.5+c+b}static EaseInBack(t,b,c,d,s){if(s===undefined)s=1.70158;return c*(t/=d)*t*((s+1)*t-s)+b}static EaseOutBack(t,
b,c,d,s){if(s===undefined)s=1.70158;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b}static EaseInOutBack(t,b,c,d,s){if(s===undefined)s=1.70158;if((t/=d/2)<1)return c/2*(t*t*(((s*=1.525)+1)*t-s))+b;return c/2*((t-=2)*t*(((s*=1.525)+1)*t+s)+2)+b}static EaseInBounce(t,b,c,d){return c-Ease.EaseOutBounce(d-t,0,c,d)+b}static EaseOutBounce(t,b,c,d){if((t/=d)<1/2.75)return c*(7.5625*t*t)+b;else if(t<2/2.75)return c*(7.5625*(t-=1.5/2.75)*t+.75)+b;else if(t<2.5/2.75)return c*(7.5625*(t-=2.25/2.75)*t+.9375)+b;else return c*
(7.5625*(t-=2.625/2.75)*t+.984375)+b}static EaseInOutBounce(t,b,c,d){if(t<d/2)return Ease.EaseInBounce(t*2,0,c,d)*.5+b;return Ease.EaseOutBounce(t*2-d,0,c,d)*.5+c*.5+b}static EaseCubicBezier(t,p0,p1,p2,p3){const _0=p0;const _1=3*t*(p1-p0);const _2=3*t**2*(p0+p2-2*p1);const _3=t**3*(p3-p0+3*p1-3*p2);return _0+_1+_2+_3}static EaseSpline(t,sx,sy,x1,y1,x2,y2,ex,ey,samples){if(x1===y1&&x2===y2)return t;const tx=get_t_for_x(t,sx,x1,x2,ex,samples);const va=a(sy,y1,y2,ey);const vb=b(sy,y1,y2,ey);const vc=
c(sy,y1,y2,ey);return calc_bezier(tx,va,vb,vc)}static GetBezierSamples(startx,a1x,a2x,endx){const ret=[];const va=a(startx,a1x,a2x,endx);const vb=b(startx,a1x,a2x,endx);const vc=c(startx,a1x,a2x,endx);for(let i=0;i<SAMPLE_COUNT;++i){const sample=calc_bezier(i*SAMPLE_STEP,va,vb,vc);ret.push(sample)}return ret}};const SAMPLE_COUNT=11;const SAMPLE_STEP=1/(SAMPLE_COUNT-1);const NEWTON_RAPHSON_ITERATIONS=4;const NEWTON_RAPHSON_MIN_SLOPE=.01;const SUBDIVISION_PRECISION=1E-7;
const SUBDIVISION_MAX_ITERATIONS=10;const a=(p0,p1,p2,p3)=>{return p3-3*p2+3*p1-p0};const b=(p0,p1,p2,p3)=>{return 3*p2-6*p1+3*p0};const c=(p0,p1,p2,p3)=>{return 3*(p1-p0)};const calc_bezier=(aT,a,b,c)=>{return((a*aT+b)*aT+c)*aT};const get_slope=(aT,a,b,c)=>{return 3*a*aT*aT+2*b*aT+c};
const get_t_for_x=(aX,p0,p1,p2,p3,samples)=>{if(aX==1)return 1;let intervalStart=0;let currentSampleIndex=1;let currentSampleValue=samples[currentSampleIndex];let lastSampleIndex=SAMPLE_COUNT-1;let lastSampleValue=samples[SAMPLE_COUNT-1];while(currentSampleIndex!=lastSampleIndex&&currentSampleValue<=aX){currentSampleIndex++;currentSampleValue=samples[currentSampleIndex];intervalStart+=SAMPLE_STEP}currentSampleIndex--;currentSampleValue=samples[currentSampleIndex];const dist=(aX-currentSampleValue)/
(samples[currentSampleIndex+1]-currentSampleValue);let guess=intervalStart+dist*SAMPLE_STEP;const va=a(p0,p1,p2,p3);const vb=b(p0,p1,p2,p3);const vc=c(p0,p1,p2,p3);const initSlope=get_slope(guess,va,vb,vc);if(initSlope===0)return guess;else if(initSlope>=NEWTON_RAPHSON_MIN_SLOPE){for(let i=0;i<NEWTON_RAPHSON_ITERATIONS;++i){const x=calc_bezier(guess,va,vb,vc)-aX;const slope=get_slope(guess,va,vb,vc);guess-=x/slope}return guess}else{let aA=intervalStart;let aB=intervalStart+SAMPLE_STEP;let i=0;let precissionLimit;
let maxIterations;do{guess=aA+(aB-aA)/2;let x=calc_bezier(guess,va,vb,vc)-aX;if(x>0)aB=guess;else aA=guess;precissionLimit=Math.abs(x)>SUBDIVISION_PRECISION;maxIterations=++i<SUBDIVISION_MAX_ITERATIONS}while(precissionLimit&&maxIterations);return guess}};

}

// ../lib/misc/probability.js
{
'use strict';const C3=self.C3;function RequireStringOrNumber(value){if(!C3.IsString(value));}
C3.ProbabilityTable=class ProbabilityTable{constructor(name){this._items=[];this._name=name||"";this._totalWeight=0}Release(){this.Clear();this._items=null}GetName(){return this._name}Clear(){C3.clear2DArray(this._items);this._totalWeight=0}GetTotalWeight(){return this._totalWeight}Sample(t=Math.random()*this.GetTotalWeight()){let sumWeight=0;for(const [weight,value]of this._items){sumWeight+=weight;if(t<sumWeight)return value}return 0}AddItem(weight,value){RequireStringOrNumber(value);this._totalWeight+=
weight;this._items.push([weight,value])}RemoveItem(weight,value){RequireStringOrNumber(value);const ignoreWeight=weight===0;for(let i=0;i<this._items.length;i++){const item=this._items[i];const doesWeightMatch=ignoreWeight||item[0]===weight;const doesValueMatch=item[1]===value;if(doesWeightMatch&&doesValueMatch){this._items.splice(i,1);this._totalWeight-=item[0];break}}}asJSON(){return JSON.stringify(this._items)}static fromJSON(str){const table=new C3.ProbabilityTable;const items=JSON.parse(str);
for(const item of items){const weight=item[0];const value=item[1];table.AddItem(weight,value)}return table}};

}

// lib/misc/screenReaderText.js
{
'use strict';const C3=self.C3;let nextId=0;
C3.ScreenReaderText=class ScreenReaderText{constructor(runtime,text){this._runtime=runtime;this._text=text;this._id=nextId++;this._runtime.PostComponentMessageToDOM("runtime","screen-reader-text",{"type":"create","id":this._id,"text":this._text})}Release(){this._runtime.PostComponentMessageToDOM("runtime","screen-reader-text",{"type":"release","id":this._id});this._runtime=null;this._text="";this._id=-1}SetText(text){if(this._text===text)return;this._text=text;this._runtime.PostComponentMessageToDOM("runtime",
"screen-reader-text",{"type":"update","id":this._id,"text":this._text})}};

}

// ../lib/events/event.js
{
'use strict';const C3=self.C3;
C3.Event=class Event{constructor(type,cancelable){this.type=type;this.cancelable=!!cancelable;this.defaultPrevented=false;this.propagationStopped=false;this.isAsync=false}preventDefault(){if(!this.cancelable)throw new Error(`event '${this.type}' is not cancelable`);this.defaultPrevented=true}stopPropagation(){if(!this.cancelable)throw new Error(`event '${this.type}' cannot be stopped`);if(this.isAsync)throw new Error(`cannot stop async event '${this.type}' propagation`);this.propagationStopped=true}};

}

// ../lib/events/handler.js
{
'use strict';const C3=self.C3;const assert=self.assert;
C3.Event.Handler=class EventHandler extends C3.DefendedBase{constructor(type){super();this._type=type;this._captureListeners=[];this._captureListenersSet=new Set;this._listeners=[];this._listenersSet=new Set;this._fireDepth=0;this._queueModifyListeners=[]}Release(){if(this._fireDepth>0)return;C3.clearArray(this._captureListeners);this._captureListenersSet.clear();C3.clearArray(this._listeners);this._listenersSet.clear();C3.clearArray(this._queueModifyListeners);C3.Release(this)}_AddListener(func,
capture){if(this._IsFiring()){this._queueModifyListeners.push({op:"add",func,capture});return}if(capture){if(this._captureListenersSet.has(func))return;this._captureListeners.push(func);this._captureListenersSet.add(func)}else{if(this._listenersSet.has(func))return;this._listeners.push(func);this._listenersSet.add(func)}}_RemoveListener(func,capture){if(this._IsFiring()){this._queueModifyListeners.push({op:"remove",func,capture});return}if(capture){if(this._captureListenersSet.has(func)){this._captureListenersSet.delete(func);
C3.arrayFindRemove(this._captureListeners,func)}}else if(this._listenersSet.has(func)){this._listenersSet.delete(func);C3.arrayFindRemove(this._listeners,func)}}_IsEmpty(){return!this._captureListeners.length&&!this._listeners.length}_IsFiring(){return this._fireDepth>0}_ProcessQueuedListeners(){const removeListenersSet=new Set;const removeCaptureListenersSet=new Set;for(const q of this._queueModifyListeners)if(q.op==="add"){this._AddListener(q.func,q.capture);if(q.capture)removeCaptureListenersSet.delete(q.func);
else removeListenersSet.delete(q.func)}else if(q.op==="remove")if(q.capture){this._captureListenersSet.delete(q.func);removeCaptureListenersSet.add(q.func)}else{this._listenersSet.delete(q.func);removeListenersSet.add(q.func)}else throw new Error("invalid op");C3.arrayRemoveAllInSet(this._listeners,removeListenersSet);C3.arrayRemoveAllInSet(this._captureListeners,removeCaptureListenersSet);C3.clearArray(this._queueModifyListeners)}_FireCancellable(event){this._IncreaseFireDepth();let isStopped=false;
for(let i=0,len=this._captureListeners.length;i<len;++i){this._captureListeners[i](event);if(event.propagationStopped){isStopped=true;break}}if(!isStopped)for(let i=0,len=this._listeners.length;i<len;++i){this._listeners[i](event);if(event.propagationStopped)break}this._DecreaseFireDepth();return!event.defaultPrevented}_FireNonCancellable(event){this._IncreaseFireDepth();for(let i=0,len=this._captureListeners.length;i<len;++i)this._captureListeners[i](event);for(let i=0,len=this._listeners.length;i<
len;++i)this._listeners[i](event);this._DecreaseFireDepth();return true}_IncreaseFireDepth(){this._fireDepth++}_DecreaseFireDepth(){this._fireDepth--;if(this._fireDepth===0&&this._queueModifyListeners.length>0)this._ProcessQueuedListeners()}SetDelayRemoveEventsEnabled(e){if(e)this._IncreaseFireDepth();else this._DecreaseFireDepth()}_FireAsync(event){let callbackPromises=[];for(let i=0,len=this._captureListeners.length;i<len;++i){let func=this._captureListeners[i];callbackPromises.push(C3.Asyncify(()=>
func(event)))}for(let i=0,len=this._listeners.length;i<len;++i){let func=this._listeners[i];callbackPromises.push(C3.Asyncify(()=>func(event)))}return Promise.all(callbackPromises).then(()=>!event.defaultPrevented)}_FireAndWait_AsyncOptional(event){const results=[];this._IncreaseFireDepth();for(let i=0,len=this._captureListeners.length;i<len;++i){const ret=this._captureListeners[i](event);if(ret instanceof Promise)results.push(ret)}for(let i=0,len=this._listeners.length;i<len;++i){const ret=this._listeners[i](event);
if(ret instanceof Promise)results.push(ret)}this._DecreaseFireDepth();if(results.length)return Promise.all(results).then(()=>!event.defaultPrevented);else return!event.defaultPrevented}async _FireAndWaitAsync(event){return await this._FireAndWait_AsyncOptional(event)}async _FireAndWaitAsyncSequential(event){this._IncreaseFireDepth();for(let i=0,len=this._captureListeners.length;i<len;++i){const ret=this._captureListeners[i](event);if(ret instanceof Promise)await ret}for(let i=0,len=this._listeners.length;i<
len;++i){const ret=this._listeners[i](event);if(ret instanceof Promise)await ret}this._DecreaseFireDepth();return!event.defaultPrevented}*_FireAsGenerator(event){this._IncreaseFireDepth();for(let i=0,len=this._captureListeners.length;i<len;++i){const ret=this._captureListeners[i](event);if(C3.IsIterator(ret))yield*ret}for(let i=0,len=this._listeners.length;i<len;++i){const ret=this._listeners[i](event);if(C3.IsIterator(ret))yield*ret}this._DecreaseFireDepth()}};

}

// ../lib/events/dispatcher.js
{
'use strict';const C3=self.C3;
C3.Event.Dispatcher=class EventDispatcher extends C3.DefendedBase{constructor(){super();this._eventHandlers=new Map;this._dispatcherWasReleased=false}Release(){if(this._dispatcherWasReleased)throw new Error("already released");this.ClearEvents();this._dispatcherWasReleased=true;C3.Release(this)}WasReleased(){return this._dispatcherWasReleased}ClearEvents(){for(let handler of this._eventHandlers.values())handler.Release();this._eventHandlers.clear()}_GetHandlerByType(type,create_if_missing){let handler=
this._eventHandlers.get(type);if(handler)return handler;if(create_if_missing){handler=C3.New(C3.Event.Handler,type);this._eventHandlers.set(type,handler);return handler}return null}HasAnyHandlerFor(type){return this._eventHandlers.has(type)}addEventListener(type,func,capture){let handler=this._GetHandlerByType(type,true);handler._AddListener(func,!!capture)}removeEventListener(type,func,capture){let handler=this._GetHandlerByType(type,false);if(!handler)return;handler._RemoveListener(func,!!capture);
if(handler._IsEmpty())this._eventHandlers.delete(type)}dispatchEvent(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return true;if(event.cancelable)return handler._FireCancellable(event);else return handler._FireNonCancellable(event)}dispatchEventAsync(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return Promise.resolve(true);event.isAsync=true;return handler._FireAsync(event)}async dispatchEventAndClearAsync(event){const handler=this._GetHandlerByType(event.type,
false);if(!handler)return true;this._eventHandlers.delete(event.type);event.isAsync=true;const ret=await handler._FireAsync(event);handler.Release();return ret}async dispatchEventAndWaitAsync(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return true;return await handler._FireAndWaitAsync(event)}dispatchEventAndWait_AsyncOptional(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return true;return handler._FireAndWait_AsyncOptional(event)}async dispatchEventAndWaitAsyncSequential(event){const handler=
this._GetHandlerByType(event.type,false);if(!handler)return true;return await handler._FireAndWaitAsyncSequential(event)}dispatchGeneratorEvent(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return null;if(event.cancelable)throw new Error("not supported");else return handler._FireAsGenerator(event)}SetDelayRemoveEventsEnabled(e){for(const handler of this._eventHandlers.values())handler.SetDelayRemoveEventsEnabled(e)}};

}

// ../lib/util/asyncify.js
{
'use strict';const C3=self.C3;const SETTIMEOUT_WORK_DURATION=12;const SETTIMEOUT_INTERVAL=16;const IDLECALLBACK_TIMEOUT=35;const SUPPORTS_RIC=typeof requestIdleCallback!=="undefined";let workQueue=[];let callbackId=-1;let highThroughputMode=0;function SetNewCallback(timerTimeout){if(SUPPORTS_RIC&&highThroughputMode===0)callbackId=requestIdleCallback(DoAsyncifiedWork,{timeout:IDLECALLBACK_TIMEOUT});else callbackId=setTimeout(DoAsyncifiedWork,highThroughputMode>0?1:timerTimeout)}
function DoAsyncifiedWork(deadline){callbackId=-1;if(!workQueue.length)return;let startTime=performance.now();let curTime=startTime;let jobCount=0;let estimatedNextJobDuration=0;do{DoNextAsyncifiedJob(workQueue.shift());curTime=performance.now();++jobCount;estimatedNextJobDuration=(curTime-startTime)/jobCount*1.1}while(workQueue.length&&(SUPPORTS_RIC&&highThroughputMode===0&&typeof deadline!=="undefined"?estimatedNextJobDuration<deadline["timeRemaining"]():curTime-startTime+estimatedNextJobDuration<
SETTIMEOUT_WORK_DURATION));if(callbackId===-1&&workQueue.length){let workDuration=curTime-startTime;let timeout=Math.max(SETTIMEOUT_INTERVAL-workDuration,4);SetNewCallback(timeout)}}function DoNextAsyncifiedJob(w){let ret;try{ret=w.func()}catch(e){w.reject(e);return}w.resolve(ret)}let asyncifyDisabled=C3.QueryString.Has("disable-asyncify");if(asyncifyDisabled)console.warn("[Asyncify] Asyncify has been disabled due to disable-asyncify in the query string. Some work will now be done synchronously.");
C3.Asyncify=function Asyncify(func){let stack=null;if(C3.isDebug)stack=C3.GetCallStack();return new Promise((resolve,reject)=>{workQueue.push({func:func,resolve:resolve,reject:reject,stack:stack});if(asyncifyDisabled){DoNextAsyncifiedJob(workQueue.pop());return}if(callbackId===-1)SetNewCallback(SETTIMEOUT_INTERVAL)})};
C3.Asyncify.SetHighThroughputMode=function SetHighThroughputMode(m){if(m)++highThroughputMode;else{--highThroughputMode;if(highThroughputMode<0)throw new Error("already turned off high throughput mode");}};

}

// ../lib/util/idleTimeout.js
{
'use strict';const C3=self.C3;const IDLE_CHECK_MIN_INTERVAL=1E3;const IDLE_CHECK_TIMER_OVERSHOOT=100;let cachedNowTime=-1;function ClearTimeCache(){cachedNowTime=-1}C3.FastGetDateNow=function FastGetDateNow(){if(cachedNowTime===-1){cachedNowTime=Date.now();self.setTimeout(ClearTimeCache,16)}return cachedNowTime};let timerId=-1;let nextDeadline=-1;let activeIdleTimeouts=new Set;
function CheckActiveIdleTimeouts(){timerId=-1;nextDeadline=-1;let nowTime=Date.now();for(let i of activeIdleTimeouts)if(i._CheckTimeout(nowTime)){let deadline=i._GetDeadline();if(nextDeadline===-1||deadline<nextDeadline)nextDeadline=deadline}else activeIdleTimeouts.delete(i);if(nextDeadline!==-1){let duration=Math.max(nextDeadline-nowTime+IDLE_CHECK_TIMER_OVERSHOOT,IDLE_CHECK_MIN_INTERVAL);timerId=self.setTimeout(CheckActiveIdleTimeouts,duration)}}
C3.IdleTimeout=class IdleTimeout{constructor(callback,timeoutInSeconds){this._callback=callback;this._timeout=timeoutInSeconds*1E3;this._deadline=0;this._isActive=false}Reset(){let nowTime=C3.FastGetDateNow();this._deadline=nowTime+this._timeout;if(!this._isActive){activeIdleTimeouts.add(this);this._isActive=true}if(timerId===-1){nextDeadline=this._deadline;timerId=self.setTimeout(CheckActiveIdleTimeouts,this._timeout+IDLE_CHECK_TIMER_OVERSHOOT)}else if(this._deadline<nextDeadline&&nextDeadline>nowTime+
IDLE_CHECK_MIN_INTERVAL){self.clearTimeout(timerId);nextDeadline=this._deadline;timerId=self.setTimeout(CheckActiveIdleTimeouts,this._timeout+IDLE_CHECK_TIMER_OVERSHOOT)}}_CheckTimeout(nowTime){if(nowTime>=this._deadline){if(this._callback()){this._deadline=nowTime+this._timeout;return true}this._isActive=false;return false}return true}_GetDeadline(){return this._deadline}Cancel(){if(this._isActive){activeIdleTimeouts.delete(this);this._isActive=false;if(activeIdleTimeouts.size===0&&timerId!==-1){self.clearTimeout(timerId);
timerId=-1;nextDeadline=-1}}}Release(){this.Cancel();this._callback=null}};

}

// ../lib/util/disposable.js
{
'use strict';const C3=self.C3;
C3.Disposable=class Disposable{constructor(disposeAction){this._disposed=false;this._disposeAction=disposeAction}Dispose(){if(this._disposed)return;this._disposed=true;if(this._disposeAction){this._disposeAction();this._disposeAction=null}}IsDisposed(){return this._disposed}Release(){this.Dispose()}static Release(instance){return new Disposable(()=>instance.Release())}static From(eventDispatcher,eventNames,eventHandler,opts,scope){if(typeof opts==="undefined"||opts===null)opts=false;else if(typeof opts!==
"boolean"&&typeof opts!=="object")throw new TypeError("invalid event listener options");if(scope)eventHandler=eventHandler.bind(scope);if(eventNames.includes(" ")){eventNames=eventNames.split(" ");const disposable=new C3.CompositeDisposable;for(let eventName of eventNames){eventDispatcher.addEventListener(eventName,eventHandler,opts);disposable.Add(C3.New(C3.Disposable,()=>eventDispatcher.removeEventListener(eventName,eventHandler,opts)))}return disposable}else{eventDispatcher.addEventListener(eventNames,
eventHandler,opts);return C3.New(C3.Disposable,()=>eventDispatcher.removeEventListener(eventNames,eventHandler,opts))}}};C3.StubDisposable=class StubDisposable extends C3.Disposable{SetAction(disposeAction){this._disposeAction=disposeAction}};
C3.CompositeDisposable=class CompositeDisposable extends C3.Disposable{constructor(...disposables){super();this._disposables=new Set;for(let disposable of disposables)this.Add(disposable)}Add(...disposables){if(this._disposed)throw new Error("already disposed");for(let disposable of disposables)this._disposables.add(disposable)}Remove(disposable){if(this._disposed)throw new Error("already disposed");this._disposables.delete(disposable)}RemoveAll(){if(this._disposed)throw new Error("already disposed");
if(!this._disposables)return;for(let disposable of this._disposables)disposable.Dispose();this._disposables.clear()}IsDisposed(){return this._disposed}Dispose(){if(this._disposed)throw new Error("already disposed");this._disposed=true;for(let disposable of this._disposables)disposable.Dispose();this._disposables.clear();this._disposables=null}Release(){this.Dispose()}};

}

// lib/util/kahanSum.js
{
'use strict';const C3=self.C3;C3.KahanSum=class KahanSum extends C3.DefendedBase{constructor(){super();this._c=0;this._y=0;this._t=0;this._sum=0}Add(v){v=+v;this._y=v-this._c;this._t=this._sum+this._y;this._c=this._t-this._sum-this._y;this._sum=this._t}Subtract(v){this._sum-=+v}Get(){return this._sum}Reset(){this._c=0;this._y=0;this._t=0;this._sum=0}Set(s){this._c=0;this._y=0;this._t=0;this._sum=+s}Copy(ks){this._c=ks._c;this._y=ks._y;this._t=ks._t;this._sum=ks._sum}Release(){}};

}

// lib/util/redblackset.js
{
'use strict';const C3=self.C3;const js_cols={};const RED=true;const BLACK=false;js_cols.RBnode=function(tree){this.tree=tree;this.right=this.tree.sentinel;this.left=this.tree.sentinel;this.parent=null;this.color=false;this.key=null};js_cols.RedBlackSet=function(compare_func){this.size=0;this.sentinel=new js_cols.RBnode(this);this.sentinel.color=BLACK;this.root=this.sentinel;this.root.parent=this.sentinel;this.compare=compare_func||this.default_compare};
js_cols.RedBlackSet.prototype.default_compare=function(a,b){if(a<b)return-1;else if(b<a)return 1;else return 0};js_cols.RedBlackSet.prototype.clone=function(){var rv=new js_cols.RedBlackSet(this.compare);rv.insertAll(this);return rv};js_cols.RedBlackSet.prototype.clear=function(){this.size=0;this.sentinel=new js_cols.RBnode(this);this.sentinel.color=BLACK;this.root=this.sentinel;this.root.parent=this.sentinel};
js_cols.RedBlackSet.prototype.leftRotate=function(x){var y=x.right;x.right=y.left;if(y.left!=this.sentinel)y.left.parent=x;y.parent=x.parent;if(x.parent==this.sentinel)this.root=y;else if(x==x.parent.left)x.parent.left=y;else x.parent.right=y;y.left=x;x.parent=y};
js_cols.RedBlackSet.prototype.rightRotate=function(x){var y=x.left;x.left=y.right;if(y.right!=this.sentinel)y.right.parent=x;y.parent=x.parent;if(x.parent==this.sentinel)this.root=y;else if(x==x.parent.right)x.parent.right=y;else x.parent.left=y;y.right=x;x.parent=y};
js_cols.RedBlackSet.prototype.insert=function(key){if(!this.contains(key)){var z=new js_cols.RBnode(this);z.key=key;var y=this.sentinel;var x=this.root;while(x!=this.sentinel){y=x;if(this.compare(z.key,x.key)<0)x=x.left;else x=x.right}z.parent=y;if(y==this.sentinel)this.root=z;else if(this.compare(z.key,y.key)<0)y.left=z;else y.right=z;z.left=this.sentinel;z.right=this.sentinel;z.color=RED;this.insertFixup(z);this.size++}else{var node=this.get_(key);node.key=key}};
js_cols.RedBlackSet.prototype.insertFixup=function(z){while(z!=this.sentinel&&z!=this.root&&z.parent.color==RED)if(z.parent==z.parent.parent.left){var y=z.parent.parent.right;if(y.color==RED){z.parent.color=BLACK;y.color=BLACK;z.parent.parent.color=RED;z=z.parent.parent}else{if(z==z.parent.right){z=z.parent;this.leftRotate(z)}z.parent.color=BLACK;z.parent.parent.color=RED;if(z.parent.parent!=this.sentinel)this.rightRotate(z.parent.parent)}}else{var y=z.parent.parent.left;if(y.color==RED){z.parent.color=
BLACK;y.color=BLACK;z.parent.parent.color=RED;z=z.parent.parent}else{if(z==z.parent.left){z=z.parent;this.rightRotate(z)}z.parent.color=BLACK;z.parent.parent.color=RED;if(z.parent.parent!=this.sentinel)this.leftRotate(z.parent.parent)}}this.root.color=BLACK};
js_cols.RedBlackSet.prototype.delete_=function(z){var y;var x;if(z.left==this.sentinel||z.right==this.sentinel)y=z;else y=this.successor_(z);if(y.left!=this.sentinel)x=y.left;else x=y.right;x.parent=y.parent;if(y.parent==this.sentinel)this.root=x;else if(y==y.parent.left)y.parent.left=x;else y.parent.right=x;if(y!=z)z.key=y.key;if(y.color==BLACK)this.deleteFixup(x);this.size--};
js_cols.RedBlackSet.prototype.deleteFixup=function(x){while(x!=this.root&&x.color==BLACK)if(x==x.parent.left){var w=x.parent.right;if(w.color==RED){w.color=BLACK;x.parent.color=RED;this.leftRotate(x.parent);w=x.parent.right}if(w.left.color==BLACK&&w.right.color==BLACK){w.color=RED;x=x.parent}else{if(w.right.color==BLACK){w.left.color=BLACK;w.color=RED;this.rightRotate(w);w=x.parent.right}w.color=x.parent.color;x.parent.color=BLACK;w.right.color=BLACK;this.leftRotate(x.parent);x=this.root}}else{var w=
x.parent.left;if(w.color==RED){w.color=BLACK;x.parent.color=RED;this.rightRotate(x.parent);w=x.parent.left}if(w.right.color==BLACK&&w.left.color==BLACK){w.color=RED;x=x.parent}else{if(w.left.color==BLACK){w.right.color=BLACK;w.color=RED;this.leftRotate(w);w=x.parent.left}w.color=x.parent.color;x.parent.color=BLACK;w.left.color=BLACK;this.rightRotate(x.parent);x=this.root}}x.color=BLACK};
js_cols.RedBlackSet.prototype.remove=function(key){var x=this.get_(key);if(x!=this.sentinel){var retval=x.key;this.delete_(x);return retval}else return null};js_cols.RedBlackSet.prototype.removeSwapped=function(value,key){this.remove(key)};js_cols.RedBlackSet.prototype.min=function(x){while(x.left!=this.sentinel)x=x.left;return x};js_cols.RedBlackSet.prototype.max=function(x){while(x.right!=this.sentinel)x=x.right;return x};
js_cols.RedBlackSet.prototype.successor_=function(x){if(x.right!=this.sentinel)return this.min(x.right);var y=x.parent;while(y!=this.sentinel&&x==y.right){x=y;y=y.parent}return y};js_cols.RedBlackSet.prototype.predeccessor_=function(x){if(x.left!=this.sentinel)return this.max(x.left);var y=x.parent;while(y!=this.sentinel&&x==y.left){x=y;y=y.parent}return y};
js_cols.RedBlackSet.prototype.successor=function(key){if(this.size>0){var x=this.get_(key);if(x==this.sentinel)return null;if(x.right!=this.sentinel)return this.min(x.right).key;var y=x.parent;while(y!=this.sentinel&&x==y.right){x=y;y=y.parent}if(y!=this.sentinel)return y.key;else return null}else return null};
js_cols.RedBlackSet.prototype.predecessor=function(key){if(this.size>0){var x=this.get_(key);if(x==this.sentinel)return null;if(x.left!=this.sentinel)return this.max(x.left).key;var y=x.parent;while(y!=this.sentinel&&x==y.left){x=y;y=y.parent}if(y!=this.sentinel)return y.key;else return null}else return null};js_cols.RedBlackSet.prototype.getMin=function(){return this.min(this.root).key};js_cols.RedBlackSet.prototype.getMax=function(){return this.max(this.root).key};
js_cols.RedBlackSet.prototype.get_=function(key){var x=this.root;while(x!=this.sentinel&&this.compare(x.key,key)!=0)if(this.compare(key,x.key)<0)x=x.left;else x=x.right;return x};js_cols.RedBlackSet.prototype.contains=function(key){return this.get_(key).key!=null};js_cols.RedBlackSet.prototype.getValues=function(){var ret=[];this.forEach(function(x){ret.push(x)});return ret};
js_cols.RedBlackSet.prototype.insertAll=function(col){if(js_cols.typeOf(col)=="array")for(var i=0;i<col.length;i++)this.insert(col[i]);else if(js_cols.typeOf(col.forEach)=="function")col.forEach(this.insert,this);else if(js_cols.typeOf(col.getValues)=="function"){var arr=col.getValues();for(var i=0;i<arr.length;i++)this.insert(arr[i])}else if(js_cols.typeOf(col)=="object")for(var key in col)this.insert(col[key])};
js_cols.RedBlackSet.prototype.removeAll=function(col){if(js_cols.typeOf(col)=="array")for(var i=0;i<col.length;i++)this.remove(col[i]);else if(js_cols.typeOf(col.forEach)=="function")col.forEach(this.removeSwapped,this);else if(js_cols.typeOf(col.getValues)=="function"){var arr=col.getValues();for(var i=0;i<arr.length;i++)this.remove(arr[i])}else if(js_cols.typeOf(col)=="object")for(var key in col)this.remove(col[key])};
js_cols.RedBlackSet.prototype.containsAll=function(col){if(js_cols.typeOf(col)=="array"){for(var i=0;i<col.length;i++)if(!this.contains(col[i]))return false;return true}else if(js_cols.typeOf(col.forEach)=="function")return col.every(this.contains,this);else if(js_cols.typeOf(col.getValues)=="function"){var arr=col.getValues();for(var i=0;i<arr.length;i++)if(!this.contains(arr[i]))return false;return true}else if(js_cols.typeOf(col)=="object"){for(var key in col)if(!this.contains(col[key]))return false;
return true}};js_cols.RedBlackSet.prototype.range=function(from,to){var retArray=[];this.traverseFromTo(function(x){retArray.push(x)},from,to);return retArray};js_cols.RedBlackSet.prototype.traverse=function(f,opt_obj){if(this.isEmpty())return;var node=this.min(this.root);while(node!=this.sentinel){if(f.call(opt_obj,node.key,this))return;node=this.successor_(node)}};
js_cols.RedBlackSet.prototype.traverseFrom=function(f,fromKey,opt_obj){if(this.isEmpty())return;var node=this.get_(fromKey);while(node!=this.sentinel){if(f.call(opt_obj,node.key,this))return;node=this.successor_(node)}};js_cols.RedBlackSet.prototype.traverseTo=function(f,toKey,opt_obj){if(this.isEmpty())return;var node=this.min(this.root);var toNode=this.get_(toKey);while(node!=toNode){if(f.call(opt_obj,node.key,this))return;node=this.successor_(node)}};
js_cols.RedBlackSet.prototype.traverseFromTo=function(f,fromKey,toKey,opt_obj){if(this.isEmpty())return;var node=this.get_(fromKey);var toNode=this.get_(toKey);while(node!=toNode){if(f.call(opt_obj,node.key,this))return;node=this.successor_(node)}};js_cols.RedBlackSet.prototype.traverseBackwards=function(f,opt_obj){if(this.isEmpty())return;var node=this.max(this.root);while(node!=this.sentinel){if(f.call(opt_obj,node.key,this))return;node=this.predeccessor_(node)}};
js_cols.RedBlackSet.prototype.forEach=function(f,opt_obj){if(this.isEmpty())return;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))f.call(opt_obj,n.key,n.key,this)};js_cols.RedBlackSet.prototype.some=function(f,opt_obj){if(this.isEmpty())return false;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(f.call(opt_obj,n.key,n.key,this))return true;return false};
js_cols.RedBlackSet.prototype.every=function(f,opt_obj){if(this.isEmpty())return false;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(!f.call(opt_obj,n.key,n.key,this))return false;return true};js_cols.RedBlackSet.prototype.map=function(f,opt_obj){var rv=[];if(this.isEmpty())return rv;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))rv.push(f.call(opt_obj,n.key,n.key,this));return rv};
js_cols.RedBlackSet.prototype.filter=function(f,opt_obj){var rv=[];if(this.isEmpty())return rv;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(f.call(opt_obj,n.key,n.key,this))rv.push(n.key);return rv};js_cols.RedBlackSet.prototype.getCount=function(){return this.size};js_cols.RedBlackSet.prototype.isEmpty=function(){return this.size==0};
js_cols.RedBlackSet.prototype.isSubsetOf=function(col){var colCount=js_cols.getCount(col);if(this.getCount()>colCount)return false;var i=0;if(this.isEmpty())return true;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(js_cols.contains.call(col,col,n.key))i++;return i==this.getCount()};
js_cols.RedBlackSet.prototype.intersection=function(col){var result=new js_cols.RedBlackSet(this.compare);if(this.isEmpty())return result;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(col.contains.call(col,n.key,n.key,this))result.insert(n.key);return result};
C3.RedBlackSet=class RedBlackSet extends C3.DefendedBase{constructor(sortFunc){super();this._rbSet=new js_cols.RedBlackSet(sortFunc);this._enableQueue=false;this._queueInsert=new Set;this._queueRemove=new Set}Add(item){if(this._enableQueue)if(this._rbSet.contains(item))this._queueRemove.delete(item);else this._queueInsert.add(item);else this._rbSet.insert(item)}Remove(item){if(this._enableQueue)if(this._rbSet.contains(item))this._queueRemove.add(item);else this._queueInsert.delete(item);else this._rbSet.remove(item)}Has(item){if(this._enableQueue){if(this._queueInsert.has(item))return true;
return!this._queueRemove.has(item)&&this._rbSet.contains(item)}else return this._rbSet.contains(item)}Clear(){this._rbSet.clear();this._queueInsert.clear();this._queueRemove.clear()}toArray(){if(this._enableQueue)throw new Error("cannot be used in queueing mode");return this._rbSet.getValues()}GetSize(){return this._rbSet.getCount()+this._queueInsert.size-this._queueRemove.size}IsEmpty(){return this.GetSize()===0}Front(){if(this.IsEmpty())throw new Error("empty set");if(this._enableQueue)throw new Error("cannot be used in queueing mode");
const rbSet=this._rbSet;const n=rbSet.min(rbSet.root);return n.key}Shift(){if(this.IsEmpty())throw new Error("empty set");if(this._enableQueue)throw new Error("cannot be used in queueing mode");const item=this.Front();this.Remove(item);return item}SetQueueingEnabled(q){q=!!q;if(this._enableQueue===q)return;this._enableQueue=q;if(!q){for(const item of this._queueRemove)this._rbSet.remove(item);this._queueRemove.clear();for(const item of this._queueInsert)this._rbSet.insert(item);this._queueInsert.clear()}}ForEach(func){this._rbSet.forEach(func)}*values(){if(this.IsEmpty())return;
const rbSet=this._rbSet;for(let n=rbSet.min(rbSet.root);n!=rbSet.sentinel;n=rbSet.successor_(n))yield n.key}[Symbol.iterator](){return this.values()}};

}

// ../lib/util/promiseThrottle.js
{
'use strict';const C3=self.C3;
C3.PromiseThrottle=class PromiseThrottle{constructor(maxParallel=C3.hardwareConcurrency){this._maxParallel=maxParallel;this._queue=[];this._activeCount=0}Add(func){return new Promise((resolve,reject)=>{this._queue.push({func,resolve,reject});this._MaybeStartNext()})}_FindInQueue(func){for(let i=0,len=this._queue.length;i<len;++i)if(this._queue[i].func===func)return i;return-1}RemoveAndResolve(func,value){const i=this._FindInQueue(func);if(i===-1)throw new Error("cannot find promise to resolve");this._queue[i].resolve(value);
this._queue.splice(i,1)}RemoveAndReject(func,value){const i=this._FindInQueue(func);if(i===-1)throw new Error("cannot find promise to reject");this._queue[i].reject(value);this._queue.splice(i,1)}async _MaybeStartNext(){if(!this._queue.length)return;if(this._activeCount>=this._maxParallel)return;this._activeCount++;const job=this._queue.shift();try{const result=await job.func();job.resolve(result)}catch(err){job.reject(err)}this._activeCount--;this._MaybeStartNext()}static async Batch(concurrency,
methods){const results=[];let failed=false;const execute=async _=>{let fn;while(fn=methods.pop()){if(failed)return;try{results.push(await fn())}catch(e){failed=true;throw e;}}};const promises=[];while(concurrency--)promises.push(execute());await Promise.all(promises);return results}};

}

// ../lib/util/rateLimiter.js
{
'use strict';const C3=self.C3;
C3.RateLimiter=class RateLimiter{constructor(callback,interval,intervalOnBattery){this._callback=callback;this._interval=interval;this._intervalOnBattery=intervalOnBattery||interval*2;this._timerId=-1;this._lastCallTime=-Infinity;this._timerCallFunc=()=>this._OnTimer();this._ignoreReset=false;this._canRunImmediate=false;this._callbackArguments=null}SetCanRunImmediate(c){this._canRunImmediate=!!c}_GetInterval(){if(typeof C3.Battery!=="undefined"&&C3.Battery.IsOnBatteryPower())return this._intervalOnBattery;else return this._interval}Call(...args){if(this._timerId!==
-1)return;this._callbackArguments=args;let nowTime=C3.FastGetDateNow();let timeSinceLastCall=nowTime-this._lastCallTime;let interval=this._GetInterval();if(timeSinceLastCall>=interval&&this._canRunImmediate){this._lastCallTime=nowTime;this._RunCallback()}else this._timerId=self.setTimeout(this._timerCallFunc,Math.max(interval-timeSinceLastCall,4))}_RunCallback(){this._ignoreReset=true;const args=this._callbackArguments;this._callbackArguments=null;if(args)this._callback(...args);else this._callback();
this._ignoreReset=false}Reset(){if(this._ignoreReset)return;this._CancelTimer();this._callbackArguments=null;this._lastCallTime=C3.FastGetDateNow()}_OnTimer(){this._timerId=-1;this._lastCallTime=C3.FastGetDateNow();this._RunCallback()}_CancelTimer(){if(this._timerId!==-1){self.clearTimeout(this._timerId);this._timerId=-1}}Release(){this._CancelTimer();this._callback=null;this._callbackArguments=null;this._timerCallFunc=null}};

}

// ../lib/util/svgRaster/svgRasterManager.js
{
'use strict';const C3=self.C3;
C3.SVGRasterManager=class SVGRasterManager{constructor(){this._images=new Map;this._allowNpotSurfaces=false;this._getBaseSizeCallback=null;this._rasterAtSizeCallback=null;this._releaseResultCallback=null;this._redrawCallback=null}SetNpotSurfaceAllowed(a){this._allowNpotSurfaces=!!a}IsNpotSurfaceAllowed(){return this._allowNpotSurfaces}SetGetBaseSizeCallback(f){this._getBaseSizeCallback=f}GetBaseSize(dataSource){if(!this._getBaseSizeCallback)throw new Error("no get base size callback set");return this._getBaseSizeCallback(dataSource)}SetRasterAtSizeCallback(f){this._rasterAtSizeCallback=
f}RasterAtSize(dataSource,context,surfaceWidth,surfaceHeight,imageWidth,imageHeight){if(!this._rasterAtSizeCallback)throw new Error("no raster at size callback set");return this._rasterAtSizeCallback(dataSource,context,surfaceWidth,surfaceHeight,imageWidth,imageHeight)}SetReleaseResultCallback(f){this._releaseResultCallback=f}ReleaseResult(rasterizedResult){if(!this._releaseResultCallback)throw new Error("no release result callback set");this._releaseResultCallback(rasterizedResult)}SetRedrawCallback(f){this._redrawCallback=
f}Redraw(){if(!this._redrawCallback)throw new Error("no redraw callback set");this._redrawCallback()}AddImage(dataSource){let ret=this._images.get(dataSource);if(!ret){ret=C3.New(C3.SVGRasterImage,this,dataSource);this._images.set(dataSource,ret)}ret.IncReference();return ret}_RemoveImage(ri){this._images.delete(ri.GetDataSource())}OnTexturesChanged(){for(const ri of this._images.values()){ri.ReleaseRasterizedResult();ri.ForceRasterAgain()}}};

}

// ../lib/util/svgRaster/svgRasterImage.js
{
'use strict';const C3=self.C3;const MAX_SURFACE_SIZE=4096;
C3.SVGRasterImage=class SVGRasterImage{constructor(manager,dataSource){this._manager=manager;this._dataSource=dataSource;this._refCount=0;this._baseWidth=0;this._baseHeight=0;this._getBaseSizePromise=this._manager.GetBaseSize(dataSource).then(baseSize=>{if(!this._manager)return;this._baseWidth=baseSize[0];this._baseHeight=baseSize[1];this._manager.Redraw()}).catch(err=>{console.error("[SVG] Error loading SVG: ",err);this._hadError=true;if(this._manager)this._manager.Redraw()});this._rasterSurfaceWidth=
0;this._rasterSurfaceHeight=0;this._rasterImageWidth=0;this._rasterImageHeight=0;this._isRasterizing=false;this._rasterizedResult=null;this._forceRaster=false;this._hadError=false}Release(){if(this._refCount<=0)throw new Error("already released");this._refCount--;if(this._refCount===0)this._Release()}ReleaseRasterizedResult(){if(this._rasterizedResult){this._manager.ReleaseResult(this._rasterizedResult);this._rasterizedResult=null}}_Release(){this.ReleaseRasterizedResult();this._manager._RemoveImage(this);
this._manager=null}GetDataSource(){return this._dataSource}IncReference(){this._refCount++}HasReferences(){return this._refCount>0}GetRasterizedResult(){return this._rasterizedResult}ForceRasterAgain(){this._forceRaster=true}async StartRasterForSize(context,width,height){if(width===0||height===0||this._hadError)return;if(this._isRasterizing)return;let rasterSurfaceWidth=C3.nextHighestPowerOfTwo(Math.ceil(width));let rasterSurfaceHeight=C3.nextHighestPowerOfTwo(Math.ceil(height));const maxDim=Math.max(rasterSurfaceWidth,
rasterSurfaceHeight);if(maxDim>MAX_SURFACE_SIZE){const scale=MAX_SURFACE_SIZE/maxDim;width*=scale;height*=scale;rasterSurfaceWidth=Math.min(Math.ceil(rasterSurfaceWidth*scale),MAX_SURFACE_SIZE);rasterSurfaceHeight=Math.min(Math.ceil(rasterSurfaceHeight*scale),MAX_SURFACE_SIZE)}if(width<rasterSurfaceWidth&&height<rasterSurfaceHeight){const imageAspectRatio=width/height;const surfaceAspectRatio=rasterSurfaceWidth/rasterSurfaceHeight;if(surfaceAspectRatio>imageAspectRatio){width=rasterSurfaceHeight*
imageAspectRatio;height=rasterSurfaceHeight}else{width=rasterSurfaceWidth;height=rasterSurfaceWidth/imageAspectRatio}}if(this._manager.IsNpotSurfaceAllowed()){rasterSurfaceWidth=Math.ceil(width);rasterSurfaceHeight=Math.ceil(height)}if(rasterSurfaceWidth<=this._rasterSurfaceWidth&&rasterSurfaceHeight<=this._rasterSurfaceHeight&&!this._forceRaster)return;this._isRasterizing=true;this._rasterSurfaceWidth=rasterSurfaceWidth;this._rasterSurfaceHeight=rasterSurfaceHeight;const newRasterizedResult=await this._manager.RasterAtSize(this._dataSource,
context,this._rasterSurfaceWidth,this._rasterSurfaceHeight,width,height);if(!this._manager)return;this.ReleaseRasterizedResult();this._rasterizedResult=newRasterizedResult;this._rasterImageWidth=width;this._rasterImageHeight=height;this._isRasterizing=false;this._forceRaster=false;this._manager.Redraw()}WhenBaseSizeReady(){return this._getBaseSizePromise}GetBaseWidth(){return this._baseWidth}GetBaseHeight(){return this._baseHeight}GetRasterWidth(){return this._rasterImageWidth}GetRasterHeight(){return this._rasterImageHeight}HadError(){return this._hadError}};

}

// ../lib/str/str.js
{
'use strict';const C3=self.C3;C3.UTF8_BOM="\ufeff";const NUMERIC_CHARS=new Set([..."0123456789"]);C3.IsNumericChar=function IsNumericChar(c){return NUMERIC_CHARS.has(c)};const WHITESPACE_CHARS=new Set([..." \t\n\r\u00a0\u0085\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u2028\u2029\u202f\u205f\u3000"]);C3.IsWhitespaceChar=function IsWhitespaceChar(c){return WHITESPACE_CHARS.has(c)};C3.FilterWhitespace=function FilterWhitespace(str){return[...str].filter(ch=>!C3.IsWhitespaceChar(ch)).join("")};
C3.IsStringAllWhitespace=function IsStringAllWhitespace(str){for(const ch of str)if(!C3.IsWhitespaceChar(ch))return false;return true};C3.IsCharArrayAllWhitespace=function IsStringAllWhitespace(chArr){for(const ch of chArr)if(!C3.IsWhitespaceChar(ch))return false;return true};C3.IsUnprintableChar=function IsUnprintableChar(c){return c.length===1&&c.charCodeAt(0)<32};C3.FilterUnprintableChars=function FilterUnprintableChars(str){return[...str].filter(ch=>!C3.IsUnprintableChar(ch)).join("")};
const NUMERIC_STRING_CHARS=new Set([..."0123456789.+-e"]);C3.IsStringNumber=function IsStringNumber(str){str=str.trim();if(!str.length)return false;let firstChar=str.charAt(0);if(firstChar!=="-"&&!NUMERIC_CHARS.has(firstChar))return false;for(let ch of str)if(!NUMERIC_STRING_CHARS.has(ch))return false;return true};C3.RemoveTrailingDigits=function RemoveTrailingDigits(str){let i=str.length;while(i>0){let prev_ch=str.charAt(i-1);if(!C3.IsNumericChar(prev_ch))break;--i}return str.substr(0,i)};
C3.IncrementNumberAtEndOf=function IncrementNumberAtEndOf(str){let baseStr=C3.RemoveTrailingDigits(str);let numberStr=str.substr(baseStr.length);if(numberStr)numberStr=(parseInt(numberStr,10)+1).toString();else numberStr="2";return baseStr+numberStr};const HTML_ENTITY_MAP=new Map([["&","&amp;"],["<","&lt;"],[">","&gt;"],['"',"&quot;"],["'","&#39;"]]);function lookupHtmlEntity(s){return HTML_ENTITY_MAP.get(s)}const HTML_ENTITY_REGEX=/[&<>"']/g;
C3.EscapeHTML=function EscapeHTML(str){return str.replace(HTML_ENTITY_REGEX,lookupHtmlEntity)};C3.EscapeJS=function EscapeJS(str){let ret=C3.ReplaceAll(str,"\\","\\\\");ret=C3.ReplaceAll(ret,'"','\\"');ret=C3.ReplaceAll(ret,"\t","\\t");ret=C3.ReplaceAll(ret,"\r","");return C3.ReplaceAll(ret,"\n","\\n")};C3.EscapeXML=function EscapeXML(str){let ret=C3.ReplaceAll(str,"&","&amp;");ret=C3.ReplaceAll(ret,"<","&lt;");ret=C3.ReplaceAll(ret,">","&gt;");return C3.ReplaceAll(ret,'"',"&quot;")};
const ESCAPE_REGEX=/[-[\]{}()*+?.,\\^$|#\s]/g;C3.EscapeRegex=function EscapeRegex(str){return str.replace(ESCAPE_REGEX,"\\$&")};C3.CountCharsInString=function CountCharsInString(str,ch){let count=0;for(const c of str)if(c===ch)++count;return count};
C3.FindAll=function FindAll(str,find,matchCase=false){if(!find)return[];if(!matchCase){str=str.toLowerCase();find=find.toLowerCase()}const findLen=find.length;let startIndex=0;let index=0;let ret=[];while((index=str.indexOf(find,startIndex))>-1){ret.push(index);startIndex=index+findLen}return ret};C3.ReplaceAll=function ReplaceAll(str,find,replace){return str.replaceAll(find,()=>replace)};
C3.ReplaceAllCaseInsensitive=function ReplaceAll(str,find,replace){return str.replace(new RegExp(C3.EscapeRegex(find),"gi"),()=>replace)};C3.SetElementContent=function SetElementContent(elem,stringlike){if(typeof stringlike==="string")elem.textContent=stringlike;else if(stringlike.isPlainText())elem.textContent=stringlike.toString();else{elem.innerHTML=stringlike.toHTML();if(stringlike instanceof C3.BBString)stringlike.attachLinkHandlers(elem)}};
C3.StringLikeEquals=function StringLikeEquals(a,b){if(a instanceof C3.HtmlString||a instanceof C3.BBString)return a.equals(b);else if(b instanceof C3.HtmlString||b instanceof C3.BBString)return b.equals(a);else return a===b};C3.StringSubstitute=function StringSubstitute(str,...arr){let ret=str;for(let i=0,len=arr.length;i<len;++i){const sub=`{${i}}`;if(!str.includes(sub))throw new Error(`missing placeholder '${sub}' in string substitution`);ret=ret.replace(sub,arr[i].toString())}return ret};
C3.StringSubstituteAllowMissing=function StringSubstituteAllowMissing(str,...arr){let ret=str;let lowestMissingIndex=-1;let highestUsedIndex=-1;for(let i=0,len=arr.length;i<len;++i){const sub=`{${i}}`;if(str.includes(sub)){highestUsedIndex=i;ret=ret.replace(sub,arr[i].toString())}else if(lowestMissingIndex===-1)lowestMissingIndex=i}if(lowestMissingIndex>=0&&highestUsedIndex>=0&&lowestMissingIndex<highestUsedIndex)throw new Error(`missing placeholder '${lowestMissingIndex}' in string substitution`);
return ret};C3.StringSubstituteMap=function StringSubstituteMap(str,o){let ret=str;for(let [placeholder,substitution]of Object.entries(o))ret=ret.replaceAll(placeholder,substitution.toString());return ret};C3.SortAZ=function SortAZ(a,b){if(a>b)return 1;else if(a<b)return-1;else return 0};C3.SortAZCaseInsensitive=function SortAZCaseInsensitive(a,b){let lowerA=a.toLowerCase();let lowerB=b.toLowerCase();if(lowerA>lowerB)return 1;else if(lowerA<lowerB)return-1;else return 0};let intlSegmenter=null;
let graphemeSplitter=null;if(self["Intl"]&&self["Intl"]["Segmenter"])intlSegmenter=new self["Intl"]["Segmenter"];else graphemeSplitter=new self.GraphemeSplitter;C3.SplitGraphemes=function SplitGraphemes(str){if(intlSegmenter){const ret=[];for(const s of intlSegmenter["segment"](str))ret.push(s["segment"]);return ret}else return graphemeSplitter.splitGraphemes(str)};C3.IterateGraphemes=function*IterateGraphemes(str){if(intlSegmenter)for(const s of intlSegmenter["segment"](str))yield s["segment"];else yield*graphemeSplitter.iterateGraphemes(str)};
C3.CountGraphemes=function CountGraphemes(str){if(intlSegmenter){let ret=0;for(const s of intlSegmenter["segment"](str))++ret;return ret}else return graphemeSplitter.countGraphemes(str)};const KILOBYTE=1024;const MEGABYTE=KILOBYTE*1024;const GIGABYTE=MEGABYTE*1024;const TERABYTE=GIGABYTE*1024;
C3.FormatDataSize=function FormatDataSize(sizeInBytes,asRate){let rootKey="common."+(asRate?"dataRates":"dataSizes")+".";const langSub=self.langSub;if(sizeInBytes<KILOBYTE)return langSub(rootKey+"bytes",sizeInBytes);else if(sizeInBytes<MEGABYTE){let kb=sizeInBytes/KILOBYTE;if(kb<10)kb=Math.round(kb*10)/10;else kb=Math.round(kb);return langSub(rootKey+"kilobytes",kb)}else if(sizeInBytes<GIGABYTE){let mb=sizeInBytes/MEGABYTE;if(mb<10)mb=Math.round(mb*10)/10;else mb=Math.round(mb);return langSub(rootKey+
"megabytes",mb)}else if(sizeInBytes<TERABYTE){let gb=sizeInBytes/GIGABYTE;if(gb<10)gb=Math.round(gb*10)/10;else gb=Math.round(gb);return langSub(rootKey+"gigabytes",gb)}else{let tb=sizeInBytes/TERABYTE;if(tb<10)tb=Math.round(tb*10)/10;else tb=Math.round(tb);return langSub(rootKey+"terabytes",tb)}};const DEFAULT_FORMATTIME_OPTS={approximate:false,days:true,hours:true,minutes:true,seconds:true};
C3.FormatTime=function FormatTime(secondsTotal,opts){opts=Object.assign({},DEFAULT_FORMATTIME_OPTS,opts);C3.Lang.PushContext("common.time");const parts=[];const lang=self.lang;const langPluralSub=self.langPluralSub;if(opts.days){const days=Math.floor(secondsTotal/(24*3600));if(days>0){secondsTotal-=days*24*3600;parts.push(langPluralSub(".days",null,days))}}if(opts.hours){const hours=Math.floor(secondsTotal/3600);if(hours>0||parts.length){secondsTotal-=hours*3600;parts.push(langPluralSub(".hours",
null,hours))}}if(opts.minutes){const minutes=Math.floor(secondsTotal/60);if(minutes>0||parts.length||!opts.seconds){secondsTotal-=minutes*60;parts.push(langPluralSub(".minutes",null,minutes))}}if(opts.seconds){const seconds=Math.floor(secondsTotal%60);parts.push(langPluralSub(".seconds",null,seconds))}const ret=(opts.approximate?lang(".approx-prefix"):"")+parts.join(lang(".separator"));C3.Lang.PopContext();return ret};
C3.ZeroPad=function(n,d){let s=n<0?"-":"";n=Math.abs(n);let nStr=n.toString();let zeroes=d-nStr.length;for(let i=0;i<zeroes;++i)s+="0";return s+nStr};C3.StringToTitleCase=function StringToTitleCase(str){return str.toLowerCase().replace(/\b\w/g,t=>t.toUpperCase())};
C3.CompareVersionStrings=function CompareVersionStrings(v1,v2){let a1=v1.split(".").map(s=>s.trim());let a2=v2.split(".").map(s=>s.trim());C3.resizeArray(a1,4,"0");C3.resizeArray(a2,4,"0");a1=a1.map(s=>parseInt(s,10));a2=a2.map(s=>parseInt(s,10));for(let i=0;i<4;++i){const diff=a1[i]-a2[i];if(diff!==0)return diff<0?-1:1}return 0};C3.CreateGUID=function CreateGUID(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,c=>{const r=Math.floor(Math.random()*16);const v=c==="x"?r:r&3|8;return v.toString(16)})};
C3.StringHammingDistance=function StringHammingDistance(a,b){if(a.length!==b.length)throw new Error("strings must be same length");let ret=0;for(let i=0,len=a.length;i<len;++i)if(a.charAt(i)!==b.charAt(i))++ret;return ret};
C3.StringLevenshteinDistance=function StringLevenshteinDistance(a,b){if(a.length===0)return b.length;if(b.length===0)return a.length;let tmp,i,j,prev,val,row;if(a.length>b.length){tmp=a;a=b;b=tmp}row=Array(a.length+1);for(i=0;i<=a.length;i++)row[i]=i;for(i=1;i<=b.length;i++){prev=i;for(j=1;j<=a.length;j++){if(b[i-1]===a[j-1])val=row[j-1];else val=Math.min(row[j-1]+1,Math.min(prev+1,row[j]+1));row[j-1]=prev;prev=val}row[a.length]=prev}return row[a.length]};

}

// ../lib/str/bbstring.js
{
'use strict';const C3=self.C3;const assert=self.assert;
const BB_CODE_MAP=new Map([["b","strong"],["i","em"],["s","s"],["u","u"],["sub","sub"],["sup","sup"],["small","small"],["mark","mark"],["code","code"],["a1","a"],["a2","a"],["a3","a"],["a4","a"],["a5","a"],["a6","a"],["a7","a"],["a8","a"],["a9","a"],["tip1","abbr"],["tip2","abbr"],["tip3","abbr"],["tip4","abbr"],["tip5","abbr"],["tip6","abbr"],["tip7","abbr"],["tip8","abbr"],["tip9","abbr"],["bad",["span","bbCodeBad"]],["good",["span","bbCodeGood"]],["info",["span","bbCodeInfo"]],["h1",["span","bbCodeH1"]],
["h2",["span","bbCodeH2"]],["h3",["span","bbCodeH3"]],["h4",["span","bbCodeH4"]],["item",["span","bbCodeItem"]]]);const BBREGEX=/\[(\/?)([a-zA-Z0-9]+)\]/g;const CUSTOM_BBREGEX=/\[(\/?)([^\[\n]*?)\]/g;let linkActions=null;let tipList=null;let classIndex=0;
function bbToHtmlReplacerFunc(match,closeSlash,tagName){const entry=BB_CODE_MAP.get(tagName);if(entry)if(typeof entry==="string"){if(entry==="a"&&linkActions.length===0||entry==="abbr"&&tipList.length===0)return match;if(entry==="a"&&!closeSlash){const index=parseInt(tagName.substring(1),10)-1;if(index<0||index>=linkActions.length)throw new Error("invalid bbcode link substitution");const linkAction=linkActions[index];if(typeof linkAction==="string")return`<a href="${linkActions[index]}">`;else if(typeof linkAction===
"function")return`<a class="bblink${index}">`;else throw new TypeError("invalid bbcode link action");}else if(entry==="abbr"&&!closeSlash){const index=parseInt(tagName.substring(3),10)-1;if(index<0||index>=tipList.length)throw new Error("invalid bbcode tip substitution");const tip=tipList[index];let tipStr="";if(typeof tip==="string")tipStr=tip;else if(typeof tip==="function")tipStr=tip();if(typeof tipStr!=="string")throw new TypeError("invalid bbcode tip");return`<abbr title="${C3.ReplaceAll(tipStr,
'"',"&quot;")}">`}else return"<"+closeSlash+entry+">"}else if(Array.isArray(entry)){let tag=entry[0];let className=entry[1];if(closeSlash)return"</"+tag+">";else return`<${tag} class="${className}">`}else;else if(tagName==="class")if(closeSlash)return"</span>";else return`<span class="bbclass${classIndex++}">`;else return match}const LINEBREAK_REGEX=/\n/g;
C3.BBString=class BBString{constructor(str,opts){this._bbstr=opts&&opts.noEscape?str:C3.EscapeHTML(str);this._htmlstr="";this._convertLineBreaks=false;this._linkActions=[];this._tipList=[];if(opts){this._convertLineBreaks=!!opts.convertLineBreaks;if(opts.links){if(opts.links.length>9)throw new Error("too many links");this._linkActions=opts.links}if(opts.tips){if(opts.tips.length>9)throw new Error("too many tips");this._tipList=opts.tips}}this._hasAnyBBtags=this._bbstr.includes("[");this._needsLineBreakConversion=
this._convertLineBreaks&&this._bbstr.includes("\n");this._isPlain=!this._hasAnyBBtags&&!this._needsLineBreakConversion&&!this._bbstr.includes("&");this._hasParsedFragments=false;this._fragments=[]}toString(){return this._bbstr}valueOf(){return this._bbstr}isPlainText(){return this._isPlain}toPlainText(){if(this._hasAnyBBtags)return this._bbstr.replace(BBREGEX,"");else return this._bbstr}toHTML(){if(this._isPlain)return this._bbstr;if(!this._htmlstr&&this._bbstr){let str=this._bbstr;if(this._hasAnyBBtags){classIndex=
0;linkActions=this._linkActions;tipList=this._tipList;str=str.replace(BBREGEX,bbToHtmlReplacerFunc);linkActions=null;tipList=null}if(this._needsLineBreakConversion)str=str.replace(LINEBREAK_REGEX,"<br>");this._htmlstr=str}return this._htmlstr}attachLinkHandlers(parentElem){if(!this._linkActions.length)return;for(let i=0,len=this._linkActions.length;i<len;++i){const linkAction=this._linkActions[i];if(typeof linkAction!=="function")continue;const linkElem=parentElem.querySelector(".bblink"+i);if(!linkElem)throw new Error("unable to attach BBString link handler");
linkElem.onclick=linkAction}}equals(s){if(s instanceof C3.HtmlString)return this.toHTML()===s.toHTML();else if(s instanceof C3.BBString)return this._bbstr===s._bbstr;else return this._bbstr===s}toFragmentList(){if(this._hasParsedFragments)return this._fragments;const bbStr=this._bbstr;const styleStack=[];CUSTOM_BBREGEX.lastIndex=0;let prevIndex=0;let result=null;while((result=CUSTOM_BBREGEX.exec(bbStr))!==null){const index=result.index;if(index>0&&bbStr.charAt(index-1)==="\\")continue;const matchStr=
result[0];const closeSlash=result[1];const tagName=result[2];const strFrag=bbStr.substring(prevIndex,index);prevIndex=index+matchStr.length;if(strFrag)this._fragments.push({text:strFrag,styles:styleStack.slice(0)});if(!tagName)continue;if(closeSlash){const lowerTagName=tagName.toLowerCase();for(let i=styleStack.length-1;i>=0;--i)if(styleStack[i].tag===lowerTagName){styleStack.splice(i,1);break}}else{let tag=tagName;let param=null;const eq=tagName.indexOf("=");if(eq!==-1){tag=tagName.substring(0,eq).toLowerCase();
param=tagName.substring(eq+1)}else tag=tag.toLowerCase();styleStack.push({tag,param})}}if(prevIndex<bbStr.length)this._fragments.push({text:bbStr.substring(prevIndex),styles:styleStack.slice(0)});for(const frag of this._fragments)frag.text=this._ProcessBBCodeEscapeSequences(frag.text);this._hasParsedFragments=true;return this._fragments}_ProcessBBCodeEscapeSequences(text){text=C3.ReplaceAll(text,"\\[","[");return C3.ReplaceAll(text,"\\\\","\\")}static StripTags(str){return C3.New(C3.BBString,str,
{noEscape:true}).toPlainText()}static StripAnyTags(str){return str.replace(CUSTOM_BBREGEX,"")}};

}

// ../lib/str/wordWrap.js
{
'use strict';const C3=self.C3;function IsWordBreakWhiteSpace(ch){if(ch==="\u00a0"||ch==="\u202f")return false;else return C3.IsWhitespaceChar(ch)}function WordBreakTrimEnd(chArr){while(chArr.length>0&&IsWordBreakWhiteSpace(chArr.at(-1)))chArr.pop()}function IsNewline(ch){return ch==="\n"||ch==="\r\n"}
C3.WordWrap=class WordWrap{constructor(){this._lines=[]}GetLines(){return this._lines}GetLineCount(){return this._lines.length}_MeasureLine(line,measureFunc){let width=0;let height=0;let fbbAscent=0;let fbbDescent=0;let topToAlphabeticDistance=0;for(const frag of line){if(frag.width===-1){const m=measureFunc(frag.chArr,frag.styles);frag.width=m.width;frag.height=m.height;frag.fontBoundingBoxAscent=m.fontBoundingBoxAscent||0;frag.fontBoundingBoxDescent=m.fontBoundingBoxDescent||0;frag.topToAlphabeticDistance=
m.topToAlphabeticDistance||0}width+=frag.width;height=Math.max(height,frag.height);fbbAscent=Math.max(fbbAscent,frag.fontBoundingBoxAscent);fbbDescent=Math.max(fbbDescent,frag.fontBoundingBoxDescent);topToAlphabeticDistance=Math.max(topToAlphabeticDistance,frag.topToAlphabeticDistance)}return{width,height,fontBoundingBoxAscent:fbbAscent,fontBoundingBoxDescent:fbbDescent,topToAlphabeticDistance}}_AddLine(fragments,width,height,fbbAscent,fbbDescent,topToAlphabeticDistance){this._lines.push({fragments,
width,height,fontBoundingBoxAscent:fbbAscent,fontBoundingBoxDescent:fbbDescent,topToAlphabeticDistance})}WordWrap(fragmentArr,measureFunc,wrapWidth,wrapMode,endOfLineMargin){if(typeof fragmentArr==="string")fragmentArr=[{text:fragmentArr,styles:[]}];C3.clearArray(this._lines);if(!fragmentArr.length||fragmentArr.length===1&&!fragmentArr[0].text.length||wrapWidth<2)return;fragmentArr=fragmentArr.map(frag=>({chArr:C3.SplitGraphemes(frag.text),styles:frag.styles}));if(fragmentArr.length===1){const frag=
fragmentArr[0];const chArr=frag.chArr;const styles=frag.styles;if(chArr.length<=100&&!chArr.includes("\n")){let {width,height,fontBoundingBoxAscent,fontBoundingBoxDescent,topToAlphabeticDistance}=measureFunc(chArr,styles);width+=endOfLineMargin;fontBoundingBoxAscent=fontBoundingBoxAscent||0;fontBoundingBoxDescent=fontBoundingBoxDescent||0;topToAlphabeticDistance=topToAlphabeticDistance||0;if(width<=wrapWidth){this._AddLine([{chArr,styles,width,height,fontBoundingBoxAscent,fontBoundingBoxDescent,topToAlphabeticDistance}],
width,height,fontBoundingBoxAscent,fontBoundingBoxDescent,topToAlphabeticDistance);return}}}let tokenisedFragments;if(wrapMode==="word")tokenisedFragments=this._TokeniseWords(fragmentArr);else{tokenisedFragments=[];for(const frag of fragmentArr)C3.appendArray(tokenisedFragments,frag.chArr.map(ch=>[{chArr:[ch],styles:frag.styles}]))}this._WrapText(tokenisedFragments,measureFunc,wrapWidth,endOfLineMargin)}_TokeniseWords(fragmentArr){const ret=[];let curWord=[];let isCurWhitespace=false;for(const frag of fragmentArr){const chArr=
frag.chArr;const styles=frag.styles;for(const ch of chArr)if(IsNewline(ch)){if(curWord.length>0)ret.push(curWord);ret.push([{chArr:["\n"],styles}]);curWord=[]}else if(curWord.length===0){curWord.push({chArr:[ch],styles});isCurWhitespace=IsWordBreakWhiteSpace(ch)}else{const isWhitespace=IsWordBreakWhiteSpace(ch);if(isWhitespace===isCurWhitespace){const curFrag=curWord.at(-1);if(curFrag.styles===styles)curFrag.chArr.push(ch);else curWord.push({chArr:[ch],styles})}else{ret.push(curWord);curWord=[];curWord.push({chArr:[ch],
styles});isCurWhitespace=isWhitespace}}}if(curWord.length>0)ret.push(curWord);return ret}_CopyLine(line){return line.map(f=>({chArr:f.chArr.slice(0),styles:f.styles,width:f.width,height:f.height,fontBoundingBoxAscent:f.fontBoundingBoxAscent,fontBoundingBoxDescent:f.fontBoundingBoxDescent,topToAlphabeticDistance:f.topToAlphabeticDistance}))}_AddWordToLine(currentLine,curWord){const lastFrag=currentLine.length?currentLine.at(-1):null;let i=0;if(lastFrag&&curWord[0].styles===lastFrag.styles){C3.appendArray(lastFrag.chArr,
curWord[0].chArr);lastFrag.width=-1;lastFrag.height=-1;lastFrag.fontBoundingBoxAscent=-1;lastFrag.fontBoundingBoxDescent=-1;lastFrag.topToAlphabeticDistance=-1;i=1}for(let len=curWord.length;i<len;++i){const f=curWord[i];currentLine.push({chArr:f.chArr.slice(0),styles:f.styles,width:-1,height:-1,fontBoundingBoxAscent:-1,fontBoundingBoxDescent:-1,topToAlphabeticDistance:-1})}}_WrapText(tokenisedFragments,measureFunc,wrapWidth,endOfLineMargin){let currentLine=[];let currentLineWidth=0;let currentLineHeight=
0;let currentLineFbbAscent=0;let currentLineFbbDescent=0;let currentLineTopToAlphabetic=0;for(const curWord of tokenisedFragments){if(curWord.length===1&&curWord[0].chArr.length===1&&IsNewline(curWord[0].chArr[0])){if(currentLineHeight===0){const m=measureFunc([" "],curWord[0].styles);currentLineHeight=m.height;currentLineFbbAscent=m.fontBoundingBoxAscent||0;currentLineFbbDescent=m.fontBoundingBoxDescent||0;currentLineTopToAlphabetic=m.topToAlphabeticDistance||0}this._AddLine(currentLine,currentLineWidth,
currentLineHeight,currentLineFbbAscent,currentLineFbbDescent,currentLineTopToAlphabetic);currentLine=[];currentLineWidth=0;currentLineHeight=0;currentLineFbbAscent=0;currentLineFbbDescent=0;currentLineTopToAlphabetic=0;continue}const tryLine=this._CopyLine(currentLine);this._AddWordToLine(tryLine,curWord);const tryMetrics=this._MeasureLine(tryLine,measureFunc);const tryLineWidth=tryMetrics.width;if(tryLineWidth>=wrapWidth){if(currentLine.length>0)this._AddLine(currentLine,currentLineWidth,currentLineHeight,
currentLineFbbAscent,currentLineFbbDescent,currentLineTopToAlphabetic);currentLine=[];if(C3.IsCharArrayAllWhitespace(curWord[0].chArr)){currentLineWidth=0;currentLineHeight=0;currentLineFbbAscent=0;currentLineFbbDescent=0;currentLineTopToAlphabetic=0}else{this._AddWordToLine(currentLine,curWord);const metrics=this._MeasureLine(currentLine,measureFunc);currentLineWidth=metrics.width;currentLineHeight=metrics.height;currentLineFbbAscent=metrics.fontBoundingBoxAscent;currentLineFbbDescent=metrics.fontBoundingBoxDescent;
currentLineTopToAlphabetic=metrics.topToAlphabeticDistance}}else{currentLine=tryLine;currentLineWidth=tryLineWidth;currentLineHeight=tryMetrics.height;currentLineFbbAscent=tryMetrics.fontBoundingBoxAscent;currentLineFbbDescent=tryMetrics.fontBoundingBoxDescent;currentLineTopToAlphabetic=tryMetrics.topToAlphabeticDistance}}if(currentLine.length>0)this._AddLine(currentLine,currentLineWidth,currentLineHeight,currentLineFbbAscent,currentLineFbbDescent,currentLineTopToAlphabetic);this._TrimLinesTrailingWhitespace(measureFunc,
endOfLineMargin)}_TrimLinesTrailingWhitespace(measureFunc,endOfLineMargin){for(const line of this._lines){const fragments=line.fragments;if(!fragments.length)continue;let lastFrag=fragments.at(-1);const chArr=lastFrag.chArr;const trimmedArr=chArr.slice(0);WordBreakTrimEnd(trimmedArr);if(trimmedArr.length===0){line.width-=lastFrag.width;fragments.pop()}else if(trimmedArr.length<chArr.length){const trimmedWidth=measureFunc(trimmedArr,lastFrag.styles).width;const diff=lastFrag.width-trimmedWidth;lastFrag.width=
trimmedWidth;lastFrag.chArr=trimmedArr;line.width-=diff}if(endOfLineMargin!==0&&fragments.length>0){lastFrag=fragments.at(-1);lastFrag.width+=endOfLineMargin;line.width+=endOfLineMargin}}}Clear(){C3.clearArray(this._lines)}GetMaxLineWidth(){return this._lines.reduce((a,v)=>Math.max(a,v.width),0)}GetTotalLineHeight(){return this._lines.reduce((a,v)=>a+v.height,0)}};

}

// ../lib/gfx/gfx.js
{
'use strict';const C3=self.C3;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const vec4=glMatrix.vec4;const mat4=glMatrix.mat4;const tempVec3a=vec3.create();const tempVec3b=vec3.create();const tempVec3c=vec3.create();const tempVec4=vec4.create();const tempMat4=mat4.create();const neartl=vec3.create();const neartr=vec3.create();const nearbl=vec3.create();const nearbr=vec3.create();const fartl=vec3.create();const fartr=vec3.create();const farbl=vec3.create();const farbr=vec3.create();
const unitViewport=vec4.fromValues(0,0,1,1);
C3.Gfx={Project(objx,objy,objz,mv,proj,viewport,windowCoordinate){const fTemp0=mv[0]*objx+mv[4]*objy+mv[8]*objz+mv[12];const fTemp1=mv[1]*objx+mv[5]*objy+mv[9]*objz+mv[13];const fTemp2=mv[2]*objx+mv[6]*objy+mv[10]*objz+mv[14];const fTemp3=mv[3]*objx+mv[7]*objy+mv[11]*objz+mv[15];let fTemp4=proj[0]*fTemp0+proj[4]*fTemp1+proj[8]*fTemp2+proj[12]*fTemp3;let fTemp5=proj[1]*fTemp0+proj[5]*fTemp1+proj[9]*fTemp2+proj[13]*fTemp3;let fTemp6=proj[2]*fTemp0+proj[6]*fTemp1+proj[10]*fTemp2+proj[14]*fTemp3;let fTemp7=
proj[3]*fTemp0+proj[7]*fTemp1+proj[11]*fTemp2+proj[15]*fTemp3;if(fTemp7===0)return false;fTemp7=1/fTemp7;fTemp4*=fTemp7;fTemp5*=fTemp7;fTemp6*=fTemp7;windowCoordinate[0]=(fTemp4*.5+.5)*viewport[2]+viewport[0];windowCoordinate[1]=(fTemp5*.5+.5)*viewport[3]+viewport[1];windowCoordinate[2]=(1+fTemp6)*.5;return true},Unproject(winx,winy,winz,mv,proj,viewport,objectCoordinate){const A=tempMat4;const vec=tempVec4;mat4.multiply(A,proj,mv);if(mat4.invert(A,A)===null)return false;vec[0]=(winx-viewport[0])/
viewport[2]*2-1;vec[1]=(winy-viewport[1])/viewport[3]*2-1;vec[2]=2*winz-1;vec[3]=1;vec4.transformMat4(vec,vec,A);if(vec[3]===0)return false;vec[3]=1/vec[3];objectCoordinate[0]=vec[0]*vec[3];objectCoordinate[1]=vec[1]*vec[3];objectCoordinate[2]=vec[2]*vec[3];return true},UnprojectScreenToWorldZ(winx,winy,worldZ,mv,proj,viewport,objectCoordinate){const nearPt=tempVec3a;const farPt=tempVec3b;if(!C3.Gfx.Unproject(winx,winy,0,mv,proj,viewport,nearPt))return false;if(!C3.Gfx.Unproject(winx,winy,1,mv,proj,
viewport,farPt))return false;const dirVec=tempVec3b;vec3.subtract(dirVec,farPt,nearPt);const planeNormal=tempVec3c;vec3.set(planeNormal,0,0,1);const planeConstant=-worldZ;const denominator=vec3.dot(planeNormal,dirVec);let distance=0;if(denominator===0){const planeDistToPt=vec3.dot(planeNormal,nearPt)+planeConstant;if(planeDistToPt!==0)return false}else{distance=-(vec3.dot(nearPt,planeNormal)+planeConstant)/denominator;if(distance<0)return false}vec3.scaleAndAdd(objectCoordinate,nearPt,dirVec,distance);
return true}};function PlaneFromPoints(ptA,ptB,ptC,plane){const normal=tempVec3c;vec3.subtract(tempVec3a,ptC,ptB);vec3.subtract(tempVec3b,ptA,ptB);vec3.cross(normal,tempVec3a,tempVec3b);vec3.normalize(normal,normal);plane.set(normal[0],normal[1],normal[2],vec3.dot(ptA,normal))}
function IsInFrontOfPlane(minX,minY,minZ,maxX,maxY,maxZ,plane){const nx=plane.x;const ny=plane.y;const nz=plane.z;const d=plane.w;const nxT=plane.xF;const nyT=plane.yF;const nzT=plane.zF;const nxF=1-nxT;const nyF=1-nyT;const nzF=1-nzT;const minD=nx*minX*nxT+nx*maxX*nxF+ny*minY*nyT+ny*maxY*nyF+nz*minZ*nzT+nz*maxZ*nzF;if(minD>=d)return true;const maxD=nx*maxX*nxT+nx*minX*nxF+ny*maxY*nyT+ny*minY*nyF+nz*maxZ*nzT+nz*minZ*nzF;return maxD>d}
function IsPointInFrontOfPlane(x,y,z,plane){const nx=plane.x;const ny=plane.y;const nz=plane.z;const d=plane.w;const minD=nx*x+ny*y+nz*z;return minD>=d}class Plane{constructor(){this.x=NaN;this.y=NaN;this.z=NaN;this.w=NaN;this.xF=NaN;this.yF=NaN;this.zF=NaN}set(x,y,z,w){this.x=x;this.y=y;this.z=z;this.w=w;this.xF=x>0?1:0;this.yF=y>0?1:0;this.zF=z>0?1:0}}
C3.Gfx.ViewFrustum=class ViewFrustum{constructor(){this._leftP=new Plane;this._topP=new Plane;this._rightP=new Plane;this._bottomP=new Plane;this._nearP=new Plane;this._farP=new Plane}CalculatePlanes(mv,proj){const vp=unitViewport;C3.Gfx.Unproject(0,1,0,mv,proj,vp,neartl);C3.Gfx.Unproject(1,1,0,mv,proj,vp,neartr);C3.Gfx.Unproject(0,0,0,mv,proj,vp,nearbl);C3.Gfx.Unproject(1,0,0,mv,proj,vp,nearbr);C3.Gfx.Unproject(0,1,1,mv,proj,vp,fartl);C3.Gfx.Unproject(1,1,1,mv,proj,vp,fartr);C3.Gfx.Unproject(0,0,
1,mv,proj,vp,farbl);C3.Gfx.Unproject(1,0,1,mv,proj,vp,farbr);PlaneFromPoints(nearbl,neartl,fartl,this._leftP);PlaneFromPoints(neartl,neartr,fartr,this._topP);PlaneFromPoints(neartr,nearbr,farbr,this._rightP);PlaneFromPoints(nearbr,nearbl,farbl,this._bottomP);PlaneFromPoints(farbl,fartl,fartr,this._farP);PlaneFromPoints(nearbr,neartr,neartl,this._nearP)}ContainsAABB(minX,minY,minZ,maxX,maxY,maxZ){return IsInFrontOfPlane(minX,minY,minZ,maxX,maxY,maxZ,this._leftP)&&IsInFrontOfPlane(minX,minY,minZ,maxX,
maxY,maxZ,this._topP)&&IsInFrontOfPlane(minX,minY,minZ,maxX,maxY,maxZ,this._rightP)&&IsInFrontOfPlane(minX,minY,minZ,maxX,maxY,maxZ,this._bottomP)&&IsInFrontOfPlane(minX,minY,minZ,maxX,maxY,maxZ,this._nearP)&&IsInFrontOfPlane(minX,minY,minZ,maxX,maxY,maxZ,this._farP)}IsBehindNearPlane(x,y,z){return!IsPointInFrontOfPlane(x,y,z,this._nearP)}};

}

// ../lib/gfx/rendererBase.js
{
'use strict';const C3=self.C3;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const vec4=glMatrix.vec4;const mat4=glMatrix.mat4;const tempMat4=mat4.create();const tmpVec3a=vec3.fromValues(0,0,0);const tmpVec3b=vec3.fromValues(0,0,0);const tmpVec3c=vec3.fromValues(0,0,0);const defaultUpVector=vec3.fromValues(0,1,0);const tmpVec4=vec4.fromValues(0,0,0,0);const tmpQuad=new C3.Quad;const tmpRect=new C3.Rect;const defaultTexCoordsQuad=new C3.Quad(0,0,1,0,1,1,0,1);
const DEFAULT_RENDERERBASE_OPTS={nearZ:1,farZ:1E4};
C3.Gfx.RendererBase=class RendererBase{constructor(opts){opts=Object.assign({},DEFAULT_RENDERERBASE_OPTS,opts);this._width=0;this._height=0;this._fovY=C3.toRadians(45);this._tan_fovY_2=Math.tan(this._fovY/2);this._matP=mat4.create();this._matMV=mat4.create();this._zAxisScale=false;this._nearZ=opts.nearZ;this._farZ=opts.farZ;this._allShaderPrograms=[];this._shaderProgramsByName=new Map;this._spTextureFill=null;this._spPoints=null;this._spTilemapFill=null;this._spTileRandomization=null;this._spColorFill=
null;this._spLinearGradientFill=null;this._spPenumbraFill=null;this._spHardEllipseFill=null;this._spHardEllipseOutline=null;this._spSmoothEllipseFill=null;this._spSmoothEllipseOutline=null;this._spSmoothLineFill=null;this._stateGroups=new Map;this._currentStateGroup=null;this._blendModeTable=[];this._namedBlendModeMap=new Map;this._baseZ=0;this._currentZ=0;this._lineWidth=1;this._lineWidthStack=[this._lineWidth];this._lineCap=1;this._lineCapStack=[this._lineCap];this._lineOffset=.5;this._lineOffsetStack=
[this._lineOffset];this._frameNumber=0;this._enableMipmaps=true;this._hasMajorPerformanceCaveat=false}FillIndexBufferData(indexData){let i=0,len=indexData.length,fv=0;while(i<len){indexData[i++]=fv;indexData[i++]=fv+1;indexData[i++]=fv+2;indexData[i++]=fv;indexData[i++]=fv+2;indexData[i++]=fv+3;fv+=4}}_ClearState(){this._baseZ=0;this._currentZ=0;this._spTextureFill=null;this._spPoints=null;this._spTilemapFill=null;this._spTileRandomization=null;this._spColorFill=null;this._spLinearGradientFill=null;
this._spPenumbraFill=null;this._spHardEllipseFill=null;this._spHardEllipseOutline=null;this._spSmoothEllipseFill=null;this._spSmoothEllipseOutline=null;this._spSmoothLineFill=null;this._ClearAllShaderPrograms()}InitState(){this._ClearState();this._currentStateGroup=null}OnDeviceOrContextLost(){for(const s of this._allShaderPrograms)s.Release();this._ClearState()}GetWidth(){return this._width}GetHeight(){return this._height}GetDefaultCameraZ(viewH){if(this.IsZAxisScaleNormalized())return 100;else return viewH/
(2*this._GetTanFovYDiv2())}GetZAxisScaleFactor(viewH){if(this.IsZAxisScaleNormalized()){const realZunits=viewH/(2*this._GetTanFovYDiv2());return realZunits/this.GetDefaultCameraZ(viewH)}else return 1}SetNearZ(z){this._nearZ=z}GetNearZ(){return this._nearZ}SetFarZ(z){this._farZ=z}GetFarZ(){return this._farZ}SetFovY(f){this._fovY=f;this._tan_fovY_2=Math.tan(this._fovY/2)}GetFovY(){return this._fovY}_GetTanFovYDiv2(){return this._tan_fovY_2}SetZAxisScaleNormalized(){this._zAxisScale=false}SetZAxisScaleRegular(){this._zAxisScale=
true}IsZAxisScaleNormalized(){return!this._zAxisScale}IsZAxisScaleRegular(){return this._zAxisScale}CalculatePerspectiveMatrix(outMat,aspect,vpX=.5,vpY=.5){const zNear=this.GetNearZ();const zFar=this.GetFarZ();const fovY=this.GetFovY();if(vpX===.5&&vpY===.5)if(this.IsWebGPU())mat4.perspectiveZO(outMat,fovY,aspect,zNear,zFar);else mat4.perspective(outMat,fovY,aspect,zNear,zFar);else{vpX=1-vpX;const fLeft=vpX*2-2;const fRight=vpX*2;const fBottom=vpY*2-2;const fTop=vpY*2;const fH=this._GetTanFovYDiv2()*
zNear;const fW=fH*aspect;mat4.frustum(outMat,fLeft*fW,fRight*fW,fBottom*fH,fTop*fH,zNear,zFar)}}CalculateOrthographicMatrix(outMat,width,height,scale=1){const dpr=self.devicePixelRatio;const worldScale=this.GetDefaultCameraZ(height)*2*dpr*this._GetTanFovYDiv2()/height;const hScaleX=width*worldScale/(2*dpr*scale);const hScaleY=height*worldScale/(2*dpr*scale);const left=-hScaleX;const right=hScaleX;const bottom=-hScaleY;const top=hScaleY;if(this.IsWebGPU())mat4.orthoZO(outMat,left,right,bottom,top,
this.GetNearZ(),this.GetFarZ());else mat4.ortho(outMat,left,right,bottom,top,this.GetNearZ(),this.GetFarZ())}CalculateLookAtModelView(outMat,cam,look,up,viewH,zScale=1){let worldScale=1;if(this.IsZAxisScaleNormalized())worldScale=200*this._GetTanFovYDiv2()/viewH;const worldScaleVec3=tmpVec3c;vec3.set(worldScaleVec3,worldScale,-worldScale,1);const tmpCam=tmpVec3a;const tmpLook=tmpVec3b;vec3.multiply(tmpCam,cam,worldScaleVec3);vec3.multiply(tmpLook,look,worldScaleVec3);mat4.lookAt(outMat,tmpCam,tmpLook,
up||defaultUpVector);worldScaleVec3[2]=zScale;mat4.scale(outMat,outMat,worldScaleVec3)}CalculateLookAtModelView2(camX,camY,camZ,lookX,lookY,lookZ,viewH,zScale){vec3.set(tmpVec3a,camX,camY,camZ);vec3.set(tmpVec3b,lookX,lookY,lookZ);this.CalculateLookAtModelView(tempMat4,tmpVec3a,tmpVec3b,defaultUpVector,viewH,zScale);return tempMat4}_AddShaderProgram(sp){this._allShaderPrograms.push(sp);this._shaderProgramsByName.set(sp.GetName(),sp)}_RemoveShaderProgram(sp){const i=this._allShaderPrograms.indexOf(sp);
if(i!==-1)this._allShaderPrograms.splice(i,1);this._shaderProgramsByName.delete(sp.GetName())}_ClearAllShaderPrograms(){C3.clearArray(this._allShaderPrograms);this._shaderProgramsByName.clear()}GetShaderProgramByName(name){return this._shaderProgramsByName.get(name)||null}GetTextureFillShaderProgram(){return this._spTextureFill}SetTextureFillMode(){this.SetProgram(this._spTextureFill)}GetPointsRenderingProgram(){return this._spPoints}SetPointsRenderingProgram(){this.SetProgram(this._spPoints)}SetTilemapFillMode(){this.SetProgram(this._spTilemapFill)}SetTileRandomizationMode(){this.SetProgram(this._spTileRandomization)}SetColorFillMode(){this.SetProgram(this._spColorFill)}SetLinearGradientFillMode(){this.SetProgram(this._spLinearGradientFill)}SetPenumbraFillMode(){this.SetProgram(this._spPenumbraFill)}SetHardEllipseFillMode(){this.SetProgram(this._spHardEllipseFill)}SetHardEllipseOutlineMode(){this.SetProgram(this._spHardEllipseOutline)}SetSmoothEllipseFillMode(){this.SetProgram(this._spSmoothEllipseFill)}SetSmoothEllipseOutlineMode(){this.SetProgram(this._spSmoothEllipseOutline)}SetSmoothLineFillMode(){this.SetProgram(this._spSmoothLineFill)}_SetCurrentStateGroup(sg){this._currentStateGroup=
sg}GetCurrentStateGroup(){return this._currentStateGroup}AcquireStateGroup(shaderProgram_or_name,blendMode,color,zElevation){const key=C3.Gfx.StateGroup.MakeKey(shaderProgram_or_name,blendMode,color,zElevation);let stateGroup=this._stateGroups.get(key);if(!stateGroup){stateGroup=C3.New(C3.Gfx.StateGroup,this,shaderProgram_or_name,blendMode,color,zElevation);this._stateGroups.set(key,stateGroup)}stateGroup.AddRef();return stateGroup}ReleaseStateGroup(stateGroup){stateGroup.DecRef();if(stateGroup._GetRefCount()===
0){if(this._currentStateGroup===stateGroup)this._currentStateGroup=null;this._stateGroups.delete(stateGroup.GetKey());stateGroup.Release()}}_InitBlendModeData(blendModeData){C3.clearArray(this._blendModeTable);this._namedBlendModeMap.clear();let number=0;for(const bmd of blendModeData){const name=bmd[0];const srcBlend=bmd[1];const destBlend=bmd[2];this._blendModeTable.push([srcBlend,destBlend]);this._namedBlendModeMap.set(name,{number,srcBlend,destBlend});number++}}_GetBlendByIndex(blendIndex){return this._blendModeTable[blendIndex]}GetSrcBlendByIndex(blendIndex){return this._GetBlendByIndex(blendIndex)[0]}GetDestBlendByIndex(blendIndex){return this._GetBlendByIndex(blendIndex)[1]}GetNamedBlend(blendName){const ret=
this._namedBlendModeMap.get(blendName);if(typeof ret==="undefined")throw new Error("invalid blend name");return ret}NamedBlendToNumber(blendName){const ret=this._namedBlendModeMap.get(blendName);if(typeof ret==="undefined")throw new Error("invalid blend name");return ret.number}SetBaseZ(z){this._baseZ=z}GetBaseZ(){return this._baseZ}SetCurrentZ(z){this._currentZ=z;this._currentStateGroup=null}GetCurrentZ(){return this._currentZ}Line(x1,y1,x2,y2){const a=C3.angleTo(x1,y1,x2,y2);const sin_a=Math.sin(a);
const cos_a=Math.cos(a);const halfLineWidth=this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this.LinePreCalc_LineCap2(x1,y1,0,x2,y2,0,sin_a_hlw,cos_a_hlw);else if(lineCap===1)this.LinePreCalc_LineCap1(x1,y1,0,x2,y2,0,sin_a_hlw,cos_a_hlw);else this.LinePreCalc_LineCap0(x1,y1,0,x2,y2,0,sin_a_hlw,cos_a_hlw)}Line3D(x1,y1,z1,x2,y2,z2){const a=C3.angleTo(x1,y1,x2,y2);const sin_a=Math.sin(a);const cos_a=Math.cos(a);const halfLineWidth=
this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this.LinePreCalc_LineCap2(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw);else if(lineCap===1)this.LinePreCalc_LineCap1(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw);else this.LinePreCalc_LineCap0(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw)}LinePreCalc_LineCap2(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+
lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=y2+lineOffset+sin_a_hlw;const cos_a_lw=cos_a_hlw*2;const sin_a_lw=sin_a_hlw*2;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw+cos_a_lw;const bly=startY+cos_a_hlw+sin_a_lw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw-cos_a_lw;const bry=endY+cos_a_hlw-sin_a_lw;this.Quad3D2(tlx,tly,z1,trx,try_,z2,brx,bry,z2,blx,bly,z1,defaultTexCoordsQuad)}LinePreCalc_LineCap1(x1,y1,z1,x2,
y2,z2,sin_a_hlw,cos_a_hlw){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=y2+lineOffset+sin_a_hlw;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw;const bry=endY+cos_a_hlw;this.Quad3D2(tlx,tly,z1,trx,try_,z2,brx,bry,z2,blx,bly,z1,defaultTexCoordsQuad)}LinePreCalc_LineCap0(x1,
y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw){const lineOffset=this._lineOffset;const startX=x1+lineOffset;const startY=y1+lineOffset;const endX=x2+lineOffset;const endY=y2+lineOffset;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw;const bry=endY+cos_a_hlw;this.Quad3D2(tlx,tly,z1,trx,try_,z2,brx,bry,z2,blx,bly,z1,defaultTexCoordsQuad)}TexturedLine(x1,y1,x2,y2,u,v){const a=
C3.angleTo(x1,y1,x2,y2);const sin_a=Math.sin(a);const cos_a=Math.cos(a);const halfLineWidth=this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this.TexturedLinePreCalc_LineCap2(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v);else if(lineCap===1)this.TexturedLinePreCalc_LineCap1(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v);else this.TexturedLinePreCalc_LineCap0(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v)}TexturedLinePreCalc_LineCap2(x1,y1,x2,
y2,sin_a_hlw,cos_a_hlw,u,v){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=y2+lineOffset+sin_a_hlw;const cos_a_lw=cos_a_hlw*2;const sin_a_lw=sin_a_hlw*2;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw+cos_a_lw;const bly=startY+cos_a_hlw+sin_a_lw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw-cos_a_lw;const bry=endY+cos_a_hlw-sin_a_lw;
tmpQuad.set(tlx,tly,trx,try_,brx,bry,blx,bly);tmpRect.set(u,0,v,0);this.Quad3(tmpQuad,tmpRect)}TexturedLinePreCalc_LineCap1(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=y2+lineOffset+sin_a_hlw;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=
endX-sin_a_hlw;const bry=endY+cos_a_hlw;tmpQuad.set(tlx,tly,trx,try_,brx,bry,blx,bly);tmpRect.set(u,0,v,0);this.Quad3(tmpQuad,tmpRect)}TexturedLinePreCalc_LineCap0(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v){const lineOffset=this._lineOffset;const startX=x1+lineOffset;const startY=y1+lineOffset;const endX=x2+lineOffset;const endY=y2+lineOffset;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=
endX-sin_a_hlw;const bry=endY+cos_a_hlw;tmpQuad.set(tlx,tly,trx,try_,brx,bry,blx,bly);tmpRect.set(u,0,v,0);this.Quad3(tmpQuad,tmpRect)}LineRect(left,top,right,bottom){const halfLineWidth=this._lineWidth*.5;const lineCap=this._lineCap;if(lineCap===2)this._LineRectPreCalc_LineCap2(left,top,right,bottom,halfLineWidth);else if(lineCap===1)this._LineRectPreCalc_LineCap1(left,top,right,bottom,halfLineWidth);else this._LineRectPreCalc_LineCap0(left,top,right,bottom,halfLineWidth)}_LineRectPreCalc_LineCap2(left,
top,right,bottom,halfLineWidth){this.LinePreCalc_LineCap2(left,top,0,right,top,0,0,halfLineWidth);this.LinePreCalc_LineCap2(right,top,0,right,bottom,0,halfLineWidth,0);this.LinePreCalc_LineCap2(right,bottom,0,left,bottom,0,0,-halfLineWidth);this.LinePreCalc_LineCap2(left,bottom,0,left,top,0,-halfLineWidth,0)}_LineRectPreCalc_LineCap1(left,top,right,bottom,halfLineWidth){this.LinePreCalc_LineCap1(left,top,0,right,top,0,0,halfLineWidth);this.LinePreCalc_LineCap1(right,top,0,right,bottom,0,halfLineWidth,
0);this.LinePreCalc_LineCap1(right,bottom,0,left,bottom,0,0,-halfLineWidth);this.LinePreCalc_LineCap1(left,bottom,0,left,top,0,-halfLineWidth,0)}_LineRectPreCalc_LineCap0(left,top,right,bottom,halfLineWidth){this.LinePreCalc_LineCap0(left,top,0,right,top,0,0,halfLineWidth);this.LinePreCalc_LineCap0(right,top,0,right,bottom,0,halfLineWidth,0);this.LinePreCalc_LineCap0(right,bottom,0,left,bottom,0,0,-halfLineWidth);this.LinePreCalc_LineCap0(left,bottom,0,left,top,0,-halfLineWidth,0)}LineRect2(r){this.LineRect(r.getLeft(),
r.getTop(),r.getRight(),r.getBottom())}LineQuad(q){const a=C3.angleTo(q.getTlx(),q.getTly(),q.getTrx(),q.getTry());const sin_a=Math.sin(a);const cos_a=Math.cos(a);const halfLineWidth=this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this._LineQuadPreCalc_LineCap2(q,sin_a_hlw,cos_a_hlw);else if(lineCap===1)this._LineQuadPreCalc_LineCap1(q,sin_a_hlw,cos_a_hlw);else this._LineQuadPreCalc_LineCap0(q,sin_a_hlw,cos_a_hlw)}_LineQuadPreCalc_LineCap2(q,
sin_a_hlw,cos_a_hlw){this.LinePreCalc_LineCap2(q.getTlx(),q.getTly(),0,q.getTrx(),q.getTry(),0,sin_a_hlw,cos_a_hlw);this.LinePreCalc_LineCap2(q.getTrx(),q.getTry(),0,q.getBrx(),q.getBry(),0,cos_a_hlw,-sin_a_hlw);this.LinePreCalc_LineCap2(q.getBrx(),q.getBry(),0,q.getBlx(),q.getBly(),0,-sin_a_hlw,-cos_a_hlw);this.LinePreCalc_LineCap2(q.getBlx(),q.getBly(),0,q.getTlx(),q.getTly(),0,-cos_a_hlw,sin_a_hlw)}_LineQuadPreCalc_LineCap1(q,sin_a_hlw,cos_a_hlw){this.LinePreCalc_LineCap1(q.getTlx(),q.getTly(),
0,q.getTrx(),q.getTry(),0,sin_a_hlw,cos_a_hlw);this.LinePreCalc_LineCap1(q.getTrx(),q.getTry(),0,q.getBrx(),q.getBry(),0,cos_a_hlw,-sin_a_hlw);this.LinePreCalc_LineCap1(q.getBrx(),q.getBry(),0,q.getBlx(),q.getBly(),0,-sin_a_hlw,-cos_a_hlw);this.LinePreCalc_LineCap1(q.getBlx(),q.getBly(),0,q.getTlx(),q.getTly(),0,-cos_a_hlw,sin_a_hlw)}_LineQuadPreCalc_LineCap0(q,sin_a_hlw,cos_a_hlw){this.LinePreCalc_LineCap0(q.getTlx(),q.getTly(),0,q.getTrx(),q.getTry(),0,sin_a_hlw,cos_a_hlw);this.LinePreCalc_LineCap0(q.getTrx(),
q.getTry(),0,q.getBrx(),q.getBry(),0,cos_a_hlw,-sin_a_hlw);this.LinePreCalc_LineCap0(q.getBrx(),q.getBry(),0,q.getBlx(),q.getBly(),0,-sin_a_hlw,-cos_a_hlw);this.LinePreCalc_LineCap0(q.getBlx(),q.getBly(),0,q.getTlx(),q.getTly(),0,-cos_a_hlw,sin_a_hlw)}SetLineWidth(n){this._lineWidth=n;this._lineWidthStack[this._lineWidthStack.length-1]=n}GetLineWidth(){return this._lineWidth}PushLineWidth(n){if(this._lineWidthStack.length>=100)throw new Error("pushed too many line widths - check push/pop pairs");
this._lineWidthStack.push(n);this._lineWidth=n}PopLineWidth(){if(this._lineWidthStack.length<=1)throw new Error("cannot pop last line width - check push/pop pairs");this._lineWidthStack.pop();this._lineWidth=this._lineWidthStack.at(-1)}SetLineCapButt(){this._lineCap=0;this._lineCapStack[this._lineCapStack.length-1]=0}SetLineCapSquare(){this._lineCap=1;this._lineCapStack[this._lineCapStack.length-1]=0}SetLineCapZag(){this._lineCap=2;this._lineCapStack[this._lineCapStack.length-1]=0}PushLineCap(type){if(type===
"butt")this.PushLineCapButt();else if(type==="square")this.PushLineCapSquare();else if(type==="zag")this.PushLineCapZag();else throw new Error("invalid line cap");}PushLineCapButt(){if(this._lineCapStack.length>=100)throw new Error("pushed too many line caps - check push/pop pairs");this._lineCapStack.push(0);this._lineCap=0}PushLineCapSquare(){if(this._lineCapStack.length>=100)throw new Error("pushed too many line caps - check push/pop pairs");this._lineCapStack.push(1);this._lineCap=1}PushLineCapZag(){if(this._lineCapStack.length>=
100)throw new Error("pushed too many line caps - check push/pop pairs");this._lineCapStack.push(2);this._lineCap=2}PopLineCap(){if(this._lineCapStack.length<=1)throw new Error("cannot pop last line cap - check push/pop pairs");this._lineCapStack.pop();this._lineCap=this._lineCapStack.at(-1)}SetLineOffset(n){this._lineOffset=n;this._lineOffsetStack[this._lineOffsetStack.length-1]=n}GetLineOffset(){return this._lineOffset}PushLineOffset(n){if(this._lineOffsetStack.length>=100)throw new Error("pushed too many line offsets - check push/pop pairs");
this._lineOffsetStack.push(n);this._lineOffset=n}PopLineOffset(){if(this._lineOffsetStack.length<=1)throw new Error("cannot pop last line offset - check push/pop pairs");this._lineOffsetStack.pop();this._lineOffset=this._lineOffsetStack.at(-1)}ConvexPoly(pts){const pts_count=pts.length/2;if(pts_count<3)throw new Error("need at least 3 points");const tris=pts_count-2;const last_tri=tris-1;const p0x=pts[0];const p0y=pts[1];for(let i=0;i<tris;i+=2){const i2=i*2;const p1x=pts[i2+2];const p1y=pts[i2+3];
const p2x=pts[i2+4];const p2y=pts[i2+5];if(i===last_tri)this.Quad2(p0x,p0y,p1x,p1y,p2x,p2y,p2x,p2y);else{const p3x=pts[i2+6];const p3y=pts[i2+7];this.Quad2(p0x,p0y,p1x,p1y,p2x,p2y,p3x,p3y)}}}GetNumVertexComponents(){return 3}Finish(){this.EndBatch(true);this._frameNumber++}GetFrameNumber(){return this._frameNumber}IncrementFrameNumber(){this._frameNumber++}SetMipmapsEnabled(e){this._enableMipmaps=!!e}AreMipmapsEnabled(){return this._enableMipmaps}SetHasMajorPerformanceCaveat(c){this._hasMajorPerformanceCaveat=
!!c}HasMajorPerformanceCaveat(){return this._hasMajorPerformanceCaveat}IsWebGL(){return false}IsWebGPU(){return false}};

}

// ../lib/gfx/shaderProgramBase.js
{
'use strict';const C3=self.C3;
C3.Gfx.ShaderProgramBase=class ShaderProgramBase{constructor(renderer,shaderInfo){this._name=shaderInfo.name;this._renderer=renderer;this._extendBoxHorizontal=shaderInfo.extendBoxHorizontal||0;this._extendBoxVertical=shaderInfo.extendBoxVertical||0;this._crossSampling=!!shaderInfo.crossSampling;this._mustPreDraw=!!shaderInfo.mustPreDraw;this._preservesOpaqueness=!!shaderInfo.preservesOpaqueness;this._animated=!!shaderInfo.animated;this._blendsBackground=!!shaderInfo.blendsBackground;this._usesDepth=
!!shaderInfo.usesDepth;this._usesAnySrcRectOrPixelSize=false;this._needsPostDrawOrExtendBox=this._crossSampling||this._blendsBackground||this._extendBoxHorizontal!==0||this._extendBoxVertical!==0}Release(){this._renderer=null}GetRenderer(){return this._renderer}GetName(){return this._name}ExtendsBox(){return this._extendBoxHorizontal!==0||this._extendBoxVertical!==0}GetBoxExtendHorizontal(){return this._extendBoxHorizontal}GetBoxExtendVertical(){return this._extendBoxVertical}UsesCrossSampling(){return this._crossSampling}MustPreDraw(){return this._mustPreDraw}PreservesOpaqueness(){return this._preservesOpaqueness}IsAnimated(){return this._animated}BlendsBackground(){return this._blendsBackground}UsesDepth(){return this._usesDepth}UsesAnySrcRectOrPixelSize(){return this._usesAnySrcRectOrPixelSize}NeedsPostDrawOrExtendsBox(){return this._needsPostDrawOrExtendBox}UsesIsSrcTexRotated(){return false}};

}

// ../lib/gfx/stateGroup.js
{
'use strict';const C3=self.C3;
C3.Gfx.StateGroup=class StateGroup{constructor(renderer,shaderProgram_or_name,blendMode,color,zElevation){this._renderer=renderer;this._refCount=0;this._shaderProgram=null;this._shaderProgramName="";this._blendMode=blendMode;this._color=C3.New(C3.Color);this._color.set(color);this._zElevation=zElevation;if(typeof shaderProgram_or_name==="string")this._shaderProgramName=shaderProgram_or_name;else{this._shaderProgram=shaderProgram_or_name;this._shaderProgramName=this._shaderProgram.GetName()}}Release(){if(this._refCount>0)throw new Error("releasing state group still in use");
this._renderer=null;this._shaderProgram=null;this._shaderProgramName=""}Apply(){const renderer=this._renderer;renderer.SetProgram(this._shaderProgram);renderer.SetBlendMode(this._blendMode);renderer.SetColor(this._color);renderer.SetCurrentZ(this._zElevation);renderer._SetCurrentStateGroup(this)}GetKey(){return C3.Gfx.StateGroup.MakeKey(this._shaderProgramName,this._blendMode,this._color,this._zElevation)}AddRef(){++this._refCount}DecRef(){--this._refCount}_GetRefCount(){return this._refCount}OnContextLost(){this._shaderProgram=
null}OnContextRestored(renderer){this._shaderProgram=renderer.GetShaderProgramByName(this._shaderProgramName);if(!this._shaderProgram)throw new Error("failed to restore shader program");}static MakeKey(shaderProgram_or_name,blendMode,c,zElevation){const shaderProgramName=typeof shaderProgram_or_name==="string"?shaderProgram_or_name:shaderProgram_or_name.GetName();return shaderProgramName+","+blendMode+","+c.getR()+","+c.getG()+","+c.getB()+","+c.getA()+","+zElevation}};

}

// ../lib/gfx/mesh.js
{
'use strict';const C3=self.C3;const tempQuadTex=C3.New(C3.Quad);function interpolateQuad(srcX,srcY,quad){const qtlx=quad.getTlx();const qtly=quad.getTly();const qtrx=quad.getTrx()-qtlx;const qtry=quad.getTry()-qtly;const qblx=quad.getBlx()-qtlx;const qbly=quad.getBly()-qtly;const xix=qtrx*srcX;const xiy=qtry*srcX;const yix=qblx*srcY;const yiy=qbly*srcY;return[qtlx+xix+yix,qtly+xiy+yiy]}
C3.Gfx.MeshPoint=class MeshPoint{constructor(mesh,col,row){this._mesh=mesh;this._col=col;this._row=row;this._x=NaN;this._y=NaN;this._zElevation=NaN;this._u=NaN;this._v=NaN;this._x=0;this._y=0;this._zElevation=0;this._u=0;this._v=0}_Init(x,y,u,v){this._x=x;this._y=y;this._u=u;this._v=v}GetX(){return this._x}SetX(x){if(this._x===x)return;this._x=x;this._mesh._SetPointsChanged()}GetY(){return this._y}SetY(y){if(this._y===y)return;this._y=y;this._mesh._SetPointsChanged()}GetZElevation(){return this._zElevation}SetZElevation(z){if(this._zElevation===
z)return;this._zElevation=Math.max(z,0);this._mesh._SetPointsChanged()}GetU(){return this._u}SetU(u){this._u=u}GetV(){return this._v}SetV(v){this._v=v}_Interpolate_TexRect(srcPoint,quadPos,rcTex){[this._x,this._y]=interpolateQuad(srcPoint._x,srcPoint._y,quadPos);this._zElevation=srcPoint._zElevation;this._u=C3.lerp(rcTex.getLeft(),rcTex.getRight(),srcPoint._u);this._v=C3.lerp(rcTex.getTop(),rcTex.getBottom(),srcPoint._v)}_Interpolate_TexQuad(srcPoint,quadPos,quadTex){[this._x,this._y]=interpolateQuad(srcPoint._x,
srcPoint._y,quadPos);this._zElevation=srcPoint._zElevation;[this._u,this._v]=interpolateQuad(srcPoint._u,srcPoint._v,quadTex)}SaveToJson(){return{"x":this.GetX(),"y":this.GetY(),"z":this.GetZElevation(),"u":this.GetU(),"v":this.GetV()}}LoadFromJson(o){this.SetX(o["x"]);this.SetY(o["y"]);if(o.hasOwnProperty("z"))this.SetZElevation(o["z"]);this.SetU(o["u"]);this.SetV(o["v"])}GetMesh(){return this._mesh}GetColumn(){return this._col}GetRow(){return this._row}};
C3.Gfx.Mesh=class Mesh{constructor(hsize,vsize,owner){if(hsize<2||vsize<2)throw new Error("invalid mesh size");this._hsize=hsize;this._vsize=vsize;this._owner=owner||null;this._pts=[];this._minX=0;this._minY=0;this._maxX=1;this._maxY=1;this._maxZ=0;this._pointsChanged=false;const lastX=hsize-1;const lastY=vsize-1;for(let y=0;y<vsize;++y){const row=[];for(let x=0;x<hsize;++x){const meshPoint=C3.New(C3.Gfx.MeshPoint,this,x,y);const xf=x/lastX;const yf=y/lastY;meshPoint._Init(xf,yf,xf,yf);row.push(meshPoint)}this._pts.push(row)}}Release(){C3.clearArray(this._pts)}GetHSize(){return this._hsize}GetVSize(){return this._vsize}GetOwner(){return this._owner}_GetPoints(){return this._pts}_SetPointsChanged(){this._pointsChanged=
true}_MaybeComputeBounds(){if(!this._pointsChanged)return;let minX=Infinity;let minY=Infinity;let maxX=-Infinity;let maxY=-Infinity;let maxZ=0;for(const row of this._pts)for(const meshPoint of row){const x=meshPoint.GetX();const y=meshPoint.GetY();minX=Math.min(minX,x);minY=Math.min(minY,y);maxX=Math.max(maxX,x);maxY=Math.max(maxY,y);maxZ=Math.max(maxZ,meshPoint.GetZElevation())}this._minX=minX;this._minY=minY;this._maxX=maxX;this._maxY=maxY;this._maxZ=maxZ;this._pointsChanged=false}GetMinX(){this._MaybeComputeBounds();
return this._minX}GetMinY(){this._MaybeComputeBounds();return this._minY}GetMaxX(){this._MaybeComputeBounds();return this._maxX}GetMaxY(){this._MaybeComputeBounds();return this._maxY}GetMaxZ(){this._MaybeComputeBounds();return this._maxZ}HasAnyZElevation(){return this.GetMaxZ()>0}GetMeshPointAt(x,y){x=Math.floor(x);y=Math.floor(y);if(x<0||x>=this._hsize||y<0||y>=this._vsize)return null;return this._pts[y][x]}CalculateTransformedMesh(srcMesh,quadPos,rcTex_or_quad){const isTexRect=rcTex_or_quad instanceof
C3.Rect;if(srcMesh.GetHSize()!==this.GetHSize()||srcMesh.GetVSize()!==this.GetVSize())throw new Error("source mesh wrong size");const srcPts=srcMesh._pts;const destPts=this._pts;for(let y=0,lenY=destPts.length;y<lenY;++y){const srcRow=srcPts[y];const destRow=destPts[y];for(let x=0,lenX=destRow.length;x<lenX;++x){const srcPoint=srcRow[x];const destPoint=destRow[x];if(isTexRect)destPoint._Interpolate_TexRect(srcPoint,quadPos,rcTex_or_quad);else destPoint._Interpolate_TexQuad(srcPoint,quadPos,rcTex_or_quad)}}}Draw(renderer){const pts=
this._pts;let prevRow=pts[0];for(let y=1,lenY=pts.length;y<lenY;++y){const row=pts[y];let tl=prevRow[0];let bl=row[0];for(let x=1,lenX=row.length;x<lenX;++x){const tr=prevRow[x];const br=row[x];tempQuadTex.set(tl.GetU(),tl.GetV(),tr.GetU(),tr.GetV(),br.GetU(),br.GetV(),bl.GetU(),bl.GetV());renderer.Quad3D2(tl.GetX(),tl.GetY(),tl.GetZElevation(),tr.GetX(),tr.GetY(),tr.GetZElevation(),br.GetX(),br.GetY(),br.GetZElevation(),bl.GetX(),bl.GetY(),bl.GetZElevation(),tempQuadTex);tl=tr;bl=br}prevRow=row}}Outline(renderer,
transformFunc){if(!transformFunc)transformFunc=(x,y,z)=>[x,y,z];const pts=this._pts;let prevRow=pts[0];for(let y=1,lenY=pts.length;y<lenY;++y){const row=pts[y];let tl=prevRow[0];let bl=row[0];for(let x=1,lenX=row.length;x<lenX;++x){const tr=prevRow[x];const br=row[x];const [tlx,tly,tlz]=transformFunc(tl.GetX(),tl.GetY(),tl.GetZElevation());const [trx,try_,trz]=transformFunc(tr.GetX(),tr.GetY(),tr.GetZElevation());const [brx,bry,brz]=transformFunc(br.GetX(),br.GetY(),br.GetZElevation());const [blx,
bly,blz]=transformFunc(bl.GetX(),bl.GetY(),bl.GetZElevation());renderer.Line3D(tlx,tly,tlz,trx,try_,trz);renderer.Line3D(tlx,tly,tlz,brx,bry,brz);renderer.Line3D(tlx,tly,tlz,blx,bly,blz);if(x===lenX-1)renderer.Line3D(trx,try_,trz,brx,bry,brz);if(y===lenY-1)renderer.Line3D(blx,bly,blz,brx,bry,brz);tl=tr;bl=br}prevRow=row}}InsertPolyMeshVertices(srcPoly){const RAY_EXT_DIST=.001;const MIN_RAY_DIST=0;const MAX_RAY_DIST=.99999999;const inPts=srcPoly.pointsArr();const outPts=[];const colCount=this.GetHSize()-
1;const rowCount=this.GetVSize()-1;const colWidthNorm=1/colCount;const rowHeightNorm=1/rowCount;const lastCol=colCount-1;const lastRow=rowCount-1;let curX=inPts[0];let curY=inPts[1];let curCol=C3.clamp(Math.floor(curX*colCount),0,lastCol);let curRow=C3.clamp(Math.floor(curY*rowCount),0,lastRow);let isUpper=true;let nextX=0;let nextY=0;let rayHit=0;const NOTHING_DISABLED=-1;const DISABLE_DIAGONAL=0;const DISABLE_LEFT_EDGE=1;const DISABLE_TOP_EDGE=2;const DISABLE_RIGHT_EDGE=3;const DISABLE_BOTTOM_EDGE=
4;let disableCheck=NOTHING_DISABLED;const addVertexAtRayHit=()=>{curX=C3.clamp(C3.lerp(curX,nextX,rayHit),0,1);curY=C3.clamp(C3.lerp(curY,nextY,rayHit),0,1);outPts.push(curX,curY)};for(let i=0,len=inPts.length;i<len;i+=2){curX=inPts[i];curY=inPts[i+1];outPts.push(curX,curY);curCol=C3.clamp(Math.floor(curX*colCount),0,lastCol);curRow=C3.clamp(Math.floor(curY*rowCount),0,lastRow);const j=(i+2)%len;nextX=inPts[j];nextY=inPts[j+1];disableCheck=NOTHING_DISABLED;while(true){if(outPts.length>1E6)throw new Error("Too many mesh poly points");
const srcTlx=curCol*colWidthNorm;const srcTly=curRow*rowHeightNorm;const srcBrx=(curCol+1)*colWidthNorm;const srcBry=(curRow+1)*rowHeightNorm;isUpper=C3.isPointInTriangleInclusive(curX,curY,srcTlx,srcTly,srcBrx,srcTly,srcBrx,srcBry);if(disableCheck!==DISABLE_DIAGONAL){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcTly,srcBrx,srcBry,-RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();isUpper=!isUpper;disableCheck=DISABLE_DIAGONAL;continue}}if(curRow>0&&
disableCheck!==DISABLE_TOP_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcTly,srcBrx,srcTly,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();curRow--;isUpper=false;disableCheck=DISABLE_BOTTOM_EDGE;continue}}if(curCol<lastCol&&disableCheck!==DISABLE_RIGHT_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcBrx,srcTly,srcBrx,srcBry,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();curCol++;isUpper=false;disableCheck=
DISABLE_LEFT_EDGE;continue}}if(curCol>0&&disableCheck!==DISABLE_LEFT_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcTly,srcTlx,srcBry,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();curCol--;isUpper=true;disableCheck=DISABLE_RIGHT_EDGE;continue}}if(curRow<lastRow&&disableCheck!==DISABLE_BOTTOM_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcBry,srcBrx,srcBry,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();
curRow++;isUpper=true;disableCheck=DISABLE_TOP_EDGE;continue}}break}}return C3.New(C3.CollisionPoly,outPts)}TransformCollisionPoly(srcPoly,destPoly){const ptsArr=this._TransformPolyPoints(srcPoly);this._SimplifyPoly(ptsArr);destPoly.setPoints(ptsArr)}_TransformPolyPoints(srcPoly){const outPts=[];const ptsArr=srcPoly.pointsArr();for(let i=0,len=ptsArr.length;i<len;i+=2){const srcX=ptsArr[i];const srcY=ptsArr[i+1];const [destX,destY]=this.TransformPoint(srcX,srcY);outPts.push(destX,destY)}return outPts}TransformPoint(srcX,
srcY){const lastCol=this.GetHSize()-1;const lastRow=this.GetVSize()-1;const colWidthNorm=1/lastCol;const rowHeightNorm=1/lastRow;const srcCol=C3.clamp(Math.floor(srcX*lastCol),0,lastCol-1);const srcRow=C3.clamp(Math.floor(srcY*lastRow),0,lastRow-1);const srcTlx=srcCol*colWidthNorm;const srcTly=srcRow*rowHeightNorm;const srcBrx=(srcCol+1)*colWidthNorm;const srcBry=(srcRow+1)*rowHeightNorm;const destTl=this.GetMeshPointAt(srcCol,srcRow);const destBr=this.GetMeshPointAt(srcCol+1,srcRow+1);const isUpper=
C3.isPointInTriangleInclusive(srcX,srcY,srcTlx,srcTly,srcBrx,srcTly,srcBrx,srcBry);const srcAltX=isUpper?srcTlx+colWidthNorm:srcTlx;const srcAltY=isUpper?srcTly:srcTly+rowHeightNorm;const destAlt=this.GetMeshPointAt(srcCol+(isUpper?1:0),srcRow+(isUpper?0:1));const [u,v,w]=C3.triangleCartesianToBarycentric(srcX,srcY,srcTlx,srcTly,srcAltX,srcAltY,srcBrx,srcBry);return C3.triangleBarycentricToCartesian3d(u,v,w,destTl.GetX(),destTl.GetY(),destTl.GetZElevation(),destAlt.GetX(),destAlt.GetY(),destAlt.GetZElevation(),
destBr.GetX(),destBr.GetY(),destBr.GetZElevation())}_SimplifyPoly(ptsArr){const outPts=[];const NZ_EPSILON=1E-7;const R_EPSILON=.001;let curX=ptsArr[0];let curY=ptsArr[1];let lastDx=curX-ptsArr.at(-2);let lastDy=curY-ptsArr.at(-1);for(let i=0,len=ptsArr.length;i<len;i+=2){const j=(i+2)%len;const nextX=ptsArr[j];const nextY=ptsArr[j+1];const dx=nextX-curX;const dy=nextY-curY;const bothXNearZero=Math.abs(dx)<NZ_EPSILON&&Math.abs(lastDx)<NZ_EPSILON&&Math.sign(dy)===Math.sign(lastDy);const bothYNearZero=
Math.abs(dy)<NZ_EPSILON&&Math.abs(lastDy)<NZ_EPSILON&&Math.sign(dx)===Math.sign(lastDx);if(!bothXNearZero&&!bothYNearZero&&Math.abs(dx/lastDx-dy/lastDy)>R_EPSILON||dx==0&&dy===0)outPts.push(curX,curY);curX=nextX;curY=nextY;lastDx=dx;lastDy=dy}if(outPts.length>=6&&outPts.length<ptsArr.length)C3.shallowAssignArray(ptsArr,outPts)}SaveToJson(){return{"cols":this.GetHSize(),"rows":this.GetVSize(),"points":this._pts.map(row=>row.map(pt=>pt.SaveToJson()))}}LoadFromJson(o){const cols=this.GetHSize();const rows=
this.GetVSize();if(o["cols"]!==cols||o["rows"]!==rows)throw new Error("mesh data wrong size");const meshRows=o["points"];for(let y=0;y<rows;++y){const rowData=meshRows[y];for(let x=0;x<cols;++x){const pt=this.GetMeshPointAt(x,y);pt.LoadFromJson(rowData[x])}}}};

}

// ../lib/gfx/webgl/texture.js
{
'use strict';const C3=self.C3;const VALID_PIXEL_FORMATS=new Set(["rgba8","rgb8","rgba4","rgb5_a1","rgb565"]);const VALID_SAMPLINGS=new Set(["nearest","bilinear","trilinear"]);const VALID_MIPMAP_QUALITIES=new Set(["default","low","high"]);const VALID_WRAP_MODES=new Set(["clamp-to-edge","repeat","mirror-repeat"]);
function GetFormatSpecifiers(pixelFormat,gl){let sizedinternalformat;let internalformat;let format;let type;switch(pixelFormat){case "rgba8":sizedinternalformat=gl.RGBA8;internalformat=gl.RGBA;format=gl.RGBA;type=gl.UNSIGNED_BYTE;break;case "rgb8":sizedinternalformat=gl.RGB8;internalformat=gl.RGB;format=gl.RGB;type=gl.UNSIGNED_BYTE;break;case "rgba4":sizedinternalformat=gl.RGBA4;internalformat=gl.RGBA;format=gl.RGBA;type=gl.UNSIGNED_SHORT_4_4_4_4;break;case "rgb5_a1":sizedinternalformat=gl.RGB5_A1;
internalformat=gl.RGBA;format=gl.RGBA;type=gl.UNSIGNED_SHORT_5_5_5_1;break;case "rgb565":sizedinternalformat=gl.RGB565;internalformat=gl.RGB;format=gl.RGB;type=gl.UNSIGNED_SHORT_5_6_5;break;default:throw new Error("invalid pixel format");}return{sizedinternalformat,internalformat,format,type}}
const CREATEFROM_DEFAULT_OPTIONS={wrapX:"clamp-to-edge",wrapY:"clamp-to-edge",sampling:"trilinear",anisotropy:0,pixelFormat:"rgba8",mipMap:true,mipMapQuality:"default",premultiplyAlpha:true,isSvg:false,width:-1,height:-1};const UPDATE_DEFAULT_OPTIONS={premultiplyAlpha:true,flipY:false};const allTextures=new Set;
C3.Gfx.WebGLRendererTexture=class WebGLRendererTexture{constructor(renderer){this._renderer=renderer;this._texture=null;this._width=0;this._height=0;this._isStatic=true;this._wrapX="clamp-to-edge";this._wrapY="clamp-to-edge";this._sampling="trilinear";this._anisotropy=0;this._pixelFormat="rgba8";this._isMipMapped=false;this._mipMapQuality="default";this._refCount=0}_CreateStatic(data,opts){if((typeof HTMLImageElement==="undefined"||!(data instanceof HTMLImageElement))&&(typeof HTMLCanvasElement===
"undefined"||!(data instanceof HTMLCanvasElement))&&(typeof ImageBitmap==="undefined"||!(data instanceof ImageBitmap))&&(typeof OffscreenCanvas==="undefined"||!(data instanceof OffscreenCanvas))&&!(data instanceof ImageData)&&!(data instanceof ArrayBuffer)&&data!==null)throw new Error("invalid texture source");opts=Object.assign({},CREATEFROM_DEFAULT_OPTIONS,opts);if(this._texture)throw new Error("already created texture");this._wrapX=opts.wrapX;this._wrapY=opts.wrapY;this._sampling=opts.sampling;
this._anisotropy=opts.anisotropy;this._pixelFormat=opts.pixelFormat;this._isMipMapped=!!opts.mipMap&&this._renderer.AreMipmapsEnabled();this._mipMapQuality=opts.mipMapQuality;if(!VALID_WRAP_MODES.has(this._wrapX)||!VALID_WRAP_MODES.has(this._wrapY))throw new Error("invalid wrap mode");if(!VALID_SAMPLINGS.has(this._sampling))throw new Error("invalid sampling");if(!VALID_PIXEL_FORMATS.has(this._pixelFormat))throw new Error("invalid pixel format");if(!VALID_MIPMAP_QUALITIES.has(this._mipMapQuality))throw new Error("invalid mipmap quality");
this._isStatic=true;if(data instanceof ArrayBuffer||data===null||opts.isSvg){this._width=opts.width;this._height=opts.height;if(data instanceof ArrayBuffer&&data.byteLength!==this._width*this._height*4)throw new Error("ArrayBuffer wrong size");}else{this._width=data.width;this._height=data.height}if(this._width<=0||this._height<=0)throw new Error("invalid texture data size");if(opts.isSvg){const canvas=C3.CreateCanvas(this._width,this._height);const ctx=canvas.getContext("2d");ctx.drawImage(data,
0,0,this._width,this._height);data=canvas}const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);const maxTextureSize=this._renderer.GetMaxTextureSize();if(this._width>maxTextureSize||this._height>maxTextureSize)throw new Error("texture data exceeds maximum texture size");const gl=this._renderer.GetContext();const webglVersion=this._renderer.GetWebGLVersionNumber();this._texture=gl.createTexture();gl.bindTexture(gl.TEXTURE_2D,this._texture);gl.pixelStorei(gl["UNPACK_PREMULTIPLY_ALPHA_WEBGL"],opts.premultiplyAlpha);
gl.pixelStorei(gl["UNPACK_FLIP_Y_WEBGL"],false);const formatspec=GetFormatSpecifiers(this._pixelFormat,gl);if(!this._renderer.SupportsNPOTTextures()&&!isPOT&&this._IsTiled()){if(data===null)throw new Error("cannot pass null data when creating a NPOT tiled texture without NPOT support");if(data instanceof ArrayBuffer)data=new ImageData(new Uint8ClampedArray(data),this._width,this._height);if(data instanceof ImageData){const tmpCanvas=C3.CreateCanvas(this._width,this._height);const tmpCtx=tmpCanvas.getContext("2d");
tmpCtx.putImageData(data,0,0);data=tmpCanvas}const canvas=C3.CreateCanvas(C3.nextHighestPowerOfTwo(this._width),C3.nextHighestPowerOfTwo(this._height));const ctx=canvas.getContext("2d");ctx.imageSmoothingEnabled=this._sampling!=="nearest";ctx.drawImage(data,0,0,this._width,this._height,0,0,canvas.width,canvas.height);gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,formatspec.format,formatspec.type,canvas)}else if(webglVersion>=2){let levels;if(this._isMipMapped)levels=Math.floor(Math.log2(Math.max(this._width,
this._height))+1);else levels=1;gl.texStorage2D(gl.TEXTURE_2D,levels,formatspec.sizedinternalformat,this._width,this._height);if(data instanceof ArrayBuffer)gl.texSubImage2D(gl.TEXTURE_2D,0,0,0,this._width,this._height,formatspec.format,formatspec.type,new Uint8Array(data));else if(data!==null)gl.texSubImage2D(gl.TEXTURE_2D,0,0,0,formatspec.format,formatspec.type,data)}else if(data instanceof ArrayBuffer)gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,this._width,this._height,0,formatspec.format,
formatspec.type,new Uint8Array(data));else if(data===null)gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,this._width,this._height,0,formatspec.format,formatspec.type,null);else gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,formatspec.format,formatspec.type,data);if(data!==null)this._SetTextureParameters(gl);gl.bindTexture(gl.TEXTURE_2D,null);this._renderer._ResetLastTexture();this._refCount=1;allTextures.add(this)}_CreateDynamic(width,height,opts){opts=Object.assign({},CREATEFROM_DEFAULT_OPTIONS,
opts);if(this._texture)throw new Error("already created texture");this._wrapX=opts.wrapX;this._wrapY=opts.wrapY;this._sampling=opts.sampling;this._pixelFormat=opts.pixelFormat;this._isMipMapped=!!opts.mipMap&&this._renderer.AreMipmapsEnabled();this._mipMapQuality=opts.mipMapQuality;if(!VALID_WRAP_MODES.has(this._wrapX)||!VALID_WRAP_MODES.has(this._wrapY))throw new Error("invalid wrap mode");if(!VALID_SAMPLINGS.has(this._sampling))throw new Error("invalid sampling");if(!VALID_PIXEL_FORMATS.has(this._pixelFormat))throw new Error("invalid pixel format");
if(!VALID_MIPMAP_QUALITIES.has(this._mipMapQuality))throw new Error("invalid mipmap quality");this._isStatic=false;this._width=Math.floor(width);this._height=Math.floor(height);const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);const maxTextureSize=this._renderer.GetMaxTextureSize();if(this._width<=0||this._height<=0)throw new Error("invalid texture size");if(this._width>maxTextureSize||this._height>maxTextureSize)throw new Error("texture exceeds maximum texture size");if(!this._renderer.SupportsNPOTTextures()&&
this._IsTiled()&&!isPOT)throw new Error("non-power-of-two tiled textures not supported");const gl=this._renderer.GetContext();const webglVersion=this._renderer.GetWebGLVersionNumber();this._texture=gl.createTexture();gl.bindTexture(gl.TEXTURE_2D,this._texture);gl.pixelStorei(gl["UNPACK_PREMULTIPLY_ALPHA_WEBGL"],opts.premultiplyAlpha);gl.pixelStorei(gl["UNPACK_FLIP_Y_WEBGL"],false);const formatspec=GetFormatSpecifiers(this._pixelFormat,gl);const internalformat=webglVersion>=2?formatspec.sizedinternalformat:
formatspec.internalformat;gl.texImage2D(gl.TEXTURE_2D,0,internalformat,this._width,this._height,0,formatspec.format,formatspec.type,null);this._SetTextureParameters(gl);gl.bindTexture(gl.TEXTURE_2D,null);this._renderer._ResetLastTexture();this._refCount=1;allTextures.add(this)}_GetMipMapHint(gl){if(this._mipMapQuality==="default")return this._isStatic?gl.NICEST:gl.FASTEST;else if(this._mipMapQuality==="low")return gl.FASTEST;else if(this._mipMapQuality==="high")return gl.NICEST;else throw new Error("invalid mipmap quality");
}_IsTiled(){return this._wrapX!=="clamp-to-edge"||this._wrapY!=="clamp-to-edge"}_GetTextureWrapMode(gl,wrapMode){if(wrapMode==="clamp-to-edge")return gl.CLAMP_TO_EDGE;else if(wrapMode==="repeat")return gl.REPEAT;else if(wrapMode==="mirror-repeat")return gl.MIRRORED_REPEAT;else throw new Error("invalid wrap mode");}_SetTextureParameters(gl){const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,this._GetTextureWrapMode(gl,this._wrapX));gl.texParameteri(gl.TEXTURE_2D,
gl.TEXTURE_WRAP_T,this._GetTextureWrapMode(gl,this._wrapY));if(this._sampling==="nearest"){gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.NEAREST);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.NEAREST);this._isMipMapped=false}else{gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR);if((isPOT||this._renderer.SupportsNPOTTextures())&&this._isMipMapped){gl.hint(gl.GENERATE_MIPMAP_HINT,this._GetMipMapHint(gl));gl.generateMipmap(gl.TEXTURE_2D);const useTrilinear=this._sampling===
"trilinear"&&!this._renderer.HasMajorPerformanceCaveat();gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,useTrilinear?gl.LINEAR_MIPMAP_LINEAR:gl.LINEAR_MIPMAP_NEAREST)}else{gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR);this._isMipMapped=false}}const anisotropicExt=this._renderer._GetAnisotropicExtension();if(anisotropicExt&&this._anisotropy>0&&this._sampling!=="nearest")gl.texParameterf(gl.TEXTURE_2D,anisotropicExt["TEXTURE_MAX_ANISOTROPY_EXT"],Math.min(this._anisotropy,this._renderer._GetMaxAnisotropy()))}_Update(data,
opts){if((typeof HTMLImageElement==="undefined"||!(data instanceof HTMLImageElement))&&(typeof HTMLVideoElement==="undefined"||!(data instanceof HTMLVideoElement))&&(typeof HTMLCanvasElement==="undefined"||!(data instanceof HTMLCanvasElement))&&(typeof ImageBitmap==="undefined"||!(data instanceof ImageBitmap))&&(typeof OffscreenCanvas==="undefined"||!(data instanceof OffscreenCanvas))&&!(data instanceof ImageData))throw new Error("invalid texture source");if(!this._texture||this._refCount<=0)throw new Error("texture not created");
if(this._isStatic)throw new Error("cannot update static texture");opts=Object.assign({},UPDATE_DEFAULT_OPTIONS,opts);const dataWidth=data.width||data.videoWidth;const dataHeight=data.height||data.videoHeight;const webglVersion=this._renderer.GetWebGLVersionNumber();const gl=this._renderer.GetContext();gl.bindTexture(gl.TEXTURE_2D,this._texture);gl.pixelStorei(gl["UNPACK_PREMULTIPLY_ALPHA_WEBGL"],opts.premultiplyAlpha);gl.pixelStorei(gl["UNPACK_FLIP_Y_WEBGL"],!!opts.flipY);const formatspec=GetFormatSpecifiers(this._pixelFormat,
gl);const internalformat=webglVersion>=2?formatspec.sizedinternalformat:formatspec.internalformat;try{if(this._width===dataWidth&&this._height===dataHeight){const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);gl.texSubImage2D(gl.TEXTURE_2D,0,0,0,formatspec.format,formatspec.type,data);if((isPOT||this._renderer.SupportsNPOTTextures())&&this._isMipMapped){gl.hint(gl.GENERATE_MIPMAP_HINT,this._GetMipMapHint(gl));gl.generateMipmap(gl.TEXTURE_2D)}}else{this._width=dataWidth;this._height=dataHeight;
const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);if(!this._renderer.SupportsNPOTTextures()&&this._IsTiled()&&!isPOT)throw new Error("non-power-of-two tiled textures not supported");gl.texImage2D(gl.TEXTURE_2D,0,internalformat,formatspec.format,formatspec.type,data);if((isPOT||this._renderer.SupportsNPOTTextures())&&this._isMipMapped){gl.hint(gl.GENERATE_MIPMAP_HINT,this._GetMipMapHint(gl));gl.generateMipmap(gl.TEXTURE_2D)}}}catch(e){console.error("Error updating WebGL texture: ",e)}gl.bindTexture(gl.TEXTURE_2D,
null);this._renderer._ResetLastTexture()}_Delete(){if(this._refCount>0)throw new Error("texture still has references");if(!this._texture)throw new Error("already deleted texture");allTextures.delete(this);const gl=this._renderer.GetContext();gl.deleteTexture(this._texture);this._texture=null}IsValid(){return!!this._texture}_GetTexture(){return this._texture}GetRenderer(){return this._renderer}AddReference(){this._refCount++}SubtractReference(){if(this._refCount<=0)throw new Error("no more references");
this._refCount--}GetReferenceCount(){return this._refCount}GetWidth(){return this._width}GetHeight(){return this._height}IsStatic(){return this._isStatic}GetEstimatedMemoryUsage(){let size=this._width*this._height;switch(this._pixelFormat){case "rgba8":size*=4;break;case "rgb8":size*=3;break;case "rgba4":case "rgb5_a1":case "rgb565":size*=2;break}if(this._isMipMapped)size+=Math.floor(size/3);return size}static OnContextLost(){allTextures.clear()}static allTextures(){return allTextures.values()}};

}

// ../lib/gfx/webgl/renderTarget.js
{
'use strict';const C3=self.C3;const assert=self.assert;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const mat4=glMatrix.mat4;const VALID_SAMPLINGS=new Set(["nearest","bilinear","trilinear"]);const DEFAULT_RENDERTARGET_OPTIONS={sampling:"trilinear",alpha:true,depth:false,isSampled:true,isDefaultSize:true,multisampling:0};const allRenderTargets=new Set;
C3.Gfx.WebGLRenderTarget=class WebGLRenderTarget{constructor(renderer){this._renderer=renderer;this._frameBuffer=null;this._frameBufferNoDepth=null;this._texture=null;this._renderBuffer=null;this._width=0;this._height=0;this._isDefaultSize=true;this._sampling="trilinear";this._alpha=true;this._depth=false;this._isSampled=true;this._multisampling=0;this._projectionMatrix=mat4.create();this._lastFov=0;this._lastNearZ=0;this._lastFarZ=0}_Create(width,height,opts){opts=Object.assign({},DEFAULT_RENDERTARGET_OPTIONS,
opts);const webGLVersion=this._renderer.GetWebGLVersionNumber();if(this._texture||this._renderBuffer)throw new Error("already created render target");this._sampling=opts.sampling;this._alpha=!!opts.alpha;this._depth=!!opts.depth;this._isSampled=!!opts.isSampled;this._isDefaultSize=!!opts.isDefaultSize;this._multisampling=opts.multisampling;if(!VALID_SAMPLINGS.has(this._sampling))throw new Error("invalid sampling");if(this._multisampling>0&&(webGLVersion<2||this._isSampled))throw new Error("invalid use of multisampling");
if(webGLVersion<2)this._isSampled=true;this._width=width;this._height=height;if(this._width<=0||this._height<=0)throw new Error("invalid render target size");this._CalculateProjection();const gl=this._renderer.GetContext();this._frameBuffer=gl.createFramebuffer();if(this._depth)this._frameBufferNoDepth=gl.createFramebuffer();if(this._isSampled){this._texture=this._renderer.CreateDynamicTexture(this._width,this._height,{sampling:this._sampling,pixelFormat:this._alpha?"rgba8":"rgb8",mipMap:false});
const tex=this._texture._GetTexture();gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,tex,0);if(this._depth){gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBufferNoDepth);gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,tex,0)}}else{this._renderBuffer=gl.createRenderbuffer();gl.bindRenderbuffer(gl.RENDERBUFFER,this._renderBuffer);const internalFormat=this._alpha?gl.RGBA8:gl.RGB8;if(this._multisampling>
0){const formatSamples=gl.getInternalformatParameter(gl.RENDERBUFFER,internalFormat,gl.SAMPLES);if(formatSamples&&formatSamples[0]){const maxSamples=formatSamples[0];if(this._multisampling>maxSamples)this._multisampling=maxSamples}else this._multisampling=0}if(this._multisampling===0)gl.renderbufferStorage(gl.RENDERBUFFER,internalFormat,this._width,this._height);else gl.renderbufferStorageMultisample(gl.RENDERBUFFER,this._multisampling,internalFormat,this._width,this._height);gl.bindFramebuffer(gl.FRAMEBUFFER,
this._frameBuffer);gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.RENDERBUFFER,this._renderBuffer);if(this._depth){gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBufferNoDepth);gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.RENDERBUFFER,this._renderBuffer)}gl.bindRenderbuffer(gl.RENDERBUFFER,null)}const rendererDepthBuffer=this._renderer._GetDepthBuffer();if(this._depth&&rendererDepthBuffer){gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);if(this._renderer._CanSampleDepth())gl.framebufferTexture2D(gl.FRAMEBUFFER,
gl.DEPTH_STENCIL_ATTACHMENT,gl.TEXTURE_2D,rendererDepthBuffer,0);else gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.DEPTH_STENCIL_ATTACHMENT,gl.RENDERBUFFER,rendererDepthBuffer)}gl.bindFramebuffer(gl.FRAMEBUFFER,null);allRenderTargets.add(this)}_Resize(width,height){if(this._width===width&&this._height===height)return;this._width=width;this._height=height;this._CalculateProjection();const gl=this._renderer.GetContext();gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);if(this._texture)this._texture._Update(new ImageData(this._width,
this._height));else{gl.bindRenderbuffer(gl.RENDERBUFFER,this._renderBuffer);gl.renderbufferStorage(gl.RENDERBUFFER,this._alpha?gl.RGBA8:gl.RGB8,this._width,this._height);gl.bindRenderbuffer(gl.RENDERBUFFER,null)}const rendererDepthBuffer=this._renderer._GetDepthBuffer();if(this._depth&&rendererDepthBuffer)if(this._renderer._CanSampleDepth())gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.DEPTH_STENCIL_ATTACHMENT,gl.TEXTURE_2D,rendererDepthBuffer,0);else gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.DEPTH_STENCIL_ATTACHMENT,
gl.RENDERBUFFER,rendererDepthBuffer);gl.bindFramebuffer(gl.FRAMEBUFFER,null)}_Delete(){if(!this._texture&&!this._renderBuffer)throw new Error("already deleted render target");allRenderTargets.delete(this);const gl=this._renderer.GetContext();if(this._texture){gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,null,0);if(this._depth){gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBufferNoDepth);gl.framebufferTexture2D(gl.FRAMEBUFFER,
gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,null,0)}this._renderer.DeleteTexture(this._texture);this._texture=null}else if(this._renderBuffer){gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.RENDERBUFFER,null);if(this._depth){gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBufferNoDepth);gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.RENDERBUFFER,null)}gl.deleteRenderbuffer(this._renderBuffer);this._renderBuffer=null}gl.bindFramebuffer(gl.FRAMEBUFFER,
null);if(this._renderer.GetWebGLVersionNumber()>=2){gl.bindFramebuffer(gl.READ_FRAMEBUFFER,null);gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER,null)}gl.deleteFramebuffer(this._frameBuffer);if(this._depth)gl.deleteFramebuffer(this._frameBufferNoDepth);const batchState=this._renderer.GetBatchState();batchState.currentFramebuffer=null;batchState.currentFramebufferNoDepth=null;this._frameBuffer=null}_CalculateProjection(){this._renderer.CalculatePerspectiveMatrix(this._projectionMatrix,this._width/this._height);
this._lastFov=this._renderer.GetFovY();this._lastNearZ=this._renderer.GetNearZ();this._lastFarZ=this._renderer.GetFarZ()}_GetFramebuffer(){return this._frameBuffer}_GetFramebufferNoDepth(){return this._frameBufferNoDepth}GetRenderer(){return this._renderer}GetTexture(){return this._texture}GetProjectionMatrix(){if(this._renderer.GetFovY()!==this._lastFov||this._renderer.GetNearZ()!==this._lastNearZ||this._renderer.GetFarZ()!==this._lastFarZ)this._CalculateProjection();return this._projectionMatrix}IsLinearSampling(){return this._sampling!==
"nearest"}HasAlpha(){return this._alpha}IsSampled(){return this._isSampled}HasDepthBuffer(){return this._depth}GetWidth(){return this._width}GetHeight(){return this._height}IsDefaultSize(){return this._isDefaultSize}GetMultisampling(){return this._multisampling}GetOptions(){const ret={sampling:this._sampling,alpha:this._alpha,isSampled:this._isSampled};if(!this._isDefaultSize){ret.width=this._width;ret.height=this._height}return ret}IsCompatibleWithOptions(opts){opts=Object.assign({},DEFAULT_RENDERTARGET_OPTIONS,
opts);if(opts.sampling!=="nearest"!==this.IsLinearSampling())return false;if(!!opts.alpha!==this.HasAlpha())return false;if(!!opts.depth!==this.HasDepthBuffer())return false;if(this._renderer.GetWebGLVersionNumber()>=2)if(!!opts.isSampled!==this.IsSampled())return false;if(typeof opts.width==="number"||typeof opts.height==="number")return!this.IsDefaultSize()&&this.GetWidth()===opts.width&&this.GetHeight()===opts.height;else return this.IsDefaultSize()}_GetWebGLTexture(){if(!this._texture)return null;
return this._texture._GetTexture()}GetEstimatedMemoryUsage(){if(this._texture)return this._texture.GetEstimatedMemoryUsage();return this._width*this._height*(this._alpha?4:3)}static async DebugReadPixelsToBlob(renderer,renderTarget){const imageData=await renderer.ReadBackRenderTargetToImageData(renderTarget,true);return await C3.ImageDataToBlob(imageData)}static OnContextLost(){allRenderTargets.clear()}static allRenderTargets(){return allRenderTargets.values()}static ResizeAll(width,height){for(const rt of allRenderTargets)if(rt.IsDefaultSize())rt._Resize(width,
height)}};

}

// ../lib/gfx/webgl/shaderProgram.js
{
'use strict';const C3=self.C3;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const mat4=glMatrix.mat4;
const RESERVED_UNIFORM_NAMES=new Set(["aPos","aTex","aPoints","matP","matMV","samplerFront","samplerBack","samplerDepth","destStart","destEnd","srcStart","srcEnd","srcOriginStart","srcOriginEnd","pixelSize","seconds","devicePixelRatio","layerScale","layerAngle","layoutStart","layoutEnd","color","color2_","pointTexStart","pointTexEnd","zElevation","tileSize","tileSpacing","outlineThickness","zNear","zFar"]);
C3.Gfx.WebGLShaderProgram=class WebGLShaderProgram extends C3.Gfx.ShaderProgramBase{static async Compile(renderer,shaderInfo){const gl=renderer.GetContext();const fragSrc=shaderInfo.src;const vertexSrc=shaderInfo.vertexSrc;const name=shaderInfo.name;const fragmentShader=gl.createShader(gl.FRAGMENT_SHADER);gl.shaderSource(fragmentShader,fragSrc);gl.compileShader(fragmentShader);const vertexShader=gl.createShader(gl.VERTEX_SHADER);gl.shaderSource(vertexShader,vertexSrc);gl.compileShader(vertexShader);
const shaderProgram=gl.createProgram();gl.attachShader(shaderProgram,fragmentShader);gl.attachShader(shaderProgram,vertexShader);gl.bindAttribLocation(shaderProgram,0,"aPos");gl.bindAttribLocation(shaderProgram,1,"aTex");gl.bindAttribLocation(shaderProgram,2,"aPoints");gl.linkProgram(shaderProgram);const parallelShaderCompileExt=renderer._GetParallelShaderCompileExtension();if(parallelShaderCompileExt)await renderer._WaitForObjectReady(()=>gl.getProgramParameter(shaderProgram,parallelShaderCompileExt["COMPLETION_STATUS_KHR"]));
else await C3.Wait(5);if(!gl.getShaderParameter(fragmentShader,gl.COMPILE_STATUS)){const log=gl.getShaderInfoLog(fragmentShader);gl.deleteShader(fragmentShader);gl.deleteShader(vertexShader);gl.deleteProgram(shaderProgram);throw new Error("Error compiling fragment shader: "+log);}if(!gl.getShaderParameter(vertexShader,gl.COMPILE_STATUS)){const log=gl.getShaderInfoLog(vertexShader);gl.deleteShader(fragmentShader);gl.deleteShader(vertexShader);gl.deleteProgram(shaderProgram);throw new Error("Error compiling vertex shader: "+
log);}if(!gl.getProgramParameter(shaderProgram,gl.LINK_STATUS)){const log=gl.getProgramInfoLog(shaderProgram);gl.deleteShader(fragmentShader);gl.deleteShader(vertexShader);gl.deleteProgram(shaderProgram);throw new Error("Error linking shader program: "+log);}const infoLog=C3.FilterUnprintableChars(gl.getProgramInfoLog(shaderProgram)||"").trim();if(infoLog&&!C3.IsStringAllWhitespace(infoLog))console.info(`[WebGL] Shader program '${name}' compilation log: `,infoLog);gl.deleteShader(fragmentShader);
gl.deleteShader(vertexShader);return shaderProgram}static async Create(renderer,shaderInfo){const shaderProgram=await C3.Gfx.WebGLShaderProgram.Compile(renderer,shaderInfo);return new C3.Gfx.WebGLShaderProgram(renderer,shaderProgram,shaderInfo)}constructor(renderer,shaderProgram,shaderInfo){super(renderer,shaderInfo);const gl=renderer.GetContext();const batchState=renderer.GetBatchState();renderer.EndBatch();gl.useProgram(shaderProgram);this._gl=gl;this._shaderProgram=shaderProgram;this._isDeviceTransform=
shaderInfo.name==="<default-device-transform>";const locAPos=gl.getAttribLocation(shaderProgram,"aPos");const locATex=gl.getAttribLocation(shaderProgram,"aTex");this._locAPoints=gl.getAttribLocation(shaderProgram,"aPoints");if(locAPos!==-1){gl.bindBuffer(gl.ARRAY_BUFFER,renderer._vertexBuffer);gl.vertexAttribPointer(locAPos,renderer.GetNumVertexComponents(),gl.FLOAT,false,0,0);gl.enableVertexAttribArray(locAPos)}if(locATex!==-1){gl.bindBuffer(gl.ARRAY_BUFFER,renderer._texcoordBuffer);gl.vertexAttribPointer(locATex,
2,gl.FLOAT,false,0,0);gl.enableVertexAttribArray(locATex)}if(this._locAPoints!==-1){gl.bindBuffer(gl.ARRAY_BUFFER,renderer._pointBuffer);gl.vertexAttribPointer(this._locAPoints,4,gl.FLOAT,false,0,0);gl.enableVertexAttribArray(this._locAPoints)}gl.bindBuffer(gl.ARRAY_BUFFER,null);this._uMatP=new C3.Gfx.WebGLShaderUniform(this,"matP","mat4");this._uMatMV=new C3.Gfx.WebGLShaderUniform(this,"matMV","mat4");this._uColor=new C3.Gfx.WebGLShaderUniform(this,"color","vec4");this._uSamplerFront=new C3.Gfx.WebGLShaderUniform(this,
"samplerFront","sampler");this._uPointTexStart=new C3.Gfx.WebGLShaderUniform(this,"pointTexStart","vec2");this._uPointTexEnd=new C3.Gfx.WebGLShaderUniform(this,"pointTexEnd","vec2");this._uZElevation=new C3.Gfx.WebGLShaderUniform(this,"zElevation","float");this._uTileSize=new C3.Gfx.WebGLShaderUniform(this,"tileSize","vec2");this._uTileSpacing=new C3.Gfx.WebGLShaderUniform(this,"tileSpacing","vec2");this._uColor2=new C3.Gfx.WebGLShaderUniform(this,"color2_","vec4");this._uOutlineThickness=new C3.Gfx.WebGLShaderUniform(this,
"outlineThickness","float");this._uSamplerBack=new C3.Gfx.WebGLShaderUniform(this,"samplerBack","sampler");this._uSamplerDepth=new C3.Gfx.WebGLShaderUniform(this,"samplerDepth","sampler");this._uDestStart=new C3.Gfx.WebGLShaderUniform(this,"destStart","vec2");this._uDestEnd=new C3.Gfx.WebGLShaderUniform(this,"destEnd","vec2");this._uSrcStart=new C3.Gfx.WebGLShaderUniform(this,"srcStart","vec2");this._uSrcEnd=new C3.Gfx.WebGLShaderUniform(this,"srcEnd","vec2");this._uSrcOriginStart=new C3.Gfx.WebGLShaderUniform(this,
"srcOriginStart","vec2");this._uSrcOriginEnd=new C3.Gfx.WebGLShaderUniform(this,"srcOriginEnd","vec2");this._uPixelSize=new C3.Gfx.WebGLShaderUniform(this,"pixelSize","vec2");this._uSeconds=new C3.Gfx.WebGLShaderUniform(this,"seconds","float");this._uDevicePixelRatio=new C3.Gfx.WebGLShaderUniform(this,"devicePixelRatio","float");this._uLayerScale=new C3.Gfx.WebGLShaderUniform(this,"layerScale","float");this._uLayerAngle=new C3.Gfx.WebGLShaderUniform(this,"layerAngle","float");this._uLayoutStart=new C3.Gfx.WebGLShaderUniform(this,
"layoutStart","vec2");this._uLayoutEnd=new C3.Gfx.WebGLShaderUniform(this,"layoutEnd","vec2");this._uZNear=new C3.Gfx.WebGLShaderUniform(this,"zNear","float");this._uZFar=new C3.Gfx.WebGLShaderUniform(this,"zFar","float");this._hasAnyOptionalUniforms=!!(this._uPixelSize.IsUsed()||this._uSeconds.IsUsed()||this._uSamplerBack.IsUsed()||this._uDestStart.IsUsed()||this._uDestEnd.IsUsed()||this._uSrcStart.IsUsed()||this._uSrcEnd.IsUsed()||this._uSrcOriginStart.IsUsed()||this._uSrcOriginEnd.IsUsed()||this._uDevicePixelRatio.IsUsed()||
this._uLayerScale.IsUsed()||this._uLayerAngle.IsUsed()||this._uLayoutStart.IsUsed()||this._uLayoutEnd.IsUsed());const customParameterDefs=shaderInfo.parameters||[];this._uCustomParameters=[];this._usesAnySrcRectOrPixelSize=this._uPixelSize.IsUsed()||this._uSrcStart.IsUsed()||this._uSrcEnd.IsUsed()||this._uSrcOriginStart.IsUsed()||this._uSrcOriginEnd.IsUsed();this._hasCurrentMatP=false;this._hasCurrentMatMV=false;this._uColor.Init4f(1,1,1,1);this._uColor2.Init4f(1,1,1,1);this._uSamplerFront.Init1i(0);
this._uSamplerBack.Init1i(1);this._uSamplerDepth.Init1i(2);this._uPointTexStart.Init2f(0,0);this._uPointTexEnd.Init2f(1,1);this._uZElevation.Init1f(0);this._uTileSize.Init2f(0,0);this._uTileSpacing.Init2f(0,0);this._uDestStart.Init2f(0,0);this._uDestEnd.Init2f(1,1);this._uSrcStart.Init2f(0,0);this._uSrcEnd.Init2f(0,0);this._uSrcOriginStart.Init2f(0,0);this._uSrcOriginEnd.Init2f(0,0);this._uPixelSize.Init2f(0,0);this._uDevicePixelRatio.Init1f(1);this._uZNear.Init1f(renderer.GetNearZ());this._uZFar.Init1f(renderer.GetFarZ());
this._uLayerScale.Init1f(1);this._uLayerAngle.Init1f(0);this._uSeconds.Init1f(0);this._uLayoutStart.Init2f(0,0);this._uLayoutEnd.Init2f(0,0);this._uOutlineThickness.Init1f(1);for(const p of customParameterDefs){const uniformName=p[0];const paramType=p[2];const shaderUniform=new C3.Gfx.WebGLShaderUniform(this,uniformName,paramType);if(paramType==="color")shaderUniform.Init3f(0,0,0);else shaderUniform.Init1f(0);this._uCustomParameters.push(shaderUniform)}if(this._isDeviceTransform)this._UpdateDeviceTransformUniforms(batchState.currentMatP);
else{this.UpdateMatP(batchState.currentMatP,true);this.UpdateMatMV(batchState.currentMV,true)}const currentShader=batchState.currentShader;gl.useProgram(currentShader?currentShader._shaderProgram:null)}Release(){this._gl.deleteProgram(this._shaderProgram);this._shaderProgram=null;this._renderer._RemoveShaderProgram(this);this._gl=null;super.Release()}GetWebGLContext(){return this._gl}GetShaderProgram(){return this._shaderProgram}GetParameterCount(){return this._uCustomParameters.length}GetParameterType(paramIndex){if(paramIndex<
0||paramIndex>=this._uCustomParameters.length)return null;return this._uCustomParameters[paramIndex].GetType()}AreCustomParametersAlreadySetInBatch(params){for(let i=0,len=params.length;i<len;++i)if(!this._uCustomParameters[i].IsSetToCustomInBatch(params[i]))return false;return true}SetCustomParametersInBatch(params){for(let i=0,len=params.length;i<len;++i)this._uCustomParameters[i].SetBatchValueCustom(params[i])}AreOptionalUniformsAlreadySetInBatch(destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,
pixelHeight,dpr,layerScale,layerAngle,time){if(this._uSamplerBack.IsUsed())return false;if(this._uPixelSize.IsUsed()&&!this._uPixelSize.IsSetTo2InBatch(pixelWidth,pixelHeight))return false;if(this._uDestStart.IsUsed()&&!this._uDestStart.IsSetTo2InBatch(destRect.getLeft(),destRect.getTop()))return false;if(this._uDestEnd.IsUsed()&&!this._uDestEnd.IsSetTo2InBatch(destRect.getRight(),destRect.getBottom()))return false;if(this._uDevicePixelRatio.IsUsed()&&!this._uDevicePixelRatio.IsSetTo1InBatch(dpr))return false;
if(this._uLayerScale.IsUsed()&&!this._uLayerScale.IsSetTo1InBatch(layerScale))return false;if(this._uLayerAngle.IsUsed()&&!this._uLayerAngle.IsSetTo1InBatch(layerAngle))return false;if(this._uSrcStart.IsUsed()&&!this._uSrcStart.IsSetTo2InBatch(srcRect.getLeft(),srcRect.getTop()))return false;if(this._uSrcEnd.IsUsed()&&!this._uSrcEnd.IsSetTo2InBatch(srcRect.getRight(),srcRect.getBottom()))return false;if(this._uSrcOriginStart.IsUsed()&&!this._uSrcOriginStart.IsSetTo2InBatch(srcOriginRect.getLeft(),
srcOriginRect.getTop()))return false;if(this._uSrcOriginEnd.IsUsed()&&!this._uSrcOriginEnd.IsSetTo2InBatch(srcOriginRect.getRight(),srcOriginRect.getBottom()))return false;if(this._uLayoutStart.IsUsed()&&!this._uLayoutStart.IsSetTo2InBatch(layoutRect.getLeft(),layoutRect.getTop()))return false;if(this._uLayoutEnd.IsUsed()&&!this._uLayoutEnd.IsSetTo2InBatch(layoutRect.getTop(),layoutRect.getBottom()))return false;if(this._uSeconds.IsUsed()&&!this._uSeconds.IsSetTo1InBatch(time))return false;return true}SetOptionalUniformsInBatch(destRect,
srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,dpr,layerScale,layerAngle,time){if(this._uSamplerBack.IsUsed())return;if(this._uPixelSize.IsUsed())this._uPixelSize.SetBatch2(pixelWidth,pixelHeight);if(this._uDestStart.IsUsed())this._uDestStart.SetBatch2(destRect.getLeft(),destRect.getTop());if(this._uDestEnd.IsUsed())this._uDestEnd.SetBatch2(destRect.getRight(),destRect.getBottom());if(this._uDevicePixelRatio.IsUsed())this._uDevicePixelRatio.SetBatch1(dpr);if(this._uLayerScale.IsUsed())this._uLayerScale.SetBatch1(layerScale);
if(this._uLayerAngle.IsUsed())this._uLayerAngle.SetBatch1(layerAngle);if(this._uSrcStart.IsUsed())this._uSrcStart.SetBatch2(srcRect.getLeft(),srcRect.getTop());if(this._uSrcEnd.IsUsed())this._uSrcEnd.SetBatch2(srcRect.getRight(),srcRect.getBottom());if(this._uSrcOriginStart.IsUsed())this._uSrcOriginStart.SetBatch2(srcOriginRect.getLeft(),srcOriginRect.getTop());if(this._uSrcOriginEnd.IsUsed())this._uSrcOriginEnd.SetBatch2(srcOriginRect.getRight(),srcOriginRect.getBottom());if(this._uLayoutStart.IsUsed())this._uLayoutStart.SetBatch2(layoutRect.getLeft(),
layoutRect.getTop());if(this._uLayoutEnd.IsUsed())this._uLayoutEnd.SetBatch2(layoutRect.getTop(),layoutRect.getBottom());if(this._uSeconds.IsUsed())this._uSeconds.SetBatch1(time)}UpdateMatP(matP,force){if(this._hasCurrentMatP&&!force)return;if(this._isDeviceTransform)return;if(this._uMatP.IsUsed())this._uMatP.UpdateMatrix4fv(matP);this._hasCurrentMatP=true}SetMatPStale(){this._hasCurrentMatP=false}UpdateMatMV(matMV,force){if(this._hasCurrentMatMV&&!force)return;if(this._isDeviceTransform)return;if(this._uMatMV.IsUsed())this._uMatMV.UpdateMatrix4fv(matMV);
this._hasCurrentMatMV=true}SetMatMVStale(){this._hasCurrentMatMV=false}_UpdateDeviceTransformUniforms(matP){if(!this._isDeviceTransform)throw new Error("not device transform shader");this._uMatP.UpdateMatrix4fv(matP);const renderer=this._renderer;const scrollX=renderer.GetWidth()/2;const scrollY=renderer.GetHeight()/2;const tempMat4=renderer.CalculateLookAtModelView2(scrollX,scrollY,renderer.GetDefaultCameraZ(renderer.GetHeight()),scrollX,scrollY,0,renderer.GetHeight());this._uMatMV.UpdateMatrix4fv(tempMat4)}UpdateColor(c){if(this._uColor.IsUsed())this._uColor.Update4f(c[0],
c[1],c[2],c[3])}static GetReservedUniformNames(){return RESERVED_UNIFORM_NAMES}static GetDefaultVertexShaderSource(useHighP){const texPrecision=useHighP?"highmedp":"mediump";return[`#ifdef GL_FRAGMENT_PRECISION_HIGH`,`#define highmedp highp`,`#else`,`#define highmedp mediump`,`#endif`,`attribute highp vec3 aPos;`,`attribute ${texPrecision} vec2 aTex;`,`varying ${texPrecision} vec2 vTex;`,`uniform highp mat4 matP;`,`uniform highp mat4 matMV;`,`void main(void) {`,`	gl_Position = matP * matMV * vec4(aPos, 1.0);`,
`	vTex = aTex;`,`}`].join("\n")}static GetDefaultVertexShaderSource_WebGL2(useHighP){const texPrecision=useHighP?"highp":"mediump";return[`#version 300 es`,`in highp vec3 aPos;`,`in ${texPrecision} vec2 aTex;`,`out ${texPrecision} vec2 vTex;`,`uniform highp mat4 matP;`,`uniform highp mat4 matMV;`,`void main(void) {`,`	gl_Position = matP * matMV * vec4(aPos, 1.0);`,`	vTex = aTex;`,`}`].join("\n")}static GetTextureFillFragmentShaderSource_WebGL1_NoFragDepth(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;",
"uniform lowp sampler2D samplerFront;","void main(void) {","\tgl_FragColor = texture2D(samplerFront, vTex) * color;","}"].join("\n")}static GetTextureFillFragmentShaderSource_WebGL1_FragDepthEXT(){return["#extension GL_EXT_frag_depth : enable","varying mediump vec2 vTex;","uniform lowp vec4 color;","uniform lowp sampler2D samplerFront;","void main(void) {","\tgl_FragColor = texture2D(samplerFront, vTex) * color;","\tgl_FragDepthEXT = (gl_FragColor.a == 0.0 ? 1.0 : gl_FragCoord.z);","}"].join("\n")}static GetTextureFillFragmentShaderSource_WebGL2(){return["#version 300 es",
"in mediump vec2 vTex;","out lowp vec4 outColor;","uniform lowp vec4 color;","uniform lowp sampler2D samplerFront;","void main(void) {","\toutColor = texture(samplerFront, vTex) * color;","\tgl_FragDepth = (outColor.a == 0.0 ? 1.0 : gl_FragCoord.z);","}"].join("\n")}static GetTilemapFragmentShaderSource_WebGL1_NoFragDepth(){return["#ifdef GL_FRAGMENT_PRECISION_HIGH","#define highmedp highp","#else","#define highmedp mediump","#endif","varying highmedp vec2 vTex;","uniform lowp vec4 color;","uniform lowp sampler2D samplerFront;",
"uniform highmedp vec2 srcStart;","uniform highmedp vec2 pixelSize;","uniform highmedp vec2 tileSize;","uniform highmedp vec2 tileSpacing;","void main(void) {","\thighmedp vec2 tile = floor(vTex);","\thighmedp vec2 tex = fract(vTex);","\thighmedp vec2 tileOrigin = srcStart + tile * (tileSize + tileSpacing);","\thighmedp vec2 lowerBound = tileOrigin + pixelSize / 2.0;","\thighmedp vec2 upperBound = tileOrigin + tileSize - pixelSize / 2.0;","\tgl_FragColor = texture2D(samplerFront, clamp(tex, lowerBound, upperBound), -16.0) * color;",
"}"].join("\n")}static GetTilemapFragmentShaderSource_WebGL1_FragDepthEXT(){return["#extension GL_EXT_frag_depth : enable","#ifdef GL_FRAGMENT_PRECISION_HIGH","#define highmedp highp","#else","#define highmedp mediump","#endif","varying highmedp vec2 vTex;","uniform lowp vec4 color;","uniform lowp sampler2D samplerFront;","uniform highmedp vec2 srcStart;","uniform highmedp vec2 pixelSize;","uniform highmedp vec2 tileSize;","uniform highmedp vec2 tileSpacing;","void main(void) {","\thighmedp vec2 tile = floor(vTex);",
"\thighmedp vec2 tex = fract(vTex);","\thighmedp vec2 tileOrigin = srcStart + tile * (tileSize + tileSpacing);","\thighmedp vec2 lowerBound = tileOrigin + pixelSize / 2.0;","\thighmedp vec2 upperBound = tileOrigin + tileSize - pixelSize / 2.0;","\tgl_FragColor = texture2D(samplerFront, clamp(tex, lowerBound, upperBound), -16.0) * color;","\tgl_FragDepthEXT = (gl_FragColor.a == 0.0 ? 1.0 : gl_FragCoord.z);","}"].join("\n")}static GetTilemapFragmentShaderSource_WebGL2(){return["#version 300 es","in highp vec2 vTex;",
"out lowp vec4 outColor;","uniform lowp vec4 color;","uniform lowp sampler2D samplerFront;","uniform highp vec2 srcStart;","uniform highp vec2 pixelSize;","uniform highp vec2 tileSize;","uniform highp vec2 tileSpacing;","void main(void) {","\thighp vec2 tile = floor(vTex);","\thighp vec2 tex = fract(vTex);","\thighp vec2 tileOrigin = srcStart + tile * (tileSize + tileSpacing);","\thighp vec2 lowerBound = tileOrigin + pixelSize / 2.0;","\thighp vec2 upperBound = tileOrigin + tileSize - pixelSize / 2.0;",
"\toutColor = texture(samplerFront, clamp(tex, lowerBound, upperBound), -16.0) * color;","\tgl_FragDepth = (outColor.a == 0.0 ? 1.0 : gl_FragCoord.z);","}"].join("\n")}static GetTileRandomizationFragmentShaderSource(webGLVer,hasFragDepthExt,useDerivatives){let prefix="";if(webGLVer>=2)prefix="#version 300 es\n";else{if(hasFragDepthExt)prefix="#extension GL_EXT_frag_depth : enable\n";if(useDerivatives){prefix+="#extension GL_EXT_shader_texture_lod : enable\n";prefix+="#extension GL_OES_standard_derivatives : enable\n"}}return prefix+
`
#ifdef GL_FRAGMENT_PRECISION_HIGH
#define highmedp highp
#else
#define highmedp mediump
#endif
precision highmedp float;
${webGLVer>=2?"in":"varying"} vec2 vTex;
${webGLVer>=2?"out lowp vec4 outColor;":""}
uniform lowp vec4 color;
uniform lowp sampler2D samplerFront;
uniform vec2 pixelSize;

uniform vec2 tileSize;
uniform vec2 tileSpacing;
uniform float outlineThickness;

const float PI = 3.1415926;

lowp vec4 cospVec4(lowp vec4 a, lowp vec4 b, float x)
{
	return (a + b + (a - b) * cos(x * PI)) / 2.0;
}

vec3 randVec3(vec2 seed)
{
	return vec3(fract(sin(dot(seed.xy + vec2(0.1, 0.1), vec2(12.9898,78.233))) * 43758.5453),
				fract(sin(dot(seed.yx + vec2(0.1, 0.1), vec2(12.9898,-78.233))) * 43758.5453),
				fract(sin(dot(seed.xy + vec2(0.1, 0.1), vec2(-12.9898,-78.233))) * 43758.5453));
}

lowp vec4 sampleTile(vec2 tile, vec2 uv, vec2 ddx, vec2 ddy)
{
	vec2 posRandom = tileSize;
	float angleRandom = outlineThickness;
	
	vec3 rand = (randVec3(floor(tile + 0.5)) - 0.5) * 2.0;
	
	float angle = angleRandom * rand.z * PI;
	float sin_a = sin(angle);
	float cos_a = cos(angle);
	float aspect = pixelSize.x / pixelSize.y;

	vec2 mid = tile + vec2(0.5, 0.5);
	vec2 dp = uv - mid;
	dp.x /= aspect;
	vec2 r = vec2(dp.x * cos_a - dp.y * sin_a,
				  dp.y * cos_a + dp.x * sin_a);
	r.x *= aspect;

	vec2 p = mid + r + (posRandom * rand.xy / 2.0);
	
	${webGLVer>=2?"return textureGrad(samplerFront, p, ddx, ddy);":""}
	${webGLVer<2&&useDerivatives?"return texture2DGradEXT(samplerFront, p, ddx, ddy);":""}
	${webGLVer<2&&!useDerivatives?"return texture2D(samplerFront, p);":""}
}

void main(void) {
	
	${webGLVer<2?"lowp vec4 outColor;":""}
	
	float blendMarginX = tileSpacing.x;
	float blendMarginY = tileSpacing.y;
	
	vec2 tile = floor(vTex);
	vec2 tex = fract(vTex);
	vec2 ddx = ${webGLVer>=2||useDerivatives?"dFdx(vTex)":"vec2(0.0, 0.0)"};
	vec2 ddy = ${webGLVer>=2||useDerivatives?"dFdy(vTex)":"vec2(0.0, 0.0)"};
	
	vec4 curTile = sampleTile(tile, vTex, ddx, ddy);
	
	bool inLeftMargin = (tex.x < blendMarginX);
	bool inRightMargin = (tex.x > 1.0 - blendMarginX);
	bool inTopMargin = (tex.y < blendMarginY);
	bool inBottomMargin = (tex.y > 1.0 - blendMarginY);
	
	if (inLeftMargin)
	{
		lowp vec4 leftTile = sampleTile(tile + vec2(-1.0, 0.0), vTex, ddx, ddy);
		float leftMix = (tex.x / (blendMarginX * 2.0)) + 0.5;
		lowp vec4 leftMixedTile = cospVec4(leftTile, curTile, leftMix);
		
		if (inTopMargin)
		{
			lowp vec4 topTile =     sampleTile(tile + vec2(0.0,  -1.0), vTex, ddx, ddy);
			lowp vec4 topLeftTile = sampleTile(tile + vec2(-1.0, -1.0), vTex, ddx, ddy);
			lowp vec4 topLeftMixedTile = cospVec4(topLeftTile, topTile, leftMix);
			
			outColor = cospVec4(topLeftMixedTile, leftMixedTile, (tex.y / (blendMarginY * 2.0)) + 0.5);
		}
		else if (inBottomMargin)
		{
			lowp vec4 bottomTile =     sampleTile(tile + vec2(0.0,  1.0), vTex, ddx, ddy);
			lowp vec4 bottomLeftTile = sampleTile(tile + vec2(-1.0, 1.0), vTex, ddx, ddy);
			lowp vec4 bottomLeftMixedTile = cospVec4(bottomLeftTile, bottomTile, leftMix);
			
			outColor = cospVec4(leftMixedTile, bottomLeftMixedTile, (tex.y - (1.0 - blendMarginY)) / (blendMarginY * 2.0));
		}
		else
		{
			outColor = leftMixedTile;
		}
	}
	else if (inRightMargin)
	{
		lowp vec4 rightTile = sampleTile(tile + vec2(1.0, 0.0), vTex, ddx, ddy);
		float rightMix = (tex.x - (1.0 - blendMarginX)) / (blendMarginX * 2.0);
		lowp vec4 rightMixedTile = cospVec4(curTile, rightTile, rightMix);
		
		if (inTopMargin)
		{
			lowp vec4 topTile =      sampleTile(tile + vec2(0.0, -1.0), vTex, ddx, ddy);
			lowp vec4 topRightTile = sampleTile(tile + vec2(1.0, -1.0), vTex, ddx, ddy);
			lowp vec4 topRightMixedTile = cospVec4(topTile, topRightTile, rightMix);
			
			outColor = cospVec4(topRightMixedTile, rightMixedTile, (tex.y / (blendMarginY * 2.0)) + 0.5);
		}
		else if (inBottomMargin)
		{
			lowp vec4 bottomTile =      sampleTile(tile + vec2(0.0, 1.0), vTex, ddx, ddy);
			lowp vec4 bottomRightTile = sampleTile(tile + vec2(1.0, 1.0), vTex, ddx, ddy);
			lowp vec4 bottomRightMixedTile = cospVec4(bottomTile, bottomRightTile, rightMix);
			
			outColor = cospVec4(rightMixedTile, bottomRightMixedTile, (tex.y - (1.0 - blendMarginY)) / (blendMarginY * 2.0));
		}
		else
		{
			outColor = rightMixedTile;
		}
	}
	else if (inTopMargin)
	{
		lowp vec4 topTile = sampleTile(tile + vec2(0.0, -1.0), vTex, ddx, ddy);
		outColor = cospVec4(topTile, curTile, (tex.y / (blendMarginY * 2.0)) + 0.5);
	}
	else if (inBottomMargin)
	{
		lowp vec4 bottomTile = sampleTile(tile + vec2(0.0, 1.0), vTex, ddx, ddy);
		outColor = cospVec4(curTile, bottomTile, (tex.y - (1.0 - blendMarginY)) / (blendMarginY * 2.0));
	}
	else
	{
		outColor = curTile;
	}
	
	outColor *= color;
	${webGLVer<2?"gl_FragColor = outColor;":""}
	${webGLVer>=2?"gl_FragDepth = (outColor.a == 0.0 ? 1.0 : gl_FragCoord.z);":""}
	${webGLVer<2&&hasFragDepthExt?"gl_FragDepthEXT = (outColor.a == 0.0 ? 1.0 : gl_FragCoord.z);":""}
}
`}static GetPointVertexShaderSource_WebGL1(){return["attribute vec4 aPoints;","varying float pointOpacity;","uniform float zElevation;","uniform mat4 matP;","uniform mat4 matMV;","void main(void) {","\tgl_Position = matP * matMV * vec4(aPoints.xy, zElevation, 1.0);","\tgl_PointSize = aPoints.z;","\tpointOpacity = aPoints.w;","}"].join("\n")}static GetPointVertexShaderSource_WebGL2(){return["#version 300 es","in vec4 aPoints;","out float pointOpacity;","uniform float zElevation;","uniform mat4 matP;",
"uniform mat4 matMV;","void main(void) {","\tgl_Position = matP * matMV * vec4(aPoints.xy, zElevation, 1.0);","\tgl_PointSize = aPoints.z;","\tpointOpacity = aPoints.w;","}"].join("\n")}static GetPointFragmentShaderSource_WebGL1_NoFragDepth(){return["uniform lowp sampler2D samplerFront;","varying lowp float pointOpacity;","uniform mediump vec2 pointTexStart;","uniform mediump vec2 pointTexEnd;","uniform lowp vec4 color;","void main(void) {","\tmediump vec2 pointTexMin = min(pointTexStart, pointTexEnd);",
"\tmediump vec2 pointTexMax = max(pointTexStart, pointTexEnd);","\tmediump vec2 pointCoord = (pointTexEnd.x > pointTexStart.x ? gl_PointCoord : vec2(1.0 - gl_PointCoord.y, gl_PointCoord.x));","\tgl_FragColor = texture2D(samplerFront, mix(pointTexMin, pointTexMax, pointCoord)) * color * pointOpacity;","}"].join("\n")}static GetPointFragmentShaderSource_WebGL1_FragDepthEXT(){return["#extension GL_EXT_frag_depth : enable","uniform lowp sampler2D samplerFront;","varying lowp float pointOpacity;","uniform mediump vec2 pointTexStart;",
"uniform mediump vec2 pointTexEnd;","uniform lowp vec4 color;","void main(void) {","\tmediump vec2 pointTexMin = min(pointTexStart, pointTexEnd);","\tmediump vec2 pointTexMax = max(pointTexStart, pointTexEnd);","\tmediump vec2 pointCoord = (pointTexEnd.x > pointTexStart.x ? gl_PointCoord : vec2(1.0 - gl_PointCoord.y, gl_PointCoord.x));","\tgl_FragColor = texture2D(samplerFront, mix(pointTexMin, pointTexMax, pointCoord)) * color * pointOpacity;","\tgl_FragDepthEXT = (gl_FragColor.a == 0.0 ? 1.0 : gl_FragCoord.z);",
"}"].join("\n")}static GetPointFragmentShaderSource_WebGL2(){return["#version 300 es","uniform lowp sampler2D samplerFront;","in lowp float pointOpacity;","uniform mediump vec2 pointTexStart;","uniform mediump vec2 pointTexEnd;","uniform lowp vec4 color;","out lowp vec4 outColor;","void main(void) {","\tmediump vec2 pointTexMin = min(pointTexStart, pointTexEnd);","\tmediump vec2 pointTexMax = max(pointTexStart, pointTexEnd);","\tmediump vec2 pointCoord = (pointTexEnd.x > pointTexStart.x ? gl_PointCoord : vec2(1.0 - gl_PointCoord.y, gl_PointCoord.x));",
"\toutColor = texture(samplerFront, mix(pointTexMin, pointTexMax, pointCoord)) * color * pointOpacity;","\tgl_FragDepth = (outColor.a == 0.0 ? 1.0 : gl_FragCoord.z);","}"].join("\n")}static GetColorFillFragmentShaderSource(){return["uniform lowp vec4 color;","void main(void) {","\tgl_FragColor = color;","}"].join("\n")}static GetLinearGradientFillFragmentShaderSource(){return["precision lowp float;","varying mediump vec2 vTex;","uniform vec4 color;","uniform vec4 color2_;","vec3 fromLinear(vec3 linearRGB)",
"{","\tbvec3 cutoff = lessThan(linearRGB, vec3(0.0031308));","\tvec3 higher = vec3(1.055) * pow(abs(linearRGB), vec3(1.0/2.4)) - vec3(0.055);","\tvec3 lower = linearRGB * vec3(12.92);","\treturn mix(higher, lower, vec3(cutoff));","}","vec3 toLinear(vec3 sRGB)","{","\tbvec3 cutoff = lessThan(sRGB, vec3(0.04045));","\tvec3 higher = pow(abs((sRGB + vec3(0.055))/vec3(1.055)), vec3(2.4));","\tvec3 lower = sRGB/vec3(12.92);","\treturn mix(higher, lower, vec3(cutoff));","}","void main(void) {","\tvec3 linearGrad = mix(toLinear(color.rgb), toLinear(color2_.rgb), vTex.x);",
"\tfloat a = mix(color.a, color2_.a, vTex.x);","\tgl_FragColor = vec4(fromLinear(linearGrad) * a, a);","}"].join("\n")}static GetPenumbraFillFragmentShaderSource(){return[`#ifdef GL_FRAGMENT_PRECISION_HIGH`,`#define highmedp highp`,`#else`,`#define highmedp mediump`,`#endif`,`precision lowp float;`,`varying highmedp vec2 vTex;`,`uniform vec4 color;`,`void main(void) {`,`	highmedp float grad = vTex.x / (1.0 - vTex.y);`,`	gl_FragColor = color * (1.0 - (cos(grad * 3.141592653589793) + 1.0) / 2.0);`,
`}`].join("\n")}static GetSmoothLineFillFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;","void main(void) {","\tlowp float f = 1.0 - abs(vTex.y - 0.5) * 2.0;","\tgl_FragColor = color * f;","}"].join("\n")}static GetHardEllipseFillFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);","\tmediump vec2 diffSq = diff * diff;","\tmediump float f = step(diffSq.x + diffSq.y, 0.25);",
"\tgl_FragColor = color * f;","}"].join("\n")}static GetHardEllipseOutlineFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;","uniform mediump vec2 pixelSize;","uniform mediump float outlineThickness;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);","\tmediump vec2 diffSq = diff * diff;","\tmediump float distSq = diffSq.x + diffSq.y;","\tmediump vec2 norm = normalize(diff);","\tmediump vec2 halfNorm = norm * 0.5;","\tmediump float innerF = step(distSq, 0.25);",
"\tmediump vec2 innerEdge = halfNorm - pixelSize * norm * outlineThickness;","\tmediump vec2 innerEdgeSq = innerEdge * innerEdge;","\tmediump float outerF = step(innerEdgeSq.x + innerEdgeSq.y, distSq);","\tgl_FragColor = color * innerF * outerF;","}"].join("\n")}static GetSmoothEllipseFillFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;","uniform mediump vec2 pixelSize;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);","\tmediump vec2 diffSq = diff * diff;",
"\tmediump vec2 norm = normalize(diff);","\tmediump vec2 halfNorm = norm * 0.5;","\tmediump vec2 halfNormSq = halfNorm * halfNorm;","\tmediump vec2 innerEdge = halfNorm - pixelSize * norm;","\tmediump vec2 innerEdgeSq = innerEdge * innerEdge;","\tmediump float f = smoothstep(halfNormSq.x + halfNormSq.y, innerEdgeSq.x + innerEdgeSq.y, diffSq.x + diffSq.y);","\tgl_FragColor = color * f;","}"].join("\n")}static GetSmoothEllipseOutlineFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;",
"uniform mediump vec2 pixelSize;","uniform mediump float outlineThickness;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);","\tmediump vec2 diffSq = diff * diff;","\tmediump float distSq = diffSq.x + diffSq.y;","\tmediump vec2 norm = normalize(diff);","\tmediump vec2 halfNorm = norm * 0.5;","\tmediump vec2 halfNormSq = halfNorm * halfNorm;","\tmediump vec2 pxNorm = pixelSize * norm;","\tmediump vec2 innerEdge1 = halfNorm - pxNorm;","\tmediump vec2 innerEdge1Sq = innerEdge1 * innerEdge1;",
"\tmediump float innerF = smoothstep(halfNormSq.x + halfNormSq.y, innerEdge1Sq.x + innerEdge1Sq.y, distSq);","\tmediump vec2 innerEdge2 = halfNorm - pxNorm * outlineThickness;","\tmediump vec2 innerEdge2Sq = innerEdge2 * innerEdge2;","\tmediump vec2 innerEdge3 = halfNorm - pxNorm * (outlineThickness + 1.0);","\tmediump vec2 innerEdge3Sq = innerEdge3 * innerEdge3;","\tmediump float outerF = smoothstep(innerEdge3Sq.x + innerEdge3Sq.y, innerEdge2Sq.x + innerEdge2Sq.y, distSq);","\tgl_FragColor = color * innerF * outerF;",
"}"].join("\n")}};

}

// ../lib/gfx/webgl/shaderUniform.js
{
'use strict';const C3=self.C3;const glMatrix=self.glMatrix;const mat4=glMatrix.mat4;const TYPE_SIZES=new Map([["float",1],["percent",1],["sampler",1],["vec2",2],["vec3",3],["color",3],["vec4",4],["mat4",16]]);
C3.Gfx.WebGLShaderUniform=class WebGLShaderUniform{constructor(owner,name,type){if(!TYPE_SIZES.has(type))throw new Error("invalid uniform type");this._owner=owner;this._gl=this._owner.GetWebGLContext();this._name=name;this._type=type;this._isColorType=this._type==="color";this._location=this._gl.getUniformLocation(this._owner.GetShaderProgram(),name);this._isUsed=!!this._location;const typeSize=TYPE_SIZES.get(type);this._lastValue=new Float32Array(typeSize);this._lastBatchValue=new Float32Array(typeSize)}Release(){this._owner=
null;this._gl=null;this._location=null}IsUsed(){return this._isUsed}GetType(){return this._type}IsColorType(){return this._isColorType}Init1f(v0){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastBatchValue.set(this._lastValue);this._gl.uniform1f(this._location,v0)}Init1i(v0){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastBatchValue.set(this._lastValue);this._gl.uniform1i(this._location,v0)}Init2f(v0,v1){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastValue[1]=v1;this._lastBatchValue.set(this._lastValue);
this._gl.uniform2f(this._location,v0,v1)}Init3f(v0,v1,v2){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastValue[1]=v1;this._lastValue[2]=v2;this._lastBatchValue.set(this._lastValue);this._gl.uniform3f(this._location,v0,v1,v2)}Init4f(v0,v1,v2,v3){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastValue[1]=v1;this._lastValue[2]=v2;this._lastValue[3]=v3;this._lastBatchValue.set(this._lastValue);this._gl.uniform4f(this._location,v0,v1,v2,v3)}Update1f(v0){v0=Math.fround(v0);const lastValue=
this._lastValue;if(lastValue[0]===v0)return;lastValue[0]=v0;this._gl.uniform1f(this._location,v0)}Update1i(v0){const lastValue=this._lastValue;if(lastValue[0]===v0)return;lastValue[0]=v0;this._gl.uniform1i(this._location,v0)}Update2f(v0,v1){v0=Math.fround(v0);v1=Math.fround(v1);const lastValue=this._lastValue;if(lastValue[0]===v0&&lastValue[1]===v1)return;lastValue[0]=v0;lastValue[1]=v1;this._gl.uniform2f(this._location,v0,v1)}Update3f(v0,v1,v2){v0=Math.fround(v0);v1=Math.fround(v1);v2=Math.fround(v2);
const lastValue=this._lastValue;if(lastValue[0]===v0&&lastValue[1]===v1&&lastValue[2]===v2)return;lastValue[0]=v0;lastValue[1]=v1;lastValue[2]=v2;this._gl.uniform3f(this._location,v0,v1,v2)}Update4f(v0,v1,v2,v3){v0=Math.fround(v0);v1=Math.fround(v1);v2=Math.fround(v2);v3=Math.fround(v3);const lastValue=this._lastValue;if(lastValue[0]===v0&&lastValue[1]===v1&&lastValue[2]===v2&&lastValue[3]===v3)return;lastValue[0]=v0;lastValue[1]=v1;lastValue[2]=v2;lastValue[3]=v3;this._gl.uniform4f(this._location,
v0,v1,v2,v3)}UpdateMatrix4fv(m){const lastValue=this._lastValue;if(mat4.exactEquals(lastValue,m))return;C3.typedArraySet16(lastValue,m,0);this._gl.uniformMatrix4fv(this._location,false,m)}IsSetToCustomInBatch(p){const batchValue=this._lastBatchValue;if(this.IsColorType())return batchValue[0]===Math.fround(p.getR())&&batchValue[1]===Math.fround(p.getG())&&batchValue[2]===Math.fround(p.getB());else return batchValue[0]===Math.fround(p)}SetBatchValueCustom(p){const batchValue=this._lastBatchValue;if(this.IsColorType()){batchValue[0]=
p.getR();batchValue[1]=p.getG();batchValue[2]=p.getB()}else batchValue[0]=p}IsSetTo1InBatch(x){return this._lastBatchValue[0]===Math.fround(x)}IsSetTo2InBatch(x,y){const batchValue=this._lastBatchValue;return batchValue[0]===Math.fround(x)&&batchValue[1]===Math.fround(y)}SetBatch1(x){this._lastBatchValue[0]=x}SetBatch2(x,y){const batchValue=this._lastBatchValue;batchValue[0]=x;batchValue[1]=y}};

}

// ../lib/gfx/webgl/batchJob.js
{
'use strict';const C3=self.C3;const glMatrix=self.glMatrix;const vec4=glMatrix.vec4;const mat4=glMatrix.mat4;const BATCH_NULL=0;const BATCH_QUAD=1;const BATCH_SETTEXTURE=2;const BATCH_SETCOLOR=3;const BATCH_SETBLEND=4;const BATCH_SETVIEWPORT=5;const BATCH_SETPROJECTION=6;const BATCH_SETMODELVIEW=7;const BATCH_SETRENDERTARGET=8;const BATCH_CLEARSURFACE=9;const BATCH_POINTS=10;const BATCH_SETPROGRAM=11;const BATCH_SETPROGRAMPARAMETERS=12;const BATCH_SETPROGRAMCUSTOMPARAMETERS=13;
const BATCH_INVALIDATEFRAMEBUFFER=14;const BATCH_SETPOINTTEXCOORDS=15;const BATCH_SETTILEMAPINFO=16;const BATCH_BLITFRAMEBUFFER=17;const BATCH_STARTQUERY=18;const BATCH_ENDQUERY=19;const BATCH_SETELLIPSEPARAMS=20;const BATCH_SETGRADIENTCOLOR=21;const BATCH_CLEARDEPTH=22;const BATCH_SETDEPTHENABLED=23;const BATCH_SETDEPTHSAMPLINGENABLED=24;const BATCH_COPLANAR_STARTSTENCILPASS=25;const BATCH_COPLANAR_STARTCOLORPASS=26;const BATCH_COPLANAR_RESTORE=27;const BATCH_SET_SCISSOR=28;
const BATCH_SETTILERANDOMIZATIONINFO=29;C3.Gfx.BatchState=class BatchState{constructor(renderer){this.renderer=renderer;this.currentMV=mat4.create();this.currentMatP=mat4.create();this.currentFramebuffer=null;this.currentFramebufferNoDepth=null;this.isDepthSamplingEnabled=false;this.currentColor=vec4.fromValues(1,1,1,1);this.currentShader=null;this.pointTexCoords=new C3.Rect;this.clearColor=C3.New(C3.Color,0,0,0,0)}};
C3.Gfx.WebGLBatchJob=class WebGLBatchJob{constructor(batchState){const arrayBuffer=new ArrayBuffer(96);this._type=0;this._batchState=batchState;this._gl=batchState.renderer.GetContext();this._startIndex=0;this._indexCount=0;this._texParam=null;this._mat4param=new Float32Array(arrayBuffer,0,16);this._colorParam=new Float32Array(arrayBuffer,64,4);this._srcOriginRect=new Float32Array(arrayBuffer,80,4);this._shaderParams=[]}InitQuad(startIndex,indexCount){this._type=BATCH_QUAD;this._startIndex=startIndex;
this._indexCount=indexCount}DoQuad(){const gl=this._gl;gl.drawElements(gl.TRIANGLES,this._indexCount,gl.UNSIGNED_SHORT,this._startIndex)}InitSetTexture(rendererTex){this._type=BATCH_SETTEXTURE;this._texParam=rendererTex}DoSetTexture(){const gl=this._gl;const texParam=this._texParam;gl.bindTexture(gl.TEXTURE_2D,texParam?texParam._GetTexture():null)}InitSetColor(c){this._type=BATCH_SETCOLOR;c.writeToTypedArray(this._colorParam,0)}DoSetColor(){const c=this._colorParam;const batchState=this._batchState;
vec4.copy(batchState.currentColor,c);batchState.currentShader.UpdateColor(c)}InitSetGradientColor(c){this._type=BATCH_SETGRADIENTCOLOR;c.writeToTypedArray(this._colorParam,0)}DoSetGradientColor(){const c=this._colorParam;const s=this._batchState.currentShader;if(s._uColor2.IsUsed())s._uColor2.Update4f(c[0],c[1],c[2],c[3])}InitSetBlend(s,d){this._type=BATCH_SETBLEND;this._startIndex=s;this._indexCount=d}DoSetBlend(){this._gl.blendFunc(this._startIndex,this._indexCount)}InitSetViewport(x,y,w,h){this._type=
BATCH_SETVIEWPORT;const colorParam=this._colorParam;colorParam[0]=x;colorParam[1]=y;colorParam[2]=w;colorParam[3]=h}DoSetViewport(){const colorParam=this._colorParam;this._gl.viewport(colorParam[0],colorParam[1],colorParam[2],colorParam[3])}InitSetProjection(m){this._type=BATCH_SETPROJECTION;mat4.copy(this._mat4param,m)}DoSetProjection(){const batchState=this._batchState;const allShaderPrograms=batchState.renderer._allShaderPrograms;const currentShader=batchState.currentShader;const mat4param=this._mat4param;
for(let i=0,len=allShaderPrograms.length;i<len;++i){const s=allShaderPrograms[i];if(s===currentShader)s.UpdateMatP(mat4param,true);else s.SetMatPStale()}mat4.copy(batchState.currentMatP,mat4param)}InitSetModelView(m){this._type=BATCH_SETMODELVIEW;mat4.copy(this._mat4param,m)}DoSetModelView(){const batchState=this._batchState;const allShaderPrograms=batchState.renderer._allShaderPrograms;const currentShader=batchState.currentShader;const mat4param=this._mat4param;for(let i=0,len=allShaderPrograms.length;i<
len;++i){const s=allShaderPrograms[i];if(s===currentShader)s.UpdateMatMV(mat4param,true);else s.SetMatMVStale()}mat4.copy(batchState.currentMV,mat4param)}InitSetRenderTarget(renderTarget){this._type=BATCH_SETRENDERTARGET;this._texParam=renderTarget}DoSetRenderTarget(){const gl=this._gl;const renderTarget=this._texParam;const batchState=this._batchState;if(renderTarget){batchState.currentFramebuffer=renderTarget._GetFramebuffer();batchState.currentFramebufferNoDepth=renderTarget._GetFramebufferNoDepth();
if(batchState.isDepthSamplingEnabled&&batchState.currentFramebufferNoDepth)gl.bindFramebuffer(gl.FRAMEBUFFER,batchState.currentFramebufferNoDepth);else gl.bindFramebuffer(gl.FRAMEBUFFER,batchState.currentFramebuffer)}else{batchState.currentFramebuffer=null;batchState.currentFramebufferNoDepth=null;gl.bindFramebuffer(gl.FRAMEBUFFER,null)}}InitClearSurface(c){this._type=BATCH_CLEARSURFACE;c.writeToTypedArray(this._mat4param,0)}InitClearSurface2(r,g,b,a){this._type=BATCH_CLEARSURFACE;const c=this._mat4param;
c[0]=r;c[1]=g;c[2]=b;c[3]=a}DoClearSurface(){const gl=this._gl;const mat4param=this._mat4param;const batchState=this._batchState;const lastClearColor=batchState.clearColor;const r=mat4param[0];const g=mat4param[1];const b=mat4param[2];const a=mat4param[3];if(!lastClearColor.equalsRgba(r,g,b,a)){gl.clearColor(r,g,b,a);lastClearColor.setRgba(r,g,b,a)}gl.clear(gl.COLOR_BUFFER_BIT)}InitSetPointTexCoords(rect){this._type=BATCH_SETPOINTTEXCOORDS;rect.writeToTypedArray(this._mat4param,0)}DoSetPointTextureCoords(){const mat4param=
this._mat4param;this._batchState.pointTexCoords.set(mat4param[0],mat4param[1],mat4param[2],mat4param[3])}InitPoints(startIndex,z){this._type=BATCH_POINTS;this._startIndex=startIndex;this._indexCount=1;this._mat4param[0]=z}DoPoints(){const gl=this._gl;const batchState=this._batchState;const renderer=batchState.renderer;const s=renderer._spPoints;gl.useProgram(s._shaderProgram);s.UpdateMatP(batchState.currentMatP,false);s.UpdateMatMV(batchState.currentMV,false);const ptc=batchState.pointTexCoords;if(s._uPointTexStart.IsUsed())s._uPointTexStart.Update2f(ptc.getLeft(),
ptc.getTop());if(s._uPointTexEnd.IsUsed())s._uPointTexEnd.Update2f(ptc.getRight(),ptc.getBottom());const z=this._mat4param[0];if(s._uZElevation.IsUsed())s._uZElevation.Update1f(z);if(s._uColor.IsUsed()){const c=batchState.currentColor;s._uColor.Update4f(c[0],c[1],c[2],c[3])}gl.drawArrays(gl.POINTS,this._startIndex/4,this._indexCount);gl.useProgram(batchState.currentShader._shaderProgram)}InitSetProgram(program){this._type=BATCH_SETPROGRAM;this._texParam=program}DoSetProgram(){const gl=this._gl;const batchState=
this._batchState;const s=this._texParam;batchState.currentShader=s;gl.useProgram(s._shaderProgram);s.UpdateMatP(batchState.currentMatP,false);s.UpdateMatMV(batchState.currentMV,false);if(s._uColor.IsUsed()){const c=batchState.currentColor;s._uColor.Update4f(c[0],c[1],c[2],c[3])}}InitSetProgramParameters(){this._type=BATCH_SETPROGRAMPARAMETERS}DoSetProgramParameters(){const s=this._batchState.currentShader;const gl=this._gl;const mat4param=this._mat4param;const colorParam=this._colorParam;const srcOriginRect=
this._srcOriginRect;if(s._uSamplerBack.IsUsed()){const renderer=this._batchState.renderer;const texParam=this._texParam;if(renderer._lastTexture1!==texParam){gl.activeTexture(gl.TEXTURE1);gl.bindTexture(gl.TEXTURE_2D,texParam?texParam._GetTexture():null);renderer._lastTexture1=texParam;gl.activeTexture(gl.TEXTURE0)}}if(s._uPixelSize.IsUsed())s._uPixelSize.Update2f(mat4param[0],mat4param[1]);if(s._uDestStart.IsUsed())s._uDestStart.Update2f(mat4param[2],mat4param[3]);if(s._uDestEnd.IsUsed())s._uDestEnd.Update2f(mat4param[4],
mat4param[5]);if(s._uDevicePixelRatio.IsUsed())s._uDevicePixelRatio.Update1f(this._indexCount);if(s._uLayerScale.IsUsed())s._uLayerScale.Update1f(mat4param[6]);if(s._uLayerAngle.IsUsed())s._uLayerAngle.Update1f(mat4param[7]);if(s._uSrcStart.IsUsed())s._uSrcStart.Update2f(mat4param[12],mat4param[13]);if(s._uSrcEnd.IsUsed())s._uSrcEnd.Update2f(mat4param[14],mat4param[15]);if(s._uSrcOriginStart.IsUsed())s._uSrcOriginStart.Update2f(srcOriginRect[0],srcOriginRect[1]);if(s._uSrcOriginEnd.IsUsed())s._uSrcOriginEnd.Update2f(srcOriginRect[2],
srcOriginRect[3]);if(s._uLayoutStart.IsUsed())s._uLayoutStart.Update2f(colorParam[0],colorParam[1]);if(s._uLayoutEnd.IsUsed())s._uLayoutEnd.Update2f(colorParam[2],colorParam[3]);if(s._uSeconds.IsUsed())s._uSeconds.Update1f(this._startIndex)}InitSetProgramCustomParameters(){this._type=BATCH_SETPROGRAMCUSTOMPARAMETERS}DoSetProgramCustomParameters(){const s=this._batchState.currentShader;const uCustomParameters=s._uCustomParameters;const shaderParams=this._shaderParams;for(let i=0,len=uCustomParameters.length;i<
len;++i){const shaderUniform=uCustomParameters[i];const paramValue=shaderParams[i];if(shaderUniform.IsColorType())shaderUniform.Update3f(paramValue.getR(),paramValue.getG(),paramValue.getB());else shaderUniform.Update1f(paramValue)}}InitInvalidateFramebuffer(fbo){this._type=BATCH_INVALIDATEFRAMEBUFFER;this._texParam=fbo}DoInvalidateFramebuffer(){const gl=this._gl;const fbo=this._texParam;const lastBoundFbo=this._batchState.currentFramebuffer;if(fbo!==lastBoundFbo)gl.bindFramebuffer(gl.FRAMEBUFFER,
fbo);gl.invalidateFramebuffer(gl.FRAMEBUFFER,[gl.COLOR_ATTACHMENT0]);if(fbo!==lastBoundFbo)gl.bindFramebuffer(gl.FRAMEBUFFER,lastBoundFbo)}InitBlitFramebuffer(sourceRenderTarget,destRenderTarget,mode){this._type=BATCH_BLITFRAMEBUFFER;const mat4param=this._mat4param;const renderer=this._batchState.renderer;mat4param[0]=sourceRenderTarget.GetWidth();mat4param[1]=sourceRenderTarget.GetHeight();mat4param[2]=destRenderTarget?destRenderTarget.GetWidth():renderer.GetWidth();mat4param[3]=destRenderTarget?
destRenderTarget.GetHeight():renderer.GetHeight();mat4param[4]=sourceRenderTarget.IsLinearSampling()?1:0;mat4param[5]=mode==="stretch";const shaderParams=this._shaderParams;C3.clearArray(shaderParams);shaderParams.push(sourceRenderTarget._GetFramebuffer());shaderParams.push(destRenderTarget?destRenderTarget._GetFramebuffer():null)}DoBlitFramebuffer(){const mat4param=this._mat4param;const shaderParams=this._shaderParams;const gl=this._gl;const srcWidth=mat4param[0];const srcHeight=mat4param[1];const destWidth=
mat4param[2];const destHeight=mat4param[3];const isLinearSampling=mat4param[4]!==0;const isStretch=mat4param[5]!==0;const srcFbo=shaderParams[0];const destFbo=shaderParams[1];gl.bindFramebuffer(gl.READ_FRAMEBUFFER,srcFbo);gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER,destFbo);if(isStretch)gl.blitFramebuffer(0,0,srcWidth,srcHeight,0,0,destWidth,destHeight,gl.COLOR_BUFFER_BIT,isLinearSampling?gl.LINEAR:gl.NEAREST);else{const w=Math.min(srcWidth,destWidth);const h=Math.min(srcHeight,destHeight);const srcOffY=
Math.max(srcHeight-destHeight,0);const destOffY=Math.max(destHeight-srcHeight,0);gl.blitFramebuffer(0,srcOffY,w,h+srcOffY,0,destOffY,w,h+destOffY,gl.COLOR_BUFFER_BIT,gl.NEAREST)}}InitStartQuery(query){this._type=BATCH_STARTQUERY;this._texParam=query}DoStartQuery(){this._texParam.BeginTimeElapsed();this._texParam=null}InitEndQuery(query){this._type=BATCH_ENDQUERY;this._texParam=query}DoEndQuery(){this._texParam.EndTimeElapsed();this._texParam=null}InitSetEllipseParams(pixelW,pixelH,outlineThickness){this._type=
BATCH_SETELLIPSEPARAMS;const mat4param=this._mat4param;mat4param[0]=pixelW;mat4param[1]=pixelH;mat4param[2]=outlineThickness}DoSetEllipseParams(){const s=this._batchState.currentShader;const mat4param=this._mat4param;if(s._uPixelSize.IsUsed())s._uPixelSize.Update2f(mat4param[0],mat4param[1]);if(s._uOutlineThickness.IsUsed())s._uOutlineThickness.Update1f(mat4param[2])}InitSetTilemapInfo(srcRect,textureWidth,textureHeight,tileWidth,tileHeight,tileSpacingX,tileSpacingY){this._type=BATCH_SETTILEMAPINFO;
const mat4param=this._mat4param;srcRect.writeToTypedArray(mat4param,0);mat4param[4]=1/textureWidth;mat4param[5]=1/textureHeight;mat4param[6]=tileWidth/textureWidth;mat4param[7]=tileHeight/textureHeight;mat4param[8]=tileSpacingX/textureWidth;mat4param[9]=tileSpacingY/textureHeight}DoSetTilemapInfo(){const s=this._batchState.currentShader;const mat4param=this._mat4param;if(s._uSrcStart.IsUsed())s._uSrcStart.Update2f(mat4param[0],mat4param[1]);if(s._uPixelSize.IsUsed())s._uPixelSize.Update2f(mat4param[4],
mat4param[5]);if(s._uTileSize.IsUsed())s._uTileSize.Update2f(mat4param[6],mat4param[7]);if(s._uTileSpacing.IsUsed())s._uTileSpacing.Update2f(mat4param[8],mat4param[9])}InitSetTileRandomizationInfo(textureWidth,textureHeight,xRandom,yRandom,angleRandom,blendMarginX,blendMarginY){this._type=BATCH_SETTILERANDOMIZATIONINFO;const mat4param=this._mat4param;mat4param[0]=1/textureWidth;mat4param[1]=1/textureHeight;mat4param[2]=xRandom;mat4param[3]=yRandom;mat4param[4]=angleRandom;mat4param[5]=blendMarginX;
mat4param[6]=blendMarginY}DoSetTileRandomizationInfo(){const s=this._batchState.currentShader;const mat4param=this._mat4param;if(s._uPixelSize.IsUsed())s._uPixelSize.Update2f(mat4param[0],mat4param[1]);if(s._uTileSize.IsUsed())s._uTileSize.Update2f(mat4param[2],mat4param[3]);if(s._uOutlineThickness.IsUsed())s._uOutlineThickness.Update1f(mat4param[4]);if(s._uTileSpacing.IsUsed())s._uTileSpacing.Update2f(mat4param[5],mat4param[6])}InitClearDepth(isDepthEnabled){this._type=BATCH_CLEARDEPTH;this._startIndex=
isDepthEnabled?1:0}DoClearDepth(){const gl=this._gl;const isDepthEnabled=this._startIndex!==0;if(!isDepthEnabled)gl.depthMask(true);gl.clear(gl.DEPTH_BUFFER_BIT);if(!isDepthEnabled)gl.depthMask(false)}InitSetDepthEnabled(e){this._type=BATCH_SETDEPTHENABLED;this._startIndex=e?1:0}DoSetDepthEnabled(){const gl=this._gl;if(this._startIndex===0){gl.disable(gl.DEPTH_TEST);gl.depthMask(false)}else{gl.enable(gl.DEPTH_TEST);gl.depthMask(true)}}InitSetDepthSamplingEnabled(e){this._type=BATCH_SETDEPTHSAMPLINGENABLED;
this._startIndex=e?1:0}DoSetDepthSamplingEnabled(){const gl=this._gl;const batchState=this._batchState;const renderer=batchState.renderer;const isDepthSamplingEnabled=this._startIndex!==0;batchState.isDepthSamplingEnabled=isDepthSamplingEnabled;gl.activeTexture(gl.TEXTURE2);if(isDepthSamplingEnabled){if(batchState.currentFramebufferNoDepth)gl.bindFramebuffer(gl.FRAMEBUFFER,batchState.currentFramebufferNoDepth);gl.bindTexture(gl.TEXTURE_2D,renderer._GetDepthBuffer())}else{gl.bindTexture(gl.TEXTURE_2D,
null);if(batchState.currentFramebufferNoDepth)gl.bindFramebuffer(gl.FRAMEBUFFER,batchState.currentFramebuffer)}gl.activeTexture(gl.TEXTURE0)}InitCoplanarStartStencilPass(){this._type=BATCH_COPLANAR_STARTSTENCILPASS}DoCoplanarStartStencilPass(){const gl=this._gl;gl.clear(gl.STENCIL_BUFFER_BIT);gl.enable(gl.STENCIL_TEST);gl.stencilFunc(gl.ALWAYS,1,1);gl.stencilOp(gl.KEEP,gl.KEEP,gl.REPLACE);gl.colorMask(false,false,false,false)}InitCoplanarStartColorPass(){this._type=BATCH_COPLANAR_STARTCOLORPASS}DoCoplanarStartColorPass(){const gl=
this._gl;gl.colorMask(true,true,true,true);gl.stencilFunc(gl.EQUAL,1,1);gl.stencilOp(gl.KEEP,gl.KEEP,gl.KEEP)}InitCoplanarRestore(){this._type=BATCH_COPLANAR_RESTORE}DoCoplanarRestore(){const gl=this._gl;gl.disable(gl.STENCIL_TEST)}InitSetScissor(enable,x,y,w,h){this._type=BATCH_SET_SCISSOR;this._startIndex=enable?1:0;const mat4param=this._mat4param;mat4param[0]=x;mat4param[1]=y;mat4param[2]=w;mat4param[3]=h}DoSetScissor(){const gl=this._gl;const mat4param=this._mat4param;if(this._startIndex===1){gl.enable(gl.SCISSOR_TEST);
gl.scissor(mat4param[0],mat4param[1],mat4param[2],mat4param[3])}else gl.disable(gl.SCISSOR_TEST)}Run(){switch(this._type){case 1:this.DoQuad();return;case 2:this.DoSetTexture();return;case 3:this.DoSetColor();return;case 4:this.DoSetBlend();return;case 5:this.DoSetViewport();return;case 6:this.DoSetProjection();return;case 7:this.DoSetModelView();return;case 8:this.DoSetRenderTarget();return;case 9:this.DoClearSurface();return;case 10:this.DoPoints();return;case 11:this.DoSetProgram();return;case 12:this.DoSetProgramParameters();
return;case 13:this.DoSetProgramCustomParameters();return;case 14:this.DoInvalidateFramebuffer();return;case 15:this.DoSetPointTextureCoords();return;case 16:this.DoSetTilemapInfo();return;case 17:this.DoBlitFramebuffer();return;case 18:this.DoStartQuery();return;case 19:this.DoEndQuery();return;case 20:this.DoSetEllipseParams();return;case 21:this.DoSetGradientColor();return;case 22:this.DoClearDepth();return;case 23:this.DoSetDepthEnabled();return;case 24:this.DoSetDepthSamplingEnabled();return;
case 25:this.DoCoplanarStartStencilPass();return;case 26:this.DoCoplanarStartColorPass();return;case 27:this.DoCoplanarRestore();return;case 28:this.DoSetScissor();return;case 29:this.DoSetTileRandomizationInfo();return}}};

}

// ../lib/gfx/text.js
{
'use strict';const C3=self.C3;const MAX_TEXTURE_SIZE=4096;const EXTRA_LINE_HEIGHT=4;const GENERIC_FONT_FAMILIES=new Set(["serif","sans-serif","monospace","cursive","fantasy","system-ui","ui-serif","ui-sans-serif","ui-monospace","ui-rounded","math","emoji","fangsong"]);const DEFAULT_OPTS={timeout:60};const tempColor=new C3.Color(0,0,0,1);const VALID_HORIZ_ALIGNMENTS=new Set(["left","center","right"]);const VALID_VERT_ALIGNMENTS=new Set(["top","center","bottom"]);
const VALID_WORD_WRAP_MODES=new Set(["word","character"]);const allRendererTexts=new Set;if(C3.FontManager)C3.FontManager.addEventListener("fontload",e=>{const fontName=e.font.GetName();for(const f of allRendererTexts)if(f.IsBBCodeEnabled()||C3.equalsNoCase(f.GetFontName(),fontName))f._SetTextChanged()});
function fillOrStrokeText(ctx,isStroke,text,x,y,maxWidth){if(isStroke)if(C3.Platform.BrowserEngine==="Gecko")ctx.strokeText(text,x,y,maxWidth);else ctx.strokeText(text,x,y);else if(C3.Platform.BrowserEngine==="Gecko")ctx.fillText(text,x,y,maxWidth);else ctx.fillText(text,x,y)}function fillOrStrokeRect(ctx,isStroke,x,y,w,h){if(isStroke)ctx.strokeRect(x,y,w,h);else ctx.fillRect(x,y,w,h)}function ptToPx(pt){return pt*(4/3)}let didCheckFoundBoundingBoxSupport=false;
let supportsFontBoundingBoxMeasurements=false;
C3.Gfx.RendererText=class RendererText{constructor(renderer,opts){opts=Object.assign({},DEFAULT_OPTS,opts);this._renderer=renderer;this._fontName="Arial";this._fontSize=16;this._fontSizeScale=1;this._lineHeight=0;this._isBold=false;this._isItalic=false;this._colorStr="black";this._isBBcodeEnabled=false;this.onloadfont=null;this._alreadyLoadedFonts=new Set;this._horizontalAlign="left";this._verticalAlign="top";this._text="";this._bbString=null;this._wrappedText=C3.New(C3.WordWrap);this._wrapMode="word";
this._textChanged=false;this._drawMaxCharCount=-1;this._drawCharCount=0;this._cssWidth=0;this._cssHeight=0;this._width=0;this._height=0;this._zoom=1;this._changed=false;this._textCanvas=null;this._textContext=null;this._measureContext=null;this._measureContextTop=null;this._lastCanvasWidth=-1;this._lastCanvasHeight=-1;this._lastTextCanvasFont="";this._lastMeasureCanvasFont="";this._lastTextCanvasFillStyle="";this._lastTextCanvasOpacity=1;this._lastTextCanvasLineWidth=1;this._measureTextCallback=(chArr,
styles)=>this._MeasureText(chArr,styles);this._texture=null;this._rcTex=new C3.Rect;this._scaleFactor=1;this._textureTimeout=new C3.IdleTimeout(()=>{this.ReleaseTexture();this._SetTextCanvasSize(8,8)},opts.timeout);this.ontextureupdate=null;this._wasReleased=false;allRendererTexts.add(this)}Release(){this.onloadfont=null;this._alreadyLoadedFonts.clear();this._bbString=null;this._textCanvas=null;this._textContext=null;this._measureContext=null;this._measureContextTop=null;this._measureTextCallback=
null;this._textureTimeout.Release();this.ontextureupdate=null;this.ReleaseTexture();this._wrappedText.Clear();this._wrappedText=null;this._renderer=null;this._wasReleased=true;allRendererTexts.delete(this)}_SetChanged(){this._changed=true}_SetTextChanged(){this._SetChanged();this._wrappedText.Clear();this._textChanged=true}SetBBCodeEnabled(e){e=!!e;if(this._isBBcodeEnabled===e)return;this._isBBcodeEnabled=e;const textBaseline=this._isBBcodeEnabled?"alphabetic":"top";if(this._textContext)this._textContext.textBaseline=
textBaseline;if(this._measureContext)this._measureContext.textBaseline=textBaseline;this._SetTextChanged()}IsBBCodeEnabled(){return this._isBBcodeEnabled}SetFontName(fontName){if(!fontName)fontName="serif";if(this._fontName===fontName)return;this._fontName=fontName;this._SetTextChanged()}GetFontName(){return this._fontName}SetFontSize(fontSize){if(fontSize<.1)fontSize=.1;if(this._fontSize===fontSize)return;this._fontSize=fontSize;this._SetTextChanged()}SetFontSizeScale(s){if(this._fontSizeScale===
s)return;this._fontSizeScale=s;this._SetTextChanged()}SetLineHeight(h){if(this._lineHeight===h)return;this._lineHeight=h;this._SetChanged()}SetBold(bold){bold=!!bold;if(this._isBold===bold)return;this._isBold=bold;this._SetTextChanged()}SetItalic(italic){italic=!!italic;if(this._isItalic===italic)return;this._isItalic=italic;this._SetTextChanged()}SetDrawMaxCharacterCount(n){n=Math.floor(n);if(this._drawMaxCharCount===n)return;this._drawMaxCharCount=n;this._SetChanged()}GetDrawMaxCharacterCount(){return this._drawMaxCharCount}_GetStyleTag(styles,
tag){for(let i=styles.length-1;i>=0;--i){const s=styles[i];if(s.tag===tag)return s}return null}_HasStyleTag(styles,tag){return!!this._GetStyleTag(styles,tag)}_GetFontString(useCssUnits,styles){let ret=[];if(this._isBold||this._HasStyleTag(styles,"b"))ret.push("bold");if(this._isItalic||this._HasStyleTag(styles,"i"))ret.push("italic");const sizeStyle=this._GetStyleTag(styles,"size");const fontSize=(sizeStyle?parseFloat(sizeStyle.param):this._fontSize)*this._fontSizeScale;if(useCssUnits)ret.push(fontSize+
"pt");else ret.push(fontSize*this.GetDrawScale()+"pt");let fontName=this._fontName;const fontStyle=this._GetStyleTag(styles,"font");if(fontStyle&&fontStyle.param){fontName=fontStyle.param;if(this.onloadfont&&!this._alreadyLoadedFonts.has(fontName)){this.onloadfont(fontName);this._alreadyLoadedFonts.add(fontName)}}if(fontName)if(GENERIC_FONT_FAMILIES.has(fontName))ret.push(fontName);else ret.push('"'+fontName+'"');return ret.join(" ")}SetColor(c){if(c instanceof C3.Color)c=c.getCssRgb();if(this._colorStr===
c)return;this._colorStr=c;this._SetChanged()}SetColorRgb(r,g,b){tempColor.setRgb(r,g,b);this.SetColor(tempColor)}SetHorizontalAlignment(h){if(!VALID_HORIZ_ALIGNMENTS.has(h))throw new Error("invalid horizontal alignment");if(this._horizontalAlign===h)return;this._horizontalAlign=h;this._SetChanged()}SetVerticalAlignment(v){if(!VALID_VERT_ALIGNMENTS.has(v))throw new Error("invalid vertical alignment");if(this._verticalAlign===v)return;this._verticalAlign=v;this._SetChanged()}SetWordWrapMode(m){if(!VALID_WORD_WRAP_MODES.has(m))throw new Error("invalid word wrap mode");
if(this._wrapMode===m)return;this._wrapMode=m;this._SetTextChanged()}SetText(text){if(this._text===text)return;this._text=text;this._SetTextChanged()}GetDrawScale(){return this._scaleFactor*this._zoom*self.devicePixelRatio}SetSize(cssWidth,cssHeight,zoom){if(typeof zoom==="undefined")zoom=1;if(cssWidth<=0||cssWidth<=0)return;if(this._cssWidth===cssWidth&&this._cssHeight===cssHeight&&this._zoom===zoom)return;const oldCssWidth=this._cssWidth;this._cssWidth=cssWidth;this._cssHeight=cssHeight;this._zoom=
zoom;const dpr=self.devicePixelRatio;this._width=this._cssWidth*this._zoom*dpr;this._height=this._cssHeight*this._zoom*dpr;const maxDim=Math.max(this._width,this._height);const maxTextureSize=Math.min(this._renderer.GetMaxTextureSize(),MAX_TEXTURE_SIZE);let scale=1;if(maxDim>maxTextureSize){scale=maxTextureSize/maxDim;this._width=Math.min(this._width*scale,maxTextureSize);this._height=Math.min(this._height*scale,maxTextureSize)}this._scaleFactor=scale;if(this._cssWidth!==oldCssWidth)this._SetTextChanged();
else this._SetChanged()}GetWidth(){return this._width}GetHeight(){return this._height}GetZoom(){return this._zoom}GetTextWidth(){this._MaybeWrapText();return this._wrappedText.GetMaxLineWidth()}GetTextHeight(){this._MaybeWrapText();return this._wrappedText.GetTotalLineHeight()+this._wrappedText.GetLineCount()*(this._lineHeight+EXTRA_LINE_HEIGHT)-this._lineHeight}GetTexture(){this._textureTimeout.Reset();this._MaybeUpdate();return this._texture}HitTestFragment(x,y){this._MaybeUpdate();const scale=
this.GetDrawScale();const lines=this._wrappedText.GetLines();for(const line of lines){const yOff=line.fontBoundingBoxDescent*scale;if(y>=line.penY-line.height*scale+yOff&&y<line.penY+yOff)for(const frag of line.fragments)if(x>=frag.penX&&x<frag.penX+frag.width*scale)return frag}return null}*fragmentsWithTag(tag){this._MaybeUpdate();const lines=this._wrappedText.GetLines();for(const line of lines)for(const frag of line.fragments){const tagStyle=this._GetStyleTag(frag.styles,"tag");if(tagStyle&&C3.equalsNoCase(tagStyle.param,
tag))yield frag}}FindFragmentWithTag(tag,index){for(const frag of this.fragmentsWithTag(tag))if(index===0)return frag;else--index;return null}CountFragmentsWithTag(tag){let count=0;for(const frag of this.fragmentsWithTag(tag))++count;return count}_MaybeUpdate(){if(this._texture&&!this._changed&&!this._textChanged)return;if(this._wasReleased)return;if(this._width<=0||this._height<=0)return;this._changed=false;this._DoUpdate()}_DoUpdate(){if(this._wasReleased)return;this._SetTextCanvasSize(Math.max(C3.nextHighestPowerOfTwo(Math.ceil(this._width)),
128),Math.max(C3.nextHighestPowerOfTwo(Math.ceil(this._height)),64));this._MaybeWrapText();this._DrawTextToCanvas();this._UpdateTexture();this._textureTimeout.Reset()}_SetTextCanvasSize(w,h){if(!this._textCanvas)this._textCanvas=C3.CreateCanvas(16,16);let wasReset=false;if(this._lastCanvasWidth!==w||this._lastCanvasHeight!==h){this._lastCanvasWidth=w;this._lastCanvasHeight=h;this._textCanvas.width=w;this._textCanvas.height=h;wasReset=true}if(!this._textContext){this._textContext=this._textCanvas.getContext("2d");
wasReset=true}if(wasReset){this._textContext.textBaseline=this._isBBcodeEnabled?"alphabetic":"top";this._textContext.font=this._lastTextCanvasFont;this._textContext.fillStyle=this._lastTextCanvasFillStyle;this._textContext.strokeStyle=this._lastTextCanvasFillStyle;this._textContext.globalAlpha=this._lastTextCanvasOpacity;this._textContext.lineWidth=this._lastTextCanvasLineWidth}else this._textContext.clearRect(0,0,w,h)}_MaybeCreateMeasureContext(){if(this._measureContext)return;this._measureContext=
C3.CreateCanvas(16,16).getContext("2d");this._measureContextTop=C3.CreateCanvas(16,16).getContext("2d");this._measureContext.textBaseline=this._isBBcodeEnabled?"alphabetic":"top";this._measureContextTop.textBaseline="top"}_SetMeasureFontString(fontString){if(this._lastMeasureCanvasFont===fontString)return;this._lastMeasureCanvasFont=fontString;this._measureContext.font=fontString;this._measureContextTop.font=fontString}_SupportsFontBoundingBoxMeasurements(){if(!didCheckFoundBoundingBoxSupport){didCheckFoundBoundingBoxSupport=
true;this._MaybeCreateMeasureContext();const textMetrics=this._measureContext.measureText("test");supportsFontBoundingBoxMeasurements=typeof textMetrics["fontBoundingBoxAscent"]==="number"&&typeof textMetrics["fontBoundingBoxDescent"]==="number"}return supportsFontBoundingBoxMeasurements}_MaybeWrapText(){if(!this._textChanged)return;this._MaybeCreateMeasureContext();if(this._isBBcodeEnabled&&(!this._bbString||this._bbString.toString()!==this._text))this._bbString=new C3.BBString(this._text,{noEscape:true});
this._wrappedText.WordWrap(this._isBBcodeEnabled?this._bbString.toFragmentList():this._text,this._measureTextCallback,this._cssWidth,this._wrapMode,0);this._textChanged=false}_MeasureText(chArr,styles){const text=chArr.join("");this._SetMeasureFontString(this._GetFontString(true,styles));const sizeStyle=this._GetStyleTag(styles,"size");const fontSize=(sizeStyle?parseFloat(sizeStyle.param):this._fontSize)*this._fontSizeScale;const textMetrics=this._measureContext.measureText(text);let topToAlphabeticDistance=
0;if(this._isBBcodeEnabled&&this._SupportsFontBoundingBoxMeasurements()){const textMetricsTop=this._measureContextTop.measureText(text);topToAlphabeticDistance=textMetrics["fontBoundingBoxAscent"]-textMetricsTop["fontBoundingBoxAscent"]}return{width:textMetrics.width,height:ptToPx(fontSize),fontBoundingBoxAscent:textMetrics["fontBoundingBoxAscent"]||0,fontBoundingBoxDescent:textMetrics["fontBoundingBoxDescent"]||0,topToAlphabeticDistance}}_SetDrawFontString(fontString){if(this._lastTextCanvasFont===
fontString)return;this._lastTextCanvasFont=fontString;this._textContext.font=fontString}_SetDrawCanvasColor(styleStr){if(this._lastTextCanvasFillStyle===styleStr)return;this._lastTextCanvasFillStyle=styleStr;this._textContext.fillStyle=styleStr;this._textContext.strokeStyle=styleStr}_SetDrawCanvasOpacity(o){if(this._lastTextCanvasOpacity===o)return;this._lastTextCanvasOpacity=o;this._textContext.globalAlpha=o}_SetDrawCanvasLineWith(w){if(this._lastTextCanvasLineWidth===w)return;this._lastTextCanvasLineWidth=
w;this._textContext.lineWidth=w}_DrawTextToCanvas(){this._drawCharCount=0;const scale=this.GetDrawScale();const lineSpaceHeight=(EXTRA_LINE_HEIGHT+this._lineHeight)*scale;let penY=0;const lines=this._wrappedText.GetLines();if(lines.length===0)return;const useFontBoundingBoxMeasurements=this._isBBcodeEnabled&&this._SupportsFontBoundingBoxMeasurements();let firstLineTextHeight=lines[0].height*scale;if(this._verticalAlign==="center"){const linesTotalHeight=lines.reduce((a,v)=>a+v.height*scale+lineSpaceHeight,
0)-lineSpaceHeight;penY=Math.max(this._height/2-linesTotalHeight/2,0);if(useFontBoundingBoxMeasurements)firstLineTextHeight=lines[0].topToAlphabeticDistance*scale}else if(this._verticalAlign==="bottom"){const linesTotalHeight=lines.reduce((a,v)=>a+v.height*scale+lineSpaceHeight,0)-this._lineHeight*scale;const lastLineDescentHeight=useFontBoundingBoxMeasurements?lines.at(-1).fontBoundingBoxDescent*scale:0;penY=this._height-linesTotalHeight-lastLineDescentHeight-2}for(let i=0,len=lines.length;i<len;++i){const line=
lines[i];const curLineTextHeight=line.height*scale;const startPenY=penY;if(this._isBBcodeEnabled){penY+=i===0?firstLineTextHeight:curLineTextHeight;if(i>0&&penY>this._height-EXTRA_LINE_HEIGHT*scale)break}else if(i>0&&penY>=this._height-curLineTextHeight)break;if(startPenY>=0)this._DrawTextLine(line,penY,scale);if(!this._isBBcodeEnabled)penY+=curLineTextHeight;penY+=lineSpaceHeight}}_DrawTextLine(line,penY,scale){let penX=0;if(this._horizontalAlign==="center")penX=(this._width-line.width*scale)/2;
else if(this._horizontalAlign==="right")penX=this._width-line.width*scale;line.penX=penX;line.penY=penY;for(const frag of line.fragments){this._DrawTextFragment(frag,penX,penY,scale,line.height);penX+=frag.width*scale}}_DrawTextFragment(frag,penX,penY,scale,lineHeight){frag.penX=penX;frag.penY=penY;const textContext=this._textContext;const lineFontScale=lineHeight/16;let fragWidth=frag.width*scale;const fragHeight=frag.height*scale;const fragFontScale=frag.height/16;const lineSpaceHeight=(EXTRA_LINE_HEIGHT+
this._lineHeight)*scale;const styles=frag.styles;let chArr=frag.chArr;if(this._drawMaxCharCount!==-1){if(this._drawCharCount>=this._drawMaxCharCount)return;if(this._drawCharCount+chArr.length>this._drawMaxCharCount){chArr=chArr.slice(0,this._drawMaxCharCount-this._drawCharCount);fragWidth=this._MeasureText(chArr,styles).width*scale}this._drawCharCount+=chArr.length}const backgroundStyle=this._GetStyleTag(styles,"background");const hasUnderline=this._HasStyleTag(styles,"u");const hasStrikethrough=
this._HasStyleTag(styles,"s");if(C3.IsCharArrayAllWhitespace(chArr)&&!backgroundStyle&&!hasUnderline&&!hasStrikethrough||this._HasStyleTag(styles,"hide"))return;const text=chArr.join("");const offsetXStyle=this._GetStyleTag(styles,"offsetx");penX+=offsetXStyle?parseFloat(offsetXStyle.param)*scale:0;const offsetYStyle=this._GetStyleTag(styles,"offsety");penY+=offsetYStyle?parseFloat(offsetYStyle.param)*scale:0;if(backgroundStyle){this._SetDrawCanvasColor(backgroundStyle.param);textContext.fillRect(penX,
penY-fragHeight,fragWidth,fragHeight+lineSpaceHeight)}const colorStyle=this._GetStyleTag(styles,"color");this._SetDrawCanvasColor(colorStyle?colorStyle.param:this._colorStr);const opacityStyle=this._GetStyleTag(styles,"opacity");this._SetDrawCanvasOpacity(opacityStyle?parseFloat(opacityStyle.param)/100:1);const lineThicknessStyle=this._GetStyleTag(styles,"linethickness");const lineThicknessScale=lineThicknessStyle?parseFloat(lineThicknessStyle.param):1;const isStroke=this._HasStyleTag(styles,"stroke");
if(isStroke)this._SetDrawCanvasLineWith(fragFontScale*.5*lineThicknessScale*this.GetDrawScale());this._SetDrawFontString(this._GetFontString(false,styles));fillOrStrokeText(textContext,isStroke,text,penX,penY,fragWidth);if(!isStroke){this._SetDrawCanvasLineWith(fragFontScale*.5*lineThicknessScale*this.GetDrawScale());const outlineStyle=this._GetStyleTag(styles,"outline");if(outlineStyle){this._SetDrawCanvasColor(outlineStyle.param);fillOrStrokeText(textContext,true,text,penX,penY,fragWidth)}}this._SetDrawCanvasColor(colorStyle?
colorStyle.param:this._colorStr);if(hasUnderline)fillOrStrokeRect(textContext,isStroke,penX,penY+scale*lineFontScale,fragWidth,scale*lineFontScale*lineThicknessScale);if(hasStrikethrough){const defaultStrikeY=penY-fragHeight/4;const defaultStrikeHeight=scale*fragFontScale;const strikeYMid=defaultStrikeY+defaultStrikeHeight/2;textContext.fillRect(penX,strikeYMid-defaultStrikeHeight*lineThicknessScale/2,fragWidth,defaultStrikeHeight*lineThicknessScale)}}_UpdateTexture(){if(this._renderer.IsContextLost())return;
if(!this._texture)this._texture=this._renderer.CreateDynamicTexture(this._textCanvas.width,this._textCanvas.height,{mipMap:true,mipMapQuality:"high"});this._renderer.UpdateTexture(this._textCanvas,this._texture);this._rcTex.set(0,0,this._width/this._texture.GetWidth(),this._height/this._texture.GetHeight());if(this.ontextureupdate)this.ontextureupdate()}GetTexRect(){return this._rcTex}ReleaseTexture(){if(this._texture){if(!this._renderer.IsContextLost())this._renderer.DeleteTexture(this._texture);
this._texture=null}}static OnContextLost(){for(const rendererText of allRendererTexts)rendererText.ReleaseTexture()}static GetAll(){return allRendererTexts.values()}};

}

// ../lib/gfx/webgl/query.js
{
'use strict';const C3=self.C3;
class WebGLRealTimeElapsedQuery{constructor(renderer){this._gl=renderer.GetContext();this._version=renderer.GetWebGLVersionNumber();this._timerExt=renderer._GetDisjointTimerQueryExtension();this._query=null;this._isActive=false;this._hasResult=false;this._result=0;if(this._version===1)this._query=this._timerExt["createQueryEXT"]();else this._query=this._gl["createQuery"]()}Release(){this._DeleteQueryObject();this._gl=null;this._timerExt=null;this._hasResult=false}_DeleteQueryObject(){if(!this._query)return;if(this._version===
1)this._timerExt["deleteQueryEXT"](this._query);else this._gl["deleteQuery"](this._query);this._query=null}BeginTimeElapsed(){if(this._isActive)throw new Error("query already active");if(this._version===1)this._timerExt["beginQueryEXT"](this._timerExt["TIME_ELAPSED_EXT"],this._query);else this._gl["beginQuery"](this._timerExt["TIME_ELAPSED_EXT"],this._query);this._isActive=true}EndTimeElapsed(){if(!this._isActive)throw new Error("query not active");if(this._version===1)this._timerExt["endQueryEXT"](this._timerExt["TIME_ELAPSED_EXT"]);
else this._gl["endQuery"](this._timerExt["TIME_ELAPSED_EXT"]);this._isActive=false}CheckForResult(){if(!this._query||this._hasResult||this._isActive)return;let available=false;if(this._version===1)available=this._timerExt["getQueryObjectEXT"](this._query,this._timerExt["QUERY_RESULT_AVAILABLE_EXT"]);else available=this._gl["getQueryParameter"](this._query,this._gl["QUERY_RESULT_AVAILABLE"]);const disjoint=this._gl.getParameter(this._timerExt["GPU_DISJOINT_EXT"]);if(available&&!disjoint){if(this._version===
1)this._result=this._timerExt["getQueryObjectEXT"](this._query,this._timerExt["QUERY_RESULT_EXT"]);else this._result=this._gl["getQueryParameter"](this._query,this._gl["QUERY_RESULT"]);this._result/=1E9;this._hasResult=true}if(available||disjoint)this._DeleteQueryObject()}HasResult(){return this._hasResult}GetResult(){if(!this._hasResult)throw new Error("no result available");return this._result}}
C3.Gfx.WebGLTimeElapsedQuery=class WebGLTimeElapsedQuery{constructor(renderer){this._renderer=renderer;this._frameNumber=renderer.GetFrameNumber();this._isActive=false;this._parentQuery=null;this._isNested=false;this._realQuery=null;this._queries=[]}Release(){for(const q of this._queries)if(q instanceof WebGLRealTimeElapsedQuery)q.Release();C3.clearArray(this._queries);this._parentQuery=null;this._realQuery=null;this._renderer=null}BeginTimeElapsed(){if(this._isActive)throw new Error("query already active");
const stack=this._renderer._GetTimeQueryStack();if(stack.length>0){this._isNested=true;this._parentQuery=stack.at(-1);this._parentQuery._EndReal();this._parentQuery._queries.push(this)}else{this._isNested=false;this._parentQuery=null}this._isActive=true;stack.push(this);this._StartReal()}EndTimeElapsed(){if(!this._isActive)throw new Error("query not active");const top=this._renderer._GetTimeQueryStack().pop();if(top!==this)throw new Error("can only end most nested query");this._isActive=false;this._EndReal();
if(this._parentQuery){this._parentQuery._StartReal();this._parentQuery=null}}_StartReal(){this._realQuery=C3.New(WebGLRealTimeElapsedQuery,this._renderer);this._queries.push(this._realQuery);this._realQuery.BeginTimeElapsed()}_EndReal(){this._realQuery.EndTimeElapsed();this._realQuery=null}CheckForResult(){for(const q of this._queries)q.CheckForResult()}IsNested(){return this._isNested}HasResult(){return this._queries.every(q=>q.HasResult())}GetResult(){return this._queries.reduce((a,v)=>a+v.GetResult(),
0)}GetFrameNumber(){return this._frameNumber}};

}

// ../lib/gfx/webgl/queryResultBuffer.js
{
'use strict';const C3=self.C3;
C3.Gfx.WebGLQueryResultBuffer=class WebGLQueryResultBuffer{constructor(renderer,maxQueries=1E3){this._renderer=renderer;this._maxQueries=maxQueries;this._buffer=[];this._renderer._AddQueryResultBuffer(this)}Release(){this.Clear();this._renderer._RemoveQueryResultBuffer(this);this._renderer=null}Clear(){for(const q of this._buffer)q.Release();C3.clearArray(this._buffer)}AddTimeElapsedQuery(){const ret=new C3.Gfx.WebGLTimeElapsedQuery(this._renderer);this._buffer.push(ret);if(this._buffer.length>this._maxQueries){const oldest=
this._buffer.shift();oldest.Release()}return ret}CheckForResults(toFrameNumber){for(const q of this._buffer){if(q.GetFrameNumber()>=toFrameNumber)return;if(q.IsNested())return;q.CheckForResult()}}GetFrameRangeResultSum(startFrame,endFrame){if(endFrame<=startFrame)return NaN;let sum=0;for(const q of this._buffer){if(q.GetFrameNumber()>=endFrame)break;if(q.GetFrameNumber()<startFrame)continue;if(q.HasResult())sum+=q.GetResult();else return NaN}return sum}DeleteAllBeforeFrameNumber(frameNumber){for(let i=
0,len=this._buffer.length;i<len;++i){const q=this._buffer[i];if(q.GetFrameNumber()<frameNumber)q.Release();else{if(i>0)this._buffer.splice(0,i);return}}}};

}

// ../lib/gfx/webgl/webglRenderer.js
{
'use strict';const C3=self.C3;const assert=self.assert;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const vec4=glMatrix.vec4;const mat4=glMatrix.mat4;const DEFAULT_WEBGLRENDERER_OPTS={powerPreference:"default",enableGpuProfiling:true,alpha:false,lowLatency:false,depth:false,canSampleDepth:false,maxWebGLVersion:2,failIfMajorPerformanceCaveat:false};const VALID_POWER_PREFERENCES=new Set(["default","low-power","high-performance"]);const MAX_VERTICES=8E3;const MAX_INDICES=MAX_VERTICES/2*3;
const MAX_POINTS=8E3;const LAST_POINT=MAX_POINTS-4;const PARTIAL_TEXTURE_UPLOAD_CHUNK_SIZE=256*1024;const defaultTexCoordsQuad=new C3.Quad(0,0,1,0,1,1,0,1);const tmpProjection=mat4.create();const tmpModelView=mat4.create();const tmpQuad=new C3.Quad;const tmpRect=new C3.Rect;let loseContextExtension=null;
if(C3.isDebug){self.debug_lose_webgl_context=function(){if(!loseContextExtension){console.warn("WEBGL_lose_context not supported");return}loseContextExtension.loseContext()};self.debug_restore_webgl_context=function(){if(!loseContextExtension){console.warn("WEBGL_lose_context not supported");return}loseContextExtension.restoreContext()}}const pendingPolls=new Set;let pollRafId=-1;
function CheckPendingPolls(){pollRafId=-1;for(const info of pendingPolls)if(info.checkFunc()){info.resolve();pendingPolls.delete(info)}if(pendingPolls.size>0)pollRafId=self.requestAnimationFrame(CheckPendingPolls)}
C3.Gfx.WebGLRenderer=class WebGLRenderer extends C3.Gfx.RendererBase{constructor(canvas,opts){super(opts);opts=Object.assign({},DEFAULT_WEBGLRENDERER_OPTS,opts);if(!VALID_POWER_PREFERENCES.has(opts.powerPreference))throw new Error("invalid power preference");const attribs={"alpha":!!opts.alpha,"depth":false,"antialias":false,"powerPreference":opts.powerPreference,"failIfMajorPerformanceCaveat":!!opts.failIfMajorPerformanceCaveat};if(opts.lowLatency){attribs["desynchronized"]=true;attribs["preserveDrawingBuffer"]=
true}let gl=null;let version=0;if(opts.maxWebGLVersion>=2){gl=canvas.getContext("webgl2",attribs);version=2}if(!gl){gl=canvas.getContext("webgl",attribs);version=1}if(!gl)throw new Error("renderer-unavailable (could not get WebGL context)");this._gl=gl;this._attribs=gl.getContextAttributes();if(opts.lowLatency&&!this._attribs["desynchronized"])console.info("[WebGLRenderer] Low-latency mode specified but is not supported here");this._versionString=gl.getParameter(gl.VERSION);this._version=version;
this._viewport=vec4.create();this._didChangeTransform=false;this._bbProjectionMatrix=mat4.create();this._usesDepthBuffer=!!opts.depth;this._canSampleDepth=!!(opts.depth&&opts.canSampleDepth);this._isDepthEnabled=this._usesDepthBuffer;this._isDepthSamplingEnabled=false;this._depthBuffer=null;this._isAutoSizeDepthBuffer=true;this._depthBufferWidth=0;this._depthBufferHeight=0;this._vertexBuffer=null;this._texcoordBuffer=null;this._indexBuffer=null;this._pointBuffer=null;this._vertexData=new Float32Array(MAX_VERTICES*
this.GetNumVertexComponents());this._indexData=new Uint16Array(MAX_INDICES);this._texcoordData=new Float32Array(MAX_VERTICES*2);this._pointData=new Float32Array(MAX_POINTS*4);this._vertexPtr=0;this._texPtr=0;this._pointPtr=0;this._lastVertexPtr=0;this._lastProgram=null;this._spDeviceTransformTextureFill=null;this._batch=[];this._batchPtr=0;this._topOfBatch=0;this._currentRenderTarget=null;this._lastPointZ=0;this._batchState=C3.New(C3.Gfx.BatchState,this);this._lastColor=C3.New(C3.Color,1,1,1,1);this._lastTexture0=
null;this._lastTexture1=null;this._lastSrcBlend=0;this._lastDestBlend=0;this._lastPointTexCoords=new C3.Rect;this._lastScissorRect=C3.New(C3.Rect,0,0,-1,-1);this._maxTextureSize=-1;this._minPointSize=0;this._maxPointSize=0;this._highpPrecision=0;this._unmaskedVendor="(unavailable)";this._unmaskedRenderer="(unavailable)";this._extensions=[];this._isInitialisingAfterContextRestored=false;this._parallelShaderCompileExt=null;this._anisotropicExt=null;this._depthTextureExt=null;this._fragDepthExt=null;
this._stdDerivativesExt=null;this._textureLodExt=null;this._maxAnisotropy=0;this._isGpuProfilingEnabled=!!opts.enableGpuProfiling;this._timerExt=null;this._allQueryResultBuffers=new Set;this._timeQueryStack=[];this.FillIndexBufferData(this._indexData)}IsWebGL(){return true}async InitState(){super.InitState();const gl=this._gl;const numVertexComponents=this.GetNumVertexComponents();this._lastColor.setRgba(1,1,1,1);this._lastTexture0=null;this._lastTexture1=null;this._vertexPtr=0;this._pointPtr=0;this._lastVertexPtr=
MAX_VERTICES*numVertexComponents-4*numVertexComponents;C3.clearArray(this._batch);this._batchPtr=0;this._topOfBatch=0;this._lastProgram=null;this._currentRenderTarget=null;this._lastPointTexCoords.set(0,0,1,1);this._lastPointZ=0;const batchState=this._batchState;batchState.currentShader=null;batchState.currentFramebuffer=null;batchState.currentFramebufferNoDepth=null;vec4.set(batchState.currentColor,1,1,1,1);batchState.clearColor.setRgba(0,0,0,0);batchState.pointTexCoords.set(0,0,1,1);gl.clearColor(0,
0,0,0);gl.clear(gl.COLOR_BUFFER_BIT);gl.enable(gl.BLEND);gl.blendFunc(gl.ONE,gl.ONE_MINUS_SRC_ALPHA);this._lastSrcBlend=gl.ONE;this._lastDestBlend=gl.ONE_MINUS_SRC_ALPHA;this._InitBlendModes(gl);gl.disable(gl.CULL_FACE);gl.disable(gl.STENCIL_TEST);gl.disable(gl.DITHER);if(this._usesDepthBuffer){gl.enable(gl.DEPTH_TEST);gl.depthMask(true);gl.depthFunc(gl.LEQUAL)}else{gl.disable(gl.DEPTH_TEST);gl.depthMask(false)}this._isDepthEnabled=this._usesDepthBuffer;this._isDepthSamplingEnabled=false;this._pointBuffer=
gl.createBuffer();gl.bindBuffer(gl.ARRAY_BUFFER,this._pointBuffer);gl.bufferData(gl.ARRAY_BUFFER,this._pointData.byteLength,gl.DYNAMIC_DRAW);this._vertexBuffer=gl.createBuffer();gl.bindBuffer(gl.ARRAY_BUFFER,this._vertexBuffer);gl.bufferData(gl.ARRAY_BUFFER,this._vertexData.byteLength,gl.DYNAMIC_DRAW);this._texcoordBuffer=gl.createBuffer();gl.bindBuffer(gl.ARRAY_BUFFER,this._texcoordBuffer);gl.bufferData(gl.ARRAY_BUFFER,this._texcoordData.byteLength,gl.DYNAMIC_DRAW);this._indexBuffer=gl.createBuffer();
gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,this._indexBuffer);gl.bufferData(gl.ELEMENT_ARRAY_BUFFER,this._indexData,gl.STATIC_DRAW);gl.activeTexture(gl.TEXTURE0);gl.bindTexture(gl.TEXTURE_2D,null);this._maxTextureSize=gl.getParameter(gl.MAX_TEXTURE_SIZE);const pointsizes=gl.getParameter(gl.ALIASED_POINT_SIZE_RANGE);this._minPointSize=pointsizes[0];this._maxPointSize=pointsizes[1];const highpVertex=gl.getShaderPrecisionFormat(gl.VERTEX_SHADER,gl.HIGH_FLOAT);const highpFrag=gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER,
gl.HIGH_FLOAT);if(highpVertex&&highpFrag)this._highpPrecision=Math.min(highpVertex["precision"],highpFrag["precision"]);else this._highpPrecision=0;if(this._maxPointSize>2048)this._maxPointSize=2048;this._extensions=gl.getSupportedExtensions();const debug_ext=gl.getExtension("WEBGL_debug_renderer_info");if(debug_ext){this._unmaskedVendor=gl.getParameter(debug_ext["UNMASKED_VENDOR_WEBGL"]);this._unmaskedRenderer=gl.getParameter(debug_ext["UNMASKED_RENDERER_WEBGL"])}this._parallelShaderCompileExt=gl.getExtension("KHR_parallel_shader_compile");
if(C3.isDebug)loseContextExtension=gl.getExtension("WEBGL_lose_context");if(this._isGpuProfilingEnabled)if(this.GetWebGLVersionNumber()===1){if(C3.Platform.BrowserEngine!=="Chromium"||C3.Platform.BrowserVersionNumber>=81||typeof document!=="undefined")this._timerExt=gl.getExtension("EXT_disjoint_timer_query")}else this._timerExt=gl.getExtension("EXT_disjoint_timer_query_webgl2")||gl.getExtension("EXT_disjoint_timer_query");this._anisotropicExt=gl.getExtension("EXT_texture_filter_anisotropic");if(this._anisotropicExt)this._maxAnisotropy=
gl.getParameter(this._anisotropicExt["MAX_TEXTURE_MAX_ANISOTROPY_EXT"]);else this._maxAnisotropy=0;if(this.GetWebGLVersionNumber()<2&&this._usesDepthBuffer&&this._canSampleDepth){this._depthTextureExt=gl.getExtension("WEBGL_depth_texture");if(!this._depthTextureExt)throw new Error("no depth texture support");}if(this.GetWebGLVersionNumber()<2){this._fragDepthExt=gl.getExtension("EXT_frag_depth");this._stdDerivativesExt=gl.getExtension("OES_standard_derivatives");this._textureLodExt=gl.getExtension("EXT_shader_texture_lod")}const WebGLShaderProgram=
C3.Gfx.WebGLShaderProgram;const vsSource=WebGLShaderProgram.GetDefaultVertexShaderSource(false);let textureFillFragmentSrc=WebGLShaderProgram.GetTextureFillFragmentShaderSource_WebGL1_NoFragDepth();let textureFillVertexSrc=vsSource;let pointFragmentSrc=WebGLShaderProgram.GetPointFragmentShaderSource_WebGL1_NoFragDepth();let pointVertexSrc=WebGLShaderProgram.GetPointVertexShaderSource_WebGL1();let tilemapFragmentSrc=WebGLShaderProgram.GetTilemapFragmentShaderSource_WebGL1_NoFragDepth();let tilemapVertexSrc=
WebGLShaderProgram.GetDefaultVertexShaderSource(true);let useFragDepthExt=false;if(this._usesDepthBuffer&&(C3.Platform.Browser!=="Safari"||C3.Platform.BrowserVersionNumber>=15.5))if(this.GetWebGLVersionNumber()<2){if(this._fragDepthExt){textureFillFragmentSrc=WebGLShaderProgram.GetTextureFillFragmentShaderSource_WebGL1_FragDepthEXT();pointFragmentSrc=WebGLShaderProgram.GetPointFragmentShaderSource_WebGL1_FragDepthEXT();tilemapFragmentSrc=WebGLShaderProgram.GetTilemapFragmentShaderSource_WebGL1_FragDepthEXT();
useFragDepthExt=true}}else{textureFillVertexSrc=WebGLShaderProgram.GetDefaultVertexShaderSource_WebGL2();textureFillFragmentSrc=WebGLShaderProgram.GetTextureFillFragmentShaderSource_WebGL2();pointFragmentSrc=WebGLShaderProgram.GetPointFragmentShaderSource_WebGL2();pointVertexSrc=WebGLShaderProgram.GetPointVertexShaderSource_WebGL2();tilemapFragmentSrc=WebGLShaderProgram.GetTilemapFragmentShaderSource_WebGL2();tilemapVertexSrc=WebGLShaderProgram.GetDefaultVertexShaderSource_WebGL2(true)}const tileRandomizationFragmentSrc=
WebGLShaderProgram.GetTileRandomizationFragmentShaderSource(this.GetWebGLVersionNumber(),useFragDepthExt,this._stdDerivativesExt&&this._textureLodExt);const tileRandomizationVertexSrc=this.GetWebGLVersionNumber()>=2?WebGLShaderProgram.GetDefaultVertexShaderSource_WebGL2():vsSource;const DEFAULT_SHADER_PROGRAMS=[[textureFillFragmentSrc,textureFillVertexSrc,"<default>"],[textureFillFragmentSrc,textureFillVertexSrc,"<default-device-transform>"],[pointFragmentSrc,pointVertexSrc,"<point>"],[WebGLShaderProgram.GetColorFillFragmentShaderSource(),
vsSource,"<fill>"],[WebGLShaderProgram.GetLinearGradientFillFragmentShaderSource(),vsSource,"<lineargradient>"],[WebGLShaderProgram.GetPenumbraFillFragmentShaderSource(),vsSource,"<penumbra>"],[WebGLShaderProgram.GetHardEllipseFillFragmentShaderSource(),vsSource,"<hardellipse>"],[WebGLShaderProgram.GetHardEllipseOutlineFragmentShaderSource(),vsSource,"<hardellipseoutline>"],[WebGLShaderProgram.GetSmoothEllipseFillFragmentShaderSource(),vsSource,"<smoothellipse>"],[WebGLShaderProgram.GetSmoothEllipseOutlineFragmentShaderSource(),
vsSource,"<smoothellipseoutline>"],[WebGLShaderProgram.GetSmoothLineFillFragmentShaderSource(),vsSource,"<smoothline>"],[tilemapFragmentSrc,tilemapVertexSrc,"<tilemap>"],[tileRandomizationFragmentSrc,tileRandomizationVertexSrc,"<tilerandomization>"]];const defaultShaders=await Promise.all(DEFAULT_SHADER_PROGRAMS.map(i=>this.CreateShaderProgram({src:i[0],vertexSrc:i[1],name:i[2]})));this._spTextureFill=defaultShaders[0];this._spDeviceTransformTextureFill=defaultShaders[1];this._spPoints=defaultShaders[2];
this._spColorFill=defaultShaders[3];this._spLinearGradientFill=defaultShaders[4];this._spPenumbraFill=defaultShaders[5];this._spHardEllipseFill=defaultShaders[6];this._spHardEllipseOutline=defaultShaders[7];this._spSmoothEllipseFill=defaultShaders[8];this._spSmoothEllipseOutline=defaultShaders[9];this._spSmoothLineFill=defaultShaders[10];this._spTilemapFill=defaultShaders[11];this._spTileRandomization=defaultShaders[12];this.SetTextureFillMode()}async CreateShaderProgram(shaderInfo){const ret=await C3.Gfx.WebGLShaderProgram.Create(this,
shaderInfo);this._AddShaderProgram(ret);return ret}ResetLastProgram(){this._lastProgram=null}SetSize(w,h,force){if(this._width===w&&this._height===h&&!force)return;this.EndBatch();const gl=this._gl;const batchState=this._batchState;this._width=w;this._height=h;this._SetViewport(0,0,w,h);this.CalculatePerspectiveMatrix(this._bbProjectionMatrix,w/h);this.SetProjectionMatrix(this._bbProjectionMatrix);if(this._spDeviceTransformTextureFill){gl.useProgram(this._spDeviceTransformTextureFill.GetShaderProgram());
this._spDeviceTransformTextureFill._UpdateDeviceTransformUniforms(this._matP);this._lastProgram=this._spDeviceTransformTextureFill;this._batchState.currentShader=this._spDeviceTransformTextureFill}gl.bindTexture(gl.TEXTURE_2D,null);gl.activeTexture(gl.TEXTURE1);gl.bindTexture(gl.TEXTURE_2D,null);gl.activeTexture(gl.TEXTURE0);this._lastTexture0=null;this._lastTexture1=null;if(this._usesDepthBuffer&&this._isAutoSizeDepthBuffer)this._SetDepthBufferSize(this._width,this._height);if(this._currentRenderTarget)this._currentRenderTarget._Resize(this._width,
this._height);gl.bindFramebuffer(gl.FRAMEBUFFER,null);this._currentRenderTarget=null;batchState.currentFramebuffer=null;batchState.currentFramebufferNoDepth=null}_SetDepthBufferSize(width,height){const gl=this._gl;if(this._depthBuffer&&this._depthBufferWidth===width&&this._depthBufferHeight===height)return;if(this._canSampleDepth){if(this._depthBuffer)gl.deleteTexture(this._depthBuffer);this._depthBuffer=gl.createTexture();gl.bindTexture(gl.TEXTURE_2D,this._depthBuffer);gl.texParameteri(gl.TEXTURE_2D,
gl.TEXTURE_MAG_FILTER,gl.NEAREST);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.NEAREST);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE);if(this.GetWebGLVersionNumber()>=2)gl.texImage2D(gl.TEXTURE_2D,0,gl.DEPTH24_STENCIL8,width,height,0,gl.DEPTH_STENCIL,gl.UNSIGNED_INT_24_8,null);else if(this._depthTextureExt)gl.texImage2D(gl.TEXTURE_2D,0,gl.DEPTH_STENCIL,width,height,0,gl.DEPTH_STENCIL,this._depthTextureExt["UNSIGNED_INT_24_8_WEBGL"],
null);else;gl.bindTexture(gl.TEXTURE_2D,null)}else{if(this._depthBuffer)gl.deleteRenderbuffer(this._depthBuffer);this._depthBuffer=gl.createRenderbuffer();gl.bindRenderbuffer(gl.RENDERBUFFER,this._depthBuffer);gl.renderbufferStorage(gl.RENDERBUFFER,this._version>=2?gl.DEPTH24_STENCIL8:gl.DEPTH_STENCIL,width,height);gl.bindRenderbuffer(gl.RENDERBUFFER,null)}this._depthBufferWidth=width;this._depthBufferHeight=height}SetFixedSizeDepthBuffer(width,height){if(!this._usesDepthBuffer)return;this._isAutoSizeDepthBuffer=
false;this._SetDepthBufferSize(width,height)}SetAutoSizeDepthBuffer(){if(!this._usesDepthBuffer)return;this._isAutoSizeDepthBuffer=true;this._SetDepthBufferSize(this._width,this._height)}_SetViewport(x,y,w,h){const viewport=this._viewport;if(viewport[0]===x&&viewport[1]===y&&viewport[2]===w&&viewport[3]===h)return;const b=this.PushBatch();b.InitSetViewport(x,y,w,h);vec4.set(viewport,x,y,w,h);this._topOfBatch=0}SetFovY(f){super.SetFovY(f);this.CalculatePerspectiveMatrix(this._bbProjectionMatrix,this._width/
this._height)}SetNearZ(z){super.SetNearZ(z);this.CalculatePerspectiveMatrix(this._bbProjectionMatrix,this._width/this._height)}SetFarZ(z){super.SetFarZ(z);this.CalculatePerspectiveMatrix(this._bbProjectionMatrix,this._width/this._height)}SetProjectionMatrix(matP){if(mat4.exactEquals(this._matP,matP))return;const b=this.PushBatch();b.InitSetProjection(matP);mat4.copy(this._matP,matP);this._topOfBatch=0;this._didChangeTransform=true}SetDefaultRenderTargetProjectionState(){let projectionMatrix;let viewportWidth,
viewportHeight;const currentRenderTarget=this._currentRenderTarget;if(currentRenderTarget===null){projectionMatrix=this._bbProjectionMatrix;viewportWidth=this.GetWidth();viewportHeight=this.GetHeight()}else{projectionMatrix=currentRenderTarget.GetProjectionMatrix();viewportWidth=currentRenderTarget.GetWidth();viewportHeight=currentRenderTarget.GetHeight()}this.SetProjectionMatrix(projectionMatrix);this._SetViewport(0,0,viewportWidth,viewportHeight)}SetModelViewMatrix(matMV){if(mat4.exactEquals(this._matMV,
matMV))return;const b=this.PushBatch();b.InitSetModelView(matMV);mat4.copy(this._matMV,matMV);this._topOfBatch=0;this._didChangeTransform=true}ResetDidChangeTransformFlag(){this._didChangeTransform=false}DidChangeTransform(){return this._didChangeTransform}GetBatchState(){return this._batchState}PushBatch(){const batch=this._batch;if(this._batchPtr===batch.length)batch.push(new C3.Gfx.WebGLBatchJob(this._batchState));return batch[this._batchPtr++]}EndBatch(){if(this._batchPtr===0)return;if(this.IsContextLost())return;
this._WriteBuffers();this._ExecuteBatch();this._batchPtr=0;this._vertexPtr=0;this._texPtr=0;this._pointPtr=0;this._topOfBatch=0}_WriteBuffers(){const gl=this._gl;if(this._pointPtr>0){gl.bindBuffer(gl.ARRAY_BUFFER,this._pointBuffer);gl.bufferSubData(gl.ARRAY_BUFFER,0,this._pointData.subarray(0,this._pointPtr))}if(this._vertexPtr>0){gl.bindBuffer(gl.ARRAY_BUFFER,this._vertexBuffer);gl.bufferSubData(gl.ARRAY_BUFFER,0,this._vertexData.subarray(0,this._vertexPtr));gl.bindBuffer(gl.ARRAY_BUFFER,this._texcoordBuffer);
gl.bufferSubData(gl.ARRAY_BUFFER,0,this._texcoordData.subarray(0,this._texPtr))}}_ExecuteBatch(){const batch=this._batch;for(let i=0,len=this._batchPtr;i<len;++i)batch[i].Run()}GetOpacity(){return this._lastColor.getA()}SetColorRgba(r,g,b,a){const lastColor=this._lastColor;if(lastColor.equalsRgba(r,g,b,a))return;lastColor.setRgba(r,g,b,a);const batch=this.PushBatch();batch.InitSetColor(lastColor);this._topOfBatch=0;this._currentStateGroup=null}SetOpacity(a){const lastColor=this._lastColor;if(lastColor.getA()===
a)return;lastColor.setA(a);const batch=this.PushBatch();batch.InitSetColor(lastColor);this._topOfBatch=0;this._currentStateGroup=null}SetColor(c){const lastColor=this._lastColor;if(lastColor.equals(c))return;lastColor.set(c);const batch=this.PushBatch();batch.InitSetColor(lastColor);this._topOfBatch=0;this._currentStateGroup=null}ResetColor(){this.SetColorRgba(1,1,1,1)}GetColor(){return this._lastColor}SetTexture(rendererTex){if(rendererTex===this._lastTexture0)return;const b=this.PushBatch();b.InitSetTexture(rendererTex);
this._lastTexture0=rendererTex;this._topOfBatch=0}_ResetLastTexture(){this._lastTexture0=null}SetBlendMode(bm){const arr=this._GetBlendByIndex(bm);this._SetBlend(arr[0],arr[1])}SetNamedBlendMode(bm){const o=this.GetNamedBlend(bm);this._SetBlend(o.srcBlend,o.destBlend)}_SetBlend(s,d){if(s===this._lastSrcBlend&&d===this._lastDestBlend)return;const b=this.PushBatch();b.InitSetBlend(s,d);this._lastSrcBlend=s;this._lastDestBlend=d;this._topOfBatch=0;this._currentStateGroup=null}IsPremultipliedAlphaBlend(){return this._lastSrcBlend===
this._gl.ONE&&this._lastDestBlend===this._gl.ONE_MINUS_SRC_ALPHA}SetAlphaBlend(){this._SetBlend(this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA)}SetNoPremultiplyAlphaBlend(){this._SetBlend(this._gl.SRC_ALPHA,this._gl.ONE_MINUS_SRC_ALPHA)}SetCopyBlend(){this._SetBlend(this._gl.ONE,this._gl.ZERO)}Rect(r){this.Rect2(r.getLeft(),r.getTop(),r.getRight(),r.getBottom())}Rect2(left,top,right,bottom){this.Quad2(left,top,right,top,right,bottom,left,bottom)}_ExtendQuadBatch(){let v=this._vertexPtr;if(v>=this._lastVertexPtr){this.EndBatch();
v=0}if(this._topOfBatch===1)this._batch[this._batchPtr-1]._indexCount+=6;else{const b=this.PushBatch();b.InitQuad(v,6);this._topOfBatch=1}}_WriteQuadToVertexBuffer(quad){quad.writeToTypedArray3D(this._vertexData,this._vertexPtr,this._baseZ+this._currentZ);this._vertexPtr+=12}Quad(quad){this._ExtendQuadBatch();this._WriteQuadToVertexBuffer(quad);defaultTexCoordsQuad.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad2(tlx,tly,trx,try_,brx,bry,blx,bly){this._ExtendQuadBatch();const vd=
this._vertexData;let v=this._vertexPtr;const z=this._baseZ+this._currentZ;vd[v++]=tlx;vd[v++]=tly;vd[v++]=z;vd[v++]=trx;vd[v++]=try_;vd[v++]=z;vd[v++]=brx;vd[v++]=bry;vd[v++]=z;vd[v++]=blx;vd[v++]=bly;vd[v++]=z;this._vertexPtr=v;defaultTexCoordsQuad.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad3(quad,rcTex){this._ExtendQuadBatch();this._WriteQuadToVertexBuffer(quad);rcTex.writeAsQuadToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad4(quad,uv){this._ExtendQuadBatch();
this._WriteQuadToVertexBuffer(quad);uv.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad3D(tlx,tly,tlz,trx,try_,trz,brx,bry,brz,blx,bly,blz,rcTex){this._ExtendQuadBatch();const vd=this._vertexData;let v=this._vertexPtr;const z=this._baseZ+this._currentZ;vd[v++]=tlx;vd[v++]=tly;vd[v++]=z+tlz;vd[v++]=trx;vd[v++]=try_;vd[v++]=z+trz;vd[v++]=brx;vd[v++]=bry;vd[v++]=z+brz;vd[v++]=blx;vd[v++]=bly;vd[v++]=z+blz;this._vertexPtr=v;rcTex.writeAsQuadToTypedArray(this._texcoordData,this._texPtr);
this._texPtr+=8}Quad3D2(tlx,tly,tlz,trx,try_,trz,brx,bry,brz,blx,bly,blz,uv){this._ExtendQuadBatch();const vd=this._vertexData;let v=this._vertexPtr;const z=this._baseZ+this._currentZ;vd[v++]=tlx;vd[v++]=tly;vd[v++]=z+tlz;vd[v++]=trx;vd[v++]=try_;vd[v++]=z+trz;vd[v++]=brx;vd[v++]=bry;vd[v++]=z+brz;vd[v++]=blx;vd[v++]=bly;vd[v++]=z+blz;this._vertexPtr=v;uv.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}FullscreenQuad(mode,curTex){mat4.copy(tmpProjection,this._matP);mat4.copy(tmpModelView,
this._matMV);this.SetDefaultRenderTargetProjectionState();const [width,height]=this.GetRenderTargetSize(this._currentRenderTarget);const tempMat4b=this.CalculateLookAtModelView2(0,0,this.GetDefaultCameraZ(height),0,0,0,height);this.SetModelViewMatrix(tempMat4b);if(mode==="crop"&&this._currentRenderTarget&&curTex){const left=this._width/2;const top=this._height/2;const srcW=curTex.GetWidth();const srcH=curTex.GetHeight();const destW=this._currentRenderTarget.GetWidth();const destH=this._currentRenderTarget.GetHeight();
const copyW=Math.min(destW,srcW);const copyH=Math.min(destH,srcH);const srcOffY=Math.max(srcH-destH,0);const destOffY=Math.max(destH-srcH,0);tmpRect.set(-left,top-destOffY,-left+copyW,top-copyH-destOffY);tmpQuad.setFromRect(tmpRect);tmpRect.set(0,srcOffY,copyW,copyH+srcOffY);tmpRect.divide(srcW,srcH);this.Quad3(tmpQuad,tmpRect)}else{const halfW=width/2;const halfH=height/2;this.Rect2(-halfW,halfH,halfW,-halfH)}this.SetProjectionMatrix(tmpProjection);this.SetModelViewMatrix(tmpModelView)}StartRenderingPoints(rect){if(this._lastPointTexCoords.equals(rect))return;
this._lastPointTexCoords.copy(rect);const b=this.PushBatch();b.InitSetPointTexCoords(rect);this._topOfBatch=0}FinishRenderingPoints(){}Point(x_,y_,size_,opacity_){if(this._pointPtr>=LAST_POINT)this.EndBatch();let p=this._pointPtr;const z=this._baseZ+this._currentZ;if(this._topOfBatch===2&&this._lastPointZ===z)this._batch[this._batchPtr-1]._indexCount++;else{const b=this.PushBatch();b.InitPoints(p,z);this._topOfBatch=2;this._lastPointZ=z}const pd=this._pointData;pd[p++]=x_;pd[p++]=y_;pd[p++]=size_;
pd[p++]=opacity_;this._pointPtr=p}SetProgram(program){if(this._lastProgram===program)return;const b=this.PushBatch();b.InitSetProgram(program);this._lastProgram=program;this._topOfBatch=0;this._currentStateGroup=null}SetDeviceTransformTextureFillMode(){this.SetProgram(this._spDeviceTransformTextureFill)}SetGradientColor(c){const b=this.PushBatch();b.InitSetGradientColor(c);this._topOfBatch=0}SetEllipseParams(pixelW,pixelH,outlineThickness=1){const b=this.PushBatch();b.InitSetEllipseParams(pixelW,
pixelH,outlineThickness);this._topOfBatch=0}SetTilemapInfo(srcRect,textureWidth,textureHeight,tileWidth,tileHeight,tileSpacingX,tileSpacingY){if(this._lastProgram!==this._spTilemapFill)throw new Error("must set tilemap fill mode first");const b=this.PushBatch();b.InitSetTilemapInfo(srcRect,textureWidth,textureHeight,tileWidth,tileHeight,tileSpacingX,tileSpacingY);this._topOfBatch=0}SetTileRandomizationInfo(textureWidth,textureHeight,xRandom,yRandom,angleRandom,blendMarginX,blendMarginY){if(this._lastProgram!==
this._spTileRandomization)throw new Error("must set tile randomization mode first");const b=this.PushBatch();b.InitSetTileRandomizationInfo(textureWidth,textureHeight,xRandom,yRandom,angleRandom,blendMarginX,blendMarginY);this._topOfBatch=0}SetProgramParameters(backTex,destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,dpr,layerScale,layerAngle,time){const s=this._lastProgram;time=time%10800;if(!s._hasAnyOptionalUniforms||s.AreOptionalUniformsAlreadySetInBatch(destRect,srcRect,srcOriginRect,
layoutRect,pixelWidth,pixelHeight,dpr,layerScale,layerAngle,time))return;const b=this.PushBatch();b.InitSetProgramParameters();s.SetOptionalUniformsInBatch(destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,dpr,layerScale,layerAngle,time);const mat4param=b._mat4param;mat4param[0]=pixelWidth;mat4param[1]=pixelHeight;destRect.writeToTypedArray(mat4param,2);mat4param[6]=layerScale;mat4param[7]=layerAngle;srcRect.writeToTypedArray(mat4param,12);const colorParam=b._colorParam;layoutRect.writeToTypedArray(colorParam,
0);const tmp=colorParam[1];colorParam[1]=colorParam[3];colorParam[3]=tmp;srcOriginRect.writeToTypedArray(b._srcOriginRect,0);b._startIndex=time;b._indexCount=dpr;if(s._uSamplerBack.IsUsed())b._texParam=backTex?backTex.GetTexture():null;else b._texParam=null;this._topOfBatch=0}SetProgramCustomParameters(params){const s=this._lastProgram;if(params.length===0||s.AreCustomParametersAlreadySetInBatch(params))return;const b=this.PushBatch();b.InitSetProgramCustomParameters();s.SetCustomParametersInBatch(params);
C3.shallowAssignArray(b._shaderParams,params);this._topOfBatch=0}ClearRgba(r,g,b_,a){const b=this.PushBatch();b.InitClearSurface2(r,g,b_,a);this._topOfBatch=0}Clear(c){const b=this.PushBatch();b.InitClearSurface(c);this._topOfBatch=0}Start(){}Finish(){super.Finish();this._gl.flush()}ClearDepth(){if(!this._usesDepthBuffer||!this._currentRenderTarget||!this._currentRenderTarget.HasDepthBuffer())return;const batch=this.PushBatch();batch.InitClearDepth(this._isDepthEnabled);this._topOfBatch=0}SetDepthEnabled(e){e=
!!e;if(this._isDepthEnabled===e)return;if(!this._usesDepthBuffer)return;this._isDepthEnabled=e;const batch=this.PushBatch();batch.InitSetDepthEnabled(e);this._topOfBatch=0}IsDepthEnabled(){return this._isDepthEnabled}_GetDepthBuffer(){return this._depthBuffer}_CanSampleDepth(){return this._canSampleDepth}SetDepthSamplingEnabled(e){e=!!e;if(!this._canSampleDepth)return;if(this._isDepthSamplingEnabled===e)return;if(e&&this.IsDepthEnabled())throw new Error("depth still enabled");this._isDepthSamplingEnabled=
e;const batch=this.PushBatch();batch.InitSetDepthSamplingEnabled(e);this._topOfBatch=0}SetScissorRect(x,y,w,h,rtHeight_=0){x=Math.floor(x);y=Math.floor(y);w=Math.floor(w);h=Math.floor(h);if(this._lastScissorRect.equalsWH(x,y,w,h))return;this._lastScissorRect.setWH(x,y,w,h);const rtHeight=rtHeight_||this.GetRenderTargetSize(this.GetRenderTarget())[1];y=rtHeight-y-h;const batch=this.PushBatch();batch.InitSetScissor(true,x,y,w,h);this._topOfBatch=0}RemoveScissorRect(){if(this._lastScissorRect.getRight()===
-1)return;this._lastScissorRect.set(0,0,-1,-1);const batch=this.PushBatch();batch.InitSetScissor(false,0,0,0,0);this._topOfBatch=0}CheckForQueryResults(){for(const qrb of this._allQueryResultBuffers)qrb.CheckForResults(this._frameNumber)}IsContextLost(){return!this._gl||this._gl.isContextLost()||this._isInitialisingAfterContextRestored}OnContextLost(){super.OnDeviceOrContextLost();C3.Gfx.WebGLRendererTexture.OnContextLost();C3.Gfx.WebGLRenderTarget.OnContextLost();C3.Gfx.RendererText.OnContextLost();
for(const qrb of this._allQueryResultBuffers)qrb.Clear();this._extensions=[];this._timerExt=null;this._parallelShaderCompileExt=null;this._anisotropicExt=null;this._depthTextureExt=null;this._fragDepthExt=null;this._stdDerivativesExt=null;this._textureLodExt=null;this._maxAnisotropy=0;this._unmaskedVendor="(unavailable)";this._unmaskedRenderer="(unavailable)";this._lastProgram=null;this._spDeviceTransformTextureFill=null;this._depthBuffer=null;for(const stateGroup of this._stateGroups.values())stateGroup.OnContextLost()}async OnContextRestored(){this._isInitialisingAfterContextRestored=
true;await this.InitState();this._isInitialisingAfterContextRestored=false;for(const stateGroup of this._stateGroups.values())stateGroup.OnContextRestored(this);this.SetSize(this._width,this._height,true)}CreateStaticTexture(data,opts){if(this.IsContextLost())throw new Error("context lost");this.EndBatch();const rendererTex=C3.New(C3.Gfx.WebGLRendererTexture,this);rendererTex._CreateStatic(data,opts);return rendererTex}async CreateStaticTextureAsync(data,opts){if(this.IsContextLost())throw new Error("context lost");
opts=Object.assign({},opts);if(C3.Supports.ImageBitmapOptions&&(C3.Platform.Browser!=="Safari"||!(data instanceof ImageData)||typeof Image==="undefined")){let imageBitmap=await createImageBitmap(data,{"premultiplyAlpha":"premultiply"});const isTiled=opts.wrapX&&opts.wrapX!=="clamp-to-edge"||opts.wrapY&&opts.wrapY!=="clamp-to-edge";const isPOT=C3.isPOT(imageBitmap.width)&&C3.isPOT(imageBitmap.height);if(!this.SupportsNPOTTextures()&&!isPOT&&isTiled)if(C3.Supports.ImageBitmapOptionsResize){imageBitmap=
await createImageBitmap(data,{"premultiplyAlpha":"premultiply","resizeWidth":C3.nextHighestPowerOfTwo(imageBitmap.width),"resizeHeight":C3.nextHighestPowerOfTwo(imageBitmap.height)});opts.premultiplyAlpha=false}else imageBitmap=await createImageBitmap(data,{"premultiplyAlpha":"none"});else opts.premultiplyAlpha=false;return await C3.Asyncify(()=>this.CreateStaticTexture(imageBitmap,opts))}else{if(data instanceof Blob){if(typeof Image==="undefined")throw new Error("texture upload variant not supported in worker");
const img=await C3.BlobToImage(data);data=img}return await C3.Asyncify(()=>this.CreateStaticTexture(data,opts))}}CreateDynamicTexture(width,height,opts){this.EndBatch();const rendererTex=C3.New(C3.Gfx.WebGLRendererTexture,this);rendererTex._CreateDynamic(width,height,opts);return rendererTex}UpdateTexture(data,rendererTex,opts){this.EndBatch();rendererTex._Update(data,opts)}DeleteTexture(rendererTex){if(!rendererTex)return;rendererTex.SubtractReference();if(rendererTex.GetReferenceCount()>0)return;
this.EndBatch();if(rendererTex===this._lastTexture0){this._gl.bindTexture(this._gl.TEXTURE_2D,null);this._lastTexture0=null}if(rendererTex===this._lastTexture1){this._gl.activeTexture(this._gl.TEXTURE1);this._gl.bindTexture(this._gl.TEXTURE_2D,null);this._gl.activeTexture(this._gl.TEXTURE0);this._lastTexture1=null}rendererTex._Delete()}CreateRenderTarget(opts){let width=this._width;let height=this._height;let isDefaultSize=true;if(opts){if(typeof opts.width==="number"){width=opts.width;isDefaultSize=
false}if(typeof opts.height==="number"){height=opts.height;isDefaultSize=false}}if(width<=0||height<=0)throw new Error("invalid size");this.EndBatch();const renderTarget=C3.New(C3.Gfx.WebGLRenderTarget,this);renderTarget._Create(width,height,Object.assign({isDefaultSize},opts));this._currentRenderTarget=null;this._batchState.currentFramebuffer=null;this._batchState.currentFramebufferNoDepth=null;return renderTarget}SetRenderTarget(renderTarget,updateProjection=true){if(renderTarget===this._currentRenderTarget)return;
if(renderTarget&&renderTarget.IsDefaultSize())renderTarget._Resize(this._width,this._height);const b=this.PushBatch();b.InitSetRenderTarget(renderTarget);this._currentRenderTarget=renderTarget;this._topOfBatch=0;if(updateProjection)this.SetDefaultRenderTargetProjectionState()}GetRenderTarget(){return this._currentRenderTarget}GetRenderTargetSize(renderTarget){if(renderTarget)return[renderTarget.GetWidth(),renderTarget.GetHeight()];else return[this._width,this._height]}CopyRenderTarget(renderTarget,
mode="stretch"){if(this._version<2||this._currentRenderTarget&&this._currentRenderTarget.GetMultisampling()>0){this.SetCopyBlend();this.ResetColor();this.DrawRenderTarget(renderTarget,mode)}else{const b=this.PushBatch();b.InitBlitFramebuffer(renderTarget,this._currentRenderTarget,mode);this._topOfBatch=0}}DrawRenderTarget(renderTarget,mode="stretch"){const tex=renderTarget.GetTexture();if(!tex)throw new Error("not a texture-backed render target");this.SetTexture(tex);this.FullscreenQuad(mode,tex)}InvalidateRenderTarget(renderTarget){if(this._version<
2)return;const b=this.PushBatch();b.InitInvalidateFramebuffer(renderTarget._GetFramebuffer());this._topOfBatch=0}DeleteRenderTarget(renderTarget){this.SetRenderTarget(null);this.EndBatch();const renderTex=renderTarget.GetTexture();if(renderTex===this._lastTexture0){this._gl.bindTexture(this._gl.TEXTURE_2D,null);this._lastTexture0=null}if(renderTex===this._lastTexture1){this._gl.activeTexture(this._gl.TEXTURE1);this._gl.bindTexture(this._gl.TEXTURE_2D,null);this._gl.activeTexture(this._gl.TEXTURE0);
this._lastTexture1=null}renderTarget._Delete()}async ReadBackRenderTargetToImageData(renderTarget,forceSynchronous,areaRect){this.EndBatch();const oldRenderTarget=this._currentRenderTarget;let width,height,framebuffer;if(renderTarget){width=renderTarget.GetWidth();height=renderTarget.GetHeight();framebuffer=renderTarget._GetFramebuffer()}else{width=this.GetWidth();height=this.GetHeight();framebuffer=null}let x=0;let y=0;let areaWidth=width;let areaHeight=height;if(areaRect){x=C3.clamp(Math.floor(areaRect.getLeft()),
0,width-1);y=C3.clamp(Math.floor(areaRect.getTop()),0,height-1);let w=areaRect.width();if(w===0)w=width-x;else w=C3.clamp(Math.floor(w),0,width-x);let h=areaRect.height();if(h===0)h=height-y;else h=C3.clamp(Math.floor(h),0,height-y);areaWidth=w;areaHeight=h;y=height-(y+areaHeight)}const gl=this._gl;gl.bindFramebuffer(gl.FRAMEBUFFER,framebuffer);const restorePreviousRenderTarget=()=>{gl.bindFramebuffer(gl.FRAMEBUFFER,null);this._currentRenderTarget=null;this._batchState.currentFramebuffer=null;this._batchState.currentFramebufferNoDepth=
null;this.SetRenderTarget(oldRenderTarget)};let imageData;if(!forceSynchronous&&this.GetWebGLVersionNumber()>=2){gl.bindFramebuffer(gl.READ_FRAMEBUFFER,framebuffer);const pixelBuffer=gl.createBuffer();const bufferSize=areaWidth*areaHeight*4;const PIXEL_PACK_BUFFER=gl["PIXEL_PACK_BUFFER"];gl.bindBuffer(PIXEL_PACK_BUFFER,pixelBuffer);gl.bufferData(PIXEL_PACK_BUFFER,bufferSize,gl["STREAM_READ"]);gl.readPixels(x,y,areaWidth,areaHeight,gl.RGBA,gl.UNSIGNED_BYTE,0);gl.bindFramebuffer(gl.READ_FRAMEBUFFER,
null);gl.bindBuffer(PIXEL_PACK_BUFFER,null);restorePreviousRenderTarget();const sync=gl["fenceSync"](gl["SYNC_GPU_COMMANDS_COMPLETE"],0);await this._WaitForObjectReady(()=>gl["getSyncParameter"](sync,gl["SYNC_STATUS"])===gl["SIGNALED"]);gl["deleteSync"](sync);imageData=new ImageData(areaWidth,areaHeight);gl.bindBuffer(PIXEL_PACK_BUFFER,pixelBuffer);gl["getBufferSubData"](PIXEL_PACK_BUFFER,0,new Uint8Array(imageData.data.buffer),0,bufferSize);gl.bindBuffer(PIXEL_PACK_BUFFER,null);gl.deleteBuffer(pixelBuffer)}else{imageData=
new ImageData(areaWidth,areaHeight);gl.readPixels(x,y,areaWidth,areaHeight,gl.RGBA,gl.UNSIGNED_BYTE,new Uint8Array(imageData.data.buffer));restorePreviousRenderTarget()}return imageData}CoplanarStartStencilPass(){this.SetDepthEnabled(true);const batch=this.PushBatch();batch.InitCoplanarStartStencilPass();this._topOfBatch=0}CoplanarStartColorPass(){this.SetDepthEnabled(false);const batch=this.PushBatch();batch.InitCoplanarStartColorPass();this._topOfBatch=0}CoplanarRestoreStandardRendering(){this.SetDepthEnabled(true);
const batch=this.PushBatch();batch.InitCoplanarRestore();this._topOfBatch=0}StartQuery(query){if(!this.SupportsGPUProfiling())return;const b=this.PushBatch();b.InitStartQuery(query);this._topOfBatch=0}EndQuery(query){if(!this.SupportsGPUProfiling())return;const b=this.PushBatch();b.InitEndQuery(query);this._topOfBatch=0}_WaitForObjectReady(checkFunc){const ret=new Promise(resolve=>pendingPolls.add({resolve,checkFunc}));if(pollRafId===-1)pollRafId=self.requestAnimationFrame(CheckPendingPolls);return ret}IsDesynchronized(){return!!this._attribs["desynchronized"]}GetEstimatedBackBufferMemoryUsage(){return this._width*
this._height*(this._attribs["alpha"]?4:3)}GetEstimatedRenderBufferMemoryUsage(){let ret=0;for(const t of C3.Gfx.WebGLRenderTarget.allRenderTargets()){if(t.GetTexture())continue;ret+=t.GetEstimatedMemoryUsage()}return ret}GetEstimatedTextureMemoryUsage(){let ret=0;for(const t of C3.Gfx.WebGLRendererTexture.allTextures())ret+=t.GetEstimatedMemoryUsage();return ret}GetEstimatedTotalMemoryUsage(){return this.GetEstimatedBackBufferMemoryUsage()+this.GetEstimatedRenderBufferMemoryUsage()+this.GetEstimatedTextureMemoryUsage()}GetWebGLVersionString(){return this._versionString}GetWebGLVersionNumber(){return this._version}GetDisplayName(){return"webgl"+
this.GetWebGLVersionNumber()}SupportsNPOTTextures(){return this.GetWebGLVersionNumber()>=2}GetMaxTextureSize(){return this._maxTextureSize}GetMinPointSize(){return this._minPointSize}GetMaxPointSize(){return this._maxPointSize}SupportsHighP(){return this._highpPrecision!==0}GetHighPPrecision(){return this._highpPrecision}GetUnmaskedVendor(){return this._unmaskedVendor}GetUnmaskedRenderer(){return this._unmaskedRenderer}GetWebGLExtensionsAnalyticsString(){if(this.GetWebGLVersionNumber()>=2)return"webgl2";
else{const exts=[];if(this._fragDepthExt)exts.push("EXT_frag_depth");if(this._stdDerivativesExt)exts.push("OES_standard_derivatives");if(this._textureLodExt)exts.push("EXT_shader_texture_lod");if(exts.length>0)return"webgl1:"+exts.join(",");else return"webgl1:none"}}GetExtensions(){return this._extensions}SupportsGPUProfiling(){return!!this._timerExt}_GetDisjointTimerQueryExtension(){return this._timerExt}_GetParallelShaderCompileExtension(){return this._parallelShaderCompileExt}_GetAnisotropicExtension(){return this._anisotropicExt}_GetMaxAnisotropy(){return this._maxAnisotropy}_AddQueryResultBuffer(qrb){this._allQueryResultBuffers.add(qrb)}_RemoveQueryResultBuffer(qrb){this._allQueryResultBuffers.delete(qrb)}_GetTimeQueryStack(){return this._timeQueryStack}GetContext(){return this._gl}_InitBlendModes(gl){this._InitBlendModeData([["normal",
gl.ONE,gl.ONE_MINUS_SRC_ALPHA],["additive",gl.ONE,gl.ONE],["xor",gl.ONE,gl.ONE_MINUS_SRC_ALPHA],["copy",gl.ONE,gl.ZERO],["destination-over",gl.ONE_MINUS_DST_ALPHA,gl.ONE],["source-in",gl.DST_ALPHA,gl.ZERO],["destination-in",gl.ZERO,gl.SRC_ALPHA],["source-out",gl.ONE_MINUS_DST_ALPHA,gl.ZERO],["destination-out",gl.ZERO,gl.ONE_MINUS_SRC_ALPHA],["source-atop",gl.DST_ALPHA,gl.ONE_MINUS_SRC_ALPHA],["destination-atop",gl.ONE_MINUS_DST_ALPHA,gl.SRC_ALPHA]])}CreateRendererText(){return C3.New(C3.Gfx.RendererText,
this)}CreateWebGLText(){return this.CreateRendererText()}};

}

// ../lib/gfx/effectCompositor/effectChainManager.js
{
'use strict';const C3=self.C3;const DEFAULT_CTOR_OPTS={getDrawSize:null,getRenderTarget:null,releaseRenderTarget:null,getTime:null,redraw:null};
C3.Gfx.EffectChainManager=class EffectChainManager{constructor(opts){opts=Object.assign({},DEFAULT_CTOR_OPTS,opts);this._cbGetDrawSize=opts.getDrawSize;this._cbGetRenderTarget=opts.getRenderTarget;this._cbReleaseRenderTarget=opts.releaseRenderTarget;this._cbGetTime=opts.getTime;this._cbRedraw=opts.redraw;this._webgpuBackTexture=null;this._allEffectChains=new Set}_AddEffectChain(ec){this._allEffectChains.add(ec)}_RemoveEffectChain(ec){this._allEffectChains.delete(ec)}OnContextLost(){this._webgpuBackTexture=
null;for(const ec of this._allEffectChains)ec.OnContextLost()}GetDrawSize(renderer){if(this._cbGetDrawSize)return this._cbGetDrawSize(renderer);else return[renderer.GetWidth(),renderer.GetHeight()]}GetRenderTarget(effectChain){return this._cbGetRenderTarget(effectChain)}ReleaseRenderTarget(rt,effectChain){this._cbReleaseRenderTarget(rt,effectChain)}GetTime(){return this._cbGetTime()}Redraw(effectChain){this._cbRedraw(effectChain)}_GetWebGPUBackTexture(renderer,width,height){if(this._webgpuBackTexture&&
(this._webgpuBackTexture.GetWidth()!==width||this._webgpuBackTexture.GetHeight()!==height)){renderer.DeleteTexture(this._webgpuBackTexture);this._webgpuBackTexture=null}if(this._webgpuBackTexture===null)this._webgpuBackTexture=renderer.CreateStaticTexture(null,{width,height,sampling:"nearest",mipMap:false});return this._webgpuBackTexture}};

}

// ../lib/gfx/effectCompositor/effectChain.js
{
'use strict';const C3=self.C3;const assert=self.assert;const glMatrix=self.glMatrix;const mat4=glMatrix.mat4;const tempRect=C3.New(C3.Rect);const tempRect2=C3.New(C3.Rect);const tempRect3=C3.New(C3.Rect);const tempRect4=C3.New(C3.Rect);const tempMat4a=mat4.create();const tempMat4b=mat4.create();const DEFAULT_CTOR_OPTS={drawContent:null,getSourceTextureInfo:null,getShaderParameters:null,invalidateRenderTargets:false};
const DEFAULT_BUILDSTEPS_OPTS={indexMap:null,forcePreDraw:false,forcePostDraw:false,is3D:false,isSourceTextureRotated:false,isRotatedOrNegativeSizeInstance:false,useFullSurface:false};
C3.Gfx.EffectChain=class EffectChain{constructor(manager,opts){opts=Object.assign({},DEFAULT_CTOR_OPTS,opts);this._manager=manager;this._cbDrawContent=opts.drawContent;this._cbGetSourceTextureInfo=opts.getSourceTextureInfo;this._cbGetShaderParameters=opts.getShaderParameters;this._cbDrawContentHook=null;this._shaderProgramList=[];this._shaderProgramIndices=[];this._steps=[];this._needsRebuild=false;this._blendMode=0;this._isAnyShaderAnimated=false;this._isAnyShaderDepthSampling=false;this._isAnyShaderBackgroundBlending=
false;this._isAnyShaderCrossSampling=false;this._isAnyIsSrcTexRotated=false;this._useCopyTextureBackgroundSampling=false;this._didChangeTransform=false;this._depthEnabledAtStart=false;this._canUseFastPath=false;this._useFullSurface=false;this._isSourceTextureRotated=false;this._numTempSurfacesRequired=0;this._renderTargets=[null,null,null];this._invalidateRenderTargets=!!opts.invalidateRenderTargets;this._boxExtendHorizontal=0;this._boxExtendVertical=0;this._drawWidth=0;this._drawHeight=0;this._contentObject=
null;this._contextObject=null;this._layoutRect=C3.New(C3.Rect);this._drawSurfaceRect=C3.New(C3.Rect);this._rcTexOriginal=C3.New(C3.Rect);this._rcTexBounce=C3.New(C3.Rect);this._rcTexDest=C3.New(C3.Rect);this._devicePixelRatio=1;this._layerScale=1;this._layerAngle=0;this._time=0;this._destRenderTarget=null;this._backTex=null;this._compositOffX=0;this._compositOffY=0;this._updateOwnProjection=false;this._projectionMatrix=mat4.create();this._modelViewMatrix=mat4.create();this._manager._AddEffectChain(this)}Release(){this._manager._RemoveEffectChain(this);
C3.clearArray(this._steps);C3.clearArray(this._shaderProgramList);C3.clearArray(this._shaderProgramIndices);this._contentObject=null;this._contextObject=null;this._cbDrawContent=null;this._cbGetSourceTextureInfo=null;this._cbGetShaderParameters=null}OnContextLost(){this._needsRebuild=true;C3.clearArray(this._steps);C3.clearArray(this._shaderProgramList);C3.clearArray(this._shaderProgramIndices)}NeedsRebuild(){return this._needsRebuild}BuildSteps(shaderProgramList,opts){opts=Object.assign({},DEFAULT_BUILDSTEPS_OPTS,
opts);C3.clearArray(this._steps);this._boxExtendHorizontal=0;this._boxExtendVertical=0;this._isAnyShaderAnimated=false;this._isAnyShaderDepthSampling=false;this._isAnyShaderBackgroundBlending=false;this._isAnyShaderCrossSampling=false;this._isAnyIsSrcTexRotated=false;this._useCopyTextureBackgroundSampling=false;this._numTempSurfacesRequired=0;this._isSourceTextureRotated=!!opts.isSourceTextureRotated;this._useFullSurface=!!opts.useFullSurface;this._needsRebuild=false;C3.shallowAssignArray(this._shaderProgramList,
shaderProgramList);if(shaderProgramList.length===0)return;if(opts.indexMap){if(opts.indexMap.length!==shaderProgramList.length)throw new Error("incorrect indexMap length");C3.shallowAssignArray(this._shaderProgramIndices,opts.indexMap)}else{C3.clearArray(this._shaderProgramIndices);for(let i=0,len=shaderProgramList.length;i<len;++i)this._shaderProgramIndices.push(i)}for(const s of shaderProgramList){this._boxExtendHorizontal+=s.GetBoxExtendHorizontal();this._boxExtendVertical+=s.GetBoxExtendVertical();
if(s.IsAnimated())this._isAnyShaderAnimated=true;if(s.UsesDepth())this._isAnyShaderDepthSampling=true;if(s.BlendsBackground())this._isAnyShaderBackgroundBlending=true;if(s.UsesCrossSampling())this._isAnyShaderCrossSampling=true;if(s.UsesIsSrcTexRotated())this._isAnyIsSrcTexRotated=true}this._useCopyTextureBackgroundSampling=this._ShouldUseCopyTextureBackgroundSampling(shaderProgramList[0].GetRenderer());const doPreDraw=this._ShouldPreDraw(shaderProgramList[0],opts);const doPostDraw=this._ShouldPostDraw(shaderProgramList.at(-1),
opts);if(shaderProgramList.length===1&&!doPreDraw&&!doPostDraw){this._canUseFastPath=true;return}this._canUseFastPath=false;let lastTargetId=0;if(doPreDraw){this._numTempSurfacesRequired=1;this._steps.push(C3.New(C3.Gfx.EffectChain.Step.PreDraw,this,-1,1));lastTargetId=1}for(let i=0,len=shaderProgramList.length;i<len;++i)if(i===0&&!doPreDraw){this._numTempSurfacesRequired=1;this._steps.push(C3.New(C3.Gfx.EffectChain.Step.FirstBounce,this,-1,1,i));lastTargetId=1}else{let nextTargetId=lastTargetId===
1?2:1;if(i===len-1&&!doPostDraw)nextTargetId=0;this._numTempSurfacesRequired=Math.max(this._numTempSurfacesRequired,nextTargetId);this._steps.push(C3.New(C3.Gfx.EffectChain.Step.Bounce,this,lastTargetId,nextTargetId,i));lastTargetId=nextTargetId}if(doPostDraw)this._steps.push(C3.New(C3.Gfx.EffectChain.Step.PostDraw,this,lastTargetId,0))}_ShouldPreDraw(firstShaderProgram,opts){if(opts.forcePreDraw||firstShaderProgram.MustPreDraw()||opts.is3D||firstShaderProgram.UsesDepth()&&!this._useFullSurface||
(this._boxExtendHorizontal!==0||this._boxExtendVertical!==0))return true;if(firstShaderProgram.GetRenderer().IsWebGL())return firstShaderProgram.BlendsBackground()&&(opts.isRotatedOrNegativeSizeInstance||opts.isSourceTextureRotated)||firstShaderProgram.UsesAnySrcRectOrPixelSize()&&opts.isSourceTextureRotated;else return false}_ShouldPostDraw(lastShaderProgram,opts){if(opts.forcePostDraw)return true;if(lastShaderProgram.GetRenderer().IsWebGL())return lastShaderProgram.BlendsBackground()||lastShaderProgram.UsesCrossSampling();
else return(lastShaderProgram.BlendsBackground()||lastShaderProgram.UsesCrossSampling())&&this._UseRenderTargetBackgroundSampling()}_ShouldUseCopyTextureBackgroundSampling(renderer){return renderer.IsWebGPU()&&this._isAnyShaderBackgroundBlending&&!this._isAnyShaderCrossSampling}Render(renderer,destRenderTarget,opts){if(renderer.IsWebGPU()&&destRenderTarget===null)destRenderTarget=renderer.GetBackbufferRenderTarget();this._destRenderTarget=destRenderTarget;this._contentObject=opts.contentObject||null;
this._contextObject=opts.contextObject||null;this._blendMode=opts.blendMode||0;this._devicePixelRatio=opts.devicePixelRatio||1;this._layerScale=opts.layerScale||1;this._layerAngle=opts.layerAngle||0;this._time=typeof opts.time==="number"?opts.time:this._manager.GetTime();this._didChangeTransform=false;renderer.ResetDidChangeTransformFlag();if(this._isAnyShaderAnimated)this._Redraw();let didCalcDrawSizeAndRects=false;if(this._UseCopyTextureBackgroundSampling()){this._CalculateDrawSizeAndRectangles(renderer,
opts);didCalcDrawSizeAndRects=true;this._backTex=this._manager._GetWebGPUBackTexture(renderer,this._drawWidth,this._drawHeight);tempRect.copy(this._drawSurfaceRect);tempRect.roundOuter();renderer.CopyTextureToTexture(this._destRenderTarget.GetTexture(),this._backTex,tempRect.getLeft(),tempRect.getTop(),tempRect.width(),tempRect.height())}if(this._canUseFastPath){this._Render_FastPath(renderer,opts);return}if(!didCalcDrawSizeAndRects)this._CalculateDrawSizeAndRectangles(renderer,opts);renderer.ResetColor();
renderer.SetBaseZ(0);renderer.SetCurrentZ(0);this._cbDrawContentHook=opts.drawContentHook||null;this._compositOffX=opts.compositOffX||0;this._compositOffY=opts.compositOffY||0;this._updateOwnProjection=!!opts.updateOwnProjection;this._OnBeforeStartEffectChain(renderer);this._renderTargets[0]=destRenderTarget;this._renderTargets[1]=this._numTempSurfacesRequired>=1?this._GetRenderTarget():null;this._renderTargets[2]=this._numTempSurfacesRequired===2?this._GetRenderTarget():null;for(const step of this._steps){const srcTarget=
this._GetRenderTargetForId(step.GetSrcTargetId());const destTarget=this._GetRenderTargetForId(step.GetDestTargetId());if(renderer.IsWebGPU())step.Run_WebGPU(renderer,srcTarget,destTarget);else step.Run_WebGL(renderer,srcTarget,destTarget)}if(this._renderTargets[1])this._ReleaseRenderTarget(this._renderTargets[1]);if(this._renderTargets[2])this._ReleaseRenderTarget(this._renderTargets[2]);this._renderTargets.fill(null);this._OnAfterEndEffectChain(renderer);this._destRenderTarget=null;this._backTex=
null;this._contentObject=null;this._contextObject=null;this._cbDrawContentHook=null}_CalculateDrawSizeAndRectangles(renderer,opts){const [drawWidth,drawHeight]=this._manager.GetDrawSize(renderer);this._SetDrawSize(renderer,drawWidth,drawHeight);this._CalculateRectangles(opts)}_SetDrawSize(renderer,drawWidth,drawHeight){if(drawWidth<=0||drawHeight<=0)throw new Error("invalid draw size");if(this._drawWidth!==drawWidth||this._drawHeight!==drawHeight)this._CalculateDeviceTransformMatrices(renderer,drawWidth,
drawHeight,0,0,this._projectionMatrix,this._modelViewMatrix);this._drawWidth=drawWidth;this._drawHeight=drawHeight}_CalculateDeviceTransformMatrices(renderer,width,height,offX,offY,projMat,mvMat){const scrollX=width/2+offX;const scrollY=height/2+offY;renderer.CalculatePerspectiveMatrix(projMat,width/height);const tempMat4=renderer.CalculateLookAtModelView2(scrollX,scrollY,renderer.GetDefaultCameraZ(height),scrollX,scrollY,0,height);mat4.copy(mvMat,tempMat4)}_CalculateRectangles(opts){this._layoutRect.copy(opts.layoutRect);
if(opts.drawSurfaceRect)this._drawSurfaceRect.copy(opts.drawSurfaceRect);else this._drawSurfaceRect.set(0,0,this._drawWidth,this._drawHeight);this._rcTexOriginal.copy(this._drawSurfaceRect);this._rcTexOriginal.divide(this._drawWidth,this._drawHeight);const boxScale=this._layerScale*this._devicePixelRatio;this._drawSurfaceRect.inflate(this._boxExtendHorizontal*boxScale,this._boxExtendVertical*boxScale);this._rcTexDest.copy(this._drawSurfaceRect);this._rcTexDest.divide(this._drawWidth,this._drawHeight);
this._drawSurfaceRect.clamp(0,0,this._drawWidth,this._drawHeight);this._rcTexBounce.copy(this._drawSurfaceRect);this._rcTexBounce.divide(this._drawWidth,this._drawHeight)}_OnBeforeStartEffectChain(renderer){this._depthEnabledAtStart=renderer.IsDepthEnabled();if(this._useFullSurface){renderer.SetDepthEnabled(false);if(this._isAnyShaderDepthSampling)renderer.SetDepthSamplingEnabled(true)}else{tempRect.copy(this._drawSurfaceRect);if(renderer.IsWebGL()){const boxScale=this._layerScale*this._devicePixelRatio;
tempRect.inflate(Math.max(this._boxExtendHorizontal,1)*boxScale,Math.max(this._boxExtendVertical,1)*boxScale);tempRect.roundOuter();tempRect.clamp(0,0,this._drawWidth,this._drawHeight)}else tempRect.roundOuter();renderer.SetScissorRect(tempRect.getLeft(),tempRect.getTop(),tempRect.width(),tempRect.height(),this._drawHeight)}}_OnAfterEffectChainDrawContent(renderer){renderer.ResetColor();if(!this._useFullSurface){renderer.SetDepthEnabled(false);if(this._isAnyShaderDepthSampling)renderer.SetDepthSamplingEnabled(true)}if(renderer.IsWebGPU())renderer.SetNormalizedCoordsProgramVariant(true)}_OnAfterEndEffectChain(renderer){renderer.SetDepthSamplingEnabled(false);
renderer.SetDepthEnabled(this._depthEnabledAtStart);if(!this._useFullSurface)renderer.RemoveScissorRect();if(renderer.IsWebGPU())renderer.SetNormalizedCoordsProgramVariant(false);this._didChangeTransform=renderer.DidChangeTransform()}_ClampRcTexDest(){this._rcTexDest.clamp(0,0,1,1)}_GetRenderTargetForId(id){return id<0?null:this._renderTargets[id]}_GetRenderTarget(){return this._manager.GetRenderTarget(this)}_GetDestRenderTarget(){return this._destRenderTarget}_ReleaseRenderTarget(rt){this._manager.ReleaseRenderTarget(rt,
this)}_GetShaderProgramAt(i){return this._shaderProgramList[i]}_DrawContent(renderer){if(this._cbDrawContentHook)this._cbDrawContentHook(this,renderer,()=>this._cbDrawContent(renderer,this));else this._cbDrawContent(renderer,this);if(!this._canUseFastPath)this._OnAfterEffectChainDrawContent(renderer)}_IsRenderTargetSameSizeAndOffset(renderer){if(this._useFullSurface)return true;if(this._compositOffX!==0||this._compositOffY!==0)return false;const [rtWidth,rtHeight]=renderer.GetRenderTargetSize(renderer.GetRenderTarget());
if(rtWidth!==this._drawWidth||rtHeight!==this._drawHeight)return false;return true}_SetDeviceTransform(renderer,isLast){let projMat=this._projectionMatrix;let mvMat=this._modelViewMatrix;if(isLast&&!this._IsRenderTargetSameSizeAndOffset(renderer)){projMat=tempMat4a;mvMat=tempMat4b;const [rtWidth,rtHeight]=renderer.GetRenderTargetSize(renderer.GetRenderTarget());this._CalculateDeviceTransformMatrices(renderer,rtWidth,rtHeight,this._compositOffX,this._compositOffY,projMat,mvMat);if(!this._useFullSurface)renderer.RemoveScissorRect()}renderer.SetProjectionMatrix(projMat);
renderer.SetModelViewMatrix(mvMat)}_Redraw(){this._manager.Redraw(this)}_GetShaderParameters(index,renderer){return this._cbGetShaderParameters(this._shaderProgramIndices[index],renderer)}_SetProgramParameters(renderer,index){let rcTexDest=this._rcTexDest;let srcRect=this._rcTexBounce;let srcOriginRect=this._rcTexOriginal;if(renderer.IsWebGL()){tempRect2.copy(rcTexDest);tempRect2.flipAround(1);rcTexDest=tempRect2;tempRect3.copy(srcRect);tempRect3.flipAround(1);srcRect=tempRect3;tempRect4.copy(srcOriginRect);
tempRect4.flipAround(1);srcOriginRect=tempRect4}this._DoSetProgramParameters(renderer,index,srcRect,srcOriginRect,rcTexDest,1/this._drawWidth,1/this._drawHeight)}_SetFirstBounceProgramParameters(renderer,index){let srcRect=this._rcTexBounce;let srcOriginRect=this._rcTexOriginal;let pixelWidth=1/this._drawWidth;let pixelHeight=1/this._drawHeight;if(this._cbGetSourceTextureInfo){let {srcTexRect,srcWidth,srcHeight}=this._cbGetSourceTextureInfo(this._contentObject);if(!srcTexRect){tempRect.set(0,0,0,
0);srcTexRect=tempRect}if(!srcWidth)srcWidth=this._drawWidth;if(!srcHeight)srcHeight=this._drawHeight;srcRect=srcTexRect;srcOriginRect=srcTexRect;pixelWidth=1/srcWidth;pixelHeight=1/srcHeight}else if(renderer.IsWebGL()){tempRect3.copy(srcRect);tempRect3.flipAround(1);srcRect=tempRect3;tempRect4.copy(srcOriginRect);tempRect4.flipAround(1);srcOriginRect=tempRect4}let rcTexDest=this._rcTexDest;if(renderer.IsWebGL()){rcTexDest=tempRect2;rcTexDest.copy(this._rcTexDest);rcTexDest.flipAround(1)}this._DoSetProgramParameters(renderer,
index,srcRect,srcOriginRect,rcTexDest,pixelWidth,pixelHeight);if(renderer.IsWebGPU()&&this._isAnyIsSrcTexRotated)renderer.SetProgramParameter_IsSrcTexRotated(this._isSourceTextureRotated)}_GetBackTex(renderer){if(this._isAnyShaderBackgroundBlending)if(renderer.IsWebGPU())if(this._UseCopyTextureBackgroundSampling())return this._backTex;else return this._destRenderTarget.GetTexture();else return this._destRenderTarget;else return null}_DoSetProgramParameters(renderer,index,srcRect,srcOriginRect,rcTexDest,
pixelWidth,pixelHeight){renderer.SetProgramParameters(this._GetBackTex(renderer),rcTexDest,srcRect,srcOriginRect,this._layoutRect,pixelWidth,pixelHeight,this._devicePixelRatio,this._layerScale,this._layerAngle,this._time);renderer.SetProgramCustomParameters(this._GetShaderParameters(index,renderer))}_Render_FastPath(renderer,opts){const shaderProgram=this._shaderProgramList[0];const wasDepthEnabled=renderer.IsDepthEnabled();const usesDepth=shaderProgram.UsesDepth();if(usesDepth){renderer.SetDepthEnabled(false);
renderer.SetDepthSamplingEnabled(true);this._rcTexDest.set(0,0,1,1);this._rcTexOriginal.set(0,0,1,1)}renderer.SetProgram(shaderProgram);renderer.SetBlendMode(this._blendMode);renderer.SetRenderTarget(this._destRenderTarget);let pixelWidth=0;let pixelHeight=1;this._rcTexOriginal.set(0,0,1,1);if(shaderProgram.UsesAnySrcRectOrPixelSize()&&this._cbGetSourceTextureInfo){const {srcTexRect,srcWidth,srcHeight}=this._cbGetSourceTextureInfo(this._contentObject);if(srcTexRect)this._rcTexOriginal.copy(srcTexRect);
pixelWidth=Number.isFinite(srcWidth)?1/srcWidth:0;pixelHeight=Number.isFinite(srcHeight)?1/srcHeight:0}else{const [drawWidth,drawHeight]=this._manager.GetDrawSize(renderer);pixelWidth=1/drawWidth;pixelHeight=1/drawHeight}if(opts.layoutRect)this._layoutRect.copy(opts.layoutRect);else this._layoutRect.set(0,0,0,0);renderer.SetProgramParameters(this._GetBackTex(renderer),this._rcTexDest,this._rcTexOriginal,this._rcTexOriginal,this._layoutRect,pixelWidth,pixelHeight,this._devicePixelRatio,this._layerScale,
this._layerAngle,this._time);renderer.SetProgramCustomParameters(this._GetShaderParameters(0,renderer));if(renderer.IsWebGPU()&&this._isAnyIsSrcTexRotated)renderer.SetProgramParameter_IsSrcTexRotated(this._isSourceTextureRotated);renderer.SetBaseZ(0);this._DrawContent(renderer);if(usesDepth){renderer.SetDepthSamplingEnabled(false);renderer.SetDepthEnabled(wasDepthEnabled)}}_UseCopyTextureBackgroundSampling(){return this._useCopyTextureBackgroundSampling}_UseRenderTargetBackgroundSampling(){return!this._useCopyTextureBackgroundSampling}IsAnyShaderBackgroundBlending(){return this._isAnyShaderBackgroundBlending}CanSkipCalculatingDrawSurfaceRect(){if(!this._canUseFastPath)return false;
if(this._UseCopyTextureBackgroundSampling())return false;return true}UseFullSurface(){return this._useFullSurface}GetContentObject(){return this._contentObject}GetContextObject(){return this._contextObject}_GetBlendMode(){return this._blendMode}_UpdateOwnProjection(){return this._updateOwnProjection}DidChangeTransform(){return this._didChangeTransform}_GetDrawSurfaceRect(){return this._drawSurfaceRect}_GetRcTexBounce(){return this._rcTexBounce}_ShouldInvalidateRenderTargets(){return this._invalidateRenderTargets}async DebugLogRenderTargetContents(msg,
renderer,renderTarget){}};

}

// ../lib/gfx/effectCompositor/step.js
{
'use strict';const C3=self.C3;
C3.Gfx.EffectChain.Step=class EffectChainStep{constructor(effectChain,srcTargetId,destTargetId,index=-1){this._effectChain=effectChain;this._srcTargetId=srcTargetId;this._destTargetId=destTargetId;this._index=index}GetEffectChain(){return this._effectChain}GetSrcTargetId(){return this._srcTargetId}GetDestTargetId(){return this._destTargetId}GetIndex(){return this._index}GetShaderProgram(){return this.GetEffectChain()._GetShaderProgramAt(this.GetIndex())}Run_WebGL(renderer,srcRenderTarget,destRenderTarget){}Run_WebGPU(renderer,
srcRenderTarget,destRenderTarget){}};

}

// ../lib/gfx/effectCompositor/preDrawStep.js
{
'use strict';const C3=self.C3;
C3.Gfx.EffectChain.Step.PreDraw=class PreDrawStep extends C3.Gfx.EffectChain.Step{constructor(effectChain,srcTargetId,destTargetId,index){super(effectChain,srcTargetId,destTargetId,index)}Run_WebGL(renderer,srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();renderer.SetAlphaBlend();renderer.SetTextureFillMode();renderer.SetRenderTarget(destRenderTarget,effectChain._UpdateOwnProjection());renderer.ClearRgba(0,0,0,0);effectChain._DrawContent(renderer);effectChain._ClampRcTexDest()}Run_WebGPU(renderer,
srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();renderer.SetAlphaBlend();renderer.SetTextureFillMode();renderer.SetRenderTarget(destRenderTarget,false);renderer.ClearRgba(0,0,0,0);effectChain._DrawContent(renderer);effectChain._ClampRcTexDest()}};

}

// ../lib/gfx/effectCompositor/postDrawStep.js
{
'use strict';const C3=self.C3;const tempRect=C3.New(C3.Rect);const tempQuad=C3.New(C3.Quad);
C3.Gfx.EffectChain.Step.PostDraw=class PostDrawStep extends C3.Gfx.EffectChain.Step{constructor(effectChain,srcTargetId,destTargetId,index){super(effectChain,srcTargetId,destTargetId,index)}Run_WebGL(renderer,srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();renderer.SetTextureFillMode();renderer.SetRenderTarget(destRenderTarget);effectChain._SetDeviceTransform(renderer,true);renderer.SetBlendMode(effectChain._GetBlendMode());renderer.SetTexture(srcRenderTarget.GetTexture());
tempQuad.setFromRect(effectChain._GetDrawSurfaceRect());tempRect.copy(effectChain._GetRcTexBounce());tempRect.flipAround(1);renderer.Quad3(tempQuad,tempRect);if(effectChain._ShouldInvalidateRenderTargets())renderer.InvalidateRenderTarget(srcRenderTarget)}Run_WebGPU(renderer,srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();renderer.SetTextureFillMode();renderer.SetRenderTarget(destRenderTarget,false);if(effectChain._IsRenderTargetSameSizeAndOffset(renderer))tempQuad.setFromRect(effectChain._GetRcTexBounce());
else{renderer.SetNormalizedCoordsProgramVariant(false);effectChain._SetDeviceTransform(renderer,true);tempQuad.setFromRect(effectChain._GetDrawSurfaceRect())}renderer.SetBackTexture(null);renderer.SetBlendMode(effectChain._GetBlendMode());renderer.SetTexture(srcRenderTarget.GetTexture());if(effectChain.UseFullSurface())renderer.FullscreenQuad();else renderer.Quad3(tempQuad,effectChain._GetRcTexBounce())}};

}

// ../lib/gfx/effectCompositor/firstBounceStep.js
{
'use strict';const C3=self.C3;
C3.Gfx.EffectChain.Step.FirstBounce=class FirstBounceStep extends C3.Gfx.EffectChain.Step{constructor(effectChain,srcTargetId,destTargetId,index){super(effectChain,srcTargetId,destTargetId,index)}Run_WebGL(renderer,srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();renderer.SetRenderTarget(destRenderTarget,effectChain._UpdateOwnProjection());renderer.ClearRgba(0,0,0,0);renderer.SetCopyBlend();renderer.SetProgram(this.GetShaderProgram());effectChain._SetFirstBounceProgramParameters(renderer,this.GetIndex());
effectChain._DrawContent(renderer);effectChain._ClampRcTexDest()}Run_WebGPU(renderer,srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();renderer.SetRenderTarget(destRenderTarget,false);renderer.ClearRgba(0,0,0,0);renderer.SetCopyBlend();renderer.SetProgram(this.GetShaderProgram());effectChain._SetFirstBounceProgramParameters(renderer,this.GetIndex());effectChain._DrawContent(renderer);effectChain._ClampRcTexDest()}};

}

// ../lib/gfx/effectCompositor/bounceStep.js
{
'use strict';const C3=self.C3;const tempRect=C3.New(C3.Rect);const tempQuad=C3.New(C3.Quad);
C3.Gfx.EffectChain.Step.Bounce=class BounceStep extends C3.Gfx.EffectChain.Step{constructor(effectChain,srcTargetId,destTargetId,index){super(effectChain,srcTargetId,destTargetId,index)}Run_WebGL(renderer,srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();renderer.SetRenderTarget(destRenderTarget);const isLast=this.GetDestTargetId()===0;if(isLast)renderer.SetBlendMode(effectChain._GetBlendMode());else{renderer.ClearRgba(0,0,0,0);renderer.SetCopyBlend()}renderer.SetProgram(this.GetShaderProgram());
effectChain._SetProgramParameters(renderer,this.GetIndex());renderer.SetTexture(srcRenderTarget.GetTexture());effectChain._SetDeviceTransform(renderer,isLast);tempQuad.setFromRect(effectChain._GetDrawSurfaceRect());tempRect.copy(effectChain._GetRcTexBounce());tempRect.flipAround(1);renderer.Quad3(tempQuad,tempRect);if(effectChain._ShouldInvalidateRenderTargets())renderer.InvalidateRenderTarget(srcRenderTarget)}Run_WebGPU(renderer,srcRenderTarget,destRenderTarget){const effectChain=this.GetEffectChain();
renderer.SetRenderTarget(destRenderTarget,false);const isLast=this.GetDestTargetId()===0;if(isLast){renderer.SetBlendMode(effectChain._GetBlendMode());renderer.SetBackTexture(null);if(effectChain._IsRenderTargetSameSizeAndOffset(renderer))tempQuad.setFromRect(effectChain._GetRcTexBounce());else{renderer.SetNormalizedCoordsProgramVariant(false);effectChain._SetDeviceTransform(renderer,true);tempQuad.setFromRect(effectChain._GetDrawSurfaceRect())}}else{renderer.ClearRgba(0,0,0,0);renderer.SetCopyBlend();
tempQuad.setFromRect(effectChain._GetRcTexBounce())}renderer.SetProgram(this.GetShaderProgram());effectChain._SetProgramParameters(renderer,this.GetIndex());renderer.SetTexture(srcRenderTarget.GetTexture());if(effectChain.UseFullSurface())renderer.FullscreenQuad();else renderer.Quad3(tempQuad,effectChain._GetRcTexBounce())}};

}

// interfaces/IRuntime.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;let runtime=null;const keysDownByKey=new Set;function SortZOrderList(a,b){const layerA=a[0];const layerB=b[0];const diff=layerA-layerB;if(diff!==0)return diff;const indexA=a[1];const indexB=b[1];return indexA-indexB}const tempZOrderList=[];const tempInstances=[];let didWarnInAlertPolyfill=false;
self.IRuntime=class IRuntime{constructor(runtime_,objects){runtime=runtime_;Object.defineProperties(this,{assets:{value:runtime.GetAssetManager().GetIAssetManager(),writable:false},objects:{value:objects,writable:false},globalVars:{value:{},writable:false},projectName:{value:runtime.GetProjectName(),writable:false},projectVersion:{value:runtime.GetProjectVersion(),writable:false},storage:{value:new self.IStorage(runtime),writable:false},isInWorker:{value:runtime.IsInWorker(),writable:false},viewportWidth:{value:runtime.GetOriginalViewportWidth(),
writable:false},viewportHeight:{value:runtime.GetOriginalViewportHeight(),writable:false}});runtime.UserScriptDispatcher().addEventListener("keydown",e=>{if(keysDownByKey.has(e["key"])){e.stopPropagation();return}keysDownByKey.add(e["key"])});runtime.UserScriptDispatcher().addEventListener("keyup",e=>keysDownByKey.delete(e["key"]));runtime.Dispatcher().addEventListener("window-blur",()=>keysDownByKey.clear());if(runtime.IsInWorker())self["alert"]=message=>{if(!didWarnInAlertPolyfill){didWarnInAlertPolyfill=
true;console.warn("[Construct] alert() was called from a Web Worker, because the project 'Use worker' setting is enabled. This method is not normally available in a Web Worker. Construct has implemented the alert for you, but note that other features may be missing in worker mode. You may wish to disable 'Use worker', or use a more convenient function like console.log(). For more information please refer to the scripting section of the manual.")}return this.alert(message)}}_InitGlobalVars(globalVarDescriptors){Object.defineProperties(this.globalVars,
globalVarDescriptors)}addEventListener(name,func){runtime.UserScriptDispatcher().addEventListener(name,func)}removeEventListener(name,func){runtime.UserScriptDispatcher().removeEventListener(name,func)}callFunction(name,...params){C3X.RequireString(name);const eventSheetManager=runtime.GetEventSheetManager();const functionBlock=eventSheetManager.GetFunctionBlockByName(name);if(!functionBlock)throw new Error(`cannot find function name '${name}'`);if(!functionBlock.IsEnabled())return functionBlock.GetDefaultReturnValue();
if(params.length<functionBlock.GetFunctionParameterCount())throw new Error(`not enough function parameters passed for '${name}' (${params.length} passed, ${functionBlock.GetFunctionParameterCount()} expected)`);const callEventBlock=functionBlock.GetEventBlock();let allSolModifiers=callEventBlock.GetSolModifiersIncludingParents();const currentEvent=eventSheetManager.GetCurrentEvent();if(currentEvent){allSolModifiers=allSolModifiers.slice(0);const allSolModifiersSet=new Set(allSolModifiers);for(const objectClass of currentEvent.GetSolModifiersIncludingParents())if(!allSolModifiersSet.has(objectClass)){allSolModifiers.push(objectClass);
allSolModifiersSet.add(objectClass)}for(const objectClass of eventSheetManager.GetDynamicSolModifiersSet())if(!allSolModifiersSet.has(objectClass)){allSolModifiers.push(objectClass);allSolModifiersSet.add(objectClass)}}const ret=callEventBlock.RunAsExpressionFunctionCall(allSolModifiers,functionBlock.IsCopyPicked(),functionBlock.GetReturnType(),functionBlock.GetDefaultReturnValue(),...params);return ret}setReturnValue(v){const frame=runtime.GetEventStack().GetCurrentExpFuncStackFrame();if(!frame)throw new Error("not in a function which returns a value");
switch(frame.GetFunctionReturnType()){case 1:if(typeof v==="number")frame.SetFunctionReturnValue(v);break;case 2:if(typeof v==="string")frame.SetFunctionReturnValue(v);break;case 3:if(typeof v==="number"||typeof v==="string")frame.SetFunctionReturnValue(v);break}}getViewportSize(){return[runtime.GetOriginalViewportWidth(),runtime.GetOriginalViewportHeight()]}get dt(){return runtime.GetDt()}get dtRaw(){return runtime.GetDtRaw()}get gameTime(){return runtime.GetGameTime()}get wallTime(){return runtime.GetWallTime()}get timeScale(){return runtime.GetTimeScale()}set timeScale(t){C3X.RequireFiniteNumber(t);
runtime.SetTimeScale(t)}get fps(){return runtime.GetFPS()}get cpuUtilisation(){return runtime.GetMainThreadTime()}get gpuUtilisation(){return runtime.GetGPUUtilisation()}random(){return runtime.Random()}get layout(){return runtime.GetMainRunningLayout().GetILayout()}getLayout(nameOrIndex){const layoutManager=runtime.GetLayoutManager();let layout=null;if(typeof nameOrIndex==="number"||typeof nameOrIndex==="string")layout=layoutManager.GetLayout(nameOrIndex);else throw new TypeError("expected string or number");
if(!layout)throw new Error("invalid layout");return layout.GetILayout()}getAllLayouts(){return runtime.GetLayoutManager().GetAllLayouts().map(layout=>layout.GetILayout())}goToLayout(nameOrIndex){const layoutManager=runtime.GetLayoutManager();let layout=null;if(typeof nameOrIndex==="number"||typeof nameOrIndex==="string")layout=layoutManager.GetLayout(nameOrIndex);else throw new TypeError("expected string or number");if(!layout)throw new Error("invalid layout");if(layoutManager.IsPendingChangeMainLayout())return;
layoutManager.ChangeMainLayout(layout)}get keyboard(){const ret=runtime._GetCommonScriptInterfaces().keyboard;if(!ret)throw new Error("runtime.keyboard used but Keyboard object missing - add it to your project first");return ret}get mouse(){const ret=runtime._GetCommonScriptInterfaces().mouse;if(!ret)throw new Error("runtime.mouse used but Mouse object missing - add it to your project first");return ret}get touch(){const ret=runtime._GetCommonScriptInterfaces().touch;if(!ret)throw new Error("runtime.touch used but Touch object missing - add it to your project first");
return ret}invokeDownload(url,filename){C3X.RequireString(url);C3X.RequireString(filename);runtime.InvokeDownload(url,filename)}getInstanceByUid(uid){C3X.RequireFiniteNumber(uid);const ret=runtime.GetInstanceByUID(uid);return ret?ret.GetInterfaceClass():null}sortZOrder(iterable,callback){C3X.RequireFunction(callback);const layout=runtime.GetCurrentLayout();for(const iinst of iterable){const inst=runtime._UnwrapIWorldInstance(iinst);const wi=inst.GetWorldInfo();tempZOrderList.push([wi.GetLayer().GetIndex(),
wi.GetZIndex()]);tempInstances.push(inst)}if(tempZOrderList.length===0)return;tempZOrderList.sort(SortZOrderList);tempInstances.sort((a,b)=>callback(a.GetInterfaceClass(),b.GetInterfaceClass()));let anyChanged=false;for(let i=0,len=tempZOrderList.length;i<len;++i){const inst=tempInstances[i];const layer=layout.GetLayerByIndex(tempZOrderList[i][0]);const toZ=tempZOrderList[i][1];const layerInstances=layer._GetInstances();if(layerInstances[toZ]!==inst){layerInstances[toZ]=inst;inst.GetWorldInfo()._SetLayer(layer,
true);layer.SetZIndicesChanged();anyChanged=true}}if(anyChanged)runtime.UpdateRender();C3.clearArray(tempZOrderList);C3.clearArray(tempInstances)}async createWorker(url,opts){const messageChannel=new MessageChannel;const port1=messageChannel.port1;const port2=messageChannel.port2;await runtime.PostComponentMessageToDOMAsync("runtime","script-create-worker",{"url":url,"opts":opts,"port2":port2},[port2]);return port1}alert(message){return runtime.PostComponentMessageToDOMAsync("runtime","alert",{"message":message+
(runtime.IsInWorker()?" [via Web Worker]":"")})}};

}

// interfaces/IAssetManager.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;let assetManager=null;
self.IAssetManager=class IAssetManager{constructor(assetManager_){assetManager=assetManager_;Object.defineProperties(this,{isWebMOpusSupported:{value:assetManager.IsAudioFormatSupported("audio/webm; codecs=opus"),writable:false}})}fetchText(url){return assetManager.FetchText(url)}fetchJson(url){return assetManager.FetchJson(url)}fetchBlob(url){return assetManager.FetchBlob(url)}fetchArrayBuffer(url){return assetManager.FetchArrayBuffer(url)}getProjectFileUrl(url){return assetManager.GetProjectFileUrl(url)}getMediaFileUrl(url){if(assetManager.GetFileStructure()==="flat"&&
C3.IsRelativeURL(url))url=url.toLowerCase();return assetManager.GetMediaFileUrl(url)}get mediaFolder(){return assetManager.GetMediaSubfolder()}async decodeWebMOpus(audioContext,arrayBuffer){if(this.isWebMOpusSupported)throw new Error("decodeWebMOpus(): not supported because WebM Opus is supported by the platform");const decodedArrayBuffer=await assetManager.GetRuntime()._WasmDecodeWebMOpus(arrayBuffer);const decodedFloats=new Float32Array(decodedArrayBuffer);const audioBuffer=audioContext["createBuffer"](1,
decodedFloats.length,48E3);const channelBuffer=audioBuffer["getChannelData"](0);channelBuffer.set(decodedFloats);return audioBuffer}loadScripts(...urls){return assetManager.LoadScripts(...urls)}compileWebAssembly(url){return assetManager.CompileWebAssembly(url)}loadStyleSheet(url){return assetManager.LoadStyleSheet(url)}};

}

// interfaces/IStorage.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;self.IStorage=class IStorage{constructor(runtime){this._storage=runtime._GetProjectStorage()}getItem(key){C3X.RequireString(key);return this._storage.getItem(key)}setItem(key,value){C3X.RequireString(key);return this._storage.setItem(key,value)}removeItem(key){C3X.RequireString(key);return this._storage.removeItem(key)}clear(){return this._storage.clear()}keys(){return this._storage.keys()}};

}

// interfaces/IObjectClass.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;
self.IObjectClass=class IObjectClass{constructor(objectClass){map.set(this,objectClass);Object.defineProperties(this,{name:{value:objectClass.GetName(),writable:false}});objectClass.GetRuntime()._MapScriptInterface(this,objectClass)}addEventListener(type,func){C3X.RequireString(type);C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().addEventListener(type,func)}removeEventListener(type,func){C3X.RequireString(type);C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().removeEventListener(type,
func)}getAllInstances(){return[...this.instances()]}getFirstInstance(){return C3.first(this.instances())}getPickedInstances(){return[...this.pickedInstances()]}getFirstPickedInstance(){return C3.first(this.pickedInstances())}*instances(){for(const inst of map.get(this).instancesIncludingPendingCreate())yield inst.GetInterfaceClass()}*pickedInstances(){for(const inst of map.get(this).GetCurrentSol().GetInstances())yield inst.GetInterfaceClass()}setInstanceClass(Class){C3X.RequireFunction(Class);const objectClass=
map.get(this);if(objectClass.GetInstanceCount()>0)throw new Error("setInstanceClass() called too late, because instances have already been created - call in runOnStartup");map.get(this)._SetUserScriptInstanceClass(Class)}createInstance(layerNameOrIndex,x,y,createHierarchy,template){C3X.RequireNumber(x);C3X.RequireNumber(y);if(typeof layerNameOrIndex!=="number"&&typeof layerNameOrIndex!=="string")throw new TypeError("invalid layer parameter");const objectClass=map.get(this);const runtime=objectClass.GetRuntime();
const layer=runtime.GetMainRunningLayout().GetLayer(layerNameOrIndex);if(!layer)throw new Error("invalid layer");const inst=runtime.CreateInstance(objectClass,layer,x,y,createHierarchy,template);if(createHierarchy)layer.SortAndAddInstancesByZIndex(inst);const eventSheetManager=runtime.GetEventSheetManager();eventSheetManager.BlockFlushingInstances(true);inst._TriggerOnCreatedOnSelfAndRelated();eventSheetManager.BlockFlushingInstances(false);if(!eventSheetManager.IsInEventEngine()&&!runtime.GetLayoutManager().IsEndingLayout())runtime.FlushPendingInstances();
return inst.GetInterfaceClass()}};

}

// interfaces/ILayout.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;
self.ILayout=class ILayout{constructor(layout){map.set(this,layout);const effectInstanceArr=[];const effectList=layout.GetEffectList();const effectCount=effectList.GetAllEffectTypes().length;for(let i=0;i<effectCount;++i)effectInstanceArr.push(new self.IEffectInstance(effectList,i));Object.defineProperties(this,{name:{value:layout.GetName(),writable:false},index:{value:layout.GetIndex(),writable:false},effects:{value:effectInstanceArr,writable:false}})}addEventListener(type,func){C3X.RequireString(type);
C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().addEventListener(type,func)}removeEventListener(type,func){C3X.RequireString(type);C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().removeEventListener(type,func)}get width(){return map.get(this).GetWidth()}set width(w){C3X.RequireFiniteNumber(w);map.get(this).SetWidth(w)}get height(){return map.get(this).GetHeight()}set height(h){C3X.RequireFiniteNumber(h);map.get(this).SetHeight(h)}setSize(w,h){C3X.RequireFiniteNumber(w);
C3X.RequireFiniteNumber(h);const layout=map.get(this);layout.SetWidth(w);layout.SetHeight(h)}getSize(){const layout=map.get(this);return[layout.GetWidth(),layout.GetHeight()]}set scale(s){C3X.RequireFiniteNumber(s);map.get(this).SetScale(s)}get scale(){return map.get(this).GetScale()}set angle(a){C3X.RequireFiniteNumber(a);map.get(this).SetAngle(a)}get angle(){return map.get(this).GetAngle()}set scrollX(x){C3X.RequireNumber(x);map.get(this).SetScrollX(x)}get scrollX(){return map.get(this).GetScrollX()}set scrollY(y){C3X.RequireNumber(y);
map.get(this).SetScrollY(y)}get scrollY(){return map.get(this).GetScrollY()}scrollTo(x,y){C3X.RequireNumber(x);C3X.RequireNumber(y);const layout=map.get(this);layout.SetScrollX(x);layout.SetScrollY(y)}getScrollPosition(){const layout=map.get(this);return[layout.GetScrollX(),layout.GetScrollY()]}getLayer(nameOrIndex){const layout=map.get(this);let layer=null;if(typeof nameOrIndex==="number"||typeof nameOrIndex==="string")layer=layout.GetLayer(nameOrIndex);else throw new TypeError("expected string or number");
if(!layer)return null;return layer.GetILayer()}getAllLayers(){return map.get(this).GetLayers().map(layer=>layer.GetILayer())}*allLayers(){for(const layer of map.get(this).allLayers())yield layer.GetILayer()}setVanishingPoint(vpX,vpY){C3X.RequireFiniteNumber(vpX);C3X.RequireFiniteNumber(vpY);map.get(this).SetVanishingPointXY(vpX,vpY)}getVanishingPoint(){return map.get(this)._GetVanishingPoint()}set projection(p){C3X.RequireString(p);const layout=map.get(this);if(p==="perspective")layout.SetPerspectiveProjection();
else if(p==="orthographic")layout.SetOrthographicProjection();else throw new Error("invalid projection");}get projection(){if(map.get(this).IsOrthographicProjection())return"orthographic";else return"perspective"}};

}

// interfaces/ILayer.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;const BLEND_MODE_TO_INDEX=new Map([["normal",0],["additive",1],["copy",3],["destination-over",4],["source-in",5],["destination-in",6],["source-out",7],["destination-out",8],["source-atop",9],["destination-atop",10]]);const INDEX_TO_BLEND_MODE=new Map([...BLEND_MODE_TO_INDEX.entries()].map(a=>[a[1],a[0]]));const tempColor=C3.New(C3.Color);
self.ILayer=class ILayer{constructor(layer){map.set(this,layer);const effectInstanceArr=[];const effectList=layer.GetEffectList();const effectCount=effectList.GetAllEffectTypes().length;for(let i=0;i<effectCount;++i)effectInstanceArr.push(new self.IEffectInstance(effectList,i));Object.defineProperties(this,{name:{value:layer.GetName(),writable:false},index:{value:layer.GetIndex(),writable:false},layout:{value:layer.GetLayout().GetILayout(),writable:false},effects:{value:effectInstanceArr,writable:false}})}static _Unwrap(ilayer){return map.get(ilayer)}get parentLayer(){const parent=
map.get(this).GetParentLayer();return parent?parent.GetILayer():null}*parentLayers(){for(const parent of map.get(this).parentLayers())yield parent.GetILayer()}*subLayers(){for(const layer of map.get(this).GetSubLayers())yield layer.GetILayer()}*allSubLayers(){for(const subLayer of map.get(this).GetSubLayers())for(const layer of subLayer.selfAndAllSubLayers())yield layer.GetILayer()}get isVisible(){return map.get(this)._IsVisibleFlagSet()}set isVisible(v){map.get(this).SetVisible(v)}get isSelfAndParentsVisible(){return map.get(this).IsVisible()}get isInteractive(){return map.get(this).IsInteractive()}set isInteractive(i){map.get(this).SetInteractive(i)}get isSelfAndParentsInteractive(){return map.get(this).IsSelfAndParentsInteractive()}get opacity(){return map.get(this).GetOpacity()}set opacity(o){o=
C3.clamp(+o,0,1);if(isNaN(o))return;map.get(this).SetOpacity(o)}set scale(s){C3X.RequireFiniteNumber(s);map.get(this).SetOwnScale(s)}get scale(){return map.get(this).GetOwnScale()}set scaleRate(r){C3X.RequireFiniteNumber(r);map.get(this).SetScaleRate(r)}get scaleRate(){return map.get(this).GetScaleRate()}set angle(a){C3X.RequireFiniteNumber(a);map.get(this).SetAngle(a)}get angle(){return map.get(this).GetOwnAngle()}set parallaxX(p){C3X.RequireFiniteNumber(p);map.get(this).SetParallaxX(p)}get parallaxX(){return map.get(this).GetParallaxX()}set parallaxY(p){C3X.RequireFiniteNumber(p);
map.get(this).SetParallaxY(p)}get parallaxY(){return map.get(this).GetParallaxY()}set zElevation(z){C3X.RequireFiniteNumber(z);map.get(this).SetZElevation(z)}get zElevation(){return map.get(this).GetZElevation()}set isTransparent(t){map.get(this).SetTransparent(t)}get isTransparent(){return map.get(this).IsTransparent()}set isForceOwnTexture(f){map.get(this).SetForceOwnTexture(f)}get isForceOwnTexture(){return map.get(this).IsForceOwnTexture()}set blendMode(bm){C3X.RequireString(bm);const index=BLEND_MODE_TO_INDEX.get(bm);
if(typeof index!=="number")throw new Error("invalid blend mode");map.get(this).SetBlendMode(index)}get blendMode(){return INDEX_TO_BLEND_MODE.get(map.get(this).GetBlendMode())}set backgroundColor(arr){C3X.RequireArray(arr);if(arr.length<3)throw new Error("expected 3 elements");tempColor.setRgb(arr[0],arr[1],arr[2]);const layer=map.get(this);const bgColor=layer.GetBackgroundColor();if(bgColor.equalsIgnoringAlpha(tempColor))return;bgColor.copyRgb(tempColor);layer.GetRuntime().UpdateRender()}get backgroundColor(){const c=
map.get(this).GetBackgroundColor();return[c.getR(),c.getG(),c.getB()]}set scrollX(x){C3X.RequireNumber(x);const layer=map.get(this);layer.SetOwnScrollPositionEnabled(true);layer.SetScrollX(x)}get scrollX(){return map.get(this).GetScrollX()}set scrollY(y){C3X.RequireNumber(y);const layer=map.get(this);layer.SetOwnScrollPositionEnabled(true);layer.SetScrollY(y)}get scrollY(){return map.get(this).GetScrollY()}scrollTo(x,y){C3X.RequireNumber(x);C3X.RequireNumber(y);const layer=map.get(this);layer.SetOwnScrollPositionEnabled(true);
layer.SetScrollX(x);layer.SetScrollY(y)}getScrollPosition(){const layer=map.get(this);return[layer.GetScrollX(),layer.GetScrollY()]}restoreScrollPosition(){map.get(this).SetOwnScrollPositionEnabled(false)}getViewport(){return map.get(this).GetViewport().toDOMRect()}cssPxToLayer(clientX,clientY,z=0){C3X.RequireNumber(clientX);C3X.RequireNumber(clientY);C3X.RequireNumber(z);const layer=map.get(this);const runtime=layer.GetRuntime();return layer.CanvasCssToLayer(clientX-runtime.GetCanvasClientX(),clientY-
runtime.GetCanvasClientY(),z)}layerToCssPx(layerX,layerY,z=0){C3X.RequireNumber(layerX);C3X.RequireNumber(layerY);C3X.RequireNumber(z);const layer=map.get(this);const runtime=layer.GetRuntime();const [clientX,clientY]=layer.LayerToCanvasCss(layerX,layerY,z);return[clientX+runtime.GetCanvasClientX(),clientY+runtime.GetCanvasClientY()]}};

}

// interfaces/IInstance.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;const dispatchers=new WeakMap;function GetDispatcher(iinst){let dispatcher=dispatchers.get(iinst);if(dispatcher)return dispatcher;dispatcher=C3.New(C3.Event.Dispatcher);dispatchers.set(iinst,dispatcher);return dispatcher}let initInst=null;
self.IInstance=class IInstance{constructor(){map.set(this,initInst);const descriptors={runtime:{value:initInst.GetRuntime().GetIRuntime(),writable:false},objectType:{value:initInst.GetObjectClass().GetIObjectClass(),writable:false},uid:{value:initInst.GetUID(),writable:false}};initInst._GetInstVarsScriptDescriptor(descriptors);initInst._GetBehaviorsScriptDescriptor(descriptors);Object.defineProperties(this,descriptors);initInst.GetRuntime()._MapScriptInterface(this,initInst)}static _Init(inst){initInst=
inst}static _GetInitInst(){return initInst}_Release(){const dispatcher=dispatchers.get(this);if(dispatcher){dispatcher.Release();dispatchers.delete(this)}map.delete(this)}addEventListener(type,func,capture){C3X.RequireString(type);C3X.RequireFunction(func);GetDispatcher(this).addEventListener(type,func,capture)}removeEventListener(type,func,capture){C3X.RequireString(type);C3X.RequireFunction(func);GetDispatcher(this).removeEventListener(type,func,capture)}dispatchEvent(e){GetDispatcher(this).dispatchEvent(e)}destroy(){const inst=
map.get(this);const runtime=inst.GetRuntime();runtime.DestroyInstance(inst);if(!runtime.GetEventSheetManager().IsInEventEngine()&&!runtime.GetLayoutManager().IsEndingLayout())runtime.FlushPendingInstances()}getOtherContainerInstances(){const siblings=map.get(this).GetSiblings();return siblings?siblings.map(s=>s.GetInterfaceClass()):[]}*otherContainerInstances(){const inst=map.get(this);if(!inst.IsInContainer())return;for(const s of inst.siblings())yield s.GetInterfaceClass()}get templateName(){return map.get(this).GetTemplateName()}set timeScale(t){C3X.RequireFiniteNumber(t);
map.get(this).SetTimeScale(t)}get timeScale(){return map.get(this).GetActiveTimeScale()}restoreTimeScale(){map.get(this).RestoreTimeScale()}};

}

// interfaces/IWorldInstance.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const IInstance=self.IInstance;const ILayer=self.ILayer;const map=new WeakMap;const BLEND_MODE_TO_INDEX=new Map([["normal",0],["additive",1],["copy",3],["destination-over",4],["source-in",5],["destination-in",6],["source-out",7],["destination-out",8],["source-atop",9],["destination-atop",10]]);const INDEX_TO_BLEND_MODE=new Map([...BLEND_MODE_TO_INDEX.entries()].map(a=>[a[1],a[0]]));const tempColor=C3.New(C3.Color);
self.IWorldInstance=class IWorldInstance extends IInstance{constructor(){super();const inst=IInstance._GetInitInst();map.set(this,inst);const effectInstanceArr=[];const wi=inst.GetWorldInfo();const instanceEffectList=wi.GetInstanceEffectList();if(instanceEffectList){const effectCount=wi.GetObjectClass().GetEffectList().GetAllEffectTypes().length;for(let i=0;i<effectCount;++i)effectInstanceArr.push(new self.IEffectInstance(instanceEffectList,i))}const descriptors={effects:{value:effectInstanceArr,
writable:false}};Object.defineProperties(this,descriptors)}get layout(){return map.get(this).GetWorldInfo().GetLayout().GetILayout()}get layer(){return map.get(this).GetWorldInfo().GetLayer().GetILayer()}get x(){return map.get(this).GetWorldInfo().GetX()}set x(v){v=+v;const wi=map.get(this).GetWorldInfo();if(isNaN(v)||wi.GetX()===v)return;wi.SetX(v);wi.SetBboxChanged()}get y(){return map.get(this).GetWorldInfo().GetY()}set y(v){v=+v;const wi=map.get(this).GetWorldInfo();if(isNaN(v)||wi.GetY()===v)return;
wi.SetY(v);wi.SetBboxChanged()}setPosition(x,y){x=+x;y=+y;const wi=map.get(this).GetWorldInfo();if(isNaN(x)||isNaN(y)||wi.GetX()===x&&wi.GetY()===y)return;wi.SetXY(x,y);wi.SetBboxChanged()}getPosition(){const wi=map.get(this).GetWorldInfo();return[wi.GetX(),wi.GetY()]}offsetPosition(dx,dy){dx=+dx;dy=+dy;if(isNaN(dx)||isNaN(dy)||dx===0&&dy===0)return;const wi=map.get(this).GetWorldInfo();wi.OffsetXY(dx,dy);wi.SetBboxChanged()}get zElevation(){return map.get(this).GetWorldInfo().GetZElevation()}set zElevation(z){z=
+z;const inst=map.get(this);const wi=inst.GetWorldInfo();if(isNaN(z)||wi.GetZElevation()===z)return;wi.SetZElevation(z);inst.GetRuntime().UpdateRender()}get totalZElevation(){return map.get(this).GetWorldInfo().GetTotalZElevation()}get width(){return map.get(this).GetWorldInfo().GetWidth()}set width(w){w=+w;const wi=map.get(this).GetWorldInfo();if(isNaN(w)||wi.GetWidth()===w)return;wi.SetWidth(w);wi.SetBboxChanged()}get height(){return map.get(this).GetWorldInfo().GetHeight()}set height(h){h=+h;const wi=
map.get(this).GetWorldInfo();if(isNaN(h)||wi.GetHeight()===h)return;wi.SetHeight(h);wi.SetBboxChanged()}setSize(w,h){w=+w;h=+h;const wi=map.get(this).GetWorldInfo();if(isNaN(w)||isNaN(h)||wi.GetWidth()===w&&wi.GetHeight()===h)return;wi.SetSize(w,h);wi.SetBboxChanged()}getSize(){const wi=map.get(this).GetWorldInfo();return[wi.GetWidth(),wi.GetHeight()]}get angle(){return map.get(this).GetWorldInfo().GetAngle()}set angle(a){a=C3.clampAngle(+a);const wi=map.get(this).GetWorldInfo();if(isNaN(a)||wi.GetAngle()===
a)return;wi.SetAngle(a);wi.SetBboxChanged()}get angleDegrees(){return C3.toDegrees(this.angle)}set angleDegrees(a){this.angle=C3.toRadians(a)}getBoundingBox(){return map.get(this).GetWorldInfo().GetBoundingBox().toDOMRect()}getBoundingQuad(){return map.get(this).GetWorldInfo().GetBoundingQuad().toDOMQuad()}get isVisible(){return map.get(this).GetWorldInfo().IsVisible()}set isVisible(v){v=!!v;const inst=map.get(this);const wi=inst.GetWorldInfo();if(wi.IsVisible()===v)return;wi.SetVisible(v);inst.GetRuntime().UpdateRender()}get opacity(){return map.get(this).GetWorldInfo().GetOpacity()}set opacity(o){o=
C3.clamp(+o,0,1);const inst=map.get(this);const wi=inst.GetWorldInfo();if(isNaN(o)||wi.GetOpacity()===o)return;wi.SetOpacity(o);inst.GetRuntime().UpdateRender()}set colorRgb(arr){C3X.RequireArray(arr);if(arr.length<3)throw new Error("expected 3 elements");tempColor.setRgb(arr[0],arr[1],arr[2]);const inst=map.get(this);const wi=inst.GetWorldInfo();if(wi.GetUnpremultipliedColor().equalsIgnoringAlpha(tempColor))return;wi.SetUnpremultipliedColor(tempColor);inst.GetRuntime().UpdateRender()}get colorRgb(){const c=
map.get(this).GetWorldInfo().GetUnpremultipliedColor();return[c.getR(),c.getG(),c.getB()]}set blendMode(bm){C3X.RequireString(bm);const index=BLEND_MODE_TO_INDEX.get(bm);if(typeof index!=="number")throw new Error("invalid blend mode");const inst=map.get(this);const wi=inst.GetWorldInfo();wi.SetBlendMode(index);inst.GetRuntime().UpdateRender()}get blendMode(){return INDEX_TO_BLEND_MODE.get(map.get(this).GetWorldInfo().GetBlendMode())}moveToTop(){map.get(this).GetWorldInfo().ZOrderMoveToTop()}moveToBottom(){map.get(this).GetWorldInfo().ZOrderMoveToBottom()}moveToLayer(ilayer){C3X.RequireInstanceOf(ilayer,
ILayer);const layer=ILayer._Unwrap(ilayer);if(!layer)throw new Error("invalid layer");map.get(this).GetWorldInfo().ZOrderMoveToLayer(layer)}moveAdjacentToInstance(other,isAfter){C3X.RequireInstanceOf(other,IWorldInstance);map.get(this).GetWorldInfo().ZOrderMoveAdjacentToInstance(map.get(other),isAfter)}get zIndex(){return map.get(this).GetWorldInfo().GetZIndex()}get isCollisionEnabled(){return map.get(this).GetWorldInfo().IsCollisionEnabled()}set isCollisionEnabled(e){map.get(this).GetWorldInfo().SetCollisionEnabled(!!e)}containsPoint(x,
y){C3X.RequireNumber(x);C3X.RequireNumber(y);return map.get(this).GetWorldInfo().ContainsPoint(+x,+y)}testOverlap(worldInstance){C3X.RequireInstanceOf(worldInstance,IWorldInstance);const a=map.get(this);const b=map.get(worldInstance);return a.GetRuntime().GetCollisionEngine().TestOverlap(a,b)}testOverlapSolid(){const inst=map.get(this);const overlapInst=inst.GetRuntime().GetCollisionEngine().TestOverlapSolid(inst);return overlapInst?overlapInst.GetInterfaceClass():null}getParent(){const parent=map.get(this).GetParent();
return parent?parent.GetInterfaceClass():null}getTopParent(){const parent=map.get(this).GetTopParent();return parent?parent.GetInterfaceClass():null}*parents(){for(const parent of map.get(this).parents())yield parent.GetInterfaceClass()}getChildCount(){return map.get(this).GetChildCount()}getChildAt(index){const child=map.get(this).GetChildAt(index);return child?child.GetInterfaceClass():null}*children(){for(const child of map.get(this).children())yield child.GetInterfaceClass()}*allChildren(){for(const child of map.get(this).allChildren())yield child.GetInterfaceClass()}addChild(ichild,
opts){C3X.RequireInstanceOf(ichild,IWorldInstance);C3X.RequireOptionalObject(opts);if(!opts)opts={};const inst=map.get(this);const child=map.get(ichild);inst.AddChild(child,opts)}removeChild(ichild){C3X.RequireInstanceOf(ichild,IWorldInstance);const inst=map.get(this);const child=map.get(ichild);inst.RemoveChild(child)}removeFromParent(){const inst=map.get(this);if(!inst.HasParent())return;const parent=inst.GetParent();parent.RemoveChild(inst)}createMesh(hsize,vsize){C3X.RequireFiniteNumber(hsize);
C3X.RequireFiniteNumber(vsize);map.get(this).GetWorldInfo().CreateMesh(hsize,vsize)}releaseMesh(){const wi=map.get(this).GetWorldInfo();wi.ReleaseMesh();wi.SetBboxChanged()}setMeshPoint(col,row,opts){C3X.RequireFiniteNumber(col);C3X.RequireFiniteNumber(row);C3X.RequireObject(opts);const wi=map.get(this).GetWorldInfo();if(wi.SetMeshPoint(col,row,opts))wi.SetBboxChanged()}getMeshSize(){const wi=map.get(this).GetWorldInfo();if(!wi.HasMesh())return[0,0];const sourceMesh=wi.GetSourceMesh();return[sourceMesh.GetHSize(),
sourceMesh.GetVSize()]}};

}

// interfaces/IDOMInstance.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.IDOMInstance=class IDOMInstance extends self.IWorldInstance{constructor(){super();map.set(this,self.IInstance._GetInitInst())}getElement(){return map.get(this).GetSdkInstance()._GetElementInDOMMode()}focus(){map.get(this).GetSdkInstance().FocusElement()}blur(){map.get(this).GetSdkInstance().BlurElement()}setCssStyle(prop,val){C3X.RequireString(prop);map.get(this).GetSdkInstance().SetElementCSSStyle(prop,val)}};

}

// interfaces/IBehaviorInstance.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;const dispatchers=new WeakMap;function GetDispatcher(ibehinst){let dispatcher=dispatchers.get(ibehinst);if(dispatcher)return dispatcher;dispatcher=C3.New(C3.Event.Dispatcher);dispatchers.set(ibehinst,dispatcher);return dispatcher}let initBehInst=null;
self.IBehaviorInstance=class IBehaviorInstance{constructor(){map.set(this,initBehInst);const descriptors={runtime:{value:initBehInst.GetRuntime().GetIRuntime(),writable:false},behavior:{value:initBehInst.GetBehavior().GetIBehavior(),writable:false}};Object.defineProperties(this,descriptors)}static _Init(behInst){initBehInst=behInst}static _GetInitInst(){return initBehInst}get instance(){return map.get(this).GetObjectInstance().GetInterfaceClass()}_Release(){const dispatcher=dispatchers.get(this);
if(dispatcher){dispatcher.Release();dispatchers.delete(this)}map.delete(this)}addEventListener(type,func,capture){C3X.RequireString(type);C3X.RequireFunction(func);GetDispatcher(this).addEventListener(type,func,capture)}removeEventListener(type,func,capture){C3X.RequireString(type);C3X.RequireFunction(func);GetDispatcher(this).removeEventListener(type,func,capture)}dispatchEvent(e){GetDispatcher(this).dispatchEvent(e)}};

}

// interfaces/IBehavior.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.IBehavior=class IBehavior{constructor(behavior){map.set(this,behavior);const descriptors={runtime:{value:behavior.GetRuntime().GetIRuntime(),writable:false}};Object.defineProperties(this,descriptors)}getAllInstances(){return map.get(this).GetInstances().map(inst=>inst.GetInterfaceClass())}};

}

// interfaces/IEffectInstance.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;const tempColor=C3.New(C3.Color);
self.IEffectInstance=class IEffectInstance{constructor(effectList,index){map.set(this,effectList);const descriptors={index:{value:index,writable:false}};Object.defineProperties(this,descriptors)}get name(){const effectTypes=map.get(this).GetAllEffectTypes();return effectTypes[this.index].GetName()}get isActive(){return map.get(this).IsEffectIndexActive(this.index)}set isActive(a){a=!!a;const fxList=map.get(this);if(fxList.IsEffectIndexActive(this.index)===a)return;fxList.SetEffectIndexActive(this.index,
a);fxList.UpdateActiveEffects();fxList.GetRuntime().UpdateRender()}setParameter(i,v){C3X.RequireFiniteNumber(i);i=Math.floor(+i);const fxList=map.get(this);const oldValue=fxList.GetEffectParameter(this.index,i);if(oldValue===null)throw new RangeError("invalid index");if(oldValue instanceof C3.Color){if(!Array.isArray(v)||v.length<3)throw new TypeError("expected array with 3 elements");tempColor.setRgb(v[0],v[1],v[2]);v=tempColor}else if(typeof v!=="number")throw new TypeError("expected number");const didChange=
fxList.SetEffectParameter(this.index,i,v);if(didChange&&fxList.IsEffectIndexActive(this.index))fxList.GetRuntime().UpdateRender()}getParameter(i){C3X.RequireFiniteNumber(i);i=Math.floor(+i);const fxList=map.get(this);const ret=fxList.GetEffectParameter(this.index,i);if(ret===null)throw new RangeError("invalid index");if(ret instanceof C3.Color)return[ret.getR(),ret.getG(),ret.getB()];else return ret}};

}

// interfaces/IAnimation.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;
self.IAnimation=class IAnimation{constructor(animationInfo){map.set(this,animationInfo);Object.defineProperties(this,{name:{value:animationInfo.GetName(),writable:false},speed:{value:animationInfo.GetSpeed(),writable:false},isLooping:{value:animationInfo.IsLooping(),writable:false},repeatCount:{value:animationInfo.GetRepeatCount(),writable:false},repeatTo:{value:animationInfo.GetRepeatTo(),writable:false},isPingPong:{value:animationInfo.IsPingPong(),writable:false},frameCount:{value:animationInfo.GetFrameCount(),
writable:false}})}getFrames(){return map.get(this).GetFrames().map(f=>f.GetIAnimationFrame())}*frames(){for(const f of map.get(this).GetFrames())yield f.GetIAnimationFrame()}};

}

// interfaces/IImageInfo.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.IImageInfo=class IImageInfo{constructor(imageInfo){map.set(this,imageInfo)}get width(){return map.get(this).GetWidth()}get height(){return map.get(this).GetHeight()}getSize(){const imageInfo=map.get(this);return[imageInfo.GetWidth(),imageInfo.GetHeight()]}};

}

// interfaces/IAnimationFrame.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;
self.IAnimationFrame=class IAnimationFrame extends self.IImageInfo{constructor(animationFrameInfo){super(animationFrameInfo.GetImageInfo());map.set(this,animationFrameInfo);Object.defineProperties(this,{duration:{value:animationFrameInfo.GetDuration(),writable:false},originX:{value:animationFrameInfo.GetOriginX(),writable:false},originY:{value:animationFrameInfo.GetOriginY(),writable:false}})}getOrigin(){const afi=map.get(this);return[afi.GetOriginX(),afi.GetOriginY()]}getImagePointCount(){return map.get(this).GetImagePointCount()}getImagePointX(nameOrIndex){return this.getImagePoint(nameOrIndex)[0]}getImagePointY(nameOrIndex){return this.getImagePoint(nameOrIndex)[1]}getImagePoint(nameOrIndex){const afi=
map.get(this);let ip=null;if(typeof nameOrIndex==="number")ip=afi.GetImagePointByIndex(Math.floor(nameOrIndex));else if(typeof nameOrIndex==="string")ip=afi.GetImagePointByName(nameOrIndex);else throw new TypeError("expected string or number");if(!ip)return this.getOrigin();return[ip.GetX(),ip.GetY()]}getPolyPointCount(){const poly=map.get(this).GetCollisionPoly();return poly?poly.pointCount():0}getPolyPointX(index){return this.getPolyPoint(index)[0]}getPolyPointY(index){return this.getPolyPoint(index)[1]}getPolyPoint(index){C3X.RequireFiniteNumber(index);
index=Math.floor(index);const poly=map.get(this).GetCollisionPoly();if(!poly||index<0||index>=poly.pointCount())return[0,0];const pointsArr=poly.pointsArr();const ptX=pointsArr[index*2];const ptY=pointsArr[index*2+1];return[ptX,ptY]}};

}

// interfaces/ITimelineState.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;function GetTimelineState(iface){const timelineState=map.get(iface);if(timelineState.IsReleased())throw new Error("timeline/tween was released and is no longer valid");return timelineState}
self.ITimelineState=class ITimelineState{constructor(timelineState){map.set(this,timelineState)}pause(){GetTimelineState(this).Stop()}resume(){GetTimelineState(this).Resume()}hasTags(tags){return GetTimelineState(this).HasTags(tags)}set time(t){C3X.RequireFiniteNumber(t);GetTimelineState(this).SetTime(t)}get time(){return GetTimelineState(this).GetTime()}set totalTime(t){C3X.RequireFiniteNumber(t);GetTimelineState(this).SetTotalTime(t)}get totalTime(){return GetTimelineState(this).GetTotalTime()}set isLooping(l){GetTimelineState(this).SetLoop(!!l)}get isLooping(){return GetTimelineState(this).GetLoop()}set isPingPong(p){GetTimelineState(this).SetPingPong(!!p)}get isPingPong(){return GetTimelineState(this).GetPingPong()}set playbackRate(p){C3X.RequireFiniteNumber(p);
GetTimelineState(this).SetPlaybackRate(p)}get playbackRate(){return GetTimelineState(this).GetPlaybackRate()}get progress(){const timelineState=GetTimelineState(this);return timelineState.GetTime()/timelineState.GetTotalTime()}get tags(){return GetTimelineState(this).GetTags()}get finished(){return GetTimelineState(this).GetPlayPromise()}get isPlaying(){return GetTimelineState(this).IsPlaying()}get isPaused(){return GetTimelineState(this).IsPaused()}get isReleased(){return map.get(this).IsReleased()}};

}

// interfaces/ITweenState.js
{
'use strict';const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;const behInstMap=new WeakMap;let easeToIndexFunc=null;function GetTweenState(iface){const tweenState=map.get(iface);if(tweenState.IsReleased())throw new Error("timeline/tween was released and is no longer valid");return tweenState}
self.ITweenState=class ITweenState extends self.ITimelineState{constructor(tweenState,behInst,opts){super(tweenState);if(!easeToIndexFunc)easeToIndexFunc=opts.easeToIndexFunc;map.set(this,tweenState);if(behInst)behInstMap.set(this,behInst)}stop(){const tweenState=GetTweenState(this);const behInst=behInstMap.get(this);behInst.ReleaseTween(tweenState)}setEase(easeName){C3X.RequireString(easeName);const ease=self.Ease.GetEaseFromIndex(easeToIndexFunc(easeName));GetTweenState(this).SetEase(ease)}get instance(){const inst=
GetTweenState(this).GetInstance();return inst?inst.GetInterfaceClass():null}get isDestroyOnComplete(){return GetTweenState(this).GetDestroyInstanceOnComplete()}set isDestroyOnComplete(d){GetTweenState(this).SetDestroyInstanceOnComplete(!!d)}get value(){const tweenState=GetTweenState(this);if(tweenState.GetId()!=="value")throw new Error("not a value tween");return tweenState.GetPropertyTrack("value").GetSourceAdapterValue()}};

}

// assets/assetManager.js
{
'use strict';const C3=self.C3;const VALID_LOAD_POLICIES=new Set(["local","remote"]);const EXT_TO_TYPE=new Map([["mp4","video/mp4"],["webm","video/webm"],["m4a","audio/mp4"],["mp3","audio/mpeg"],["js","application/javascript"],["wasm","application/wasm"],["svg","image/svg+xml"],["html","text/html"]]);function GetTypeFromFileExtension(filename){if(!filename)return"";const parts=filename.split(".");if(parts.length<2)return"";const ext=parts.at(-1).toLowerCase();return EXT_TO_TYPE.get(ext)||""}
function AddScript(url){return new Promise((resolve,reject)=>{const elem=document.createElement("script");elem.onload=resolve;elem.onerror=reject;elem.async=false;elem.type="module";elem.src=url;document.head.appendChild(elem)})}
C3.AssetManager=class AssetManager extends C3.DefendedBase{constructor(runtime,opts){super();const exportType=opts["exportType"];this._runtime=runtime;this._fileStructure="folders";this._localUrlBlobs=new Map;this._localBlobUrlCache=new Map;this._localBlobSWUrls=new Map;this._isCordova=exportType==="cordova";this._isiOSCordova=!!opts["isiOSCordova"];this._isFileProtocol=!!opts["isFileProtocol"];this._swClientId=opts["swClientId"];this._supportedAudioFormats=opts["supportedAudioFormats"]||{};this._audioFiles=
new Map;this._preloadSounds=false;this._mediaSubfolder="";this._fontsSubfolder="";this._iconsSubfolder="";const isRemoteLoadPolicy=exportType==="html5"||exportType==="scirra-arcade"||exportType==="instant-games";this._defaultLoadPolicy=isRemoteLoadPolicy?"remote":"local";this._allAssets=[];this._assetsByUrl=new Map;this._webFonts=[];this._loadPromises=[];this._hasFinishedInitialLoad=false;this._totalAssetSizeToLoad=0;this._assetSizeLoaded=0;this._lastLoadProgress=0;this._hasHadErrorLoading=false;
this._loadingRateLimiter=C3.New(C3.RateLimiter,()=>this._FireLoadingProgressEvent(),50);this._promiseThrottle=new C3.PromiseThrottle(Math.max(C3.hardwareConcurrency,8));const localUrlBlobs=opts["previewImageBlobs"];if(localUrlBlobs){const projectFileBlobs=opts["previewProjectFileBlobs"];if(projectFileBlobs)Object.assign(localUrlBlobs,projectFileBlobs);const projectData=opts["projectData"];if(projectData)localUrlBlobs["data.json"]=projectData;for(const [url,blob]of Object.entries(localUrlBlobs))this._localUrlBlobs.set(url,
blob)}const localSWUrlMap=opts["previewProjectFileSWUrls"];if(localSWUrlMap)for(const [srcUrl,destUrl]of Object.entries(localSWUrlMap))this._localBlobSWUrls.set(srcUrl,destUrl);this._iAssetManager=new self.IAssetManager(this)}Release(){this._localUrlBlobs.clear();for(const url of this._localBlobUrlCache.values())if(url.startsWith("blob:"))URL.revokeObjectURL(url);this._localBlobUrlCache.clear();for(const asset of this._allAssets)asset.Release();C3.clearArray(this._allAssets);this._assetsByUrl.clear();
C3.clearArray(this._loadPromises);this._runtime=null}GetRuntime(){return this._runtime}_SetFileStructure(f){this._fileStructure=f;if(f==="flat"){const newMap=new Map;for(const [url,blob]of this._localUrlBlobs.entries())newMap.set(url.toLowerCase(),blob);this._localUrlBlobs=newMap}}GetFileStructure(){return this._fileStructure}_SetMediaSubfolder(folder){this._mediaSubfolder=folder}GetMediaSubfolder(){return this._mediaSubfolder}_SetFontsSubfolder(folder){this._fontsSubfolder=folder}GetFontsSubfolder(){return this._fontsSubfolder}_SetIconsSubfolder(folder){this._iconsSubfolder=
folder}GetIconsSubfolder(){return this._iconsSubfolder}IsFileProtocol(){return this._isFileProtocol}_HasLocalUrlBlob(url){if(this._fileStructure==="flat")url=url.toLowerCase();return this._localUrlBlobs.has(url)}_GetLocalUrlBlob(url){if(this._fileStructure==="flat")url=url.toLowerCase();return this._localUrlBlobs.get(url)||null}GetLocalUrlAsBlobUrl(url){if(this._fileStructure==="flat")url=url.toLowerCase();if(!this._HasLocalUrlBlob(url))return url;let ret=this._localBlobUrlCache.get(url);if(!ret){const blob=
this._GetLocalUrlBlob(url);ret=URL.createObjectURL(blob);this._localBlobUrlCache.set(url,ret)}return ret}FetchBlob(url,loadPolicy){loadPolicy=loadPolicy||this._defaultLoadPolicy;const localBlob=this._GetLocalUrlBlob(url);if(localBlob)return Promise.resolve(localBlob);else if(C3.IsRelativeURL(url)){if(this._fileStructure==="flat")url=url.toLowerCase();if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsBlob(url);else if(loadPolicy==="local")return this._promiseThrottle.Add(()=>
C3.FetchBlob(url));else return C3.FetchBlob(url)}else return C3.FetchBlob(url)}FetchArrayBuffer(url){const localBlob=this._GetLocalUrlBlob(url);if(localBlob)return C3.BlobToArrayBuffer(localBlob);else if(C3.IsRelativeURL(url)){if(this._fileStructure==="flat")url=url.toLowerCase();if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsArrayBuffer(url);else if(this._defaultLoadPolicy==="local")return this._promiseThrottle.Add(()=>C3.FetchArrayBuffer(url));else return C3.FetchArrayBuffer(url)}else return C3.FetchArrayBuffer(url)}FetchText(url){const localBlob=
this._GetLocalUrlBlob(url);if(localBlob)return C3.BlobToString(localBlob);else if(C3.IsRelativeURL(url)){if(this._fileStructure==="flat")url=url.toLowerCase();if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsText(url);else if(this._defaultLoadPolicy==="local")return this._promiseThrottle.Add(()=>C3.FetchText(url));else return C3.FetchText(url)}else return C3.FetchText(url)}async FetchJson(url){const text=await this.FetchText(url);return JSON.parse(text)}_CordovaFetchLocalFileAs(filename,
as_){if(this._fileStructure==="flat")filename=filename.toLowerCase();return this._runtime.PostComponentMessageToDOMAsync("runtime","cordova-fetch-local-file",{"filename":filename,"as":as_})}CordovaFetchLocalFileAsText(filename){return this._CordovaFetchLocalFileAs(filename,"text")}async CordovaFetchLocalFileAsBlob(filename){const buffer=await this._CordovaFetchLocalFileAs(filename,"buffer");const type=GetTypeFromFileExtension(filename);return new Blob([buffer],{"type":type})}async CordovaFetchLocalFileAsBlobURL(filename){if(this._fileStructure===
"flat")filename=filename.toLowerCase();let blobUrl=this._localBlobUrlCache.get(filename);if(blobUrl)return blobUrl;const blob=await this.CordovaFetchLocalFileAsBlob(filename);blobUrl=URL.createObjectURL(blob);this._localBlobUrlCache.set(filename,blobUrl);return blobUrl}CordovaFetchLocalFileAsArrayBuffer(filename){return this._CordovaFetchLocalFileAs(filename,"buffer")}GetMediaFileUrl(filename){if(this._fileStructure==="flat")filename=filename.toLowerCase();filename=this._mediaSubfolder+filename;if(this._HasLocalUrlBlob(filename))return this.GetLocalUrlAsBlobUrl(filename);
else return filename}GetProjectFileUrl(url){if(C3.IsAbsoluteURL(url))return Promise.resolve(url);else if(this._HasLocalUrlBlob(url))return Promise.resolve(this.GetLocalUrlAsBlobUrl(url));else if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsBlobURL(url);else{if(this._fileStructure==="flat")url=url.toLowerCase();return Promise.resolve(url)}}GetProjectFileIframeUrl(url){if(C3.IsAbsoluteURL(url))return Promise.resolve(url);else{const queryIndex=url.indexOf("?");const queryStr=
queryIndex===-1?"":url.substr(queryIndex);const urlNoSearch=queryIndex===-1?url:url.substr(0,queryIndex);if(this._HasLocalUrlBlob(urlNoSearch)){let localUrl=this._localBlobSWUrls.get(urlNoSearch)||this.GetLocalUrlAsBlobUrl(urlNoSearch);if(!localUrl.startsWith("blob:")&&this._swClientId){const asUrl=new URL(localUrl);const params=new URLSearchParams(queryStr);params.set("__c3_client_id",this._swClientId);asUrl.search=params.toString();localUrl=asUrl.toString()}return Promise.resolve(localUrl)}else if(this._isCordova&&
this._isFileProtocol)return this.CordovaFetchLocalFileAsBlobURL(urlNoSearch);else{if(this._fileStructure==="flat")url=url.toLowerCase();return Promise.resolve(url)}}}LoadProjectFileUrl(url){return this.GetProjectFileUrl(url)}LoadImage(opts){if(opts.loadPolicy&&!VALID_LOAD_POLICIES.has(opts.loadPolicy))throw new Error("invalid load policy");let asset=this._assetsByUrl.get(opts.url);if(asset)return asset;asset=C3.New(C3.ImageAsset,this,{url:opts.url,size:opts.size||0,loadPolicy:opts.loadPolicy||this._defaultLoadPolicy});
this._allAssets.push(asset);this._assetsByUrl.set(asset.GetURL(),asset);if(!this._hasFinishedInitialLoad){this._totalAssetSizeToLoad+=asset.GetSize();this._loadPromises.push(asset.Load().then(()=>this._AddLoadedSize(asset.GetSize())))}return asset}async WaitForAllToLoad(){try{await Promise.all(this._loadPromises);this._lastLoadProgress=1}catch(err){console.error("Error loading: ",err);this._hasHadErrorLoading=true;this._FireLoadingProgressEvent()}}SetInitialLoadFinished(){this._hasFinishedInitialLoad=
true}HasHadErrorLoading(){return this._hasHadErrorLoading}_AddLoadedSize(s){this._assetSizeLoaded+=s;this._loadingRateLimiter.Call()}_FireLoadingProgressEvent(){const event=C3.New(C3.Event,"loadingprogress");this._lastLoadProgress=C3.clamp(this._assetSizeLoaded/this._totalAssetSizeToLoad,0,1);event.progress=this._lastLoadProgress;this._runtime.Dispatcher().dispatchEvent(event)}GetLoadProgress(){return this._lastLoadProgress}_SetWebFonts(arr){C3.shallowAssignArray(this._webFonts,arr);if(this._webFonts.length)this._loadPromises.push(this._LoadWebFonts())}async _LoadWebFonts(){const promises=
[];const loadFontsForDOM=[];for(const [name,filename,size]of this._webFonts){this._totalAssetSizeToLoad+=size;promises.push(this._LoadWebFont(name,filename,loadFontsForDOM).then(()=>this._AddLoadedSize(size)))}await Promise.all(promises);if(this._runtime.IsInWorker()&&loadFontsForDOM.length>0)await this._runtime.PostComponentMessageToDOMAsync("runtime","load-webfonts",{"webfonts":loadFontsForDOM})}async _LoadWebFont(name,filename,loadFontsForDOM){try{const url=await this.GetProjectFileUrl(filename);
const fontFace=new FontFace(name,`url('${url}')`);if(this._runtime.IsInWorker())self.fonts.add(fontFace);else document.fonts.add(fontFace);await fontFace.load();if(this._runtime.IsInWorker())loadFontsForDOM.push({name,url})}catch(err){console.warn(`[C3 runtime] Failed to load web font '${name}': `,err)}}IsAudioFormatSupported(type){return!!this._supportedAudioFormats[type]}_SetAudioFiles(arr,preloadSounds){this._preloadSounds=!!preloadSounds;for(const [fileName,projectFilesInfo,isMusic]of arr)this._audioFiles.set(fileName,
{fileName,formats:projectFilesInfo.map(si=>({type:si[0],fileExtension:si[1],fullName:fileName+si[1],fileSize:si[2]})),isMusic})}GetPreferredAudioFile(namePart){if(this._fileStructure==="flat")namePart=namePart.toLowerCase();const info=this._audioFiles.get(namePart);if(!info)return null;let webMOpusFile=null;for(const formatInfo of info.formats){if(!webMOpusFile&&formatInfo.type==="audio/webm; codecs=opus")webMOpusFile=formatInfo;if(this.IsAudioFormatSupported(formatInfo.type))return formatInfo}return webMOpusFile}GetProjectAudioFileUrl(namePart){const formatInfo=
this.GetPreferredAudioFile(namePart);if(!formatInfo)return null;return{url:this.GetMediaFileUrl(formatInfo.fullName),type:formatInfo.type}}GetAudioToPreload(){if(this._preloadSounds){const ret=[];for(const info of this._audioFiles.values()){if(info.isMusic)continue;const formatInfo=this.GetPreferredAudioFile(info.fileName);if(!formatInfo)continue;ret.push({originalUrl:info.fileName,url:this.GetMediaFileUrl(formatInfo.fullName),type:formatInfo.type,fileSize:formatInfo.fileSize})}return ret}else return[]}GetIAssetManager(){return this._iAssetManager}async LoadScripts(...urls){const scriptUrls=
await Promise.all(urls.map(url=>this.GetProjectFileUrl(url)));if(this._runtime.IsInWorker())if(urls.length===1){const url=urls[0];await self.c3_import((C3.IsRelativeURL(url)?"./":"")+url)}else{const scriptStr=urls.map(url=>`import "${C3.IsRelativeURL(url)?"./":""}${url}";`).join("\n");const blobUrl=URL.createObjectURL(new Blob([scriptStr],{type:"application/javascript"}));await self.c3_import(blobUrl)}else await Promise.all(scriptUrls.map(url=>AddScript(url)))}async CompileWebAssembly(url){if(WebAssembly.compileStreaming){const fetchUrl=
await this.GetProjectFileUrl(url);return await WebAssembly.compileStreaming(fetch(fetchUrl))}else{const arrayBuffer=await C3.FetchArrayBuffer(url);return await WebAssembly.compile(arrayBuffer)}}async LoadStyleSheet(url){const fetchUrl=await this.GetProjectFileUrl(url);return await this._runtime.PostComponentMessageToDOMAsync("runtime","add-stylesheet",{"url":fetchUrl})}};

}

// assets/asset.js
{
'use strict';const C3=self.C3;
C3.Asset=class Asset extends C3.DefendedBase{constructor(assetManager,opts){super();this._assetManager=assetManager;this._runtime=assetManager.GetRuntime();this._url=opts.url||"";this._size=opts.size;this._loadPolicy=opts.loadPolicy;this._blob=opts.blob||null;this._isLoaded=!!this._blob;this._loadPromise=null}Release(){this._loadPromise=null;this._assetManager=null;this._runtime=null;this._blob=null}GetURL(){return this._url}GetSize(){return this._size}Load(){if(this._loadPolicy==="local"||this._blob){this._isLoaded=
true;return Promise.resolve()}if(this._loadPromise)return this._loadPromise;this._loadPromise=this._assetManager.FetchBlob(this._url,this._loadPolicy).then(blob=>{this._isLoaded=true;this._loadPromise=null;this._blob=blob;return blob}).catch(err=>console.error("Error loading resource: ",err));return this._loadPromise}IsLoaded(){return this._isLoaded}GetBlob(){if(this._blob)return Promise.resolve(this._blob);if(this._loadPromise)return this._loadPromise;return this._assetManager.FetchBlob(this._url,
this._loadPolicy)}};

}

// assets/imageAsset.js
{
'use strict';const C3=self.C3;const promiseThrottle=new C3.PromiseThrottle;const allImageAssets=new Set;
C3.ImageAsset=class ImageAsset extends C3.Asset{constructor(assetManager,opts){super(assetManager,opts);this._texturePromise=null;this._webglTexture=null;this._refCount=0;this._imageWidth=-1;this._imageHeight=-1;allImageAssets.add(this)}Release(){this.ReleaseTexture();if(this._refCount!==0)throw new Error("released image asset which still has texture references");this._texturePromise=null;allImageAssets.delete(this);super.Release()}static OnRendererContextLost(){for(const imageAsset of allImageAssets){imageAsset._texturePromise=
null;imageAsset._webglTexture=null;imageAsset._refCount=0}}LoadStaticTexture(renderer,opts){opts=opts||{};this._refCount++;if(this._webglTexture)return Promise.resolve(this._webglTexture);if(this._texturePromise)return this._texturePromise;opts.anisotropy=this._runtime.GetCanvasManager().GetTextureAnisotropy();this._texturePromise=this.GetBlob().then(blob=>promiseThrottle.Add(()=>renderer.CreateStaticTextureAsync(blob,opts).then(texture=>{this._texturePromise=null;if(this._refCount===0){renderer.DeleteTexture(texture);
return null}this._webglTexture=texture;this._imageWidth=texture.GetWidth();this._imageHeight=texture.GetHeight();return this._webglTexture}))).catch(err=>{console.error("Failed to load texture: ",err);throw err;});return this._texturePromise}ReleaseTexture(){if(this._refCount<=0)throw new Error("texture released too many times");this._refCount--;if(this._refCount===0&&this._webglTexture){const renderer=this._webglTexture.GetRenderer();renderer.DeleteTexture(this._webglTexture);this._webglTexture=
null}}GetTexture(){return this._webglTexture}GetWidth(){return this._imageWidth}GetHeight(){return this._imageHeight}async LoadToDrawable(){const blob=await this.GetBlob();if(C3.Supports.ImageBitmapOptions)return await createImageBitmap(blob,{"premultiplyAlpha":"none"});else if(C3.Supports.ImageBitmap)return await createImageBitmap(blob);else return await C3.BlobToImage(blob)}};

}

// layouts/renderCell.js
{
'use strict';const C3=self.C3;const assert=self.assert;function SortByInstLastCachedZIndex(a,b){return a.GetWorldInfo()._GetLastCachedZIndex()-b.GetWorldInfo()._GetLastCachedZIndex()}
C3.RenderCell=class RenderCell extends C3.DefendedBase{constructor(grid,x,y){super();this._grid=grid;this._x=x;this._y=y;this._instances=[];this._isSorted=true;this._pendingRemoval=new Set;this._isAnyPendingRemoval=false}Release(){C3.clearArray(this._instances);this._pendingRemoval.clear();this._grid=null}Reset(){C3.clearArray(this._instances);this._isSorted=true;this._pendingRemoval.clear();this._isAnyPendingRemoval=false}SetChanged(){this._isSorted=false}IsEmpty(){if(!this._instances.length)return true;
if(this._instances.length>this._pendingRemoval.size)return false;this._FlushPending();return true}Insert(inst){if(this._pendingRemoval.has(inst)){this._pendingRemoval.delete(inst);if(this._pendingRemoval.size===0)this._isAnyPendingRemoval=false;return}this._instances.push(inst);this._isSorted=this._instances.length===1}Remove(inst){this._pendingRemoval.add(inst);this._isAnyPendingRemoval=true;if(this._pendingRemoval.size>=50)this._FlushPending()}_FlushPending(){if(!this._isAnyPendingRemoval)return;
if(this._instances.length===this._pendingRemoval.size){this.Reset();return}C3.arrayRemoveAllInSet(this._instances,this._pendingRemoval);this._pendingRemoval.clear();this._isAnyPendingRemoval=false}_EnsureSorted(){if(this._isSorted)return;this._instances.sort(SortByInstLastCachedZIndex);this._isSorted=true}Dump(result){this._FlushPending();this._EnsureSorted();if(this._instances.length)result.push(this._instances)}};

}

// layouts/renderGrid.js
{
'use strict';const C3=self.C3;
C3.RenderGrid=class RenderGrid extends C3.DefendedBase{constructor(cellWidth,cellHeight){super();this._cellWidth=cellWidth;this._cellHeight=cellHeight;this._cells=C3.New(C3.PairMap)}Release(){this._cells.Release();this._cells=null}GetCell(x,y,createIfMissing){let ret=this._cells.Get(x,y);if(ret)return ret;else if(createIfMissing){ret=C3.New(C3.RenderCell,this,x,y);this._cells.Set(x,y,ret);return ret}else return null}XToCell(x){return Math.floor(x/this._cellWidth)}YToCell(y){return Math.floor(y/this._cellHeight)}Update(inst,
oldRange,newRange){if(oldRange)for(let x=oldRange.getLeft(),lenx=oldRange.getRight();x<=lenx;++x)for(let y=oldRange.getTop(),leny=oldRange.getBottom();y<=leny;++y){if(newRange&&newRange.containsPoint(x,y))continue;const cell=this.GetCell(x,y,false);if(!cell)continue;cell.Remove(inst);if(cell.IsEmpty())this._cells.Delete(x,y)}if(newRange)for(let x=newRange.getLeft(),lenx=newRange.getRight();x<=lenx;++x)for(let y=newRange.getTop(),leny=newRange.getBottom();y<=leny;++y){if(oldRange&&oldRange.containsPoint(x,
y))continue;this.GetCell(x,y,true).Insert(inst)}}QueryRange(rc,result){let x=this.XToCell(rc.getLeft());const ystart=this.YToCell(rc.getTop());const lenx=this.XToCell(rc.getRight());const leny=this.YToCell(rc.getBottom());for(;x<=lenx;++x)for(let y=ystart;y<=leny;++y){const cell=this.GetCell(x,y,false);if(!cell)continue;cell.Dump(result)}}MarkRangeChanged(rc){let x=rc.getLeft();const ystart=rc.getTop();const lenx=rc.getRight();const leny=rc.getBottom();for(;x<=lenx;++x)for(let y=ystart;y<=leny;++y){const cell=
this.GetCell(x,y,false);if(!cell)continue;cell.SetChanged()}}};

}

// layouts/layer.js
{
'use strict';const C3=self.C3;const tmpRect=new C3.Rect;const tmpQuad=new C3.Quad;const renderCellArr=[];const tmpDestRect=new C3.Rect;const tmpSrcRect=new C3.Rect;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const vec4=glMatrix.vec4;const mat4=glMatrix.mat4;const tempMat4=mat4.create();const tempVec3=vec3.create();const tempVec4=vec4.create();const camVector=vec3.create();const lookVector=vec3.create();const upVector=vec3.create();const tempVec2=C3.New(C3.Vector2);const tempRect=C3.New(C3.Rect);
function SortByInstLastCachedZIndex(a,b){return a.GetWorldInfo()._GetLastCachedZIndex()-b.GetWorldInfo()._GetLastCachedZIndex()}function SortByInstZElevation(a,b){return a.GetWorldInfo().GetZElevation()-b.GetWorldInfo().GetZElevation()}const tempInstanceList1=[];const tempInstanceList2=[];const tempInstancesByCameraDist=[];
C3.Layer=class Layer extends C3.DefendedBase{constructor(layout,parentLayer,data){super();this._layout=layout;this._runtime=layout.GetRuntime();this._parentLayer=parentLayer;this._name=data[0];this._index=-1;this._sid=data[2];this._isVisible=!!data[3];this._isInteractive=!!data[13];this._backgroundColor=C3.New(C3.Color);this._backgroundColor.setFromJSON(data[4].map(x=>x/255));this._isTransparent=!!data[5];this._parallaxX=data[6];this._parallaxY=data[7];this._color=C3.New(C3.Color,1,1,1,data[8]);this._premultipliedColor=
C3.New(C3.Color);this._isForceOwnTexture=data[9];this._renderAs3d=data[17];this._useCameraDistanceDrawOrder=data[18];this._useRenderCells=data[10];this._scaleRate=data[11];this._blendMode=data[12];this._curRenderTarget=null;this._scale=1;this._zElevation=data[16];this._angle=0;this._scrollX=0;this._scrollY=0;this._hasOwnScrollPosition=false;this._viewport=C3.New(C3.Rect);this._viewportZ0=C3.New(C3.Rect);this._viewport3D=C3.New(C3.Rect);this._isViewportChanged=true;this._projectionMatrix=mat4.create();
this._isProjectionMatrixChanged=true;this._modelViewMatrix=mat4.create();this._isMVMatrixChanged=true;this._viewFrustum=C3.New(C3.Gfx.ViewFrustum);this._isViewFrustumChanged=true;this._startupInitialInstances=[];this._initialInstancesData=data[14];this._initialInstances=[];this._createdGlobalUids=[];this._initialUIDsToInstanceData=new Map;this._instances=[];this._zIndicesUpToDate=false;this._anyInstanceZElevated=false;const canvasManager=this._runtime.GetCanvasManager();this._effectList=C3.New(C3.EffectList,
this,data[15]);this._effectChain=C3.New(C3.Gfx.EffectChain,canvasManager.GetEffectChainManager(),{drawContent:(renderer,effectChain)=>{const layer=effectChain.GetContentObject();const renderSurface=layer.GetRenderTarget();renderer.SetColor(layer.GetPremultipliedColor());renderer.DrawRenderTarget(renderSurface);renderer.InvalidateRenderTarget(renderSurface);canvasManager.ReleaseAdditionalRenderTarget(renderSurface)},getShaderParameters:index=>this.GetEffectList()._GetEffectChainShaderParametersForIndex(index)});
this._needsRebuildEffectChainSteps=true;this._wasDefaultColor=true;this._renderGrid=null;this._lastRenderList=[];this._isRenderListUpToDate=false;this._lastRenderCells=C3.New(C3.Rect,0,0,-1,-1);this._curRenderCells=C3.New(C3.Rect,0,0,-1,-1);this._iLayer=null;this._UpdatePremultipliedColor();if(this.UsesRenderCells())this._renderGrid=C3.New(C3.RenderGrid,this._runtime.GetOriginalViewportWidth(),this._runtime.GetOriginalViewportHeight());this._subLayers=data[19].map(ld=>C3.New(C3.Layer,this._layout,
this,ld))}_Init(){for(const instData of this._initialInstancesData){const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);this._layout._AddInitialObjectClass(objectClass);if(!objectClass.GetDefaultInstanceData()){objectClass.SetDefaultInstanceData(instData);objectClass._SetDefaultLayerIndex(this._index)}this._initialInstances.push(instData);this._initialUIDsToInstanceData.set(instData[2],instData)}C3.shallowAssignArray(this._startupInitialInstances,this._initialInstances);this._initialInstancesData=
null;this._iLayer=new self.ILayer(this)}Release(){this._layout=null;this._runtime=null}GetInitialInstanceData(uid){return this._initialUIDsToInstanceData.get(uid)}CreateInitialInstances(createdInstances){const isFirstVisit=this._layout.IsFirstVisit();let k=0;const initialInstances=this._initialInstances;for(let i=0,len=initialInstances.length;i<len;++i){const instData=initialInstances[i];const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);let keep=true;if(!objectClass.HasPersistBehavior()||
isFirstVisit){const inst=this._runtime.CreateInstanceFromData(instData,this,true);createdInstances.push(inst);if(objectClass.IsGlobal()){keep=false;this._createdGlobalUids.push(inst.GetUID())}}if(keep){initialInstances[k]=initialInstances[i];++k}}C3.truncateArray(initialInstances,k);this._runtime.FlushPendingInstances();this.SetZIndicesChanged()}_AddInstance(inst,addToGrid){if(!inst.GetPlugin().IsWorldType())throw new Error("instance is not of world type");const wi=inst.GetWorldInfo();if(wi.GetLayer()!==
this)throw new Error("instance added to wrong layer");this._instances.push(inst);if(wi.GetZElevation()!==0)this._anyInstanceZElevated=true;if(addToGrid&&this.UsesRenderCells())inst.GetWorldInfo().SetBboxChanged();this.SetZIndicesChanged()}_MaybeAddInstance(inst){if(this._instances.includes(inst))return;this._instances.push(inst);if(inst.GetWorldInfo().GetZElevation()!==0)this._anyInstanceZElevated=true;this.SetZIndicesChanged()}_PrependInstance(inst,addToGrid){const wi=inst.GetWorldInfo();if(wi.GetLayer()!==
this)throw new Error("instance added to wrong layer");this._instances.unshift(inst);if(wi.GetZElevation()!==0)this._anyInstanceZElevated=true;this.SetZIndicesChanged();if(addToGrid&&this.UsesRenderCells())inst.GetWorldInfo().SetBboxChanged()}_RemoveInstance(inst,removeFromGrid){const index=this._instances.indexOf(inst);if(index<0)return;if(removeFromGrid&&this.UsesRenderCells())inst.GetWorldInfo()._RemoveFromRenderCells();this._instances.splice(index,1);this.SetZIndicesChanged();this._MaybeResetAnyInstanceZElevatedFlag()}_SetAnyInstanceZElevated(){this._anyInstanceZElevated=
true}_MaybeResetAnyInstanceZElevatedFlag(){if(this._instances.length===0)this._anyInstanceZElevated=false}_SortInstancesByLastCachedZIndex(isPersistMode){if(isPersistMode){const assignedZIndices=new Set;for(const inst of this._instances){const cachedZIndex=inst.GetWorldInfo()._GetLastCachedZIndex();if(cachedZIndex>=0)assignedZIndices.add(cachedZIndex)}let index=-1;for(const inst of this._instances){const wi=inst.GetWorldInfo();if(wi._GetLastCachedZIndex()>=0)continue;++index;while(assignedZIndices.has(index))++index;
wi._SetZIndex(index)}}this._instances.sort(SortByInstLastCachedZIndex)}_Start(){}_End(){for(const inst of this._instances)if(!inst.GetObjectClass().IsGlobal())this._runtime.DestroyInstance(inst);this._runtime.FlushPendingInstances();C3.clearArray(this._instances);this._anyInstanceZElevated=false;this.SetZIndicesChanged()}RecreateInitialObjects(objectClass,rc,offsetX,offsetY,createHierarchy){const eventSheetManager=this._runtime.GetEventSheetManager();const allObjectClasses=this._runtime.GetAllObjectClasses();
const isFamily=objectClass.IsFamily();const ret=[];for(const instData of this._initialInstances){const worldData=instData[0];const x=worldData[0];const y=worldData[1];if(!rc.containsPoint(x,y))continue;const objectType=allObjectClasses[instData[1]];if(objectType!==objectClass)if(isFamily){if(!objectClass.FamilyHasMember(objectType))continue}else continue;let createOnLayer=this;const runningLayout=this._runtime.GetCurrentLayout();if(this.GetLayout()!==runningLayout){createOnLayer=runningLayout.GetLayerByName(this.GetName());
if(!createOnLayer)createOnLayer=runningLayout.GetLayerByIndex(this.GetIndex())}const inst=this._runtime.CreateInstanceFromData(instData,createOnLayer,false,undefined,undefined,false,createHierarchy);createOnLayer.SortAndAddInstancesByZIndex(inst);const wi=inst.GetWorldInfo();wi.OffsetXY(offsetX,offsetY);wi.SetBboxChanged();eventSheetManager.BlockFlushingInstances(true);inst._TriggerOnCreatedOnSelfAndRelated();eventSheetManager.BlockFlushingInstances(false);ret.push(inst)}return ret}GetInstanceCount(){return this._instances.length}GetLayout(){return this._layout}GetName(){return this._name}_SetIndex(i){this._index=
i}GetIndex(){return this._index}GetSID(){return this._sid}GetRuntime(){return this._runtime}GetDevicePixelRatio(){return this._runtime.GetDevicePixelRatio()}GetEffectList(){return this._effectList}GetEffectChain(){this._MaybeRebuildEffectChainSteps();return this._effectChain}_MaybeRebuildEffectChainSteps(){const isDefaultColor=this.HasDefaultColor();if(!this._needsRebuildEffectChainSteps&&isDefaultColor===this._wasDefaultColor&&!this._effectChain.NeedsRebuild())return;const activeEffectTypes=this.GetEffectList().GetActiveEffectTypes();
this._effectChain.BuildSteps(activeEffectTypes.map(e=>e.GetShaderProgram()),{indexMap:activeEffectTypes.map(e=>e.GetIndex()),forcePreDraw:!isDefaultColor,useFullSurface:true});this._needsRebuildEffectChainSteps=false;this._wasDefaultColor=isDefaultColor}UpdateActiveEffects(){this.GetEffectList().UpdateActiveEffects();this._needsRebuildEffectChainSteps=true}UsesRenderCells(){return this._useRenderCells&&!this._useCameraDistanceDrawOrder}GetRenderGrid(){return this._renderGrid}SetRenderListStale(){this._isRenderListUpToDate=
false}IsVisible(){for(const layer of this.selfAndParentLayers())if(!layer._IsVisibleFlagSet())return false;return true}_IsVisibleFlagSet(){return this._isVisible}SetVisible(v){v=!!v;if(this._isVisible===v)return;this._isVisible=v;this._runtime.UpdateRender()}SetInteractive(i){this._isInteractive=!!i}IsInteractive(){return this._isInteractive}IsSelfAndParentsInteractive(){for(const layer of this.selfAndParentLayers())if(!layer.IsInteractive())return false;return true}SetOwnScrollPositionEnabled(e){e=
!!e;if(this._hasOwnScrollPosition===e)return;this._hasOwnScrollPosition=e;if(e){const layout=this.GetLayout();this._scrollX=layout.GetScrollX();this._scrollY=layout.GetScrollY()}this._SetMVMatrixChanged();this._runtime.UpdateRender()}IsOwnScrollPositionEnabled(){return this._hasOwnScrollPosition}SetScrollX(x){const layout=this.GetLayout();const lbound=layout.GetScrollLeftBound();const rbound=layout.GetScrollRightBound();if(x>rbound)x=rbound;if(x<lbound)x=lbound;if(this._scrollX!==x){this._scrollX=
x;if(this.IsOwnScrollPositionEnabled()){this._SetMVMatrixChanged();this._runtime.UpdateRender()}}}SetScrollY(y){const layout=this.GetLayout();const ubound=layout.GetScrollTopBound();const bbound=layout.GetScrollBottomBound();if(y>bbound)y=bbound;if(y<ubound)y=ubound;if(this._scrollY!==y){this._scrollY=y;if(this.IsOwnScrollPositionEnabled()){this._SetMVMatrixChanged();this._runtime.UpdateRender()}}}GetScrollX(){if(this.IsOwnScrollPositionEnabled())return this._scrollX;else return this.GetLayout().GetScrollX()}GetScrollY(){if(this.IsOwnScrollPositionEnabled())return this._scrollY;
else return this.GetLayout().GetScrollY()}GetViewport(){this._MaybeUpdateViewport();return this._viewport}_GetViewportZ0(){this._MaybeUpdateViewport();return this._viewportZ0}GetViewport3D(){this._MaybeUpdateViewport();return this._viewport3D}_GetVanishingPoint(){const layout=this.GetLayout();return[layout.GetVanishingPointX(),layout.GetVanishingPointY()]}GetDefaultCameraZ(viewH){return this._runtime.GetDefaultCameraZ(viewH)}GetViewportForZ(z,outRect){const viewportZ0=this._GetViewportZ0();if(z===
0)outRect.copy(viewportZ0);else{let midX=viewportZ0.midX();let midY=viewportZ0.midY();const scaleFactor=this.Get2DScaleFactorToZ(z);const viewW=viewportZ0.width()/scaleFactor;const viewH=viewportZ0.height()/scaleFactor;const [vpX,vpY]=this._GetVanishingPoint();if(vpX!==.5||vpY!==.5){const cameraZ=this.GetCameraZ();const runtime=this._runtime;const zf=this.GetDefaultCameraZ()/cameraZ;let camOffX=(vpX-.5)*runtime.GetViewportWidth()/zf;let camOffY=(vpY-.5)*runtime.GetViewportHeight()/zf;const a=this.GetAngle();
if(a!==0){tempVec2.set(camOffX,camOffY);tempVec2.rotate(a);camOffX=tempVec2.getX();camOffY=tempVec2.getY()}const zProg=C3.unlerp(cameraZ,0,z);midX+=C3.lerp(camOffX,0,zProg);midY+=C3.lerp(camOffY,0,zProg)}outRect.set(midX-viewW/2,midY-viewH/2,midX+viewW/2,midY+viewH/2)}}GetOpacity(){return this._color.getA()}SetOpacity(o){o=C3.clamp(o,0,1);if(this._color.getA()===o)return;this._color.setA(o);this._UpdatePremultipliedColor();this._runtime.UpdateRender()}_UpdatePremultipliedColor(){this._premultipliedColor.copy(this._color);
this._premultipliedColor.premultiply()}GetPremultipliedColor(){return this._premultipliedColor}HasDefaultColor(){return this._color.equalsRgba(1,1,1,1)}GetScaleRate(){return this._scaleRate}SetScaleRate(r){if(this._scaleRate===r)return;this._scaleRate=r;this._SetMVMatrixChanged();this._runtime.UpdateRender()}GetParallaxX(){return this._parallaxX}GetParallaxY(){return this._parallaxY}SetParallax(px,py){if(this._parallaxX===px&&this._parallaxY===py)return;this._parallaxX=px;this._parallaxY=py;this._SetMVMatrixChanged();
this._runtime.UpdateRender();if(this._parallaxX!==1||this._parallaxY!==1)for(const inst of this._instances)inst.GetObjectClass()._SetAnyInstanceParallaxed(true)}SetParallaxX(px){this.SetParallax(px,this.GetParallaxY())}SetParallaxY(py){this.SetParallax(this.GetParallaxX(),py)}SetZElevation(z){if(this._zElevation===z)return;this._zElevation=z;this._runtime.UpdateRender()}GetZElevation(){return this._zElevation}SetAngle(a){a=C3.clampAngle(a);if(this._angle===a)return;this._angle=a;this._SetMVMatrixChanged();
this._runtime.UpdateRender()}GetAngle(){return C3.clampAngle(this._layout.GetAngle()+this._angle)}GetOwnAngle(){return this._angle}HasInstances(){return this._instances.length>0}_GetInstances(){return this._instances}_GetInstancesInDrawOrder(){if(this.RendersIn3DMode()&&this._useCameraDistanceDrawOrder){C3.shallowAssignArray(tempInstancesByCameraDist,this._GetInstances());tempInstancesByCameraDist.sort((a,b)=>this._SortInstancesByCameraDistance(a,b));return tempInstancesByCameraDist}else return this._GetInstances()}_AppendAllInstancesIncludingSubLayersInDrawOrder(arr){C3.appendArray(arr,
this._GetInstancesInDrawOrder());for(const subLayer of this._subLayers)if(subLayer.IsVisible()&&subLayer.GetOpacity()>0)subLayer._AppendAllInstancesIncludingSubLayersInDrawOrder(arr)}_SortInstancesByCameraDistance(a,b){const camVec=this.GetLayout().Get3DCameraPosition();const camX=camVec[0];const camY=camVec[1];const camZ=camVec[2];const wiA=a.GetWorldInfo();const wiB=b.GetWorldInfo();const dxA=wiA.GetX()-camX;const dyA=wiA.GetY()-camY;const dzA=wiA.GetZElevation()-camZ;const dxB=wiB.GetX()-camX;
const dyB=wiB.GetY()-camY;const dzB=wiB.GetZElevation()-camZ;return dxB*dxB+dyB*dyB+dzB*dzB-(dxA*dxA+dyA*dyA+dzA*dzA)}GetBackgroundColor(){return this._backgroundColor}IsTransparent(){return this._isTransparent}SetTransparent(t){t=!!t;if(this._isTransparent===t)return;this._isTransparent=t;this._runtime.UpdateRender()}IsForceOwnTexture(){return this._isForceOwnTexture}SetForceOwnTexture(f){f=!!f;if(this._isForceOwnTexture===f)return;this._isForceOwnTexture=f;this._runtime.UpdateRender()}RendersIn2DMode(){return!this.GetRuntime().Uses3DFeatures()||
!this._renderAs3d}RendersIn3DMode(){return!this.RendersIn2DMode()}Has3DCamera(){return this.RendersIn3DMode()&&this.GetLayout().Is3DCameraEnabled()}SelfAndAllSubLayersHave3DCamera(){if(!this.Has3DCamera())return false;for(const subLayer of this._subLayers)if(!subLayer.SelfAndAllSubLayersHave3DCamera())return false;return true}SetBlendMode(bm){if(this._blendMode===bm)return;this._blendMode=bm;this._runtime.UpdateRender()}GetBlendMode(){return this._blendMode}IsRootLayer(){return!this._parentLayer}GetParentLayer(){return this._parentLayer}GetSubLayers(){return this._subLayers}HasAnySubLayers(){return this._subLayers.length>
0}HasAnyVisibleSubLayer(){for(const subLayer of this._subLayers)if(subLayer.ShouldDraw())return true;return false}*selfAndAllSubLayers(){for(const subLayer of this._subLayers)yield*subLayer.selfAndAllSubLayers();yield this}*parentLayers(){let parentLayer=this.GetParentLayer();while(parentLayer){yield parentLayer;parentLayer=parentLayer.GetParentLayer()}}*selfAndParentLayers(){yield this;yield*this.parentLayers()}IsTransformCompatibleWith(otherLayer){return this===otherLayer||this._parallaxX===otherLayer._parallaxX&&
this._parallaxY===otherLayer._parallaxY&&this._scale===otherLayer._scale&&this._scaleRate===otherLayer._scaleRate&&this._angle===otherLayer._angle&&this.GetScrollX()===otherLayer.GetScrollX()&&this.GetScrollY()===otherLayer.GetScrollY()}SaveTransform(){return{"parallaxX":this.GetParallaxX(),"parallaxY":this.GetParallaxY(),"scale":this.GetOwnScale(),"scaleRate":this.GetScaleRate(),"angle":this.GetOwnAngle(),"hasOwnScroll":this.IsOwnScrollPositionEnabled(),"scrollX":this.GetScrollX(),"scrollY":this.GetScrollY()}}RestoreTransform(t){this.SetParallax(t["parallaxX"],
t["parallaxY"]);this.SetOwnScale(t["scale"]);this.SetScaleRate(t["scaleRate"]);this.SetAngle(t["angle"]);this.SetOwnScrollPositionEnabled(t["hasOwnScroll"]);this.SetScrollX(t["scrollX"]);this.SetScrollY(t["scrollY"]);this._MaybeUpdateViewport()}_RemoveAllInstancesInSet(s){if(s.size===0)return;const numRemoved=C3.arrayRemoveAllInSet(this._instances,s);if(numRemoved>0){this._MaybeResetAnyInstanceZElevatedFlag();this.SetZIndicesChanged()}}SetZIndicesChanged(){this._zIndicesUpToDate=false;this._isRenderListUpToDate=
false}_UpdateZIndices(){if(this._zIndicesUpToDate)return;this._instances.sort(SortByInstZElevation);if(this.UsesRenderCells())for(let i=0,len=this._instances.length;i<len;++i){const wi=this._instances[i].GetWorldInfo();wi._SetZIndex(i);this._renderGrid.MarkRangeChanged(wi.GetRenderCellRange())}else for(let i=0,len=this._instances.length;i<len;++i)this._instances[i].GetWorldInfo()._SetZIndex(i);this._zIndicesUpToDate=true}MoveInstanceAdjacent(inst,other,isAfter){const instWi=inst.GetWorldInfo();const otherWi=
other.GetWorldInfo();if(instWi.GetLayer()!==this||otherWi.GetLayer()!==this)throw new Error("can't arrange Z order unless both objects on this layer");const myZ=instWi.GetZIndex();let insertZ=otherWi.GetZIndex();if(myZ===insertZ+(isAfter?1:-1))return false;C3.arrayRemove(this._instances,myZ);if(myZ<insertZ)insertZ--;if(isAfter)insertZ++;if(insertZ===this._instances.length)this._instances.push(inst);else this._instances.splice(insertZ,0,inst);this.SetZIndicesChanged();return true}_MergeSortedZArrays(a,
b){const ret=[];let i=0,j=0,lena=a.length,lenb=b.length;while(i<lena&&j<lenb){const ai=a[i];const bj=b[j];if(ai.GetWorldInfo()._GetLastCachedZIndex()<bj.GetWorldInfo()._GetLastCachedZIndex()){ret.push(ai);++i}else{ret.push(bj);++j}}for(;i<lena;++i)ret.push(a[i]);for(;j<lenb;++j)ret.push(b[j]);return ret}_MergeAllSortedZArrays_pass(arr){const ret=[];const len=arr.length;for(let i=0;i<len-1;i+=2){const arr1=arr[i];const arr2=arr[i+1];ret.push(this._MergeSortedZArrays(arr1,arr2))}if(len%2===1)ret.push(arr[len-
1]);return ret}_MergeAllSortedZArrays(arr){while(arr.length>1)arr=this._MergeAllSortedZArrays_pass(arr);return arr[0]}_GetRenderCellInstancesToDraw(){this._UpdateZIndices();C3.clearArray(renderCellArr);this._renderGrid.QueryRange(this.GetViewport(),renderCellArr);if(!renderCellArr.length)return[];if(renderCellArr.length===1)return renderCellArr[0];return this._MergeAllSortedZArrays(renderCellArr)}ShouldDraw(){return this.IsVisible()&&this.GetOpacity()>0&&this._DrawsAnyContentInSelfOrSubLayers()}_DrawsAnyContentInSelfOrSubLayers(){if(this.HasInstances()||
!this.IsTransparent())return true;for(const subLayer of this._subLayers)if(subLayer._DrawsAnyContentInSelfOrSubLayers())return true;return false}UsesOwnTexture(){return this.IsForceOwnTexture()||!this.HasDefaultColor()||this.GetBlendMode()!==0||this._effectList.HasAnyActiveEffect()}SelfOrAnySubLayerUsesOwnTexture(){if(this.UsesOwnTexture())return true;for(const subLayer of this._subLayers)if(subLayer.SelfOrAnySubLayerUsesOwnTexture())return true;return false}GetRenderTarget(){return this._curRenderTarget}Get2DScaleFactorToZ(z){if(this._layout.IsOrthographicProjection())return 1;
else{const camZ=this.GetCameraZ();return camZ/(camZ-z)}}GetCameraZ(viewH){return this.GetDefaultCameraZ(viewH)/this.GetNormalScale()}_SetMVMatrixChanged(){this._isMVMatrixChanged=true;this._isViewFrustumChanged=true;this._isViewportChanged=true}_GetModelViewMatrix(renderer){if(this._isMVMatrixChanged){this._CalculateModelViewMatrix(renderer,this._modelViewMatrix,0,0,null);this._isMVMatrixChanged=false}return this._modelViewMatrix}GetCameraPosition(){if(this.Has3DCamera()){const camPos=this.GetLayout().Get3DCameraPosition();
return[camPos[0],camPos[1],camPos[2]]}else return this._Get2DCameraPosition()}_Get2DCameraPosition(offX=0,offY=0,viewH=0){const runtime=this._runtime;const layout=this.GetLayout();const parallaxOriginX=runtime.GetParallaxXOrigin();const parallaxOriginY=runtime.GetParallaxYOrigin();let scrollOriginX=(this.GetScrollX()-parallaxOriginX)*this._parallaxX+parallaxOriginX;let scrollOriginY=(this.GetScrollY()-parallaxOriginY)*this._parallaxY+parallaxOriginY;if(runtime.IsPixelRoundingEnabled()){scrollOriginX=
Math.round(scrollOriginX);scrollOriginY=Math.round(scrollOriginY)}let camX=scrollOriginX+offX;let camY=scrollOriginY+offY;const camZ=layout.IsOrthographicProjection()?this.GetDefaultCameraZ(viewH):this.GetCameraZ(viewH);const [vpX,vpY]=this._GetVanishingPoint();if(vpX!==.5||vpY!==.5){const zf=this.GetDefaultCameraZ(viewH)/camZ;let camOffX=(vpX-.5)*runtime.GetViewportWidth()/zf;let camOffY=(vpY-.5)*runtime.GetViewportHeight()/zf;const a=this.GetAngle();if(a!==0){tempVec2.set(camOffX,camOffY);tempVec2.rotate(a);
camOffX=tempVec2.getX();camOffY=tempVec2.getY()}camX+=camOffX;camY+=camOffY}return[camX,camY,camZ]}_CalculateModelViewMatrix(renderer,outMat,offX,offY,viewH){const runtime=this._runtime;const layout=this.GetLayout();if(this.Has3DCamera()){vec3.copy(camVector,layout.Get3DCameraPosition());vec3.copy(lookVector,layout.Get3DCameraLookAt());vec3.copy(upVector,layout.Get3DCameraUpVector());const parallaxOriginX=runtime.GetParallaxXOrigin();const parallaxOriginY=runtime.GetParallaxYOrigin();const lookDx=
lookVector[0]-camVector[0];const lookDy=lookVector[1]-camVector[1];const lookDz=lookVector[2]-camVector[2];camVector[0]=(camVector[0]-parallaxOriginX)*this._parallaxX+parallaxOriginX;camVector[1]=(camVector[1]-parallaxOriginY)*this._parallaxY+parallaxOriginY;camVector[2]*=Math.max(this._parallaxX,this._parallaxY);lookVector[0]=camVector[0]+lookDx;lookVector[1]=camVector[1]+lookDy;lookVector[2]=camVector[2]+lookDz}else{const [camX,camY,camZ]=this._Get2DCameraPosition(offX,offY,viewH);vec3.set(camVector,
camX,camY,camZ);vec3.set(lookVector,camX,camY,camZ-100);const a=this.GetAngle();if(a===0)vec3.set(upVector,0,1,0);else vec3.set(upVector,Math.sin(a),Math.cos(a),0)}renderer.CalculateLookAtModelView(outMat,camVector,lookVector,upVector,viewH||runtime.GetViewportHeight())}_SetProjectionMatrixChanged(){this._isProjectionMatrixChanged=true;this._isViewFrustumChanged=true;this._isViewportChanged=true}_GetProjectionMatrix(renderer){if(this._isProjectionMatrixChanged){this._CalculateProjectionMatrix(renderer);
this._isProjectionMatrixChanged=false}return this._projectionMatrix}_CalculateProjectionMatrix(renderer){const canvasManager=this._runtime.GetCanvasManager();const [vpX,vpY]=this._GetVanishingPoint();if(this._layout.IsOrthographicProjection())renderer.CalculateOrthographicMatrix(this._projectionMatrix,canvasManager.GetDrawWidth(),canvasManager.GetDrawHeight());else if(vpX===.5&&vpY===.5)mat4.copy(this._projectionMatrix,canvasManager.GetDefaultProjectionMatrix());else{const drawW=canvasManager.GetDrawWidth();
const drawH=canvasManager.GetDrawHeight();renderer.CalculatePerspectiveMatrix(this._projectionMatrix,drawW/drawH,vpX,vpY)}}_SetTransform(renderer,updateProjection=true,offX=0,offY=0,viewH=0){if(updateProjection)renderer.SetProjectionMatrix(this._GetProjectionMatrix(renderer));let modelViewMatrix=null;if(offX===0&&offY===0&&viewH===0)modelViewMatrix=this._GetModelViewMatrix(renderer);else{this._CalculateModelViewMatrix(renderer,tempMat4,offX,offY,viewH);modelViewMatrix=tempMat4}renderer.SetModelViewMatrix(modelViewMatrix)}PrepareForDraw(renderer){this._SetTransform(renderer);
renderer.SetBaseZ(this.GetZElevation())}Draw(renderer,destinationRenderTarget,isFirstToTarget){const canvasManager=this._runtime.GetCanvasManager();const useOwnTexture=this.UsesOwnTexture();let ownRenderTarget=null;let layerQuery=null;if(this._runtime.IsGPUProfiling())if(renderer.IsWebGL()){const timingsBuffer=canvasManager.GetLayerTimingsBuffer(this);if(timingsBuffer){layerQuery=timingsBuffer.AddTimeElapsedQuery();renderer.StartQuery(layerQuery)}}else if(renderer.IsWebGPU())renderer.WriteTimestamp((this.GetIndex()+
1)*2);if(useOwnTexture){const rtOpts={sampling:this._runtime.GetSampling(),isSampled:true,canReadPixels:renderer.IsWebGPU()?this._runtime.UsesAnyBackgroundBlending():false};if(canvasManager.GetCurrentFullscreenScalingQuality()==="low"){rtOpts.width=canvasManager.GetDrawWidth();rtOpts.height=canvasManager.GetDrawHeight()}ownRenderTarget=this._runtime.GetAdditionalRenderTarget(rtOpts);this._curRenderTarget=ownRenderTarget;renderer.SetRenderTarget(ownRenderTarget);if(this.IsTransparent())renderer.ClearRgba(0,
0,0,0)}else{this._curRenderTarget=destinationRenderTarget;renderer.SetRenderTarget(destinationRenderTarget)}if(!this.IsTransparent())renderer.Clear(this._backgroundColor);this._layout._DrawLayerList(renderer,this._curRenderTarget,this._subLayers,useOwnTexture&&this.IsTransparent());this._SetTransform(renderer);renderer.SetBaseZ(this.GetZElevation());renderer.SetDepthEnabled(this.RendersIn3DMode());if(this.GetNormalScale()>Number.EPSILON){this._UpdateZIndices();const useRenderCells=this.UsesRenderCells()&&
this.GetZElevation()===0&&!this._anyInstanceZElevated;if(this.Has3DCamera())this._DrawInstances_3DCamera(renderer);else if(useRenderCells)this._DrawInstances_RenderCells(renderer);else this._DrawInstances(renderer,this._GetInstancesInDrawOrder())}renderer.SetBaseZ(0);renderer.SetCurrentZ(0);if(useOwnTexture){renderer.SetDepthEnabled(false);this._DrawLayerOwnTextureToRenderTarget(renderer,ownRenderTarget,destinationRenderTarget,isFirstToTarget)}if(layerQuery)renderer.EndQuery(layerQuery);if(this._runtime.IsGPUProfiling()&&
renderer.IsWebGPU())renderer.WriteTimestamp((this.GetIndex()+1)*2+1);this._curRenderTarget=null}_DrawInstances(renderer,instances){const viewport=this.GetViewport();const renderTarget=this._curRenderTarget;const isOrthographic=this.GetLayout().IsOrthographicProjection();const hasVanishingPointOutsideViewport=this.GetLayout().HasVanishingPointOutsideViewport();let lastInst=null;for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];if(inst===lastInst)continue;lastInst=inst;const wi=inst.GetWorldInfo();
if(wi.IsVisible()&&wi.IsInViewport(viewport,hasVanishingPointOutsideViewport,isOrthographic))this._DrawInstanceMaybeWithEffects(inst,wi,renderer,renderTarget)}}_DrawInstances_3DCamera(renderer){const renderTarget=this._curRenderTarget;const viewFrustum=this._GetViewFrustum();const coplanarInstances=tempInstanceList1;const postRenderInstances=tempInstanceList2;const instances=this._GetInstancesInDrawOrder();for(let i=0,len=instances.length;i<len;){const inst=instances[i];const wi=inst.GetWorldInfo();
if(!wi.IsVisible()||!wi.IsInViewport3D(viewFrustum)){++i;continue}if(!inst.RendersToOwnZPlane()||wi.GetDepth()>0)postRenderInstances.push(inst);const startZ=inst.GetWorldInfo().GetTotalZElevation();coplanarInstances.push(inst);let endIndex=i+1;for(;endIndex<len;++endIndex){const nextInst=instances[endIndex];const nextWi=nextInst.GetWorldInfo();if(!nextWi.IsVisible()||!nextWi.IsInViewport3D(viewFrustum))continue;if(nextWi.GetTotalZElevation()!==startZ)break;if(!nextInst.RendersToOwnZPlane()){postRenderInstances.push(nextInst);
continue}if(nextWi.GetDepth()>0)postRenderInstances.push(nextInst);coplanarInstances.push(nextInst)}if(coplanarInstances.length===1&&!coplanarInstances[0].MustMitigateZFighting()){this._DrawInstanceMaybeWithEffects(inst,wi,renderer,renderTarget);for(let j=0,lenj=postRenderInstances.length;j<lenj;++j){const postInst=postRenderInstances[j];if(postInst===inst)continue;const postWi=postInst.GetWorldInfo();const postWiLayer=postWi.GetLayer();postWiLayer._DrawInstanceMaybeWithEffects(postInst,postWi,renderer,
renderTarget)}}else{this._DrawCoplanarInstances_3DCamera(renderer,coplanarInstances);for(let j=0,lenj=postRenderInstances.length;j<lenj;++j){const postInst=postRenderInstances[j];const postWi=postInst.GetWorldInfo();postWi._SetDrawNonBackFacesOnly(true);this._DrawInstanceMaybeWithEffects(postInst,postWi,renderer,renderTarget);postWi._SetDrawNonBackFacesOnly(false)}}i=endIndex;C3.clearArray(coplanarInstances);C3.clearArray(postRenderInstances)}}_DrawCoplanarInstances_3DCamera(renderer,instances){const renderTarget=
this._curRenderTarget;renderer.CoplanarStartStencilPass();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];const wi=inst.GetWorldInfo();wi._SetDrawBackFaceOnly(true);this._DrawInstance(inst,wi,renderer)}renderer.CoplanarStartColorPass();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];const wi=inst.GetWorldInfo();this._DrawInstanceMaybeWithEffects(inst,wi,renderer,renderTarget);wi._SetDrawBackFaceOnly(false)}renderer.CoplanarRestoreStandardRendering()}_DrawInstances_RenderCells(renderer){const renderGrid=
this._renderGrid;const curRenderCells=this._curRenderCells;const lastRenderCells=this._lastRenderCells;const viewport=this.GetViewport();let instancesToDraw;curRenderCells.set(renderGrid.XToCell(viewport.getLeft()),renderGrid.YToCell(viewport.getTop()),renderGrid.XToCell(viewport.getRight()),renderGrid.YToCell(viewport.getBottom()));if(!this._isRenderListUpToDate||!curRenderCells.equals(lastRenderCells)){instancesToDraw=this._GetRenderCellInstancesToDraw();this._isRenderListUpToDate=true;lastRenderCells.copy(curRenderCells)}else instancesToDraw=
this._lastRenderList;this._DrawInstances(renderer,instancesToDraw);if(instancesToDraw!==this._lastRenderList)C3.shallowAssignArray(this._lastRenderList,instancesToDraw)}_DrawInstanceMaybeWithEffects(inst,wi,renderer,renderTarget){if(wi.HasAnyActiveEffect())this._DrawInstanceWithEffectsAndRestore(inst,wi,renderer,renderTarget);else this._DrawInstance(inst,wi,renderer)}_DrawInstance(inst,wi,renderer){const wiStateGroup=wi.GetRendererStateGroup();if(renderer.GetCurrentStateGroup()!==wiStateGroup)wiStateGroup.Apply();
inst.Draw(renderer)}_DrawInstanceWithEffectsAndRestore(inst,wi,renderer,renderTarget){if(this._DrawInstanceWithEffects(inst,wi,renderer,renderTarget,null))this._SetTransform(renderer)}_DrawInstanceWithEffects(inst,wi,renderer,renderTarget,opts){const effectChain=wi.GetInstanceEffectList().GetEffectChain();effectChain.Render(renderer,renderTarget,{contentObject:inst,blendMode:wi.GetBlendMode(),devicePixelRatio:this._runtime.GetEffectDevicePixelRatioParam(),time:inst.GetInstanceGameTime(),layerScale:this._runtime.GetEffectLayerScaleParam()*
this.GetNormalScale(),layerAngle:this.GetAngle(),layoutRect:wi.GetBoundingBox(),drawSurfaceRect:effectChain.CanSkipCalculatingDrawSurfaceRect()?null:this._InstanceBoxToDrawSurface(wi),drawContentHook:opts&&opts.drawContentHook,compositOffX:opts&&opts.compositOffX,compositOffY:opts&&opts.compositOffY,updateOwnProjection:opts&&opts.updateOwnProjection});renderer.SetBaseZ(this.GetZElevation());return effectChain.DidChangeTransform()}_DrawLayerOwnTextureToRenderTarget(renderer,ownRenderTarget,destinationRenderTarget,
isFirstToTarget){const activeEffectTypes=this._effectList.GetActiveEffectTypes();const runtime=this._runtime;if(activeEffectTypes.length===0){renderer.SetRenderTarget(destinationRenderTarget);renderer.SetTextureFillMode();if(isFirstToTarget&&this._blendMode===0&&this.HasDefaultColor())renderer.CopyRenderTarget(ownRenderTarget);else{renderer.SetBlendMode(this._blendMode);renderer.SetColor(this._premultipliedColor);renderer.DrawRenderTarget(ownRenderTarget)}renderer.InvalidateRenderTarget(ownRenderTarget);
runtime.ReleaseAdditionalRenderTarget(ownRenderTarget)}else this.GetEffectChain().Render(renderer,destinationRenderTarget,{contentObject:this,blendMode:this.GetBlendMode(),devicePixelRatio:runtime.GetEffectDevicePixelRatioParam(),layerScale:runtime.GetEffectLayerScaleParam()*this.GetNormalScale(),layerAngle:this.GetAngle(),layoutRect:this.GetViewport(),drawSurfaceRect:null,invalidateRenderTargets:true})}GetOwnScale(){return this._scale}SetOwnScale(s){if(this._scale===s)return;this._scale=s;this._layout.BoundScrolling();
this._SetMVMatrixChanged();this._runtime.UpdateRender()}GetRenderScale(){return this.GetNormalScale()*this._runtime.GetRenderScale()}GetDisplayScale(){return this.GetNormalScale()*this._runtime.GetDisplayScale()}GetNormalScale(){return(this._scale*this._layout.GetScale()-1)*this._scaleRate+1}_MaybeUpdateViewport(){if(!this._isViewportChanged)return;this._isViewportChanged=false;const parallaxOriginX=this._runtime.GetParallaxXOrigin();const parallaxOriginY=this._runtime.GetParallaxYOrigin();const scrollOriginX=
(this.GetScrollX()-parallaxOriginX)*this._parallaxX+parallaxOriginX;const scrollOriginY=(this.GetScrollY()-parallaxOriginY)*this._parallaxY+parallaxOriginY;const normalScale=this.GetNormalScale();const scaledViewportWidth=this._runtime.GetViewportWidth()/normalScale;const scaledViewportHeight=this._runtime.GetViewportHeight()/normalScale;let px=scrollOriginX-scaledViewportWidth/2;let py=scrollOriginY-scaledViewportHeight/2;if(this._runtime.IsPixelRoundingEnabled()){px=Math.round(px);py=Math.round(py)}const viewportZ0=
this._viewportZ0;viewportZ0.set(px,py,px+scaledViewportWidth,py+scaledViewportHeight);const myAngle=this.GetAngle();if(myAngle!==0){tmpRect.copy(viewportZ0);tmpRect.offset(-viewportZ0.midX(),-viewportZ0.midY());tmpQuad.setFromRotatedRect(tmpRect,myAngle);tmpQuad.getBoundingBox(tmpRect);tmpRect.offset(viewportZ0.midX(),viewportZ0.midY());viewportZ0.copy(tmpRect)}const layerZ=this._zElevation;this.GetViewportForZ(layerZ,this._viewport);if(this.Has3DCamera())this.CalculateViewport3D(layerZ,this._viewport3D);
else this._viewport3D.copy(this._viewport)}CalculateViewport3D(z,outRect){const canvasManager=this._runtime.GetCanvasManager();const canvasWidth=canvasManager.GetCssWidth();const canvasHeight=canvasManager.GetCssHeight();const [tlx,tly]=this.CanvasCssToLayer(0,0,z);const [trx,try_]=this.CanvasCssToLayer(canvasWidth,0,z);const [brx,bry]=this.CanvasCssToLayer(canvasWidth,canvasHeight,z);const [blx,bly]=this.CanvasCssToLayer(0,canvasHeight,z);let left=Math.min(tlx,trx,brx,blx);let top=Math.min(tly,try_,
bry,bly);let right=Math.max(tlx,trx,brx,blx);let bottom=Math.max(tly,try_,bry,bly);if(!isFinite(left))left=-Infinity;if(!isFinite(top))top=-Infinity;if(!isFinite(right))right=Infinity;if(!isFinite(bottom))bottom=Infinity;outRect.set(left,top,right,bottom)}CanvasCssToLayer(ptx,pty,z=0){return this._CanvasToLayer(ptx,pty,z,this.GetDisplayScale())}DrawSurfaceToLayer(ptx,pty,z=0){return this._CanvasToLayer(ptx,pty,z,this.GetRenderScale()*this.GetDevicePixelRatio())}_CanvasToLayer(canvasX,canvasY,zElevation,
displayScale){const runtime=this._runtime;const renderer=runtime.GetRenderer();const normalScale=this.GetNormalScale();const scaledViewportWidth=runtime.GetViewportWidth()/normalScale;const scaledViewportHeight=runtime.GetViewportHeight()/normalScale;const viewport=tempVec4;vec4.set(viewport,0,0,scaledViewportWidth,scaledViewportHeight);canvasX=canvasX/displayScale;canvasY=viewport[3]-canvasY/displayScale;const matP=this._GetProjectionMatrix(renderer);const matMV=this._GetModelViewMatrix(renderer);
const objectCoord=tempVec3;const result=C3.Gfx.UnprojectScreenToWorldZ(canvasX,canvasY,zElevation,matMV,matP,viewport,objectCoord);if(result)return[objectCoord[0],objectCoord[1]];else return[NaN,NaN]}CanvasCssToLayer_DefaultTransform(ptx,pty){const scale=this._scale;const scaleRate=this._scaleRate;const parallaxX=this._parallaxX;const parallaxY=this._parallaxY;const angle=this._angle;this._scale=1;this._scaleRate=1;this._parallaxX=1;this._parallaxY=1;this._angle=0;this._SetMVMatrixChanged();const ret=
this.CanvasCssToLayer(ptx,pty);this._scale=scale;this._scaleRate=scaleRate;this._parallaxX=parallaxX;this._parallaxY=parallaxY;this._angle=angle;this._SetMVMatrixChanged();return ret}LayerToCanvasCss(ptx,pty,z=0){return this._LayerToCanvas(ptx,pty,z,this.GetDisplayScale())}LayerToDrawSurface(ptx,pty,z=0){return this._LayerToCanvas(ptx,pty,z,this.GetRenderScale()*this.GetDevicePixelRatio())}_LayerToCanvas(layerX,layerY,zElevation,displayScale){const runtime=this._runtime;const renderer=runtime.GetRenderer();
const normalScale=this.GetNormalScale();const scaledViewportWidth=runtime.GetViewportWidth()/normalScale;const scaledViewportHeight=runtime.GetViewportHeight()/normalScale;const viewport=tempVec4;vec4.set(viewport,0,0,scaledViewportWidth,scaledViewportHeight);const matP=this._GetProjectionMatrix(renderer);const matMV=this._GetModelViewMatrix(renderer);const windowCoord=tempVec3;const result=C3.Gfx.Project(layerX,layerY,zElevation,matMV,matP,viewport,windowCoord);if(result)return[windowCoord[0]*displayScale,
(viewport[3]-windowCoord[1])*displayScale];else return[NaN,NaN]}_GetLayerToDrawSurfaceScale(size,zElevation){size*=this.GetRenderScale()*this.GetDevicePixelRatio();if(zElevation!==0)size*=this.Get2DScaleFactorToZ(zElevation);return size}_InstanceBoxToDrawSurface(wi){const bbox=wi.GetBoundingBox();const z=wi.GetTotalZElevation();const depth=wi.GetDepth();const topZ=z+depth;const bbLeft=bbox.getLeft();const bbTop=bbox.getTop();const bbRight=bbox.getRight();const bbBottom=bbox.getBottom();if(this.Has3DCamera()){if(this._IsPointBehindNearPlane(bbLeft,
bbTop,z)||this._IsPointBehindNearPlane(bbRight,bbTop,z)||this._IsPointBehindNearPlane(bbRight,bbBottom,z)||this._IsPointBehindNearPlane(bbLeft,bbBottom,z))return null;if(depth>0)if(this._IsPointBehindNearPlane(bbLeft,bbTop,topZ)||this._IsPointBehindNearPlane(bbRight,bbTop,topZ)||this._IsPointBehindNearPlane(bbRight,bbBottom,topZ)||this._IsPointBehindNearPlane(bbLeft,bbBottom,topZ))return null}else if(topZ>=this.GetCameraZ())return null;let [stlx,stly]=this.LayerToDrawSurface(bbLeft,bbTop,z);let [sbrx,
sbry]=this.LayerToDrawSurface(bbRight,bbBottom,z);if(this.GetAngle()!==0||depth>0||this.Has3DCamera()){const [strx,stry]=this.LayerToDrawSurface(bbRight,bbTop,z);const [sblx,sbly]=this.LayerToDrawSurface(bbLeft,bbBottom,z);if(depth>0){const [stlxTop,stlyTop]=this.LayerToDrawSurface(bbLeft,bbTop,topZ);const [strxTop,stryTop]=this.LayerToDrawSurface(bbRight,bbTop,topZ);const [sbrxTop,sbryTop]=this.LayerToDrawSurface(bbRight,bbBottom,topZ);const [sblxTop,sblyTop]=this.LayerToDrawSurface(bbLeft,bbBottom,
topZ);let temp=Math.min(stlx,sbrx,strx,sblx,stlxTop,strxTop,sbrxTop,sblxTop);sbrx=Math.max(stlx,sbrx,strx,sblx,stlxTop,strxTop,sbrxTop,sblxTop);stlx=temp;temp=Math.min(stly,sbry,stry,sbly,stlyTop,stryTop,sbryTop,sblyTop);sbry=Math.max(stly,sbry,stry,sbly,stlyTop,stryTop,sbryTop,sblyTop);stly=temp}else{let temp=Math.min(stlx,sbrx,strx,sblx);sbrx=Math.max(stlx,sbrx,strx,sblx);stlx=temp;temp=Math.min(stly,sbry,stry,sbly);sbry=Math.max(stly,sbry,stry,sbly);stly=temp}}tmpRect.set(stlx,stly,sbrx,sbry);
return tmpRect}_GetViewFrustum(){if(this._isViewFrustumChanged){this._UpdateViewFrustum();this._isViewFrustumChanged=false}return this._viewFrustum}_UpdateViewFrustum(){const renderer=this._runtime.GetRenderer();const matP=this._GetProjectionMatrix(renderer);const matMV=this._GetModelViewMatrix(renderer);this._viewFrustum.CalculatePlanes(matMV,matP)}_IsPointBehindNearPlane(x,y,z){return this._GetViewFrustum().IsBehindNearPlane(x,y,z)}_SaveToJson(){const o={"s":this.GetOwnScale(),"a":this.GetOwnAngle(),
"v":this._IsVisibleFlagSet(),"i":this.IsInteractive(),"bc":this._backgroundColor.toJSON(),"t":this.IsTransparent(),"sx":this._scrollX,"sy":this._scrollY,"hosp":this._hasOwnScrollPosition,"px":this.GetParallaxX(),"py":this.GetParallaxY(),"c":this._color.toJSON(),"sr":this.GetScaleRate(),"fx":this._effectList.SaveToJson(),"cg":this._createdGlobalUids};return o}_LoadFromJson(o){this._scale=o["s"];this._angle=o["a"];this._isVisible=!!o["v"];this._isInteractive=o.hasOwnProperty("i")?o["i"]:true;this._backgroundColor.setFromJSON(o["bc"]);
this._isTransparent=!!o["t"];if(o.hasOwnProperty("sx"))this._scrollX=o["sx"];if(o.hasOwnProperty("sy"))this._scrollY=o["sy"];if(o.hasOwnProperty("hosp"))this._hasOwnScrollPosition=!!o["hosp"];this._parallaxX=o["px"];this._parallaxY=o["py"];this._color.setFromJSON(o["c"]);this._UpdatePremultipliedColor();this._scaleRate=o["sr"];C3.shallowAssignArray(this._createdGlobalUids,o["cg"]);C3.shallowAssignArray(this._initialInstances,this._startupInitialInstances);const tempSet=new Set(this._createdGlobalUids);
let j=0;for(let i=0,len=this._initialInstances.length;i<len;++i)if(!tempSet.has(this._initialInstances[i][2])){this._initialInstances[j]=this._initialInstances[i];++j}C3.truncateArray(this._initialInstances,j);this._effectList.LoadFromJson(o["fx"]);this._needsRebuildEffectChainSteps=true;this._SortInstancesByLastCachedZIndex(false);this.SetZIndicesChanged();this._SetMVMatrixChanged();this._SetProjectionMatrixChanged()}GetILayer(){return this._iLayer}SortAndAddInstancesByZIndex(inst,sortExisting=false){if(this._instances.includes(inst)){if(sortExisting)this._instances.sort((f,
s)=>{const firstZIndex=f.GetWorldInfo().GetSceneGraphZIndex();const secondZIndex=s.GetWorldInfo().GetSceneGraphZIndex();return firstZIndex-secondZIndex});return}if(inst.HasChildren()){const instances=[...inst.allChildren()];instances.push(inst);instances.sort((f,s)=>{const firstZIndex=f.GetWorldInfo().GetSceneGraphZIndex();const secondZIndex=s.GetWorldInfo().GetSceneGraphZIndex();return firstZIndex-secondZIndex});for(const instanceToAdd of instances){if(!instanceToAdd.IsInContainer())continue;for(const instanceToAddSibling of instanceToAdd.siblings()){if(instances.includes(instanceToAddSibling))continue;
const siblingAndChildren=[...instanceToAddSibling.allChildren()];siblingAndChildren.push(instanceToAddSibling);siblingAndChildren.sort((f,s)=>{const firstZIndex=f.GetWorldInfo().GetSceneGraphZIndex();const secondZIndex=s.GetWorldInfo().GetSceneGraphZIndex();return firstZIndex-secondZIndex});if(!siblingAndChildren||!siblingAndChildren.length)continue;instances.splice(instances.length,0,...siblingAndChildren)}}for(const instance of instances)if(instance.GetPlugin().IsWorldType())this._AddInstance(instance,
true)}else{if(inst.GetPlugin().IsWorldType())this._AddInstance(inst,true);if(!inst.IsInContainer())return;for(const sibling of inst.siblings()){const siblingAndChildren=[...sibling.allChildren()];siblingAndChildren.push(sibling);siblingAndChildren.sort((f,s)=>{const firstZIndex=f.GetWorldInfo().GetSceneGraphZIndex();const secondZIndex=s.GetWorldInfo().GetSceneGraphZIndex();return firstZIndex-secondZIndex});if(!siblingAndChildren||!siblingAndChildren.length)continue;for(const instance of siblingAndChildren)if(instance.GetPlugin().IsWorldType())this._AddInstance(instance,
true)}}}};

}

// layouts/layout.js
{
'use strict';const C3=self.C3;const C3Debugger=self.C3Debugger;const assert=self.assert;const tempDestRect=C3.New(C3.Rect);const tempSrcRect=C3.New(C3.Rect);const tempLayoutRect=C3.New(C3.Rect);const tempColor=C3.New(C3.Color);const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const tempRender3dList=[];const tempInstanceList1=[];const tempInstanceList2=[];const tempInstanceList3=[];function vec3EqualsXYZ(v,x,y,z){return v[0]===Math.fround(x)&&v[1]===Math.fround(y)&&v[2]===Math.fround(z)}
let lastLayerPreparedForDrawing=null;function MaybePrepareLayerDraw(layer,renderer){if(lastLayerPreparedForDrawing===layer)return;layer.PrepareForDraw(renderer);lastLayerPreparedForDrawing=layer}
C3.Layout=class Layout extends C3.DefendedBase{constructor(layoutManager,index,data){super();this._layoutManager=layoutManager;this._runtime=layoutManager.GetRuntime();this._name=data[0];this._originalWidth=data[1];this._originalHeight=data[2];this._width=data[1];this._height=data[2];this._isUnboundedScrolling=!!data[3];this._isOrthographicProjection=!!data[4];this._vanishingPointX=data[5];this._vanishingPointY=data[6];this._eventSheetName=data[7];this._eventSheet=null;this._sid=data[8];this._index=
index;this._scrollX=0;this._scrollY=0;this._scale=1;this._angle=0;this._initialObjectClasses=new Set;this._textureLoadedTypes=new Set;this._textureLoadPendingPromises=new Set;this._createdInstances=[];this._createdPersistedInstances=[];this._createdPersistedInstancesToDataMap=new Map;this._createdPersistedIndexToInstanceMap=new Map;this._initialNonWorld=[];this._is3dCameraEnabled=false;this._cam3dposition=vec3.create();this._cam3dlook=vec3.create();this._cam3dup=vec3.create();this._rootLayers=[];
this._allLayersFlat=[];this._layersByName=new Map;this._layersBySid=new Map;const canvasManager=this._runtime.GetCanvasManager();this._effectList=C3.New(C3.EffectList,this,data[11]);this._effectChain=C3.New(C3.Gfx.EffectChain,canvasManager.GetEffectChainManager(),{drawContent:(renderer,effectChain)=>{const layout=effectChain.GetContentObject();const renderSurface=layout.GetRenderTarget();renderer.ResetColor();renderer.DrawRenderTarget(renderSurface);renderer.InvalidateRenderTarget(renderSurface);
canvasManager.ReleaseAdditionalRenderTarget(renderSurface)},getShaderParameters:index=>this.GetEffectList()._GetEffectChainShaderParametersForIndex(index)});this._needsRebuildEffectChainSteps=true;this._wasFullScreenQualityLow=false;this._curRenderTarget=null;this._persistData={};this._persistedIntances=new Map;this._isFirstVisit=true;this._iLayout=new self.ILayout(this);this._userScriptDispatcher=C3.New(C3.Event.Dispatcher);for(const layerData of data[9])this._rootLayers.push(C3.New(C3.Layer,this,
null,layerData));this._allLayersFlat=[...this.allLayers()];for(let i=0,len=this._allLayersFlat.length;i<len;++i){const layer=this._allLayersFlat[i];layer._SetIndex(i);layer._Init();this._layersByName.set(layer.GetName().toLowerCase(),layer);this._layersBySid.set(layer.GetSID(),layer)}for(const instData of data[10]){const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);if(!objectClass)throw new Error("missing nonworld object class");if(!objectClass.GetDefaultInstanceData())objectClass.SetDefaultInstanceData(instData);
this._initialNonWorld.push(instData);this._AddInitialObjectClass(objectClass)}}Release(){for(const l of this._allLayersFlat)l.Release();C3.clearArray(this._allLayersFlat);this._textureLoadPendingPromises.clear();this._eventSheet=null;this._layoutManager=null;this._runtime=null}GetRuntime(){return this._runtime}GetName(){return this._name}GetSID(){return this._sid}GetIndex(){return this._index}GetEffectList(){return this._effectList}GetEffectChain(){this._MaybeRebuildEffectChainSteps();return this._effectChain}_MaybeRebuildEffectChainSteps(){const isFullscreenQualityLow=
this._runtime.GetCanvasManager().GetCurrentFullscreenScalingQuality()==="low";if(!this._needsRebuildEffectChainSteps&&this._wasFullScreenQualityLow===isFullscreenQualityLow&&!this._effectChain.NeedsRebuild())return;const activeEffectTypes=this.GetEffectList().GetActiveEffectTypes();this._effectChain.BuildSteps(activeEffectTypes.map(e=>e.GetShaderProgram()),{indexMap:activeEffectTypes.map(e=>e.GetIndex()),forcePostDraw:isFullscreenQualityLow,useFullSurface:true});this._needsRebuildEffectChainSteps=
false;this._wasFullScreenQualityLow=isFullscreenQualityLow}UpdateActiveEffects(){this.GetEffectList().UpdateActiveEffects();this._needsRebuildEffectChainSteps=true}GetMinLayerScale(){let m=this._allLayersFlat[0].GetNormalScale();for(let i=1,len=this._allLayersFlat.length;i<len;++i){const layer=this._allLayersFlat[i];if(layer.GetParallaxX()===0&&layer.GetParallaxY()===0)continue;m=Math.min(m,layer.GetNormalScale())}return m}_GetScrollBoundMarginHorizontal(){return.5*this._runtime.GetViewportWidth()/
this.GetMinLayerScale()}_GetScrollBoundMarginVertical(){return.5*this._runtime.GetViewportHeight()/this.GetMinLayerScale()}GetScrollLeftBound(){if(this.IsUnboundedScrolling())return-Infinity;else return this._GetScrollBoundMarginHorizontal()}GetScrollRightBound(){if(this.IsUnboundedScrolling())return Infinity;else return this.GetWidth()-this._GetScrollBoundMarginHorizontal()}GetScrollTopBound(){if(this.IsUnboundedScrolling())return-Infinity;else return this._GetScrollBoundMarginVertical()}GetScrollBottomBound(){if(this.IsUnboundedScrolling())return Infinity;
else return this.GetHeight()-this._GetScrollBoundMarginVertical()}SetScrollX(x){const lbound=this.GetScrollLeftBound();const rbound=this.GetScrollRightBound();if(x>rbound)x=rbound;if(x<lbound)x=lbound;if(this._scrollX!==x){this._scrollX=x;this._SetAllLayersMVChanged();this._runtime.UpdateRender()}}GetScrollX(){return this._scrollX}SetScrollY(y){const ubound=this.GetScrollTopBound();const bbound=this.GetScrollBottomBound();if(y>bbound)y=bbound;if(y<ubound)y=ubound;if(this._scrollY!==y){this._scrollY=
y;this._SetAllLayersMVChanged();this._runtime.UpdateRender()}}GetScrollY(){return this._scrollY}IsUnboundedScrolling(){return this._isUnboundedScrolling}BoundScrolling(){this.SetScrollX(this.GetScrollX());this.SetScrollY(this.GetScrollY());for(const layer of this._allLayersFlat)if(layer.IsOwnScrollPositionEnabled()){layer.SetScrollX(layer.GetScrollX());layer.SetScrollY(layer.GetScrollY())}}SetVanishingPointXY(vpX,vpY){if(this._vanishingPointX===vpX&&this._vanishingPointY===vpY)return;this._vanishingPointX=
vpX;this._vanishingPointY=vpY;if(this.IsPerspectiveProjection()){this._SetAllLayersProjectionChanged();this._SetAllLayersMVChanged();this._runtime.UpdateRender()}}GetVanishingPointX(){if(this.IsOrthographicProjection())return.5;else return this._vanishingPointX}GetVanishingPointY(){if(this.IsOrthographicProjection())return.5;else return this._vanishingPointY}HasVanishingPointOutsideViewport(){const vpX=this.GetVanishingPointX();const vpY=this.GetVanishingPointY();return vpX<0||vpX>1||vpY<0||vpY>1}SetPerspectiveProjection(){if(!this._isOrthographicProjection)return;
this._isOrthographicProjection=false;this._SetAllLayersProjectionChanged();this._SetAllLayersMVChanged();this._runtime.UpdateRender()}SetOrthographicProjection(){if(this._isOrthographicProjection)return;this._isOrthographicProjection=true;this._SetAllLayersProjectionChanged();this._SetAllLayersMVChanged();this._runtime.UpdateRender()}IsOrthographicProjection(){return this._isOrthographicProjection}IsPerspectiveProjection(){return!this.IsOrthographicProjection()}Set3DCameraEnabled(e){e=!!e;if(this._is3dCameraEnabled===
e)return;this._is3dCameraEnabled=e;this._SetAllLayersMVChanged();this._runtime.UpdateRender()}Is3DCameraEnabled(){return this._is3dCameraEnabled}Set3DCameraOrientation(camX,camY,camZ,lookX,lookY,lookZ,upX,upY,upZ){if(vec3EqualsXYZ(this._cam3dposition,camX,camY,camZ)&&vec3EqualsXYZ(this._cam3dlook,lookX,lookY,lookZ)&&vec3EqualsXYZ(this._cam3dup,upX,upY,upZ))return;vec3.set(this._cam3dposition,camX,camY,camZ);vec3.set(this._cam3dlook,lookX,lookY,lookZ);vec3.set(this._cam3dup,upX,upY,upZ);this.Set3DCameraChanged()}Set3DCameraChanged(){this._SetAllLayersMVChanged();
this._runtime.UpdateRender()}Get3DCameraPosition(){return this._cam3dposition}Get3DCameraLookAt(){return this._cam3dlook}Get3DCameraUpVector(){return this._cam3dup}GetScale(){return this._scale}SetScale(s){if(this._scale===s)return;this._scale=s;this._SetAllLayersMVChanged();this.BoundScrolling();this._runtime.UpdateRender()}SetAngle(a){a=C3.clampAngle(a);if(this._angle===a)return;this._angle=a;this._SetAllLayersMVChanged();this._runtime.UpdateRender()}GetAngle(){return this._angle}GetWidth(){return this._width}SetWidth(w){if(!isFinite(w)||
w<1)return;this._width=w}GetHeight(){return this._height}SetHeight(h){if(!isFinite(h)||h<1)return;this._height=h}GetEventSheet(){return this._eventSheet}*allLayers(){for(const rootLayer of this._rootLayers)yield*rootLayer.selfAndAllSubLayers()}GetLayers(){return this._allLayersFlat}GetLayerCount(){return this._allLayersFlat.length}GetLayer(p){if(typeof p==="number")return this.GetLayerByIndex(p);else return this.GetLayerByName(p.toString())}GetLayerByIndex(i){i=C3.clamp(Math.floor(i),0,this._allLayersFlat.length-
1);return this._allLayersFlat[i]}GetLayerByName(name){return this._layersByName.get(name.toLowerCase())||null}GetLayerBySID(sid){return this._layersBySid.get(sid)||null}_SetAllLayersProjectionChanged(){for(const layer of this._allLayersFlat)layer._SetProjectionMatrixChanged()}_SetAllLayersMVChanged(){for(const layer of this._allLayersFlat)layer._SetMVMatrixChanged()}SaveTransform(){return{"scrollX":this.GetScrollX(),"scrollY":this.GetScrollY(),"scale":this.GetScale(),"angle":this.GetAngle(),"vpX":this.GetVanishingPointX(),
"vpY":this.GetVanishingPointY()}}RestoreTransform(t){this.SetScrollX(t["scrollX"]);this.SetScrollY(t["scrollY"]);this.SetScale(t["scale"]);this.SetAngle(t["angle"]);this.SetVanishingPointXY(t["vpX"],t["vpY"])}GetLayoutBackgroundColor(){let firstDrawLayer=this._rootLayers.filter(l=>l.ShouldDraw())[0];while(firstDrawLayer){if(!firstDrawLayer.IsTransparent()){tempColor.copyRgb(firstDrawLayer.GetBackgroundColor());tempColor.setA(1);return tempColor}else if(firstDrawLayer.UsesOwnTexture()){tempColor.setRgba(0,
0,0,0);return tempColor}firstDrawLayer=firstDrawLayer.GetSubLayers().filter(l=>l.ShouldDraw())[0]}tempColor.setRgba(0,0,0,0);return tempColor}IsFirstVisit(){return this._isFirstVisit}_GetInitialObjectClasses(){return[...this._initialObjectClasses]}_AddInitialObjectClass(objectClass){if(objectClass.IsInContainer())for(const containerType of objectClass.GetContainer().GetObjectTypes())this._initialObjectClasses.add(containerType);else this._initialObjectClasses.add(objectClass)}_GetTextureLoadedObjectTypes(){return[...this._textureLoadedTypes]}_Load(previousLayout,
renderer){if(previousLayout===this||!renderer)return Promise.resolve();if(previousLayout){C3.CopySet(this._textureLoadedTypes,previousLayout._textureLoadedTypes);previousLayout._textureLoadedTypes.clear()}const promises=[];for(const oc of this._initialObjectClasses)if(!this._textureLoadedTypes.has(oc)){promises.push(oc.LoadTextures(renderer));this._textureLoadedTypes.add(oc)}return Promise.all(promises)}async MaybeLoadTexturesFor(objectClass){if(objectClass.IsFamily())throw new Error("cannot load textures for family");
const renderer=this._runtime.GetRenderer();if(!renderer||renderer.IsContextLost()||this._textureLoadedTypes.has(objectClass))return;this._textureLoadedTypes.add(objectClass);const loadPromise=objectClass.LoadTextures(renderer);this._AddPendingTextureLoadPromise(loadPromise);await loadPromise;objectClass.OnDynamicTextureLoadComplete();this._runtime.UpdateRender()}_AddPendingTextureLoadPromise(promise){this._textureLoadPendingPromises.add(promise);promise.then(()=>this._textureLoadPendingPromises.delete(promise)).catch(()=>
this._textureLoadPendingPromises.delete(promise))}WaitForPendingTextureLoadsToComplete(){return Promise.all([...this._textureLoadPendingPromises])}MaybeUnloadTexturesFor(objectClass){if(objectClass.IsFamily()||objectClass.GetInstanceCount()>0)throw new Error("cannot unload textures");const renderer=this._runtime.GetRenderer();if(!renderer||!this._textureLoadedTypes.has(objectClass))return;this._textureLoadedTypes.delete(objectClass);objectClass.ReleaseTextures(renderer)}_Unload(nextLayout,renderer){if(nextLayout===
this||!renderer)return;for(const oc of this._textureLoadedTypes)if(!oc.IsGlobal()&&!nextLayout._initialObjectClasses.has(oc)){oc.ReleaseTextures();this._textureLoadedTypes.delete(oc)}}_OnRendererContextLost(){this._textureLoadedTypes.clear()}async _StartRunning(isFirstLayout){const runtime=this._runtime;const layoutManager=this._layoutManager;const eventSheetManager=runtime.GetEventSheetManager();if(this._eventSheetName){this._eventSheet=eventSheetManager.GetEventSheetByName(this._eventSheetName);
this._eventSheet._UpdateDeepIncludes()}layoutManager._SetMainRunningLayout(this);this._width=this._originalWidth;this._height=this._originalHeight;this._scrollX=runtime.GetOriginalViewportWidth()/2;this._scrollY=runtime.GetOriginalViewportHeight()/2;this.BoundScrolling();this._SetAllLayersProjectionChanged();this._SetAllLayersMVChanged();this._MoveGlobalObjectsToThisLayout(isFirstLayout);this._runtime.SetUsingCreatePromises(true);this._CreateInitialInstances();if(!this._isFirstVisit)this._CreatePersistedInstances();
this._CreateAndLinkContainerInstances(this._createdInstances);this._CreateAndLinkContainerInstances(this._createdPersistedInstances);this._CreateInitialNonWorldInstances();layoutManager.ClearPendingChangeLayout();runtime.FlushPendingInstances();this._runtime.SetUsingCreatePromises(false);const createPromises=this._runtime.GetCreatePromises();await Promise.all(createPromises);C3.clearArray(createPromises);if(!runtime.IsLoadingState()){for(const inst of this._createdInstances)inst.SetupInitialSceneGraphConnections();
for(const inst of this._createdPersistedInstances)inst.SetupPersistedSceneGraphConnections(this._createdPersistedInstancesToDataMap,this._createdPersistedIndexToInstanceMap);for(const [sidStr,typeData]of Object.entries(this._persistData)){const objectClass=this._runtime.GetObjectClassBySID(parseInt(sidStr,10));if(!objectClass||objectClass.IsFamily()||!objectClass.HasPersistBehavior())continue;C3.clearArray(typeData)}for(const inst of this._createdInstances)inst._TriggerOnCreated();for(const inst of this._createdPersistedInstances)inst._TriggerOnCreated()}C3.clearArray(this._createdInstances);
C3.clearArray(this._createdPersistedInstances);this._createdPersistedInstancesToDataMap.clear();this._createdPersistedIndexToInstanceMap.clear();await Promise.all([...this._initialObjectClasses].map(oc=>oc.PreloadTexturesWithInstances(this._runtime.GetRenderer())));if(isFirstLayout){runtime.Dispatcher().dispatchEvent(new C3.Event("beforefirstlayoutstart"));await runtime.DispatchUserScriptEventAsyncWait(new C3.Event("beforeprojectstart"))}runtime.Dispatcher().dispatchEvent(new C3.Event("beforelayoutstart"));
await this.DispatchUserScriptEventAsyncWait(new C3.Event("beforelayoutstart"));if(!runtime.IsLoadingState())await runtime.TriggerAsync(C3.Plugins.System.Cnds.OnLayoutStart,null,null);runtime.Dispatcher().dispatchEvent(new C3.Event("afterlayoutstart"));await this.DispatchUserScriptEventAsyncWait(new C3.Event("afterlayoutstart"));if(isFirstLayout){runtime.Dispatcher().dispatchEvent(new C3.Event("afterfirstlayoutstart"));await runtime.DispatchUserScriptEventAsyncWait(new C3.Event("afterprojectstart"))}eventSheetManager._RunQueuedTriggers(layoutManager);
await this.WaitForPendingTextureLoadsToComplete();this._isFirstVisit=false}_MoveGlobalObjectsToThisLayout(isFirstLayout){for(const objectClass of this._runtime.GetAllObjectClasses()){if(objectClass.IsFamily()||!objectClass.IsWorldType())continue;for(const inst of objectClass.GetInstances()){const wi=inst.GetWorldInfo();const oldLayer=wi.GetLayer();const layerIndex=C3.clamp(oldLayer.GetIndex(),0,this._allLayersFlat.length-1);const newLayer=this._allLayersFlat[layerIndex];wi._SetLayer(newLayer);newLayer._MaybeAddInstance(inst)}}if(!isFirstLayout)for(const layer of this._allLayersFlat)layer._SortInstancesByLastCachedZIndex(false)}_CreateInitialInstances(){for(const layer of this._allLayersFlat){layer.CreateInitialInstances(this._createdInstances);
layer._Start()}}_CreatePersistedInstances(){let uidsChanged=false;for(const [sidStr,typeData]of Object.entries(this._persistData)){const objectClass=this._runtime.GetObjectClassBySID(parseInt(sidStr,10));if(!objectClass||objectClass.IsFamily()||!objectClass.HasPersistBehavior())continue;for(const instData of typeData){let layer=null;if(objectClass.IsWorldType()){if(instData.hasOwnProperty("instJson"))layer=this.GetLayerBySID(instData["instJson"]["w"]["l"]);else layer=this.GetLayerBySID(instData["w"]["l"]);
if(!layer)continue}const inst=this._runtime.CreateInstanceFromData(objectClass,layer,false,0,0,true);if(instData.hasOwnProperty("instJson"))inst.LoadFromJson(instData["instJson"]);else inst.LoadFromJson(instData);uidsChanged=true;this._createdPersistedInstances.push(inst);if(instData.hasOwnProperty("instJson")){this._createdPersistedInstancesToDataMap.set(inst,instData);this._createdPersistedIndexToInstanceMap.set(instData["index"],inst)}}}for(const layer of this._allLayersFlat){layer._SortInstancesByLastCachedZIndex(true);
layer.SetZIndicesChanged()}if(uidsChanged){this._runtime.FlushPendingInstances();this._runtime._RefreshUidMap()}}_CreateAndLinkContainerInstances(createdInstances){for(const inst of createdInstances){if(!inst.IsInContainer())continue;const wi=inst.GetWorldInfo();const iid=inst.GetIID();for(const containerType of inst.GetObjectClass().GetContainer().objectTypes()){if(containerType===inst.GetObjectClass())continue;const instances=containerType.GetInstances();if(instances.length>iid)inst._AddSibling(instances[iid]);
else{let s;if(wi)s=this._runtime.CreateInstanceFromData(containerType,wi.GetLayer(),true,wi.GetX(),wi.GetY(),true);else s=this._runtime.CreateInstanceFromData(containerType,null,true,0,0,true);this._runtime.FlushPendingInstances();containerType._UpdateIIDs();inst._AddSibling(s);createdInstances.push(s)}}}}_CreateInitialNonWorldInstances(){for(const instData of this._initialNonWorld){const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);if(!objectClass.IsInContainer())this._runtime.CreateInstanceFromData(instData,
null,true)}}_CreateGlobalNonWorlds(){const createdInstances=[];const initialNonWorld=this._initialNonWorld;let k=0;for(let i=0,len=initialNonWorld.length;i<len;++i){const instData=initialNonWorld[i];const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);if(objectClass.IsGlobal()){if(!objectClass.IsInContainer()||!objectClass.GetContainer().HasAnyWorldType())createdInstances.push(this._runtime.CreateInstanceFromData(instData,null,true))}else{initialNonWorld[k]=instData;++k}}C3.truncateArray(initialNonWorld,
k);this._runtime.FlushPendingInstances();this._CreateAndLinkContainerInstances(createdInstances)}RecreateInitialObjects(objectClass,rc,srcLayer,offsetX,offsetY,createHierarchy){if(srcLayer)return srcLayer.RecreateInitialObjects(objectClass,rc,offsetX,offsetY,createHierarchy);else{const ret=[];for(const layer of this._allLayersFlat)ret.push(layer.RecreateInitialObjects(objectClass,rc,offsetX,offsetY,createHierarchy));return ret.flat()}}async _StopRunning(){const layoutManager=this._layoutManager;if(!this._runtime.IsLoadingState()){await this.DispatchUserScriptEventAsyncWait(new C3.Event("beforelayoutend"));
await this._runtime.TriggerAsync(C3.Plugins.System.Cnds.OnLayoutEnd,null,null);await this.DispatchUserScriptEventAsyncWait(new C3.Event("afterlayoutend"))}layoutManager.SetIsEndingLayout(true);this._runtime.GetEventSheetManager().ClearAllScheduledWaits();if(!this._isFirstVisit)this._SavePersistData();for(const layer of this._allLayersFlat)layer._End();for(const objectClass of this._runtime.GetAllObjectClasses()){if(objectClass.IsGlobal()||objectClass.IsWorldType()||objectClass.GetPlugin().IsSingleGlobal()||
objectClass.IsFamily())continue;for(const inst of objectClass.GetInstances())this._runtime.DestroyInstance(inst);this._runtime.FlushPendingInstances()}layoutManager.SetIsEndingLayout(false);if(layoutManager.GetMainRunningLayout()===this)layoutManager._SetMainRunningLayout(null)}_SaveInstanceToPersist(inst,index){const sidStr=inst.GetObjectClass().GetSID().toString();if(!this._persistData.hasOwnProperty(sidStr))this._persistData[sidStr]=[];const typePersist=this._persistData[sidStr];const persistData=
{"index":index,"instJson":inst.SaveToJson(),"sceneGraphJson":{"children":[]}};typePersist.push(persistData);this._persistedIntances.set(inst,persistData)}_SaveSceneGraphInfoToPersist(inst){const persistData=this._persistedIntances.get(inst);for(const child of inst.GetChildren()){const childPersistData=this._persistedIntances.get(child);if(childPersistData)persistData["sceneGraphJson"]["children"].push({"index":childPersistData["index"],"flags":C3.SceneGraphInfo._GetFlagsNumber(child.GetWorldInfo())})}}_SavePersistData(){this._persistedIntances.clear();
let persisDataIndex=0;for(const layer of this._allLayersFlat){layer._UpdateZIndices();for(const inst of layer._GetInstances()){const objectClass=inst.GetObjectClass();if(!objectClass.IsGlobal()&&objectClass.HasPersistBehavior()){this._SaveInstanceToPersist(inst,persisDataIndex);persisDataIndex++}}}for(const layer of this._allLayersFlat)for(const inst of layer._GetInstances()){const objectClass=inst.GetObjectClass();if(!objectClass.IsGlobal()&&objectClass.HasPersistBehavior())this._SaveSceneGraphInfoToPersist(inst)}this._persistedIntances.clear()}ResetPersistData(){this._persistData=
{};this._isFirstVisit=true}GetRenderTarget(){return this._curRenderTarget}UsesOwnTexture(){const runtime=this._runtime;const isWebGL=runtime.GetRenderer().IsWebGL();return runtime.GetCanvasManager().GetCurrentFullscreenScalingQuality()==="low"||isWebGL&&runtime.UsesAnyBackgroundBlending()||runtime.GetCompositingMode()==="low-latency"||this._effectList.HasAnyActiveEffect()||isWebGL&&runtime.Uses3DFeatures()}Draw(renderer){const canvasManager=this._runtime.GetCanvasManager();const useOwnTexture=this.UsesOwnTexture();
if(useOwnTexture){if(this._runtime.GetCompositingMode()!=="low-latency"){renderer.SetRenderTarget(null);renderer.ClearRgba(0,0,0,0)}const rtOpts={sampling:this._runtime.GetSampling(),isSampled:renderer.IsWebGPU()||this._runtime.UsesAnyBackgroundBlending()||this._effectList.HasAnyActiveEffect(),canReadPixels:renderer.IsWebGPU()?this._runtime.UsesAnyBackgroundBlending():false};if(canvasManager.GetCurrentFullscreenScalingQuality()==="low"){rtOpts.width=canvasManager.GetDrawWidth();rtOpts.height=canvasManager.GetDrawHeight()}this._curRenderTarget=
this._runtime.GetAdditionalRenderTarget(rtOpts)}else this._curRenderTarget=null;renderer.SetRenderTarget(this._curRenderTarget);renderer.Clear(this.GetLayoutBackgroundColor());if(this._runtime.Uses3DFeatures())renderer.ClearDepth();this._DrawLayerList(renderer,this._curRenderTarget,this._rootLayers,true);if(useOwnTexture){renderer.SetDepthEnabled(false);this._DrawLayoutOwnTextureToRenderTarget(renderer,this._curRenderTarget)}this._curRenderTarget=null}_DrawLayerList(renderer,destRenderTarget,layersArr,
canCopyFirstLayer){const layersToDraw=layersArr.filter(l=>l.ShouldDraw());for(let i=0,len=layersToDraw.length;i<len;){const layer=layersToDraw[i];if(layer.SelfAndAllSubLayersHave3DCamera()&&!layer.SelfOrAnySubLayerUsesOwnTexture()){tempRender3dList.push(layer);for(let j=i+1;j<len;++j){const nextLayer=layersToDraw[j];if(nextLayer.SelfAndAllSubLayersHave3DCamera()&&!nextLayer.SelfOrAnySubLayerUsesOwnTexture())tempRender3dList.push(layersToDraw[j]);else break}if(tempRender3dList.length>=2||tempRender3dList.length===
1&&tempRender3dList[0].HasAnyVisibleSubLayer()){this._Draw3DLayers(renderer,destRenderTarget,tempRender3dList);i+=tempRender3dList.length;C3.clearArray(tempRender3dList);continue}C3.clearArray(tempRender3dList)}layer.Draw(renderer,destRenderTarget,canCopyFirstLayer&&i===0);++i}}_DrawLayoutOwnTextureToRenderTarget(renderer,ownRenderTarget){const activeEffectTypes=this._effectList.GetActiveEffectTypes();const runtime=this._runtime;if(activeEffectTypes.length===0){renderer.SetRenderTarget(null);renderer.SetTextureFillMode();
renderer.CopyRenderTarget(ownRenderTarget);renderer.InvalidateRenderTarget(ownRenderTarget);runtime.ReleaseAdditionalRenderTarget(ownRenderTarget)}else{tempLayoutRect.set(0,0,runtime.GetViewportWidth(),runtime.GetViewportHeight());this.GetEffectChain().Render(renderer,null,{contentObject:this,blendMode:3,devicePixelRatio:this._runtime.GetEffectDevicePixelRatioParam(),layerScale:this._runtime.GetEffectLayerScaleParam()*this.GetScale(),layerAngle:this.GetAngle(),layoutRect:tempLayoutRect,drawSurfaceRect:null,
invalidateRenderTargets:true})}}_Draw3DLayers(renderer,renderTarget,layerList){if(!layerList[0].IsTransparent()){tempColor.copyRgb(layerList[0].GetBackgroundColor());tempColor.setA(1);renderer.Clear(tempColor)}const canvasManager=this._runtime.GetCanvasManager();renderer.SetDepthEnabled(true);const fullInstanceList=tempInstanceList1;const coplanarInstances=tempInstanceList2;const postRenderInstances=tempInstanceList3;for(const layer of layerList){layer._UpdateZIndices();layer._AppendAllInstancesIncludingSubLayersInDrawOrder(fullInstanceList)}const firstLayer=
layerList[0];let layerQuery=null;if(this._runtime.IsGPUProfiling())if(renderer.IsWebGL()){const timingsBuffer=canvasManager.GetLayerTimingsBuffer(firstLayer);if(timingsBuffer){layerQuery=timingsBuffer.AddTimeElapsedQuery();renderer.StartQuery(layerQuery)}}else if(renderer.IsWebGPU())renderer.WriteTimestamp((firstLayer.GetIndex()+1)*2);for(let i=0,len=fullInstanceList.length;i<len;){const inst=fullInstanceList[i];const wi=inst.GetWorldInfo();const wiLayer=wi.GetLayer();if(!wi.IsVisible()||!wi.IsInViewport3D(wiLayer._GetViewFrustum())){++i;
continue}if(!inst.RendersToOwnZPlane()||wi.GetDepth()>0)postRenderInstances.push(inst);const startZ=inst.GetWorldInfo().GetTotalZElevation();coplanarInstances.push(inst);let endIndex=i+1;for(;endIndex<len;++endIndex){const nextInst=fullInstanceList[endIndex];const nextWi=nextInst.GetWorldInfo();if(!nextWi.IsVisible()||!nextWi.IsInViewport3D(nextWi.GetLayer()._GetViewFrustum()))continue;if(nextWi.GetTotalZElevation()!==startZ)break;if(!nextInst.RendersToOwnZPlane()){postRenderInstances.push(nextInst);
continue}if(nextWi.GetDepth()>0)postRenderInstances.push(nextInst);coplanarInstances.push(nextInst)}if(coplanarInstances.length===1&&!coplanarInstances[0].MustMitigateZFighting()){MaybePrepareLayerDraw(wiLayer,renderer);wiLayer._DrawInstanceMaybeWithEffects(inst,wi,renderer,renderTarget);for(let j=0,lenj=postRenderInstances.length;j<lenj;++j){const postInst=postRenderInstances[j];if(postInst===inst)continue;const postWi=postInst.GetWorldInfo();const postWiLayer=postWi.GetLayer();MaybePrepareLayerDraw(postWiLayer,
renderer);postWiLayer._DrawInstanceMaybeWithEffects(postInst,postWi,renderer,renderTarget)}}else{this._Draw3DLayersCoplanarInstances(renderer,renderTarget,coplanarInstances);for(let j=0,lenj=postRenderInstances.length;j<lenj;++j){const postInst=postRenderInstances[j];const postWi=postInst.GetWorldInfo();const postWiLayer=postWi.GetLayer();postWi._SetDrawNonBackFacesOnly(true);MaybePrepareLayerDraw(postWiLayer,renderer);postWiLayer._DrawInstanceMaybeWithEffects(postInst,postWi,renderer,renderTarget);
postWi._SetDrawNonBackFacesOnly(false)}}i=endIndex;C3.clearArray(coplanarInstances);C3.clearArray(postRenderInstances)}if(layerQuery)renderer.EndQuery(layerQuery);if(this._runtime.IsGPUProfiling()&&renderer.IsWebGPU())renderer.WriteTimestamp((firstLayer.GetIndex()+1)*2+1);C3.clearArray(fullInstanceList);lastLayerPreparedForDrawing=null}_Draw3DLayersCoplanarInstances(renderer,renderTarget,instances){renderer.CoplanarStartStencilPass();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];
const wi=inst.GetWorldInfo();const layer=wi.GetLayer();wi._SetDrawBackFaceOnly(true);MaybePrepareLayerDraw(layer,renderer);layer._DrawInstance(inst,wi,renderer)}renderer.CoplanarStartColorPass();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];const wi=inst.GetWorldInfo();const layer=wi.GetLayer();MaybePrepareLayerDraw(layer,renderer);layer._DrawInstanceMaybeWithEffects(inst,wi,renderer,renderTarget);wi._SetDrawBackFaceOnly(false)}renderer.CoplanarRestoreStandardRendering()}_SaveToJson(){const o=
{"sx":this.GetScrollX(),"sy":this.GetScrollY(),"s":this.GetScale(),"a":this.GetAngle(),"w":this.GetWidth(),"h":this.GetHeight(),"ortho":this.IsOrthographicProjection(),"vpX":this.GetVanishingPointX(),"vpY":this.GetVanishingPointY(),"fv":this._isFirstVisit,"persist":this._persistData,"fx":this._effectList.SaveToJson(),"layers":{}};for(const layer of this._allLayersFlat)o["layers"][layer.GetSID().toString()]=layer._SaveToJson();return o}_LoadFromJson(o){this._scrollX=o["sx"];this._scrollY=o["sy"];this._scale=
o["s"];this._angle=o["a"];this._width=o["w"];this._height=o["h"];this._isOrthographicProjection=!!o["ortho"];if(o.hasOwnProperty("vpX"))this._vanishingPointX=o["vpX"];if(o.hasOwnProperty("vpY"))this._vanishingPointY=o["vpY"];this._isFirstVisit=!!o["fv"];this._persistData=o["persist"];this._effectList.LoadFromJson(o["fx"]);this._needsRebuildEffectChainSteps=true;for(const [sidStr,data]of Object.entries(o["layers"])){const sid=parseInt(sidStr,10);const layer=this.GetLayerBySID(sid);if(!layer)continue;
layer._LoadFromJson(data)}this._SetAllLayersProjectionChanged();this._SetAllLayersMVChanged()}GetILayout(){return this._iLayout}UserScriptDispatcher(){return this._userScriptDispatcher}DispatchUserScriptEvent(e){e.layout=this.GetILayout();const runtime=this._runtime;const shouldTime=runtime.IsDebug()&&!runtime.GetEventSheetManager().IsInEventEngine();if(shouldTime)C3Debugger.StartMeasuringScriptTime();this._userScriptDispatcher.dispatchEvent(e);if(shouldTime)C3Debugger.AddScriptTime()}DispatchUserScriptEventAsyncWait(e){e.layout=
this.GetILayout();return this._userScriptDispatcher.dispatchEventAndWaitAsync(e)}};

}

// layouts/layoutManager.js
{
'use strict';const C3=self.C3;
C3.LayoutManager=class LayoutManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._allLayouts=[];this._layoutsByName=new Map;this._layoutsBySid=new Map;this._mainRunningLayout=null;this._runningSubLayouts=[];this._firstLayout=null;this._isEndingLayout=0;this._pendingChangeLayout=null}Release(){this._runtime=null;this._mainRunningLayout=null;this._firstLayout=null;this._pendingChangeLayout=null;C3.clearArray(this._allLayouts);this._layoutsByName.clear();this._layoutsBySid.clear();
C3.clearArray(this._runningSubLayouts)}Create(layoutData){const layout=C3.New(C3.Layout,this,this._allLayouts.length,layoutData);this._allLayouts.push(layout);this._layoutsByName.set(layout.GetName().toLowerCase(),layout);this._layoutsBySid.set(layout.GetSID(),layout)}GetRuntime(){return this._runtime}SetFirstLayout(layout){this._firstLayout=layout}GetFirstLayout(){if(this._firstLayout)return this._firstLayout;if(this._allLayouts.length)return this._allLayouts[0];throw new Error("no first layout");
}GetLayoutByName(name){return this._layoutsByName.get(name.toLowerCase())||null}GetLayoutBySID(sid){return this._layoutsBySid.get(sid)||null}GetLayoutByIndex(index){index=C3.clamp(Math.floor(index),0,this._allLayouts.length-1);return this._allLayouts[index]}GetLayout(p){if(typeof p==="number")return this.GetLayoutByIndex(p);else return this.GetLayoutByName(p.toString())}GetAllLayouts(){return this._allLayouts}_SetMainRunningLayout(layout){this._mainRunningLayout=layout}GetMainRunningLayout(){return this._mainRunningLayout}_AddRunningSubLayout(layout){if(this._runningSubLayouts.includes(layout))throw new Error("layout already running");
this._runningSubLayouts.push(layout)}_RemoveRunningSubLayout(layout){const i=this._runningSubLayouts.indexOf(layout);if(i===-1)throw new Error("layout not running");this._runningSubLayouts.splice(i,1)}*runningLayouts(){if(this._mainRunningLayout)yield this._mainRunningLayout;if(this._runningSubLayouts.length)yield*this._runningSubLayouts}IsLayoutRunning(layout){return this._mainRunningLayout===layout||this._runningSubLayouts.includes(layout)}SetIsEndingLayout(e){if(e)this._isEndingLayout++;else{if(this._isEndingLayout<=
0)throw new Error("already unset");this._isEndingLayout--}}IsEndingLayout(){return this._isEndingLayout>0}ChangeMainLayout(layout){this._pendingChangeLayout=layout}ClearPendingChangeLayout(){this._pendingChangeLayout=null}IsPendingChangeMainLayout(){return!!this._pendingChangeLayout}GetPendingChangeMainLayout(){return this._pendingChangeLayout}SetAllLayerProjectionChanged(){const runningLayout=this.GetMainRunningLayout();if(!runningLayout)return;runningLayout._SetAllLayersProjectionChanged()}SetAllLayerMVChanged(){const runningLayout=
this.GetMainRunningLayout();if(!runningLayout)return;runningLayout._SetAllLayersMVChanged()}};

}

// timelines/timelineManager.js
{
'use strict';const C3=self.C3;const NAMES_REGEXP=new RegExp("<(.+?)>","g");
C3.TimelineManager=class TimelineManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._timelineDataManager=C3.New(C3.TimelineDataManager);this._pluginInstance=null;this._timelines=[];this._timelinesByName=new Map;this._objectClassToTimelineMap=new Map;this._timelinesCreatedByTemplate=new Map;this._scheduledTimelines=[];this._playingTimelines=[];this._markedForRemovalTimelines=[];this._hasRuntimeListeners=false;this._changingLayout=false;this._isTickingTimelines=
false;this._tickFunc=()=>this._OnTick();this._tick2Func=()=>this._OnTick2();this._beforeLayoutChange=()=>this._OnBeforeChangeLayout();this._layoutChange=()=>this._OnAfterChangeLayout();this._instanceDestroy=e=>this._OnInstanceDestroy(e.instance);this._beforeLoad=e=>this._OnBeforeLoad();this._afterLoad=e=>this._OnAfterLoad();this._afterLayoutStart=e=>this._OnAfterLayoutStart();this._destroyedWhileLoadingState=[];this._renderChange=0}Release(){this.RemoveRuntimeListeners();this._tickFunc=null;this._tick2Func=
null;this._beforeLayoutChange=null;this._layoutChange=null;this._instanceDestroy=null;this._afterLoad=null;for(const timeline of this._timelines){timeline.Stop();timeline.Release()}C3.clearArray(this._timelines);this._timelines=null;this._timelineDataManager.Release();this._timelineDataManager=null;C3.clearArray(this._scheduledTimelines);this._scheduledTimelines=null;C3.clearArray(this._playingTimelines);this._playingTimelines=null;C3.clearArray(this._markedForRemovalTimelines);this._markedForRemovalTimelines=
null;this._timelinesByName.clear();this._timelinesByName=null;this._objectClassToTimelineMap.clear();this._objectClassToTimelineMap=null;this._timelinesCreatedByTemplate.clear();this._timelinesCreatedByTemplate=null;C3.clearArray(this._destroyedWhileLoadingState);this._destroyedWhileLoadingState=null;this._runtime=null}AddRuntimeListeners(){const dispatcher=this._runtime.Dispatcher();dispatcher.addEventListener("pretick",this._tickFunc);dispatcher.addEventListener("tick2",this._tick2Func);dispatcher.addEventListener("beforelayoutchange",
this._beforeLayoutChange);dispatcher.addEventListener("layoutchange",this._layoutChange);dispatcher.addEventListener("instancedestroy",this._instanceDestroy);dispatcher.addEventListener("beforeload",this._beforeLoad);dispatcher.addEventListener("afterload",this._afterLoad);dispatcher.addEventListener("afterlayoutstart",this._afterLayoutStart)}RemoveRuntimeListeners(){const dispatcher=this._runtime.Dispatcher();dispatcher.removeEventListener("pretick",this._tickFunc);dispatcher.removeEventListener("tick2",
this._tick2Func);dispatcher.removeEventListener("beforelayoutchange",this._beforeLayoutChange);dispatcher.removeEventListener("layoutchange",this._layoutChange);dispatcher.removeEventListener("instancedestroy",this._instanceDestroy);dispatcher.removeEventListener("beforeload",this._beforeLoad);dispatcher.removeEventListener("afterload",this._afterLoad);dispatcher.removeEventListener("afterlayoutstart",this._afterLayoutStart)}Create(timelineData){this._timelineDataManager.Add(timelineData);const timeline=
C3.TimelineState.CreateInitial(timelineData,this);this.Add(timeline);this.SetTimelineObjectClassesToMap(timeline);this._timelinesCreatedByTemplate.set(timeline.GetName(),0)}CreateFromTemplate(template){const timelineDataManager=this.GetTimelineDataManager();const templateName=template.GetTemplateName();const timelineDataItem=timelineDataManager.Get(templateName);const timeline=C3.TimelineState.CreateFromTemplate(`${templateName}:${this._timelinesCreatedByTemplate.get(templateName)}`,timelineDataItem,
this);this._IncreaseTemplateTimelinesCount(templateName);this.Add(timeline);return timeline}_IncreaseTemplateTimelinesCount(templateName){this._timelinesCreatedByTemplate.set(templateName,this._timelinesCreatedByTemplate.get(templateName)+1)}_SetCreatedTemplateTimelinesCount(){for(const timeline of this._timelines){if(timeline.IsTemplate())continue;const templateName=timeline.GetTemplateName();this._IncreaseTemplateTimelinesCount(templateName)}}_ClearCreatedTemplateTimelinesCount(){for(const templateName of this._timelinesCreatedByTemplate.keys())this._timelinesCreatedByTemplate.set(templateName,
0)}Add(timeline){this._timelines.push(timeline);this._timelinesByName.set(timeline.GetName().toLowerCase(),timeline)}Remove(timeline){timeline.Removed();if(timeline.IsTemplate())return;C3.arrayFindRemove(this._timelines,timeline);C3.arrayFindRemove(this._scheduledTimelines,timeline);C3.arrayFindRemove(this._playingTimelines,timeline);C3.arrayFindRemove(this._markedForRemovalTimelines,timeline);this._timelinesByName.delete(timeline.GetName().toLowerCase());this.RemoveTimelineFromObjectClassMap(timeline);
if(!timeline.IsReleased())timeline.Release()}Trigger(method){this._runtime.Trigger(method,this._pluginInstance,null)}GetRuntime(){return this._runtime}GetTimelineDataManager(){return this._timelineDataManager}SetPluginInstance(inst){this._pluginInstance=inst}GetPluginInstance(){return this._pluginInstance}*GetTimelines(){for(const timeline of this._timelines)yield timeline}*GetPlayingTimelines(){for(const timeline of this._playingTimelines)yield timeline}SetTimelineObjectClassToMap(objectClass,timeline){if(!this._objectClassToTimelineMap.has(objectClass))this._objectClassToTimelineMap.set(objectClass,
new Set);this._objectClassToTimelineMap.get(objectClass).add(timeline)}SetTimelineObjectClassesToMap(timeline){for(const objectClass of timeline.GetObjectClasses())this.SetTimelineObjectClassToMap(objectClass,timeline)}RemoveTimelineFromObjectClassMap(timeline){for(const [objectClass,timelines]of this._objectClassToTimelineMap.entries())if(timelines.has(timeline)){timelines.delete(timeline);if(timelines.size===0)this._objectClassToTimelineMap.delete(objectClass)}}GetTimelinesForObjectClass(objectClass){if(!this._objectClassToTimelineMap.has(objectClass))return;
return this._objectClassToTimelineMap.get(objectClass)}GetTimelineOfTemplateForInstances(templateTimeline,instancesObject){if(!instancesObject)return;for(const timeline of this._timelines){const found=instancesObject.every(io=>{return timeline.HasTrackInstance(io.instance,io.trackId)});if(found)if(timeline.GetName().includes(templateTimeline.GetName()))return timeline}}GetTimelineByName(name){return this._timelinesByName.get(name.toLowerCase())||null}GetScheduledOrPlayingTimelineByName(name){for(const timeline of this._scheduledTimelines)if(timeline.GetName()===
name)return timeline;for(const timeline of this._playingTimelines)if(timeline.GetName()===name)return timeline;return null}*GetTimelinesByName(name){if(NAMES_REGEXP.test(name)){NAMES_REGEXP.lastIndex=0;let match;const uniqueNames=new Set;do{match=NAMES_REGEXP.exec(name);if(match){const names=match[1].split(",");for(const name of names)uniqueNames.add(name)}}while(match);for(const name of uniqueNames.values()){const timeline=this.GetTimelineByName(name);if(timeline)yield timeline}uniqueNames.clear()}else{const timeline=
this.GetTimelineByName(name);if(timeline)yield timeline}}*GetTimelinesByTags(tags){for(const timeline of this._timelines)if(timeline.HasTags(tags))yield timeline}AddScheduledTimeline(timeline){if(!this._scheduledTimelines.includes(timeline))this._scheduledTimelines.push(timeline);this._MaybeEnableRuntimeListeners()}RemovePlayingTimeline(timeline){C3.arrayFindRemove(this._playingTimelines,timeline);this._MaybeDisableRuntimeListeners()}ScheduleTimeline(timeline){if(this._playingTimelines.includes(timeline)){timeline.SetPlaying(true);
timeline.SetScheduled(false);timeline.SetMarkedForRemoval(false)}else{timeline.SetPlaying(false);timeline.SetScheduled(true);timeline.SetMarkedForRemoval(false);if(!this._scheduledTimelines.includes(timeline))this._scheduledTimelines.push(timeline)}this._MaybeEnableRuntimeListeners()}DeScheduleTimeline(timeline){timeline.SetPlaying(false);timeline.SetScheduled(false);timeline.ResolvePlayPromise();C3.arrayFindRemove(this._scheduledTimelines,timeline);this._MaybeDisableRuntimeListeners()}CompleteTimeline(timeline){timeline.SetPlaying(false);
timeline.SetScheduled(false);if(this._playingTimelines.includes(timeline)){timeline.SetMarkedForRemoval(true);this._markedForRemovalTimelines.push(timeline);C3.arrayFindRemove(this._playingTimelines,timeline)}}CompleteTimelineBeforeChangeOfLayout(timeline){timeline.SetPlaying(false);timeline.SetScheduled(false);timeline.SetMarkedForRemoval(false);timeline.SetPlaybackRate(1);C3.arrayFindRemove(this._playingTimelines,timeline)}CompleteTimelineAndResolve(timeline){this.CompleteTimeline(timeline);timeline.ResolvePlayPromise()}_OnTick(){if(this.GetRuntime().IsLoadingState())return;
if(!this._hasRuntimeListeners)return;if(this._changingLayout)return;this._isTickingTimelines=true;while(this._scheduledTimelines.length){const t=this._scheduledTimelines.pop();t.SetInitialState();if(t.GetRenderChange()!==0)this._renderChange=1;this._playingTimelines.push(t)}const dt=this._runtime._GetDtFast();const dt1=this._runtime.GetDt1();const ts=this._runtime.GetTimeScale();for(let i=this._playingTimelines.length-1;i>=0;i--){const t=this._playingTimelines[i];if(t)t.Tick(dt,ts,dt1)}this._isTickingTimelines=
false;if(this._renderChange!==0)this.GetRuntime().UpdateRender()}_OnTick2(){if(this.GetRuntime().IsLoadingState())return;if(!this._hasRuntimeListeners)return;if(this._changingLayout)return;let timelinesToRemove;for(let i=0,l=this._markedForRemovalTimelines.length;i<l;i++){const t=this._markedForRemovalTimelines[i];if(!timelinesToRemove)timelinesToRemove=new Set;t.Removed();this._MaybeExecuteTimelineFinishTriggers(t);timelinesToRemove.add(t)}if(timelinesToRemove){C3.arrayRemoveAllInSet(this._markedForRemovalTimelines,
timelinesToRemove);this._renderChange=0;for(let i=0,l=this._playingTimelines.length;i<l;i++)if(this._playingTimelines[i].GetRenderChange()!==0){this._renderChange=1;break}}this._MaybeDisableRuntimeListeners()}_MaybeExecuteTimelineFinishTriggers(timeline){if(timeline.IsReleased())return;if(!timeline.HasValidTracks())return;if(timeline.IsComplete()&&timeline.InitialStateSet())timeline.FinishTriggers()}_MaybeEnableRuntimeListeners(){if(this._hasRuntimeListeners)return;this._hasRuntimeListeners=true}_MaybeDisableRuntimeListeners(){if(this._markedForRemovalTimelines.length)return;
if(this._playingTimelines.length)return;if(this._scheduledTimelines.length)return;if(this._isTickingTimelines)return;this._hasRuntimeListeners=false}_OnBeforeChangeLayout(){this._changingLayout=true;while(this._scheduledTimelines.length)this.DeScheduleTimeline(this._scheduledTimelines.pop());const timelinesToRemove=new Set;for(const t of this._playingTimelines){const remove=t._OnBeforeChangeLayout();if(remove){t.Removed();timelinesToRemove.add(t)}}C3.arrayRemoveAllInSet(this._playingTimelines,timelinesToRemove);
timelinesToRemove.clear();for(const t of this._markedForRemovalTimelines){const remove=t._OnBeforeChangeLayout();if(remove){t.Removed();timelinesToRemove.add(t)}}C3.arrayRemoveAllInSet(this._markedForRemovalTimelines,timelinesToRemove);this._MaybeDisableRuntimeListeners();for(const timeline of this._timelines)timeline.CleanCaches()}_OnAfterChangeLayout(){this._changingLayout=false}_OnInstanceDestroy(instance){const objectClass=instance.GetObjectClass();const timelines=this.GetTimelinesForObjectClass(objectClass);
if(!timelines)return;if(this._runtime.IsLoadingState())this._destroyedWhileLoadingState.push(instance);else for(const timeline of timelines){if(timeline.IsTemplate())continue;if(timeline.IsReleased()){this.Remove(timeline);continue}if(!timeline.HasValidTracks()){this._MaybeExecuteTimelineFinishTriggers(timeline);this.Remove(timeline)}}}_OnBeforeLoad(){for(const timeline of this._scheduledTimelines.map(t=>t)){this._MaybeExecuteTimelineFinishTriggers(timeline);this.Remove(timeline)}for(const timeline of this._playingTimelines.map(t=>
t)){this._MaybeExecuteTimelineFinishTriggers(timeline);this.Remove(timeline)}}_OnAfterLoad(){for(const destroyedInstance of this._destroyedWhileLoadingState)this._OnInstanceDestroy(destroyedInstance);C3.clearArray(this._destroyedWhileLoadingState)}_OnAfterLayoutStart(){const layoutManager=this._runtime.GetLayoutManager();const runningLayout=layoutManager.GetMainRunningLayout();if(!runningLayout)return;for(const timeline of this._timelines){const startOnLayout=timeline.GetStartOnLayout();if(!startOnLayout)continue;
if(runningLayout.GetName()===startOnLayout)this.ScheduleTimeline(timeline)}}_SaveToJson(){return{"timelinesJson":this._SaveTimelinesToJson(),"scheduledTimelinesJson":this._SaveScheduledTimelinesToJson(),"playingTimelinesJson":this._SavePlayingTimelinesToJson(),"markedForRemovalTimelinesJson":this._SaveMarkedForRemovalTimelinesToJson(),"hasRuntimeListeners":this._hasRuntimeListeners,"changingLayout":this._changingLayout,"isTickingTimelines":this._isTickingTimelines}}_LoadFromJson(o){if(!o)return;this._ClearCreatedTemplateTimelinesCount();
this._LoadTimelinesFromJson(o["timelinesJson"]);this._LoadScheduledTimelinesFromJson(o["scheduledTimelinesJson"]);this._LoadPlayingTimelinesFromJson(o["playingTimelinesJson"]);this._LoadMarkedForRemovalTimelinesFromJson(o["markedForRemovalTimelinesJson"]);this._hasRuntimeListeners=!o["hasRuntimeListeners"];this._changingLayout=!!o["changingLayout"];this._isTickingTimelines=!!o["isTickingTimelines"];this._SetCreatedTemplateTimelinesCount();this._MaybeEnableRuntimeListeners();this._MaybeDisableRuntimeListeners()}_SaveTimelinesToJson(){return this._timelines.map(timelineState=>
timelineState._SaveToJson())}_LoadTimelinesFromJson(timelinesJson){for(const timelineJson of timelinesJson){let timeline=this.GetTimelineByName(timelineJson["name"]);if(timeline)timeline._LoadFromJson(timelineJson);else{const templateName=this._GetTemplateNameFromJson(timelineJson);if(!templateName)continue;const templateTimeline=this.GetTimelineByName(templateName);timeline=this.CreateFromTemplate(templateTimeline);timeline._LoadFromJson(timelineJson)}if(!timeline.HasTracks())this.Remove(timeline)}}_GetTemplateNameFromJson(timelineJson){const name=
timelineJson["name"];const nameParts=name.split(":");if(!nameParts||nameParts.length!==2)return null;return nameParts[0]}_SaveScheduledTimelinesToJson(){return this._SaveTimelines(this._scheduledTimelines)}_LoadScheduledTimelinesFromJson(scheduledTimelinesJson){this._LoadTimelines(scheduledTimelinesJson,this._scheduledTimelines)}_SavePlayingTimelinesToJson(){return this._SaveTimelines(this._playingTimelines)}_LoadPlayingTimelinesFromJson(playingTimelinesJson){this._LoadTimelines(playingTimelinesJson,
this._playingTimelines)}_SaveMarkedForRemovalTimelinesToJson(){return this._SaveTimelines(this._markedForRemovalTimelines)}_LoadMarkedForRemovalTimelinesFromJson(markedForRemovalTimelinesJson){this._LoadTimelines(markedForRemovalTimelinesJson,this._markedForRemovalTimelines)}_IsTimelineInJson(timeline,json){if(!json)return false;for(const name of json)if(name===timeline.GetName())return true;return false}_SaveTimelines(collection){return collection.map(t=>t.GetName())}_LoadTimelines(timelinesJson,
collection){const timelinesToRemove=new Set;for(const timeline of collection)if(!this._IsTimelineInJson(timeline,timelinesJson))timelinesToRemove.add(timeline);C3.arrayRemoveAllInSet(collection,timelinesToRemove);if(timelinesJson){const ff=tn=>t=>t.GetName()===tn;for(const name of timelinesJson){const timeline=this.GetTimelineByName(name);if(timeline){const t=collection.find(ff(name));if(!t)collection.push(timeline)}}}}};

}

// timelines/timelineInfo.js
{
'use strict';const C3=self.C3;const STEPS=100;const LENGTH_STEP_SIZE=.01;const BEZIER_STEP_SIZE=30;const TANGENT_RESULT=[0,0];const MAP_RESULT=[0,0];const PROJECTION_RESULT=[0,0,0,0,0];
C3.TimelineInfo=class TimelineInfo{constructor(timeline,trackId){this._initialized=false;this._timeline=timeline;this._segments=[];let trackState=null;if(trackId)trackState=this._timeline.GetTrackById(trackId);else trackState=C3.first(this._timeline.GetTracks());if(!trackState)return;const xTrack=trackState.GetPropertyTrack("offsetX");const yTrack=trackState.GetPropertyTrack("offsetY");if(!xTrack||!yTrack)return;this._xTrack=xTrack;this._yTrack=yTrack;const xPropertyKeyframes=xTrack.GetPropertyKeyframeDataItemArrayIncludingDisabled();
const yPropertyKeyframes=yTrack.GetPropertyKeyframeDataItemArrayIncludingDisabled();for(let i=1,len=Math.min(xPropertyKeyframes.length,yPropertyKeyframes.length);i<len;++i){const startX=xPropertyKeyframes[i];const endX=startX.GetNext();const prevX=startX.GetPrevious();const startY=yPropertyKeyframes[i];const endY=startY.GetNext();const prevY=startY.GetPrevious();if(prevX&&prevX.GetPathMode()==="cubic-bezier"&&prevY&&prevY.GetPathMode()==="cubic-bezier")this._segments.push(C3.New(C3.TimelineCubicBezierSegmentInfo,
prevX,prevY,startX,startY,this._segments.length));else if(prevX&&prevX.GetPathMode()==="line"&&prevY&&prevY.GetPathMode()==="line")this._segments.push(C3.New(C3.TimelineLineSegmentInfo,startX,startY,this._segments.length));else this._segments.push(C3.New(C3.TimelineLineSegmentInfo,startX,startY,this._segments.length))}this._initialized=true}Release(){for(const segment of this._segments)segment.Release();C3.clearArray(this._segments);this._segments=null;this._timeline=null;this._xTrack=null;this._yTrack=
null}WasInitialized(){return this._initialized}segments(){return this._segments}SetOrigin(wi){const ox=this._xTrack.GetResultMode()==="relative"?wi.GetX():0;const oy=this._yTrack.GetResultMode()==="relative"?wi.GetY():0;for(const segment of this._segments)segment.SetOrigin(ox,oy)}Project(x,y,opts){if(opts&&opts.tRange){if(!C3.IsFiniteNumber(opts.tRange[0]))opts.tRange[0]=0;if(!C3.IsFiniteNumber(opts.tRange[1]))opts.tRange[1]=1}const ret=[];for(const segment of this._segments)if(segment.GetType()===
"cubic-bezier"){const p=segment.Project(x,y,opts?opts.tRange:null);p[4]=segment.GetIndex();ret.push(JSON.parse(JSON.stringify(p)))}ret.sort((f,s)=>f[3]-s[3]);return ret[0]}Tangent(t,segmentIndex){return this._segments[segmentIndex].Tangent(t)}TangentAngle(x,y,t,segmentIndex){return this._segments[segmentIndex].TangentAngle(x,y,t)}};
C3.TimelineCubicBezierSegmentInfo=class TimelineCubicBezierSegmentInfo{constructor(startX,startY,endX,endY,index){this._index=index;const startXAddon=startX.GetAddOn("cubic-bezier");const endXAddon=endX.GetAddOn("cubic-bezier");const startYAddon=startY.GetAddOn("cubic-bezier");const endYAddon=endY.GetAddOn("cubic-bezier");this._aX=startX.GetValueWithResultMode();this._aY=startY.GetValueWithResultMode();this._bX=startX.GetValueWithResultMode()+startXAddon.GetStartAnchor();this._bY=startY.GetValueWithResultMode()+
startYAddon.GetStartAnchor();this._cX=endX.GetValueWithResultMode()+endXAddon.GetEndAnchor();this._cY=endY.GetValueWithResultMode()+endYAddon.GetEndAnchor();this._dX=endX.GetValueWithResultMode();this._dY=endY.GetValueWithResultMode();this._initialized=false;this._len=STEPS;this._arcLengths=new Array(this._len+1);this._arcLengths[0]=0;this._length=0;this._lut=[];this._CalculateLength()}Release(){C3.clearArray(this._arcLengths);this._arcLengths=null;C3.clearArray(this._lut);this._lut=null}GetType(){return"cubic-bezier"}GetIndex(){return this._index}GetStepCount(){return Math.floor(this._length/
BEZIER_STEP_SIZE)}GetStepIncrement(){return 1/this.GetStepCount()}SetOrigin(ox,oy){this._originX=ox;this._originY=oy;this._arcLengths=new Array(this._len+1);this._arcLengths[0]=0;this._CalculateLength()}Map(u){if(!this._initialized)return NaN;const mt=this._Map(u);MAP_RESULT[0]=this._X(mt);MAP_RESULT[1]=this._Y(mt);return MAP_RESULT}Project(x,y,tRange){const lut=this._GenerateLUT(STEPS);const i=this._FindClosestFromLUT(x,y,lut,tRange);const p=this._RefineProjection(x,y,lut,i);PROJECTION_RESULT[0]=
p.x;PROJECTION_RESULT[1]=p.y;PROJECTION_RESULT[2]=p.t;PROJECTION_RESULT[3]=p.distance;return PROJECTION_RESULT}Tangent(t){const mt=1-t;const a=mt*mt;const b=2*mt*t;const c=t*t;const d0x=3*(this._bX+this._originX-(this._aX+this._originX));const d0y=3*(this._bY+this._originY-(this._aY+this._originY));const d1x=3*(this._cX+this._originX-(this._bX+this._originX));const d1y=3*(this._cY+this._originY-(this._bY+this._originY));const d2x=3*(this._dX+this._originX-(this._cX+this._originX));const d2y=3*(this._dY+
this._originY-(this._cY+this._originY));const dx=a*d0x+b*d1x+c*d2x;const dy=a*d0y+b*d1y+c*d2y;const m=Math.hypot(dx,dy);TANGENT_RESULT[0]=dx/m;TANGENT_RESULT[1]=dy/m;return TANGENT_RESULT}TangentAngle(x,y,t){const tanget=this.Tangent(t);const angle=C3.angleTo(x,y,x+tanget[0],y+tanget[1]);return angle}_Map(u){if(!this._initialized)return;let targetLength=u*this._arcLengths[this._len];let low=0;let high=this._len;let index=0;while(low<high){index=low+((high-low)/2|0);if(this._arcLengths[index]<targetLength)low=
index+1;else high=index}if(this._arcLengths[index]>targetLength)index--;const lengthBefore=this._arcLengths[index];if(lengthBefore===targetLength)return index/this._len;else return(index+(targetLength-lengthBefore)/(this._arcLengths[index+1]-lengthBefore))/this._len}_X(t){if(!this._initialized)return NaN;return self.Ease.GetRuntimeEase("cubicbezier")(t,this._aX+this._originX,this._bX+this._originX,this._cX+this._originX,this._dX+this._originX)}_Y(t){if(!this._initialized)return NaN;return self.Ease.GetRuntimeEase("cubicbezier")(t,
this._aY+this._originY,this._bY+this._originY,this._cY+this._originY,this._dY+this._originY)}_GenerateLUT(steps){steps=steps||STEPS;if(this._lut.length===steps)return this._lut;this._lut=[];steps++;for(let i=0;i<steps;i++){const t=i/(steps-1);const x=this._X(t);const y=this._Y(t);this._lut.push({x:x,y:y,t:t,distance:0})}return this._lut}_FindClosestFromLUT(x,y,LUT,tRange=null,distance=Number.MAX_SAFE_INTEGER){let i=0;LUT.forEach((p,index)=>{p.t=index/(LUT.length-1);p.distance=C3.distanceTo(x,y,p.x,
p.y);if(tRange&&C3.IsArray(tRange)&&C3.IsFiniteNumber(tRange[0])&&C3.IsFiniteNumber(tRange[1])){if(p.t>=tRange[0]&&p.t<=tRange[1])if(p.distance<distance){distance=p.distance;i=index}}else if(p.distance<distance){distance=p.distance;i=index}});return i}_RefineProjection(x,y,LUT,i,targetDistance=0,epsilon=1){let q=LUT[i];let count=1;let distance=Number.MAX_SAFE_INTEGER;do{let i1=i===0?0:i-1;let i2=i===LUT.length-1?LUT.length-1:i+1;let t1=LUT[i1].t;let t2=LUT[i2].t;let lut=[];let step=(t2-t1)/4;if(step<
.001)break;lut.push(LUT[i1]);for(let j=1;j<=3;j++){const t=t1+j*step;const pathX=this._X(t);const pathY=this._Y(t);const pathDistance=Math.abs(C3.distanceTo(pathX,pathY,x,y)-targetDistance);if(pathDistance<distance){distance=pathDistance;q={x:pathX,y:pathY,t:t,distance:pathDistance};i=j}lut.push({x:pathX,y:pathY,t:t,distance:pathDistance})}lut.push(LUT[i2]);LUT=lut}while(count++<25);if(targetDistance&&distance>epsilon)q=null;return q}_CalculateLength(){this._initialized=true;let ox=this._X(0);let oy=
this._Y(0);let clen=0;for(let i=1;i<=this._len;i++){const x=this._X(i*LENGTH_STEP_SIZE);const y=this._Y(i*LENGTH_STEP_SIZE);const dx=ox-x;const dy=oy-y;clen+=Math.hypot(dx,dy);this._arcLengths[i]=clen;ox=x;oy=y}this._length=clen}};
C3.TimelineLineSegmentInfo=class TimelineLineSegmentInfo{constructor(startX,startY,index){this._index=index;this._targetX=startX.GetValueWithResultMode();this._targetY=startY.GetValueWithResultMode();this._originX=0;this._originY=0}Release(){}GetType(){return"line"}GetIndex(){return this._index}SetOrigin(ox,oy){this._originX=ox;this._originY=oy}GetX(){return this._targetX+this._originX}GetY(){return this._targetY+this._originY}};

}

// timelines/state/timelineState.js
{
'use strict';const C3=self.C3;const PING_PONG_BEGIN=0;const PING_PONG_END=1;
C3.TimelineState=class Timeline extends C3.DefendedBase{constructor(name,timelineDataItem,timelineManager){super();this._runtime=timelineManager.GetRuntime();this._timelineManager=timelineManager;this._timelineDataItem=timelineDataItem;this._name=name;this._tracks=[];this._tracksLength=0;this._beforeAndAfterTracks=null;this._beforeAndAfterTracksLength=0;this.CreateTrackStates();this._playPromise=null;this._playResolve=null;this._playheadTime=0;this._playbackRate=1;this._pingPongState=PING_PONG_BEGIN;
this._currentRepeatCount=1;this._isPlaying=false;this._isScheduled=false;this._initialStateSet=false;this._complete=true;this._released=false;this._markedForRemoval=false;this._completedTick=-1;this._implicitPause=false;this._isTemplate=false;this._finishedTriggers=false;this._firstTick=false;this._lastDelta=NaN;this._tags=[""];this._stringTags="";this._tagsChanged=false;this._renderChange=0;this._hasNestedContent=0;this._iTimelineState=null}static CreateInitial(timelineDataJson,timelineManager){const timelineDataManager=
timelineManager.GetTimelineDataManager();const nameId=timelineDataManager.GetNameId();const timelineDataItem=timelineDataManager.Get(timelineDataJson[nameId]);const timeline=C3.New(C3.TimelineState,timelineDataJson[nameId],timelineDataItem,timelineManager);timeline.SetIsTemplate(true);return timeline}static CreateFromTemplate(name,timelineDataItem,timelineManager){return C3.New(C3.TimelineState,name,timelineDataItem,timelineManager)}Release(){if(this.IsReleased())return;const dispatcher=this._runtime.Dispatcher();
this._timelineManager.DeScheduleTimeline(this);this._timelineManager.CompleteTimelineAndResolve(this);for(const track of this._tracks)track.Release();C3.clearArray(this._tracks);this._tracks=null;this._runtime=null;this._timelineManager=null;this._timelineDataItem=null;this._released=true;this._playPromise=null;this._playResolve=null;this.FireReleaseEvent(dispatcher)}FireReleaseEvent(dispatcher){const event=C3.New(C3.Event,"timelinestatereleased");event.timelineState=this;dispatcher.dispatchEvent(event)}GetType(){return 0}CreateTrackStates(){for(const trackDataItem of this._timelineDataItem.GetTrackData().trackDataItems())this._tracksLength=
this._tracks.push(C3.TrackState.Create(this,trackDataItem))}GetTimelineManager(){return this._timelineManager}GetRuntime(){return this._runtime}GetTracks(){return this._tracks}GetSimilarPropertyTracks(instance,sourceAdapter,propertyName){if(!this._hasNestedContent)return;let ret;for(let i=0;i<this._tracks.length;i++){let track=this._tracks[i];if(instance!==track.GetInstance())continue;const propertyTrack=track.GetPropertyTrack(propertyName);if(!propertyTrack)continue;if(sourceAdapter.constructor!==
propertyTrack.GetSourceAdapter().constructor)continue;if(!ret)ret=[];ret.push(propertyTrack)}return ret}HasTracks(){return!!this._tracks.length}GetTrackById(trackId){for(const track of this._tracks)if(C3.equalsNoCase(track.GetId(),trackId))return track;return null}GetTrackByName(name){for(const track of this._tracks){if(track.IsInstanceTrack())continue;if(C3.equalsNoCase(track.GetName(),name))return track}return null}SetName(name){this._name=name}GetName(){return this._name}GetTimelineDataItem(){return this._timelineDataItem}GetTemplateName(){return this._timelineDataItem.GetName()}GetTotalTime(){return this._timelineDataItem.GetTotalTime()}SetTotalTime(tt){this._timelineDataItem.SetTotalTime(tt)}GetStep(){return this._timelineDataItem.GetStep()}SetStep(s){this._timelineDataItem.SetStep(s)}GetInterpolationMode(){return this._timelineDataItem.GetInterpolationMode()}SetInterpolationMode(im){this._timelineDataItem.SetInterpolationMode(im)}GetResultMode(){return this._timelineDataItem.GetResultMode()}SetResultMode(rm){this._timelineDataItem.GetResultMode(rm)}SetEase(e){for(const track of this.GetTracks())track.SetEase(e)}GetLoop(){return this._timelineDataItem.GetLoop()}SetLoop(l){return this._timelineDataItem.SetLoop(l)}GetPingPong(){return this._timelineDataItem.GetPingPong()}SetPingPong(p){return this._timelineDataItem.SetPingPong(p)}GetRepeatCount(){return this._timelineDataItem.GetRepeatCount()}SetRepeatCount(rc){return this._timelineDataItem.SetRepeatCount(rc)}SetPlaybackRate(r){return this._playbackRate=
r}GetPlaybackRate(){return this._playbackRate}GetStartOnLayout(){return this._timelineDataItem.GetStartOnLayout()}GetTransformWithSceneGraph(){return this._timelineDataItem.GetTransformWithSceneGraph()}GetUseSystemTimescale(){return this._timelineDataItem.GetUseSystemTimescale()}IsForwardPlayBack(){if(!this.IsPlaying())return true;return this._playbackRate>0}GetPlayPromise(){if(this._playPromise)return this._playPromise;this._playPromise=new Promise(resolve=>{this._playResolve=resolve});return this._playPromise}ResolvePlayPromise(){if(!this._playPromise)return;
this._playResolve();this._playPromise=null;this._playResolve=null}SetTags(tags){this._tags=C3.TimelineState._GetTagArray(tags);this._tagsChanged=true}GetTags(){return this._tags}GetStringTags(){if(this._tagsChanged)this._stringTags=this._tags.join(" ");this._tagsChanged=false;return this._stringTags}HasTags(tags){if(!this._tags)return false;if(!this._tags.length)return false;const t=C3.TimelineState._GetTagArray(tags);if(!t)return false;if(!t.length)return false;return t.every(C3.TimelineState._HasTag,
this)}OnStarted(){if(!C3.Plugins.Timeline||this.constructor!==C3.TimelineState)return;C3.Plugins.Timeline.Cnds.PushTriggerTimeline(this);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineStarted);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineStartedByName);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineStartedByTags);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnAnyTimelineStarted);C3.Plugins.Timeline.Cnds.PopTriggerTimeline()}OnCompleted(){this._completedTick=
this._runtime.GetTickCount()}FinishTriggers(){if(this._finishedTriggers)return;this._finishedTriggers=true;if(!C3.Plugins.Timeline||this.constructor!==C3.TimelineState)return;C3.Plugins.Timeline.Cnds.PushTriggerTimeline(this);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineFinished);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineFinishedByName);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineFinishedByTags);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnAnyTimelineFinished);
C3.Plugins.Timeline.Cnds.PopTriggerTimeline()}SetPlaying(p){this._isPlaying=p}IsCompletedTick(){return this._completedTick===this._runtime.GetTickCount()}IsPlaying(playingOnly=false){if(this.IsCompletedTick())return true;if(this.IsScheduled()&&!playingOnly)return true;return this._isPlaying}_IsPlaying(){return this.IsPlaying(true)}IsPaused(){return this._IsPaused()}_IsPaused(){if(this.IsReleased())return false;if(this.IsScheduled())return false;if(this._IsPlaying())return false;if(this.IsComplete())return false;
return true}SetScheduled(s){this._isScheduled=s}IsScheduled(){return this._isScheduled}SetComplete(c){this._complete=c;const t=this.GetTime();if(t<=0||t>=this.GetTotalTime())this._complete=true}IsComplete(){return this._complete}IsReleased(){return this._released}SetMarkedForRemoval(mfr){this._markedForRemoval=mfr}IsMarkedForRemoval(){return this._markedForRemoval}SetImplicitPause(ip){this._implicitPause=ip}IsImplicitPause(){return this._implicitPause}SetIsTemplate(it){this._isTemplate=!!it}IsTemplate(){return this._isTemplate}InitialStateSet(){return this._initialStateSet}GetTime(){return this._playheadTime}SetTime(time){const lastGlobalTime=
this.GetTime();this._SetTime(time);this.SetComplete(false);if(!this.IsComplete())this.SetImplicitPause(true);if(!this._IsPlaying()&&!this.IsScheduled()&&this._initialStateSet);else if(!this._IsPlaying()&&!this.IsScheduled()&&!this._initialStateSet)this.SetInitialStateFromSetTime();else if(this._IsPlaying())this.Stop();else if(this.IsScheduled()){this._timelineManager.DeScheduleTimeline(this);this.SetInitialStateFromSetTime()}this._SetUpdateStateBefore();this._Interpolate(this.GetTime(),false,true,
true,lastGlobalTime);this._SetUpdateStateAfter();if(this._renderChange)this.GetRuntime().UpdateRender();this._OnSetTime()}_SetTime(time){if(!C3.IsFiniteNumber(time))time=this.GetTotalTime();if(time<0)this._playheadTime=0;else if(time>=this.GetTotalTime())this._playheadTime=this.GetTotalTime();else this._playheadTime=time}_SetTimeAndReset(time){if(!C3.IsFiniteNumber(time))time=this.GetTotalTime();if(time<0)this._playheadTime=0;else if(time>=this.GetTotalTime())this._playheadTime=this.GetTotalTime();
else this._playheadTime=time;for(const track of this._tracks)track.SetResetState()}_OnSetTime(){if(!C3.Plugins.Timeline||this.constructor!==C3.TimelineState)return;C3.Plugins.Timeline.Cnds.PushTriggerTimeline(this);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimeSet);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimeSetByName);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimeSetByTags);C3.Plugins.Timeline.Cnds.PopTriggerTimeline()}_CanResume(){if(this.GetLoop())return true;
else if(this.GetPingPong()&&this._pingPongState===PING_PONG_END)if(this.IsForwardPlayBack()){if(this.GetTime()>=this.GetTotalTime())return false}else{if(this.GetTime()<=0)return false}else if(!this.GetLoop()&&!this.GetPingPong())if(this.IsForwardPlayBack()){if(this.GetTime()>=this.GetTotalTime())return false}else if(this.GetTime()<=0)return false;return true}Resume(){if(this.IsReleased())return;if(this._CanResume())this.Play(true)}Play(resume=false){if(this.IsReleased())return false;if(this.IsScheduled())return false;
if(this._IsPlaying()&&this.IsCompletedTick())return this._SchedulePlayingTimeline();if(this._IsPlaying())return false;if(!this.IsComplete()&&!resume&&!this.IsImplicitPause())return false;return this._ScheduleStoppedTimeline()}_SchedulePlayingTimeline(){this.SetImplicitPause(false);this._timelineManager.RemovePlayingTimeline(this);this._timelineManager.ScheduleTimeline(this);this.GetPlayPromise();return true}_ScheduleStoppedTimeline(){this.SetImplicitPause(false);this._timelineManager.ScheduleTimeline(this);
this.GetPlayPromise();return true}Stop(completed=false){if(this.IsReleased())return;this.SetComplete(completed);this._timelineManager.CompleteTimeline(this);if(this.IsComplete())this.ResolvePlayPromise()}Reset(render=true,beforeChangeLayout=false){if(this.IsReleased())return;if(!this._IsPlaying()&&this.IsScheduled())return this._timelineManager.DeScheduleTimeline(this);if(this.IsComplete())return;this.Stop(true);if(this.IsForwardPlayBack())this._SetTime(0);else this._SetTime(this.GetTotalTime());
const time=this.GetTime();this._SetUpdateStateBefore();if(beforeChangeLayout)this._InterpolateBeforeChangeLayout(time);else this._Interpolate(time,false,false,true);if(render)this._OnSetTime();this._SetUpdateStateAfter();if(this._renderChange&&render)this.GetRuntime().UpdateRender()}ResetBeforeChangeLayout(){this.Reset(false,true)}_InterpolateBeforeChangeLayout(time){this._Interpolate(time,false,false,true,NaN,false,true)}_OnBeforeChangeLayout(){if(this.IsReleased())return true;if(!this.GetRuntime().IsLoadingState())if(this.HasValidGlobalTracks())return false;
this._timelineManager.CompleteTimelineBeforeChangeOfLayout(this);if(!this.GetRuntime().IsLoadingState())this.ResetBeforeChangeLayout();return true}SetInitialStateFromSetTime(){this.SetInitialState(true)}SetInitialState(fromSetTime){if(this.IsMarkedForRemoval())return;if(fromSetTime){this._finishedTriggers=false;this._initialStateSet=true;this._firstTick=true;this._SetUpdateStateBefore();for(const track of this._tracks)track.SetInitialState();this._SetUpdateStateAfter()}else{this.SetPlaying(true);
this.SetScheduled(false);this.OnStarted();if(this.IsComplete()){this._completedTick=-1;if(this._pingPongState!==PING_PONG_BEGIN)this._playbackRate=Math.abs(this._playbackRate);this._pingPongState=PING_PONG_BEGIN;this._currentRepeatCount=1;this._complete=false;this._finishedTriggers=false;this._initialStateSet=true;this._firstTick=true;if(this.IsForwardPlayBack())this._SetTime(0);else this._SetTime(this.GetTotalTime());this._SetUpdateStateBefore();for(const track of this._tracks)track.SetInitialState();
this._SetUpdateStateAfter()}else{this._firstTick=true;this._finishedTriggers=false;this._SetUpdateStateBefore();for(const track of this._tracks)track.SetResumeState();this._SetUpdateStateAfter()}}}GetRenderChange(){return this._renderChange}_SetUpdateStateBefore(){this._hasNestedContent=0;for(const track of this._tracks)if(track.IsNested())this._hasNestedContent=1}_SetUpdateStateAfter(){this._renderChange=0;for(const track of this._tracks){track._SetUpdateState();if(this._renderChange===0&&track.GetRenderChange()===
1)this._renderChange=1;if(!this._beforeAndAfterTracks&&track.GetNeedsBeforeAndAfter()===1){if(!this._beforeAndAfterTracks)this._beforeAndAfterTracks=[];this._beforeAndAfterTracksLength=this._beforeAndAfterTracks.push(track)}}}Tick(deltaTime,timeScale,deltaTime1){if(this.GetUseSystemTimescale()){if(deltaTime===0&&this._lastDelta===0)return;this._lastDelta=deltaTime}else{if(deltaTime1===0&&this._lastDelta===0)return;this._lastDelta=deltaTime1;deltaTime=deltaTime1;timeScale=1}const lastTime=this._playheadTime;
const newDeltaTime=deltaTime*timeScale*this._playbackRate;const newTime=lastTime+newDeltaTime;const totalTime=this._timelineDataItem._totalTime;if(newTime<0)this._playheadTime=0;else if(newTime>=totalTime)this._playheadTime=totalTime;else this._playheadTime=newTime;let complete=false;let ensureValue=false;const loop=this.GetLoop();const pingPong=this.GetPingPong();if(!loop&&!pingPong)if(this._playbackRate>0){if(this._playheadTime>=totalTime)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;
this._SetTimeAndReset(0);ensureValue=true}else{this._SetTime(totalTime);complete=true}}else{if(this._playheadTime<=0)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._SetTimeAndReset(totalTime);ensureValue=true}else{this._SetTime(0);complete=true}}else if(loop&&!pingPong)if(this._playbackRate>0){if(this._playheadTime>=totalTime){this._SetTimeAndReset(0);ensureValue=true}}else{if(this._playheadTime<=0){this._SetTimeAndReset(totalTime);ensureValue=true}}else if(!loop&&
pingPong)if(this._playbackRate>0){if(this._playheadTime>=totalTime){this._SetTime(totalTime);this.SetPlaybackRate(this.GetPlaybackRate()*-1);ensureValue=true;if(this._pingPongState===PING_PONG_END)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._pingPongState=PING_PONG_BEGIN}else complete=true;else if(this._pingPongState===PING_PONG_BEGIN)this._pingPongState=PING_PONG_END}}else{if(this._playheadTime<=0){this._SetTime(0);this.SetPlaybackRate(this.GetPlaybackRate()*
-1);ensureValue=true;if(this._pingPongState===PING_PONG_END)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._pingPongState=PING_PONG_BEGIN}else complete=true;else if(this._pingPongState===PING_PONG_BEGIN)this._pingPongState=PING_PONG_END}}else if(loop&&pingPong)if(this._playbackRate>0){if(this._playheadTime>=totalTime){this._SetTime(totalTime);this.SetPlaybackRate(this.GetPlaybackRate()*-1);ensureValue=true;this._pingPongState++;C3.wrap(this._pingPongState,0,2)}}else if(this._playheadTime<=
0){this._SetTime(0);this.SetPlaybackRate(this.GetPlaybackRate()*-1);ensureValue=true;this._pingPongState++;C3.wrap(this._pingPongState,0,2)}let i;const l=this._tracksLength;if(complete){for(i=0;i<l;i++)this._tracks[i].SetEndState();this.Stop(true);this.OnCompleted();return}const bal=this._beforeAndAfterTracksLength;for(i=0;i<bal;i++)this._beforeAndAfterTracks[i].BeforeInterpolate();if(this._hasNestedContent===1)for(i=0;i<l;i++){const track=this._tracks[i];const startOffset=track.GetStartOffset();
const localTime=this._playheadTime-startOffset;const lastLocalTime=lastTime-startOffset;if(localTime<0&&lastLocalTime>0){if(startOffset<0)this._playheadTime=0;else if(startOffset>=totalTime)this._playheadTime=totalTime;else this._playheadTime=startOffset;track.Interpolate(startOffset,true,false,ensureValue,this._firstTick,false)}else track.Interpolate(this._playheadTime,true,false,ensureValue,this._firstTick,false)}else for(i=0;i<l;i++)this._tracks[i].Interpolate(this._playheadTime,true,false,ensureValue,
this._firstTick,false);for(i=0;i<bal;i++)this._beforeAndAfterTracks[i].AfterInterpolate();if(this._firstTick)this._firstTick=false}_Interpolate(time,isTicking=false,setTime=false,ensureValue=false,lastTime=NaN,onTickCall=false,ignoreGlobals=false){for(const track of this._tracks)track.BeforeInterpolate();for(const track of this._tracks){let t=time;if(typeof lastTime==="number"&&!isNaN(lastTime)){const globalTime=this.GetTime();const localTime=globalTime-track.GetStartOffset();const lastLocalTime=
lastTime-track.GetStartOffset();if(localTime<0&&lastLocalTime>0){t=track.GetStartOffset();this._SetTime(t)}}track.Interpolate(t,isTicking,setTime,ensureValue,this._firstTick,ignoreGlobals)}for(const track of this._tracks)track.AfterInterpolate();if(this._firstTick&&onTickCall)this._firstTick=false}AddTrack(){const trackDataItem=this._timelineDataItem.GetTrackData().AddEmptyTrackDataItem();const track=C3.TrackState.Create(this,trackDataItem);this._tracksLength=this._tracks.push(track);return track}Removed(){if(this.IsReleased())return;
for(const track of this._tracks)track.TimelineRemoved()}CleanCaches(){for(const track of this._tracks)track.CleanCaches()}ClearTrackInstances(){for(const track of this._tracks)track.ClearInstance()}SetTrackInstance(trackId,instance){if(!instance)return;for(const track of this._tracks){if(!track.IsInstanceTrack())continue;if(trackId){if(track.GetId()!==trackId)continue;track.SetInstance(instance);this._timelineManager.SetTimelineObjectClassToMap(instance.GetObjectClass(),this);break}else{if(track.HasInstance())continue;
track.SetInstance(instance);this._timelineManager.SetTimelineObjectClassToMap(instance.GetObjectClass(),this);break}}}HasTrackInstance(instance,trackId){for(const track of this._tracks){if(!track.IsInstanceTrack())continue;if(trackId){if(trackId===track.GetId()&&instance===track.GetInstance())return true}else if(instance===track.GetInstance())return true}return false}HasValidTracks(){return this._tracks.some(t=>{if(t.IsInstanceTrack())return t.CanInstanceBeValid();else return true})}HasValidGlobalTracks(){return this._tracks.some(t=>
{if(t.IsInstanceTrack()){if(!t.CanInstanceBeValid())return false;const objectClass=t.GetObjectClass();if(!objectClass)return false;return objectClass.IsGlobal()}else return false})}GetPropertyTrack(propertyName){for(const track of this.GetTracks())for(const propertyTrack of track.GetPropertyTracks())if(propertyTrack.GetPropertyName()===propertyName)return propertyTrack}GetTrackFromInstance(instance){for(const track of this._tracks)if(instance===track.GetInstance())return track;return null}GetKeyframeWithTags(tags){let tagsArray=
tags?tags.split(" "):[];const tagsSet=new Set(tagsArray.map(t=>t.toLowerCase().trim()));tagsArray=[...tagsSet.values()];for(const track of this.GetTracks())for(const keyframeDataItem of track.GetKeyframeDataItems()){const hasAllTags=tagsArray.every(t=>keyframeDataItem.HasTag(t));if(hasAllTags)return keyframeDataItem}}GetObjectClasses(){const ret=[];for(const track of this.GetTracks())ret.push(track.GetObjectClass());return ret.filter(oc=>oc)}_SaveToJson(){return{"tracksJson":this._SaveTracksToJson(),
"name":this._name,"playheadTime":this.GetTime(),"playbackRate":this._playbackRate,"pingPongState":this._pingPongState,"currentRepeatCount":this._currentRepeatCount,"isPlaying":this._isPlaying,"isScheduled":this._isScheduled,"initialStateSet":this._initialStateSet,"finishedTriggers":this._finishedTriggers,"complete":this._complete,"released":this._released,"markedForRemoval":this._markedForRemoval,"completedTick":this._completedTick,"implicitPause":this._implicitPause,"isTemplate":this._isTemplate,
"tags":this._tags.join(" "),"stringTags":this._stringTags,"tagsChanged":this._tagsChanged,"firstTick":this._firstTick}}_LoadFromJson(o){if(!o)return;this._LoadTracksFromJson(o["tracksJson"]);this._name=o["name"];this._playheadTime=o["playheadTime"];this._playbackRate=o["playbackRate"];this._pingPongState=o["pingPongState"];this._currentRepeatCount=o["currentRepeatCount"];this._isPlaying=!!o["isPlaying"];this._isScheduled=!!o["isScheduled"];this._initialStateSet=!!o["initialStateSet"];this._finishedTriggers=
o.hasOwnProperty("finishedTriggers")?!!o["finishedTriggers"]:false;this._complete=!!o["complete"];this._released=!!o["released"];this._markedForRemoval=!!o["markedForRemoval"];this._completedTick=o["completedTick"];this._implicitPause=!!o["implicitPause"];this._isTemplate=!!o["isTemplate"];this._tags=o["tags"].split(" ");this._stringTags=o["stringTags"];this._tagsChanged=!!o["tagsChanged"];this._firstTick=!!o["firstTick"]}_SaveTracksToJson(){return this._tracks.map(trackState=>trackState._SaveToJson())}_LoadTracksFromJson(tracksJson){this.ClearTrackInstances();
tracksJson.forEach((trackJson,i)=>{const track=this._tracks[i];track._LoadFromJson(trackJson)});this._tracks.filter(track=>track.CanInstanceBeValid())}static _HasTag(tag){const tags=this.GetTags();if(tag==="")return tags.length===1&&tags[0]==="";return tags.map(t=>t.toLowerCase()).includes(tag.toLowerCase())}static _GetTagArray(tags){if(C3.IsArray(tags))return tags.slice(0);if(C3.IsString(tags))return tags.split(" ");throw new Error("invalid tags");}GetITimelineState(){if(!this._iTimelineState)this._iTimelineState=
C3.New(self.ITimelineState,this);return this._iTimelineState}};

}

// timelines/state/trackState.js
{
'use strict';const C3=self.C3;const INSTANCE_TRACK=0;const VALUE_TRACK=1;const AUDIO_TRACK=2;
C3.TrackState=class Track extends C3.DefendedBase{constructor(timeline,trackDataItem){super();this._timeline=timeline;this._trackDataItem=trackDataItem;this._trackData=trackDataItem.GetTrackData();this._instanceUid=NaN;this._objectClassIndex=NaN;this._instance=null;this._worldInfo=null;this._isNested=trackDataItem.GetStartOffset()>0;this._initialStateOfNestedSet=false;this._endStateOfNestedSet=false;this._lastKeyframeDataItem=null;this._keyframeDataItems=this._trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();
this._propertyTracks=[];this.CreatePropertyTrackStates();this._worldInfoChange=0;this._renderChange=0;this._needsBeforeAndAfter=0}static Create(timeline,trackDataItem){return C3.New(C3.TrackState,timeline,trackDataItem)}Release(){this._keyframeDataItems=null;for(const propertyTrack of this._propertyTracks)propertyTrack.Release();C3.clearArray(this._propertyTracks);this._propertyTracks=null;this._timeline=null;this._instance=null;this._worldInfo=null;this._trackDataItem=null;this._lastKeyframeDataItem=
null}CreatePropertyTrackStates(){for(const propertyTrackDataItem of this._trackDataItem.GetPropertyTrackData().propertyTrackDataItems())this._propertyTracks.push(C3.PropertyTrackState.Create(this,propertyTrackDataItem))}TimelineRemoved(){for(const propertyTrack of this._propertyTracks)propertyTrack.TimelineRemoved()}CleanCaches(){for(const propertyTrack of this._propertyTracks)propertyTrack.CleanCaches();this._instance=null;this._worldInfo=null}GetTimeline(){return this._timeline}GetRuntime(){return this._timeline.GetRuntime()}GetKeyframeDataItems(){if(this._keyframeDataItems)return this._keyframeDataItems;
this._keyframeDataItems=this._trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();return this._keyframeDataItems}GetPropertyTracks(){return this._propertyTracks}GetPropertyTrack(propertyName){for(let i=0;i<this._propertyTracks.length;i++){const propertyTrack=this._propertyTracks[i];if(propertyTrack.GetPropertyName()===propertyName)return propertyTrack}}MaybeGetInstance(){if(!this._instance)this.GetInstance()}IsInstanceValid(){if(!this._instance)return false;return!this._instance.IsDestroyed()}CanInstanceBeValid(){if(!this.IsInstanceTrack())return false;
const uid=this.GetInstanceUID();const instance=this.GetRuntime().GetInstanceByUID(uid);if(!instance)return false;return!instance.IsDestroyed()}GetObjectClass(){if(!this.IsInstanceTrack())return;const index=this.GetObjectClassIndex();if(index===-1)return;return this.GetRuntime().GetObjectClassByIndex(index)}ClearInstance(){this._instance=null;this._instanceUid=-1;this._worldInfo=null;this._objectClassIndex=-1}HasInstance(){return!!this._instance}GetInstance(){if(this._instance&&this.IsInstanceValid())return this._instance;
const uid=this.GetInstanceUID();this._instance=this.GetRuntime().GetInstanceByUID(uid);return this._instance}SetInstance(instance){if(this._instance===instance)return;this.CleanCaches();this._instance=instance;this._objectClassIndex=instance.GetObjectClass().GetIndex();this._instanceUid=instance.GetUID();this._worldInfo=instance.GetWorldInfo();for(const item of this.propertyTrackItems()){const propertyTrack=item.propertyTrack;const sourceAdapter=item.sourceAdapter;const id=propertyTrack.GetSourceAdapterId();
switch(id){case "instance-variable":{const index=sourceAdapter.GetEditorIndex();const objectClass=instance.GetObjectClass();const i=objectClass.GetInstanceVariableIndexByName(item.name);const name=objectClass.GetInstanceVariableName(i);const type=objectClass.GetInstanceVariableType(i);if(name===item.name&&type===item.type)sourceAdapter.UpdateInstanceVariableIndex(i);break}case "behavior":{const timelineBehaviorType=item.behaviorType;const trackObjectClass=this.GetObjectClass();const objectClass=instance.GetObjectClass();
const instanceBehaviorType=sourceAdapter.GetBehaviorType(objectClass);if(timelineBehaviorType&&instanceBehaviorType){const name=timelineBehaviorType.GetName();const templateBehaviorIndex=trackObjectClass.GetBehaviorIndexByName(name);const instanceBehaviorIndex=objectClass.GetBehaviorIndexByName(name);const propertyIndex=sourceAdapter.GetEditorIndex();sourceAdapter.UpdateBehaviorTypeSid(instanceBehaviorType.GetSID())}break}}}}*propertyTrackItems(){for(const propertyTrack of this._propertyTracks){const sourceAdapter=
propertyTrack.GetSourceAdapter();const objectClass=this.GetObjectClass();const ret={propertyTrack:propertyTrack,sourceAdapter:sourceAdapter};switch(propertyTrack.GetSourceAdapterId()){case "world-instance":{ret.property=propertyTrack.GetPropertyName();break}case "instance-variable":{const index=sourceAdapter.GetEditorIndex();ret.name=objectClass.GetInstanceVariableName(index);ret.type=objectClass.GetInstanceVariableType(index);break}case "effect":{const effectList=objectClass.GetEffectList();const effectType=
sourceAdapter.GetEffectType(effectList);ret.effectType=effectType;break}case "behavior":{const behaviorType=sourceAdapter.GetBehaviorType(objectClass);ret.behaviorType=behaviorType;break}case "plugin":{ret.plugin=objectClass.GetPlugin();break}case "value":{break}}yield ret}}GetWorldInfo(){if(this._worldInfo&&this.IsInstanceValid())return this._worldInfo;const instance=this.GetInstance();if(instance)this._worldInfo=instance.GetWorldInfo();return this._worldInfo}GetTrackDataItem(){return this._trackDataItem}GetInstanceUID(){if(this._instanceUid)return this._instanceUid;
return this._trackDataItem.GetInstanceUID()}SetInstanceUID(uid){this._trackDataItem.SetInstanceUID(uid)}GetInterpolationMode(){return this._trackDataItem.GetInterpolationMode()}SetInterpolationMode(im){this._trackDataItem.SetInterpolationMode(im)}GetResultMode(){return this._trackDataItem.GetResultMode()}GetId(){return this._trackDataItem.GetId()}GetStartOffset(){return this._trackDataItem.GetStartOffset()}GetLocalTotalTime(){return this._trackDataItem.GetLocalTotalTime()}SetLocalTotalTime(t){this._trackDataItem.SetLocalTotalTime(t)}SetResultMode(rm){this._trackDataItem.SetResultMode(rm)}SetEase(e){for(const keyframeDataItem of this.GetKeyframeDataItems())keyframeDataItem.SetEase(e);
for(const propertyTrack of this.GetPropertyTracks())propertyTrack.SetEase(e)}GetEnable(){return this._trackDataItem.GetEnable()}SetEnable(e){this._trackDataItem.SetEnable(e)}GetObjectClassIndex(){if(!isNaN(this._objectClassIndex))return this._objectClassIndex;return this._trackDataItem.GetObjectClassIndex()}SetObjectClassIndex(objectClassIndex){this._trackDataItem.SetObjectClassIndex(objectClassIndex)}SetOriginalWidth(w){this._trackDataItem.SetOriginalWidth(w)}GetOriginalWidth(){const instance=this.GetInstance();
if(instance){const sdkIntance=instance.GetSdkInstance();if(sdkIntance.IsOriginalSizeKnown())return instance.GetSdkInstance().GetOriginalWidth()}return this._trackDataItem.GetOriginalWidth()}SetOriginalHeight(h){this._trackDataItem.SetOriginalHeight(h)}GetOriginalHeight(){const instance=this.GetInstance();if(instance){const sdkIntance=instance.GetSdkInstance();if(sdkIntance.IsOriginalSizeKnown())return instance.GetSdkInstance().GetOriginalHeight()}return this._trackDataItem.GetOriginalHeight()}GetType(){return this._trackDataItem.GetType()}GetName(){return this._trackDataItem.GetName()}IsInstanceTrack(){return this.GetType()===
INSTANCE_TRACK}IsValueTrack(){return this.GetType()===VALUE_TRACK}IsAudioTrack(){return this.GetType()===AUDIO_TRACK}GetWorldInfoChange(){return this._worldInfoChange}GetRenderChange(){return this._renderChange}GetNeedsBeforeAndAfter(){return this._needsBeforeAndAfter}IsNested(){return this._isNested}SetResetState(){for(const propertyTrack of this._propertyTracks)propertyTrack.SetResetState()}SetInitialState(){this.MaybeGetInstance();if(!this.IsInstanceValid()&&this.IsInstanceTrack())return;const timeline=
this.GetTimeline();const isForwardPlayBack=timeline.IsForwardPlayBack();const time=isForwardPlayBack?0:this.GetLocalTotalTime();for(const propertyTrack of this._propertyTracks){propertyTrack.SetInitialState(time);if(this._worldInfoChange===0&&propertyTrack.GetWorldInfoChange()===1)this._worldInfoChange=1;if(this._renderChange===0&&propertyTrack.GetRenderChange()===1)this._renderChange=1}this._needsBeforeAndAfter=0;const nba=this._propertyTracks.some(pt=>pt.GetNeedsBeforeAndAfter());if(nba)this._needsBeforeAndAfter=
1;this._lastKeyframeDataItem=this._GetLastKeyFrameBeforeTime(time);this._initialStateOfNestedSet=false;this._endStateOfNestedSet=false;this.Interpolate(time);this.OnKeyframeReached(this._GetLastKeyFrameBeforeTime(time))}SetResumeState(){this.MaybeGetInstance();if(!this.IsInstanceValid()&&this.IsInstanceTrack())return;const playbackDirection=this._timeline.IsForwardPlayBack();const time=this._timeline.GetTime()-this.GetStartOffset();this._lastKeyframeDataItem=this._GetLastKeyFrameBeforeTime(time);
for(const propertyTrack of this._propertyTracks)propertyTrack.SetResumeState(time)}SetEndState(){if(this.GetTimeline().IsComplete())return;this.MaybeGetInstance();if(!this.IsInstanceValid()&&this.IsInstanceTrack())return;if(!this._isNested){const time=this._timeline.GetTime();const totalTime=this.GetStartOffset()+this.GetLocalTotalTime();if(time>=totalTime)this.Interpolate(this.GetLocalTotalTime(),true,false,true,false,false,true);else if(time<=0)this.Interpolate(0,true,false,true,false,false,true)}}_SetUpdateState(){for(let i=
0,l=this._propertyTracks.length;i<l;i++){const propertyTrack=this._propertyTracks[i];propertyTrack._SetUpdateState();if(this._worldInfoChange===0&&propertyTrack.GetWorldInfoChange()===1)this._worldInfoChange=1;if(this._renderChange===0&&propertyTrack.GetRenderChange()===1)this._renderChange=1}}BeforeInterpolate(){const l=this._propertyTracks.length;for(let i=0;i<l;i++)this._propertyTracks[i].BeforeInterpolate()}Interpolate(time,isTicking=false,setTime=false,ensureValue=false,firstTick=false,ignoreGlobals=
false,endState=false){if(!this._instance)this.GetInstance();const instanceValid=this._instance&&!this._instance.IsDestroyed();const isInstanceTrack=this._trackDataItem._type===INSTANCE_TRACK;if(!instanceValid&&isInstanceTrack)return;if(ignoreGlobals&&isInstanceTrack&&this.GetObjectClass().IsGlobal())return;time=time-this.GetStartOffset();if(time<0)return;this.MaybeSetInitialStateOfNestedTrack(time,isTicking);this.MaybeTriggerKeyframeReachedConditions(time,isTicking,firstTick);for(let i=0,l=this._propertyTracks.length;i<
l;i++)this._propertyTracks[i].Interpolate(time,setTime,ensureValue,endState);this.MaybeSetEndStateOfNestedTrack(time,isTicking);if(this._worldInfoChange!==0){if(!this._worldInfo)this._worldInfo=this._instance.GetWorldInfo();if(this._worldInfo)this._worldInfo.SetBboxChanged()}}AfterInterpolate(){const l=this._propertyTracks.length;for(let i=0;i<l;i++)this._propertyTracks[i].AfterInterpolate()}MaybeSetInitialStateOfNestedTrack(time,isTicking){if(!isTicking)return;if(!this._isNested)return;if(this._initialStateOfNestedSet)return;
const timeline=this.GetTimeline();if(timeline.IsForwardPlayBack()){if(time<0)return;for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(0,false,true)}else{if(time>this.GetLocalTotalTime())return;for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(this.GetLocalTotalTime(),false,true)}for(const propertyTrack of this._propertyTracks)propertyTrack.SetInitialState();this._initialStateOfNestedSet=true}MaybeSetEndStateOfNestedTrack(time,isTicking){if(!isTicking)return;
if(!this._isNested)return;if(this._endStateOfNestedSet)return;const timeline=this.GetTimeline();if(timeline.IsForwardPlayBack()){if(time>=this.GetLocalTotalTime()){for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(this.GetLocalTotalTime(),false,true);this._endStateOfNestedSet=true}}else if(time<=0){for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(0,false,true);this._endStateOfNestedSet=true}}MaybeTriggerKeyframeReachedConditions(time,isTicking,firstTick){if(firstTick)return;
if(!isTicking)return;if(!C3.Plugins.Timeline)return;const timeline=this.GetTimeline();const nextKeyframe=this._lastKeyframeDataItem.GetNext();const lastTime=this._lastKeyframeDataItem.GetTime();const nextTime=nextKeyframe?nextKeyframe.GetTime():timeline.GetTotalTime();if(time<=lastTime||time>=nextTime){this._lastKeyframeDataItem=this._trackData.GetFirstKeyFrameDataItemLowerOrEqualThan(time,this._trackDataItem);if(timeline.IsForwardPlayBack()){if(nextKeyframe)this.OnKeyframeReached(this._lastKeyframeDataItem)}else{const nextKeyframe=
this._lastKeyframeDataItem.GetNext();if(nextKeyframe)this.OnKeyframeReached(nextKeyframe)}}}_GetLastKeyFrameBeforeTime(time){const keyframeDataItem=this._trackData.GetKeyFrameDataItemAtTime(time,this._trackDataItem);if(keyframeDataItem)return keyframeDataItem;else return this._trackData.GetFirstKeyFrameDataItemLowerOrEqualThan(time,this._trackDataItem)}OnKeyframeReached(keyframeDataItem){const timeline=this.GetTimeline();const timelineManager=timeline.GetTimelineManager();C3.Plugins.Timeline.Cnds.PushTriggerTimeline(timeline);
C3.Plugins.Timeline.Cnds.PushTriggerKeyframe(keyframeDataItem);timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnAnyKeyframeReached);timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnKeyframeReached);C3.Plugins.Timeline.Cnds.PopTriggerTimeline(timeline);C3.Plugins.Timeline.Cnds.PopTriggerKeyframe(keyframeDataItem)}AddKeyframe(){const keyframeData=this._trackDataItem.GetKeyframeData();const keyframeDataItem=keyframeData.AddEmptyKeyframeDataItem();return keyframeDataItem}AddPropertyTrack(){const propertyTrackData=
this._trackDataItem.GetPropertyTrackData();const propertyTrackDataItem=propertyTrackData.AddEmptyPropertyTrackDataItem();const propertyTrack=C3.PropertyTrackState.Create(this,propertyTrackDataItem);this._propertyTracks.push(propertyTrack);return propertyTrack}DeleteKeyframes(match){const keyframeData=this._trackDataItem.GetKeyframeData();keyframeData.DeleteKeyframeDataItems(match)}DeletePropertyKeyframes(match){for(const propertyTrack of this._propertyTracks)propertyTrack.DeletePropertyKeyframes(match)}SaveState(){for(const propertyTrack of this._propertyTracks)propertyTrack.SaveState()}CompareInitialStateWithCurrent(){this.MaybeGetInstance();
if(!this.IsInstanceValid()&&this.IsInstanceTrack())return;for(const propertyTrack of this._propertyTracks)propertyTrack.CompareInitialStateWithCurrent()}CompareSaveStateWithCurrent(){this.MaybeGetInstance();if(!this.IsInstanceValid()&&this.IsInstanceTrack())return;let difference=false;for(const propertyTrack of this._propertyTracks){const diff=propertyTrack.CompareSaveStateWithCurrent();if(!difference&&diff)difference=true}if(difference){const keyframeDataItem=this.AddKeyframe();keyframeDataItem.SetTime(this.GetTimeline().GetTime());
keyframeDataItem.SetEase("noease");keyframeDataItem.SetEnable(true);keyframeDataItem.SetTags("")}}_SaveToJson(){const instance=this.GetInstance();const uid=instance?instance.GetUID():this.GetInstanceUID();return{"propertyTracksJson":this._SavePropertyTracksToJson(),"lastKeyframeDataItemJson":this._SaveLastKeyframeDataItemToJson(),"initialStateOfNestedSet":this._initialStateOfNestedSet,"endStateOfNestedSet":this._endStateOfNestedSet,"instanceUid":uid}}_LoadFromJson(o){if(!o)return;this._LoadPropertyTracksFromJson(o["propertyTracksJson"]);
this._LoadLastKeyframeDataItemFromJson(o["lastKeyframeDataItemJson"]);this._LoadInstanceFromJson(o["instanceUid"]);this._initialStateOfNestedSet=false;if(o.hasOwnProperty["initialStateOfNestedSet"])this._initialStateOfNestedSet=o["initialStateOfNestedSet"];this._endStateOfNestedSet=false;if(o.hasOwnProperty["endStateOfNestedSet"])this._endStateOfNestedSet=o["endStateOfNestedSet"];for(const propertyTrack of this._propertyTracks){if(this._worldInfoChange===0&&propertyTrack.GetWorldInfoChange()===1)this._worldInfoChange=
1;if(this._renderChange===0&&propertyTrack.GetRenderChange()===1)this._renderChange=1}this._needsBeforeAndAfter=0;if(this._propertyTracks.some(pt=>pt.GetNeedsBeforeAndAfter()))this._needsBeforeAndAfter=1}_SaveLastKeyframeDataItemToJson(){const keyframeData=this._trackDataItem.GetKeyframeData();return keyframeData.GetKeyframeDataItemIndex(this._lastKeyframeDataItem)}_SavePropertyTracksToJson(){return this._propertyTracks.map(propertyTrackState=>propertyTrackState._SaveToJson())}_LoadPropertyTracksFromJson(propertyTracksJson){propertyTracksJson.forEach((propertyTrackJson,
i)=>{const propertyTrack=this._propertyTracks[i];propertyTrack._LoadFromJson(propertyTrackJson)})}_LoadInstanceFromJson(uid){if(!C3.IsFiniteNumber(uid))return;const instance=this.GetRuntime().GetInstanceByUID(uid);if(!instance)return;const timeline=this.GetTimeline();timeline.SetTrackInstance(this._trackDataItem.GetId(),instance)}_LoadLastKeyframeDataItemFromJson(lastKeyframeDataItemIndex){const keyframeData=this._trackDataItem.GetKeyframeData();this._lastKeyframeDataItem=keyframeData.GetKeyframeDataItemFromIndex(lastKeyframeDataItemIndex)}};

}

// timelines/state/propertyTrackState.js
{
'use strict';const C3=self.C3;
C3.PropertyTrackState=class PropertyTrack extends C3.DefendedBase{constructor(track,propertyTrackDataItem){super();this._track=track;this._propertyTrackDataItem=propertyTrackDataItem;this._propertyTrackData=propertyTrackDataItem.GetPropertyTrackData();this._worldInfoChange=0;this._renderChange=0;this._needsBeforeAndAfter=0;this._sourceAdapter=this.GetSourceAdapter();this._propertyKeyframeDataItems=this._propertyTrackDataItem.GetPropertyKeyframeData().GetPropertyKeyframeDataItemArray();this._lastPropertyKeyframeDataItem=
null;this._absoluteValueObject=null}static Create(track,propertyTrackDataItem){return C3.New(C3.PropertyTrackState,track,propertyTrackDataItem)}Release(){this._track=null;if(this._sourceAdapter){this._sourceAdapter.Release();this._sourceAdapter=null}this._propertyKeyframeDataItems=null;this._propertyTrackDataItem=null;this._propertyTrackData=null}GetWorldInfoChange(){return this._worldInfoChange}GetRenderChange(){return this._renderChange}GetNeedsBeforeAndAfter(){return this._needsBeforeAndAfter}HasAbsoluteValueObject(){return!!this._absoluteValueObject}SetAbsoluteValueObject(avo){this._absoluteValueObject=
avo}GetAbsoluteValueObject(){return this._absoluteValueObject}GetTrack(){return this._track}GetPropertyTrackDataItem(){return this._propertyTrackDataItem}GetPropertyTrackData(){return this._propertyTrackData}GetTimeline(){return this._track.GetTimeline()}GetRuntime(){return this._track.GetRuntime()}GetInstance(){return this._track.GetInstance()}GetSourceAdapter(){if(this._sourceAdapter)return this._sourceAdapter;const id=this._propertyTrackDataItem.GetSourceAdapterId();let ret;switch(id){case "behavior":ret=
new C3.PropertyTrackState.BehaviorSourceAdapter(this);break;case "effect":ret=new C3.PropertyTrackState.EffectSourceAdapter(this);this._renderChange=1;break;case "instance-variable":ret=new C3.PropertyTrackState.InstanceVariableSourceAdapter(this);break;case "plugin":ret=new C3.PropertyTrackState.PluginSourceAdapter(this);this._renderChange=1;break;case "world-instance":ret=new C3.PropertyTrackState.PropertySourceAdapter(this);this._renderChange=1;this._worldInfoChange=1;break;case "value":ret=new C3.PropertyTrackState.ValueSourceAdapter(this);
break;case "audio":ret=new C3.PropertyTrackState.AudioSourceAdapter(this);break}this._sourceAdapter=ret;return this._sourceAdapter}GetSourceAdapterId(){return this._propertyTrackDataItem.GetSourceAdapterId()}SetSourceAdapterId(said){this._propertyTrackDataItem.SetSourceAdapterId(said)}GetSourceAdapterArgs(){return this._propertyTrackDataItem.GetSourceAdapterArguments()}SetSourceAdapterArgs(sargs){this._propertyTrackDataItem.SetSourceAdapterArguments(sargs)}GetSourceAdapterValue(){return this.GetSourceAdapter().GetValue()}GetPropertyName(){return this._propertyTrackDataItem.GetProperty()}SetPropertyName(pn){this._propertyTrackDataItem.SetProperty(pn)}GetPropertyType(){return this._propertyTrackDataItem.GetType()}SetPropertyType(pt){this._propertyTrackDataItem.SetType(pt)}GetPropertyKeyframeType(){return this.GetPropertyTrackData().GetFirstPropertyKeyframeDataItem(this._propertyTrackDataItem).GetType()}GetMin(){return this._propertyTrackDataItem.GetMin()}SetMin(min){this._propertyTrackDataItem.SetMin(min)}GetMax(){return this._propertyTrackDataItem.GetMax()}SetMax(max){this._propertyTrackDataItem.SetMax(max)}GetEnable(){return this._propertyTrackDataItem.GetEnable()}SetEnable(e){this._propertyTrackDataItem.SetEnable(e)}GetInterpolationMode(){return this._propertyTrackDataItem.GetInterpolationMode()}SetInterpolationMode(im){this._propertyTrackDataItem.SetInterpolationMode(im)}GetResultMode(){return this._propertyTrackDataItem.GetResultMode()}SetResultMode(rm){this._propertyTrackDataItem.SetResultMode(rm)}SetEase(e){for(const propertyKeyframeDataItem of this.GetPropertyKeyframeDataItems())propertyKeyframeDataItem.SetEase(e)}CanHavePropertyKeyframes(){return this._propertyTrackDataItem.CanHavePropertyKeyframes()}GetPropertyKeyframeDataItems(){if(this._propertyKeyframeDataItems)return this._propertyKeyframeDataItems;
this._propertyKeyframeDataItems=this._propertyTrackDataItem.GetPropertyKeyframeData().GetPropertyKeyframeDataItemArray();return this._propertyKeyframeDataItems}GetPropertyKeyframeDataItemArrayIncludingDisabled(){return this._propertyTrackDataItem.GetPropertyKeyframeData().GetPropertyKeyframeDataItemArrayIncludingDisabled()}GetPropertyKeyFrameDataItemAtTime(time){return this._propertyTrackData.GetPropertyKeyFrameDataItemAtTime(time,this._propertyTrackDataItem)}GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time){return this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,
this._propertyTrackDataItem)}GetPropertyKeyframeDataItemPairForTime(time){let start=this._propertyTrackData.GetPropertyKeyFrameDataItemAtTime(time,this._propertyTrackDataItem);let end;if(start)end=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherThan(time,this._propertyTrackDataItem);else{start=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem);end=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,this._propertyTrackDataItem)}return{start,
end}}*GetPropertyKeyframeValues(){for(const propertyKeyframeDataItem of this.GetPropertyKeyframeDataItems())yield propertyKeyframeDataItem.GetValueWithResultMode()}*GetPropertyKeyframeTimes(){for(const propertyKeyframeDataItem of this.GetPropertyKeyframeDataItems())yield propertyKeyframeDataItem.GetTime()}TimelineRemoved(){this.GetSourceAdapter().TimelineRemoved()}CleanCaches(){this.GetSourceAdapter().CleanCaches()}GetCurrentState(){return this.GetSourceAdapter().GetCurrentState()}SetResetState(){this.GetSourceAdapter().SetResetState()}SetInitialState(time){this.GetSourceAdapter().SetInitialState();
this._lastPropertyKeyframeDataItem=this._GetLastPropertyKeyFrameBeforeTime(time);this._SetUpdateState()}SetResumeState(time){this.GetSourceAdapter().SetResumeState();this._lastPropertyKeyframeDataItem=this._GetLastPropertyKeyFrameBeforeTime(time)}_SetUpdateState(){const track=this.GetTrack();this._needsBeforeAndAfter=0;if(track.IsInstanceTrack()){const timeline=this.GetTimeline();const instance=track.GetInstance();const sourceAdapter=this.GetSourceAdapter();const propertyName=this.GetPropertyName();
const mayNeedBeforeAndAfterInterpolate=sourceAdapter.MayNeedBeforeAndAfterInterpolate();if(mayNeedBeforeAndAfterInterpolate){const similarPropertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,propertyName);if(similarPropertyTracks&&similarPropertyTracks.length)this._needsBeforeAndAfter=1}else this._needsBeforeAndAfter=0}}_GetLastPropertyKeyFrameBeforeTime(time){const timeline=this.GetTimeline();const propertyKeyframeDataItem=this._propertyTrackData.GetPropertyKeyFrameDataItemAtTime(time,
this._propertyTrackDataItem);if(propertyKeyframeDataItem)return propertyKeyframeDataItem;else if(timeline.IsForwardPlayBack())return this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem);else return this._propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,this._propertyTrackDataItem)}BeforeInterpolate(){this._sourceAdapter.BeforeInterpolate()}Interpolate(time,setTime=false,ensureValue=false,endState=false){let start;let end;
if(setTime)start=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem);else{if(this._lastPropertyKeyframeDataItem){const timeline=this.GetTimeline();const nextPropertyKeyframe=this._lastPropertyKeyframeDataItem.GetNext();const lastTime=this._lastPropertyKeyframeDataItem.GetTime();const nextTime=nextPropertyKeyframe?nextPropertyKeyframe.GetTime():timeline.GetTotalTime();if(time<=lastTime||time>=nextTime)this._lastPropertyKeyframeDataItem=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,
this._propertyTrackDataItem)}else this._lastPropertyKeyframeDataItem=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem);start=this._lastPropertyKeyframeDataItem}if(start)end=start.GetNext();this._sourceAdapter.Interpolate(time,start,end,setTime,ensureValue,endState)}GetInterpolatedValue(time){if(this._lastPropertyKeyframeDataItem){const timeline=this.GetTimeline();const nextPropertyKeyframe=this._lastPropertyKeyframeDataItem.GetNext();const lastTime=
this._lastPropertyKeyframeDataItem.GetTime();const nextTime=nextPropertyKeyframe?nextPropertyKeyframe.GetTime():timeline.GetTotalTime();if(time<=lastTime||time>=nextTime)this._lastPropertyKeyframeDataItem=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem)}else this._lastPropertyKeyframeDataItem=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem);const start=this._lastPropertyKeyframeDataItem;
const end=start.GetNext();return this._sourceAdapter.GetInterpolatedValue(time,start,end)}GetInterpolatedValueFast(time,start,end){return this._sourceAdapter.GetInterpolatedValue(time,start,end)}AfterInterpolate(){this._sourceAdapter.AfterInterpolate()}static GetStartPropertyKeyframeForTime(time,propertyTrack){const propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack._propertyTrackData;return propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,
propertyTrackDataItem)}static GetEndPropertyKeyframeForTime(time,propertyTrack){const propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack._propertyTrackData;return propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,propertyTrackDataItem)}AddPropertyKeyframe(){const propertyKeyframeData=this._propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItem=propertyKeyframeData.AddEmptyPropertyKeyframeDataItem();this._lastPropertyKeyframeDataItem=
null;return propertyKeyframeDataItem}DeletePropertyKeyframes(match){this._lastPropertyKeyframeDataItem=null;const propertyKeyframeData=this._propertyTrackDataItem.GetPropertyKeyframeData();propertyKeyframeData.DeletePropertyKeyframeDataItems(match)}SaveState(){this.GetSourceAdapter().SaveState()}CompareInitialStateWithCurrent(){const difference=this.GetSourceAdapter().CompareInitialStateWithCurrent();if(difference){const propertyKeyframeDataItem=this._propertyTrackData.GetFirstPropertyKeyframeDataItem(this._propertyTrackDataItem);
const currentState=this.GetSourceAdapter().GetCurrentState();propertyKeyframeDataItem.SetAbsoluteValue(currentState)}}CompareSaveStateWithCurrent(){const difference=this.GetSourceAdapter().CompareSaveStateWithCurrent();if(difference)this.AddPropertyKeyframeAtCurrentTime();this.GetSourceAdapter().ClearSaveState();return difference}AddPropertyKeyframeAtCurrentTime(){const time=this.GetTimeline().GetTime();const sourceAdapter=this.GetSourceAdapter();const startPropertyKeyframe=C3.PropertyTrackState.GetStartPropertyKeyframeForTime(time,
this);const propertyKeyframeDataItem=this.AddPropertyKeyframe();propertyKeyframeDataItem.SetType(startPropertyKeyframe.GetType());propertyKeyframeDataItem.SetTime(time);propertyKeyframeDataItem.SetEase(startPropertyKeyframe.GetEase());propertyKeyframeDataItem.SetEnable(true);propertyKeyframeDataItem.SetValue(sourceAdapter.GetValueAtTime());propertyKeyframeDataItem.SetAbsoluteValue(sourceAdapter.GetCurrentState())}_SaveToJson(){return{"sourceAdapterJson":this.GetSourceAdapter()._SaveToJson()}}_LoadFromJson(o){if(!o)return;
this.GetSourceAdapter()._LoadFromJson(o["sourceAdapterJson"])}};

}

// timelines/state/propertySourceAdapters/propertySourceAdapter.js
{
'use strict';const C3=self.C3;const NS=C3.PropertyTrackState;
NS.PropertySourceAdapter=class PropertySourceAdapter{constructor(propertyTrack){this._propertyTrack=propertyTrack;this._propertyAdapter=null;this.GetPropertyAdapter()}Release(){if(this._propertyAdapter){this._propertyAdapter.Release();this._propertyAdapter=null}this._propertyTrack=null}MayNeedBeforeAndAfterInterpolate(){return this._propertyAdapter.MayNeedBeforeAndAfterInterpolate()}GetPropertyTrack(){return this._propertyTrack}TimelineRemoved(){if(this._propertyAdapter)this._propertyAdapter.TimelineRemoved()}CleanCaches(){if(this._propertyAdapter)this._propertyAdapter.CleanCaches()}GetPropertyAdapter(){if(this._propertyAdapter)return this._propertyAdapter;this._propertyAdapter=
this._CreatePropertyAdapter();return this._propertyAdapter}GetEditorIndex(){}GetIndex(){return this.GetEditorIndex()}GetTarget(){}SetResetState(){this.GetPropertyAdapter().SetResetState()}SetInitialState(){this.GetPropertyAdapter().SetInitialState()}SetResumeState(){this.GetPropertyAdapter().SetResumeState()}BeforeInterpolate(){this._propertyAdapter.BeforeChangeProperty()}Interpolate(time,start,end,setTime,ensureValue,endState){const type=this._propertyTrack.GetPropertyKeyframeType();let value;switch(type){case "numeric":{value=
NS.NumericTypeAdapter.Interpolate(time,start,end,this._propertyTrack);break}case "angle":{value=NS.AngleTypeAdapter.Interpolate(time,start,end,this._propertyTrack);break}case "boolean":{value=NS.BooleanTypeAdapter.Interpolate(time,start,end,this._propertyTrack);break}case "color":{value=NS.ColorTypeAdapter.Interpolate(time,start,end,this._propertyTrack);break}case "text":{value=NS.TextTypeAdapter.Interpolate(time,start,end,this._propertyTrack);break}}this._propertyAdapter.ChangeProperty(time,value,
start,end,setTime,ensureValue,endState)}GetInterpolatedValue(time,start,end){switch(this._propertyTrack.GetPropertyKeyframeType()){case "numeric":return NS.NumericTypeAdapter.Interpolate(time,start,end,this._propertyTrack);case "angle":return NS.AngleTypeAdapter.Interpolate(time,start,end,this._propertyTrack);case "boolean":return NS.BooleanTypeAdapter.Interpolate(time,start,end,this._propertyTrack);case "color":return NS.ColorTypeAdapter.Interpolate(time,start,end,this._propertyTrack);case "text":return NS.TextTypeAdapter.Interpolate(time,
start,end,this._propertyTrack)}}AfterInterpolate(){this._propertyAdapter.AfterChangeProperty()}SaveState(){this.GetPropertyAdapter().SetSaveState()}ClearSaveState(){this.GetPropertyAdapter().ClearSaveState()}GetCurrentState(){return this.GetPropertyAdapter().GetCurrentState()}CompareInitialStateWithCurrent(){return this.GetPropertyAdapter().CompareInitialStateWithCurrent()}CompareSaveStateWithCurrent(){return this.GetPropertyAdapter().CompareSaveStateWithCurrent()}GetValueAtTime(){const propertyTrack=
this._propertyTrack;const track=propertyTrack.GetTrack();const time=track.GetTimeline().GetTime();const start=NS.GetStartPropertyKeyframeForTime(time,propertyTrack);const end=start.GetNext();const type=propertyTrack.GetPropertyKeyframeType();switch(type){case "numeric":{return NS.NumericTypeAdapter.Interpolate(time,start,end,propertyTrack)}case "angle":{return NS.AngleTypeAdapter.Interpolate(time,start,end,propertyTrack)}case "boolean":{return NS.BooleanTypeAdapter.Interpolate(time,start,end,propertyTrack)}case "color":{return NS.ColorTypeAdapter.Interpolate(time,
start,end,propertyTrack)}case "text":{return NS.TextTypeAdapter.Interpolate(time,start,end,propertyTrack)}}}_CreatePropertyAdapter(){const pt=this._propertyTrack;const type=pt.CanHavePropertyKeyframes()?pt.GetPropertyKeyframeType():"";switch(type){case "combo":case "boolean":case "text":case "string":{return new NS.PropertyInterpolationAdapter.NoInterpolationAdapter(this)}case "numeric":case "number":case "angle":{if(this._propertyTrack.GetPropertyType()==="combo")return new NS.PropertyInterpolationAdapter.NoInterpolationAdapter(this);
return new NS.PropertyInterpolationAdapter.NumericInterpolationAdapter(this)}case "color":case "offsetColor":{return new NS.PropertyInterpolationAdapter.ColorInterpolationAdapter(this)}default:{return new NS.PropertyInterpolationAdapter.NumericInterpolationAdapter(this)}}}_SaveToJson(){return{"propertyAdapterJson":this.GetPropertyAdapter()._SaveToJson()}}_LoadFromJson(o){if(!o)return;this.GetPropertyAdapter()._LoadFromJson(o["propertyAdapterJson"])}};

}

// timelines/state/propertySourceAdapters/instanceVariableSourceAdapter.js
{
'use strict';const C3=self.C3;const INDEX=0;
class InstanceVariableSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack);this._updatedIndex=NaN}GetEditorIndex(){return this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX]}GetIndex(){if(this._updatedIndex)return this._updatedIndex;return super.GetIndex()}GetTarget(){return this._propertyTrack.GetTrack().GetInstance()}UpdateInstanceVariableIndex(index){const i=this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX];if(i===
index)return;this._updatedIndex=index}Interpolate(time,start,end,setTime,ensureValue){if(!this.GetPropertyAdapter().CanChange(start.GetValue()))return;super.Interpolate(time,start,end,setTime,ensureValue)}GetInterpolatedValue(time,start,end){if(!this.GetPropertyAdapter().CanChange(start.GetValue()))return;return super.GetInterpolatedValue(time,start,end)}_SaveToJson(){return Object.assign(super._SaveToJson(),{"index":this._updatedIndex})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._updatedIndex=
o["index"]}}C3.PropertyTrackState.InstanceVariableSourceAdapter=InstanceVariableSourceAdapter;

}

// timelines/state/propertySourceAdapters/behaviorSourceAdapter.js
{
'use strict';const C3=self.C3;const SID=0;const INDEX=1;const NAME=2;
class BehaviorSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack);this._sid=NaN}GetEditorIndex(){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();return dataItem.GetSourceAdapterArguments()[INDEX]}GetTarget(){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();const track=this._propertyTrack.GetTrack();const sid=this._sid?this._sid:dataItem.GetSourceAdapterArguments()[SID];const instance=track.GetInstance();const index=
instance.GetBehaviorIndexBySID(sid);const behaviorInstance=instance.GetBehaviorInstances()[index];return behaviorInstance.GetSdkInstance()}GetBehaviorType(objectClass){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();const name=dataItem.GetSourceAdapterArguments()[NAME];return objectClass.GetBehaviorTypeByName(name)}UpdateBehaviorTypeSid(sid){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();if(dataItem.GetSourceAdapterArguments()[SID]===sid)return;this._sid=sid}Interpolate(time,
start,end,setTime,ensureValue){const track=this._propertyTrack.GetTrack();const instance=track.GetInstance();if(!this.GetBehaviorType(instance.GetObjectClass()))return;super.Interpolate(time,start,end,setTime,ensureValue)}GetInterpolatedValue(time,start,end){const track=this._propertyTrack.GetTrack();const instance=track.GetInstance();if(!this.GetBehaviorType(instance.GetObjectClass()))return;return super.GetInterpolatedValue(time,start,end)}_SaveToJson(){return Object.assign(super._SaveToJson(),
{"sid":this._sid})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._sid=o["sid"]}}C3.PropertyTrackState.BehaviorSourceAdapter=BehaviorSourceAdapter;

}

// timelines/state/propertySourceAdapters/effectSourceAdapter.js
{
'use strict';const C3=self.C3;const NAME=0;const INDEX=1;
class EffectSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack)}GetEditorIndex(){return this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX]}GetTarget(){const pTrack=this._propertyTrack;const track=pTrack.GetTrack();const worldInfo=track.GetWorldInfo();const instanceEffectList=worldInfo.GetInstanceEffectList();const effectList=instanceEffectList.GetEffectList();const effectType=this.GetEffectType(effectList);
const effectIndex=effectType.GetIndex();if(instanceEffectList.IsEffectIndexActive(effectIndex))return instanceEffectList.GetEffectParametersForIndex(effectIndex);return null}GetEffectType(effectList){const pTrack=this._propertyTrack;const name=pTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[NAME];return effectList.GetEffectTypeByName(name)}Interpolate(time,start,end,setTime,ensureValue){if(!this._IsEffectActive())return;super.Interpolate(time,start,end,setTime,ensureValue)}GetInterpolatedValue(time,
start,end){if(!this._IsEffectActive())return;return super.GetInterpolatedValue(time,start,end)}_IsEffectActive(){const pTrack=this._propertyTrack;const track=pTrack.GetTrack();const worldInfo=track.GetWorldInfo();const instanceEffectList=worldInfo.GetInstanceEffectList();const effectList=instanceEffectList.GetEffectList();const effectType=this.GetEffectType(effectList);if(!effectType)return;const effectIndex=effectType.GetIndex();return instanceEffectList.IsEffectIndexActive(effectIndex)}}
C3.PropertyTrackState.EffectSourceAdapter=EffectSourceAdapter;

}

// timelines/state/propertySourceAdapters/pluginSourceAdapter.js
{
'use strict';const C3=self.C3;const INDEX=0;
class PluginSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack)}GetEditorIndex(){return this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX]}GetTarget(){return this._propertyTrack.GetTrack().GetInstance().GetSdkInstance()}Interpolate(time,start,end,setTime,ensureValue){const track=this._propertyTrack.GetTrack();const templatePlugin=track.GetObjectClass().GetPlugin();const currentPlugin=track.GetInstance().GetObjectClass().GetPlugin();
if(templatePlugin!==currentPlugin)return;super.Interpolate(time,start,end,setTime,ensureValue)}GetInterpolatedValue(time,start,end){const track=this._propertyTrack.GetTrack();const templatePlugin=track.GetObjectClass().GetPlugin();const currentPlugin=track.GetInstance().GetObjectClass().GetPlugin();if(templatePlugin!==currentPlugin)return;return super.GetInterpolatedValue(time,start,end)}GetOptionalCallbacks(){const track=this._propertyTrack.GetTrack();const plugin=track.GetObjectClass().GetPlugin();
if(plugin instanceof C3.Plugins.Sprite)if(this._propertyTrack.GetPropertyName()==="initial-frame"||this._propertyTrack.GetPropertyName()==="initial-animation")switch(this._propertyTrack.GetResultMode()){case "relative":{return null}case "absolute":{return null}}}}C3.PropertyTrackState.PluginSourceAdapter=PluginSourceAdapter;

}

// timelines/state/propertySourceAdapters/valueSourceAdapter.js
{
'use strict';const C3=self.C3;
class ValueSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack);this._value=0;this._init=false}MayNeedBeforeAndAfterInterpolate(){return false}SetInitialState(){const propertyTrackData=this._propertyTrack.GetPropertyTrackData();let propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();propertyTrackDataItem=propertyTrackData.GetFirstPropertyKeyframeDataItem(propertyTrackDataItem);this._value=propertyTrackDataItem.GetValueWithResultMode()}SetResumeState(){}GetValue(){if(!this._init)this._propertyTrack.Interpolate(0);return this._value}Interpolate(time,
start,end,setTime,ensureValue){this._value=C3.PropertyTrackState.NumericTypeAdapter.Interpolate(time,start,end,this._propertyTrack);this._init=true}SaveState(){}ClearSaveState(){}GetCurrentState(){return this._value}CompareInitialStateWithCurrent(){return false}CompareSaveStateWithCurrent(){return false}_SaveToJson(){return{"value":this._value,"init":this._init}}_LoadFromJson(o){if(!o)return;this._value=o["value"];this._init=o.hasOwnProperty("init")?o["init"]:true}}
C3.PropertyTrackState.ValueSourceAdapter=ValueSourceAdapter;

}

// timelines/state/propertySourceAdapters/audioSourceAdapter.js
{
'use strict';const C3=self.C3;const PROJECT_FILE=0;const PROJECT_FILE_NAME=0;const PROJECT_FILE_TYPE=1;const START_OFFSET=1;const AUDIO_DURATION=2;const AUDIO_TAG=3;
class AudioSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack);this._audioPlaybackStarted=false;this._sdkInstance=null;this._actions=null;this._expressions=null;this._timeline=this._propertyTrack.GetTimeline();this._track=this._propertyTrack.GetTrack();this._sourceAdapterArgs=this._propertyTrack.GetSourceAdapterArgs();this._fileArgs=this._sourceAdapterArgs[PROJECT_FILE];this._startOffsetTime=this._sourceAdapterArgs[START_OFFSET];if(this._sourceAdapterArgs[AUDIO_TAG])this._audioTag=
this._sourceAdapterArgs[AUDIO_TAG];else this._audioTag=Math.random().toString(36).slice(2);this._pauseTime=NaN;this._pauseVolume=NaN;this._volume=NaN;this._audioSource=null;this._Initialize()}Release(){super.Release();this._sdkInstance=null;this._actions=null;this._expressions=null;this._timeline=null;this._track=null;this._sourceAdapterArgs=null;this._fileArgs=null;this._audioSource=null}_Initialize(){if(!self.C3.Plugins.Audio)return;const runtime=this._propertyTrack.GetRuntime();const audioObjectClass=
runtime.GetObjectClassByName("audio");if(audioObjectClass)this._sdkInstance=audioObjectClass.GetSingleGlobalInstance().GetSdkInstance();this._actions=self.C3.Plugins.Audio.Acts;this._expressions=self.C3.Plugins.Audio.Exps}_MaybeSetAudioSource(){if(this._audioSource)return;const track=this._propertyTrack.GetTrack();const audioSourcePropertyTrack=track.GetPropertyTrack("audioSource");if(audioSourcePropertyTrack)this._audioSource=audioSourcePropertyTrack.GetSourceAdapter()}_GetPauseVolume(){const track=
this._propertyTrack.GetTrack();const volumePropertyTrack=track.GetPropertyTrack("volume");if(volumePropertyTrack)return volumePropertyTrack.GetSourceAdapter()._pauseVolume;else return this._pauseVolume}TimelineRemoved(){super.TimelineRemoved();this._audioPlaybackStarted=false;if(this._sdkInstance){if(this._expressions){this._pauseTime=this._expressions.PlaybackTime.call(this._sdkInstance,this._audioTag);this._pauseVolume=this._expressions.Volume.call(this._sdkInstance,this._audioTag)}if(this._actions)this._actions.Stop.call(this._sdkInstance,
this._audioTag)}}GetAudioTag(){return this._audioTag}GetVolume(){return this._volume}SetVolume(v){this._volume=v}SetInitialState(){super.SetInitialState();this._pauseTime=NaN;this._audioPlaybackStarted=false}SetResumeState(){super.SetResumeState();const timeline=this._propertyTrack.GetTimeline();const time=timeline.GetTime();this._pauseTime=time-this._startOffsetTime;switch(this._propertyTrack.GetPropertyName()){case "audioSource":{break}case "volume":{this._pauseVolume=this._propertyTrack.GetInterpolatedValue(time);
break}}this._audioPlaybackStarted=false}Interpolate(time,start,end,setTime,ensureValue){if(!this._sdkInstance)return;switch(this._propertyTrack.GetPropertyName()){case "audioSource":{if(!this._timeline.IsForwardPlayBack())return;if(setTime){if(this._actions)this._actions.Stop.call(this._sdkInstance,this._audioTag);return}if(time<this._startOffsetTime){this._audioPlaybackStarted=false;return}const aPlaybackRate=this._expressions.PlaybackRate.call(this._sdkInstance,this._audioTag);const tPlaybackRate=
this._timeline.GetPlaybackRate();if(tPlaybackRate!==aPlaybackRate)this._actions.SetPlaybackRate.call(this._sdkInstance,this._audioTag,tPlaybackRate);if(this._audioPlaybackStarted)return;if(!this._propertyTrack.GetTimeline().IsPlaying())return;this._audioPlaybackStarted=true;if(isNaN(this._pauseTime)){const thenTime=self["performance"].now();const startDeltaTime=time-this._startOffsetTime;const state=this._sdkInstance.GetAudioContextState();if(state==="suspended"){this._audioPlaybackStarted=false;
return}const nowTime=self["performance"].now();const postToDOMDeltaTime=(nowTime-thenTime)/1E3;const startPlaybackOffset=startDeltaTime+postToDOMDeltaTime;if(this._actions){let startVolume=this.GetVolume();if(isNaN(startVolume)){this.SetVolume(0);startVolume=0}else this.SetVolume(startVolume);this._actions.PlayFromTimeline.call(this._sdkInstance,this._fileArgs,startVolume,this._audioTag,startPlaybackOffset)}}else{const startTime=this._pauseTime;this._pauseTime=NaN;const startVolume=this._GetPauseVolume();
this._pauseVolume=NaN;const state=this._sdkInstance.GetAudioContextState();if(state==="suspended"){this._audioPlaybackStarted=false;return}if(this._actions){this.SetVolume(startVolume);this._actions.PlayFromTimeline.call(this._sdkInstance,this._fileArgs,startVolume,this._audioTag,startTime)}}break}case "volume":{this._MaybeSetAudioSource();super.Interpolate(time,start,end,setTime,ensureValue)}}}GetInterpolatedValue(time,start,end){if(!this._sdkInstance)return;switch(this._propertyTrack.GetPropertyName()){case "audioSource":{return}case "volume":{this._MaybeSetAudioSource();
return super.GetInterpolatedValue(time,start,end)}}}Getter(wi,track){if(this._audioSource)return this._audioSource.GetVolume();return 0}Setter(wi,value,track,interpolationAdapter){if(this._audioSource)this._audioSource.SetVolume(this.Getter()+value);if(this._actions&&this._audioSource)this._actions.SetVolume.call(this._sdkInstance,this._audioSource.GetAudioTag(),this._audioSource.GetVolume())}AbsoluteSetter(wi,value,track){if(this._audioSource)this._audioSource.SetVolume(value);if(this._actions&&
this._audioSource)this._actions.SetVolume.call(this._sdkInstance,this._audioSource.GetAudioTag(),this._audioSource.GetVolume())}DoesRounding(){return true}_SaveToJson(){return{"audioPlaybackStarted":this._audioPlaybackStarted,"audioTag":this._audioTag,"pauseTime":this._pauseTime,"pauseVolume":this._pauseVolume,"volume":this._volume}}_LoadFromJson(o){if(!o)return;this._audioPlaybackStarted=o["audioPlaybackStarted"];this._audioTag=o["audioTag"];this._pauseTime=o["pauseTime"];this._pauseVolume=o["pauseVolume"];
this._volume=o["volume"];this._Initialize()}}C3.PropertyTrackState.AudioSourceAdapter=AudioSourceAdapter;

}

// timelines/state/propertyInterpolationAdapters/propertyInterpolationAdapter.js
{
'use strict';const C3=self.C3;
C3.PropertyTrackState.PropertyInterpolationAdapter=class PropertyInterpolationAdapter{constructor(sourceAdapter){this._sourceAdapter=sourceAdapter;this._propertyTrack=sourceAdapter.GetPropertyTrack();this._worldInfo=this._propertyTrack.GetTrack().GetWorldInfo();this._property=this._propertyTrack.GetPropertyName();this._firstAbsoluteUpdate=false;this._saveState=null;this._target=null}Release(){this._sourceAdapter=null;this._propertyTrack=null;this._worldInfo=null;this._saveState=null;this._target=
null}MayNeedBeforeAndAfterInterpolate(){return false}TimelineRemoved(){}CleanCaches(){this._worldInfo=null;this._saveState=null;this._target=null}GetSourceAdapter(){return this._sourceAdapter}GetPropertyTrack(){return this._propertyTrack}GetWorldInfo(){if(this._worldInfo)return this._worldInfo;this._worldInfo=this._propertyTrack.GetTrack().GetWorldInfo();return this._worldInfo}SetFirstAbsoluteUpdate(f){this._firstAbsoluteUpdate=!!f}GetFirstAbsoluteUpdate(){return this._firstAbsoluteUpdate}SetResetState(){}SetInitialState(){}SetResumeState(){}SetSaveState(){this._saveState=
this.GetCurrentState()}ClearSaveState(){this._saveState=null}GetCurrentState(){}CompareInitialStateWithCurrent(){}CompareSaveStateWithCurrent(){}CanChange(value){const targetType=typeof this._Getter();const newType=typeof value;return targetType===newType}BeforeChangeProperty(){}ChangeProperty(time,value,start,end,setTime,ensureValue,endState){}AfterChangeProperty(){}_FirstKeyframeGetter(){const propertyKeyframeDataItem=this._PickTimelinePlaybackMode(()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();
const propertyTrackData=this._propertyTrack.GetPropertyTrackData();return propertyTrackData.GetFirstPropertyKeyframeDataItem(propertyTrackDataItem)},()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=this._propertyTrack.GetPropertyTrackData();return propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem)});return propertyKeyframeDataItem.GetAbsoluteValue()}_CurrentKeyframeGetter(){const timeline=this._propertyTrack.GetTimeline();
const time=timeline.GetTime()-this._propertyTrack.GetTrack().GetStartOffset();const propertyKeyframe=this._PickTimelinePlaybackMode(()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=this._propertyTrack.GetPropertyTrackData();return propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,propertyTrackDataItem)},()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=this._propertyTrack.GetPropertyTrackData();
const ret=propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,propertyTrackDataItem);if(!ret)return propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return ret});return propertyKeyframe.GetAbsoluteValue()}_PickTimelinePlaybackMode(forwardFunc,backwardFunc){const timeline=this._propertyTrack.GetTimeline();return timeline.IsForwardPlayBack()?forwardFunc():backwardFunc()}_PickResultMode(relativeFunc,absoluteFunc){const resultMode=this._propertyTrack.GetResultMode();
return resultMode==="relative"?relativeFunc():absoluteFunc()}_PickFirstAbsoluteUpdate(firstFunc,otherFunc){if(this.GetFirstAbsoluteUpdate()){this.SetFirstAbsoluteUpdate(false);return firstFunc()}else return otherFunc()}_GetAbsoluteInitialValue(keyframeValue){}_GetIndex(){return this._sourceAdapter.GetIndex()}_GetTarget(){if(this._target)return this._target;this._target=this._sourceAdapter.GetTarget();return this._target}_PickSource(bFunc,eFunc,ivFunc,pFunc,wiFunc,aFunc){const id=this._propertyTrack.GetSourceAdapterId();
switch(id){case "behavior":return bFunc();case "effect":return eFunc();case "instance-variable":return ivFunc();case "plugin":return pFunc();case "world-instance":return wiFunc();case "audio":return aFunc()}}_SaveToJson(){return{"firstAbsoluteUpdate":this._firstAbsoluteUpdate,"saveState":this._saveState}}_LoadFromJson(o){if(!o)return;this._firstAbsoluteUpdate=o["firstAbsoluteUpdate"];this._saveState=o["saveState"]}_GetPropertyKeyframeStubs(propertyTracks,firstOnly=false){const ret=[];for(const propertyTrack of propertyTracks){const startOffset=
propertyTrack.GetTrack().GetStartOffset();for(const propertyKeyframeDataItem of propertyTrack.GetPropertyKeyframeDataItems())if(firstOnly&&propertyKeyframeDataItem.GetTime()===0)ret.push({time:startOffset+propertyKeyframeDataItem.GetTime(),value:propertyKeyframeDataItem.GetAbsoluteValue()});else if(!firstOnly)ret.push({time:startOffset+propertyKeyframeDataItem.GetTime(),value:propertyKeyframeDataItem.GetAbsoluteValue()})}return ret.sort((f,s)=>f.time-s.time)}_GetLastPropertyKeyframeStub(timeline,
time,propertyKeyframeStubs){return this._GetPropertyKeyframeStubLowerThanPlayhead(time,propertyKeyframeStubs)}_GetPropertyKeyframeStubLowerThanPlayhead(time,propertyKeyframeStubs){for(let i=propertyKeyframeStubs.length-1;i>=0;i--){const stubTime=propertyKeyframeStubs[i].time;if(stubTime<=time)return propertyKeyframeStubs[i]}return null}};

}

// timelines/state/propertyInterpolationAdapters/colorInterpolationAdapter.js
{
'use strict';const C3=self.C3;const TMP_COLORS_MAP=new Map;const TMP_COLOR=[0,0,0];
class ColorInterpolationAdapter extends C3.PropertyTrackState.PropertyInterpolationAdapter{constructor(sourceAdapter){super(sourceAdapter)}SetResetState(){}SetInitialState(){}SetResumeState(){}GetCurrentState(){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":return this._ToColorArray(target.GetPropertyValueByIndex(index));case "effect":return this._ToColorArray(target[index]);case "plugin":return this._ToColorArray(target.GetPropertyValueByIndex(index));
case "world-instance":return this._ToColorArray(this._Getter())}}CompareInitialStateWithCurrent(){const firstKeyframeColor=this._FirstKeyframeGetter();return!this._CompareColors(firstKeyframeColor,this._Getter())}CompareSaveStateWithCurrent(){if(C3.IsNullOrUndefined(this._saveState))return false;return!this._CompareColors(this._saveState,this._Getter())}_CompareColors(fColor,sColor){fColor=this._GetColorFromArray(fColor);sColor=this._GetColorFromArray(sColor);return fColor.equalsIgnoringAlpha(sColor)}_FirstKeyframeGetter(){const color=
super._FirstKeyframeGetter();return this._GetColorFromArray(color)}_CurrentKeyframeGetter(){const color=super._CurrentKeyframeGetter();return this._GetColorFromArray(color)}_GetAbsoluteInitialValue(value){}_ToColorArray(color){if(C3.IsInstanceOf(color,C3.Color))return color.toArray().slice(0,3);return color.slice(0,3)}_GetColorFromArray(color){if(C3.IsInstanceOf(color,C3.Color))return color;return new C3.Color(color[0],color[1],color[2],1)}CanChange(value){return true}MayNeedBeforeAndAfterInterpolate(){return true}BeforeChangeProperty(){const timeline=
this._propertyTrack.GetTimeline();const instance=this._propertyTrack.GetInstance();const sourceAdapter=this._propertyTrack.GetSourceAdapter();const propertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,this._property);if(propertyTracks&&propertyTracks.length>1){if(!TMP_COLORS_MAP.has(instance))TMP_COLORS_MAP.set(instance,new Map);const instanceMap=TMP_COLORS_MAP.get(instance);const id=this._propertyTrack.GetSourceAdapterId();if(!instanceMap.has(id))instanceMap.set(id,new Map);const sourceMap=
instanceMap.get(id);if(!sourceMap.has(this._property))sourceMap.set(this._property,{used:false,color:new C3.Color(0,0,0,1)})}}_GetTmpColor(instance,sourceId,propertyName){const tmpColorObj=TMP_COLORS_MAP.get(instance).get(sourceId).get(propertyName);tmpColorObj.used=true;return tmpColorObj.color}ChangeProperty(time,value,start,end,setTime){const timeline=this._propertyTrack.GetTimeline();const track=this._propertyTrack.GetTrack();const instance=this._propertyTrack.GetInstance();const sourceAdapter=
this._propertyTrack.GetSourceAdapter();const sourceAdapterId=this._propertyTrack.GetSourceAdapterId();const property=this._property;const propertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,property);if(propertyTracks&&propertyTracks.length>1){const propertyKeyframeStubs=this._GetPropertyKeyframeStubs(propertyTracks,true);const stub=this._GetLastPropertyKeyframeStub(timeline,timeline.GetTime(),propertyKeyframeStubs);if(stub){const startOffset=track.GetStartOffset();const t=stub.time-
startOffset;if(t===0)this._GetTmpColor(instance,sourceAdapterId,this._property).addRgb(value[0],value[1],value[2]);else{if(t<0)return;const r=value[0];const g=value[1];const b=value[2];const v=this._propertyTrack.Interpolate(t,false,true);const dr=C3.Color.DiffChannel(r,v[0]);const dg=C3.Color.DiffChannel(g,v[1]);const db=C3.Color.DiffChannel(b,v[2]);this._GetTmpColor(instance,sourceAdapterId,this._property).addRgb(dr,dg,db)}}}else this._Setter(value[0],value[1],value[2])}AfterChangeProperty(){const instance=
this._propertyTrack.GetInstance();if(!TMP_COLORS_MAP.has(instance))return;const instanceMap=TMP_COLORS_MAP.get(instance);const id=this._propertyTrack.GetSourceAdapterId();if(!instanceMap.has(id))return;const sourceMap=instanceMap.get(id);if(!sourceMap.has(this._property))return;const tmpColorObj=sourceMap.get(this._property);const used=tmpColorObj.used;const color=tmpColorObj.color;if(used)this._Setter(color.getR(),color.getG(),color.getB());if(sourceMap.size===0)instanceMap.delete(id);if(instanceMap.size===
0)TMP_COLORS_MAP.delete(instance)}_Getter(){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":return this._GetColorFromArray(target.GetPropertyValueByIndex(index));case "effect":return target[index].clone();case "plugin":return this._GetColorFromArray(target.GetPropertyValueByIndex(index));case "world-instance":return this.GetWorldInfo().GetUnpremultipliedColor().clone()}}_Setter(r,g,b){const id=this._propertyTrack.GetSourceAdapterId();
const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":TMP_COLOR[0]=r;TMP_COLOR[1]=g;TMP_COLOR[2]=b;target.SetPropertyValueByIndex(index,TMP_COLOR);break;case "effect":target[index].setRgb(r,g,b);break;case "plugin":TMP_COLOR[0]=r;TMP_COLOR[1]=g;TMP_COLOR[2]=b;target.SetPropertyValueByIndex(index,TMP_COLOR);break;case "world-instance":this.GetWorldInfo().SetUnpremultipliedColorRGB(r,g,b);break}}_SaveToJson(){}_LoadFromJson(o){}}
C3.PropertyTrackState.PropertyInterpolationAdapter.ColorInterpolationAdapter=ColorInterpolationAdapter;

}

// timelines/state/propertyInterpolationAdapters/noInterpolationAdapter.js
{
'use strict';const C3=self.C3;const NS=C3.PropertyTrackState;
class NoInterpolationAdapter extends C3.PropertyTrackState.PropertyInterpolationAdapter{constructor(sourceAdapter){super(sourceAdapter)}SetResetState(){}SetInitialState(){}SetResumeState(){}GetCurrentState(){return this._Getter()}CompareInitialStateWithCurrent(){const firstKeyframeValue=this._FirstKeyframeGetter();return firstKeyframeValue!==this.GetCurrentState()}CompareSaveStateWithCurrent(){if(C3.IsNullOrUndefined(this._saveState))return false;return this._saveState!==this.GetCurrentState()}MayNeedBeforeAndAfterInterpolate(){return false}ChangeProperty(time,
value,start,end,setTime){const propertyTrack=this._propertyTrack;const track=propertyTrack.GetTrack();const id=propertyTrack.GetSourceAdapterId();const timeline=propertyTrack.GetTimeline();const instance=track.GetInstance();const sourceAdapter=propertyTrack.GetSourceAdapter();const property=this._property;const propertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,property);if(propertyTracks&&propertyTracks.length>1){const propertyKeyframeStubs=this._GetPropertyKeyframeStubs(propertyTracks);
const t=time+track.GetStartOffset();const stub=this._GetLastPropertyKeyframeStub(timeline,t,propertyKeyframeStubs);if(stub)value=stub.value}const type=propertyTrack.GetPropertyKeyframeType();switch(type){case "numeric":{if(!NS.NumericTypeAdapter.WillChange(this._GetIndex(),this._GetTarget(),value,id))return;break}case "angle":{if(!NS.AngleTypeAdapter.WillChange(this._GetIndex(),this._GetTarget(),value,id))return;break}case "boolean":{if(!NS.BooleanTypeAdapter.WillChange(this._GetIndex(),this._GetTarget(),
value,id))return;break}case "color":{if(!NS.ColorTypeAdapter.WillChange(this._GetIndex(),this._GetTarget(),value,id))return;break}case "text":{if(!NS.TextTypeAdapter.WillChange(this._GetIndex(),this._GetTarget(),value,id))return;break}}this._Setter(value)}_Getter(){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":return target.GetPropertyValueByIndex(index);case "effect":return target[index];case "instance-variable":return target.GetInstanceVariableValue(index);
case "plugin":return target.GetPropertyValueByIndex(index)}}_Setter(value){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":target.SetPropertyValueByIndex(index,value);break;case "effect":target[index]=value;break;case "instance-variable":target.SetInstanceVariableValue(index,value);break;case "plugin":target.SetPropertyValueByIndex(index,value);break}}}
C3.PropertyTrackState.PropertyInterpolationAdapter.NoInterpolationAdapter=NoInterpolationAdapter;

}

// timelines/state/propertyInterpolationAdapters/numericInterpolationAdapter.js
{
'use strict';const C3=self.C3;const NS=C3.PropertyTrackState.PropertyInterpolationAdapter;const INSTANCE_FUNC_MAP=new Map;const add=(prop,setter,absolute_setter,getter,round,fRound=false,init=null,reset=null)=>{INSTANCE_FUNC_MAP.set(prop,{setter,absolute_setter,getter,round,fRound,init,reset})};add("offsetX",(wi,v,t,a)=>{if(a._propertyTrack.GetResultMode()==="relative")wi.OffsetX(v,t.GetTimeline().GetTransformWithSceneGraph());else wi.OffsetX(v)},(wi,v)=>wi.SetX(v),wi=>wi.GetX(),true);
add("offsetY",(wi,v,t,a)=>{if(a._propertyTrack.GetResultMode()==="relative")wi.OffsetY(v,t.GetTimeline().GetTransformWithSceneGraph());else wi.OffsetY(v)},(wi,v)=>wi.SetY(v),wi=>wi.GetY(),true);
add("offsetWidth",(wi,v,t,a,noChanges)=>{if(v===0)return;const isRelative=a._propertyTrack.GetResultMode()==="relative";const isTween=a._typeAdapter.GetType()===1;if((isRelative||isTween)&&wi.HasParent()&&wi.GetTransformWithParentWidth()){if(isNaN(a._absoluteToFactor)){const parents=[];let parent=wi.GetParent();while(parent){parents.push(parent);parent=parent.GetParent()}parents.reverse();const get_track=(wi,t)=>{return t.GetTimeline().GetTrackFromInstance(wi.GetInstance())};const get_original_size=
(wi,t)=>{const track=get_track(wi,t);if(track)return track.GetOriginalWidth();const sdki=wi.GetInstance().GetSdkInstance();if(sdki.IsOriginalSizeKnown())return sdki.GetOriginalWidth();return wi._GetSceneGraphInfo()._GetStartWidth()};const get_last_property_keyframe_value=(wi,t,propertyName)=>{const track=get_track(wi,t);if(!track)return 0;const propertyTrack=track.GetPropertyTrack(propertyName);if(!propertyTrack)return 0;const parentPropertyKeyframeData=propertyTrack.GetPropertyTrackDataItem().GetPropertyKeyframeData();
if(!parentPropertyKeyframeData)return 0;const parentLastPropertyKeyframeDataItem=parentPropertyKeyframeData.GetLastPropertyKeyframeDataItem();if(!parentLastPropertyKeyframeDataItem)return 0;return parentLastPropertyKeyframeDataItem.GetValue()};let p=parents[0];const ownStartSize=p._GetSceneGraphInfo()._GetStartWidth();const ownStartScale=p._GetSceneGraphInfo().GetStartScaleX();let absoluteToFactor=ownStartSize*ownStartScale;absoluteToFactor+=get_last_property_keyframe_value(p,t,"offsetWidth");absoluteToFactor+=
get_original_size(p,t)*get_last_property_keyframe_value(p,t,"offsetScaleX");for(let i=1;i<parents.length;i++){p=parents[i];absoluteToFactor*=p._GetSceneGraphInfo().GetStartScaleX();absoluteToFactor+=get_last_property_keyframe_value(p,t,"offsetWidth");absoluteToFactor+=get_original_size(p,t)*get_last_property_keyframe_value(p,t,"offsetScaleX")}a._absoluteToFactor=absoluteToFactor===0?Number.EPSILON:absoluteToFactor}if(noChanges)return;wi.OffsetWidth(v/a._absoluteToFactor,true)}else wi.OffsetWidth(v)},
(wi,v)=>wi.SetWidth(v),wi=>wi.GetWidth(),true);
add("offsetHeight",(wi,v,t,a,noChanges)=>{if(v===0)return;const isRelative=a._propertyTrack.GetResultMode()==="relative";const isTween=a._typeAdapter.GetType()===1;if((isRelative||isTween)&&wi.HasParent()&&wi.GetTransformWithParentHeight()){if(isNaN(a._absoluteToFactor)){const parents=[];let parent=wi.GetParent();while(parent){parents.push(parent);parent=parent.GetParent()}parents.reverse();const get_track=(wi,t)=>{return t.GetTimeline().GetTrackFromInstance(wi.GetInstance())};const get_original_size=
(wi,t)=>{const track=get_track(wi,t);if(track)return track.GetOriginalHeight();const sdki=wi.GetInstance().GetSdkInstance();if(sdki.IsOriginalSizeKnown())return sdki.GetOriginalHeight();return wi._GetSceneGraphInfo()._GetStartHeight()};const get_last_property_keyframe_value=(wi,t,propertyName)=>{const track=t.GetTimeline().GetTrackFromInstance(wi.GetInstance());if(!track)return 0;const propertyTrack=track.GetPropertyTrack(propertyName);if(!propertyTrack)return 0;const parentPropertyKeyframeData=propertyTrack.GetPropertyTrackDataItem().GetPropertyKeyframeData();
if(!parentPropertyKeyframeData)return 0;const parentLastPropertyKeyframeDataItem=parentPropertyKeyframeData.GetLastPropertyKeyframeDataItem();if(!parentLastPropertyKeyframeDataItem)return 0;return parentLastPropertyKeyframeDataItem.GetValue()};let p=parents[0];const ownStartSize=p._GetSceneGraphInfo()._GetStartHeight();const ownStartScale=p._GetSceneGraphInfo().GetStartScaleY();let absoluteToFactor=ownStartSize*ownStartScale;absoluteToFactor+=get_last_property_keyframe_value(p,t,"offsetHeight");absoluteToFactor+=
get_original_size(p,t)*get_last_property_keyframe_value(p,t,"offsetScaleY");for(let i=1;i<parents.length;i++){p=parents[i];absoluteToFactor*=p._GetSceneGraphInfo().GetStartScaleY();absoluteToFactor+=get_last_property_keyframe_value(p,t);absoluteToFactor+=get_original_size(p,t)*get_last_property_keyframe_value(p,t,"offsetScaleY")}a._absoluteToFactor=absoluteToFactor===0?Number.EPSILON:absoluteToFactor}if(noChanges)return;wi.OffsetHeight(v/a._absoluteToFactor,true)}else wi.OffsetHeight(v)},(wi,v)=>
wi.SetHeight(v),wi=>wi.GetHeight(),true);add("offsetAngle",(wi,v)=>wi.OffsetAngle(v),(wi,v)=>wi.SetAngle(v),wi=>wi.GetAngle(),false,true);
add("offsetOpacity",(wi,v,t,a,noChanges)=>{const opacityFactor=a._opacityFactor?a._opacityFactor:1;v/=opacityFactor;const o=wi.GetOpacity();const nv=o+v;const min=0;const max=1;if(a._clampAccumulator===0){if(nv>max)a._clampAccumulator+=nv-max;else if(nv<min)a._clampAccumulator+=nv;wi.OffsetOpacity(v)}else{const nv=wi.GetOpacity()+v;if(v>0&&a._clampAccumulator>0){if(nv>max)a._clampAccumulator+=nv-max}else if(v>0&&a._clampAccumulator<0){a._clampAccumulator+=v;if(a._clampAccumulator>0)a._clampAccumulator=
0}else if(v<0&&a._clampAccumulator>0){a._clampAccumulator+=v;if(a._clampAccumulator<0)a._clampAccumulator=0}else if(v<0&&a._clampAccumulator<0)if(nv<min)a._clampAccumulator+=nv}},(wi,v)=>{wi.SetOpacity(v)},wi=>{return wi.GetOpacity()},false,true,(a,wi,t)=>{a._clampAccumulator=0;switch(a._propertyTrack.GetResultMode()){case "relative":{const propertyTrackData=a._propertyTrack.GetPropertyTrackData();const propertyTrackDataItem=a._propertyTrack.GetPropertyTrackDataItem();const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();
const propertyKeyframeDataItems=propertyKeyframeData.GetPropertyKeyframeDataItemArray();let startingAbsoluteOpacity=a.GetWorldInfo().GetOpacity();let currentAbsoluteOpacity=startingAbsoluteOpacity;for(const propertyKeyframeDataItem of propertyKeyframeDataItems){const time=propertyKeyframeDataItem.GetTime();const currentRelativeOpacity=a._propertyTrack.GetInterpolatedValue(time);currentAbsoluteOpacity=startingAbsoluteOpacity+currentRelativeOpacity;currentAbsoluteOpacity=C3.clamp(currentAbsoluteOpacity,
0,1)}a._totalForewardOpacityDelta=startingAbsoluteOpacity-currentAbsoluteOpacity;a._totalForewardOpacityDelta=Math.round((a._totalForewardOpacityDelta+Number.EPSILON)*100)/100;currentAbsoluteOpacity=startingAbsoluteOpacity;for(let i=propertyKeyframeDataItems.length-1;i>=0;i--){const time=propertyKeyframeDataItems[i].GetTime();const currentRelativeOpacity=a._propertyTrack.GetInterpolatedValue(time);currentAbsoluteOpacity-=currentRelativeOpacity;currentAbsoluteOpacity=C3.clamp(currentAbsoluteOpacity,
0,1)}a._totalBackwardOpacityDelta=currentAbsoluteOpacity;a._totalBackwardOpacityDelta=Math.round((a._totalBackwardOpacityDelta+Number.EPSILON)*100)/100;break}case "absolute":{break}}const isRelative=a._propertyTrack.GetResultMode()==="relative";const isTween=a._typeAdapter.GetType()===1;if((isRelative||isTween)&&wi.HasParent()&&wi.GetTransformWithParentOpacity()){const parents=[];let parent=wi.GetParent();while(parent){parents.push(parent);parent=parent.GetParent()}parents.reverse();const get_last_property_keyframe_value=
(wi,t,propertyName)=>{const track=t.GetTimeline().GetTrackFromInstance(wi.GetInstance());if(!track)return 0;const propertyTrack=track.GetPropertyTrack(propertyName);if(!propertyTrack)return 0;const parentPropertyKeyframeData=propertyTrack.GetPropertyTrackDataItem().GetPropertyKeyframeData();if(!parentPropertyKeyframeData)return 0;const parentLastPropertyKeyframeDataItem=parentPropertyKeyframeData.GetLastPropertyKeyframeDataItem();if(!parentLastPropertyKeyframeDataItem)return 0;return parentLastPropertyKeyframeDataItem.GetValue()};
let opacityFactor=parents[0]._GetSceneGraphInfo().GetStartOpacity();opacityFactor+=get_last_property_keyframe_value(parents[0],t,"offsetOpacity");for(let i=1;i<parents.length;i++)opacityFactor+=get_last_property_keyframe_value(parents[i],t,"offsetOpacity");a._opacityFactor=opacityFactor===0?1:opacityFactor}},a=>{switch(a._propertyTrack.GetResultMode()){case "relative":{a._clampAccumulator=0;const wi=a.GetWorldInfo();let currentOpacity=wi.GetOpacity();currentOpacity=Math.round((currentOpacity+Number.EPSILON)*
100)/100;if(a._propertyTrack.GetTimeline().IsForwardPlayBack()){wi.SetOpacity(currentOpacity+a._totalForewardOpacityDelta);a._lastValue=0}else{wi.SetOpacity(currentOpacity-a._totalBackwardOpacityDelta);a._lastValue=a.GetSourceAdapter().GetValueAtTime()}break}case "absolute":{break}}});add("offsetOriginX",(wi,v)=>wi.OffsetOriginX(v),(wi,v)=>wi.SetOriginX(v),wi=>wi.GetOriginX(),false);add("offsetOriginY",(wi,v)=>wi.OffsetOriginY(v),(wi,v)=>wi.SetOriginY(v),wi=>wi.GetOriginY(),false);
add("offsetZElevation",(wi,v)=>wi.OffsetZElevation(v),(wi,v)=>wi.SetZElevation(v),wi=>wi.GetZElevation(),true);
add("offsetScaleX",(wi,v,t,a)=>{if(v===0)return;const mirrorFactor=wi.GetWidth()<0?-1:1;if(a._propertyTrack.GetResultMode()==="relative"&&wi.HasParent()&&wi.GetTransformWithParentWidth()){const value=t.GetOriginalWidth()*mirrorFactor*v;if(isNaN(a._absoluteToFactor))INSTANCE_FUNC_MAP.get("offsetWidth").setter(wi,1,t,a,true);wi.OffsetWidth(value/a._absoluteToFactor,true)}else wi.OffsetWidth(t.GetOriginalWidth()*mirrorFactor*v)},(wi,v,t)=>{wi.SetWidth(t.GetOriginalWidth()*v)},(wi,t)=>{const mirrorFactor=
wi.GetWidth()<0?-1:1;if(wi.GetTransformWithParentWidth()){const parentWi=wi.GetParent();const parentTrack=t.GetTimeline().GetTrackFromInstance(parentWi.GetInstance());let parentScale=NaN;if(parentTrack)parentScale=parentWi.GetWidth()/parentTrack.GetOriginalWidth();else{const sdki=parentWi.GetInstance().GetSdkInstance();if(sdki.IsOriginalSizeKnown())parentScale=parentWi.GetWidth()/sdki.GetOriginalWidth();else parentScale=1}return wi.GetWidth()*mirrorFactor/(t.GetOriginalWidth()*parentScale)}else return wi.GetWidth()*
mirrorFactor/t.GetOriginalWidth()},false);
add("offsetScaleY",(wi,v,t,a)=>{if(v===0)return;const flipFactor=wi.GetHeight()<0?-1:1;if(a._propertyTrack.GetResultMode()==="relative"&&wi.HasParent()&&wi.GetTransformWithParentHeight()){const value=t.GetOriginalHeight()*flipFactor*v;if(isNaN(a._absoluteToFactor))INSTANCE_FUNC_MAP.get("offsetHeight").setter(wi,1,t,a,true);wi.OffsetHeight(value/a._absoluteToFactor,true)}else wi.OffsetHeight(t.GetOriginalHeight()*flipFactor*v)},(wi,v,t)=>{wi.SetHeight(t.GetOriginalHeight()*v)},(wi,t)=>{const flipFactor=
wi.GetHeight()<0?-1:1;if(wi.GetTransformWithParentHeight()){const parentWi=wi.GetParent();const parentTrack=t.GetTimeline().GetTrackFromInstance(parentWi.GetInstance());let parentScale=NaN;if(parentTrack)parentScale=parentWi.GetHeight()/parentTrack.GetOriginalHeight();else{const sdki=parentWi.GetInstance().GetSdkInstance();if(sdki.IsOriginalSizeKnown())parentScale=parentWi.GetHeight()/sdki.GetOriginalHeight();else parentScale=1}return wi.GetHeight()*flipFactor/(t.GetOriginalHeight()*parentScale)}else return wi.GetHeight()*
flipFactor/t.GetOriginalHeight()},false);
class NumericInterpolationAdapter extends C3.PropertyTrackState.PropertyInterpolationAdapter{constructor(sourceAdapter){super(sourceAdapter);this._lastValue=0;this._clampAccumulator=0;this._totalForewardOpacityDelta=0;this._totalBackwardOpacityDelta=0;this._opacityFactor=NaN;this._absoluteToFactor=NaN;this._instance_getter=null;this._instance_setter=null;this._instance_absolute_setter=null;this._reset_action=null;this._init_action=null;this._source_adapter_getter=null;this._source_adapter_setter=
null;this._source_adapter_absolute_setter=null;this._round=false;this._fRound=false;if(C3.IsInstanceOf(this._propertyTrack.GetTimeline(),C3.TweenState))this._typeAdapter=new C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTween(this);else this._typeAdapter=new C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTimeline(this);const property=this._propertyTrack.GetPropertyName();switch(this._propertyTrack.GetSourceAdapterId()){case "world-instance":{const p=
INSTANCE_FUNC_MAP.get(property);this._instance_getter=p.getter;this._instance_setter=p.setter;this._instance_absolute_setter=p.absolute_setter;this._round=p.round;this._fRound=p.fRound;this._init_action=p.init;this._reset_action=p.reset;break}case "audio":{this._source_adapter_getter=sourceAdapter.Getter;this._source_adapter_setter=sourceAdapter.Setter;this._source_adapter_absolute_setter=sourceAdapter.AbsoluteSetter;this._round=!!sourceAdapter.DoesRounding();this._fRound=false;break}}}Release(){this._typeAdapter=
null;this._instance_getter=null;this._instance_setter=null;this._instance_absolute_setter=null;this._absoluteToFactor=NaN;super.Release()}MayNeedBeforeAndAfterInterpolate(){return this._typeAdapter.MayNeedBeforeAndAfterInterpolate()}GetLastValue(){return this._lastValue}SetLastValue(v){this._lastValue=v}SetResetState(){if(this._reset_action)this._reset_action(this)}SetInitialState(){const initValue=this._typeAdapter.SetInitialState();if(typeof initValue==="number")this._lastValue=initValue;if(this._init_action){const wi=
this.GetWorldInfo();const track=this._propertyTrack.GetTrack();this._init_action(this,wi,track)}}SetResumeState(){const resumeValue=this._typeAdapter.SetResumeState();if(typeof resumeValue==="number")this._lastValue=resumeValue}GetCurrentState(){return this._Getter()}CompareInitialStateWithCurrent(){const firstKeyframeValue=this._FirstKeyframeGetter();return firstKeyframeValue!==this.GetCurrentState()}CompareSaveStateWithCurrent(){if(C3.IsNullOrUndefined(this._saveState))return false;return this._saveState!==
this.GetCurrentState()}BeforeChangeProperty(){this._typeAdapter.BeforeChangeProperty()}ChangeProperty(time,value,start,end,setTime,ensureValue,endState){return this._typeAdapter.ChangeProperty(time,value,start,end,setTime,ensureValue,endState)}AfterChangeProperty(){this._typeAdapter.AfterChangeProperty()}_Getter(){const target=this._GetTarget();const index=this._GetIndex();const wi=this.GetWorldInfo();const track=this._propertyTrack.GetTrack();const id=this._propertyTrack.GetSourceAdapterId();switch(id){case "behavior":return target.GetPropertyValueByIndex(index);
case "effect":return target[index];case "instance-variable":return target.GetInstanceVariableValue(index);case "plugin":return target.GetPropertyValueByIndex(index);case "world-instance":return this._instance_getter(wi,track);case "audio":return this._source_adapter_getter.call(this.GetSourceAdapter(),wi,track)}}_Setter(value,start,end){const target=this._GetTarget();const index=this._GetIndex();const wi=this.GetWorldInfo();const track=this._propertyTrack.GetTrack();const id=this._propertyTrack.GetSourceAdapterId();
switch(id){case "behavior":target.OffsetPropertyValueByIndex(index,value);break;case "effect":target[index]+=value;break;case "instance-variable":target.SetInstanceVariableOffset(index,value);break;case "plugin":target.OffsetPropertyValueByIndex(index,value,this.GetSourceAdapter().GetOptionalCallbacks());break;case "world-instance":this._instance_setter(wi,value,track,this);break;case "audio":this._source_adapter_setter.call(this.GetSourceAdapter(),wi,value,track,this);break}}_SetterAbsolute(value,
start,end){const target=this._GetTarget();const index=this._GetIndex();const wi=this.GetWorldInfo();const track=this._propertyTrack.GetTrack();const id=this._propertyTrack.GetSourceAdapterId();switch(id){case "behavior":target.SetPropertyValueByIndex(index,value);break;case "effect":target[index]=value;break;case "instance-variable":target.SetInstanceVariableValue(index,value);break;case "plugin":target.SetPropertyValueByIndex(index,value,this.GetSourceAdapter().GetOptionalCallbacks());break;case "world-instance":this._instance_absolute_setter(wi,
value,track);break;case "audio":this._source_adapter_absolute_setter.call(this.GetSourceAdapter(),wi,value,track);break}}_MaybeEnsureValue(time,start,end,setTime,lastValue,currentValue,forceEndValue,endState){this._typeAdapter._MaybeEnsureValue(time,start,end,setTime,lastValue,currentValue,forceEndValue,endState)}_AddDelta(value,start,end,forceEndValue,endState){switch(this._propertyTrack.GetPropertyType()){case "angle":{value=C3.toDegrees(value);break}default:{value=value;break}}const stringValue=
value.toString();const decimalsString=stringValue.split(".")[1]||"";const decimalPlaces=decimalsString.length;const v=this._Getter();let rv;if(decimalPlaces===0)if(this._round)rv=Math.round(v);else if(this._fRound)switch(this._propertyTrack.GetPropertyType()){case "angle":{rv=C3.toRadians(Math.round(C3.toDegrees(v)));break}default:{rv=Math.round((v+Number.EPSILON)*100)/100;break}}else rv=v;else if(this._round)rv=Number(C3.toFixed(v,decimalPlaces));else if(this._fRound)rv=v;else rv=v;this._Setter(rv-
v,start,end)}_SaveToJson(){return Object.assign(super._SaveToJson(),{"v":this._lastValue,"a":this._clampAccumulator,"fod":this._totalForewardOpacityDelta,"bod":this._totalBackwardOpacityDelta})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._lastValue=o["v"];this._clampAccumulator=o["a"];this._totalForewardOpacityDelta=C3.IsFiniteNumber(o["fod"])?o["fod"]:0;this._totalBackwardOpacityDelta=C3.IsFiniteNumber(o["bod"])?o["bod"]:0}}
C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapter=NumericInterpolationAdapter;

}

// timelines/state/propertyInterpolationAdapters/numericInterpolationAdapterForTimeline.js
{
'use strict';const C3=self.C3;class AbsoluteValueObject{constructor(propertyTracks){this._used=false;this._value=0;this._propertyTracks=propertyTracks;for(let i=0,l=this._propertyTracks.length;i<l;i++)this._propertyTracks[i].SetAbsoluteValueObject(this)}GetPropertyTracks(){return this._propertyTracks}SetUsed(){this._used=true}GetUsed(){return this._used}SetValue(v){this._value=v}GetValue(){return this._value}Reset(){this._used=false;this._value=0}}
class NumericInterpolationAdapterForTimeline{constructor(numericInterpolationAdapter){this._numericInterpolationAdapter=numericInterpolationAdapter}Release(){this._numericInterpolationAdapter=null}GetType(){return 0}SetInitialState(){const adapter=this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();return adapter._PickResultMode(()=>{return adapter._PickTimelinePlaybackMode(()=>0,()=>adapter.GetSourceAdapter().GetValueAtTime())},()=>{})}SetResumeState(){}MayNeedBeforeAndAfterInterpolate(){const adapter=
this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();switch(propertyTrack.GetResultMode()){case "relative":{return false}case "absolute":{return true}}}BeforeChangeProperty(){const adapter=this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();const property=propertyTrack.GetPropertyName();switch(propertyTrack.GetResultMode()){case "relative":{break}case "absolute":{if(propertyTrack.HasAbsoluteValueObject()){const valueObj=
propertyTrack.GetAbsoluteValueObject();valueObj.Reset()}else{const timeline=propertyTrack.GetTimeline();const instance=propertyTrack.GetInstance();const sourceAdapter=propertyTrack.GetSourceAdapter();const similarPropertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,property);if(similarPropertyTracks&&similarPropertyTracks.length>1)new AbsoluteValueObject(similarPropertyTracks)}break}}}ChangeProperty(time,value,start,end,setTime,ensureValue,endState){const adapter=this._numericInterpolationAdapter;
const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();switch(propertyTrack.GetResultMode()){case "relative":{const lastValue=adapter.GetLastValue();adapter._Setter(value-lastValue,start,end);if(ensureValue)this._MaybeEnsureValue(time,start,end,setTime,lastValue,value);adapter.SetLastValue(value);break}case "absolute":{const timeline=propertyTrack.GetTimeline();const track=propertyTrack.GetTrack();const instance=propertyTrack.GetInstance();const sourceAdapter=propertyTrack.GetSourceAdapter();
if(propertyTrack.HasAbsoluteValueObject()){const absoluteValueObject=propertyTrack.GetAbsoluteValueObject();const similarpropertyTracks=absoluteValueObject.GetPropertyTracks();const propertyKeyframeStubs=adapter._GetPropertyKeyframeStubs(similarpropertyTracks,true);const stub=adapter._GetLastPropertyKeyframeStub(timeline,timeline.GetTime(),propertyKeyframeStubs);if(stub){const startOffset=track.GetStartOffset();const t=stub.time-startOffset;if(t===0){absoluteValueObject.SetUsed();absoluteValueObject.SetValue(absoluteValueObject.GetValue()+
value)}else{if(t<0)return;const v=propertyTrack.GetInterpolatedValue(t);absoluteValueObject.SetUsed();absoluteValueObject.SetValue(absoluteValueObject.GetValue()+(value-v))}}}else adapter._SetterAbsolute(value);break}}}AfterChangeProperty(){const adapter=this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();switch(propertyTrack.GetResultMode()){case "relative":{break}case "absolute":{if(propertyTrack.HasAbsoluteValueObject()){const absoluteValueObject=
propertyTrack.GetAbsoluteValueObject();if(absoluteValueObject.GetUsed())adapter._SetterAbsolute(absoluteValueObject.GetValue())}break}}}_MaybeEnsureValue(time,start,end,setTime,lastValue,currentValue){const adapter=this._numericInterpolationAdapter;if(setTime)return;if(start&&time===start.GetTime())adapter._AddDelta(start.GetValueWithResultMode(),start,end);else if(end&&time===end.GetTime())adapter._AddDelta(end.GetValueWithResultMode(),start,end);else if(currentValue-lastValue===0)adapter._AddDelta(start.GetValueWithResultMode(),
start,end)}}C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTimeline=NumericInterpolationAdapterForTimeline;

}

// timelines/state/propertyInterpolationAdapters/numericInterpolationAdapterForTween.js
{
'use strict';const C3=self.C3;
class NumericInterpolationAdapterForTween{constructor(numericInterpolationAdapter){this._numericInterpolationAdapter=numericInterpolationAdapter}Release(){this._numericInterpolationAdapter=null}GetType(){return 1}SetInitialState(){const adapter=this._numericInterpolationAdapter;adapter.SetFirstAbsoluteUpdate(true);return this._GetAbsoluteInitialValue(adapter._FirstKeyframeGetter())}SetResumeState(){const adapter=this._numericInterpolationAdapter;if(adapter._FirstKeyframeGetter()===adapter._CurrentKeyframeGetter())return;
adapter.SetFirstAbsoluteUpdate(true);return this._GetAbsoluteInitialValue(adapter._CurrentKeyframeGetter())}MayNeedBeforeAndAfterInterpolate(){return false}BeforeChangeProperty(){}ChangeProperty(time,value,start,end,setTime,ensureValue,endState){const adapter=this._numericInterpolationAdapter;const lastValue=adapter.GetLastValue();switch(adapter.GetPropertyTrack().GetResultMode()){case "relative":{adapter._Setter(value-lastValue,start,end);if(ensureValue)this._MaybeEnsureValue(time,start,end,setTime,
lastValue,value,false,endState);break}case "absolute":{if(adapter.GetFirstAbsoluteUpdate()){adapter.SetFirstAbsoluteUpdate(false);adapter._Setter(lastValue,start,end)}else{adapter._Setter(value-lastValue,start,end);if(ensureValue)this._MaybeEnsureValue(time,start,end,setTime,lastValue,value,this._ForceEndValue(),endState)}break}}adapter.SetLastValue(value)}AfterChangeProperty(){}_GetAbsoluteInitialValue(keyframeValue){const adapter=this._numericInterpolationAdapter;return keyframeValue-adapter.GetCurrentState()}_ForceEndValue(){const adapter=
this._numericInterpolationAdapter;const inst=adapter.GetWorldInfo().GetInstance();const runtime=adapter.GetPropertyTrack().GetRuntime();const timelineManager=runtime.GetTimelineManager();let activeTimelineCount=0;for(const timeline of timelineManager.GetPlayingTimelines())if(timeline.GetType()===0){if(timeline.HasTrackInstance(inst))activeTimelineCount++}else if(timeline.GetType()===1)if(timeline.GetInstance()===inst)activeTimelineCount++;return activeTimelineCount<=1}_MaybeEnsureValue(time,start,
end,setTime,lastValue,currentValue,forceEndValue,endState){const adapter=this._numericInterpolationAdapter;if(setTime)if(start&&time===start.GetTime())adapter._AddDelta(start.GetValueWithResultMode(),start,end,forceEndValue,endState);else if(end&&time===end.GetTime())adapter._AddDelta(end.GetValueWithResultMode(),start,end,forceEndValue,endState);else{if(!end)adapter._AddDelta(start.GetValueWithResultMode(),start,end,forceEndValue,endState)}else if(start&&time===start.GetTime())adapter._AddDelta(start.GetValueWithResultMode(),
start,end,forceEndValue,endState);else if(end&&time===end.GetTime())adapter._AddDelta(end.GetValueWithResultMode(),start,end,forceEndValue,endState);else if(currentValue-lastValue===0)adapter._AddDelta(start.GetValueWithResultMode(),start,end,forceEndValue,endState)}}C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTween=NumericInterpolationAdapterForTween;

}

// timelines/state/propertyTypeAdapters/numericTypeAdapter.js
{
'use strict';const C3=self.C3;const Ease=self.Ease;
C3.PropertyTrackState.NumericTypeAdapter=class NumericTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(oldValue===newValue)return false;return true}static Interpolate(time,start,end,propertyTrack){if(!end){let propertyTrackDataItem=
propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()}let mode=propertyTrack.GetInterpolationMode();if(mode==="default")mode="continuous";if(propertyTrack.GetPropertyType()==="combo")mode="discrete";if(mode==="discrete")return start.GetValueWithResultMode();else if(mode==="continuous"||mode==="step"){if(mode===
"step"){const step=propertyTrack.GetTimeline().GetStep();if(step!==0){const s=1/step;time=Math.floor(time*s)/s}}const sv=start.GetValueWithResultMode();const ev=end.GetValueWithResultMode();const startAddon=start.GetAddOn("cubic-bezier");const endAddon=end.GetAddOn("cubic-bezier");const doCubicBezier=startAddon&&startAddon.GetStartEnable()&&endAddon&&endAddon.GetEndEnable();if(!doCubicBezier&&sv===ev)return sv;const st=start.GetTime();const et=end.GetTime();const n=C3.normalize(time,st,et);const e=
start.GetEase();let ret;if(doCubicBezier){const dt=et-st;ret=Ease.GetRuntimeEase(e)(dt*n,0,1,dt);ret=Ease.GetRuntimeEase("cubicbezier")(ret,sv,sv+startAddon.GetStartAnchor(),ev+endAddon.GetEndAnchor(),ev)}else ret=Ease.GetRuntimeEase(e)((et-st)*n,sv,ev-sv,et-st);if(propertyTrack.GetPropertyType()==="integer")return Math.floor(ret);return ret}}};

}

// timelines/state/propertyTypeAdapters/angleTypeAdapter.js
{
'use strict';const C3=self.C3;
C3.PropertyTrackState.AngleTypeAdapter=class AngleTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(oldValue===newValue)return false;return true}static Interpolate(time,start,end,propertyTrack){if(!end){let propertyTrackDataItem=
propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()}let mode=propertyTrack.GetInterpolationMode();if(mode==="default")mode="continuous";if(propertyTrack.GetPropertyType()==="combo")mode="discrete";if(mode==="discrete")return start.GetValueWithResultMode();else if(mode==="continuous"||mode==="step"){if(mode===
"step"){const step=propertyTrack.GetTimeline().GetStep();if(step!==0){const s=1/step;time=Math.floor(time*s)/s}}const st=start.GetTime();const et=end.GetTime();const sv=start.GetValueWithResultMode();const ev=end.GetValueWithResultMode();const angleAddon=start.GetAddOn("angle");if(angleAddon){const revolutions=angleAddon.GetRevolutions();if(sv===ev&&revolutions===0)return sv;const n=C3.normalize(time,st,et);const easeFunc=self.Ease.GetRuntimeEase(start.GetEase());const easeRes=easeFunc(n,0,1,1);switch(angleAddon.GetDirection()){case "closest":return C3.angleLerp(sv,
ev,easeRes,revolutions);case "clockwise":return C3.angleLerpClockwise(sv,ev,easeRes,revolutions);case "anti-clockwise":return C3.angleLerpAntiClockwise(sv,ev,easeRes,revolutions)}}else{if(sv===ev)return sv;const n=C3.normalize(time,st,et);const easeFunc=self.Ease.GetRuntimeEase(start.GetEase());return C3.angleLerp(sv,ev,easeFunc(n,0,1,1))}}}};

}

// timelines/state/propertyTypeAdapters/booleanTypeAdapter.js
{
'use strict';const C3=self.C3;
C3.PropertyTrackState.BooleanTypeAdapter=class BooleanTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(!!oldValue===!!newValue)return false;return true}static Interpolate(time,start,end,propertyTrack){if(!end){let propertyTrackDataItem=
propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()?1:0}return start.GetValueWithResultMode()?1:0}};

}

// timelines/state/propertyTypeAdapters/colorTypeAdapter.js
{
'use strict';const C3=self.C3;const TEMP_COLOR_ARRAY=[0,0,0];const TEMP_COLOR_ARRAY_2=[0,0,0];const TEMP_COLOR_ARRAY_3=[0,0,0];
C3.PropertyTrackState.ColorTypeAdapter=class ColorTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(Array.isArray(newValue)){TEMP_COLOR_ARRAY[0]=newValue[0];TEMP_COLOR_ARRAY[1]=newValue[1];TEMP_COLOR_ARRAY[2]=
newValue[2]}else{TEMP_COLOR_ARRAY_3.parseCommaSeparatedRgb(newValue);TEMP_COLOR_ARRAY[0]=Math.floor(TEMP_COLOR_ARRAY_3.getR()*255);TEMP_COLOR_ARRAY[1]=Math.floor(TEMP_COLOR_ARRAY_3.getG()*255);TEMP_COLOR_ARRAY[2]=Math.floor(TEMP_COLOR_ARRAY_3.getB()*255)}if(Array.isArray(oldValue)){TEMP_COLOR_ARRAY_2[0]=oldValue[0];TEMP_COLOR_ARRAY_2[1]=oldValue[1];TEMP_COLOR_ARRAY_2[2]=oldValue[2]}else{TEMP_COLOR_ARRAY_3.parseCommaSeparatedRgb(oldValue);TEMP_COLOR_ARRAY_2[0]=Math.floor(TEMP_COLOR_ARRAY_3.getR()*
255);TEMP_COLOR_ARRAY_2[1]=Math.floor(TEMP_COLOR_ARRAY_3.getG()*255);TEMP_COLOR_ARRAY_2[2]=Math.floor(TEMP_COLOR_ARRAY_3.getB()*255)}if(TEMP_COLOR_ARRAY[0]!==TEMP_COLOR_ARRAY_2[0])return true;if(TEMP_COLOR_ARRAY[1]!==TEMP_COLOR_ARRAY_2[1])return true;if(TEMP_COLOR_ARRAY[2]!==TEMP_COLOR_ARRAY_2[2])return true;return false}static Interpolate(time,start,end,propertyTrack){if(!end){let propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();
propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);const color=propertyTrackDataItem.GetValueWithResultMode();TEMP_COLOR_ARRAY[0]=color[0];TEMP_COLOR_ARRAY[1]=color[1];TEMP_COLOR_ARRAY[2]=color[2];return TEMP_COLOR_ARRAY}let mode=propertyTrack.GetInterpolationMode();if(mode==="default")mode="continuous";if(mode==="discrete"){const color=start.GetValueWithResultMode();TEMP_COLOR_ARRAY[0]=color[0];TEMP_COLOR_ARRAY[1]=color[1];TEMP_COLOR_ARRAY[2]=color[2];
return TEMP_COLOR_ARRAY}else if(mode==="continuous"||mode==="step"){if(mode==="step"){const step=propertyTrack.GetTimeline().GetStep();if(step!==0){const s=1/step;time=Math.floor(time*s)/s}}const st=start.GetTime();const et=end.GetTime();const sv=start.GetValueWithResultMode();const ev=end.GetValueWithResultMode();const n=C3.normalize(time,st,et);const e=start.GetEase();const sr=sv[0];const sg=sv[1];const sb=sv[2];const er=ev[0];const eg=ev[1];const eb=ev[2];const easeFunc=self.Ease.GetRuntimeEase(e);
const d=et-st;const dn=d*n;if(sr===er)TEMP_COLOR_ARRAY[0]=sr;else TEMP_COLOR_ARRAY[0]=easeFunc(dn,sr,er-sr,d);if(sg===eg)TEMP_COLOR_ARRAY[1]=sg;else TEMP_COLOR_ARRAY[1]=easeFunc(dn,sg,eg-sg,d);if(sb===eb)TEMP_COLOR_ARRAY[2]=sb;else TEMP_COLOR_ARRAY[2]=easeFunc(dn,sb,eb-sb,d);return TEMP_COLOR_ARRAY}}};

}

// timelines/state/propertyTypeAdapters/textTypeAdapter.js
{
'use strict';const C3=self.C3;
C3.PropertyTrackState.TextTypeAdapter=class TextTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(oldValue===newValue)return false;return true}static Interpolate(time,start,end,propertyTrack){if(!end){let propertyTrackDataItem=
propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()}return start.GetValueWithResultMode()}};

}

// timelines/data/timelineDataManager.js
{
'use strict';const C3=self.C3;
C3.TimelineDataManager=class TimelineDataManager{constructor(){this._timelineDataItems=new Map}Release(){for(const timelineDataItem of this._timelineDataItems.values())timelineDataItem.Release();this._timelineDataItems.clear();this._timelineDataItems=null}Add(data){const timelineDataItem=new C3.TimelineDataItem(data);const name=timelineDataItem.GetName();this._timelineDataItems.set(name,timelineDataItem)}Get(name){return this._timelineDataItems.get(name)}GetNameId(){return 0}static _CreateDataItems(items,jsonItems,
dataItemConstructor,dataContainer){if(!jsonItems)return;for(const jsonItem of jsonItems)C3.TimelineDataManager._CreateDataItem("create",jsonItem,items,dataItemConstructor,dataContainer)}static _CreateDataItemsIncludingDisabled(items,jsonItems,dataItemConstructor,dataContainer){if(!jsonItems)return;for(const jsonItem of jsonItems)C3.TimelineDataManager._CreateDataItem("create-including-disabled",jsonItem,items,dataItemConstructor,dataContainer)}static _LoadDataItemsFromJson(items,jsonItems,dataItemConstructor,
dataContainer){if(items.length)jsonItems.forEach((jsonItem,index)=>{items[index]._LoadFromJson(jsonItem)});else jsonItems.forEach(jsonItem=>{C3.TimelineDataManager._CreateDataItem("load",jsonItem,items,dataItemConstructor,dataContainer)})}static _CreateDataItem(mode,json,items,dataItemConstructor,dataContainer){let dataItem;if(typeof dataItemConstructor==="function")switch(mode){case "load":dataItem=new dataItemConstructor(null,dataContainer);break;case "create":dataItem=new dataItemConstructor(json,
dataContainer);break;case "create-including-disabled":dataItem=new dataItemConstructor(json,dataContainer);break}else if(typeof dataItemConstructor==="object"){const prop=dataItemConstructor.prop;const value=json[prop];const cnstrctr=dataItemConstructor.map.get(value);switch(mode){case "load":dataItem=new cnstrctr(null,dataContainer);break;case "create":dataItem=new cnstrctr(json,dataContainer);break;case "create-including-disabled":dataItem=new cnstrctr(json,dataContainer);break}}switch(mode){case "load":dataItem._LoadFromJson(json);
items.push(dataItem);break;case "create":if(typeof dataItem.GetEnable==="function"&&!dataItem.GetEnable())return dataItem.Release();items.push(dataItem);break;case "create-including-disabled":items.push(dataItem);break}}};

}

// timelines/data/timelineData.js
{
'use strict';const C3=self.C3;const NAME=0;const TOTAL_TIME=1;const STEP=2;const INTERPOLATION_MODE=3;const RESULT_MODE=4;const TRACKS=5;const LOOP=6;const PING_PONG=7;const REPEAT_COUNT=8;const START_ON_LAYOUT=9;const TRANSFORM_WITH_SCENE_GRAPH=10;const USE_SYSTEM_TIMESCALE=11;
C3.TimelineDataItem=class TimelineDataItem{constructor(timelineDataJson){this._name="";this._totalTime=NaN;this._step=0;this._interpolationMode="default";this._resultMode="default";this._loop=false;this._pingPong=false;this._repeatCount=1;this._trackData=null;this._startOnLayout="";this._transformWithSceneGraph=false;this._useSystemTimescale=true;if(!timelineDataJson)return;this._name=timelineDataJson[NAME];this._totalTime=timelineDataJson[TOTAL_TIME];this._step=timelineDataJson[STEP];this._interpolationMode=
timelineDataJson[INTERPOLATION_MODE];this._resultMode=timelineDataJson[RESULT_MODE];this._loop=!!timelineDataJson[LOOP];this._pingPong=!!timelineDataJson[PING_PONG];this._repeatCount=timelineDataJson[REPEAT_COUNT];this._startOnLayout=timelineDataJson[START_ON_LAYOUT];this._transformWithSceneGraph=!!timelineDataJson[TRANSFORM_WITH_SCENE_GRAPH];this._useSystemTimescale=!!timelineDataJson[USE_SYSTEM_TIMESCALE];this._trackData=new C3.TrackData(timelineDataJson[TRACKS],this)}Release(){this._trackData.Release();
this._trackData=null}GetTrackData(){if(!this._trackData)this._trackData=new C3.TrackData(null,this);return this._trackData}GetName(){return this._name}SetName(n){this._name=n}GetTotalTime(){return this._totalTime}SetTotalTime(tt){this._totalTime=tt}GetStep(){return this._step}SetStep(s){this._step=s}GetInterpolationMode(){return this._interpolationMode}SetInterpolationMode(im){this._interpolationMode=im}GetResultMode(){return this._resultMode}SetResultMode(rm){this._resultMode=rm}GetLoop(){return this._loop}SetLoop(l){this._loop=
l}GetPingPong(){return this._pingPong}SetPingPong(p){this._pingPong=p}GetRepeatCount(){return this._repeatCount}SetRepeatCount(rc){this._repeatCount=rc}GetStartOnLayout(){return this._startOnLayout}GetTransformWithSceneGraph(){return this._transformWithSceneGraph}GetUseSystemTimescale(){return this._useSystemTimescale}_SaveToJson(){return{"trackDataJson":this._trackData._SaveToJson(),"name":this._name,"totalTime":this._totalTime,"step":this._step,"interpolationMode":this._interpolationMode,"resultMode":this._resultMode,
"loop":this._loop,"pingPong":this._pingPong,"repeatCount":this._repeatCount,"startOnLayout":this._startOnLayout,"transformWithSceneGraph":!!this._transformWithSceneGraph,"useSystemTimescale":this._useSystemTimescale}}_LoadFromJson(o){if(!o)return;this.GetTrackData()._LoadFromJson(o["trackDataJson"]);this._name=o["name"];this._totalTime=o["totalTime"];this._step=o["step"];this._interpolationMode=o["interpolationMode"];this._resultMode=o["resultMode"];this._loop=o["loop"];this._pingPong=o["pingPong"];
this._repeatCount=o["repeatCount"];this._startOnLayout=o["startOnLayout"];this._transformWithSceneGraph=!!o["transformWithSceneGraph"];this._useSystemTimescale=!!o["useSystemTimescale"]}};

}

// timelines/data/trackData.js
{
'use strict';const C3=self.C3;const WI_DATA=0;const OC_INDEX=1;const WI_UID=2;const INTERPOLATION_MODE=1;const RESULT_MODE=2;const ENABLED=3;const KEYFRAMES=4;const PROPERTY_TRACKS=5;const ID=6;const NESTED_DATA=7;const START_OFFSET=0;const LOCAL_TOTAL_TIME=1;const WI_ADDITIONAL_DATA=8;const ORIGINAL_WIDTH=0;const ORIGINAL_HEIGHT=1;const TRACK_TYPE=9;const TRACK_NAME=10;
class TrackDataItem{constructor(trackDataJson,trackData){this._trackData=trackData;this._instanceData=null;this._additionalInstanceData=null;this._instanceUid=NaN;this._objectClassIndex=NaN;this._interpolationMode="default";this._resultMode="default";this._enabled=false;this._keyframeData=null;this._propertyTrackData=null;this._id="";this._nestedData=null;this._startOffset=0;this._localTotalTime=this._trackData.GetTimelineDataItem().GetTotalTime();this._type=0;this._name="";if(!trackDataJson)return;
if(trackDataJson[WI_DATA]){this._instanceData=trackDataJson[WI_DATA];this._instanceUid=trackDataJson[WI_DATA][WI_UID];this._objectClassIndex=trackDataJson[WI_DATA][OC_INDEX]}this._interpolationMode=trackDataJson[INTERPOLATION_MODE];this._resultMode=trackDataJson[RESULT_MODE];this._enabled=!!trackDataJson[ENABLED];if(trackDataJson[ID])this._id=trackDataJson[ID];if(trackDataJson[NESTED_DATA]){this._nestedData=trackDataJson[NESTED_DATA];this._startOffset=trackDataJson[NESTED_DATA][START_OFFSET];this._localTotalTime=
trackDataJson[NESTED_DATA][LOCAL_TOTAL_TIME]}if(trackDataJson[WI_ADDITIONAL_DATA])this._additionalInstanceData=trackDataJson[WI_ADDITIONAL_DATA];if(trackDataJson[WI_ADDITIONAL_DATA])this._additionalInstanceData=trackDataJson[WI_ADDITIONAL_DATA];if(trackDataJson[TRACK_TYPE])this._type=trackDataJson[TRACK_TYPE];if(trackDataJson[TRACK_NAME])this._name=trackDataJson[TRACK_NAME];this._keyframeData=new C3.KeyframeData(trackDataJson[KEYFRAMES],this);this._propertyTrackData=new C3.PropertyTrackData(trackDataJson[PROPERTY_TRACKS],
this)}Release(){this._instanceData=null;this._trackData=null;if(this._keyframeData){this._keyframeData.Release();this._keyframeData=null}if(this._propertyTrackData){this._propertyTrackData.Release();this._propertyTrackData=null}this._nestedData=null}GetTrackData(){return this._trackData}GetKeyframeData(){if(!this._keyframeData)this._keyframeData=new C3.KeyframeData(null,this);return this._keyframeData}GetPropertyTrackData(){if(!this._propertyTrackData)this._propertyTrackData=new C3.PropertyTrackData(null,
this);return this._propertyTrackData}GetInstanceData(){return this._instanceData}GetObjectClassIndex(){return this._objectClassIndex}SetObjectClassIndex(index){this._objectClassIndex=index}GetInstanceUID(){return this._instanceUid}SetInstanceUID(uid){this._instanceUid=uid}GetInterpolationMode(){return this._interpolationMode}SetInterpolationMode(im){this._interpolationMode=im}GetResultMode(){return this._resultMode}SetResultMode(rm){this._resultMode=rm}GetEnable(){return this._enabled}SetEnable(e){this._enabled=
!!e}GetId(){return this._id}GetStartOffset(){return this._startOffset}GetLocalTotalTime(){return this._localTotalTime}SetLocalTotalTime(t){this._localTotalTime=t}GetOriginalWidth(){return this._additionalInstanceData[ORIGINAL_WIDTH]}SetOriginalWidth(w){if(!this._additionalInstanceData)this._additionalInstanceData=[];this._additionalInstanceData[ORIGINAL_WIDTH]=w}GetOriginalHeight(){if(!this._additionalInstanceData)this._additionalInstanceData=[];return this._additionalInstanceData[ORIGINAL_HEIGHT]}SetOriginalHeight(h){if(!this._additionalInstanceData)this._additionalInstanceData=
[];this._additionalInstanceData[ORIGINAL_HEIGHT]=h}GetType(){return this._type}GetName(){return this._name}_SaveToJson(){return{"keyframeDataJson":this._keyframeData._SaveToJson(),"propertyTrackDataJson":this._propertyTrackData._SaveToJson(),"instanceData":this._instanceData,"additionalInstanceData":this._additionalInstanceData,"instanceUid":this._instanceUid,"objectClassIndex":this._objectClassIndex,"interpolationMode":this._interpolationMode,"resultMode":this._resultMode,"enabled":this._enabled,
"id":this._id,"nestedData":this._nestedData,"type":this._type,"name":this._name}}_LoadFromJson(o){if(!o)return;this._instanceData=o["instanceData"];this._instanceUid=o["instanceUid"];this._objectClassIndex=o["objectClassIndex"];this._interpolationMode=o["interpolationMode"];this._resultMode=o["resultMode"];this._enabled=o["enabled"];this._id=o["id"];this._type=o["type"]?o["type"]:0;this._name=o["name"]?o["name"]:"";this._localTotalTime=this._trackData.GetTimelineDataItem().GetTotalTime();if(o["nestedData"]){this._nestedData=
o["nestedData"];this._startOffset=this._nestedData[START_OFFSET];this._localTotalTime=this._nestedData[LOCAL_TOTAL_TIME]}if(o["additionalInstanceData"])this._additionalInstanceData=o["additionalInstanceData"];this.GetKeyframeData()._LoadFromJson(o["keyframeDataJson"]);this.GetPropertyTrackData()._LoadFromJson(o["propertyTrackDataJson"])}}
C3.TrackData=class TrackData{constructor(tracksDataJson,timelineDataItem){this._timelineDataItem=timelineDataItem;this._trackDataItems=[];C3.TimelineDataManager._CreateDataItems(this._trackDataItems,tracksDataJson,TrackDataItem,this)}Release(){this._timelineDataItem=null;for(const trackDataItem of this._trackDataItems)trackDataItem.Release();C3.clearArray(this._trackDataItems);this._trackDataItems=null}GetTimelineDataItem(){return this._timelineDataItem}AddEmptyTrackDataItem(){const trackDataItem=
new TrackDataItem(null,this);this._trackDataItems.push(trackDataItem);return trackDataItem}GetFirstKeyframeDataItem(trackDataItem){return trackDataItem.GetKeyframeData().GetKeyframeDataItemArray()[0]}GetLastKeyframeDataItem(trackDataItem){const keyframeDataItems=trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();return keyframeDataItems.at(-1)}GetKeyFrameDataItemAtTime(time,trackDataItem){const keyframeDataItems=trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();const l=keyframeDataItems.length;
for(let i=0;i<l;i++){const keyframeDataItem=keyframeDataItems[i];if(keyframeDataItem.GetTime()===time)return keyframeDataItem}}GetFirstKeyFrameDataItemHigherThan(time,trackDataItem){const keyframeDataItems=trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();const l=keyframeDataItems.length;for(let i=0;i<l;i++){const keyframeDataItem=keyframeDataItems[i];if(keyframeDataItem.GetTime()>time)return keyframeDataItem}}GetFirstKeyFrameDataItemHigherOrEqualThan(time,trackDataItem){const keyframeDataItems=
trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();const l=keyframeDataItems.length;for(let i=0;i<l;i++){const keyframeDataItem=keyframeDataItems[i];if(keyframeDataItem.GetTime()>=time)return keyframeDataItem}}GetFirstKeyFrameDataItemLowerOrEqualThan(time,trackDataItem){const keyframeDataItems=trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();for(let i=keyframeDataItems.length-1;i>=0;i--){const keyframeDataItem=keyframeDataItems[i];if(keyframeDataItem.GetTime()<=time)return keyframeDataItem}}*trackDataItems(){for(const trackDataItem of this._trackDataItems)yield trackDataItem}_SaveToJson(){return{"trackDataItemsJson":this._trackDataItems.map(trackDataItem=>
trackDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._trackDataItems,o["trackDataItemsJson"],TrackDataItem,this)}};

}

// timelines/data/propertyTrackData.js
{
'use strict';const C3=self.C3;const SOURCE_DATA=0;const SOURCE=0;const PROPERTY=1;const TYPE=2;const MIN=3;const MAX=4;const INTERPOLATION_MODE=5;const RESULT_MODE=6;const ENABLED=7;const PROPERTY_KEYFRAMES=8;const CAN_HAVE_PROPERTY_KEYFRAMES=9;
class PropertyTrackDataItem{constructor(propertyTrackDataJson,propertyTrackData){this._propertyTrackData=propertyTrackData;this._sourceAdapterId="";this._sourceAdapterArguments=null;this._property=null;this._type=null;this._min=NaN;this._max=NaN;this._interpolationMode="default";this._resultMode="default";this._enabled=false;this._propertyKeyframeData=null;this._canHavePropertyKeyframes=true;if(!propertyTrackDataJson)return;this._sourceAdapterId=propertyTrackDataJson[SOURCE_DATA][SOURCE];this._sourceAdapterArguments=
propertyTrackDataJson[SOURCE_DATA].slice(1);this._property=propertyTrackDataJson[PROPERTY];this._type=propertyTrackDataJson[TYPE];this._min=propertyTrackDataJson[MIN];this._max=propertyTrackDataJson[MAX];this._interpolationMode=propertyTrackDataJson[INTERPOLATION_MODE];this._resultMode=propertyTrackDataJson[RESULT_MODE];this._enabled=!!propertyTrackDataJson[ENABLED];this._propertyKeyframeData=new C3.PropertyKeyframeData(propertyTrackDataJson[PROPERTY_KEYFRAMES],this);this._canHavePropertyKeyframes=
propertyTrackDataJson[CAN_HAVE_PROPERTY_KEYFRAMES]}Release(){this._propertyKeyframeData.Release();this._propertyKeyframeData=null;this._propertyTrackData=null;this._sourceAdapterArguments=null}GetPropertyTrackData(){return this._propertyTrackData}GetPropertyKeyframeData(){if(!this._propertyKeyframeData)this._propertyKeyframeData=new C3.PropertyKeyframeData(null,this);return this._propertyKeyframeData}GetSourceAdapterId(){return this._sourceAdapterId}SetSourceAdapterId(said){this._sourceAdapterId=
said}GetSourceAdapterArguments(){return this._sourceAdapterArguments}SetSourceAdapterArguments(sargs){this._sourceAdapterArguments=sargs}GetProperty(){return this._property}SetProperty(p){this._property=p}GetType(){return this._type}SetType(t){this._type=t}GetMin(){return this._min}SetMin(min){this._min=min}GetMax(){return this._max}SetMax(max){this._max=max}GetInterpolationMode(){return this._interpolationMode}SetInterpolationMode(im){this._interpolationMode=im}GetResultMode(){return this._resultMode}SetResultMode(rm){this._resultMode=
rm}GetEnable(){return this._enabled}SetEnable(e){this._enabled=!!e}CanHavePropertyKeyframes(){return!!this._canHavePropertyKeyframes}_SaveToJson(){return{"propertyKeyframeDataJson":this._propertyKeyframeData._SaveToJson(),"sourceAdapterId":this._sourceAdapterId,"sourceAdapterArguments":this._sourceAdapterArguments,"property":this._property,"type":this._type,"min":this._min,"max":this._max,"interpolationMode":this._interpolationMode,"resultMode":this._resultMode,"enabled":this._enabled,"canHavePropertyKeyframes":this._canHavePropertyKeyframes}}_LoadFromJson(o){if(!o)return;
this._sourceAdapterId=o["sourceAdapterId"];this._sourceAdapterArguments=o["sourceAdapterArguments"];this._property=o["property"];this._type=o["type"];this._min=o["min"];this._max=o["max"];this._interpolationMode=o["interpolationMode"];this._resultMode=o["resultMode"];this._enabled=o["enabled"];this._canHavePropertyKeyframes=o["canHavePropertyKeyframes"];this.GetPropertyKeyframeData()._LoadFromJson(o["propertyKeyframeDataJson"])}}
C3.PropertyTrackData=class PropertyTrackData{constructor(propertyTracksDataJson,trackDataItem){this._trackDataItem=trackDataItem;this._propertyTrackDataItems=[];C3.TimelineDataManager._CreateDataItems(this._propertyTrackDataItems,propertyTracksDataJson,PropertyTrackDataItem,this)}Release(){this._trackDataItem=null;for(const propertyTrackDataItem of this._propertyTrackDataItems)propertyTrackDataItem.Release();C3.clearArray(this._propertyTrackDataItems);this._propertyTrackDataItems=null}GetTrackDataItem(){return this._trackDataItem}AddEmptyPropertyTrackDataItem(){const propertyTrackDataItem=
new PropertyTrackDataItem(null,this);this._propertyTrackDataItems.push(propertyTrackDataItem);return propertyTrackDataItem}GetFirstPropertyKeyframeDataItem(propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();return propertyKeyframeData.GetPropertyKeyframeDataItemArray()[0]}GetLastPropertyKeyframeDataItem(propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItems=propertyKeyframeData.GetPropertyKeyframeDataItemArray();
return propertyKeyframeDataItems.at(-1)}GetPropertyKeyFrameDataItemAtTime(time,propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItems=propertyKeyframeData.GetPropertyKeyframeDataItemArray();const l=propertyKeyframeDataItems.length;for(let i=0;i<l;i++){const propertyKeyframeDataItem=propertyKeyframeDataItems[i];if(propertyKeyframeDataItem.GetTime()===time)return propertyKeyframeDataItem}}GetFirstPropertyKeyFrameDataItemHigherThan(time,
propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItems=propertyKeyframeData.GetPropertyKeyframeDataItemArray();const l=propertyKeyframeDataItems.length;for(let i=0;i<l;i++){const propertyKeyframeDataItem=propertyKeyframeDataItems[i];if(propertyKeyframeDataItem.GetTime()>time)return propertyKeyframeDataItem}}GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();
const propertyKeyframeDataItems=propertyKeyframeData.GetPropertyKeyframeDataItemArray();const l=propertyKeyframeDataItems.length;for(let i=0;i<l;i++){const propertyKeyframeDataItem=propertyKeyframeDataItems[i];if(propertyKeyframeDataItem.GetTime()>=time)return propertyKeyframeDataItem}}GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItems=propertyKeyframeData.GetPropertyKeyframeDataItemArray();
for(let i=propertyKeyframeDataItems.length-1;i>=0;i--){const propertyKeyframeDataItem=propertyKeyframeDataItems[i];if(propertyKeyframeDataItem.GetTime()<=time)return propertyKeyframeDataItem}}*propertyTrackDataItems(){for(const propertyTrackDataItem of this._propertyTrackDataItems)yield propertyTrackDataItem}_SaveToJson(){return{"propertyTrackDataItemsJson":this._propertyTrackDataItems.map(propertyTrackDataItem=>propertyTrackDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._propertyTrackDataItems,
o["propertyTrackDataItemsJson"],PropertyTrackDataItem,this)}};

}

// timelines/data/keyframeData.js
{
'use strict';const C3=self.C3;const TIME=0;const EASE=1;const ENABLE=2;const TAGS=3;
class KeyframeDataItem{constructor(keyframeDataJson,keyframeData){this._keyframeData=keyframeData;this._time=-1;this._ease="noease";this._enable=false;this._tags=null;this._lowerTags=null;if(!keyframeDataJson)return;this._time=keyframeDataJson[TIME];this._ease=keyframeDataJson[EASE];this._enable=!!keyframeDataJson[ENABLE];const tagStr=keyframeDataJson[TAGS];this._tags=tagStr?tagStr.split(" "):[];this._lowerTags=new Set(this._tags.map(t=>t.toLowerCase()));this._next=null}Release(){this._keyframeData=
null;C3.clearArray(this._tags);this._tags=null;this._lowerTags.clear();this._lowerTags=null;this._next=null}GetKeyframeData(){return this._keyframeData}GetNext(){return this._next}SetNext(next){this._next=next}GetTime(){return this._time}SetTime(t){this._time=t;this._keyframeData._LinkKeyframeDataItems()}GetEase(){return this._ease}SetEase(e){this._ease=e}GetEnable(){return this._enable}SetEnable(e){this._enable=!!e}GetTags(){return this._tags}SetTags(t){this._tags=t?t.split(" "):[];this._lowerTags=
new Set(this._tags.map(t=>t.toLowerCase()))}GetLowerTags(){return this._lowerTags}HasTag(tag){return this._lowerTags.has(tag.toLowerCase())}_SaveToJson(){return{"time":this._time,"ease":this._ease,"enable":this._enable,"tags":this._tags}}_LoadFromJson(o){if(!o)return;this._time=o["time"];this._ease=o["ease"];this._enable=o["enable"];this._tags=o["tags"];this._lowerTags=new Set(this._tags.map(t=>t.toLowerCase()))}}
C3.KeyframeData=class KeyframeData{constructor(keyframesDataJson,trackDataItem){this._trackDataItem=trackDataItem;this._keyframeDataItems=[];C3.TimelineDataManager._CreateDataItems(this._keyframeDataItems,keyframesDataJson,KeyframeDataItem,this);this._LinkKeyframeDataItems()}Release(){this._trackDataItem=null;for(const keyframeDataItem of this._keyframeDataItems)keyframeDataItem.Release();C3.clearArray(this._keyframeDataItems);this._keyframeDataItems=null}_LinkKeyframeDataItems(){this._keyframeDataItems.sort((first,
second)=>first.GetTime()-second.GetTime());for(let i=0;i<this._keyframeDataItems.length;i++){const current=this._keyframeDataItems[i];current.SetNext(this._keyframeDataItems[i+1])}}GetTrackDataItem(){return this._trackDataItem}GetKeyframeDataItemCount(){return this._keyframeDataItems.length}GetKeyframeDataItemArray(){return this._keyframeDataItems}AddEmptyKeyframeDataItem(){const keyframeDataItem=new KeyframeDataItem(null,this);this._keyframeDataItems.push(keyframeDataItem);this._LinkKeyframeDataItems();
return keyframeDataItem}DeleteKeyframeDataItems(match){for(const keyframeDataItem of this._keyframeDataItems){if(!match(keyframeDataItem))continue;const index=this._keyframeDataItems.indexOf(keyframeDataItem);if(index===-1)continue;keyframeDataItem.Release();this._keyframeDataItems.splice(index,1)}this.SortKeyframeDataItems();this._LinkKeyframeDataItems()}SortKeyframeDataItems(){this._keyframeDataItems.sort((a,b)=>a.GetTime()-b.GetTime())}GetKeyframeDataItemIndex(keyframeDataItem){return this._keyframeDataItems.indexOf(keyframeDataItem)}GetKeyframeDataItemFromIndex(index){return this._keyframeDataItems[index]}*keyframeDataItems(){for(const keyframeDataItem of this._keyframeDataItems)yield keyframeDataItem}*keyframeDataItemsReverse(){for(let i=
this._keyframeDataItems.length-1;i>=0;i--)yield this._keyframeDataItems[i]}_SaveToJson(){return{"keyframeDataItemsJson":this._keyframeDataItems.map(keyframeDataItem=>keyframeDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._keyframeDataItems,o["keyframeDataItemsJson"],KeyframeDataItem,this);this._LinkKeyframeDataItems()}};

}

// timelines/data/propertyKeyframeData.js
{
'use strict';const C3=self.C3;const VALUE_DATA=0;const VALUE_DATA_VALUE=0;const VALUE_DATA_ABSOLUTE_VALUE=1;const VALUE_DATA_TYPE=2;const TIME=1;const EASE=2;const ENABLE=3;const ADDONS=4;const PATH_MODE=5;
class PropertyKeyframeDataItem{constructor(propertyKeyframeDataJson,propertyKeyframeData){this._propertyKeyframeData=propertyKeyframeData;this._value=null;this._aValue=null;this._type="";this._time=NaN;this._ease="noease";this._enable=false;this._addonData=null;this._addonInstance=undefined;this._pathMode="line";if(!propertyKeyframeDataJson)return;this._value=propertyKeyframeDataJson[VALUE_DATA][VALUE_DATA_VALUE];this._aValue=propertyKeyframeDataJson[VALUE_DATA][VALUE_DATA_ABSOLUTE_VALUE];this._type=
propertyKeyframeDataJson[VALUE_DATA][VALUE_DATA_TYPE];this._time=propertyKeyframeDataJson[TIME];this._ease=propertyKeyframeDataJson[EASE];this._enable=!!propertyKeyframeDataJson[ENABLE];this._pathMode=propertyKeyframeDataJson[PATH_MODE];this._addonData=null;if(!!propertyKeyframeDataJson[ADDONS])this._addonData=new C3.AddonData(propertyKeyframeDataJson[ADDONS],this);this._next=null;this._prev=null}Release(){this._propertyKeyframeData=null;if(this._addonData){this._addonData.Release();this._addonData=
null}this._next=null;this._prev=null}GetAddonData(){return this._addonData}SetNext(next){this._next=next}GetNext(){return this._next}SetPrevious(prev){this._prev=prev}GetPrevious(){return this._prev}GetValue(){return this._value}SetValue(value){if(this._type==="color"&&C3.IsFiniteNumber(value)){this._value[0]=C3.GetRValue(value);this._value[1]=C3.GetGValue(value);this._value[2]=C3.GetBValue(value)}else this._value=value}GetAbsoluteValue(){return this._aValue}SetAbsoluteValue(aValue){if(this._type===
"color"&&C3.IsFiniteNumber(aValue)){this._aValue[0]=C3.GetRValue(aValue);this._aValue[1]=C3.GetGValue(aValue);this._aValue[2]=C3.GetBValue(aValue)}else this._aValue=aValue}GetValueWithResultMode(){const rm=this._propertyKeyframeData.GetPropertyTrackDataItem().GetResultMode();if(rm==="relative")return this.GetValue();else if(rm==="absolute")return this.GetAbsoluteValue()}GetType(){return this._type}SetType(t){this._type=t}GetTime(){return this._time}SetTime(t){this._time=t;this._propertyKeyframeData._LinkPropertyKeyframeDataItems()}GetEase(){return this._ease}SetEase(e){this._ease=
e}GetEnable(){return this._enable}SetEnable(e){this._enable=!!e}GetPathMode(){return this._pathMode}GetAddOn(id){if(!this._addonData)return;if(this._addonInstance||this._addonInstance===null)return this._addonInstance;const addonArray=this._addonData.GetAddDataItemArray();if(!addonArray){this._addonInstance=null;return this._addonInstance}const len=addonArray.length;for(let i=0;i<len;i++){const addon=addonArray[i];if(addon.GetId()===id){this._addonInstance=addon;return this._addonInstance}}this._addonInstance=
null;return this._addonInstance}_SaveToJson(){const aData=this._addonData;return{"addonDataJson":aData?aData._SaveToJson():aData,"value":this._value,"aValue":this._aValue,"type":this._type,"time":this._time,"ease":this._ease,"enable":this._enable}}_LoadFromJson(o){if(!o)return;if(o["addonDataJson"])this._addonData._SetFromJson(o["addonDataJson"]);this._value=o["value"];this._aValue=o["aValue"];this._type=o["type"];this._time=o["time"];this._ease=o["ease"];this._enable=o["enable"]}}
C3.PropertyKeyframeData=class PropertyKeyframeData{constructor(propertyKeyframesDataJson,propertyTrackDataItem){this._propertyTrackDataItem=propertyTrackDataItem;this._propertyKeyframeDataItems=[];this._propertyKeyframeDataItemsIncludingDisabled=[];C3.TimelineDataManager._CreateDataItems(this._propertyKeyframeDataItems,propertyKeyframesDataJson,PropertyKeyframeDataItem,this);C3.TimelineDataManager._CreateDataItemsIncludingDisabled(this._propertyKeyframeDataItemsIncludingDisabled,propertyKeyframesDataJson,
PropertyKeyframeDataItem,this);this._LinkPropertyKeyframeDataItems()}Release(){this._propertyTrackDataItem=null;for(const propertyKeyframeDataItem of this._propertyKeyframeDataItems)propertyKeyframeDataItem.Release();C3.clearArray(this._propertyKeyframeDataItems);this._propertyKeyframeDataItems=null;for(const propertyKeyframeDataItem of this._propertyKeyframeDataItemsIncludingDisabled)propertyKeyframeDataItem.Release();C3.clearArray(this._propertyKeyframeDataItemsIncludingDisabled);this._propertyKeyframeDataItemsIncludingDisabled=
null}_LinkPropertyKeyframeDataItems(){let dataItems=this._propertyKeyframeDataItems;dataItems.sort((first,second)=>first.GetTime()-second.GetTime());for(let i=0;i<dataItems.length;i++){const current=dataItems[i];if(i+1<dataItems.length)current.SetNext(dataItems[i+1]);if(i-1>=0)current.SetPrevious(dataItems[i-1])}dataItems=this._propertyKeyframeDataItemsIncludingDisabled;dataItems.sort((first,second)=>first.GetTime()-second.GetTime());for(let i=0;i<dataItems.length;i++){const current=dataItems[i];
if(i+1<dataItems.length)current.SetNext(dataItems[i+1]);if(i-1>=0)current.SetPrevious(dataItems[i-1])}}AddEmptyPropertyKeyframeDataItem(){const propertyKeyframeDataItem=new PropertyKeyframeDataItem(null,this);this._propertyKeyframeDataItems.push(propertyKeyframeDataItem);this._LinkPropertyKeyframeDataItems();return propertyKeyframeDataItem}DeletePropertyKeyframeDataItems(match){for(const propertyKeyframeDataItem of this._propertyKeyframeDataItems){if(!match(propertyKeyframeDataItem))continue;const index=
this._propertyKeyframeDataItems.indexOf(propertyKeyframeDataItem);if(index===-1)continue;propertyKeyframeDataItem.Release();this._propertyKeyframeDataItems.splice(index,1)}this.SortPropertyKeyFrameDataItems();this._LinkPropertyKeyframeDataItems()}SortPropertyKeyFrameDataItems(){this._propertyKeyframeDataItems.sort((a,b)=>a.GetTime()-b.GetTime())}GetPropertyTrackDataItem(){return this._propertyTrackDataItem}GetPropertyKeyframeDataItemCount(){return this._propertyKeyframeDataItems.length}GetLastPropertyKeyframeDataItem(){return this._propertyKeyframeDataItems[this._propertyKeyframeDataItems.length-
1]}GetPropertyKeyframeDataItemArray(){return this._propertyKeyframeDataItems}GetPropertyKeyframeDataItemArrayIncludingDisabled(){return this._propertyKeyframeDataItemsIncludingDisabled}*propertyKeyframeDataItems(){for(const propertyKeyframeDataItem of this._propertyKeyframeDataItems)yield propertyKeyframeDataItem}*propertyKeyframeDataItemsReverse(){for(let i=this._propertyKeyframeDataItems.length-1;i>=0;i--)yield this._propertyKeyframeDataItems[i]}_SaveToJson(){const propertyKeyframeDataItems=this._propertyKeyframeDataItems;
const propertyKeyframeDataItemsIncludingDisabled=this._propertyKeyframeDataItemsIncludingDisabled;return{"propertyKeyframeDataItemsJson":propertyKeyframeDataItems.map(propertyTrackDataItem=>{return propertyTrackDataItem._SaveToJson()}),"propertyKeyframeDataItemsIncludingDisabledJson":propertyKeyframeDataItemsIncludingDisabled.map(propertyTrackDataItem=>{return propertyTrackDataItem._SaveToJson()})}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._propertyKeyframeDataItems,
o["propertyKeyframeDataItemsJson"],PropertyKeyframeDataItem,this);C3.TimelineDataManager._LoadDataItemsFromJson(this._propertyKeyframeDataItemsIncludingDisabled,o["propertyKeyframeDataItemsIncludingDisabledJson"],PropertyKeyframeDataItem,this);this._LinkPropertyKeyframeDataItems()}};

}

// timelines/data/propertyKeyframeAddonData.js
{
'use strict';const C3=self.C3;const ADDON_ID=0;const ADDON_DATA=1;class AddonDataItem{constructor(addonDataJson,addonData){this._addonData=addonData;this._id=addonDataJson[ADDON_ID];this._data=addonDataJson[ADDON_DATA]}Release(){this._addonData=null;this._data=null}GetAddonData(){return this._addonData}GetId(){return this._id}_SaveToJson(){return{"id":this._id,"data":this._data}}_LoadFromJson(o){if(!o)return;this._id=o["id"];this._data=o["data"]}}const START_ANCHOR=0;const START_ENABLE=1;
const END_ANCHOR=2;const END_ENABLE=3;
class AddonDataCubicBezierItem extends AddonDataItem{constructor(addonDataJson,addonData){super(addonDataJson,addonData);this._startAnchor=this._data[START_ANCHOR];this._startEnable=!!this._data[START_ENABLE];this._endAnchor=this._data[END_ANCHOR];this._endEnable=!!this._data[END_ENABLE]}Release(){super.Release()}GetStartAnchor(){return this._startAnchor}GetStartEnable(){return this._startEnable}GetEndAnchor(){return this._endAnchor}GetEndEnable(){return this._endEnable}_SaveToJson(){return Object.assign(super._SaveToJson(),{"startAnchor":this._startAnchor,
"startEnable":!!this._startEnable,"endAnchor":this._endAnchor,"endEnable":!!this._endEnable})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._startAnchor=o["startAnchor"];this._startEnable=!!o["startEnable"];this._endAnchor=o["endAnchor"];this._endEnable=!!o["endEnable"]}}const DIRECTION=0;const REVOLUTIONS=1;
class AddonDataAngleItem extends AddonDataItem{constructor(addonDataJson,addonData){super(addonDataJson,addonData);this._direction=this._data[DIRECTION];this._revolutions=this._data[REVOLUTIONS]}Release(){super.Release()}GetDirection(){return this._direction}GetRevolutions(){return this._revolutions}_SaveToJson(){return Object.assign(super._SaveToJson(),{"direction":this._direction,"revolutions":this._revolutions})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._direction=o["direction"];
this._revolutions=o["revolutions"]}}
C3.AddonData=class AddonData{constructor(addonsDataJson,propertyKeyframeDataItem){this._propertyKeyframeDataItem=propertyKeyframeDataItem;this._addonDataItems=[];C3.TimelineDataManager._CreateDataItems(this._addonDataItems,addonsDataJson,{prop:0,map:new Map([["cubic-bezier",AddonDataCubicBezierItem],["angle",AddonDataAngleItem]])},this)}Release(){this._propertyKeyframeDataItem=null;for(const addonDataItem of this._addonDataItems)addonDataItem.Release();C3.clearArray(this._addonDataItems);this._addonDataItems=
null}GetPropertyKeyframeDataItem(){return this._propertyKeyframeDataItem}GetAddDataItemArray(){return this._addonDataItems}*addonDataItems(){for(const addonDataItem of this._addonDataItems)yield addonDataItem}_SaveToJson(){return{"addonDataItemsJson":this._addonDataItems.map(addonDataItem=>addonDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._addonDataItems,o["addonDataItemsJson"],{prop:"id",map:new Map([["cubic-bezier",AddonDataCubicBezierItem],
["angle",AddonDataAngleItem]])},this)}};

}

// timelines/tweens/tweenState.js
{
'use strict';const C3=self.C3;const INITIAL_VALUE_MODE_START_VALUE="start-value";const INITIAL_VALUE_MODE_CURRENT_STATE="current-state";const PING_PONG_BEGIN=0;const PING_PONG_END=1;let createdTweens=0;
C3.TweenState=class Tween extends C3.TimelineState{constructor(tweenDataItem,timelineManager){super(`tween-${createdTweens++}`,tweenDataItem,timelineManager);this._id="";this._destroyInstanceOnComplete=false;this._initialValueMode=INITIAL_VALUE_MODE_START_VALUE;this._instance=null;this._on_completed_callbacks=null;this._on_started_callbacks=null;this._track=null;this._iTweenState=null}FireReleaseEvent(dispatcher){const event=C3.New(C3.Event,"tweenstatereleased");event.tweenState=this;dispatcher.dispatchEvent(event)}GetType(){return 1}CreateTrackStates(){for(const trackDataItem of this._timelineDataItem.GetTrackData().trackDataItems())this._tracks.push(C3.TweenTrackState.Create(this,
trackDataItem));this._track=this._tracks[0]}AddTrack(){const trackDataItem=this._timelineDataItem.GetTrackData().AddEmptyTrackDataItem();const track=C3.TweenTrackState.Create(this,trackDataItem);this._tracks.push(track);this._track=this._tracks[0];return track}GetPropertyTrack(propertyName){return this._track.GetPropertyTracks()[0]}SetPropertyType(type){this._propertyType=type}GetInstance(){const tracks=this.GetTracks();if(!tracks||!tracks.length)return;const track=tracks[0];this._track=track;if(!track)return;
const instance=track.GetInstance();return track.IsInstanceValid()?instance:undefined}AddStartedCallback(c){if(!this._on_started_callbacks)this._on_started_callbacks=[];this._on_started_callbacks.push(c)}AddCompletedCallback(c){if(!this._on_completed_callbacks)this._on_completed_callbacks=[];this._on_completed_callbacks.push(c)}RemoveStartedCallback(c){if(!this._on_started_callbacks)return;const index=this._on_started_callbacks.indexOf(c);if(index!==-1)this._on_started_callbacks.splice(index,1)}RemoveCompletedCallback(c){if(!this._on_completed_callbacks)return;
const index=this._on_completed_callbacks.indexOf(c);if(index!==-1)this._on_completed_callbacks.splice(index,1)}SetStartValue(startValue,propertyName){for(const track of this._tracks)for(const propertyTrack of track._propertyTracks){if(propertyTrack.GetPropertyName()!==propertyName)continue;const propertyTrackData=propertyTrack.GetPropertyTrackData();const propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyKeyframeDataItem=propertyTrackData.GetFirstPropertyKeyframeDataItem(propertyTrackDataItem);
propertyKeyframeDataItem.SetValue(startValue);propertyKeyframeDataItem.SetAbsoluteValue(startValue)}}_GetPropertyTrackState(propertyName){for(const track of this._tracks)for(const propertyTrack of track._propertyTracks)if(propertyTrack.GetPropertyName()===propertyName)return propertyTrack}BeforeSetEndValues(properties){for(const propertyName of properties){const propertyTrackState=this._GetPropertyTrackState(propertyName);this.SetStartValue(propertyTrackState.GetCurrentState(),propertyName)}if(this.IsForwardPlayBack()){const newTotalTime=
this.GetTotalTime()-this.GetTime();this.SetTotalTime(newTotalTime);for(const track of this._tracks)track.SetLocalTotalTime(newTotalTime);this._SetTime(0)}else{const newTotalTime=this.GetTime();this.SetTotalTime(newTotalTime);for(const track of this._tracks)track.SetLocalTotalTime(newTotalTime);this._SetTime(newTotalTime)}this.SetInitialStateFromSetTime()}SetEndValue(endValue,propertyName){const propertyTrackState=this._GetPropertyTrackState(propertyName);const propertyTrackData=propertyTrackState.GetPropertyTrackData();
const propertyTrackDataItem=propertyTrackState.GetPropertyTrackDataItem();const propertyKeyframeDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);propertyKeyframeDataItem.SetTime(this.GetTotalTime());propertyKeyframeDataItem.SetValue(endValue);propertyKeyframeDataItem.SetAbsoluteValue(endValue)}SetId(id){this._id=id}GetId(){return this._id}SetInitialValueMode(initialValueMode){this._initialValueMode=initialValueMode}GetInitialValueMode(){return this._initialValueMode}SetDestroyInstanceOnComplete(releaseOnComplete){this._destroyInstanceOnComplete=
releaseOnComplete}GetDestroyInstanceOnComplete(){return this._destroyInstanceOnComplete}OnStarted(){if(this._on_started_callbacks)for(const c of this._on_started_callbacks)c(this);if(this.IsComplete())return;for(const track of this._tracks)track.CompareSaveStateWithCurrent()}OnCompleted(){this._completedTick=this._runtime.GetTickCount()}FinishTriggers(){if(this._finishedTriggers)return;this._finishedTriggers=true;if(this._on_completed_callbacks)for(const c of this._on_completed_callbacks)c(this)}SetTime(time){this._DeleteIntermediateKeyframes();
super.SetTime(time)}_SetTimeAndReset(time){if(!C3.IsFiniteNumber(time))time=this.GetTotalTime();if(time<0)this._playheadTime=0;else if(time>=this.GetTotalTime())this._playheadTime=this.GetTotalTime();else this._playheadTime=time;this._track.SetResetState()}SetInitialState(fromSetTime){if(!this.InitialStateSet()&&this.GetInitialValueMode()===INITIAL_VALUE_MODE_CURRENT_STATE)for(const track of this._tracks)track.CompareInitialStateWithCurrent();super.SetInitialState(fromSetTime)}Stop(completed=false){super.Stop(completed);
if(this.IsComplete())return;for(const track of this._tracks)track.SaveState()}Reset(render=true,beforeChangeLayout=false){this._DeleteIntermediateKeyframes();super.Reset(render,beforeChangeLayout)}_DeleteIntermediateKeyframes(){for(const track of this._tracks){const del=kf=>{const time=kf.GetTime();const totalTime=this.GetTotalTime();return time!==0&&time!==totalTime};track.DeleteKeyframes(del);track.DeletePropertyKeyframes(del)}}_OnBeforeChangeLayout(){if(this.IsReleased())return true;const instance=
this.GetInstance();if(instance&&instance.GetObjectClass().IsGlobal())return false;this._timelineManager.CompleteTimelineBeforeChangeOfLayout(this);this.ResetBeforeChangeLayout();return true}Tick(deltaTime,timeScale,deltaTime1){if(!this._instance)this._instance=this.GetInstance();if(!this._instance||this._instance.IsDestroyed()){this.Stop(true);this.OnCompleted();return}const instanceTimeScale=this._instance.GetTimeScale();if(instanceTimeScale!==-1)deltaTime=deltaTime1*instanceTimeScale;if(deltaTime===
0&&this._lastDelta===0)return;this._lastDelta=deltaTime;const lastTime=this._playheadTime;const newDeltaTime=deltaTime*this._playbackRate;const newTime=lastTime+newDeltaTime;const totalTime=this._timelineDataItem._totalTime;if(newTime<0)this._playheadTime=0;else if(newTime>=totalTime)this._playheadTime=totalTime;else this._playheadTime=newTime;let complete=false;let ensureValue=false;const loop=this.GetLoop();const pingPong=this.GetPingPong();if(!loop&&!pingPong)if(this._playbackRate>0){if(this._playheadTime>=
totalTime)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._SetTimeAndReset(0);ensureValue=true}else{this._SetTime(totalTime);complete=true}}else{if(this._playheadTime<=0)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._SetTimeAndReset(totalTime);ensureValue=true}else{this._SetTime(0);complete=true}}else if(loop&&!pingPong)if(this._playbackRate>0){if(this._playheadTime>=totalTime){this._SetTimeAndReset(0);ensureValue=true}}else{if(this._playheadTime<=
0){this._SetTimeAndReset(totalTime);ensureValue=true}}else if(!loop&&pingPong)if(this._playbackRate>0){if(this._playheadTime>=totalTime){this._SetTime(totalTime);this.SetPlaybackRate(this.GetPlaybackRate()*-1);ensureValue=true;if(this._pingPongState===PING_PONG_END)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._pingPongState=PING_PONG_BEGIN}else complete=true;else if(this._pingPongState===PING_PONG_BEGIN)this._pingPongState=PING_PONG_END}}else{if(this._playheadTime<=
0){this._SetTime(0);this.SetPlaybackRate(this.GetPlaybackRate()*-1);ensureValue=true;if(this._pingPongState===PING_PONG_END)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._pingPongState=PING_PONG_BEGIN}else complete=true;else if(this._pingPongState===PING_PONG_BEGIN)this._pingPongState=PING_PONG_END}}else if(loop&&pingPong)if(this._playbackRate>0){if(this._playheadTime>=totalTime){this._SetTime(totalTime);this.SetPlaybackRate(this.GetPlaybackRate()*-1);ensureValue=
true;this._pingPongState++;C3.wrap(this._pingPongState,0,2)}}else if(this._playheadTime<=0){this._SetTime(0);this.SetPlaybackRate(this.GetPlaybackRate()*-1);ensureValue=true;this._pingPongState++;C3.wrap(this._pingPongState,0,2)}if(complete){this._track.SetEndState();this.Stop(true);this.OnCompleted();return}this._track.Interpolate(this._playheadTime,true,false,ensureValue,this._firstTick,false);if(this._firstTick)this._firstTick=false}_SaveToJson(){const ret=super._SaveToJson();const tweenDataItem=
this.GetTimelineDataItem();return Object.assign(ret,{"tweenDataItemJson":tweenDataItem._SaveToJson(),"id":this._id,"destroyInstanceOnComplete":this._destroyInstanceOnComplete,"initialValueMode":this._initialValueMode})}_LoadFromJson(o){if(!o)return;const tweenDataItem=this.GetTimelineDataItem();tweenDataItem._LoadFromJson(o["tweenDataItemJson"]);super._LoadFromJson(o);this._id=o["id"];this._destroyInstanceOnComplete=o["destroyInstanceOnComplete"];this._initialValueMode=o["initialValueMode"]}static IsPlaying(tween){return tween.IsPlaying()}static IsPaused(tween){return tween.IsPaused()}static Build(config){const timelineManager=
config.runtime.GetTimelineManager();const tweenDataItem=new C3.TimelineDataItem;if(config.json){tweenDataItem._LoadFromJson(config.json["tweenDataItemJson"]);const tween=new C3.TweenState(tweenDataItem,timelineManager);tween._LoadFromJson(config.json);return tween}else{const tween=new C3.TweenState(tweenDataItem,timelineManager);if(!C3.IsArray(config.propertyTracksConfig))config.propertyTracksConfig=[config.propertyTracksConfig];tween.SetId(config.id);tween.SetTags(config.tags);tween.SetInitialValueMode(config.initialValueMode);
tween.SetDestroyInstanceOnComplete(config.releaseOnComplete);tween.SetLoop(config.loop);tween.SetPingPong(config.pingPong);tween.SetTotalTime(config.time);tween.SetStep(0);tween.SetInterpolationMode("default");tween.SetResultMode(config.propertyTracksConfig[0].resultMode);tween.SetRepeatCount(config.repeatCount);const track=tween.AddTrack();track.SetInstanceUID(config.instance.GetUID());track.SetInterpolationMode("default");track.SetResultMode(config.propertyTracksConfig[0].resultMode);track.SetEnable(true);
track.SetObjectClassIndex(config.instance.GetObjectClass().GetIndex());const sdkIntance=config.instance.GetSdkInstance();const w=sdkIntance.IsOriginalSizeKnown()?sdkIntance.GetOriginalWidth():config.instance.GetWorldInfo().GetWidth();const h=sdkIntance.IsOriginalSizeKnown()?sdkIntance.GetOriginalHeight():config.instance.GetWorldInfo().GetHeight();track.SetOriginalWidth(w);track.SetOriginalHeight(h);const startKeyframeDataItem=track.AddKeyframe();startKeyframeDataItem.SetTime(0);startKeyframeDataItem.SetEase("noease");
startKeyframeDataItem.SetEnable(true);startKeyframeDataItem.SetTags("");const endKeyframeDataItem=track.AddKeyframe();endKeyframeDataItem.SetTime(config.time);endKeyframeDataItem.SetEase("noease");endKeyframeDataItem.SetEnable(true);endKeyframeDataItem.SetTags("");for(const propertyTrackConfig of config.propertyTracksConfig){const propertyTrack=track.AddPropertyTrack();propertyTrack.SetSourceAdapterId(propertyTrackConfig.sourceId);propertyTrack.SetSourceAdapterArgs(propertyTrackConfig.sourceArgs);
propertyTrack.SetPropertyName(propertyTrackConfig.property);propertyTrack.SetPropertyType(propertyTrackConfig.type);propertyTrack.SetMin(NaN);propertyTrack.SetMax(NaN);propertyTrack.SetInterpolationMode("default");propertyTrack.SetResultMode(propertyTrackConfig.resultMode);propertyTrack.SetEnable(true);const startPropertyKeyframeDataItem=propertyTrack.AddPropertyKeyframe();startPropertyKeyframeDataItem.SetType(propertyTrackConfig.valueType);startPropertyKeyframeDataItem.SetTime(0);startPropertyKeyframeDataItem.SetEase(propertyTrackConfig.ease);
startPropertyKeyframeDataItem.SetEnable(true);startPropertyKeyframeDataItem.SetValue(propertyTrackConfig.startValue);startPropertyKeyframeDataItem.SetAbsoluteValue(propertyTrackConfig.startValue);const endPropertyKeyframeDataItem=propertyTrack.AddPropertyKeyframe();endPropertyKeyframeDataItem.SetType(propertyTrackConfig.valueType);endPropertyKeyframeDataItem.SetTime(config.time);endPropertyKeyframeDataItem.SetEase(propertyTrackConfig.ease);endPropertyKeyframeDataItem.SetEnable(true);endPropertyKeyframeDataItem.SetValue(propertyTrackConfig.endValue);
endPropertyKeyframeDataItem.SetAbsoluteValue(propertyTrackConfig.endValue);propertyTrack.GetSourceAdapter()}return tween}}GetITweenState(behInst,opts){if(!this._iTweenState)this._iTweenState=C3.New(self.ITweenState,this,behInst,opts);return this._iTweenState}};

}

// timelines/tweens/tweenTrackState.js
{
'use strict';const C3=self.C3;
C3.TweenTrackState=class TweenTrack extends C3.TrackState{constructor(timeline,trackDataItem){super(timeline,trackDataItem);this._firstPropertyTrack=null;this._secondPropertyTrack=null}static Create(timeline,trackDataItem){return C3.New(C3.TweenTrackState,timeline,trackDataItem)}_CachePropertyTracks(){if(this._propertyTracks.length===1)this._firstPropertyTrack=this._propertyTracks[0];else{this._firstPropertyTrack=this._propertyTracks[0];this._secondPropertyTrack=this._propertyTracks[1]}}CreatePropertyTrackStates(){for(const propertyTrackDataItem of this._trackDataItem.GetPropertyTrackData().propertyTrackDataItems())this._propertyTracks.push(C3.TweenPropertyTrackState.Create(this,propertyTrackDataItem));
this._CachePropertyTracks()}AddPropertyTrack(){const propertyTrackData=this._trackDataItem.GetPropertyTrackData();const propertyTrackDataItem=propertyTrackData.AddEmptyPropertyTrackDataItem();const propertyTrack=C3.TweenPropertyTrackState.Create(this,propertyTrackDataItem);this._propertyTracks.push(propertyTrack);this._CachePropertyTracks();return propertyTrack}SetInitialState(){this.MaybeGetInstance();if(!this.IsInstanceValid()&&this.IsInstanceTrack())return;const timeline=this.GetTimeline();const isForwardPlayBack=
timeline.IsForwardPlayBack();const time=isForwardPlayBack?0:this.GetLocalTotalTime();for(const propertyTrack of this._propertyTracks){propertyTrack.SetInitialState(time);if(this._worldInfoChange===0&&propertyTrack.GetWorldInfoChange()===1)this._worldInfoChange=1;if(this._renderChange===0&&propertyTrack.GetRenderChange()===1)this._renderChange=1}this._needsBeforeAndAfter=0;const nba=this._propertyTracks.some(pt=>pt.GetNeedsBeforeAndAfter());if(nba)this._needsBeforeAndAfter=1;this._lastKeyframeDataItem=
this._GetLastKeyFrameBeforeTime(time);this._initialStateOfNestedSet=false;this._endStateOfNestedSet=false;this.Interpolate(time)}BeforeInterpolate(){}Interpolate(time,isTicking=false,setTime=false,ensureValue=false,firstTick=false,ignoreGlobals=false,endState=false){if(!this._instance)this.GetInstance();if(!this._instance)return;const instanceValid=!this._instance.IsDestroyed();if(!instanceValid)return false;if(ignoreGlobals&&this.GetObjectClass().IsGlobal())return false;if(this._secondPropertyTrack){this._firstPropertyTrack.Interpolate(time,
setTime,ensureValue,endState);this._secondPropertyTrack.Interpolate(time,setTime,ensureValue,endState)}else this._firstPropertyTrack.Interpolate(time,setTime,ensureValue,endState);if(this._firstPropertyTrack.GetWorldInfoChange()!==0){if(!this._worldInfo)this._worldInfo=this._instance.GetWorldInfo();if(this._worldInfo)this._worldInfo.SetBboxChanged()}}AfterInterpolate(){}_LoadFromJson(o){super._LoadFromJson(o);this._CachePropertyTracks()}};

}

// timelines/tweens/tweenPropertyTrackState.js
{
'use strict';const C3=self.C3;
C3.TweenPropertyTrackState=class TweenPropertyTrackState extends C3.PropertyTrackState{constructor(track,propertyTrackDataItem){super(track,propertyTrackDataItem);this._basic=false}static Create(track,propertyTrackDataItem){return C3.New(C3.TweenPropertyTrackState,track,propertyTrackDataItem)}Interpolate(time,setTime=false,ensureValue=false,endState=false){let start;let end;if(this._basic){start=this._propertyKeyframeDataItems[0];end=this._propertyKeyframeDataItems[1]}else if(setTime){start=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,
this._propertyTrackDataItem);end=start.GetNext()}else{if(this._lastPropertyKeyframeDataItem){const timeline=this.GetTimeline();const nextPropertyKeyframe=this._lastPropertyKeyframeDataItem.GetNext();const lastTime=this._lastPropertyKeyframeDataItem.GetTime();const nextTime=nextPropertyKeyframe?nextPropertyKeyframe.GetTime():timeline.GetTotalTime();if(time<=lastTime||time>=nextTime)this._lastPropertyKeyframeDataItem=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem)}else this._lastPropertyKeyframeDataItem=
this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,this._propertyTrackDataItem);start=this._lastPropertyKeyframeDataItem;end=start.GetNext()}this._sourceAdapter.Interpolate(time,start,end,setTime,ensureValue,endState)}AddPropertyKeyframe(){const propertyKeyframeData=this._propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItem=propertyKeyframeData.AddEmptyPropertyKeyframeDataItem();this._lastPropertyKeyframeDataItem=null;this._basic=this.GetPropertyKeyframeDataItems().length<=
2;return propertyKeyframeDataItem}DeletePropertyKeyframes(match){this._lastPropertyKeyframeDataItem=null;const propertyKeyframeData=this._propertyTrackDataItem.GetPropertyKeyframeData();propertyKeyframeData.DeletePropertyKeyframeDataItems(match);this._basic=this.GetPropertyKeyframeDataItems().length<=2}_SaveToJson(){return{"sourceAdapterJson":this.GetSourceAdapter()._SaveToJson(),"basic":this._basic}}_LoadFromJson(o){if(!o)return;this.GetSourceAdapter()._LoadFromJson(o["sourceAdapterJson"]);this._basic=
o["basic"]}};

}

// timelines/transitions/transition.js
{
'use strict';const C3=self.C3;const Ease=self.Ease;const NAME=0;const TRANSITION_KEYFRAMES=1;
C3.Transition=class Transition extends C3.DefendedBase{constructor(data,addCustomEase=true){super();this._name=data[NAME];this._linear=false;this._transitionKeyframes=[];for(const transitionKeyframeData of data[TRANSITION_KEYFRAMES]){const transitionKeyframe=C3.TransitionKeyframe.Create(this,transitionKeyframeData);this._transitionKeyframes.push(transitionKeyframe)}for(let i=0;i<this._transitionKeyframes.length;i++){const current=this._transitionKeyframes[i];current.SetNext(this._transitionKeyframes[i+
1])}this._precalculatedSamples=new Map;this._transitionKeyframeCache=new Map;this._PreCalcSamples();if(addCustomEase)Ease.AddCustomEase(this._name,(t,sv,dv,tt)=>this.Interpolate(t,sv,dv,tt))}static Create(data){return C3.New(C3.Transition,data)}Release(){for(const transitionKeyframe of this._transitionKeyframes)transitionKeyframe.Release();C3.clearArray(this._transitionKeyframes);this._transitionKeyframes=null;this._precalculatedSamples.clear();this._precalculatedSamples=null;this._transitionKeyframeCache.clear();
this._transitionKeyframeCache=null}MakeLinear(linear){this._linear=!!linear}GetTransitionKeyFrameAt(x){const transitionKeyframe=this._transitionKeyframeCache.get(x);if(transitionKeyframe)return transitionKeyframe;for(const transitionKeyframe of this._transitionKeyframes)if(transitionKeyframe.GetValueX()===x){this._transitionKeyframeCache.set(x,transitionKeyframe);return transitionKeyframe}}GetFirstTransitionKeyFrameHigherThan(x){for(const transitionKeyframe of this._transitionKeyframes)if(transitionKeyframe.GetValueX()>
x)return transitionKeyframe}GetFirstTransitionKeyFrameHigherOrEqualThan(x){for(const transitionKeyframe of this._transitionKeyframes)if(transitionKeyframe.GetValueX()>=x)return transitionKeyframe}GetFirstTransitionKeyFrameLowerThan(x){for(let i=this._transitionKeyframes.length-1;i>=0;i--){const transitionKeyframe=this._transitionKeyframes[i];if(transitionKeyframe.GetValueX()<x)return transitionKeyframe}}GetFirstTransitionKeyFrameLowerOrEqualThan(x){for(let i=this._transitionKeyframes.length-1;i>=
0;i--){const transitionKeyframe=this._transitionKeyframes[i];if(transitionKeyframe.GetValueX()<=x)return transitionKeyframe}}Interpolate(time,startValue,deltaValue,totalTime){if(this._linear)return Ease.NoEase(time,startValue,deltaValue,totalTime);const n=time/totalTime;let start=this.GetFirstTransitionKeyFrameLowerOrEqualThan(n);let end=start.GetNext();if(!end){start=this.GetFirstTransitionKeyFrameLowerThan(n);end=start.GetNext()}const delta=end.GetValueX()-start.GetValueX();const nn=C3.mapToRange(n,
start.GetValueX(),end.GetValueX(),0,delta);const startX=start.GetValueX();const startY=start.GetValueY();const anchor1X=start.GetValueX()+start.GetStartAnchorX();const anchor1Y=start.GetValueY()+start.GetStartAnchorY();const anchor2X=end.GetValueX()+end.GetEndAnchorX();const anchor2Y=end.GetValueY()+end.GetEndAnchorY();const endX=end.GetValueX();const endY=end.GetValueY();let ret=Ease.GetRuntimeEase("spline")(nn,startX,startY,anchor1X,anchor1Y,anchor2X,anchor2Y,endX,endY,this._precalculatedSamples.get(start));
ret+=start.GetValueY();return(1-ret)*startValue+ret*(startValue+deltaValue)}_PreCalcSamples(){this._precalculatedSamples.clear();for(let i=0;i<this._transitionKeyframes.length-1;i++){const transitionKeyframe=this._transitionKeyframes[i];if(!transitionKeyframe.GetStartEnable())continue;const start=transitionKeyframe;const end=this._transitionKeyframes[i+1];const startValue=start.GetValueX();const anchor1Value=start.GetValueX()+start.GetStartAnchorX();const anchor2Value=end.GetValueX()+end.GetEndAnchorX();
const endValue=end.GetValueX();this._precalculatedSamples.set(start,Ease.GetBezierSamples(startValue,anchor1Value,anchor2Value,endValue))}}};

}

// timelines/transitions/transitionKeyframe.js
{
'use strict';const C3=self.C3;const VALUE_X=0;const VALUE_Y=1;const START_ANCHOR_X=2;const START_ANCHOR_Y=3;const END_ANCHOR_X=4;const END_ANCHOR_Y=5;const START_ENABLE=6;const END_ENABLE=7;
C3.TransitionKeyframe=class TransitionKeyframe extends C3.DefendedBase{constructor(transition,data){super();this._transition=transition;this._valueX=data[VALUE_X];this._valueY=data[VALUE_Y];this._startAnchorX=data[START_ANCHOR_X];this._startAnchorY=data[START_ANCHOR_Y];this._endAnchorX=data[END_ANCHOR_X];this._endAnchorY=data[END_ANCHOR_Y];this._startEnable=data[START_ENABLE];this._endEnable=data[END_ENABLE];this._next=null}Release(){this._transition=null}static Create(transition,data){return C3.New(C3.TransitionKeyframe,
transition,data)}SetNext(transitionKeyframe){this._next=transitionKeyframe}GetNext(){return this._next}GetValueX(){return this._valueX}GetValueY(){return this._valueY}GetStartAnchorX(){return this._startAnchorX}GetStartAnchorY(){return this._startAnchorY}GetEndAnchorX(){return this._endAnchorX}GetEndAnchorY(){return this._endAnchorY}GetStartEnable(){return this._startEnable}GetEndEnable(){return this._endEnable}};

}

// timelines/transitions/transitionManager.js
{
'use strict';const C3=self.C3;C3.TransitionManager=class TransitionManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._transitions=[]}Release(){for(const transition of this._transitions)transition.Release();C3.clearArray(this._transitions);this._transitions=null}Create(transitionData){this._transitions.push(C3.Transition.Create(transitionData))}};

}

// templates/templateManager.js
{
'use strict';const C3=self.C3;
C3.TemplateManager=class TemplateManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._templateDataMap=null;this._instanceToTemplateNameMap=null;this._instanceDestroy=e=>this._OnInstanceDestroy(e.instance)}Release(){this.RemoveRuntimeListeners();if(this._templateDataMap){for(const objectClassTemplatesMap of this._templateDataMap.values())objectClassTemplatesMap.clear();this._templateDataMap.clear()}this._templateDataMap=null;this._runtime=null}Create(templateInstanceData){if(!this._templateDataMap)this._templateDataMap=
new Map;if(!templateInstanceData)return;const templateData=templateInstanceData[0][16];const templateName=templateData[0];const objectClassIndex=templateInstanceData[1];if(!this._templateDataMap.has(objectClassIndex))this._templateDataMap.set(objectClassIndex,new Map);const objectClassTemplatesMap=this._templateDataMap.get(objectClassIndex);objectClassTemplatesMap.set(templateName,templateInstanceData)}AddRuntimeListeners(){const dispatcher=this._runtime.Dispatcher();if(dispatcher)dispatcher.addEventListener("instancedestroy",
this._instanceDestroy)}RemoveRuntimeListeners(){const dispatcher=this._runtime.Dispatcher();if(dispatcher)dispatcher.removeEventListener("instancedestroy",this._instanceDestroy)}HasTemplates(){if(!this._templateDataMap)return false;return this._templateDataMap.size!==0}GetTemplateData(objectClass_or_index,templateName){let index=0;if(objectClass_or_index instanceof C3.ObjectClass)index=objectClass_or_index.GetIndex();else index=objectClass_or_index;if(!this._templateDataMap.has(index))return;const ret=
this._templateDataMap.get(index).get(templateName);if(ret)return JSON.parse(JSON.stringify(ret));return undefined}MapInstanceToTemplateName(inst,templateName){if(!this._instanceToTemplateNameMap)this._instanceToTemplateNameMap=new WeakMap;if(this._instanceToTemplateNameMap.has(inst))return;this._instanceToTemplateNameMap.set(inst,templateName)}GetInstanceTemplateName(inst){if(!this._instanceToTemplateNameMap)return"";const ret=this._instanceToTemplateNameMap.get(inst);if(ret)return ret;return""}_OnInstanceDestroy(inst){if(!this._instanceToTemplateNameMap)return;
if(!this._instanceToTemplateNameMap.has(inst))return;this._instanceToTemplateNameMap.delete(inst)}};

}

// events/stacks/solStack.js
{
'use strict';const C3=self.C3;
C3.SolStack=class SolStack extends C3.DefendedBase{constructor(objectClass){super();this._objectClass=objectClass;this._stack=[];this._stack.push(C3.New(C3.Sol,this));this._index=0;this._current=this._stack[0]}Release(){for(const s of this._stack)s.Release();C3.clearArray(this._stack);this._current=null;this._objectClass=null}GetObjectClass(){return this._objectClass}GetCurrentSol(){return this._current}GetOneBelowCurrentSol(){return this._stack[this._index-1]}Clear(){this.GetCurrentSol().Clear()}PushClean(){const stack=this._stack;
const index=++this._index;if(index===stack.length){const sol=C3.New(C3.Sol,this);stack.push(sol);this._current=sol}else{const sol=stack[index];sol.Reset();this._current=sol}}PushCopy(){const stack=this._stack;const index=++this._index;if(index===stack.length)stack.push(C3.New(C3.Sol,this));const sol=stack[index];sol.Copy(stack[index-1]);this._current=sol}Pop(){this._current=this._stack[--this._index]}RemoveInstances(s){const stack=this._stack;for(let i=0,len=stack.length;i<len;++i)stack[i].RemoveInstances(s)}};

}

// events/stacks/sol.js
{
'use strict';const C3=self.C3;
C3.Sol=class Sol extends C3.DefendedBase{constructor(stack){super();this._stack=stack;this._objectClass=this._stack.GetObjectClass();this._eventStack=this._objectClass.GetRuntime().GetEventStack();this._selectAll=true;this._instances=[];this._elseInstances=[]}Release(){this.ClearArrays();this._stack=null;this._objectClass=null;this._eventStack=null}ClearArrays(){C3.clearArray(this._instances);C3.clearArray(this._elseInstances)}GetObjectClass(){return this._objectClass}IsSelectAll(){return this._selectAll}HasAnyInstances(){if(this._selectAll)return!!this._objectClass.GetInstanceCount();else return!!this._instances.length}GetInstances(){if(this._selectAll)return this._objectClass.GetInstances();
else return this._instances}HasAnyElseInstances(){return!!this._elseInstances.length}GetElseInstances(){return this._elseInstances}GetExpressionInstances(){const ret=this.GetInstances();if(ret.length)return ret;else return this._elseInstances}Reset(){this._selectAll=true;C3.clearArray(this._elseInstances)}Clear(){this._selectAll=true}Copy(sol){if(sol.IsSelectAll())this.Reset();else{this._selectAll=false;C3.shallowAssignArray(this._instances,sol._instances);C3.clearArray(this._elseInstances)}}_PushInstance(inst){this._instances.push(inst)}_PushElseInstance(inst){this._elseInstances.push(inst)}_SetSelectAll(s){this._selectAll=
!!s}_GetOwnInstances(){return this._instances}_GetOwnElseInstances(){return this._elseInstances}SetSinglePicked(inst){this._selectAll=false;C3.clearArray(this._instances);this._instances.push(inst)}SetArrayPicked(arr){this._selectAll=false;C3.shallowAssignArray(this._instances,arr)}SetSetPicked(set){this._selectAll=false;C3.clearArray(this._instances);for(const item of set)this._instances.push(item)}AddElseInstances(setOfPicked,arrayOfAllPicked){for(const inst of arrayOfAllPicked)if(!setOfPicked.has(inst))this._elseInstances.push(inst)}TransferElseInstancesToOwn(setOfPicked){for(const inst of setOfPicked)this._instances.push(inst);
C3.arrayRemoveAllInSet(this._elseInstances,setOfPicked)}ClearElseInstances(){C3.clearArray(this._elseInstances)}PickOne(inst){if(!inst)return;if(this._eventStack.GetCurrentStackFrame().GetCurrentEvent().IsOrBlock()){if(this.IsSelectAll()){C3.clearArray(this._instances);C3.shallowAssignArray(this._elseInstances,inst.GetObjectClass().GetInstances());this._selectAll=false}const i=this._elseInstances.indexOf(inst);if(i!==-1){this._instances.push(this._elseInstances[i]);this._elseInstances.splice(i,1)}}else this.SetSinglePicked(inst)}RemoveInstances(s){C3.arrayRemoveAllInSet(this._instances,
s);C3.arrayRemoveAllInSet(this._elseInstances,s)}};

}

// events/stacks/eventStack.js
{
'use strict';const C3=self.C3;
C3.EventStack=class EventStack extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._runtime=this._eventSheetManager.GetRuntime();this._stack=[];this._stack.push(C3.New(C3.EventStackFrame,this,null));this._index=0;this._expFuncStack=[]}Release(){for(const e of this._stack)e.Release();C3.clearArray(this._stack);C3.clearArray(this._expFuncStack);this._eventSheetManager=null;this._runtime=null}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}GetCurrentStackFrame(){return this._stack[this._index]}GetAllStackFrames(){return this._stack}GetCurrentStackFrameIndex(){return this._index}Push(currentEvent){const stack=this._stack;
const index=++this._index;if(index===stack.length){const ret=C3.New(C3.EventStackFrame,this,currentEvent);stack.push(ret);return ret}else{const ret=stack[index];ret.Reset(currentEvent);return ret}}Pop(){--this._index}PushExpFunc(frame){this._expFuncStack.push(frame)}PopExpFunc(){this._expFuncStack.pop()}GetCurrentExpFuncStackFrame(){const expFuncStack=this._expFuncStack;if(expFuncStack.length===0)return null;else return expFuncStack.at(-1)}};

}

// events/stacks/eventStackFrame.js
{
'use strict';const C3=self.C3;
C3.EventStackFrame=class EventStackFrame extends C3.DefendedBase{constructor(stack,currentEvent){super();this._stack=stack;this._runtime=this._stack.GetRuntime();this._currentEvent=currentEvent;this._cndIndex=0;this._actIndex=0;this._lastEventTrue=false;this._elseBranchRan=false;this._expressionObjectClass=null;this._functionReturnType=0;this._functionReturnValue=0;this._dynamicSolModifiers=null}Release(){this.Reset(null);this._stack=null;this._runtime=null}Reset(currentEvent){this._currentEvent=currentEvent;
this._cndIndex=0;this._actIndex=0;this._lastEventTrue=false;this._elseBranchRan=false;this._dynamicSolModifiers=null}_Restore(currentEvent,actIndex){this._currentEvent=currentEvent;this._cndIndex=0;this._actIndex=actIndex}ResetQuick(){this._cndIndex=0;this._actIndex=0}GetCurrentEvent(){return this._currentEvent}SetCurrentEvent(currentEvent){this._currentEvent=currentEvent}GetConditionIndex(){return this._cndIndex}SetConditionIndex(i){this._cndIndex=i}GetActionIndex(){return this._actIndex}SetActionIndex(i){this._actIndex=
i}SetLastEventTrue(t){this._lastEventTrue=!!t}GetLastEventTrue(){return this._lastEventTrue}SetElseBranchRan(r){this._elseBranchRan=!!r}GetElseBranchRan(){return this._elseBranchRan}SetExpressionObjectClass(objectClass){this._expressionObjectClass=objectClass}GetExpressionObjectClass(){return this._expressionObjectClass}InitCallFunctionExpression(returnType,defaultReturnValue){this._functionReturnType=returnType;this._functionReturnValue=defaultReturnValue}GetFunctionReturnType(){return this._functionReturnType}SetFunctionReturnValue(v){this._functionReturnValue=
v}GetFunctionReturnValue(){return this._functionReturnValue}IsSolModifierAfterCnds(){const currentEvent=this._currentEvent;if(currentEvent.IsSolWriterAfterCnds())return true;if(this._cndIndex<currentEvent.GetConditionCount()-1)return!!currentEvent.GetSolModifiers().length;return false}SetDynamicSolModifiers(solModifiers){this._dynamicSolModifiers=solModifiers}GetDynamicSolModifiers(){return this._dynamicSolModifiers}};

}

// events/stacks/localVarStack.js
{
'use strict';const C3=self.C3;
C3.LocalVarStack=class LocalVarStack extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._runtime=this._eventSheetManager.GetRuntime();this._stack=[];this._index=-1;this._current=null;this._initialValues=[]}Release(){C3.clearArray(this._stack);this._eventSheetManager=null;this._runtime=null}_SetInitialValues(initialValues){this._initialValues=initialValues;const arr=this._initialValues.slice(0);this._stack.push(arr);this._index=0;this._current=
arr}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}GetCurrent(){return this._current}Push(){const index=++this._index;const stack=this._stack;if(index===stack.length)stack.push(this._initialValues.slice(0));else C3.shallowAssignArray(stack[index],this._initialValues);this._current=stack[index]}Pop(){this._current=this._stack[--this._index]}};

}

// events/stacks/loopStack.js
{
'use strict';const C3=self.C3;
C3.LoopStack=class LoopStack extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._runtime=this._eventSheetManager.GetRuntime();this._stack=[];this._index=-1}Release(){C3.clearArray(this._stack);this._eventSheetManager=null;this._runtime=null}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}IsInLoop(){return this._index>=0}GetCurrent(){return this._stack[this._index]}Push(){++this._index;if(this._index===
this._stack.length){const ret=C3.New(C3.Loop,this);this._stack.push(ret);return ret}else{const ret=this._stack[this._index];ret.Reset();return ret}}Pop(){--this._index}FindByName(name){const stack=this._stack;for(let i=this._index;i>=0;--i){const loop=stack[i];if(loop.GetName()===name)return loop}return null}_GetStack(){return this._stack.slice(0,this._index+1)}};

}

// events/stacks/loop.js
{
'use strict';const C3=self.C3;C3.Loop=class Loop extends C3.DefendedBase{constructor(loopStack){super();this._loopStack=loopStack;this._name="";this._index=0;this._isStopped=false;this._end=NaN}Reset(){this._name="";this._index=0;this._isStopped=false;this._end=NaN}SetName(name){this._name=name}GetName(){return this._name}SetIndex(i){this._index=i}GetIndex(){return this._index}Stop(){this._isStopped=true}IsStopped(){return this._isStopped}SetEnd(e){this._end=e}GetEnd(){return this._end}};

}

// events/stacks/arrayStack.js
{
'use strict';const C3=self.C3;C3.ArrayStack=class ArrayStack extends C3.DefendedBase{constructor(){super();this._stack=[];this._index=-1}Release(){C3.clearArray(this._stack)}GetCurrent(){return this._stack[this._index]}Push(){++this._index;if(this._index===this._stack.length){const ret=[];this._stack.push(ret);return ret}else return this._stack[this._index]}Pop(){--this._index}};

}

// events/eventSheetManager.js
{
'use strict';const C3=self.C3;const assert=self.assert;function SortSolArray(a,b){return a.GetIndex()-b.GetIndex()}function IsSolArrayIdentical(a,b){for(let i=0,len=a.length;i<len;++i)if(a[i]!==b[i])return false;return true}
C3.EventSheetManager=class EventSheetManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._allSheets=[];this._sheetsByName=new Map;this._allGroups=[];this._groupsByName=new Map;this._blocksBySid=new Map;this._cndsBySid=new Map;this._actsBySid=new Map;this._allUniqueSolModifiers=new Map;this._eventVarsBySid=new Map;this._nextLocalVarIndex=0;this._allGlobalVars=[];this._allLocalVars=[];this._localVarInitialValues=[];this._functionBlocksByName=new Map;this._customActionBlocksMap=
new Map;this._eventStack=C3.New(C3.EventStack,this);this._localVarStack=C3.New(C3.LocalVarStack,this);this._loopStack=C3.New(C3.LoopStack,this);this._triggersToPostInit=[];this._queuedTriggers=[];this._queuedDebugTriggers=[];this._runningEventsDepth=0;this._executingTriggerDepth=0;this._blockFlushingDepth=0;this._scheduledWaits=[];this._asyncActionPromises=[];self["c3_callFunction"]=(name,params)=>this._InvokeFunctionFromJS(name,params)}Release(){this.ClearAllScheduledWaits();this._eventStack.Release();
this._eventStack=null;this._localVarStack.Release();this._localVarStack=null;C3.clearArray(this._queuedTriggers);C3.clearArray(this._queuedDebugTriggers);this._runtime=null;C3.clearArray(this._allSheets);this._sheetsByName.clear()}Create(eventSheetData){const eventSheet=C3.New(C3.EventSheet,this,eventSheetData);this._allSheets.push(eventSheet);this._sheetsByName.set(eventSheet.GetName().toLowerCase(),eventSheet)}_AddTriggerToPostInit(trig){this._triggersToPostInit.push(trig)}_PostInit(){for(const customActionBlock of this._customActionBlocksMap.values())customActionBlock._CheckOverrideState();
for(const functionBlock of this._functionBlocksByName.values())functionBlock._PostInit();for(const customActionBlock of this._customActionBlocksMap.values())customActionBlock._PostInit();for(const sheet of this._allSheets)sheet._PostInit();for(const sheet of this._allSheets)sheet._UpdateDeepIncludes();for(const trig of this._triggersToPostInit)trig._PostInit(false);C3.clearArray(this._triggersToPostInit);this._localVarStack._SetInitialValues(this._localVarInitialValues)}GetRuntime(){return this._runtime}GetEventSheetByName(name){return this._sheetsByName.get(name.toLowerCase())||
null}_RegisterGroup(group){this._allGroups.push(group);this._groupsByName.set(group.GetGroupName(),group)}_RegisterEventBlock(eventBlock){this._blocksBySid.set(eventBlock.GetSID(),eventBlock)}_RegisterCondition(condition){this._cndsBySid.set(condition.GetSID(),condition)}_RegisterAction(action){this._actsBySid.set(action.GetSID(),action)}_RegisterFunctionBlock(functionBlock){switch(functionBlock.GetFunctionType()){case 0:this._functionBlocksByName.set(functionBlock.GetFunctionName().toLowerCase(),
functionBlock);break;case 1:this._customActionBlocksMap.set(functionBlock.GetFunctionName().toLowerCase(),functionBlock);break;default:}}_RegisterEventVariable(ev){this._eventVarsBySid.set(ev.GetSID(),ev);if(ev.IsGlobal())this._allGlobalVars.push(ev);else this._allLocalVars.push(ev)}_DeduplicateSolModifierList(arr){if(arr.length>=2)arr.sort(SortSolArray);let candidateList=this._allUniqueSolModifiers.get(arr.length);if(!candidateList){candidateList=[];this._allUniqueSolModifiers.set(arr.length,candidateList)}for(let i=
0,len=candidateList.length;i<len;++i){const candidate=candidateList[i];if(IsSolArrayIdentical(arr,candidate))return candidate}candidateList.push(arr);return arr}_GetNextLocalVarIndex(eventVar){this._localVarInitialValues.push(eventVar.GetInitialValue());return this._nextLocalVarIndex++}GetEventStack(){return this._eventStack}GetCurrentEventStackFrame(){return this.GetEventStack().GetCurrentStackFrame()}GetCurrentEvent(){return this.GetCurrentEventStackFrame().GetCurrentEvent()}GetCurrentCondition(){const frame=
this.GetCurrentEventStackFrame();const event=frame.GetCurrentEvent();return event.GetConditionAt(frame.GetConditionIndex())}GetCurrentAction(){const frame=this.GetCurrentEventStackFrame();const event=frame.GetCurrentEvent();return event.GetActionAt(frame.GetActionIndex())}GetLocalVarStack(){return this._localVarStack}GetLoopStack(){return this._loopStack}GetAllLocalVariablesInScope(fromRow){const ret=[];fromRow=fromRow.GetScopeParent();while(fromRow){C3.appendArray(ret,fromRow._GetAllLocalVariablesInScope());
fromRow=fromRow.GetScopeParent()}return ret}_GetLocalVariablesScriptInterface(fromRow){const localVarDescriptors={};for(const v of this.GetAllLocalVariablesInScope(fromRow))localVarDescriptors[v.GetJsPropName()]=v._GetScriptInterfaceDescriptor();return Object.create(Object.prototype,localVarDescriptors)}GetEventVariableBySID(sid){return this._eventVarsBySid.get(sid)||null}GetEventBlockBySID(sid){return this._blocksBySid.get(sid)||null}GetConditionBySID(sid){return this._cndsBySid.get(sid)||null}GetActionBySID(sid){return this._actsBySid.get(sid)||
null}GetFunctionBlockByName(name){return this._functionBlocksByName.get(name.toLowerCase())||null}GetCustomActionBlockByName(objectClass,name){let ret=this._customActionBlocksMap.get((objectClass.GetName()+"."+name).toLowerCase());if(ret)return ret;if(!objectClass.IsFamily())for(const family of objectClass.GetFamilies()){ret=this._customActionBlocksMap.get((family.GetName()+"."+name).toLowerCase());if(ret)return ret}return null}GetAllGlobalVariables(){return this._allGlobalVars}GetAllLocalVariables(){return this._allLocalVars}ResetAllGlobalsToInitialValue(){for(const ev of this._allGlobalVars)ev.ResetToInitialValue()}GetEventGroupByName(name){return this._groupsByName.get(name.toLowerCase())||
null}GetEventGroupBySID(sid){const group=this._blocksBySid.get(sid);if(group&&group.IsGroup())return group;else return null}GetAllGroups(){return this._allGroups}ResetAllGroupsInitialActivation(){for(const group of this._allGroups)group.ResetInitialActivation()}_ResetAllHasRunFlags(){for(const sheet of this._allSheets)sheet._ResetHasRunFlag()}RunEvents(layoutManager){this._ResetAllHasRunFlags();this._runningEventsDepth++;for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();
if(!eventSheet)continue;this._runtime.PushCurrentLayout(layout);eventSheet.Run();this._runtime.PopCurrentLayout()}this._runningEventsDepth--}async DebugRunEvents(layoutManager){this._ResetAllHasRunFlags();this._runningEventsDepth++;for(const breakEventObject of this._DebugRunEventsGen(layoutManager))await this._runtime.DebugBreak(breakEventObject);this._runningEventsDepth--}*_DebugRunEventsGen(layoutManager){for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();
if(!eventSheet)continue;this._runtime.PushCurrentLayout(layout);yield*eventSheet.DebugRun();this._runtime.PopCurrentLayout()}}_Trigger(layoutManager,method,inst,behaviorType){let ret=false;if(!layoutManager.GetMainRunningLayout())return this.QueueTrigger(method,inst,behaviorType);this._executingTriggerDepth++;for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();if(!eventSheet)continue;this._runtime.PushCurrentLayout(layout);for(const includeSheet of eventSheet.deepIncludes()){const result=
includeSheet._Trigger(method,inst,behaviorType);ret=ret||result}const result2=eventSheet._Trigger(method,inst,behaviorType);ret=ret||result2;this._runtime.PopCurrentLayout()}this._executingTriggerDepth--;return ret}*_DebugTrigger(layoutManager,method,inst,behaviorType){let ret=false;if(!layoutManager.GetMainRunningLayout())return this.QueueTrigger(method,inst,behaviorType);this._executingTriggerDepth++;for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();if(!eventSheet)continue;
this._runtime.PushCurrentLayout(layout);for(const includeSheet of eventSheet.deepIncludes()){const result=yield*includeSheet._DebugTrigger(method,inst,behaviorType);ret=ret||result}const result2=yield*eventSheet._DebugTrigger(method,inst,behaviorType);ret=ret||result2;this._runtime.PopCurrentLayout()}this._executingTriggerDepth--;return ret}QueueTrigger(method,inst,behaviorType){this._queuedTriggers.push([method,inst,behaviorType]);return false}QueueDebugTrigger(method,inst,behaviorType){let resolve=
null;const ret=new Promise(r=>resolve=r);this._queuedDebugTriggers.push([method,inst,behaviorType,resolve]);return ret}*_RunQueuedDebugTriggersGen(){if(this._runtime.HitBreakpoint())throw new Error("should not be in breakpoint");const layoutManager=this._runtime.GetLayoutManager();while(this._queuedDebugTriggers.length){const [method,inst,behaviorType,resolve]=this._queuedDebugTriggers.shift();const ret=yield*this._DebugTrigger(layoutManager,method,inst,behaviorType);resolve(ret)}}async RunQueuedDebugTriggersAsync(){for(const breakEventObject of this._RunQueuedDebugTriggersGen())await this._runtime.DebugBreak(breakEventObject)}_FastTrigger(layoutManager,
method,inst,value){let ret=false;const layout=layoutManager.GetMainRunningLayout();const eventSheet=layout.GetEventSheet();if(!eventSheet)return;this._executingTriggerDepth++;this._runtime.PushCurrentLayout(layout);const deepIncludes=eventSheet.deepIncludes();for(let i=0,len=deepIncludes.length;i<len;++i){const result=deepIncludes[i]._FastTrigger(method,inst,value);ret=ret||result}const result2=eventSheet._FastTrigger(method,inst,value);ret=ret||result2;this._runtime.PopCurrentLayout();this._executingTriggerDepth--;
return ret}*_DebugFastTrigger(layoutManager,method,inst,value){let ret=false;const layout=layoutManager.GetMainRunningLayout();const eventSheet=layout.GetEventSheet();if(!eventSheet)return;this._executingTriggerDepth++;this._runtime.PushCurrentLayout(layout);const deepIncludes=eventSheet.deepIncludes();for(let i=0,len=deepIncludes.length;i<len;++i){const result=yield*deepIncludes[i]._DebugFastTrigger(method,inst,value);ret=ret||result}const result2=yield*eventSheet._DebugFastTrigger(method,inst,value);
ret=ret||result2;this._runtime.PopCurrentLayout();this._executingTriggerDepth--;return ret}GetTriggerDepth(){return this._executingTriggerDepth}IsInTrigger(){return this.GetTriggerDepth()>0}_IncTriggerDepth(){return++this._executingTriggerDepth}_DecTriggerDepth(){--this._executingTriggerDepth}IsRunningEvents(){return this._runningEventsDepth>0}IsInEventEngine(){return this.IsRunningEvents()||this.IsInTrigger()}_RunQueuedTriggers(layoutManager){for(const [method,inst,behaviorType]of this._queuedTriggers)this._Trigger(layoutManager,
method,inst,behaviorType);C3.clearArray(this._queuedTriggers)}BlockFlushingInstances(e){if(e)this._blockFlushingDepth++;else this._blockFlushingDepth--}IsFlushingBlocked(){return this._blockFlushingDepth>0}ClearSol(solModifiers){for(let i=0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().Clear()}PushCleanSol(solModifiers){for(let i=0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().PushClean()}PushCopySol(solModifiers){for(let i=0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().PushCopy()}PopSol(solModifiers){for(let i=
0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().Pop()}GetDynamicSolModifiersSet(skipSet){const ret=new Set;const allStackFrames=this._eventStack.GetAllStackFrames();const stackIndex=this._eventStack.GetCurrentStackFrameIndex();for(let i=0;i<=stackIndex;++i){const dynamicSolModifiers=allStackFrames[i].GetDynamicSolModifiers();if(dynamicSolModifiers)for(const t of dynamicSolModifiers)if(!skipSet||!skipSet.has(t))ret.add(t)}return ret}PushCleanSolDynamic(existingSolModifiers){const existingSet=
new Set([...existingSolModifiers]);const pushSet=this.GetDynamicSolModifiersSet(existingSet);if(pushSet.size>0){for(const t of pushSet)t.GetSolStack().PushClean();return[...pushSet]}else return null}AddScheduledWait(){const w=C3.New(C3.ScheduledWait,this);this._scheduledWaits.push(w);return w}scheduledWaits(){return this._scheduledWaits}RunScheduledWaits(){if(!this._scheduledWaits.length)return;const frame=this.GetCurrentEventStackFrame();let didAnyRun=false;this._runningEventsDepth++;for(let i=0,
len=this._scheduledWaits.length;i<len;++i){const w=this._scheduledWaits[i];if(w._ShouldRun())w._Run(frame);if(w.ShouldRelease())didAnyRun=true}if(didAnyRun){this._FilterScheduledWaitsToRelease();frame.Reset(null)}this._runningEventsDepth--}async DebugRunScheduledWaits(){if(!this._scheduledWaits.length)return;const frame=this.GetCurrentEventStackFrame();let didAnyRun=false;this._runningEventsDepth++;for(let i=0,len=this._scheduledWaits.length;i<len;++i){const w=this._scheduledWaits[i];if(w._ShouldRun())await w._DebugRun(frame);
if(w.ShouldRelease())didAnyRun=true}if(didAnyRun){this._FilterScheduledWaitsToRelease();frame.Reset(null)}this._runningEventsDepth--}_FilterScheduledWaitsToRelease(){const toRelease=C3.arrayFilterOut(this._scheduledWaits,w=>w.ShouldRelease());for(const w of toRelease)w.Release()}ClearAllScheduledWaits(){for(const w of this._scheduledWaits)w.Release();C3.clearArray(this._scheduledWaits)}RemoveInstancesFromScheduledWaits(s){for(const w of this._scheduledWaits)w.RemoveInstances(s)}AddAsyncActionPromise(p){this._asyncActionPromises.push(p)}ClearAsyncActionPromises(){C3.clearArray(this._asyncActionPromises)}GetPromiseForAllAsyncActions(){const ret=
Promise.all(this._asyncActionPromises);this._asyncActionPromises=[];return ret}_SaveToJson(){return{"groups":this._SaveGroupsToJson(),"cnds":this._SaveCndsToJson(),"acts":this._SaveActsToJson(),"vars":this._SaveVarsToJson(),"waits":this._SaveScheduledWaitsToJson()}}_LoadFromJson(o){this._LoadGroupsFromJson(o["groups"]);this._LoadCndsFromJson(o["cnds"]);this._LoadActsFromJson(o["acts"]);this._LoadVarsFromJson(o["vars"]);this._LoadScheduledWaitsFromJson(o["waits"])}_SaveGroupsToJson(){const o={};for(const group of this.GetAllGroups())o[group.GetSID().toString()]=
group.IsGroupActive();return o}_LoadGroupsFromJson(o){for(const [sidStr,data]of Object.entries(o)){const sid=parseInt(sidStr,10);const group=this.GetEventGroupBySID(sid);if(group)group.SetGroupActive(data)}}_SaveCndsToJson(){const o={};for(const [sid,cnd]of this._cndsBySid){const data=cnd._SaveToJson();if(data)o[sid.toString()]=data}return o}_LoadCndsFromJson(o){const map=new Map;for(const [sidStr,data]of Object.entries(o))map.set(parseInt(sidStr,10),data);for(const [sid,cnd]of this._cndsBySid)cnd._LoadFromJson(map.get(sid)||
null)}_SaveActsToJson(){const o={};for(const [sid,act]of this._actsBySid){const data=act._SaveToJson();if(data)o[sid.toString()]=data}return o}_LoadActsFromJson(o){const map=new Map;for(const [sidStr,data]of Object.entries(o))map.set(parseInt(sidStr,10),data);for(const [sid,act]of this._actsBySid)act._LoadFromJson(map.get(sid)||null)}_SaveVarsToJson(){const o={};for(const [sid,eventVar]of this._eventVarsBySid)if(!eventVar.IsConstant()&&(eventVar.IsGlobal()||eventVar.IsStatic()))o[sid.toString()]=
eventVar.GetValue();return o}_LoadVarsFromJson(o){for(const [sidStr,data]of Object.entries(o)){const sid=parseInt(sidStr,10);const eventVar=this.GetEventVariableBySID(sid);if(eventVar)eventVar.SetValue(data)}}_SaveScheduledWaitsToJson(){return this._scheduledWaits.filter(w=>!w.IsPromise()).map(w=>w._SaveToJson())}_LoadScheduledWaitsFromJson(arr){this.ClearAllScheduledWaits();for(const data of arr){const sw=C3.ScheduledWait._CreateFromJson(this,data);if(sw)this._scheduledWaits.push(sw)}}_GetPerfRecords(){return[...this._runtime.GetLayoutManager().runningLayouts()].map(l=>
l.GetEventSheet()).filter(eventSheet=>eventSheet).map(e=>e._GetPerfRecord())}FindFirstFunctionBlockParent(parent){while(parent){const scopeParent=parent.GetScopeParent();if(scopeParent instanceof C3.FunctionBlock)return scopeParent;parent=scopeParent}return null}_InvokeFunctionFromJS(name,params){if(!Array.isArray(params))params=[];const functionBlock=this.GetFunctionBlockByName(name.toLowerCase());if(!functionBlock)return null;if(!functionBlock.IsEnabled())return functionBlock.GetDefaultReturnValue();
const functionParameters=functionBlock.GetFunctionParameters();if(params.length<functionParameters.length){params=params.slice(0);do params.push(functionParameters[params.length].GetInitialValue());while(params.length<functionParameters.length)}const callEventBlock=functionBlock.GetEventBlock();return callEventBlock.RunAsExpressionFunctionCall(callEventBlock.GetSolModifiersIncludingParents(),false,functionBlock.GetReturnType(),functionBlock.GetDefaultReturnValue(),...params)}};

}

// events/eventSheet.js
{
'use strict';const C3=self.C3;
C3.EventSheet=class EventSheet extends C3.DefendedBase{constructor(eventSheetManager,data){super();this._eventSheetManager=eventSheetManager;this._runtime=eventSheetManager.GetRuntime();this._name=data[0];this._events=[];this._triggers=new Map;this._fastTriggers=new Map;this._eventsByDisplayNumber=new Map;this._hasRun=false;this._shallowIncludes=[];this._deepIncludes=[];this._alreadyIncludedSheets=new Set;for(const eventData of data[1])this._CreateEvent(eventData,null,this._events);this._perfRecord=
this._runtime.IsDebug()?{type:"sheet",name:this._name,totalTimeCounter:0,children:[]}:null}Release(){this._eventSheetManager=null;this._runtime=null}_CreateEvent(eventData,parent,nontriggers){switch(eventData[0]){case 0:case 3:this._CreateEventBlock(eventData,parent,nontriggers);break;case 1:this._CreateEventVariable(eventData,parent,nontriggers);break;case 2:this._CreateInclude(eventData,parent,nontriggers);break;case 4:this._CreateFunctionBlock(eventData,parent);break;case 5:this._CreateScriptBlock(eventData,
parent,nontriggers);break;case 6:this._CreateCustomACEBlock(eventData,parent);break;default:throw new Error("invalid event type");}}_CreateEventBlock(data,parent,nontriggers){const eventBlock=C3.EventBlock.Create(this,parent,data);if(eventBlock.IsOrBlock()){nontriggers.push(eventBlock);const conditions=eventBlock.GetConditions();for(let i=0,len=conditions.length;i<len;++i)if(conditions[i].IsTrigger())this._InitTrigger(eventBlock,i)}else if(eventBlock.IsTrigger())this._InitTrigger(eventBlock,0);else nontriggers.push(eventBlock)}_CreateFunctionBlock(data,
parent){const functionBlock=C3.FunctionBlock.CreateFunctionBlock(this,parent,data);this._eventSheetManager._RegisterFunctionBlock(functionBlock)}_CreateCustomACEBlock(data,parent){const customAceBlock=C3.FunctionBlock.CreateCustomACEBlock(this,parent,data);this._eventSheetManager._RegisterFunctionBlock(customAceBlock)}_CreateEventVariable(data,parent,nontriggers){const v=C3.EventVariable.Create(this,parent,data);nontriggers.push(v)}_CreateInclude(data,parent,nontriggers){const include=C3.EventInclude.Create(this,
parent,data);nontriggers.push(include)}_CreateScriptBlock(data,parent,nontriggers){const scriptBlock=C3.EventScript.Create(this,parent,data);nontriggers.push(scriptBlock)}_InitTrigger(eventBlock,i){if(!eventBlock.IsOrBlock())this._eventSheetManager._AddTriggerToPostInit(eventBlock);const cnd=eventBlock.GetConditionAt(i);const func=cnd._GetFunc();const objectClass=cnd.GetObjectClass();if(cnd.IsFastTrigger()){let methodMap=this._fastTriggers.get(objectClass);if(!methodMap){methodMap=new Map;this._fastTriggers.set(objectClass,
methodMap)}const value=cnd.GetFastTriggerValue().toLowerCase();let valueMap=methodMap.get(func);if(!valueMap){valueMap=new Map;methodMap.set(func,valueMap)}let triggerArr=valueMap.get(value);if(!triggerArr){triggerArr=[];valueMap.set(value,triggerArr)}triggerArr.push([eventBlock,i])}else{let ocInfo=this._triggers.get(objectClass);if(!ocInfo){ocInfo={methodMap:new Map,behaviors:new Map};this._triggers.set(objectClass,ocInfo)}const behaviorType=cnd.GetBehaviorType();let methodMap;if(behaviorType){methodMap=
ocInfo.behaviors.get(behaviorType);if(!methodMap){methodMap=new Map;ocInfo.behaviors.set(behaviorType,methodMap)}}else methodMap=ocInfo.methodMap;let triggerArr=methodMap.get(func);if(!triggerArr){triggerArr=[];methodMap.set(func,triggerArr)}triggerArr.push([eventBlock,i])}}_PostInit(){const events=this._events;for(let i=0,len=events.length;i<len;++i){const hasElseBlock=i<len-1&&events[i+1]instanceof C3.EventBlock&&events[i+1].IsElseBlock();events[i]._PostInit(hasElseBlock)}}_AddShallowInclude(include){this._shallowIncludes.push(include)}_UpdateDeepIncludes(){C3.clearArray(this._deepIncludes);
this._AddDeepIncludes(this);this._alreadyIncludedSheets.clear()}_AddDeepIncludes(rootSheet){const deepIncludes=rootSheet._deepIncludes;const alreadyIncludedSheets=rootSheet._alreadyIncludedSheets;for(const include of this._shallowIncludes){const sheet=include.GetIncludeSheet();if(!include.IsActive()||rootSheet===sheet||alreadyIncludedSheets.has(sheet))continue;alreadyIncludedSheets.add(sheet);sheet._AddDeepIncludes(rootSheet);deepIncludes.push(sheet)}}deepIncludes(){return this._deepIncludes}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}GetName(){return this._name}_RegisterEventByDisplayNumber(eventBlock,
displayNumber){this._eventsByDisplayNumber.set(displayNumber,eventBlock)}_GetEventByDisplayNumber(displayNumber){return this._eventsByDisplayNumber.get(displayNumber)||null}_ResetHasRunFlag(){this._hasRun=false}Run(){if(this._hasRun)return;const runtime=this._runtime;const profile=runtime.IsCPUProfiling();const startTime=profile?performance.now():0;this._hasRun=true;const eventSheetManager=this.GetEventSheetManager();const frame=eventSheetManager.GetCurrentEventStackFrame();for(const e of this._events){e.Run(frame);
eventSheetManager.ClearSol(e.GetSolModifiers());eventSheetManager.ClearAsyncActionPromises();runtime.FlushPendingInstances()}frame.Reset(null);if(profile)this._perfRecord.totalTimeCounter+=performance.now()-startTime}*DebugRun(){if(this._hasRun)return;this._hasRun=true;const runtime=this._runtime;const eventSheetManager=this.GetEventSheetManager();const frame=eventSheetManager.GetCurrentEventStackFrame();for(const e of this._events){yield*e.DebugRun(frame);eventSheetManager.ClearSol(e.GetSolModifiers());
eventSheetManager.ClearAsyncActionPromises();runtime.FlushPendingInstances()}frame.Reset(null)}_Trigger(method,inst,behaviorType){if(inst){const objectClass=inst.GetObjectClass();let ret=false;let r=this._TriggerForClass(method,inst,objectClass,behaviorType);ret=ret||r;for(const family of objectClass.GetFamilies()){r=this._TriggerForClass(method,inst,family,behaviorType);ret=ret||r}}else return this._TriggerForClass(method,inst,null,null)}_TriggerForClass(method,inst,objectClass,behaviorType){const ocInfo=
this._triggers.get(objectClass);if(!ocInfo)return false;const methodMap=behaviorType?ocInfo.behaviors.get(behaviorType):ocInfo.methodMap;if(!methodMap)return false;const triggerList=methodMap.get(method);if(!triggerList)return false;let ret=false;for(const [trigger,index]of triggerList){const r=this._ExecuteTrigger(inst,trigger,index);ret=ret||r}return ret}*_DebugTrigger(method,inst,behaviorType){if(inst){const objectClass=inst.GetObjectClass();let ret=false;let r=yield*this._DebugTriggerForClass(method,
inst,objectClass,behaviorType);ret=ret||r;for(const family of objectClass.GetFamilies()){r=yield*this._DebugTriggerForClass(method,inst,family,behaviorType);ret=ret||r}}else return yield*this._DebugTriggerForClass(method,inst,null,null)}*_DebugTriggerForClass(method,inst,objectClass,behaviorType){const ocInfo=this._triggers.get(objectClass);if(!ocInfo)return false;const methodMap=behaviorType?ocInfo.behaviors.get(behaviorType):ocInfo.methodMap;if(!methodMap)return false;const triggerList=methodMap.get(method);
if(!triggerList)return false;let ret=false;for(const [trigger,index]of triggerList){let r;if(trigger.DebugCanRunFast())r=this._ExecuteTrigger(inst,trigger,index);else r=yield*this._DebugExecuteTrigger(inst,trigger,index);ret=ret||r}return ret}_FastTrigger(method,inst,value){const objectClass=inst.GetObjectClass();const methodMap=this._fastTriggers.get(objectClass);if(!methodMap)return false;const valueMap=methodMap.get(method);if(!valueMap)return false;const triggerList=valueMap.get(value);if(!triggerList)return false;
let ret=false;for(let i=0,len=triggerList.length;i<len;++i){const t=triggerList[i];const r=this._ExecuteTrigger(null,t[0],t[1]);ret=ret||r}return ret}*_DebugFastTrigger(method,inst,value){const objectClass=inst.GetObjectClass();const methodMap=this._fastTriggers.get(objectClass);if(!methodMap)return false;const valueMap=methodMap.get(method);if(!valueMap)return false;const triggerList=valueMap.get(value);if(!triggerList)return false;let ret=false;for(let i=0,len=triggerList.length;i<len;++i){const t=
triggerList[i];const trigger=t[0];const index=t[1];let r;if(trigger.DebugCanRunFast())r=this._ExecuteTrigger(null,trigger,index);else r=yield*this._DebugExecuteTrigger(null,trigger,index);ret=ret||r}return ret}_ExecuteTrigger(inst,trigger,index){const runtime=this._runtime;const eventSheetManager=this._eventSheetManager;const currentEvent=eventSheetManager.GetCurrentEvent();const eventStack=eventSheetManager.GetEventStack();const triggerDepth=eventSheetManager.GetTriggerDepth();let ret=false;if(currentEvent)eventSheetManager.PushCleanSol(currentEvent.GetSolModifiersIncludingParents());
eventSheetManager.PushCleanSol(trigger.GetSolModifiersIncludingParents());const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();const frame=eventStack.Push(trigger);if(inst){const objectClass=trigger.GetConditions()[index].GetObjectClass();const sol=objectClass.GetCurrentSol();sol.SetSinglePicked(inst);if(inst.IsInContainer())inst.SetSiblingsSinglePicked()}let okToRun=true;if(trigger.GetParent()){const parents=trigger.GetTriggerParents();for(let i=0,len=parents.length;i<
len;++i)if(!parents[i].RunPreTrigger(frame)){okToRun=false;break}}if(okToRun){if(trigger.IsOrBlock())trigger.RunOrBlockTrigger(frame,index);else trigger.Run(frame);ret=frame.GetLastEventTrue()}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();eventSheetManager.PopSol(trigger.GetSolModifiersIncludingParents());if(currentEvent)eventSheetManager.PopSol(currentEvent.GetSolModifiersIncludingParents());if(!currentEvent&&triggerDepth===1){eventSheetManager.ClearAsyncActionPromises();
if(!eventSheetManager.IsFlushingBlocked())runtime.FlushPendingInstances()}return ret}*_DebugExecuteTrigger(inst,trigger,index){const runtime=this._runtime;const eventSheetManager=this._eventSheetManager;const currentEvent=eventSheetManager.GetCurrentEvent();const eventStack=eventSheetManager.GetEventStack();const triggerDepth=eventSheetManager.GetTriggerDepth();let ret=false;if(currentEvent)eventSheetManager.PushCleanSol(currentEvent.GetSolModifiersIncludingParents());eventSheetManager.PushCleanSol(trigger.GetSolModifiersIncludingParents());
const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();const frame=eventStack.Push(trigger);if(inst){const objectClass=trigger.GetConditions()[index].GetObjectClass();const sol=objectClass.GetCurrentSol();sol.SetSinglePicked(inst);if(inst.IsInContainer())inst.SetSiblingsSinglePicked()}let okToRun=true;if(trigger.GetParent()){const parents=trigger.GetTriggerParents();for(let i=0,len=parents.length;i<len;++i)if(!(yield*parents[i].DebugRunPreTrigger(frame))){okToRun=
false;break}}if(okToRun){if(trigger.IsOrBlock())yield*trigger.DebugRunOrBlockTrigger(frame,index);else yield*trigger.DebugRun(frame);ret=frame.GetLastEventTrue()}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();eventSheetManager.PopSol(trigger.GetSolModifiersIncludingParents());if(currentEvent)eventSheetManager.PopSol(currentEvent.GetSolModifiersIncludingParents());if(!currentEvent&&triggerDepth===1){eventSheetManager.ClearAsyncActionPromises();if(!eventSheetManager.IsFlushingBlocked())runtime.FlushPendingInstances()}return ret}_GetPerfRecord(){return this._perfRecord}};

}

// events/eventBlock.js
{
'use strict';const C3=self.C3;const EMPTY_ARRAY=[];function NoActions(frame,index){return true}function*DebugNoActions(frame,index){return true}
C3.EventBlock=class EventBlock extends C3.DefendedBase{constructor(eventSheet,parent,data){super();this._eventSheet=eventSheet;this._runtime=eventSheet.GetRuntime();this._parent=parent;this._scopeParent=null;this._eventStack=this._runtime.GetEventSheetManager().GetEventStack();this._solModifiers=[];this._solModifiersIncludingParents=[];this._hasGotSolModifiersIncludingParents=false;this._isSolWriterAfterCnds=false;this._isTopLevelGroup=false;this._hasElseBlock=false;this._isOrBlock=!!data[2];this._isElseBlock=
false;this._triggerParents=null;this._conditions=[];this._actions=[];this._subEvents=[];this._RunActions=NoActions;this._DebugRunActions=DebugNoActions;this._isGroup=false;this._isInitiallyActive=false;this._groupName="";this._isGroupActive=false;this._containedIncludes=null;this._perfRecord=null;this._sid=data[4];this._displayNumber=data[5];this._eventSheet._RegisterEventByDisplayNumber(this,this._displayNumber);this._debugData=this._runtime.IsDebug()?{isBreakpoint:data[3][0],isBreakable:data[3][1],
canRunAllConditionsFast:false,canRunAllActionsFast:false,canRunAllSubEventsFast:false,canRunSelfFast:false}:null;this.GetEventSheetManager()._RegisterEventBlock(this);if(data[0]===3)this._InitGroup(data[1]);let index=0;for(const cndData of data[6]){const condition=C3.Condition.Create(this,cndData,index++);this._conditions.push(condition);this._AddSolModifier(condition.GetObjectClass())}index=0;for(const actData of data[7]){const action=C3.Action.Create(this,actData,index++);this._actions.push(action)}if(data.length===
9){const subEventsData=data[8];for(const eventData of subEventsData)this._eventSheet._CreateEvent(eventData,this,this._subEvents)}if(this._conditions.length)this._isElseBlock=this._conditions[0].GetObjectClass()===null&&this._conditions[0]._GetFunc()===C3.Plugins.System.Cnds.Else;if(this._conditions.length===0)this._conditions=EMPTY_ARRAY;if(this._actions.length===0)this._actions=EMPTY_ARRAY;if(this._subEvents.length===0)this._subEvents=EMPTY_ARRAY}static Create(eventSheet,parent,data){return C3.New(C3.EventBlock,
eventSheet,parent,data)}_InitGroup(groupData){this._isGroup=true;this._isInitiallyActive=!!groupData[0];this._isGroupActive=this._isInitiallyActive;this._groupName=groupData[1].toLowerCase();this._containedIncludes=[];this.GetEventSheetManager()._RegisterGroup(this);if(this._runtime.IsDebug())this._perfRecord={type:"group",name:groupData[1],totalTimeCounter:0,children:[]}}_AddContainedInclude(include){this._containedIncludes.push(include)}_AddContainerSolModifierToList(objectClass,arr){for(const containerType of objectClass.GetContainer().objectTypes())if(!arr.includes(containerType))arr.push(containerType)}_AddSolModifierToList(objectClass,
arr){if(!objectClass)return;if(!arr.includes(objectClass))arr.push(objectClass);if(objectClass.IsFamily())for(const familyMember of objectClass.GetFamilyMembers()){if(familyMember.IsInContainer())this._AddContainerSolModifierToList(familyMember,arr)}else if(objectClass.IsInContainer())this._AddContainerSolModifierToList(objectClass,arr)}_AddSolModifier(objectClass){this._AddSolModifierToList(objectClass,this._solModifiers)}_AddParentSolModifier(objectClass){this._AddSolModifierToList(objectClass,
this._solModifiersIncludingParents)}SetAllSolModifiers(){this._solModifiers=this._runtime.GetAllObjectClasses()}_PostInit(hasElse){this._hasElseBlock=!!hasElse;this._IdentifyTopLevelGroup();this._IdentifyTriggerParents();for(const c of this._conditions)c._PostInit();if(this._actions.length>0){let hasAnyActionWithReturnType=false;for(const a of this._actions){a._PostInit();if(a.HasReturnType())hasAnyActionWithReturnType=true}if(hasAnyActionWithReturnType){this._RunActions=this._RunActions_ReturnValue;
this._DebugRunActions=this._DebugRunActions_ReturnValue}else{this._RunActions=this._RunActions_Fast;this._DebugRunActions=this._DebugRunActions_Fast}}const subEvents=this._subEvents;for(let i=0,len=subEvents.length;i<len;++i){const hasElseBlock=i<len-1&&subEvents[i+1]instanceof C3.EventBlock&&subEvents[i+1].IsElseBlock();subEvents[i]._PostInit(hasElseBlock)}if(this._debugData)this._UpdateCanRunFast();if(this._perfRecord)this._GetPerfRecordParent()._GetPerfRecord().children.push(this._perfRecord)}_GetPerfRecord(){return this._perfRecord}_GetPerfRecordParent(){let p=
this.GetParent();while(p){if(p.IsGroup())return p;p=p.GetParent()}return this._eventSheet}_UpdateCanRunFast(){const dd=this._debugData;dd.canRunAllConditionsFast=this._conditions.every(c=>c.DebugCanRunFast());dd.canRunAllActionsFast=this._actions.every(a=>a.DebugCanRunFast());dd.canRunAllSubEventsFast=this._subEvents.every(s=>s.DebugCanRunFast());dd.canRunSelfFast=dd.canRunAllConditionsFast&&dd.canRunAllActionsFast&&dd.canRunAllSubEventsFast}_UpdateCanRunFastRecursive(){let e=this;do{e._UpdateCanRunFast();
e=e.GetParent()}while(e)}_IdentifyTopLevelGroup(){if(!this.IsGroup())return;let p=this.GetParent();this._isTopLevelGroup=true;while(p){if(!p.IsGroup()){this._isTopLevelGroup=false;break}p=p.GetParent()}}_IdentifySolModifiersIncludingParents(){const allObjectClasses=this._runtime.GetAllObjectClasses();if(this._solModifiers===allObjectClasses)this._solModifiersIncludingParents=allObjectClasses;else{this._solModifiersIncludingParents=C3.cloneArray(this._solModifiers);let p=this.GetParent();while(p){for(const o of p._solModifiers)this._AddParentSolModifier(o);
p=p.GetParent()}const eventSheetManager=this.GetEventSheetManager();this._solModifiers=eventSheetManager._DeduplicateSolModifierList(this._solModifiers);this._solModifiersIncludingParents=eventSheetManager._DeduplicateSolModifierList(this._solModifiersIncludingParents)}}_IdentifyTriggerParents(){if(!this.HasAnyTriggeredCondition())return;this._triggerParents=[];let p=this.GetParent();while(p){this._triggerParents.push(p);p=p.GetParent()}this._triggerParents.reverse()}SetSolWriterAfterCnds(){this._isSolWriterAfterCnds=
true;if(this._parent)this._parent.SetSolWriterAfterCnds()}IsSolWriterAfterCnds(){return this._isSolWriterAfterCnds}GetSolModifiers(){return this._solModifiers}GetSolModifiersIncludingParents(){if(!this._hasGotSolModifiersIncludingParents){this._hasGotSolModifiersIncludingParents=true;this._IdentifySolModifiersIncludingParents()}return this._solModifiersIncludingParents}HasSolModifier(objectClass){return this._solModifiers.includes(objectClass)}GetTriggerParents(){return this._triggerParents}GetEventSheet(){return this._eventSheet}GetEventSheetManager(){return this._eventSheet.GetEventSheetManager()}GetRuntime(){return this._runtime}GetParent(){return this._parent}_SetScopeParent(p){this._scopeParent=
p}GetScopeParent(){return this._scopeParent||this._parent}GetDisplayNumber(){return this._displayNumber}IsDebugBreakable(){return this._debugData&&this._debugData.isBreakable}IsDebugBreakpoint(){return this.IsDebugBreakable()&&this._debugData.isBreakpoint}_SetDebugBreakpoint(b){this._debugData.isBreakpoint=!!b;this._UpdateCanRunFastRecursive()}IsGroup(){return this._isGroup}IsTopLevelGroup(){return this._isTopLevelGroup}IsElseBlock(){return this._isElseBlock}HasElseBlock(){return this._hasElseBlock}GetGroupName(){return this._groupName}IsGroupActive(){return this._isGroupActive}ResetInitialActivation(){this.SetGroupActive(this._isInitiallyActive)}SetGroupActive(a){a=
!!a;if(!this._isGroup)throw new Error("not a group");if(this._isGroupActive===a)return;this._isGroupActive=a;for(const include of this._containedIncludes)include.UpdateActive();if(this._containedIncludes.length){const currentLayout=this._runtime.GetCurrentLayout();const mainEventSheet=currentLayout.GetEventSheet();if(mainEventSheet)mainEventSheet._UpdateDeepIncludes()}}GetSID(){return this._sid}IsOrBlock(){return this._isOrBlock}IsTrigger(){return this._conditions.length&&this._conditions[0].IsTrigger()}IsForFunctionBlock(){return this._scopeParent&&
this._scopeParent instanceof C3.FunctionBlock}HasAnyTriggeredCondition(){return this.IsForFunctionBlock()||this._conditions.some(c=>c.IsTrigger())}GetConditions(){return this._conditions}GetConditionCount(){return this._conditions.length}GetConditionAt(i){i=Math.floor(i);if(i<0||i>=this._conditions.length)throw new RangeError("invalid condition index");return this._conditions[i]}GetConditionByDebugIndex(i){return this.GetConditionAt(i)}IsFirstConditionOfType(cnd){let i=cnd.GetIndex();if(i===0)return true;
--i;const cndObjectClass=cnd.GetObjectClass();for(;i>=0;--i){const c=this._conditions[i];if(c.GetObjectClass()===cndObjectClass||c.IsSystemCondition()&&c.GetFirstObjectParameterObjectClass()===cndObjectClass)return false}return true}GetActions(){return this._actions}GetActionCount(){return this._actions.length}GetActionAt(i){i=Math.floor(i);if(i<0||i>=this._actions.length)throw new RangeError("invalid action index");return this._actions[i]}GetActionByDebugIndex(i){i=Math.floor(i);const ret=this._actions.find(a=>
a.GetDebugIndex()===i);if(!ret)throw new RangeError("invalid action debug index");return ret}_HasActionIndex(i){i=Math.floor(i);return i>=0&&i<this._actions.length}GetSubEvents(){return this._subEvents}_GetAllLocalVariablesInScope(){return this._subEvents.filter(e=>e instanceof C3.EventVariable)}RunPreTrigger(frame){frame.SetCurrentEvent(this);const conditions=this._conditions;let isAnyTrue=conditions.length===0;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);
if(c.IsLooping())throw new Error("trigger cannot be used as sub-event to a loop");if(c.Run())isAnyTrue=true;else if(!this._isOrBlock)return false}return this._isOrBlock?isAnyTrue:true}RunOrBlockTrigger(frame,index){frame.SetCurrentEvent(this);if(this._conditions[index].Run()){if(this._RunActions(frame,0))this._RunSubEvents(frame);frame.SetLastEventTrue(true)}}*DebugRunPreTrigger(frame){frame.SetCurrentEvent(this);const conditions=this._conditions;let isAnyTrue=conditions.length===0;for(let i=0,len=
conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);if(c.IsLooping())throw new Error("trigger cannot be used as sub-event to a loop");let ret;if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();if(ret)isAnyTrue=true;else if(!this._isOrBlock)return false}return this._isOrBlock?isAnyTrue:true}*DebugRunOrBlockTrigger(frame,index){frame.SetCurrentEvent(this);const c=this._conditions[index];let ret;if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();if(ret){let actRet;
if(this.DebugCanRunActionsFast())actRet=this._RunActions(frame,0);else actRet=yield*this._DebugRunActions(frame,0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();else yield*this._DebugRunSubEvents();frame.SetLastEventTrue(true)}}Run(frame){frame.SetCurrentEvent(this);if(!this._isElseBlock)frame.SetElseBranchRan(false);if(this._isOrBlock)this._RunOrBlock(frame);else this._RunAndBlock(frame)}*DebugRun(frame){if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;frame.SetCurrentEvent(this);
if(!this._isElseBlock)frame.SetElseBranchRan(false);if(this._isOrBlock)yield*this._DebugRunOrBlock(frame);else yield*this._DebugRunAndBlock(frame)}_RunOrBlock(frame){const conditions=this._conditions;let isAnyTrue=conditions.length===0;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];if(c.IsTrigger())continue;frame.SetConditionIndex(i);const result=c.Run();isAnyTrue=isAnyTrue||result}frame.SetLastEventTrue(isAnyTrue);if(isAnyTrue){if(this._RunActions(frame,0))this._RunSubEvents(frame);
if(this._hasElseBlock)frame.SetElseBranchRan(true)}}*_DebugRunOrBlock(frame){const conditions=this._conditions;let isAnyTrue=conditions.length===0;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];if(c.IsTrigger())continue;frame.SetConditionIndex(i);let ret;if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();isAnyTrue=isAnyTrue||ret}frame.SetLastEventTrue(isAnyTrue);if(isAnyTrue){let actRet;if(this.DebugCanRunActionsFast())actRet=this._RunActions(frame,0);else actRet=yield*this._DebugRunActions(frame,
0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();else yield*this._DebugRunSubEvents();if(this._hasElseBlock)frame.SetElseBranchRan(true)}}_RunAndBlock(frame){const conditions=this._conditions;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);const result=c.Run();if(!result){frame.SetLastEventTrue(false);return}}frame.SetLastEventTrue(true);if(this._RunActions(frame,0))this._RunSubEvents(frame);if(frame.GetLastEventTrue()&&this._hasElseBlock)frame.SetElseBranchRan(true)}*_DebugRunAndBlock(frame){const conditions=
this._conditions;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);let ret;if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();if(!ret){frame.SetLastEventTrue(false);return}}frame.SetLastEventTrue(true);let actRet;if(this.DebugCanRunActionsFast())actRet=this._RunActions(frame,0);else actRet=yield*this._DebugRunActions(frame,0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();else yield*this._DebugRunSubEvents();if(frame.GetLastEventTrue()&&
this._hasElseBlock)frame.SetElseBranchRan(true)}_RunActions_Fast(frame,startIndex){const actions=this._actions;for(let i=startIndex,len=actions.length;i<len;++i){const a=actions[i];frame.SetActionIndex(i);a.Run()}return true}*_DebugRunActions_Fast(frame,startIndex){const actions=this._actions;for(let i=startIndex,len=actions.length;i<len;++i){const a=actions[i];frame.SetActionIndex(i);if(a.DebugCanRunFast())a.Run();else yield*a.DebugRun()}return true}_RunActions_ReturnValue(frame,startIndex){const eventSheetManager=
this.GetEventSheetManager();const actions=this._actions;for(let i=startIndex,len=actions.length;i<len;++i){const a=actions[i];frame.SetActionIndex(i);const ret=a.Run();if(a.CanBailOut()&&ret===true)return false;else if(a.IsAsync()&&ret instanceof Promise)eventSheetManager.AddAsyncActionPromise(ret)}return true}*_DebugRunActions_ReturnValue(frame,startIndex){const eventSheetManager=this.GetEventSheetManager();const actions=this._actions;for(let i=startIndex,len=actions.length;i<len;++i){const a=actions[i];
frame.SetActionIndex(i);let ret;if(a.DebugCanRunFast())ret=a.Run();else ret=yield*a.DebugRun();if(a.CanBailOut()&&ret===true)return false;else if(a.IsAsync()&&ret instanceof Promise)eventSheetManager.AddAsyncActionPromise(ret)}return true}_ResumeActionsAndSubEvents(frame){if(this._RunActions(frame,frame.GetActionIndex()))this._RunSubEvents()}*_DebugResumeActionsAndSubEvents(frame){if(yield*this._DebugRunActions(frame,frame.GetActionIndex()))yield*this._DebugRunSubEvents()}_RunSubEvents(){if(!this._subEvents.length)return;
const profile=this.IsGroup()&&this._runtime.IsCPUProfiling();const startTime=profile?performance.now():0;const eventStack=this._eventStack;const frame=eventStack.Push(this);if(this._isSolWriterAfterCnds)this._RunSubEvents_SolWriterAfterCnds(frame);else this._RunSubEvents_Fast(frame);eventStack.Pop();if(profile)this._perfRecord.totalTimeCounter+=performance.now()-startTime}_RunSubEvents_SolWriterAfterCnds(frame){const isGroup=this._isGroup;const isTopLevelGroup=this._isTopLevelGroup;const eventSheetManager=
this.GetEventSheetManager();const subEvents=this._subEvents;for(let i=0,len=subEvents.length,last=len-1;i<len;++i){const e=subEvents[i];const solModifiers=e.GetSolModifiers();const copySol=!isTopLevelGroup||!isGroup&&i<last;if(copySol)eventSheetManager.PushCopySol(solModifiers);e.Run(frame);if(copySol)eventSheetManager.PopSol(solModifiers);else eventSheetManager.ClearSol(solModifiers)}}_RunSubEvents_Fast(frame){const subEvents=this._subEvents;for(let i=0,len=subEvents.length;i<len;++i)subEvents[i].Run(frame)}*_DebugRunSubEvents(){if(!this._subEvents.length)return;
const eventStack=this._eventStack;const frame=eventStack.Push(this);if(this._isSolWriterAfterCnds)yield*this._DebugRunSubEvents_SolWriterAfterCnds(frame);else yield*this._DebugRunSubEvents_Fast(frame);eventStack.Pop()}*_DebugRunSubEvents_SolWriterAfterCnds(frame){const isGroup=this._isGroup;const isTopLevelGroup=this._isTopLevelGroup;const eventSheetManager=this.GetEventSheetManager();const subEvents=this._subEvents;for(let i=0,len=subEvents.length,last=len-1;i<len;++i){const e=subEvents[i];const solModifiers=
e.GetSolModifiers();const copySol=!isTopLevelGroup||!isGroup&&i<last;if(copySol)eventSheetManager.PushCopySol(solModifiers);yield*e.DebugRun(frame);if(copySol)eventSheetManager.PopSol(solModifiers);else eventSheetManager.ClearSol(solModifiers)}}*_DebugRunSubEvents_Fast(frame){const subEvents=this._subEvents;for(let i=0,len=subEvents.length;i<len;++i)yield*subEvents[i].DebugRun(frame)}Retrigger(oldFrame,newFrame){newFrame.ResetQuick();const conditions=this._conditions;if(!this.IsOrBlock())for(let i=
oldFrame.GetConditionIndex()+1,len=conditions.length;i<len;++i){const c=conditions[i];newFrame.SetConditionIndex(i);const result=c.Run();if(!result)return false}if(this._RunActions(newFrame,0))this._RunSubEvents(newFrame);return true}*DebugRetrigger(oldFrame,newFrame){newFrame.ResetQuick();const conditions=this._conditions;if(!this.IsOrBlock())for(let i=oldFrame.GetConditionIndex()+1,len=conditions.length;i<len;++i){const c=conditions[i];newFrame.SetConditionIndex(i);let ret;if(c.DebugCanRunFast())ret=
c.Run();else ret=yield*c.DebugRun();if(!ret)return false}let actRet;if(this.DebugCanRunActionsFast())actRet=this._RunActions(newFrame,0);else actRet=yield*this._DebugRunActions(newFrame,0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();else yield*this._DebugRunSubEvents();return true}DebugCanRunFast(){return!this.IsDebugBreakpoint()&&!this._runtime.DebugBreakNext()&&this._debugData.canRunSelfFast}DebugCanRunActionsFast(){return!this._runtime.DebugBreakNext()&&this._debugData.canRunAllActionsFast}DebugCanRunSubEventsFast(){return!this._runtime.DebugBreakNext()&&
this._debugData.canRunAllSubEventsFast}_CheckParentsOKToRun(frame){if(this.GetParent()){const parents=this.GetTriggerParents();for(let i=0,len=parents.length;i<len;++i)if(!parents[i].RunPreTrigger(frame))return false}return true}*_DebugCheckParentsOKToRun(frame){if(this.GetParent()){const parents=this.GetTriggerParents();for(let i=0,len=parents.length;i<len;++i)if(!(yield*parents[i].DebugRunPreTrigger(frame)))return false}return true}_EvaluateFunctionCallParameters(eventSheetManager,parameters,isRecursive){if(parameters.length>
0)if(isRecursive){const paramResults=parameters.map(p=>p.Get(0));eventSheetManager.GetLocalVarStack().Push();this._scopeParent.SetFunctionParameters(paramResults)}else this._scopeParent.EvaluateFunctionParameters(parameters);else if(isRecursive)eventSheetManager.GetLocalVarStack().Push()}RunAsFunctionCall(combinedSolModifiers,parameters,isCopyPicked,pickInfo){let ret;let asyncId;const hasAnySolModifiers=combinedSolModifiers.length>0;let extraPopSolModifiers=null;const runtime=this._runtime;const eventStack=
this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;this._EvaluateFunctionCallParameters(eventSheetManager,parameters,isRecursive);if(hasAnySolModifiers)if(isCopyPicked)eventSheetManager.PushCopySol(combinedSolModifiers);else eventSheetManager.PushCleanSol(combinedSolModifiers);if(pickInfo!==null){if(pickInfo.copyFromObjectClass){const copyFromSol=isCopyPicked?pickInfo.copyFromObjectClass.GetCurrentSol():
pickInfo.copyFromObjectClass.GetSolStack().GetOneBelowCurrentSol();const copyToSol=pickInfo.copyToObjectClass.GetCurrentSol();copyToSol.SetArrayPicked(copyFromSol.GetInstances());copyToSol.ClearElseInstances();if(!isCopyPicked)pickInfo.copyToObjectClass.ApplySolToContainer()}else if(pickInfo.pickObjectClass){const objectClassSol=pickInfo.pickObjectClass.GetCurrentSol();objectClassSol.SetArrayPicked(pickInfo.pickInstances);objectClassSol.ClearElseInstances()}if(pickInfo.pushCleanSolDynamic)extraPopSolModifiers=
eventSheetManager.PushCleanSolDynamic(combinedSolModifiers)}const frame=eventStack.Push(this);if(isCopyPicked)frame.SetDynamicSolModifiers(combinedSolModifiers);if(this._CheckParentsOKToRun(frame)){frame.SetCurrentEvent(this);const isAsync=this._scopeParent.IsAsync();if(isAsync)[asyncId,ret]=this._scopeParent.StartAsyncFunctionCall();this._RunAndBlock(frame);if(isAsync)this._scopeParent.MaybeFinishAsyncFunctionCall(asyncId)}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();
if(extraPopSolModifiers!==null)eventSheetManager.PopSol(extraPopSolModifiers);if(hasAnySolModifiers)eventSheetManager.PopSol(combinedSolModifiers);eventSheetManager._DecTriggerDepth();return ret}*DebugRunAsFunctionCall(combinedSolModifiers,parameters,isCopyPicked,pickInfo){let ret;let asyncId;if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;const hasAnySolModifiers=combinedSolModifiers.length>0;let extraPopSolModifiers=null;const runtime=this._runtime;const eventStack=this._eventStack;
const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;this._EvaluateFunctionCallParameters(eventSheetManager,parameters,isRecursive);if(hasAnySolModifiers)if(isCopyPicked)eventSheetManager.PushCopySol(combinedSolModifiers);else eventSheetManager.PushCleanSol(combinedSolModifiers);if(pickInfo!==null){if(pickInfo.copyFromObjectClass){const copyFromSol=isCopyPicked?pickInfo.copyFromObjectClass.GetCurrentSol():pickInfo.copyFromObjectClass.GetSolStack().GetOneBelowCurrentSol();
const copyToSol=pickInfo.copyToObjectClass.GetCurrentSol();copyToSol.SetArrayPicked(copyFromSol.GetInstances());copyToSol.ClearElseInstances();if(!isCopyPicked)pickInfo.copyToObjectClass.ApplySolToContainer()}else if(pickInfo.pickObjectClass){const objectClassSol=pickInfo.pickObjectClass.GetCurrentSol();objectClassSol.SetArrayPicked(pickInfo.pickInstances);objectClassSol.ClearElseInstances()}if(pickInfo.pushCleanSolDynamic)extraPopSolModifiers=eventSheetManager.PushCleanSolDynamic(combinedSolModifiers)}const frame=
eventStack.Push(this);if(isCopyPicked)frame.SetDynamicSolModifiers(combinedSolModifiers);if(yield*this._DebugCheckParentsOKToRun(frame)){frame.SetCurrentEvent(this);const isAsync=this._scopeParent.IsAsync();if(isAsync)[asyncId,ret]=this._scopeParent.StartAsyncFunctionCall();yield*this._DebugRunAndBlock(frame);if(isAsync)this._scopeParent.MaybeFinishAsyncFunctionCall(asyncId)}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(extraPopSolModifiers!==null)eventSheetManager.PopSol(extraPopSolModifiers);
if(hasAnySolModifiers)eventSheetManager.PopSol(combinedSolModifiers);eventSheetManager._DecTriggerDepth();return ret}RunAsMappedFunctionCall(paramResults,isCopyPicked){const solModifiers=this.GetSolModifiersIncludingParents();const hasAnySolModifiers=solModifiers.length>0;const runtime=this._runtime;const eventStack=this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();
this._scopeParent.SetFunctionParameters(paramResults);if(hasAnySolModifiers)if(isCopyPicked)eventSheetManager.PushCopySol(solModifiers);else eventSheetManager.PushCleanSol(solModifiers);const frame=eventStack.Push(this);if(this._CheckParentsOKToRun(frame)){frame.SetCurrentEvent(this);this._RunAndBlock(frame)}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(solModifiers);eventSheetManager._DecTriggerDepth()}*DebugRunAsMappedFunctionCall(paramResults,
isCopyPicked){if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;const solModifiers=this.GetSolModifiersIncludingParents();const hasAnySolModifiers=solModifiers.length>0;const runtime=this._runtime;const eventStack=this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();this._scopeParent.SetFunctionParameters(paramResults);
if(hasAnySolModifiers)if(isCopyPicked)eventSheetManager.PushCopySol(solModifiers);else eventSheetManager.PushCleanSol(solModifiers);const frame=eventStack.Push(this);if(yield*this._DebugCheckParentsOKToRun(frame)){frame.SetCurrentEvent(this);yield*this._DebugRunAndBlock(frame)}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(solModifiers);eventSheetManager._DecTriggerDepth()}RunAsExpressionFunctionCall(combinedSolModifiers,isCopyPicked,
returnType,defaultReturnValue,...paramResults){let ret;let asyncId;const hasAnySolModifiers=combinedSolModifiers.length>0;const runtime=this._runtime;const eventStack=this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();if(paramResults.length>0)this._scopeParent.SetFunctionParameters(paramResults);if(hasAnySolModifiers)if(isCopyPicked)eventSheetManager.PushCopySol(combinedSolModifiers);
else eventSheetManager.PushCleanSol(combinedSolModifiers);const frame=eventStack.Push(this);frame.InitCallFunctionExpression(returnType,defaultReturnValue);eventStack.PushExpFunc(frame);runtime.SetDebuggingEnabled(false);if(this._CheckParentsOKToRun(frame)){frame.SetCurrentEvent(this);const isAsync=this._scopeParent.IsAsync();if(isAsync)[asyncId,ret]=this._scopeParent.StartAsyncFunctionCall();this._RunAndBlock(frame);if(isAsync)this._scopeParent.MaybeFinishAsyncFunctionCall(asyncId)}runtime.SetDebuggingEnabled(true);
eventStack.Pop();eventStack.PopExpFunc();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(combinedSolModifiers);eventSheetManager._DecTriggerDepth();return ret||frame.GetFunctionReturnValue()}};

}

// events/eventScript.js
{
'use strict';const C3=self.C3;const EMPTY_SOL_MODIFIERS=[];let hadUserScriptException=false;
C3.EventScript=class EventScript extends C3.DefendedBase{constructor(eventSheet,parent,data){super();const runtime=eventSheet.GetRuntime();const eventSheetManager=eventSheet.GetEventSheetManager();this._eventSheet=eventSheet;this._eventSheetManager=eventSheetManager;this._runtime=eventSheet.GetRuntime();this._parent=parent;const userMethod=runtime.GetObjectReference(data[1]);this._func=userMethod;this._displayNumber=data[2];this._eventSheet._RegisterEventByDisplayNumber(this,this._displayNumber);
this._debugData=runtime.IsDebug()?{isBreakpoint:data[3][0],isBreakable:data[3][1]}:null}static Create(eventSheet,parent,data){return C3.New(C3.EventScript,eventSheet,parent,data)}_PostInit(){const userMethod=this._func;const localVars=this._runtime.GetEventSheetManager()._GetLocalVariablesScriptInterface(this);this._func=userMethod.bind(null,this._runtime.GetIRuntime(),localVars)}GetParent(){return this._parent}GetScopeParent(){return this._parent}GetEventSheet(){return this._eventSheet}GetDisplayNumber(){return this._displayNumber}IsDebugBreakable(){return this._debugData&&
this._debugData.isBreakable}IsDebugBreakpoint(){return this.IsDebugBreakable()&&this._debugData.isBreakpoint}_SetDebugBreakpoint(b){this._debugData.isBreakpoint=!!b}IsElseBlock(){return false}GetSolModifiers(){return EMPTY_SOL_MODIFIERS}GetSolModifiersIncludingParents(){if(this._parent)return this._parent.GetSolModifiersIncludingParents();else return EMPTY_SOL_MODIFIERS}Run(frame){frame.SetCurrentEvent(this);this._eventSheetManager.AddAsyncActionPromise(this._RunUserScript())}async _RunUserScript(){try{await this._func()}catch(err){console.error(`Unhandled exception running script %c${this.GetEventSheet().GetName()}, event ${this.GetDisplayNumber()}:`,
"font-size: 1.2em; font-weight: bold;",err);if(self.C3Debugger)self.C3Debugger._SetLastErrorScript(this);if(!hadUserScriptException){console.info(`%cTip:%c run this to highlight in Construct the last script that had an error: %cgoToLastErrorScript()`,"font-weight: bold; text-decoration: underline","","font-weight: bold");hadUserScriptException=true}}}*DebugRun(frame){frame.SetCurrentEvent(this);if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;this.Run(frame)}DebugCanRunFast(){return!this.IsDebugBreakpoint()&&
!this._runtime.DebugBreakNext()}static HadUserScriptException(){return hadUserScriptException}static SetHadUserScriptException(){hadUserScriptException=true}};

}

// events/functionBlock.js
{
'use strict';const C3=self.C3;const assert=self.assert;
C3.FunctionBlock=class FunctionBlock extends C3.DefendedBase{constructor(eventSheet,parent,data){super();this._eventSheet=eventSheet;this._runtime=eventSheet.GetRuntime();this._parent=parent;this._functionType=0;this._functionName="";this._returnType=0;this._functionParameters=[];this._isEnabled=true;this._aceName="";this._objectClass=null;this._hasOverrides=false;this._innerLocalVariables=[];this._isCopyPicked=false;this._isAsync=false;this._nextAsyncId=0;this._currentAsyncId=-1;this._asyncMap=new Map;
this._eventBlock=C3.EventBlock.Create(eventSheet,parent,data);this._eventBlock._SetScopeParent(this)}InitFunctionBlock(funcData){this._functionType=0;this._functionName=funcData[0];this._returnType=funcData[1];this._functionParameters=funcData[2].map(paramData=>C3.EventVariable.Create(this._eventSheet,this,paramData));this._isEnabled=funcData[3];this._isAsync=funcData[4];this._isCopyPicked=funcData[5]}InitCustomACEBlock(funcData){this._functionType=1;this._aceName=funcData[1];this._objectClass=this._runtime.GetObjectClassByIndex(funcData[2]);
this._eventBlock._AddSolModifier(this._objectClass);this._functionName=this._objectClass.GetName()+"."+this._aceName;this._returnType=funcData[3];this._functionParameters=funcData[4].map(paramData=>C3.EventVariable.Create(this._eventSheet,this,paramData));this._isEnabled=funcData[5];this._isAsync=funcData[6];this._isCopyPicked=funcData[7];this._objectClass.AddCustomAction(this)}static CreateFunctionBlock(eventSheet,parent,data){const ret=C3.New(C3.FunctionBlock,eventSheet,parent,data);const funcData=
data[1];ret.InitFunctionBlock(funcData);return ret}static CreateCustomACEBlock(eventSheet,parent,data){const ret=C3.New(C3.FunctionBlock,eventSheet,parent,data);const funcData=data[1];ret.InitCustomACEBlock(funcData);return ret}_CheckOverrideState(){if(this._objectClass&&this._objectClass.IsFamily())for(const objectType of this._objectClass.GetFamilyMembers())if(objectType.HasOwnCustomActionByName(this._aceName)){this._hasOverrides=true;break}}_PostInit(){for(const fp of this._functionParameters)fp._PostInit();
this._eventBlock._PostInit(false)}GetFunctionType(){return this._functionType}_GetAllLocalVariablesInScope(){return this._functionParameters}GetFunctionParameters(){return this._functionParameters}GetFunctionParameterCount(){return this._functionParameters.length}_RegisterLocalVariable(localVariable){this._innerLocalVariables.push(localVariable)}_GetAllInnerLocalVariables(){return this._innerLocalVariables}EvaluateFunctionParameters(parameters){const functionParameters=this._functionParameters;for(let i=
0,len=functionParameters.length;i<len;++i)functionParameters[i].SetValue(parameters[i].Get(0))}SetFunctionParameters(paramResults){const functionParameters=this._functionParameters;for(let i=0,len=functionParameters.length;i<len;++i)functionParameters[i].SetValue(paramResults[i])}CaptureFunctionParameters(){return this._functionParameters.map(p=>p.GetValue())}GetParent(){return this._parent}GetScopeParent(){return this._parent}GetFunctionName(){return this._functionName}GetACEName(){return this._aceName}HasCustomACEOverrides(){return this._hasOverrides}GetReturnType(){return this._returnType}GetObjectClass(){return this._objectClass}IsEnabled(){return this._isEnabled}GetDefaultReturnValue(){switch(this._returnType){case 0:return null;
case 2:return"";default:return 0}}GetEventBlock(){return this._eventBlock}IsCopyPicked(){return this._isCopyPicked}IsAsync(){return this._isAsync}StartAsyncFunctionCall(){const asyncId=this._nextAsyncId++;this._currentAsyncId=asyncId;let resolve;const promise=new Promise(r=>resolve=r);this._asyncMap.set(asyncId,{resolve,pauseCount:0});return[asyncId,promise]}MaybeFinishAsyncFunctionCall(asyncId){const info=this._asyncMap.get(asyncId);if(info.pauseCount===0){info.resolve();this._asyncMap.delete(asyncId)}this._currentAsyncId=
-1}PauseCurrentAsyncFunction(){const info=this._asyncMap.get(this._currentAsyncId);info.pauseCount++;return this._currentAsyncId}ResumeAsyncFunction(asyncId){this._currentAsyncId=asyncId;const info=this._asyncMap.get(asyncId);info.pauseCount--}RunAsFamilyCustomActionWithOverrides(combinedSolModifiers,parameters){const objectTypeMap=new Map;const familyInstances=[];for(const inst of this._objectClass.GetCurrentSol().GetInstances()){const objectType=inst.GetObjectClass();if(objectType.HasOwnCustomActionByName(this._aceName)){const arr=
objectTypeMap.get(objectType);if(Array.isArray(arr))arr.push(inst);else objectTypeMap.set(objectType,[inst])}else familyInstances.push(inst)}if(familyInstances.length>0)this._eventBlock.RunAsFunctionCall(combinedSolModifiers,parameters,this._isCopyPicked,{pickObjectClass:this._objectClass,pickInstances:familyInstances});if(objectTypeMap.size>0)for(const [objectType,arr]of objectTypeMap){const eventBlock=objectType.GetOwnCustomActionByName(this._aceName).GetEventBlock();const allCombinedSolModifiers=
[...(new Set([...combinedSolModifiers,...eventBlock.GetSolModifiers()]))];eventBlock.RunAsFunctionCall(allCombinedSolModifiers,parameters,this._isCopyPicked,{pickObjectClass:objectType,pickInstances:arr})}}*DebugRunAsFamilyCustomActionWithOverrides(combinedSolModifiers,parameters){const objectTypeMap=new Map;const familyInstances=[];for(const inst of this._objectClass.GetCurrentSol().GetInstances()){const objectType=inst.GetObjectClass();if(objectType.HasOwnCustomActionByName(this._aceName)){const arr=
objectTypeMap.get(objectType);if(Array.isArray(arr))arr.push(inst);else objectTypeMap.set(objectType,[inst])}else familyInstances.push(inst)}if(familyInstances.length>0)yield*this._eventBlock.DebugRunAsFunctionCall(combinedSolModifiers,parameters,this._isCopyPicked,{pickObjectClass:this._objectClass,pickInstances:familyInstances});if(objectTypeMap.size>0)for(const [objectType,arr]of objectTypeMap){const eventBlock=objectType.GetOwnCustomActionByName(this._aceName).GetEventBlock();const allCombinedSolModifiers=
[...(new Set([...combinedSolModifiers,...eventBlock.GetSolModifiers()]))];yield*eventBlock.DebugRunAsFunctionCall(allCombinedSolModifiers,parameters,this._isCopyPicked,{pickObjectClass:objectType,pickInstances:arr})}}};

}

// events/eventVariable.js
{
'use strict';const C3=self.C3;const EMPTY_SOL_MODIFIERS=[];
C3.EventVariable=class EventVariable extends C3.DefendedBase{constructor(eventSheet,parent,data){super();const eventSheetManager=eventSheet.GetEventSheetManager();this._eventSheet=eventSheet;this._eventSheetManager=eventSheetManager;this._runtime=eventSheet.GetRuntime();this._parent=parent;this._localVarStack=eventSheetManager.GetLocalVarStack();this._name=data[1];this._type=data[2];this._initialValue=data[3];this._isStatic=!!data[4];this._isConstant=!!data[5];this._isFunctionParameter=parent instanceof
C3.FunctionBlock;this._sid=data[6];this._jsPropName=this._runtime.GetJsPropName(data[8]);this._scriptSetter=v=>this.SetValue(v);this._scriptGetter=()=>this.GetValue();this._hasSingleValue=!this._parent||this._isStatic||this._isConstant;this._value=this._initialValue;this._localIndex=-1;if(this.IsBoolean())this._value=this._value?1:0;if(this.IsLocal()&&!this.IsStatic()&&!this.IsConstant())this._localIndex=eventSheetManager._GetNextLocalVarIndex(this);eventSheetManager._RegisterEventVariable(this)}static Create(eventSheet,
parent,data){return C3.New(C3.EventVariable,eventSheet,parent,data)}_PostInit(){if(this.IsLocal()&&!this.IsStatic()&&!this.IsConstant()&&!this.IsFunctionParameter()){const functionBlock=this._eventSheetManager.FindFirstFunctionBlockParent(this);if(functionBlock)functionBlock._RegisterLocalVariable(this)}}GetName(){return this._name}GetJsPropName(){return this._jsPropName}GetParent(){return this._parent}GetScopeParent(){return this.GetParent()}IsGlobal(){return!this.GetParent()}IsLocal(){return!this.IsGlobal()}IsFunctionParameter(){return this._isFunctionParameter}IsStatic(){return this._isStatic}IsConstant(){return this._isConstant}IsNumber(){return this._type===
0}IsString(){return this._type===1}IsBoolean(){return this._type===2}IsElseBlock(){return false}GetSID(){return this._sid}GetInitialValue(){return this._initialValue}GetSolModifiers(){return EMPTY_SOL_MODIFIERS}Run(frame){if(this.IsLocal()&&!this.IsStatic()&&!this.IsConstant())this.SetValue(this.GetInitialValue())}DebugCanRunFast(){return true}*DebugRun(frame){this.Run(frame)}SetValue(v){if(this.IsNumber()){if(typeof v!=="number")v=parseFloat(v)}else if(this.IsString()){if(typeof v!=="string")v=v.toString()}else if(this.IsBoolean())v=
v?1:0;if(this._hasSingleValue)this._value=v;else this._localVarStack.GetCurrent()[this._localIndex]=v}GetValue(){return this._hasSingleValue?this._value:this._localVarStack.GetCurrent()[this._localIndex]}GetTypedValue(){let ret=this.GetValue();if(this.IsBoolean())ret=!!ret;return ret}ResetToInitialValue(){this._value=this._initialValue}_GetScriptInterfaceDescriptor(){return{configurable:false,enumerable:true,get:this._scriptGetter,set:this._scriptSetter}}};

}

// events/eventInclude.js
{
'use strict';const C3=self.C3;const assert=self.assert;const EMPTY_SOL_MODIFIERS=[];
C3.EventInclude=class EventInclude extends C3.DefendedBase{constructor(eventSheet,parent,data){super();const eventSheetManager=eventSheet.GetEventSheetManager();this._eventSheet=eventSheet;this._eventSheetManager=eventSheetManager;this._runtime=eventSheet.GetRuntime();this._parent=parent;this._includeSheet=null;this._includeSheetName=data[1];this._isActive=true}static Create(eventSheet,parent,data){return C3.New(C3.EventInclude,eventSheet,parent,data)}_PostInit(){this._includeSheet=this._eventSheetManager.GetEventSheetByName(this._includeSheetName);
this._eventSheet._AddShallowInclude(this);let p=this.GetParent();while(p){if(p instanceof C3.EventBlock&&p.IsGroup())p._AddContainedInclude(this);p=p.GetParent()}this.UpdateActive();if(this._runtime.IsDebug())this._eventSheet._GetPerfRecord().children.push(this._includeSheet._GetPerfRecord())}GetParent(){return this._parent}GetSolModifiers(){return EMPTY_SOL_MODIFIERS}GetIncludeSheet(){return this._includeSheet}Run(frame){const pushSol=!!this.GetParent();const allObjectClasses=this._runtime.GetAllObjectClasses();
if(pushSol)this._eventSheetManager.PushCleanSol(allObjectClasses);this._includeSheet.Run();if(pushSol)this._eventSheetManager.PopSol(allObjectClasses)}*DebugRun(frame){const pushSol=!!this.GetParent();const allObjectClasses=this._runtime.GetAllObjectClasses();if(pushSol)this._eventSheetManager.PushCleanSol(allObjectClasses);yield*this._includeSheet.DebugRun();if(pushSol)this._eventSheetManager.PopSol(allObjectClasses)}DebugCanRunFast(){return false}IsActive(){return this._isActive}UpdateActive(){let p=
this.GetParent();while(p){if(p instanceof C3.EventBlock&&p.IsGroup()&&!p.IsGroupActive()){this._isActive=false;return}p=p.GetParent()}this._isActive=true}};

}

// events/expNode.js
{
'use strict';const C3=self.C3;const assert=self.assert;C3.ExpNode=class ExpNode extends C3.DefendedBase{constructor(owner){super();this._owner=owner;this._runtime=owner.GetRuntime()}_PostInit(){}static CreateNode(owner,data){const type=data[0];const Classes=[BehaviorExpressionNode,ObjectExpressionNode,InstVarExpressionNode,EventVarExpNode,SystemExpressionExpNode,CallFunctionExpressionExpNode];return C3.New(Classes[type],owner,data)}};
class SystemExpressionExpNode extends C3.ExpNode{constructor(owner,data){super(owner);this._systemPlugin=this._runtime.GetSystemPlugin();this._func=this._runtime.GetObjectReference(data[1]);if(this._func===C3.Plugins.System.Exps.random||this._func===C3.Plugins.System.Exps.choose)this._owner.SetVariesPerInstance()}GetBoundMethod(){return this._systemPlugin._GetBoundACEMethod(this._func,this._systemPlugin)}}
class CallFunctionExpressionExpNode extends C3.ExpNode{constructor(owner,data){super(owner);this._functionBlock=null;this._functionName=data[1];this._owner.SetVariesPerInstance()}_PostInit(){const eventSheetManager=this._runtime.GetEventSheetManager();this._functionBlock=eventSheetManager.GetFunctionBlockByName(this._functionName);this._functionName=null;const myEventBlock=this._owner.GetEventBlock();const callEventBlock=this._functionBlock.GetEventBlock();this._combinedSolModifiers=[...(new Set([...myEventBlock.GetSolModifiersIncludingParents(),
...callEventBlock.GetSolModifiersIncludingParents()]))];this._combinedSolModifiers=eventSheetManager._DeduplicateSolModifierList(this._combinedSolModifiers)}GetBoundMethod(){const functionBlock=this._functionBlock;if(functionBlock.IsEnabled()){const callEventBlock=functionBlock.GetEventBlock();return C3.EventBlock.prototype.RunAsExpressionFunctionCall.bind(callEventBlock,this._combinedSolModifiers,functionBlock.IsCopyPicked(),functionBlock.GetReturnType(),functionBlock.GetDefaultReturnValue())}else{const defaultReturnValue=
functionBlock.GetDefaultReturnValue();return()=>defaultReturnValue}}}function WrapIndex(index,len){if(index>=len)return index%len;else if(index<0){if(index<=-len)index%=len;if(index<0)index+=len;return index}else return index}
class ObjectExpressionNode extends C3.ExpNode{constructor(owner,data){super(owner);this._objectClass=this._runtime.GetObjectClassByIndex(data[1]);this._func=this._runtime.GetObjectReference(data[2]);this._returnsString=!!data[3];this._eventStack=this._runtime.GetEventSheetManager().GetEventStack();this._owner._MaybeVaryFor(this._objectClass)}GetBoundMethod(){return this._objectClass.GetPlugin()._GetBoundACEMethod(this._func,this._objectClass.GetSingleGlobalInstance().GetSdkInstance())}ExpObject(...args){const objectClass=
this._objectClass;const instances=objectClass.GetCurrentSol().GetExpressionInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);return this._func.apply(instances[index].GetSdkInstance(),args)}ExpObject_InstExpr(instIndex,...args){const objectClass=this._objectClass;const instances=objectClass.GetInstances();const len=instances.length;if(len===
0)return this._returnsString?"":0;const index=WrapIndex(instIndex,len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);return this._func.apply(instances[index].GetSdkInstance(),args)}}
class InstVarExpressionNode extends C3.ExpNode{constructor(owner,data){super(owner);this._objectClass=this._runtime.GetObjectClassByIndex(data[1]);this._varIndex=data[3];this._returnsString=!!data[2];this._owner._MaybeVaryFor(this._objectClass)}ExpInstVar(){const instances=this._objectClass.GetCurrentSol().GetExpressionInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);return instances[index]._GetInstanceVariableValueUnchecked(this._varIndex)}ExpInstVar_Family(){const objectClass=
this._objectClass;const instances=objectClass.GetCurrentSol().GetExpressionInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);const inst=instances[index];const offset=inst.GetObjectClass().GetFamilyInstanceVariableOffset(objectClass.GetFamilyIndex());return inst._GetInstanceVariableValueUnchecked(this._varIndex+offset)}ExpInstVar_InstExpr(instIndex){const objectClass=this._objectClass;const instances=objectClass.GetInstances();
const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(instIndex,len);const inst=instances[index];let offset=0;if(objectClass.IsFamily())offset=inst.GetObjectClass().GetFamilyInstanceVariableOffset(objectClass.GetFamilyIndex());return inst._GetInstanceVariableValueUnchecked(this._varIndex+offset)}}
class BehaviorExpressionNode extends C3.ExpNode{constructor(owner,data){super(owner);this._objectClass=this._runtime.GetObjectClassByIndex(data[1]);this._behaviorType=this._objectClass.GetBehaviorTypeByName(data[2]);this._behaviorIndex=this._objectClass.GetBehaviorIndexByName(data[2]);this._func=this._runtime.GetObjectReference(data[3]);this._returnsString=!!data[4];this._eventStack=this._runtime.GetEventSheetManager().GetEventStack();this._owner._MaybeVaryFor(this._objectClass)}ExpBehavior(...args){const objectClass=
this._objectClass;const instances=objectClass.GetCurrentSol().GetExpressionInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);const inst=instances[index];let offset=0;if(objectClass.IsFamily())offset=inst.GetObjectClass().GetFamilyBehaviorOffset(objectClass.GetFamilyIndex());return this._func.apply(inst.GetBehaviorInstances()[this._behaviorIndex+
offset].GetSdkInstance(),args)}ExpBehavior_InstExpr(instIndex,...args){const objectClass=this._objectClass;const instances=objectClass.GetInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(instIndex,len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);const inst=instances[index];let offset=0;if(objectClass.IsFamily())offset=inst.GetObjectClass().GetFamilyBehaviorOffset(objectClass.GetFamilyIndex());return this._func.apply(inst.GetBehaviorInstances()[this._behaviorIndex+
offset].GetSdkInstance(),args)}}class EventVarExpNode extends C3.ExpNode{constructor(owner,data){super(owner);this._eventVar=null;this._eventVarSid=data[1]}_PostInit(){this._eventVar=this._runtime.GetEventSheetManager().GetEventVariableBySID(this._eventVarSid)}GetVar(){return this._eventVar}};

}

// events/parameter.js
{
'use strict';const C3=self.C3;const assert=self.assert;
C3.Parameter=class Parameter extends C3.DefendedBase{constructor(owner,type,index){super();this._owner=owner;this._index=index;this._type=type;this.Get=null;this._variesPerInstance=false;this._isConstant=false}static Create(owner,data,index){const type=data[0];const Classes=[ExpressionParameter,StringExpressionParameter,FileParameter,ComboParameter,ObjectParameter,LayerExpressionParameter,LayoutParameter,ExpressionParameter,ComboParameter,ComboParameter,InstVarParameter,EventVarParameter,FileParameter,
VariadicParameter,StringExpressionParameter,TimelineParameter,BooleanParameter,FunctionParameter,EaseParameter,TilemapBrushParameter,TemplateExpressionParameter];return C3.New(Classes[type],owner,type,index,data)}_PostInit(){}SetVariesPerInstance(){this._variesPerInstance=true}_MaybeVaryFor(objectClass){if(this._variesPerInstance)return;if(!objectClass)return;if(!objectClass.GetPlugin().IsSingleGlobal())this._variesPerInstance=true}VariesPerInstance(){return this._variesPerInstance}GetIndex(){return this._index}GetRuntime(){return this._owner.GetRuntime()}GetEventBlock(){return this._owner.GetEventBlock()}IsConstant(){return this._isConstant}IsObjectParameter(){return this._type===
4}};function GetExpressionFunc(number){const ret=self.C3_ExpressionFuncs[number];if(!ret)throw new Error("invalid expression number");return ret}
class ExpressionParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._solIndex=0;const expData=data[1];this._expressionNumber=expData[0];this._numberedNodes=[];this._expressionFunc=null;for(let i=1,len=expData.length;i<len;++i)this._numberedNodes.push(C3.ExpNode.CreateNode(this,expData[i]));if(this._numberedNodes.length)this.Get=this.GetExpression;else{this.Get=GetExpressionFunc(this._expressionNumber);this._isConstant=true}}_GetNode(i){if(i<0||i>=this._numberedNodes.length)throw new RangeError("invalid numbered node");
return this._numberedNodes[i]}_PostInit(){for(const node of this._numberedNodes)node._PostInit();const func=GetExpressionFunc(this._expressionNumber);if(this._numberedNodes.length)this._expressionFunc=func(this);else this._expressionFunc=func}GetSolIndex(){return this._solIndex}GetExpression(solIndex){this._solIndex=solIndex;return this._expressionFunc()}}
class StringExpressionParameter extends ExpressionParameter{constructor(owner,type,index,data){super(owner,type,index,data);this.Get=this.GetStringExpression;if(type===14){this.GetEventBlock().SetAllSolModifiers();if(this._owner instanceof C3.Action)this.GetEventBlock().SetSolWriterAfterCnds()}}GetStringExpression(solIndex){this._solIndex=solIndex;const ret=this._expressionFunc();if(typeof ret==="string")return ret;else return""}_GetFastTriggerValue(){return GetExpressionFunc(this._expressionNumber)()}}
class LayerExpressionParameter extends ExpressionParameter{constructor(owner,type,index,data){super(owner,type,index,data);this.Get=this.GetLayer;this._isConstant=false}GetLayer(solIndex){this._solIndex=solIndex;const ret=this._expressionFunc();const layout=this.GetRuntime().GetCurrentLayout();return layout.GetLayer(ret)}}
class ComboParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._combo=data[1];this.Get=this.GetCombo;this._isConstant=true}GetCombo(){return this._combo}}class BooleanParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._bool=data[1];this.Get=this.GetBoolean;this._isConstant=true}GetBoolean(){return this._bool}}
class ObjectParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._objectClass=this.GetRuntime().GetObjectClassByIndex(data[1]);this.Get=this.GetObjectClass;const eventBlock=this.GetEventBlock();eventBlock._AddSolModifier(this._objectClass);if(this._owner instanceof C3.Action)eventBlock.SetSolWriterAfterCnds();else if(eventBlock.GetParent())eventBlock.GetParent().SetSolWriterAfterCnds();this._isConstant=true}GetObjectClass(){return this._objectClass}}
class LayoutParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._layout=this.GetRuntime().GetLayoutManager().GetLayoutByName(data[1]);this.Get=this.GetLayout;this._isConstant=true}GetLayout(){return this._layout}}
class TimelineParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._timeline=this.GetRuntime().GetTimelineManager().GetTimelineByName(data[1]);this.Get=this.GetTimeline;this._isConstant=true}GetTimeline(){return this._timeline}}class FileParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._fileInfo=data[1];this.Get=this.GetFile;this._isConstant=true}GetFile(){return this._fileInfo}}
class InstVarParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._instVarIndex=data[1];const ownerObjectClass=this._owner.GetObjectClass();if(this._owner instanceof C3.Condition&&this._owner.IsStatic()){this.Get=this.GetInstanceVariable;this._isConstant=true}else if(ownerObjectClass&&ownerObjectClass.IsFamily()){this.Get=this.GetFamilyInstanceVariable;this.SetVariesPerInstance()}else{this.Get=this.GetInstanceVariable;this._isConstant=true}}GetInstanceVariable(){return this._instVarIndex}GetFamilyInstanceVariable(solIndex){solIndex=
solIndex||0;const familyType=this._owner.GetObjectClass();const sol=familyType.GetCurrentSol();const instances=sol.GetInstances();let realType=null;if(instances.length)realType=instances[solIndex%instances.length].GetObjectClass();else if(sol.HasAnyElseInstances()){const elseInstances=sol.GetElseInstances();realType=elseInstances[solIndex%elseInstances.length].GetObjectClass()}else if(familyType.GetInstanceCount()>0){const familyInstances=familyType.GetInstances();realType=familyInstances[solIndex%
familyInstances.length].GetObjectClass()}else return 0;return this._instVarIndex+realType.GetFamilyInstanceVariableOffset(familyType.GetFamilyIndex())}}
class EventVarParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._eventVarSid=data[1];this._eventVar=null;this.Get=this.GetEventVariable;this._isConstant=true}_PostInit(){this._eventVar=this.GetRuntime().GetEventSheetManager().GetEventVariableBySID(this._eventVarSid)}GetEventVariable(){return this._eventVar}}
class FunctionParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._functionBlockName=data[1];this._functionBlock=null;this.Get=this.GetFunction;this._isConstant=true}_PostInit(){this._functionBlock=this.GetRuntime().GetEventSheetManager().GetFunctionBlockByName(this._functionBlockName);this._functionBlockName=null}GetFunction(){return this._functionBlock}}
class VariadicParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._subParams=[];this._variadicRet=[];this._isConstant=true;for(let i=1,len=data.length;i<len;++i){const subParam=C3.Parameter.Create(this._owner,data[i],0);this._subParams.push(subParam);this._variadicRet.push(0);if(!subParam.IsConstant())this._isConstant=false}this.Get=this.GetVariadic}_PostInit(){for(const subParam of this._subParams)subParam._PostInit()}GetVariadic(){const subParams=this._subParams;
const variadicRet=this._variadicRet;for(let i=0,len=subParams.length;i<len;++i)variadicRet[i]=subParams[i].Get(0);return variadicRet}}class EaseParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._easeIndex=data[1];this.Get=this.GetEase;this._isConstant=true}GetEase(){return this._easeIndex}}
class TilemapBrushParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._brushIndex=data[1];this.Get=this.GetTilemapBrush;this._isConstant=true}GetTilemapBrush(){return this._brushIndex}}class TemplateExpressionParameter extends ExpressionParameter{constructor(owner,type,index,data){super(owner,type,index,data);this.Get=this.GetTemplateName;this._isConstant=false}GetTemplateName(){return this._expressionFunc()}};

}

// events/condition.js
{
'use strict';const C3=self.C3;const assert=self.assert;function EvalParams(parameters,results){for(let i=0,len=parameters.length;i<len;++i)results[i]=parameters[i].Get(0)}const EMPTY_PARAMS_ARRAY=[];const noop=function(){};
C3.Condition=class Condition extends C3.DefendedBase{constructor(eventBlock,data,index){super();this._eventBlock=eventBlock;this._runtime=eventBlock.GetRuntime();this._index=index;this._func=this._runtime.GetObjectReference(data[1]);this._isTrigger=data[3]>0;this._isFastTrigger=data[3]===2;this._isLooping=!!data[4];this._isInverted=!!data[5];this._isStatic=!!data[6];this._sid=data[7];this._isInOrBlock=this._eventBlock.IsOrBlock();this._objectClass=null;this._behaviorType=null;this._behaviorIndex=
-1;this._systemPlugin=null;this.Run=noop;this.DebugRun=noop;this._parameters=[];this._results=[];this._anyParamVariesPerInstance=false;this._savedData=null;this._unsavedData=null;this._debugData=this._runtime.IsDebug()?{isBreakpoint:data[8][0],canDebug:data[8][1]}:null;if(data[0]===-1)this._systemPlugin=this._runtime.GetSystemPlugin();else{this._objectClass=this._runtime.GetObjectClassByIndex(data[0]);if(data[2]){this._behaviorType=this._objectClass.GetBehaviorTypeByName(data[2]);this._behaviorIndex=
this._objectClass.GetBehaviorIndexByName(data[2])}if(this._eventBlock.GetParent())this._eventBlock.GetParent().SetSolWriterAfterCnds()}if(data.length===10){let paramData=data[9];for(let data of paramData){this._parameters.push(C3.Parameter.Create(this,data,this._parameters.length));this._results.push(0)}}if(this._parameters.length===0){this._parameters=EMPTY_PARAMS_ARRAY;this._results=EMPTY_PARAMS_ARRAY}this._eventBlock.GetEventSheetManager()._RegisterCondition(this)}static Create(eventBlock,data,
index){return C3.New(C3.Condition,eventBlock,data,index)}_PostInit(){for(const param of this._parameters){param._PostInit();if(param.VariesPerInstance())this._anyParamVariesPerInstance=true}if(this._isFastTrigger){this.Run=this._RunFastTrigger;this.DebugRun=this._DebugRunFastTrigger}else if(this._systemPlugin){this._SetSystemRunMethod();this.DebugRun=this._DebugRunSystem}else if(this._objectClass.GetPlugin().IsSingleGlobal()){this._SetSingleGlobalRunMethod();this.DebugRun=this._DebugRunSingleGlobal}else if(this._isStatic){this.Run=
this._RunStatic;this.DebugRun=this._DebugRunStatic}else{this.Run=this._RunObject;this.DebugRun=this._DebugRunObject}}_SetSystemRunMethod(){const plugin=this._systemPlugin;const bindThis=this._systemPlugin;this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSystem)}_SetSingleGlobalRunMethod(){const plugin=this._objectClass.GetPlugin();const bindThis=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSingleGlobal)}_SetRunMethodForBoundFunc(plugin,
bindThis,fallbackMethod){const func=this._func;const isInverted=this._isInverted;const parameters=this._parameters;if(parameters.length===0){const boundFunc=plugin._GetBoundACEMethod(func,bindThis);if(isInverted)this.Run=function RunSingleCnd_0param(){return C3.xor(boundFunc(),isInverted)};else this.Run=boundFunc}else if(parameters.length===1){const param0=parameters[0];if(!isInverted&&param0.IsConstant())this.Run=plugin._GetBoundACEMethod_1param(func,bindThis,param0.Get(0));else{const boundFunc=
plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleCnd_1param(){return C3.xor(boundFunc(param0.Get(0)),isInverted)}}}else if(parameters.length===2){const param0=parameters[0];const param1=parameters[1];if(!isInverted&&param0.IsConstant()&&param1.IsConstant())this.Run=plugin._GetBoundACEMethod_2params(func,bindThis,param0.Get(0),param1.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleCnd_2params(){return C3.xor(boundFunc(param0.Get(0),
param1.Get(0)),isInverted)}}}else if(parameters.length===3){const param0=parameters[0];const param1=parameters[1];const param2=parameters[2];if(!isInverted&&param0.IsConstant()&&param1.IsConstant()&&param2.IsConstant())this.Run=plugin._GetBoundACEMethod_3params(func,bindThis,param0.Get(0),param1.Get(0),param2.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleCnd_3params(){return C3.xor(boundFunc(param0.Get(0),param1.Get(0),param2.Get(0)),isInverted)}}}else this.Run=
fallbackMethod}GetSID(){return this._sid}_GetFunc(){return this._func}GetObjectClass(){return this._objectClass}GetBehaviorType(){return this._behaviorType}GetEventBlock(){return this._eventBlock}GetRuntime(){return this._runtime}GetIndex(){return this._index}GetDebugIndex(){return this.GetIndex()}IsTrigger(){return this._isTrigger}IsFastTrigger(){return this._isFastTrigger}IsInverted(){return this._isInverted}IsLooping(){return this._isLooping}IsStatic(){return this._isStatic}IsBreakpoint(){return this._debugData.isBreakpoint}IsSystemCondition(){return!!this._systemPlugin}GetFirstObjectParameterObjectClass(){for(const p of this._parameters)if(p.IsObjectParameter())return p.GetObjectClass();
return null}_SetBreakpoint(b){this._debugData.isBreakpoint=!!b;this._eventBlock._UpdateCanRunFastRecursive()}_DebugReturnsGenerator(){return this._debugData.canDebug}DebugCanRunFast(){return!this.IsBreakpoint()&&!this._runtime.DebugBreakNext()&&!this._DebugReturnsGenerator()}GetSavedDataMap(){if(!this._savedData)this._savedData=new Map;return this._savedData}GetUnsavedDataMap(){if(!this._unsavedData)this._unsavedData=new Map;return this._unsavedData}_RunSystem(){const results=this._results;EvalParams(this._parameters,
results);return C3.xor(this._func.apply(this._systemPlugin,results),this._isInverted)}*_DebugRunSystem(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);let ret=this._func.apply(this._systemPlugin,results);if(C3.IsIterator(ret))ret=yield*ret;return C3.xor(ret,this._isInverted)}else return this.Run()}_RunSingleGlobal(){const results=this._results;EvalParams(this._parameters,results);
const inst=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();return C3.xor(this._func.apply(inst,results),this._isInverted)}*_DebugRunSingleGlobal(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);const inst=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();let ret=this._func.apply(inst,results);if(C3.IsIterator(ret))ret=yield*ret;return C3.xor(ret,this._isInverted)}else return this.Run()}_RunFastTrigger(){return true}*_DebugRunFastTrigger(){if(this.IsBreakpoint()||
this._runtime.DebugBreakNext())yield this;return true}_RunStatic(){const results=this._results;EvalParams(this._parameters,results);const ret=this._func.apply(this._behaviorType||this._objectClass,results);this._objectClass.ApplySolToContainer();return ret}*_DebugRunStatic(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);let ret=this._func.apply(this._behaviorType||this._objectClass,
results);if(C3.IsIterator(ret))ret=yield*ret;this._objectClass.ApplySolToContainer();return ret}else return this.Run()}_RunObject(){const parameters=this._parameters;const results=this._results;const sol=this._objectClass.GetCurrentSol();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}if(sol.IsSelectAll())return this._RunObject_FirstFilter(sol);else return this._RunObject_NextFilter(sol)}*_DebugRunObject(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;
return this._RunObject()}_EvaluateVaryingParameters(solIndex){const parameters=this._parameters;const results=this._results;for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(p.VariesPerInstance())results[i]=p.Get(solIndex)}}_RunObject_FirstFilter(sol){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const behaviorIndex=this._behaviorIndex;const isBehavior=behaviorIndex>=0;const allInstances=objectClass.GetInstances();
const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const isInverted=this._isInverted;const isInOrBlock=this._isInOrBlock&&!this._isTrigger;sol.ClearArrays();for(let i=0,len=allInstances.length;i<len;++i){const inst=allInstances[i];if(paramsVary)this._EvaluateVaryingParameters(i);let ret;if(isBehavior){const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;ret=func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),
results)}else ret=func.apply(inst.GetSdkInstance(),results);if(C3.xor(ret,isInverted))sol._PushInstance(inst);else if(isInOrBlock)sol._PushElseInstance(inst)}objectClass.FinishCondition(true);sol._SetSelectAll(false);objectClass.ApplySolToContainer();return sol.HasAnyInstances()}_RunObject_NextFilter(sol){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const isInContainer=objectClass.IsInContainer();const behaviorIndex=this._behaviorIndex;
const isBehavior=behaviorIndex>=0;const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const isInverted=this._isInverted;const isInOrBlock=this._isInOrBlock&&!this._isTrigger;const solInstances=sol._GetOwnInstances();const solElseInstances=sol._GetOwnElseInstances();const isUsingElseInstances=isInOrBlock&&!this._eventBlock.IsFirstConditionOfType(this);const arr=isUsingElseInstances?solElseInstances:solInstances;let k=0;let isAnyTrue=false;for(let i=0,
len=arr.length;i<len;++i){const inst=arr[i];if(paramsVary)this._EvaluateVaryingParameters(i);let ret;if(isBehavior){const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;ret=func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}else ret=func.apply(inst.GetSdkInstance(),results);if(C3.xor(ret,isInverted)){isAnyTrue=true;if(isUsingElseInstances){solInstances.push(inst);if(isInContainer)inst._PushSiblingsToSolInstances()}else{arr[k]=inst;
if(isInContainer)inst._SetSiblingsToSolInstancesIndex(k);++k}}else if(isUsingElseInstances){arr[k]=inst;if(isInContainer)inst._SetSiblingsToSolElseInstancesIndex(k);++k}else if(isInOrBlock){solElseInstances.push(inst);if(isInContainer)inst._PushSiblingsToSolElseInstances()}}C3.truncateArray(arr,k);if(isInContainer)objectClass._TruncateContainerSols(isUsingElseInstances,k);const pickInFinish=isAnyTrue;if(isUsingElseInstances&&!isAnyTrue)isAnyTrue=this._OrBlockCheckInstances(solInstances);objectClass.FinishCondition(pickInFinish||
isInOrBlock);return isInOrBlock?isAnyTrue:sol.HasAnyInstances()}_OrBlockCheckInstances(solInstances){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const paramsVary=this._anyParamVariesPerInstance;const behaviorIndex=this._behaviorIndex;const isBehavior=behaviorIndex>=0;const results=this._results;const func=this._func;const isInverted=this._isInverted;for(let i=0,len=solInstances.length;i<len;++i){const inst=solInstances[i];
if(paramsVary)this._EvaluateVaryingParameters(i);let ret;if(isBehavior){const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;ret=func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}else ret=func.apply(inst.GetSdkInstance(),results);if(C3.xor(ret,isInverted))return true}return false}ReevaluateParameter(paramIndex,solIndex){return this._parameters[paramIndex].Get(solIndex)}GetFastTriggerValue(){const parameters=this._parameters;if(!parameters.length)throw new Error("no parameters");
return parameters[0]._GetFastTriggerValue()}_SaveToJson(){if(!this._savedData||!this._savedData.size)return null;const ex={};for(const [k,v]of this._savedData.entries()){let saveVal=v;if(k==="collmemory")saveVal=[...v.entries()].map(arr=>[arr[0].GetUID(),arr[1].GetUID(),arr[2]]);ex[k]=saveVal}return{"ex":ex}}_LoadFromJson(o){if(this._savedData){this._savedData.clear();this._savedData=null}if(!o)return;const runtime=this._runtime;const ex=o["ex"];if(ex){const map=this.GetSavedDataMap();map.clear();
for(const [k,v]of Object.entries(ex)){let loadVal=v;if(k==="collmemory")loadVal=C3.New(C3.PairMap,v.map(arr=>[runtime.GetInstanceByUID(arr[0]),runtime.GetInstanceByUID(arr[1]),arr[2]]).filter(arr=>arr[0]&&arr[1]));map.set(k,loadVal)}}}};

}

// events/action.js
{
'use strict';const C3=self.C3;const assert=self.assert;function EvalParams(parameters,results){for(let i=0,len=parameters.length;i<len;++i)results[i]=parameters[i].Get(0)}const EMPTY_PARAMS_ARRAY=[];const noop=function(){};const noopGenerator=function*(){};const FLAG_CANPICKANYOBJECTCLASS=1;const FLAG_COPYPICKED=2;const FLAG_CUSTOM_ACE=4;
C3.Action=class Action extends C3.DefendedBase{constructor(eventBlock,data,index){super();this._eventBlock=eventBlock;const runtime=eventBlock.GetRuntime();this._runtime=runtime;this._index=index;this._sid=data.length>=4?data[3]:-1;this._actionType=data.length>=5?data[4]&255:0;this._flags=data.length>=5?data[4]>>8:0;this._func=null;this._objectClass=null;this._behaviorType=null;this._behaviorIndex=-1;this._systemPlugin=null;this._callFunctionName="";this._callCustomAceObjectClass=null;this._callEventBlock=
null;this.Run=noop;this.DebugRun=noop;this._parameters=[];this._results=[];this._anyParamVariesPerInstance=false;this._savedData=null;this._unsavedData=null;const isScript=data[0]===-3;const debugInfo=isScript?data[2]:data[5];this._debugData=runtime.IsDebug()||isScript?{isBreakpoint:debugInfo[0],canDebug:debugInfo[1],index:debugInfo[2]}:null;if(data[0]===-1){this._systemPlugin=runtime.GetSystemPlugin();this._func=runtime.GetObjectReference(data[1])}else if(data[0]===-2)this._callFunctionName=data[1];
else if(isScript){const userMethod=runtime.GetObjectReference(data[1]);this._func=userMethod;this.Run=this.RunUserScript;this.DebugRun=this.DebugRunUserScript;this._actionType=1}else{this._objectClass=runtime.GetObjectClassByIndex(data[0]);if(this._flags&FLAG_CUSTOM_ACE){this._callFunctionName=data[1];this._callCustomAceObjectClass=runtime.GetObjectClassByIndex(data[2])}else{if(data[2]){this._behaviorType=this._objectClass.GetBehaviorTypeByName(data[2]);this._behaviorIndex=this._objectClass.GetBehaviorIndexByName(data[2])}this._func=
runtime.GetObjectReference(data[1])}}if(data.length===7){const paramData=data[6];for(const data of paramData){this._parameters.push(C3.Parameter.Create(this,data,this._parameters.length));this._results.push(0)}}if(this._parameters.length===0){this._parameters=EMPTY_PARAMS_ARRAY;this._results=EMPTY_PARAMS_ARRAY}if(this.CanPickAnyObjectClass()){this._eventBlock.SetAllSolModifiers();this._eventBlock.SetSolWriterAfterCnds()}this._eventBlock.GetEventSheetManager()._RegisterAction(this)}static Create(eventBlock,
data,index){return C3.New(C3.Action,eventBlock,data,index)}_PostInit(){for(const param of this._parameters){param._PostInit();if(param.VariesPerInstance())this._anyParamVariesPerInstance=true}if(this._systemPlugin){this._SetSystemRunMethod();this.DebugRun=this._DebugRunSystem}else if(this._callFunctionName){if(this._flags&FLAG_CUSTOM_ACE)this._SetCallCustomActionRunMethod();else this._SetCallFunctionRunMethod();this._callFunctionName="";this._callCustomAceObjectClass=null}else if(this.Run===this.RunUserScript){const userMethod=
this._func;const localVars=this._runtime.GetEventSheetManager()._GetLocalVariablesScriptInterface(this._eventBlock);this._func=userMethod.bind(null,this._runtime.GetIRuntime(),localVars)}else if(this._behaviorType)if(this.IsAsync()){this.Run=this._RunBehavior_Async;this.DebugRun=this._DebugRunBehavior_Async}else{this.Run=this._RunBehavior;this.DebugRun=this._DebugRunBehavior}else if(this._objectClass.GetPlugin().IsSingleGlobal()){this._SetSingleGlobalRunMethod();this.DebugRun=this._DebugRunSingleGlobal}else if(this.IsAsync()){this.Run=
this._RunObject_Async;this.DebugRun=this._DebugRunObject_Async}else if(this.CallBeforeAfterHooks()){this.Run=this._RunObject_BeforeAfterHooks;this.DebugRun=this._DebugRunObject_BeforeAfterHooks}else if(!this._parameters.length){this.Run=this._RunObject_ParamsConst;this.DebugRun=this._DebugRunObject_ParamsConst}else if(this._parameters.every(p=>p.VariesPerInstance())){this.Run=this._RunObject_AllParamsVary;this.DebugRun=this._DebugRunObject_AllParamsVary}else if(this._anyParamVariesPerInstance){this.Run=
this._RunObject_SomeParamsVary;this.DebugRun=this._DebugRunObject_SomeParamsVary}else if(this._parameters.every(p=>p.IsConstant())){EvalParams(this._parameters,this._results);this.Run=this._RunObject_ParamsConst;this.DebugRun=this._DebugRunObject_ParamsConst}else{this.Run=this._RunObject_ParamsDontVary;this.DebugRun=this._DebugRunObject_ParamsDontVary}}_SetSystemRunMethod(){const plugin=this._systemPlugin;const bindThis=this._systemPlugin;this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSystem)}_SetSingleGlobalRunMethod(){const plugin=
this._objectClass.GetPlugin();const bindThis=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSingleGlobal)}_SetCallFunctionRunMethod(){const eventSheetManager=this._eventBlock.GetEventSheetManager();const functionBlock=eventSheetManager.GetFunctionBlockByName(this._callFunctionName);if(functionBlock.IsEnabled()){const isCopyPicked=(this._flags&FLAG_COPYPICKED)!==0;this._callEventBlock=functionBlock.GetEventBlock();let combinedSolModifiers=
[...(new Set([...this._eventBlock.GetSolModifiersIncludingParents(),...this._callEventBlock.GetSolModifiersIncludingParents()]))];combinedSolModifiers=eventSheetManager._DeduplicateSolModifierList(combinedSolModifiers);const pickInfo=!functionBlock.IsCopyPicked()&&this._HasCopyPickedParent()?{pushCleanSolDynamic:true}:null;this.Run=C3.EventBlock.prototype.RunAsFunctionCall.bind(this._callEventBlock,combinedSolModifiers,this._parameters,isCopyPicked,pickInfo);if(this._runtime.IsDebug()){const thiz=
this;this.DebugRun=function*DebugRunCallFunction(){if(thiz.IsBreakpoint()||thiz._runtime.DebugBreakNext())yield thiz;const ret=yield*thiz._callEventBlock.DebugRunAsFunctionCall(combinedSolModifiers,thiz._parameters,isCopyPicked,pickInfo);return ret}}else this.DebugRun=noopGenerator}else{this.Run=noop;this.DebugRun=noopGenerator}}_SetCallCustomActionRunMethod(){const eventSheetManager=this._eventBlock.GetEventSheetManager();const customAceBlock=eventSheetManager.GetCustomActionBlockByName(this._callCustomAceObjectClass,
this._callFunctionName);if(customAceBlock.IsEnabled()){const isCopyPicked=(this._flags&FLAG_COPYPICKED)!==0;this._callEventBlock=customAceBlock.GetEventBlock();let combinedSolModifiers=[...(new Set([...this._eventBlock.GetSolModifiersIncludingParents(),...this._callEventBlock.GetSolModifiersIncludingParents(),this._objectClass,customAceBlock.GetObjectClass()]))];combinedSolModifiers=eventSheetManager._DeduplicateSolModifierList(combinedSolModifiers);const isOTtoOT=!this._objectClass.IsFamily()&&!customAceBlock.GetObjectClass().IsFamily();
const isOTtoFamily=!this._objectClass.IsFamily()&&customAceBlock.GetObjectClass().IsFamily();const isFamilyToFamily=this._objectClass.IsFamily();let pickInfo=null;if(!customAceBlock.IsCopyPicked()&&this._HasCopyPickedParent()){pickInfo=pickInfo||{};pickInfo.pushCleanSolDynamic=true}if(isOTtoFamily||!isCopyPicked){pickInfo=pickInfo||{};pickInfo.copyFromObjectClass=this._objectClass;pickInfo.copyToObjectClass=customAceBlock.GetObjectClass()}if(isOTtoOT||isOTtoFamily||isFamilyToFamily&&!customAceBlock.HasCustomACEOverrides())this.Run=
C3.EventBlock.prototype.RunAsFunctionCall.bind(this._callEventBlock,combinedSolModifiers,this._parameters,isCopyPicked,pickInfo);else if(isFamilyToFamily)this.Run=C3.FunctionBlock.prototype.RunAsFamilyCustomActionWithOverrides.bind(customAceBlock,combinedSolModifiers,this._parameters);else;if(this._runtime.IsDebug()){const thiz=this;if(isOTtoOT||isOTtoFamily||isFamilyToFamily&&!customAceBlock.HasCustomACEOverrides())this.DebugRun=function*DebugRunCustomAction(){if(thiz.IsBreakpoint()||thiz._runtime.DebugBreakNext())yield thiz;
const ret=yield*thiz._callEventBlock.DebugRunAsFunctionCall(combinedSolModifiers,thiz._parameters,isCopyPicked,pickInfo);return ret};else if(isFamilyToFamily)this.DebugRun=function*DebugRunCustomAction(){if(thiz.IsBreakpoint()||thiz._runtime.DebugBreakNext())yield thiz;const ret=yield*customAceBlock.DebugRunAsFamilyCustomActionWithOverrides(combinedSolModifiers,thiz._parameters);return ret}}else this.DebugRun=noopGenerator}else{this.Run=noop;this.DebugRun=noopGenerator}}_SetRunMethodForBoundFunc(plugin,
bindThis,fallbackMethod){const func=this._func;const parameters=this._parameters;if(parameters.length===0)this.Run=plugin._GetBoundACEMethod(func,bindThis);else if(parameters.length===1){const param0=parameters[0];if(param0.IsConstant())this.Run=plugin._GetBoundACEMethod_1param(func,bindThis,param0.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleAct_1param(){return boundFunc(param0.Get(0))}}}else if(parameters.length===2){const param0=parameters[0];
const param1=parameters[1];if(param0.IsConstant()&&param1.IsConstant())this.Run=plugin._GetBoundACEMethod_2params(func,bindThis,param0.Get(0),param1.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleAct_2params(){return boundFunc(param0.Get(0),param1.Get(0))}}}else if(parameters.length===3){const param0=parameters[0];const param1=parameters[1];const param2=parameters[2];if(param0.IsConstant()&&param1.IsConstant()&&param2.IsConstant())this.Run=plugin._GetBoundACEMethod_3params(func,
bindThis,param0.Get(0),param1.Get(0),param2.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleAct_3params(){return boundFunc(param0.Get(0),param1.Get(0),param2.Get(0))}}}else this.Run=fallbackMethod}GetSID(){return this._sid}IsAsync(){return this._actionType===1}CanBailOut(){return this._actionType===2}CallBeforeAfterHooks(){return this._actionType===3}CanPickAnyObjectClass(){return(this._flags&FLAG_CANPICKANYOBJECTCLASS)!==0}HasReturnType(){return this.IsAsync()||
this.CanBailOut()}GetObjectClass(){return this._objectClass}GetEventBlock(){return this._eventBlock}_HasCopyPickedParent(){let parent=this._eventBlock;do{if(parent instanceof C3.FunctionBlock&&parent.IsCopyPicked())return true;parent=parent.GetScopeParent()}while(parent);return false}GetRuntime(){return this._runtime}GetIndex(){return this._index}GetDebugIndex(){return this._debugData.index}IsBreakpoint(){return this._debugData.isBreakpoint}_SetBreakpoint(b){this._debugData.isBreakpoint=!!b;this._eventBlock._UpdateCanRunFastRecursive()}_DebugReturnsGenerator(){return this._debugData.canDebug}DebugCanRunFast(){return!this.IsBreakpoint()&&
!this._runtime.DebugBreakNext()&&!this._DebugReturnsGenerator()}GetSavedDataMap(){if(!this._savedData)this._savedData=new Map;return this._savedData}GetUnsavedDataMap(){if(!this._unsavedData)this._unsavedData=new Map;return this._unsavedData}_RunSystem(){const results=this._results;EvalParams(this._parameters,results);return this._func.apply(this._systemPlugin,results)}*_DebugRunSystem(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=
this._results;EvalParams(this._parameters,results);const ret=yield*this._func.apply(this._systemPlugin,results);return ret}else return this.Run()}_RunSingleGlobal(){const results=this._results;EvalParams(this._parameters,results);return this._func.apply(this._objectClass.GetSingleGlobalInstance().GetSdkInstance(),results)}*_DebugRunSingleGlobal(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,
results);const ret=yield*this._func.apply(this._objectClass.GetSingleGlobalInstance().GetSdkInstance(),results);return ret}else return this.Run()}_RunObject_ParamsConst(){const results=this._results;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i)this._func.apply(instances[i].GetSdkInstance(),results)}*_DebugRunObject_ParamsConst(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=
this._results;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i)yield*this._func.apply(instances[i].GetSdkInstance(),results)}else this._RunObject_ParamsConst()}_RunObject_ParamsDontVary(){const results=this._results;EvalParams(this._parameters,results);const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i)this._func.apply(instances[i].GetSdkInstance(),results)}*_DebugRunObject_ParamsDontVary(){if(this.IsBreakpoint()||
this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i)yield*this._func.apply(instances[i].GetSdkInstance(),results)}else this._RunObject_ParamsDontVary()}_RunObject_AllParamsVary(){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();
for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);func.apply(inst.GetSdkInstance(),results)}}*_DebugRunObject_AllParamsVary(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<
len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);yield*func.apply(inst.GetSdkInstance(),results)}}else this._RunObject_AllParamsVary()}_RunObject_SomeParamsVary(){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=
instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}func.apply(inst.GetSdkInstance(),results)}}*_DebugRunObject_SomeParamsVary(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=
0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}yield*func.apply(inst.GetSdkInstance(),results)}}else this._RunObject_SomeParamsVary()}_RunObject_BeforeAfterHooks(){const parameters=this._parameters;const results=this._results;const func=this._func;const objectClass=
this._objectClass;const sdkType=objectClass.GetSdkType();const instances=objectClass.GetCurrentSol().GetInstances();sdkType.BeforeRunAction(func);for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);func.apply(inst.GetSdkInstance(),results)}sdkType.AfterRunAction(func)}*_DebugRunObject_BeforeAfterHooks(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const parameters=
this._parameters;const results=this._results;const func=this._func;const objectClass=this._objectClass;const sdkType=objectClass.GetSdkType();const instances=objectClass.GetCurrentSol().GetInstances();sdkType.BeforeRunAction(func);for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);yield*func.apply(inst.GetSdkInstance(),results)}sdkType.AfterRunAction(func)}else this._RunObject_BeforeAfterHooks()}_RunBehavior(){const objectClass=
this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;const instances=objectClass.GetCurrentSol().GetInstances();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=instances.length;i<len;++i){const inst=
instances[i];if(paramsVary)for(let j=0,lenj=parameters.length;j<lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}}*_DebugRunBehavior(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();
const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;const instances=objectClass.GetCurrentSol().GetInstances();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];if(paramsVary)for(let j=0,lenj=parameters.length;j<
lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;yield*func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}}else this._RunBehavior()}_RunObject_Async(){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<len;++i){const inst=
instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);promises.push(func.apply(inst.GetSdkInstance(),results))}return Promise.all(promises)}*_DebugRunObject_Async(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<
len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);promises.push(yield*func.apply(inst.GetSdkInstance(),results))}return Promise.all(promises)}else return this._RunObject_Async()}_RunBehavior_Async(){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;
const instances=objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;promises.push(func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results))}return Promise.all(promises)}*_DebugRunBehavior_Async(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;
if(this._DebugReturnsGenerator()){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;const instances=objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);
const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;promises.push(yield*func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results))}return Promise.all(promises)}else return this._RunBehavior_Async()}async RunUserScript(){try{await this._func()}catch(err){console.error(`Unhandled exception running script %c${this._eventBlock.GetEventSheet().GetName()}, event ${this._eventBlock.GetDisplayNumber()}, action ${this.GetDebugIndex()+1}:`,"font-size: 1.2em; font-weight: bold;",
err);if(self.C3Debugger)self.C3Debugger._SetLastErrorScript(this);if(!C3.EventScript.HadUserScriptException()){console.info(`%cTip:%c run this to highlight in Construct the last script that had an error: %cgoToLastErrorScript()`,"font-weight: bold; text-decoration: underline","","font-weight: bold");C3.EventScript.SetHadUserScriptException()}}}*DebugRunUserScript(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;return this.RunUserScript()}_SaveToJson(){if(!this._savedData||!this._savedData.size)return null;
return{"ex":C3.ToSuperJSON(this._savedData)}}_LoadFromJson(o){if(this._savedData){this._savedData.clear();this._savedData=null}if(!o)return;const ex=o["ex"];if(ex)this._savedData=C3.FromSuperJSON(ex)}};

}

// events/commonACEs.js
{
'use strict';const C3=self.C3;const tempColor=new C3.Color;function CompareX(cmp,x){return C3.compare(this.GetWorldInfo().GetX(),cmp,x)}function CompareY(cmp,y){return C3.compare(this.GetWorldInfo().GetY(),cmp,y)}function IsOnScreen(){return this.GetWorldInfo().IsInViewport2()}
function IsOutsideLayout(){const wi=this.GetWorldInfo();const layout=wi.GetLayout();const bbox=wi.GetBoundingBox();return bbox.getRight()<0||bbox.getBottom()<0||bbox.getLeft()>layout.GetWidth()||bbox.getTop()>layout.GetHeight()}
function PickDistance(which,x,y){const sol=this.GetCurrentSol();const instances=sol.GetInstances();if(!instances.length)return false;let inst=instances[0];let wi=inst.GetWorldInfo();let pickme=inst;let dist2=C3.distanceSquared(wi.GetX(),wi.GetY(),x,y);for(let i=1,len=instances.length;i<len;++i){inst=instances[i];wi=inst.GetWorldInfo();const d2=C3.distanceSquared(wi.GetX(),wi.GetY(),x,y);if(which===0&&d2<dist2||which===1&&d2>dist2){dist2=d2;pickme=inst}}sol.PickOne(pickme);return true}
function SetX(x){const wi=this.GetWorldInfo();if(wi.GetX()===x)return;wi.SetX(x);wi.SetBboxChanged()}function SetY(y){const wi=this.GetWorldInfo();if(wi.GetY()===y)return;wi.SetY(y);wi.SetBboxChanged()}function SetPos(x,y){const wi=this.GetWorldInfo();if(wi.EqualsXY(x,y))return;wi.SetXY(x,y);wi.SetBboxChanged()}
function SetPosToObject(objectClass,imgPt){if(!objectClass)return;const inst=objectClass.GetPairedInstance(this._inst);if(!inst)return;const [x,y]=inst.GetImagePoint(imgPt);const wi=this.GetWorldInfo();if(wi.GetX()===x&&wi.GetY()===y)return;wi.SetXY(x,y);wi.SetBboxChanged()}function MoveForward(dist){if(dist===0)return;const wi=this.GetWorldInfo();wi.OffsetXY(wi.GetCosAngle()*dist,wi.GetSinAngle()*dist);wi.SetBboxChanged()}
function MoveAtAngle(a,dist){if(dist===0)return;const wi=this.GetWorldInfo();a=C3.toRadians(a);wi.OffsetXY(Math.cos(a)*dist,Math.sin(a)*dist);wi.SetBboxChanged()}function GetX(){return this.GetWorldInfo().GetX()}function GetY(){return this.GetWorldInfo().GetY()}function GetDt(){return this._runtime.GetDt(this._inst)}function CompareWidth(cmp,w){return C3.compare(this.GetWorldInfo().GetWidth(),cmp,w)}function CompareHeight(cmp,h){return C3.compare(this.GetWorldInfo().GetHeight(),cmp,h)}
function SetWidth(w){const wi=this.GetWorldInfo();if(wi.GetWidth()===w)return;wi.SetWidth(w);wi.SetBboxChanged()}function SetHeight(h){const wi=this.GetWorldInfo();if(wi.GetHeight()===h)return;wi.SetHeight(h);wi.SetBboxChanged()}function SetSize(w,h){const wi=this.GetWorldInfo();if(wi.GetWidth()===w&&wi.GetHeight()===h)return;wi.SetSize(w,h);wi.SetBboxChanged()}function GetWidth(){return this.GetWorldInfo().GetWidth()}function GetHeight(){return this.GetWorldInfo().GetHeight()}
function GetBboxLeft(){return this.GetWorldInfo().GetBoundingBox().getLeft()}function GetBboxTop(){return this.GetWorldInfo().GetBoundingBox().getTop()}function GetBboxRight(){return this.GetWorldInfo().GetBoundingBox().getRight()}function GetBboxBottom(){return this.GetWorldInfo().GetBoundingBox().getBottom()}function GetBboxMidX(){const bbox=this.GetWorldInfo().GetBoundingBox();return(bbox.getLeft()+bbox.getRight())/2}
function GetBboxMidY(){const bbox=this.GetWorldInfo().GetBoundingBox();return(bbox.getTop()+bbox.getBottom())/2}function IsAngleWithin(within,a){return C3.angleDiff(this.GetWorldInfo().GetAngle(),C3.toRadians(a))<=C3.toRadians(within)}function IsAngleClockwiseFrom(a){return C3.angleClockwise(this.GetWorldInfo().GetAngle(),C3.toRadians(a))}
function IsBetweenAngles(a,b){const lower=C3.toRadians(a);const upper=C3.toRadians(b);const angle=this.GetWorldInfo().GetAngle();const obtuse=!C3.angleClockwise(upper,lower);if(obtuse)return!(!C3.angleClockwise(angle,lower)&&C3.angleClockwise(angle,upper));else return C3.angleClockwise(angle,lower)&&!C3.angleClockwise(angle,upper)}
function SetAngle(a){const wi=this.GetWorldInfo();const newAngle=C3.clampAngle(C3.toRadians(a));if(isNaN(newAngle)||wi.GetAngle()===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}function RotateClockwise(a){if(isNaN(a)||a===0)return;const wi=this.GetWorldInfo();wi.SetAngle(wi.GetAngle()+C3.toRadians(a));wi.SetBboxChanged()}function RotateCounterclockwise(a){if(isNaN(a)||a===0)return;const wi=this.GetWorldInfo();wi.SetAngle(wi.GetAngle()-C3.toRadians(a));wi.SetBboxChanged()}
function RotateTowardAngle(amt,target){const wi=this.GetWorldInfo();const a=wi.GetAngle();const newAngle=C3.angleRotate(a,C3.toRadians(target),C3.toRadians(amt));if(isNaN(newAngle)||a===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}
function RotateTowardPosition(amt,x,y){const wi=this.GetWorldInfo();const a=wi.GetAngle();const dx=x-wi.GetX();const dy=y-wi.GetY();const target=Math.atan2(dy,dx);const newAngle=C3.angleRotate(a,target,C3.toRadians(amt));if(isNaN(newAngle)||a===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}
function SetTowardPosition(x,y){const wi=this.GetWorldInfo();const a=wi.GetAngle();const dx=x-wi.GetX();const dy=y-wi.GetY();const newAngle=Math.atan2(dy,dx);if(isNaN(newAngle)||a===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}function GetAngle(){return C3.toDegrees(this.GetWorldInfo().GetAngle())}function CompareOpacity(cmp,x){return C3.compare(C3.roundToDp(this.GetWorldInfo().GetOpacity()*100,6),cmp,x)}function IsVisible(){return this.GetWorldInfo().IsVisible()}
function SetVisible(v){const wi=this.GetWorldInfo();if(v===2)v=!wi.IsVisible();else v=v!==0;if(wi.IsVisible()===v)return;wi.SetVisible(v);this._runtime.UpdateRender()}function SetOpacity(o){const newOpacity=C3.clamp(o/100,0,1);const wi=this.GetWorldInfo();if(wi.GetTransformWithParentOpacity()){if(wi._GetSceneGraphInfo().GetOwnOpacity()===newOpacity)return}else if(wi.GetOpacity()===newOpacity)return;wi.SetOpacity(newOpacity);this._runtime.UpdateRender()}
function SetDefaultColor(rgb){tempColor.setFromRgbValue(rgb);const wi=this.GetWorldInfo();if(wi.GetUnpremultipliedColor().equalsIgnoringAlpha(tempColor))return;wi.SetUnpremultipliedColor(tempColor);this._runtime.UpdateRender()}function GetColor(){const c=this.GetWorldInfo().GetUnpremultipliedColor();return C3.PackRGBAEx(c.getR(),c.getG(),c.getB(),c.getA())}function GetOpacity(){return C3.roundToDp(this.GetWorldInfo().GetOpacity()*100,6)}
function IsOnLayer(layer){if(!layer)return false;return this.GetWorldInfo().GetLayer()===layer}
function PickTopBottom(which){const sol=this.GetCurrentSol();const instances=sol.GetInstances();if(!instances.length)return false;let inst=instances[0];let pickme=inst;for(let i=1,len=instances.length;i<len;++i){const inst=instances[i];const instWi=inst.GetWorldInfo();const pickmeWi=pickme.GetWorldInfo();const instLayerIndex=instWi.GetLayer().GetIndex();const pickmeLayerIndex=pickmeWi.GetLayer().GetIndex();if(which===0){if(instLayerIndex>pickmeLayerIndex||instLayerIndex===pickmeLayerIndex&&instWi.GetZIndex()>
pickmeWi.GetZIndex())pickme=inst}else if(instLayerIndex<pickmeLayerIndex||instLayerIndex===pickmeLayerIndex&&instWi.GetZIndex()<pickmeWi.GetZIndex())pickme=inst}sol.PickOne(pickme);return true}function CompareZElevation(which,cmp,value){const wi=this.GetWorldInfo();const z=which===0?wi.GetZElevation():wi.GetTotalZElevation();return C3.compare(z,cmp,value)}function MoveToTop(){this.GetWorldInfo().ZOrderMoveToTop()}function MoveToBottom(){this.GetWorldInfo().ZOrderMoveToBottom()}
function MoveToLayer(layerMove){if(!layerMove)return;this.GetWorldInfo().ZOrderMoveToLayer(layerMove)}function ZMoveToObject(where,objectClass){const isAfter=where===0;if(!objectClass)return;const otherInst=objectClass.GetFirstPicked(this.GetInstance());if(!otherInst)return;this.GetWorldInfo().ZOrderMoveAdjacentToInstance(otherInst,isAfter)}function SetZElevation(z){const wi=this.GetWorldInfo();if(wi.GetZElevation()===z)return;wi.SetZElevation(z);this._runtime.UpdateRender()}
function LayerNumber(){return this.GetWorldInfo().GetLayer().GetIndex()}function LayerName(){return this.GetWorldInfo().GetLayer().GetName()}function ZIndex(){return this.GetWorldInfo().GetZIndex()}function ZElevation(){return this.GetWorldInfo().GetZElevation()}function TotalZElevation(){return this.GetWorldInfo().GetTotalZElevation()}
function IsEffectEnabled(effectName){const effectType=this.GetObjectClass().GetEffectList().GetEffectTypeByName(effectName);if(!effectType)return;const effectTypeIndex=effectType.GetIndex();const instFxList=this.GetWorldInfo().GetInstanceEffectList();return instFxList.IsEffectIndexActive(effectTypeIndex)}
function SetEffectEnabled(enabled,effectName){const effectType=this.GetObjectClass().GetEffectList().GetEffectTypeByName(effectName);if(!effectType)return;const effectTypeIndex=effectType.GetIndex();const e=enabled===1;const instFxList=this.GetWorldInfo().GetInstanceEffectList();if(instFxList.IsEffectIndexActive(effectTypeIndex)===e)return;instFxList.SetEffectIndexActive(effectTypeIndex,e);instFxList.UpdateActiveEffects();this._runtime.UpdateRender()}
function SetEffectParam(effectName,paramIndex,value){const effectType=this.GetObjectClass().GetEffectList().GetEffectTypeByName(effectName);if(!effectType)return;paramIndex=Math.floor(paramIndex);const paramType=effectType.GetShaderProgram().GetParameterType(paramIndex);if(!paramType)return;if(paramType==="color"){tempColor.setFromRgbValue(value);value=tempColor}else if(paramType==="percent")value/=100;const effectTypeIndex=effectType.GetIndex();const instFxList=this.GetWorldInfo().GetInstanceEffectList();
const didChange=instFxList.SetEffectParameter(effectTypeIndex,paramIndex,value);if(didChange&&instFxList.IsEffectIndexActive(effectTypeIndex))this._runtime.UpdateRender()}const tempRect=C3.New(C3.Rect);const tempCandidates1=[];const tempCandidates2=[];let needsCollisionFinish=false;let rPickType=null;let rPickFromElseInstances=false;const rToPick=new Set;
function CollMemory_Add(collMemory,a,b,tickCount){const a_uid=a.GetUID();const b_uid=b.GetUID();if(a_uid<b_uid)collMemory.Set(a,b,tickCount);else collMemory.Set(b,a,tickCount)}function CollMemory_Remove(collMemory,a,b){const a_uid=a.GetUID();const b_uid=b.GetUID();if(a_uid<b_uid)collMemory.Delete(a,b);else collMemory.Delete(b,a)}function CollMemory_RemoveInstance(collMemory,inst){collMemory.DeleteEither(inst)}
function CollMemory_Get(collMemory,a,b){const a_uid=a.GetUID();const b_uid=b.GetUID();if(a_uid<b_uid)return collMemory.Get(a,b);else return collMemory.Get(b,a)}
function DoOverlapCondition(sdkInst,rtype,offX,offY){if(!rtype)return false;const inst=sdkInst.GetInstance();const hasOffset=offX!==0||offY!==0;const wi=inst.GetWorldInfo();const runtime=inst.GetRuntime();const collisionEngine=runtime.GetCollisionEngine();const cnd=runtime.GetCurrentCondition();const isOrBlock=cnd.GetEventBlock().IsOrBlock();const ltype=cnd.GetObjectClass();const isInverted=cnd.IsInverted();const rsol=rtype.GetCurrentSol();const isDifferentTypes=ltype!==rtype;rPickType=rtype;needsCollisionFinish=
isDifferentTypes&&!isInverted;rPickFromElseInstances=false;let rinstances;let oldX=0;let oldY=0;let ret=false;if(rsol.IsSelectAll()){tempRect.copy(wi.GetBoundingBox());tempRect.offset(offX,offY);collisionEngine.GetCollisionCandidates(wi.GetLayer(),rtype,tempRect,tempCandidates2);rinstances=tempCandidates2}else if(isOrBlock)if(runtime.IsCurrentConditionFirst()&&!rsol._GetOwnElseInstances().length&&rsol._GetOwnInstances().length)rinstances=rsol._GetOwnInstances();else{rinstances=rsol._GetOwnElseInstances();
rPickFromElseInstances=true}else rinstances=rsol._GetOwnInstances();if(hasOffset){oldX=wi.GetX();oldY=wi.GetY();wi.OffsetXY(offX,offY);wi.SetBboxChanged()}for(const rinst of rinstances)if(collisionEngine.TestOverlap(inst,rinst)){ret=true;if(isInverted)break;if(isDifferentTypes)rToPick.add(rinst)}if(hasOffset){wi.SetXY(oldX,oldY);wi.SetBboxChanged()}C3.clearArray(tempCandidates2);return ret}
function FinishCollisionConditionPicking(type){const isOrBlock=type.GetRuntime().GetCurrentEvent().IsOrBlock();const sol=rPickType.GetCurrentSol();const solInstances=sol._GetOwnInstances();const solElseInstances=sol._GetOwnElseInstances();if(sol.IsSelectAll()){sol.SetSetPicked(rToPick);if(isOrBlock){C3.clearArray(solElseInstances);sol.AddElseInstances(rToPick,rPickType.GetInstances())}}else if(isOrBlock)if(rPickFromElseInstances)sol.TransferElseInstancesToOwn(rToPick);else{sol.AddElseInstances(rToPick,
solInstances);sol.SetSetPicked(rToPick)}else sol.SetSetPicked(rToPick);rPickType.ApplySolToContainer()}function FinishCollisionCondition(type,doPick){if(!needsCollisionFinish)return;if(doPick)FinishCollisionConditionPicking(type);rToPick.clear();rPickType=null;needsCollisionFinish=false}
function OnCollision(rtype){if(this._runtime.IsDebugging())return DebugOnCollision.call(this,rtype);if(!rtype)return false;const runtime=this._runtime;const collisionEngine=runtime.GetCollisionEngine();const eventSheetManager=runtime.GetEventSheetManager();const eventStack=eventSheetManager.GetEventStack();const cnd=eventSheetManager.GetCurrentCondition();const ltype=cnd.GetObjectClass();const savedData=cnd.GetSavedDataMap();const unsavedData=cnd.GetUnsavedDataMap();const oldFrame=eventStack.GetCurrentStackFrame();
const tickCount=runtime.GetTickCount();const lastTickCount=tickCount-1;const currentEvent=oldFrame.GetCurrentEvent();const newFrame=eventStack.Push(currentEvent);let collMemory=savedData.get("collmemory");if(!collMemory){collMemory=C3.New(C3.PairMap);savedData.set("collmemory",collMemory)}if(!unsavedData.get("collisionCreatedDestroyCallback")){unsavedData.set("collisionCreatedDestroyCallback",true);runtime.Dispatcher().addEventListener("instancedestroy",e=>CollMemory_RemoveInstance(collMemory,e.instance))}const lsol=
ltype.GetCurrentSol();const rsol=rtype.GetCurrentSol();const linstances=lsol.GetInstances();let rinstances=null;for(let l=0;l<linstances.length;++l){const linst=linstances[l];if(rsol.IsSelectAll()){collisionEngine.GetCollisionCandidates(linst.GetWorldInfo().GetLayer(),rtype,linst.GetWorldInfo().GetBoundingBox(),tempCandidates1);rinstances=tempCandidates1;collisionEngine.AddRegisteredCollisionCandidates(linst,rtype,rinstances)}else rinstances=rsol.GetInstances();for(let r=0;r<rinstances.length;++r){const rinst=
rinstances[r];if(collisionEngine.TestOverlap(linst,rinst)||collisionEngine.CheckRegisteredCollision(linst,rinst)){const entry=CollMemory_Get(collMemory,linst,rinst);let entryExists=false;let lastCollTickCount=-2;if(typeof entry==="number"){entryExists=true;lastCollTickCount=entry}const shouldRun=!entryExists||lastCollTickCount<lastTickCount;CollMemory_Add(collMemory,linst,rinst,tickCount);if(shouldRun){const solModifiers=currentEvent.GetSolModifiers();eventSheetManager.PushCopySol(solModifiers);const curlsol=
ltype.GetCurrentSol();const currsol=rtype.GetCurrentSol();curlsol._SetSelectAll(false);currsol._SetSelectAll(false);if(ltype===rtype){const solInstances=curlsol._GetOwnInstances();C3.clearArray(solInstances);solInstances.push(linst);solInstances.push(rinst);ltype.ApplySolToContainer()}else{const lsolInstances=curlsol._GetOwnInstances();const rsolInstances=currsol._GetOwnInstances();C3.clearArray(lsolInstances);C3.clearArray(rsolInstances);lsolInstances.push(linst);rsolInstances.push(rinst);ltype.ApplySolToContainer();
rtype.ApplySolToContainer()}currentEvent.Retrigger(oldFrame,newFrame);eventSheetManager.PopSol(solModifiers)}}else CollMemory_Remove(collMemory,linst,rinst)}C3.clearArray(tempCandidates1)}eventStack.Pop();return false}
function*DebugOnCollision(rtype){if(!rtype)return false;const runtime=this._runtime;const collisionEngine=runtime.GetCollisionEngine();const eventSheetManager=runtime.GetEventSheetManager();const eventStack=eventSheetManager.GetEventStack();const cnd=eventSheetManager.GetCurrentCondition();const ltype=cnd.GetObjectClass();const savedData=cnd.GetSavedDataMap();const unsavedData=cnd.GetUnsavedDataMap();const oldFrame=eventStack.GetCurrentStackFrame();const tickCount=runtime.GetTickCount();const lastTickCount=
tickCount-1;const currentEvent=oldFrame.GetCurrentEvent();const newFrame=eventStack.Push(currentEvent);let collMemory=savedData.get("collmemory");if(!collMemory){collMemory=C3.New(C3.PairMap);savedData.set("collmemory",collMemory)}if(!unsavedData.get("collisionCreatedDestroyCallback")){unsavedData.set("collisionCreatedDestroyCallback",true);runtime.Dispatcher().addEventListener("instancedestroy",e=>CollMemory_RemoveInstance(collMemory,e.instance))}const lsol=ltype.GetCurrentSol();const rsol=rtype.GetCurrentSol();
const linstances=lsol.GetInstances();let rinstances=null;for(let l=0;l<linstances.length;++l){const linst=linstances[l];if(rsol.IsSelectAll()){collisionEngine.GetCollisionCandidates(linst.GetWorldInfo().GetLayer(),rtype,linst.GetWorldInfo().GetBoundingBox(),tempCandidates1);rinstances=tempCandidates1;collisionEngine.AddRegisteredCollisionCandidates(linst,rtype,rinstances)}else rinstances=rsol.GetInstances();for(let r=0;r<rinstances.length;++r){const rinst=rinstances[r];if(collisionEngine.TestOverlap(linst,
rinst)||collisionEngine.CheckRegisteredCollision(linst,rinst)){const entry=CollMemory_Get(collMemory,linst,rinst);let entryExists=false;let lastCollTickCount=-2;if(typeof entry==="number"){entryExists=true;lastCollTickCount=entry}const shouldRun=!entryExists||lastCollTickCount<lastTickCount;CollMemory_Add(collMemory,linst,rinst,tickCount);if(shouldRun){const solModifiers=currentEvent.GetSolModifiers();eventSheetManager.PushCopySol(solModifiers);const curlsol=ltype.GetCurrentSol();const currsol=rtype.GetCurrentSol();
curlsol._SetSelectAll(false);currsol._SetSelectAll(false);if(ltype===rtype){const solInstances=curlsol._GetOwnInstances();C3.clearArray(solInstances);solInstances.push(linst);solInstances.push(rinst);ltype.ApplySolToContainer()}else{const lsolInstances=curlsol._GetOwnInstances();const rsolInstances=currsol._GetOwnInstances();C3.clearArray(lsolInstances);C3.clearArray(rsolInstances);lsolInstances.push(linst);rsolInstances.push(rinst);ltype.ApplySolToContainer();rtype.ApplySolToContainer()}yield*currentEvent.DebugRetrigger(oldFrame,
newFrame);eventSheetManager.PopSol(solModifiers)}}else CollMemory_Remove(collMemory,linst,rinst)}C3.clearArray(tempCandidates1)}eventStack.Pop();return false}function IsOverlapping(rtype){return DoOverlapCondition(this,rtype,0,0)}function IsOverlappingOffset(rtype,offX,offY){return DoOverlapCondition(this,rtype,offX,offY)}function HasParent(){return this.GetWorldInfo().HasParent()}function HasChildren(){return this.GetWorldInfo().HasChildren()}
function PickParent(parentObjectClass,which){const mySol=this.GetCurrentSol();const myInstances=mySol.GetInstances();if(myInstances.length===0)return false;const parentSol=parentObjectClass.GetCurrentSol();let parentInstances=parentSol.GetInstances();if(parentSol.IsSelectAll()){const parentInstsPendingCreate=[...this._runtime.instancesPendingCreateForObjectClass(parentObjectClass)];if(parentInstsPendingCreate.length>0)parentInstances=parentInstances.concat(parentInstsPendingCreate)}if(parentInstances.length===
0)return false;const parentInstancesSet=new Set(parentInstances);const pickParents=new Set;for(let i=0,len=myInstances.length;i<len;++i){const myInst=myInstances[i];if(which===1)for(const parentInst of myInst.parents()){if(parentInst.BelongsToObjectClass(parentObjectClass)&&parentInstancesSet.has(parentInst))pickParents.add(parentInst)}else{let parentInst;if(which===0){parentInst=myInst.GetParent();if(parentInst===null)continue}else parentInst=myInst.GetTopParent();if(parentInst.BelongsToObjectClass(parentObjectClass)&&
parentInstancesSet.has(parentInst))pickParents.add(parentInst)}}if(pickParents.size===0)return false;parentSol.SetSetPicked(pickParents);parentObjectClass.ApplySolToContainer();return true}
function PickChildren(childObjectClass,which){const mySol=this.GetCurrentSol();const myInstances=mySol.GetInstances();if(myInstances.length===0)return false;const childSol=childObjectClass.GetCurrentSol();let childInstances=childSol.GetInstances();if(childSol.IsSelectAll()){const childInstsPendingCreate=[...this._runtime.instancesPendingCreateForObjectClass(childObjectClass)];if(childInstsPendingCreate.length>0)childInstances=childInstances.concat(childInstsPendingCreate)}if(childInstances.length===
0)return false;const childInstancesSet=new Set(childInstances);const pickChildren=new Set;for(let i=0,len=myInstances.length;i<len;++i){const myInst=myInstances[i];if(which===2&&!myInst.HasChildren()&&myInst.BelongsToObjectClass(childObjectClass)&&childInstancesSet.has(myInst))pickChildren.add(myInst);for(const childInst of which===0?myInst.children():myInst.allChildren()){if(which===2&&childInst.HasChildren())continue;if(childInst.BelongsToObjectClass(childObjectClass)&&childInstancesSet.has(childInst))pickChildren.add(childInst)}}if(pickChildren.size===
0)return false;childSol.SetSetPicked(pickChildren);childObjectClass.ApplySolToContainer();return true}
function PickNthChild(childObjectClass,index){const mySol=this.GetCurrentSol();const myInstances=mySol.GetInstances();if(myInstances.length===0)return false;const childSol=childObjectClass.GetCurrentSol();let childInstances=childSol.GetInstances();if(childSol.IsSelectAll()){const childInstsPendingCreate=[...this._runtime.instancesPendingCreateForObjectClass(childObjectClass)];if(childInstsPendingCreate.length>0)childInstances=childInstances.concat(childInstsPendingCreate)}if(childInstances.length===
0)return false;const childInstancesSet=new Set(childInstances);const pickChildren=[];for(let i=0,len=myInstances.length;i<len;++i){const myInst=myInstances[i];const childInst=myInst.GetChildAt(index);if(childInst!==null&&childInst.BelongsToObjectClass(childObjectClass)&&childInstancesSet.has(childInst))pickChildren.push(childInst)}if(pickChildren.length===0)return false;childSol.SetArrayPicked(pickChildren);childObjectClass.ApplySolToContainer();return true}
function CompareChildCount(which,cmp,count){switch(which){case 0:default:{return C3.compare(this._inst.GetChildCount(),cmp,count)}case 1:{return C3.compare(this._inst.GetAllChildCount(),cmp,count)}}}
function AddChild(childObjectClass,transformX,transformY,transformWidth,transformHeight,transformAngle,transformOpacity,transformZElevation,transformVisibility,destroyWithParent){const inst=this._inst;const actObjectClass=this._runtime.GetCurrentAction().GetObjectClass();for(const child of childObjectClass.allCorrespondingInstances(inst,actObjectClass)){if(!child.GetPlugin().SupportsSceneGraph())return;inst.AddChild(child,{transformX,transformY,transformWidth,transformHeight,transformAngle,transformOpacity,
transformZElevation,transformVisibility,destroyWithParent})}}function RemoveChild(childObjectClass){const inst=this._inst;const actObjectClass=this._runtime.GetCurrentAction().GetObjectClass();for(const child of childObjectClass.allCorrespondingInstances(inst,actObjectClass))inst.RemoveChild(child)}function RemoveFromParent(){if(!this._inst.HasParent())return;const parent=this._inst.GetParent();parent.RemoveChild(this._inst)}function ChildCount(){return this._inst.GetChildCount()}
function AllChildCount(){return this._inst.GetAllChildCount()}function SetMeshSize(cols,rows){cols=Math.floor(cols);rows=Math.floor(rows);const wi=this.GetWorldInfo();if(cols<2||rows<2||!isFinite(cols)||!isFinite(rows)){wi.ReleaseMesh();wi.SetBboxChanged()}else wi.CreateMesh(cols,rows)}
function SetMeshPoint(col,row,mode,posx,posy,zElevation,texu,texv){const wi=this.GetWorldInfo();const didBboxChange=wi.SetMeshPoint(col,row,{mode:mode===0?"absolute":"relative",x:posx,y:posy,zElevation,u:texu,v:texv});if(didBboxChange)wi.SetBboxChanged()}function MeshColumns(){const wi=this.GetWorldInfo();return wi.HasMesh()?wi.GetSourceMesh().GetHSize():0}function MeshRows(){const wi=this.GetWorldInfo();return wi.HasMesh()?wi.GetSourceMesh().GetVSize():0}
function SetElementVisible(v){const wi=this.GetWorldInfo();if(v===2)v=!wi.IsVisible();else v=v!==0;if(wi.IsVisible()===v)return;wi.SetVisible(v)}function SetElementCSSStyle(prop,val){this.SetElementCSSStyle(prop,val)}function SetElementAttribute(attribName,value){this.SetElementAttribute(attribName,""+value)}function RemoveElementAttribute(attribName){this.RemoveElementAttribute(attribName)}function SetElementFocus(){this.FocusElement()}function SetElementBlur(){this.BlurElement()}
function IsElementFocused(){return this.IsElementFocused()}function SetElementEnabled(e){this._SetEnabled(e!==0)}function IsElementEnabled(){return this._IsEnabled()}function CompareInstanceVar(iv,cmp,val){return C3.compare(this.GetInstance().GetInstanceVariableValue(iv),cmp,val)}function IsBoolInstanceVarSet(iv){return!!this.GetInstance().GetInstanceVariableValue(iv)}function TemplateName(){return this.GetInstance().GetTemplateName()}
function PickInstVarHiLow(which,iv){const sol=this.GetCurrentSol();const instances=sol.GetInstances();if(!instances.length)return false;const isFamily=this.IsFamily();let pickInst=null;let bestVal=0;for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];const offset=isFamily?inst.GetObjectClass().GetFamilyInstanceVariableOffset(this.GetFamilyIndex()):0;const v=inst.GetInstanceVariableValue(offset+iv);if(pickInst===null||which===0&&v<bestVal||which===1&&v>bestVal){bestVal=v;pickInst=inst}}sol.PickOne(pickInst);
return true}function PickByUID(uid){if(this._runtime.GetCurrentCondition().IsInverted())return PickByUID_Inverted(this,uid);else return PickByUID_Normal(this,uid)}
function PickByUID_Normal(objectClass,uid){const inst=objectClass.GetRuntime().GetInstanceByUID(uid);if(!inst)return false;const sol=objectClass.GetCurrentSol();if(!sol.IsSelectAll()&&!sol._GetOwnInstances().includes(inst))return false;if(objectClass.IsFamily()){if(inst.GetObjectClass().BelongsToFamily(objectClass)){sol.PickOne(inst);objectClass.ApplySolToContainer();return true}}else if(inst.GetObjectClass()===objectClass){sol.PickOne(inst);objectClass.ApplySolToContainer();return true}return false}
function PickByUID_Inverted(objectClass,uid){const sol=objectClass.GetCurrentSol();if(sol.IsSelectAll()){sol._SetSelectAll(false);sol.ClearArrays();const instances=objectClass.GetInstances();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];if(inst.GetUID()===uid)sol._PushElseInstance(inst);else sol._PushInstance(inst)}objectClass.ApplySolToContainer();return!!sol._GetOwnInstances().length}else{const instances=sol._GetOwnInstances();let j=0;for(let i=0,len=instances.length;i<len;++i){const inst=
instances[i];instances[j]=inst;if(inst.GetUID()===uid)sol._PushElseInstance(inst);else++j}C3.truncateArray(instances,j);objectClass.ApplySolToContainer();return!!instances.length}}function Destroy(){this._runtime.DestroyInstance(this._inst)}function OnCreated(){return true}function OnDestroyed(){return true}function SetInstanceVar(iv,value){this.GetInstance().SetInstanceVariableValue(iv,value)}
function AddInstanceVar(iv,value){const instance=this.GetInstance();const lastValue=instance.GetInstanceVariableValue(iv);if(typeof lastValue==="number"&&typeof value!=="number")value=parseFloat(value);else if(typeof lastValue==="string"&&typeof value!=="string")value=value.toString();instance.SetInstanceVariableValue(iv,lastValue+value)}
function SubInstanceVar(iv,value){const instance=this.GetInstance();const lastValue=instance.GetInstanceVariableValue(iv);if(typeof lastValue!=="number")return;if(typeof value!=="number")value=parseFloat(value);instance.SetInstanceVariableValue(iv,lastValue-value)}function SetBoolInstanceVar(iv,value){this.GetInstance().SetInstanceVariableValue(iv,value?1:0)}
function ToggleBoolInstanceVar(iv){const instance=this.GetInstance();instance.SetInstanceVariableValue(iv,instance.GetInstanceVariableValue(iv)===0?1:0)}
function LoadFromJsonString(str){let o;try{o=JSON.parse(str)}catch(err){console.error("Failed to load from JSON string: ",err);return}const inst=this.GetInstance();const mode="state";inst._OnBeforeLoad(mode);inst.LoadFromJson(o,mode);const event=C3.New(C3.Event,"afterloadinstance");event["instance"]=inst;this._runtime.Dispatcher().dispatchEvent(event)}function AsJSON(){return JSON.stringify(this.GetInstance().SaveToJson("state"))}
function ObjectTypeName(){return this.GetInstance().GetObjectClass().GetName()}function Count(){const expObjectClass=this._runtime.GetCurrentEventStackFrame().GetExpressionObjectClass();let count=expObjectClass.GetInstanceCount();for(const inst of this._runtime.instancesPendingCreateForObjectClass(expObjectClass))++count;return count}function PickedCount(){return this._runtime.GetCurrentEventStackFrame().GetExpressionObjectClass().GetCurrentSol().GetInstances().length}
function GetIID(){return this._inst.GetIID()}function GetUID(){return this._inst.GetUID()}
C3.AddCommonACEs=function AddCommonACEs(pluginData,pluginCtor){const isSingleGlobal=pluginData[1];const hasPositionACEs=pluginData[3];const hasSizeACEs=pluginData[4];const hasAngleACEs=pluginData[5];const hasAppearanceACEs=pluginData[6];const hasZOrderACEs=pluginData[7];const hasEffectsACEs=pluginData[8];const hasElementACEs=pluginData[10];const hasElementFocusACEs=pluginData[11];const hasElementEnabledACEs=pluginData[12];const hasSceneGraphACEs=pluginData[13];const hasMeshACEs=pluginData[14];const hasCollisionACEs=
pluginData[15];const hasTemplateACEs=pluginData[16];const Cnds=pluginCtor.Cnds;const Acts=pluginCtor.Acts;const Exps=pluginCtor.Exps;if(hasPositionACEs){Cnds.CompareX=CompareX;Cnds.CompareY=CompareY;Cnds.IsOnScreen=IsOnScreen;Cnds.IsOutsideLayout=IsOutsideLayout;Cnds.PickDistance=PickDistance;Acts.SetX=SetX;Acts.SetY=SetY;Acts.SetPos=SetPos;Acts.SetPosToObject=SetPosToObject;Acts.MoveForward=MoveForward;Acts.MoveAtAngle=MoveAtAngle;Exps.X=GetX;Exps.Y=GetY;Exps.dt=GetDt}if(hasSizeACEs){Cnds.CompareWidth=
CompareWidth;Cnds.CompareHeight=CompareHeight;Acts.SetWidth=SetWidth;Acts.SetHeight=SetHeight;Acts.SetSize=SetSize;Exps.Width=GetWidth;Exps.Height=GetHeight;Exps.BBoxLeft=GetBboxLeft;Exps.BBoxTop=GetBboxTop;Exps.BBoxRight=GetBboxRight;Exps.BBoxBottom=GetBboxBottom;Exps.BBoxMidX=GetBboxMidX;Exps.BBoxMidY=GetBboxMidY}if(hasAngleACEs){Cnds.AngleWithin=IsAngleWithin;Cnds.IsClockwiseFrom=IsAngleClockwiseFrom;Cnds.IsBetweenAngles=IsBetweenAngles;Acts.SetAngle=SetAngle;Acts.RotateClockwise=RotateClockwise;
Acts.RotateCounterclockwise=RotateCounterclockwise;Acts.RotateTowardAngle=RotateTowardAngle;Acts.RotateTowardPosition=RotateTowardPosition;Acts.SetTowardPosition=SetTowardPosition;Exps.Angle=GetAngle}if(hasAppearanceACEs){Cnds.IsVisible=IsVisible;Cnds.CompareOpacity=CompareOpacity;Acts.SetVisible=SetVisible;Acts.SetOpacity=SetOpacity;Acts.SetDefaultColor=SetDefaultColor;Exps.Opacity=GetOpacity;Exps.ColorValue=GetColor}if(hasZOrderACEs){Cnds.IsOnLayer=IsOnLayer;Cnds.PickTopBottom=PickTopBottom;Cnds.CompareZElevation=
CompareZElevation;Acts.MoveToTop=MoveToTop;Acts.MoveToBottom=MoveToBottom;Acts.MoveToLayer=MoveToLayer;Acts.ZMoveToObject=ZMoveToObject;Acts.SetZElevation=SetZElevation;Exps.LayerNumber=LayerNumber;Exps.LayerName=LayerName;Exps.ZIndex=ZIndex;Exps.ZElevation=ZElevation;Exps.TotalZElevation=TotalZElevation}if(hasEffectsACEs){Cnds.IsEffectEnabled=IsEffectEnabled;Acts.SetEffectEnabled=SetEffectEnabled;Acts.SetEffectParam=SetEffectParam}if(hasSceneGraphACEs){Cnds.HasParent=HasParent;Cnds.HasChildren=HasChildren;
Cnds.PickParent=PickParent;Cnds.PickChildren=PickChildren;Cnds.PickNthChild=PickNthChild;Cnds.CompareChildCount=CompareChildCount;Acts.AddChild=AddChild;Acts.RemoveChild=RemoveChild;Acts.RemoveFromParent=RemoveFromParent;Exps.ChildCount=ChildCount;Exps.AllChildCount=AllChildCount}if(hasMeshACEs){Acts.SetMeshSize=SetMeshSize;Acts.SetMeshPoint=SetMeshPoint;Exps.MeshColumns=MeshColumns;Exps.MeshRows=MeshRows}if(hasElementACEs){Cnds.IsVisible=IsVisible;Acts.SetVisible=SetElementVisible;Acts.SetCSSStyle=
SetElementCSSStyle;Acts.SetElemAttribute=SetElementAttribute;Acts.RemoveElemAttribute=RemoveElementAttribute}if(hasElementFocusACEs){Cnds.IsFocused=IsElementFocused;Acts.SetFocus=SetElementFocus;Acts.SetBlur=SetElementBlur}if(hasElementEnabledACEs){Cnds.IsEnabled=IsElementEnabled;Acts.SetEnabled=SetElementEnabled}if(hasCollisionACEs){Cnds.OnCollision=OnCollision;Cnds.IsOverlapping=IsOverlapping;Cnds.IsOverlappingOffset=IsOverlappingOffset;pluginCtor.FinishCollisionCondition=FinishCollisionCondition}if(!isSingleGlobal){Cnds.CompareInstanceVar=
CompareInstanceVar;Cnds.IsBoolInstanceVarSet=IsBoolInstanceVarSet;Cnds.PickInstVarHiLow=PickInstVarHiLow;Cnds.PickByUID=PickByUID;Acts.SetInstanceVar=SetInstanceVar;Acts.AddInstanceVar=AddInstanceVar;Acts.SubInstanceVar=SubInstanceVar;Acts.SetBoolInstanceVar=SetBoolInstanceVar;Acts.ToggleBoolInstanceVar=ToggleBoolInstanceVar;Cnds.OnCreated=OnCreated;Cnds.OnDestroyed=OnDestroyed;Acts.Destroy=Destroy;if(!Acts.LoadFromJsonString)Acts.LoadFromJsonString=LoadFromJsonString;if(!Exps.AsJSON)Exps.AsJSON=
AsJSON;Exps.Count=Count;Exps.PickedCount=PickedCount;Exps.IID=GetIID;Exps.UID=GetUID;Exps.ObjectTypeName=ObjectTypeName}if(hasTemplateACEs)Exps.TemplateName=TemplateName};

}

// events/scheduledWait.js
{
'use strict';const C3=self.C3;
C3.ScheduledWait=class ScheduledWait extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._type="";this._time=-1;this._signalTag="";this._isSignalled=false;this._event=null;this._actIndex=0;this._solModifiers=[];this._dynamicSolModifiers=null;this._sols=new Map;this._callingFunctionBlock=null;this._asyncId=-1;this._functionParameters=null;this._functionInnerLocalVars=null;this._shouldRelease=false}Release(){this._type="";this._time=-1;this._signalTag=
"";this._event=null;this._callingFunctionBlock=null;this._functionParameters=null;this._functionInnerLocalVars=null;this._asyncId=-1;C3.clearArray(this._solModifiers);if(this._dynamicSolModifiers){this._dynamicSolModifiers.clear();this._dynamicSolModifiers=null}for(const s of this._sols.values())s.Release();this._sols.clear()}_Init(){const eventSheetManager=this._eventSheetManager;const allObjectClasses=eventSheetManager.GetRuntime().GetAllObjectClasses();const frame=eventSheetManager.GetCurrentEventStackFrame();
this._event=frame.GetCurrentEvent();this._actIndex=frame.GetActionIndex()+1;const functionBlock=eventSheetManager.FindFirstFunctionBlockParent(this._event);if(functionBlock){this._callingFunctionBlock=functionBlock;this._functionParameters=functionBlock.CaptureFunctionParameters();this._functionInnerLocalVars=functionBlock._GetAllInnerLocalVariables().map(v=>v.GetValue());if(functionBlock.IsAsync())this._asyncId=functionBlock.PauseCurrentAsyncFunction()}for(const objectClass of allObjectClasses){const sol=
objectClass.GetCurrentSol();if(sol.IsSelectAll()&&!this._event.HasSolModifier(objectClass))continue;this._solModifiers.push(objectClass);this._sols.set(objectClass,C3.New(C3.SolState,sol))}const dynamicSolModifiersSet=eventSheetManager.GetDynamicSolModifiersSet();this._dynamicSolModifiers=dynamicSolModifiersSet.size>0?dynamicSolModifiersSet:null}InitTimer(seconds){this._type="timer";this._Init();this._time=this._eventSheetManager.GetRuntime().GetGameTime()+seconds}InitSignal(tag){this._type="signal";
this._Init();this._signalTag=tag.toLowerCase()}InitPromise(p){this._type="promise";this._Init();p.then(()=>this.SetSignalled()).catch(err=>{console.warn("[C3 runtime] Promise rejected in 'Wait for previous actions to complete': ",err);this.SetSignalled()})}IsTimer(){return this._type==="timer"}IsSignal(){return this._type==="signal"}IsPromise(){return this._type==="promise"}GetSignalTag(){return this._signalTag}IsSignalled(){return this._isSignalled}SetSignalled(){this._isSignalled=true}_ShouldRun(){if(this.IsTimer())return this._time<=
this._eventSheetManager.GetRuntime().GetGameTime();else return this.IsSignalled()}_RestoreState(frame){frame._Restore(this._event,this._actIndex);for(const [objectClass,solState]of this._sols.entries()){const sol=objectClass.GetCurrentSol();solState._Restore(sol)}if(this._dynamicSolModifiers)frame.SetDynamicSolModifiers([...this._dynamicSolModifiers]);const callingFunctionBlock=this._callingFunctionBlock;if(callingFunctionBlock){callingFunctionBlock.SetFunctionParameters(this._functionParameters);
callingFunctionBlock._GetAllInnerLocalVariables().map((v,index)=>v.SetValue(this._functionInnerLocalVars[index]));if(callingFunctionBlock.IsAsync())callingFunctionBlock.ResumeAsyncFunction(this._asyncId)}}_Run(frame){this._RestoreState(frame);this._event._ResumeActionsAndSubEvents(frame);if(this._callingFunctionBlock&&this._callingFunctionBlock.IsAsync())this._callingFunctionBlock.MaybeFinishAsyncFunctionCall(this._asyncId);this._eventSheetManager.ClearSol(this._solModifiers);this._shouldRelease=
true}async _DebugRun(frame){this._RestoreState(frame);for(const breakEventObject of this._event._DebugResumeActionsAndSubEvents(frame))await this._eventSheetManager.GetRuntime().DebugBreak(breakEventObject);if(this._callingFunctionBlock&&this._callingFunctionBlock.IsAsync())this._callingFunctionBlock.MaybeFinishAsyncFunctionCall(this._asyncId);this._eventSheetManager.ClearSol(this._solModifiers);this._shouldRelease=true}ShouldRelease(){return this._shouldRelease}RemoveInstances(s){for(const solState of this._sols.values())solState.RemoveInstances(s)}_SaveToJson(){const sols=
{};const o={"t":this._time,"st":this._signalTag,"s":this._isSignalled,"ev":this._event.GetSID(),"sm":this._solModifiers.map(oc=>oc.GetSID()),"dsm":this._dynamicSolModifiers?[...this._dynamicSolModifiers].map(oc=>oc.GetSID()):null,"sols":sols};if(this._event._HasActionIndex(this._actIndex))o["act"]=this._event.GetActionAt(this._actIndex).GetSID();for(const [objectClass,solState]of this._sols)sols[objectClass.GetSID().toString()]=solState._SaveToJson();return o}static _CreateFromJson(eventSheetManager,
o){const runtime=eventSheetManager.GetRuntime();const event=eventSheetManager.GetEventBlockBySID(o["ev"]);if(!event)return null;let actIndex=0;if(o.hasOwnProperty("act")){const act=eventSheetManager.GetActionBySID(o["act"]);if(!act)return null;actIndex=act.GetIndex()}const sw=C3.New(C3.ScheduledWait,eventSheetManager);sw._time=o["t"];sw._type=sw._time===-1?"signal":"timer";sw._signalTag=o["st"];sw._isSignalled=o["s"];sw._event=event;sw._actIndex=actIndex;for(const sid of o["sm"]){const objectClass=
runtime.GetObjectClassBySID(sid);if(objectClass)sw._solModifiers.push(objectClass)}if(Array.isArray(o["dsm"]))for(const sid of o["dsm"]){const objectClass=runtime.GetObjectClassBySID(sid);if(objectClass){if(!sw._dynamicSolModifiers)sw._dynamicSolModifiers=new Set;sw._dynamicSolModifiers.add(objectClass)}}for(const [sidStr,solData]of Object.entries(o["sols"])){const sid=parseInt(sidStr,10);const objectClass=runtime.GetObjectClassBySID(sid);if(!objectClass)continue;const solState=C3.New(C3.SolState,
null);solState._LoadFromJson(eventSheetManager,solData);sw._sols.set(objectClass,solState)}return sw}};

}

// events/solState.js
{
'use strict';const C3=self.C3;
C3.SolState=class SolState extends C3.DefendedBase{constructor(sol){super();this._objectClass=null;this._isSelectAll=true;this._instances=[];if(sol){this._objectClass=sol.GetObjectClass();this._isSelectAll=sol.IsSelectAll();C3.shallowAssignArray(this._instances,sol._GetOwnInstances())}}Release(){this._objectClass=null;C3.clearArray(this._instances)}_Restore(sol){sol._SetSelectAll(this._isSelectAll);C3.shallowAssignArray(sol._GetOwnInstances(),this._instances)}RemoveInstances(s){C3.arrayRemoveAllInSet(this._instances,s)}_SaveToJson(){return{"sa":this._isSelectAll,
"insts":this._instances.map(inst=>inst.GetUID())}}_LoadFromJson(eventSheetManager,o){const runtime=eventSheetManager.GetRuntime();this._isSelectAll=!!o["sa"];C3.clearArray(this._instances);for(const uid of o["insts"]){const inst=runtime.GetInstanceByUID(uid);if(inst)this._instances.push(inst)}}};

}

// sdk/sdkPluginBase.js
{
'use strict';const C3=self.C3;function GetNextParamMap(paramMap,param){let nextParamMap=paramMap.get(param);if(!nextParamMap){nextParamMap=new Map;paramMap.set(param,nextParamMap)}return nextParamMap}
C3.SDKPluginBase=class SDKPluginBase extends C3.DefendedBase{constructor(opts){super();this._runtime=opts.runtime;this._isSingleGlobal=!!opts.isSingleGlobal;this._isWorldType=!!opts.isWorld;this._isRotatable=!!opts.isRotatable;this._mustPredraw=!!opts.mustPredraw;this._hasEffects=!!opts.hasEffects;this._supportsSceneGraph=!!opts.supportsSceneGraph;this._supportsMesh=!!opts.supportsMesh;this._singleGlobalObjectClass=null;this._boundACEMethodCache=new Map;this._boundACEMethodCache_1param=new Map;this._boundACEMethodCache_2params=
new Map;this._boundACEMethodCache_3params=new Map}Release(){this._runtime=null}GetRuntime(){return this._runtime}OnCreate(){}IsSingleGlobal(){return this._isSingleGlobal}IsWorldType(){return this._isWorldType}IsRotatable(){return this._isRotatable}MustPreDraw(){return this._mustPredraw}HasEffects(){return this._hasEffects}SupportsSceneGraph(){return this._supportsSceneGraph}SupportsMesh(){return this._supportsMesh}_GetBoundACEMethod(func,bindThis){if(!bindThis)throw new Error("missing 'this' binding");
let ret=this._boundACEMethodCache.get(func);if(ret)return ret;ret=func.bind(bindThis);this._boundACEMethodCache.set(func,ret);return ret}_GetBoundACEMethod_1param(func,bindThis,param0){if(!bindThis)throw new Error("missing 'this' binding");const param0map=GetNextParamMap(this._boundACEMethodCache_1param,func);let ret=param0map.get(param0);if(ret)return ret;ret=func.bind(bindThis,param0);param0map.set(param0,ret);return ret}_GetBoundACEMethod_2params(func,bindThis,param0,param1){if(!bindThis)throw new Error("missing 'this' binding");
const param0map=GetNextParamMap(this._boundACEMethodCache_2params,func);const param1map=GetNextParamMap(param0map,param0);let ret=param1map.get(param1);if(ret)return ret;ret=func.bind(bindThis,param0,param1);param1map.set(param1,ret);return ret}_GetBoundACEMethod_3params(func,bindThis,param0,param1,param2){if(!bindThis)throw new Error("missing 'this' binding");const param0map=GetNextParamMap(this._boundACEMethodCache_3params,func);const param1map=GetNextParamMap(param0map,param0);const param2map=
GetNextParamMap(param1map,param1);let ret=param2map.get(param2);if(ret)return ret;ret=func.bind(bindThis,param0,param1,param2);param2map.set(param2,ret);return ret}_SetSingleGlobalObjectClass(objectClass){if(!this.IsSingleGlobal())throw new Error("must be single-global plugin");this._singleGlobalObjectClass=objectClass}GetSingleGlobalObjectClass(){if(!this.IsSingleGlobal())throw new Error("must be single-global plugin");return this._singleGlobalObjectClass}GetSingleGlobalInstance(){if(!this.IsSingleGlobal())throw new Error("must be single-global plugin");
return this._singleGlobalObjectClass.GetSingleGlobalInstance()}};

}

// sdk/sdkDOMPluginBase.js
{
'use strict';const C3=self.C3;
C3.SDKDOMPluginBase=class SDKDOMPluginBase extends C3.SDKPluginBase{constructor(opts,DOM_COMPONENT_ID){super(opts);this._domComponentId=DOM_COMPONENT_ID;this._nextElementId=0;this._instMap=new Map;this.AddElementMessageHandler("elem-focused",sdkInst=>sdkInst._OnElemFocused());this.AddElementMessageHandler("elem-blurred",sdkInst=>{if(sdkInst)sdkInst._OnElemBlurred()})}Release(){super.Release()}_AddElement(sdkInst){const elementId=this._nextElementId++;this._instMap.set(elementId,sdkInst);return elementId}_RemoveElement(elementId){this._instMap.delete(elementId)}AddElementMessageHandler(handler,
func){this._runtime.AddDOMComponentMessageHandler(this._domComponentId,handler,e=>{const sdkInst=this._instMap.get(e["elementId"]);func(sdkInst,e)})}};

}

// sdk/sdkTypeBase.js
{
'use strict';const C3=self.C3;
C3.SDKTypeBase=class SDKTypeBase extends C3.DefendedBase{constructor(objectClass){super();this._objectClass=objectClass;this._runtime=objectClass.GetRuntime();this._plugin=objectClass.GetPlugin()}Release(){this._objectClass=null;this._runtime=null;this._plugin=null}GetObjectClass(){return this._objectClass}GetRuntime(){return this._runtime}GetPlugin(){return this._plugin}GetImageInfo(){return this._objectClass.GetImageInfo()}OnCreate(){}FinishCondition(f){}BeforeRunAction(method){}AfterRunAction(method){}LoadTextures(renderer){}ReleaseTextures(){}OnDynamicTextureLoadComplete(){}PreloadTexturesWithInstances(renderer){}LoadTilemapData(){}GetScriptInterfaceClass(){return null}DispatchScriptEvent(name,cancelable,
additionalProperties){const e=C3.New(C3.Event,name,cancelable);e.objectClass=this;if(additionalProperties)Object.assign(e,additionalProperties);this.GetObjectClass().DispatchUserScriptEvent(e)}};

}

// sdk/sdkInstanceBase.js
{
'use strict';const C3=self.C3;
C3.SDKInstanceBase=class SDKInstanceBase extends C3.DefendedBase{constructor(inst,domComponentId){super();this._inst=inst;this._domComponentId=domComponentId;this._runtime=inst.GetRuntime();this._objectClass=this._inst.GetObjectClass();this._sdkType=this._objectClass.GetSdkType();this._tickFunc=null;this._tick2Func=null;this._isTicking=false;this._isTicking2=false;this._disposables=null;this._wasReleased=false}Release(){this._wasReleased=true;this._StopTicking();this._StopTicking2();this._tickFunc=
null;this._tick2Func=null;if(this._disposables){this._disposables.Release();this._disposables=null}this._inst=null;this._runtime=null;this._objectClass=null;this._sdkType=null}WasReleased(){return this._wasReleased}GetInstance(){return this._inst}GetRuntime(){return this._runtime}GetObjectClass(){return this._objectClass}GetPlugin(){return this._sdkType.GetPlugin()}GetSdkType(){return this._sdkType}GetScriptInterface(){return this._inst.GetInterfaceClass()}Trigger(method){return this._runtime.Trigger(method,
this._inst,null)}DebugTrigger(method){return this._runtime.DebugTrigger(method,this._inst,null)}TriggerAsync(method){return this._runtime.TriggerAsync(method,this._inst,null)}FastTrigger(method,value){return this._runtime.FastTrigger(method,this._inst,value)}DebugFastTrigger(method,value){return this._runtime.DebugFastTrigger(method,this._inst,value)}ScheduleTriggers(f){return this._runtime.ScheduleTriggers(f)}AddDOMMessageHandler(handler,func){this._runtime.AddDOMComponentMessageHandler(this._domComponentId,
handler,func)}AddDOMMessageHandlers(list){for(const [handler,func]of list)this.AddDOMMessageHandler(handler,func)}PostToDOM(handler,data){this._runtime.PostComponentMessageToDOM(this._domComponentId,handler,data)}PostToDOMAsync(handler,data){return this._runtime.PostComponentMessageToDOMAsync(this._domComponentId,handler,data)}_PostToDOMMaybeSync(handler,data){if(this._runtime.IsInWorker())this.PostToDOM(handler,data);else return window["c3_runtimeInterface"]["_OnMessageFromRuntime"]({"type":"event",
"component":this._domComponentId,"handler":handler,"data":data,"responseId":null})}Tick(){}Tick2(){}_StartTicking(){if(this._isTicking)return;if(!this._tickFunc)this._tickFunc=()=>this.Tick();this._runtime.Dispatcher().addEventListener("tick",this._tickFunc);this._isTicking=true}_StopTicking(){if(!this._isTicking)return;this._runtime.Dispatcher().removeEventListener("tick",this._tickFunc);this._isTicking=false}IsTicking(){return this._isTicking}_StartTicking2(){if(this._isTicking2)return;if(!this._tick2Func)this._tick2Func=
()=>this.Tick2();this._runtime.Dispatcher().addEventListener("tick2",this._tick2Func);this._isTicking2=true}_StopTicking2(){if(!this._isTicking2)return;this._runtime.Dispatcher().removeEventListener("tick2",this._tick2Func);this._isTicking2=false}IsTicking2(){return this._isTicking2}GetDebuggerProperties(){return[]}SaveToJson(){return null}LoadFromJson(o){}GetPropertyValueByIndex(index){}SetPropertyValueByIndex(index,value){}OffsetPropertyValueByIndex(index,offset,opts){if(offset===0)return;const value=
this.GetPropertyValueByIndex(index);if(typeof value!=="number")throw new Error("expected number");this.SetPropertyValueByIndex(index,value+offset,opts)}SetPropertyColorOffsetValueByIndex(offset,r,g,b){}CallAction(actMethod,...args){actMethod.call(this,...args)}CallExpression(expMethod,...args){return expMethod.call(this,...args)}GetScriptInterfaceClass(){return null}DispatchScriptEvent(name,cancelable,additionalProperties){if(!this._inst.HasScriptInterface())return;const scriptInterface=this.GetScriptInterface();
const e=C3.New(C3.Event,name,cancelable);e.instance=scriptInterface;if(additionalProperties)Object.assign(e,additionalProperties);scriptInterface.dispatchEvent(e)}};

}

// sdk/sdkWorldInstanceBase.js
{
'use strict';const C3=self.C3;
C3.SDKWorldInstanceBase=class SDKWorldInstanceBase extends C3.SDKInstanceBase{constructor(inst,domComponentId){super(inst,domComponentId);this._worldInfo=inst.GetWorldInfo();this._renderercontextlost_handler=null;this._renderercontextrestored_handler=null}Release(){if(this._renderercontextlost_handler){const dispatcher=this._runtime.Dispatcher();dispatcher.removeEventListener("renderercontextlost",this._renderercontextlost_handler);dispatcher.removeEventListener("renderercontextrestored",this._renderercontextrestored_handler);
this._renderercontextlost_handler=null;this._renderercontextrestored_handler=null}this._worldInfo=null;super.Release()}HandleWebGLContextLoss(){this.HandleRendererContextLoss()}OnWebGLContextLost(){}OnWebGLContextRestored(){}HandleRendererContextLoss(){if(this._renderercontextlost_handler)return;this._renderercontextlost_handler=()=>this.OnRendererContextLost();this._renderercontextrestored_handler=()=>this.OnRendererContextRestored();const dispatcher=this._runtime.Dispatcher();dispatcher.addEventListener("rendererontextlost",
this._renderercontextlost_handler);dispatcher.addEventListener("renderercontextrestored",this._renderercontextrestored_handler)}OnRendererContextLost(){this.OnWebGLContextLost()}OnRendererContextRestored(){this.OnWebGLContextRestored()}GetWorldInfo(){return this._worldInfo}IsOriginalSizeKnown(){return false}GetOriginalWidth(){if(!this.IsOriginalSizeKnown())throw new Error("original size not known");const imageInfo=this.GetCurrentImageInfo();if(imageInfo)return imageInfo.GetWidth();else;}GetOriginalHeight(){if(!this.IsOriginalSizeKnown())throw new Error("original size not known");
const imageInfo=this.GetCurrentImageInfo();if(imageInfo)return imageInfo.GetHeight();else;}GetCurrentImageInfo(){return null}GetCurrentSurfaceSize(){const imageInfo=this.GetCurrentImageInfo();if(imageInfo){const texture=imageInfo.GetTexture();if(texture)return[texture.GetWidth(),texture.GetHeight()]}return[100,100]}GetCurrentTexRect(){const imageInfo=this.GetCurrentImageInfo();return imageInfo?imageInfo.GetTexRect():null}GetCurrentTexQuad(){const imageInfo=this.GetCurrentImageInfo();return imageInfo?
imageInfo.GetTexQuad():null}IsCurrentTexRotated(){const imageInfo=this.GetCurrentImageInfo();return imageInfo?imageInfo.IsRotated():false}GetImagePoint(nameOrIndex){const wi=this._inst.GetWorldInfo();return[wi.GetX(),wi.GetY(),wi.GetTotalZElevation()]}LoadTilemapData(data,mapWidth,mapHeight){}TestPointOverlapTile(x,y){}RendersToOwnZPlane(){return true}};

}

// sdk/sdkDOMInstanceBase.js
{
'use strict';const C3=self.C3;const tempRect=C3.New(C3.Rect);
C3.SDKDOMInstanceBase=class SDKDOMInstanceBase extends C3.SDKWorldInstanceBase{constructor(inst,domComponentId){super(inst,domComponentId);this._elementId=this.GetPlugin()._AddElement(this);this._isElementShowing=true;this._elemHasFocus=false;this._autoFontSize=false;this._autoFontSizeOffset=-.2;this._lastRect=C3.New(C3.Rect,0,0,-1,-1);const canvasManager=this._runtime.GetCanvasManager();this._lastWindowWidth=canvasManager.GetLastWidth();this._lastWindowHeight=canvasManager.GetLastHeight();this._isPendingUpdateState=
false;this._StartTicking()}Release(){this.GetPlugin()._RemoveElement(this._elementId);this.PostToDOMElement("destroy");this._elementId=-1;super.Release()}_GetElementInDOMMode(){if(this._runtime.IsInWorker())throw new Error("not valid in worker mode");return this._PostToDOMElementMaybeSync("get-element")}PostToDOMElement(handler,data){if(!data)data={};data["elementId"]=this._elementId;this.PostToDOM(handler,data)}_PostToDOMElementMaybeSync(handler,data){if(!data)data={};data["elementId"]=this._elementId;
return this._PostToDOMMaybeSync(handler,data)}PostToDOMElementAsync(handler,data){if(!data)data={};data["elementId"]=this._elementId;return this.PostToDOMAsync(handler,data)}CreateElement(data){if(!data)data={};const isVisible=this.GetWorldInfo().IsVisible();data["elementId"]=this._elementId;data["isVisible"]=isVisible;Object.assign(data,this.GetElementState());this._isElementShowing=!!data["isVisible"];this._PostToDOMMaybeSync("create",data);this._UpdatePosition(true)}SetElementVisible(v){v=!!v;
if(this._isElementShowing===v)return;this._isElementShowing=v;this.PostToDOMElement("set-visible",{"isVisible":v})}Tick(){this._UpdatePosition(false)}_ShouldPreserveElement(){const fullscreenMode=this._runtime.GetCanvasManager().GetFullscreenMode();return C3.Platform.OS==="Android"&&(fullscreenMode==="scale-inner"||fullscreenMode==="scale-outer"||fullscreenMode==="crop")}_UpdatePosition(first){const wi=this.GetWorldInfo();const layer=wi.GetLayer();const bbox=wi.GetBoundingBox();let [cleft,ctop]=layer.LayerToCanvasCss(bbox.getLeft(),
bbox.getTop());let [cright,cbottom]=layer.LayerToCanvasCss(bbox.getRight(),bbox.getBottom());const canvasManager=this._runtime.GetCanvasManager();const rightEdge=canvasManager.GetCssWidth();const bottomEdge=canvasManager.GetCssHeight();if(!wi.IsVisible()||!layer.IsVisible()){this.SetElementVisible(false);return}if(!this._ShouldPreserveElement()){if(cright<=0||cbottom<=0||cleft>=rightEdge||ctop>=bottomEdge){this.SetElementVisible(false);return}if(cleft<1)cleft=1;if(ctop<1)ctop=1;if(cright>=rightEdge)cright=
rightEdge-1;if(cbottom>=bottomEdge)cbottom=bottomEdge-1}tempRect.set(cleft,ctop,cright,cbottom);const curWinWidth=canvasManager.GetLastWidth();const curWinHeight=canvasManager.GetLastHeight();if(!first&&tempRect.equals(this._lastRect)&&this._lastWindowWidth===curWinWidth&&this._lastWindowHeight===curWinHeight){this.SetElementVisible(true);return}this._lastRect.copy(tempRect);this._lastWindowWidth=curWinWidth;this._lastWindowHeight=curWinHeight;this.SetElementVisible(true);let fontSize=null;if(this._autoFontSize)fontSize=
layer.GetDisplayScale()+this._autoFontSizeOffset;this.PostToDOMElement("update-position",{"left":Math.round(this._lastRect.getLeft())+canvasManager.GetCanvasClientX(),"top":Math.round(this._lastRect.getTop())+canvasManager.GetCanvasClientY(),"width":Math.round(this._lastRect.width()),"height":Math.round(this._lastRect.height()),"fontSize":fontSize})}FocusElement(){this._PostToDOMElementMaybeSync("focus",{"focus":true})}BlurElement(){this._PostToDOMElementMaybeSync("focus",{"focus":false})}_OnElemFocused(){this._elemHasFocus=
true}_OnElemBlurred(){this._elemHasFocus=false}IsElementFocused(){return this._elemHasFocus}SetElementCSSStyle(prop,val){this.PostToDOMElement("set-css-style",{"prop":C3.CSSToCamelCase(prop),"val":val})}SetElementAttribute(attribName,value){this.PostToDOMElement("set-attribute",{"name":attribName,"val":value})}RemoveElementAttribute(attribName){this.PostToDOMElement("remove-attribute",{"name":attribName})}UpdateElementState(){if(this._isPendingUpdateState)return;this._isPendingUpdateState=true;Promise.resolve().then(()=>
{this._isPendingUpdateState=false;this.PostToDOMElement("update-state",this.GetElementState())})}GetElementState(){}GetElementId(){return this._elementId}};

}

// sdk/sdkBehaviorBase.js
{
'use strict';const C3=self.C3;const IBehavior=self.IBehavior;
C3.SDKBehaviorBase=class SDKBehaviorBase extends C3.DefendedBase{constructor(opts){super();this._runtime=opts.runtime;this._myObjectClasses=C3.New(C3.ArraySet);this._myInstances=C3.New(C3.ArraySet);this._iBehavior=null;this._scriptInterfaceClass=opts.scriptInterfaceClass||null}Release(){this._myInstances.Release();this._myObjectClasses.Release();this._runtime=null}GetRuntime(){return this._runtime}OnCreate(){}_AddObjectClass(objectClass){this._myObjectClasses.Add(objectClass)}GetObjectClasses(){return this._myObjectClasses.GetArray()}_AddInstance(inst){this._myInstances.Add(inst)}_RemoveInstance(inst){this._myInstances.Delete(inst)}GetInstances(){return this._myInstances.GetArray()}GetIBehavior(){if(this._iBehavior===null){const CustomScriptClass=
this._scriptInterfaceClass;if(CustomScriptClass){this._iBehavior=new CustomScriptClass(this);if(!(this._iBehavior instanceof IBehavior))throw new TypeError("script interface class must derive from IBehavior");}else this._iBehavior=new IBehavior(this)}return this._iBehavior}};

}

// sdk/sdkBehaviorTypeBase.js
{
'use strict';const C3=self.C3;C3.SDKBehaviorTypeBase=class SDKBehaviorTypeBase extends C3.DefendedBase{constructor(behaviorType){super();this._runtime=behaviorType.GetRuntime();this._behaviorType=behaviorType;this._objectClass=behaviorType.GetObjectClass();this._behavior=behaviorType.GetBehavior();this._behavior._AddObjectClass(this._objectClass)}Release(){this._runtime=null;this._behaviorType=null;this._objectClass=null;this._behavior=null}OnCreate(){}GetBehaviorType(){return this._behaviorType}GetObjectClass(){return this._objectClass}GetRuntime(){return this._runtime}GetBehavior(){return this._behavior}};

}

// sdk/sdkBehaviorInstanceBase.js
{
'use strict';const C3=self.C3;
C3.SDKBehaviorInstanceBase=class SDKBehaviorInstanceBase extends C3.DefendedBase{constructor(behInst,domComponentId){super();this._behInst=behInst;this._domComponentId=domComponentId