function Scene_GrosseItem(){ this.initialize.apply(this, arguments); }
Scene_GrosseItem.prototype = Object.create(Scene_MonsterMutter.prototype);
Scene_GrosseItem.prototype.constructor = Scene_GrosseItem;

function Window_DgsItemList(){ this.initialize.apply(this, arguments); }
Window_DgsItemList.prototype = Object.create(Window_ItemList.prototype);
Window_DgsItemList.prototype.constructor = Window_DgsItemList;

(function(){
    Window_DgsItemList.prototype.initialize = function(x,y,w,h,help,status) {
        Window_ItemList.prototype.initialize.call(this,x,y,w,h);
        this._statusWindow = status
        this.setHelpWindow(help);
        this.refresh();
        this.activate();
        this.select(0);
    }
    Window_DgsItemList.prototype.includes = function(item) {
        return item && !DataManager.isItem(item) &&
        item.meta.dmt && item.meta.dmt.length > 0;
    };
    Window_DgsItemList.prototype.maxCols = function(){
        return 1;
    }
    Window_DgsItemList.prototype.isEnabled = function(item){
        return !!item;
    }

    function refreshStatus(item){
        this.contents.clear();
        const sys = this.systemColor(), nml = this.normalColor();
        this.changeTextColor(sys);
        const w = this.contents.width;
        this.drawText(TextManager.dieGrosse,0,0,w,"center");
        if (!item) { return };
        let y = 16;
        this.changeTextColor(nml);
        this.drawText(item.name,32,y,w);
        this.drawIcon(item.iconIndex,0,y+4);

        y+=16;
        this.drawText($gameParty.numItems(item),0,y,w,"right");
        this.drawText("×",-50,y,w,"right");

        y+=16;
        this.changeTextColor(sys);
        this.drawText(TextManager.drObtainable,0,y,w);
        this.changeTextColor(nml);

        y+=16;
        item.meta.dmt.forEach(function(dmt){
            const item = $dataItems[dmt[0]];
            this.drawText(item.name,32,y,w);
            this.drawIcon(item.iconIndex,0,y+4);
            y+=16;
            this.drawText(dmt[1],0,y,w,"right");
            this.drawText($gameParty.numItems(item)+"+",-50,y,w,"right");
            y+=16;
        }, this);
        if (DataManager.isItem(item)){ return };
        y=144;
        for (let i = 0; i < 8; i++){
            this.changeTextColor(sys);
            this.drawText(TextManager.param(i),0,y,w);
            this.changeTextColor(nml);
            this.drawText(item.params[i],0,y,w,"right");
            y+=16;
        };
        let object, typeName;
        if (DataManager.isWeapon(item)){
            object = $dataSystem.weaponTypes;
            typeName = "wtypeId";
        }else{
            object = $dataSystem.armorTypes;
            typeName = "atypeId";
        }
        this.changeTextColor(sys);
        this.drawText(TextManager._itemBook2,0,y,w);
        this.changeTextColor(nml);
        this.drawText($dataSystem.equipTypes[item.etypeId],0,y,w,"right");

        y+=16;
        this.changeTextColor(sys);
        this.drawText(TextManager._itemBook3,0,y,w);
        this.changeTextColor(nml);
        this.drawText(object[item[typeName]],0,y,w,"right");
    }

    Window_DgsItemList.prototype.setHelpWindowItem = function(item) {
        if (this._helpWindow) {
            refreshStatus.call(this._statusWindow, item);
            this._helpWindow.setItem(item);
        }
    };


    // Scene_GrosseItem
    Scene_GrosseItem.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);
        this.createHelpWindow();
        this.createStatusWindow();
        this.createItemWindow();
    };
    Scene_GrosseItem.prototype.createStatusWindow = function(){
        const wy = this._helpWindow.height;
        const ww = 250;
        this._statusWindow = new Window_Base(Graphics.width-ww,wy,ww,Graphics.height-wy);
        this.addWindow(this._statusWindow);
    };
    Scene_GrosseItem.prototype.createItemWindow = function() {
        this._itemWindow = new Window_DgsItemList(
            0,this._statusWindow.y,Graphics.width-this._statusWindow.width,
            this._statusWindow.height,this._helpWindow,this._statusWindow
        );
        this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
        this._itemWindow.setHandler('cancel', this.popScene.bind(this));
        this.addWindow(this._itemWindow);
    };

    Scene_GrosseItem.prototype.onItemOk = function(){
        const item = this._itemWindow.item();
        if (item){
            AudioManager.playSe({name:'se_maoudamashii_retro25', volume:100, pitch:100});
            item.meta.dmt.forEach(function(dmt){
                $gameParty.gainItem($dataItems[dmt[0]],dmt[1]);
            })
            $gameParty.gainItem(item,-1);
            this._itemWindow.refresh();
        }
        this._itemWindow.activate();
    };
})();