function Scene_ItemMutter(){this.initialize.apply(this, arguments);}
Scene_ItemMutter.prototype = Object.create(Scene_MenuBase.prototype);
Scene_ItemMutter.prototype.constructor = Scene_Shop;

function Window_DmtItemList(){this.initialize.apply(this, arguments);}
Window_DmtItemList.prototype = Object.create(Window_ItemList.prototype);
Window_DmtItemList.prototype.constructor = Window_DmtItemList;

(function(){
    Window_DmtItemList.prototype.initialize = function(x,y,w,h,goods){
        Window_ItemList.prototype.initialize.call(this,x,y,w,h);
        this._data = goods;
        this.refresh();
        this.select(0);
        this.activate();
    }

    Window_DmtItemList.prototype.makeItemList = function() {
        if(!this._data){this._data = [];}
    };
    Window_DmtItemList.prototype.maxCols = function() {
        return 1;
    };
    Window_DmtItemList.prototype.setStatusWindow = function(window) {
        this._statusWindow = window;
        this.refreshStatusWindow();
    };
    Window_DmtItemList.prototype.select = function(idx){
        Window_ItemList.prototype.select.call(this, idx);
        this._statusWindow && this.refreshStatusWindow();
    }
    Window_DmtItemList.prototype.refreshStatusWindow = function() {
        const item = this.item();
        function refresh (item){
            this.contents.clear();
            this.changeTextColor(this.systemColor());
            const w = this.contents.width;
            this.drawText(TextManager.dieMutterItem1,0,0,w,"center");
            if (item){
                let y = 16;
                this.drawText(TextManager.possession,0,16,w);
                this.changeTextColor(this.normalColor());
                this.drawText($gameParty.numItems(item),0,16,w,"right");

                y = 48;
                this.changeTextColor(this.systemColor());
                this.drawText(TextManager.dieMutterIngredient,0,y,w);
                this.changeTextColor(this.normalColor());
                y += 20
                item.meta.dmt.forEach(function(dmt){
                    const item = $dataItems[dmt[0]];
                    this.drawItemName(item,0,y,w);
                    let num  = String(dmt[1]);
                    if (num.length == 1) { num = " "+num };
                    this.drawText(
                        $gameParty.numItems(item)+"/"+num,0,y+16,w,"right");
                    y += 32;
                }, this);

                if (item.params){
                    y = 172;
                    for (let i = 0; i < 8; i++){
                        this.changeTextColor(this.systemColor());
                        this.drawText(TextManager.param(i),0,y,w);
                        this.changeTextColor(this.normalColor());
                        this.drawText(item.params[i],0,y,w,"right");
                        y+=16;
                    }
                }
            }
        };
        refresh.call(this._statusWindow, item);
    };
    Window_DmtItemList.prototype.drawItem = function(idx) {
        const item = this._data[idx];
        if (item){
            const rect = this.itemRectForText(idx);
            this.changePaintOpacity(this.isEnabled(item));
            this.drawItemName(item, rect.x, rect.y, rect.width);
            this.drawItemNumber(item, rect.x, rect.y, rect.width);
        }
    };

    Window_DmtItemList.prototype.isEnabled = function(item){
        if (item && item.meta.dmt){
            const dmt = item.meta.dmt;
            for (let i = 0; i < dmt.length; i++){
                if ($gameParty.numItems($dataItems[dmt[i][0]]) < dmt[i][1]){
                    return false; };
            }
            return true;
        }
        return false;
    };
    
    // Scene_ItemMutter
    Scene_ItemMutter.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);
        this.createHelpWindow();
        this.createItemWindow();
        this.createStatusWindow();
    };
    
    Scene_ItemMutter.prototype.prepare = function(goods) {
        this._goods = goods;
        this._item = null;
    };

    Scene_ItemMutter.prototype.createItemWindow = function() {
        const wy = this._helpWindow.height;
        this._itemWindow = new Window_DmtItemList(
            0,wy,314,Graphics.height-wy,this._goods);
        this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
        this._itemWindow.setHandler('cancel', this.popScene.bind(this));
        this._itemWindow.setHelpWindow(this._helpWindow);
        this.addWindow(this._itemWindow);
    };

    Scene_ItemMutter.prototype.onItemOk = function(){
        const item = this._itemWindow.item();
        if (item){
            AudioManager.playSe({name:'se_maoudamashii_retro25', volume:100, pitch:100});
            $gameParty.gainItem(item, 1);
            item.meta.dmt.forEach(function(dmt){
                $gameParty.gainItem($dataItems[dmt[0]], -dmt[1]);
            });
            this._itemWindow.refresh();
            this._itemWindow.refreshStatusWindow();
        }
        this._itemWindow.activate();
    }

    Scene_ItemMutter.prototype.createStatusWindow = function(){
        this._statusWindow = new Window_Base(
            this._itemWindow.width, this._itemWindow.y,
            Graphics.width - this._itemWindow.width, this._itemWindow.height
        );
        this._itemWindow.setStatusWindow(this._statusWindow);
        this.addWindow(this._statusWindow);
    }
})();