function Scene_MonsterMutter(){ this.initialize.apply(this, arguments); }
Scene_MonsterMutter.prototype = Object.create(Scene_ItemMutter.prototype);
Scene_MonsterMutter.prototype.constructor = Scene_MonsterMutter;

function Window_DmtMonsterList(){ this.initialize.apply(this, arguments); }
Window_DmtMonsterList.prototype = Object.create(Window_DmtItemList.prototype);
Window_DmtMonsterList.prototype.constructor = Window_DmtMonsterList;

(function(){
    Window_DmtMonsterList.prototype.makeItemList = function() {
        this._data = $gameParty.items().filter(
            function(item) {return item.meta.crt;}, this);
    };

    Window_DmtMonsterList.prototype.isOwnedMonster = function(id){
        id = Number(id);
        return  $gameParty._actors.contains(id) || 
                $gameSystem.waitingMembers().contains(id);
    }

    Window_DmtMonsterList.prototype.isEnabled = function(item){
        if (!item || $gameParty.members().length == 4 || 
            this.isOwnedMonster(item.meta.crt)
        ) {
            return false;
        };
        $gameParty.hasItem($dataItems[item.meta.dmt[0]]);
        if (item && item.meta.dmt){
            const dmt = item.meta.dmt;
            for (let i = 0; i < dmt.length; i++){
                if ($gameParty.numItems($dataItems[dmt[i][0]]) < dmt[i][1]){
                    return false; };
            }
            return true;
        }
        return false;
    };

    Window_DmtMonsterList.prototype.refreshStatusWindow = function() {
        const item = this.item();
        function refresh (item){
            this.contents.clear();
            this.changeTextColor(this.systemColor());
            const w = this.contents.width;
            this.drawText(TextManager.dieMutterMost1,0,0,w,"center");
            if (item){
                let y = 16;
                this.changeTextColor(this.systemColor());
                this.drawText(TextManager.dieMutterIngredient,0,y,w);
                this.changeTextColor(this.normalColor());
                y += 20;
                item.meta.dmt.forEach(function(dmt){
                    const item = $dataItems[dmt[0]];
                    this.drawItemName(item,0,y,w);
                    let num  = String(dmt[1]);
                    if (num.length == 1) { num = " "+num };
                    this.drawText(
                        $gameParty.numItems(item)+"/"+num,0,y+16,w,"right");
                    y += 32;
                }, this);

                y = 160;
                const id = item.meta.crt;
                if ($dataClasses[id] && $dataActors[id]){
                    this.drawText($dataClasses[id].name,0,y-16,w);
                    this.drawText($dataActors[id].profile,0,y,w);
                    y += 16;
                    const param = $dataClasses[id].params;
                    for (let i = 0; i < 8; i++){
                        this.changeTextColor(this.systemColor());
                        this.drawText(TextManager.param(i),0,y,w);
                        this.changeTextColor(this.normalColor());
                        this.drawText(param[i][1],0,y,w,"right");
                        y+=16;
                    }
                }
            }
        };
        refresh.call(this._statusWindow, item);
    };
    Window_DmtMonsterList.prototype.drawItem = function(idx) {
        const item = this._data[idx];
        if (item){
            const rect = this.itemRectForText(idx);
            this.changePaintOpacity(this.isEnabled(item));
            this.drawItemName(item, rect.x, rect.y, rect.width);
            this.drawItemNumber(item, rect.x, rect.y, rect.width);
            if (this.isOwnedMonster(item.meta.crt)){
                this.drawText(TextManager.ownedMonster, rect.x, rect.y+16, rect.width, "right");
            };
        }
    };

    // Scene_ItemMutter
    Scene_MonsterMutter.prototype.createItemWindow = function() {
        const wy = this._helpWindow.height;
        this._itemWindow = new Window_DmtMonsterList(
            0,wy,314,Graphics.height-wy,this._goods);
        this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
        this._itemWindow.setHandler('cancel', this.popScene.bind(this));
        this._itemWindow.setHelpWindow(this._helpWindow);
        this.addWindow(this._itemWindow);
    };

    Scene_MonsterMutter.prototype.onItemOk = function(){
        const item = this._itemWindow.item();
        if (item){
            $gameVariables.setValue(2,parseInt(item.meta.crt));
            $gameParty.gainItem(item, -1);
            item.meta.dmt.forEach(function(dmt){
                $gameParty.gainItem($dataItems[dmt[0]], -dmt[1]);
            });
            this.popScene();
        }else{
            this._itemWindow.activate();
        }
    }
})();