function Window_MenuExp() { this.initialize.apply(this, arguments);}
Window_MenuExp.prototype = Object.create(Window_Selectable.prototype);
Window_MenuExp.prototype.constructor = Window_MenuExp;

function Scene_MenuExp() { this.initialize.apply(this, arguments);}
Scene_MenuExp.prototype = Object.create(Scene_MenuBase.prototype);
Scene_MenuExp.prototype.constructor = Scene_MenuExp;

(function(){
    Window_MenuExp.prototype.maxCols = function(){
        return 1;
    };

    Window_MenuExp.prototype.standardPadding = function(){
        return 8;
    };

    Window_MenuExp.prototype.itemHeight = function(){
        return 71;
    };

    Window_MenuExp.prototype.maxItems = function(){
        return $gameParty.size();
    };

    Window_MenuExp.prototype.members = function(){
        return $gameParty.members();
    };

    Window_MenuExp.prototype.expItem = function(){
        return $gameParty.lastItem();
    }

    function isItemGainer (item){
        return item.effects.find(function(effect){
            return effect.code == 42;
        });
    };

    Window_MenuExp.prototype.isEnable = function(actor){
        const item = this.expItem();
        const effect = isItemGainer(item);
        return actor && item && $gameParty.numItems(item) > 0 && (
            effect ? actor.param(effect.dataId) != actor.paramMax(effect.dataId)
            : !actor.isMaxLevel()
        );
    };

    Window_MenuExp.prototype.drawItem = function(idx){
        const actor = this.members()[idx];
        if (actor){
            this.changePaintOpacity(this.isEnable(actor));
            const rect = this.itemRect(idx);
            let x = 160, y = rect.y-2, w = 182, tmp;
            this.drawText(actor.name(),rect.x,y,rect.width);
            this.drawActorHp(actor, x,y,w)
            this.drawActorMp(actor, x+w+30,y,w)
            y += 16;
            w = 133
            for (let i = 2; i < 8; i++){
                tmp = (i-2) % 3;
                x = 160 + tmp * w;
                this.changeTextColor(this.systemColor());
                this.drawText(TextManager.param(i),x,y,w);
                this.changeTextColor(this.normalColor());
                this.drawText(actor.param(i),x,y,w-4,"right");
                if (tmp == 2) { y += 16; };
            }
            y = rect.y+46;
            this.drawActorLevel(actor, rect.x-4, y);
            this.drawActorExp(actor, rect.x + 160, y, 262);
            this.changePaintOpacity(1);
        }
    }

    // Scene_Item
    Scene_Item.prototype.onItemOk = function() {
        const item = this.item();
        $gameParty.setLastItem(item);
        if (item && (item.meta.EXP || isItemGainer(item))){
            SceneManager.push(Scene_MenuExp);
        }else{
            this.determineItem();
        }
    };

    // Scene_MenuExp
    Scene_MenuExp.prototype.create = function(){
        Scene_MenuBase.prototype.create.call(this);
        this.createMessageWindow();
        this.createMenuExp();
        this.refreshDummy();
    };

    Scene_MenuExp.prototype.createMessageWindow = function(){
        this._messageWindow = new Window_Message();
        const wx = this._messageWindow.x;
        const ww = this._messageWindow.width;
        const wh = this._messageWindow.height;
        this._dummyWindow = new Window_Base(wx,Graphics.height-wh,ww,wh);
        this.addWindow(this._dummyWindow);
        this.addWindow(this._messageWindow);
    };

    Scene_MenuExp.prototype.createMenuExp = function(){
        const ww = Graphics.width;
        const wh = Graphics.height - this._messageWindow.height;
        this._expWindow = new Window_MenuExp(0,0,ww,wh);
        this._expWindow.setHandler('ok',     this.onExpOk.bind(this));
        this._expWindow.setHandler('cancel', this.popScene.bind(this));
        this._expWindow.refresh();
        this._expWindow.activate();
        this._expWindow.select(0);
        this.addWindow(this._expWindow);
    };

    Scene_MenuExp.prototype.refreshDummy = function(){
        const item = this._expWindow.expItem();
        if (!item) { return };
        const w = 332;
        function refresh(){
            this.contents.clear();
            const old = this.standardFontSize;
            this.standardFontSize = function(){ return 28 };
            this.contents.fontSize = this.standardFontSize();
            this.drawTextEx(item.description,2,32);
            this.drawItemName(item,-2,0,w);

            this.drawText(
                "x"+("   "+$gameParty.numItems(item)).slice(-3),
                0,0,w,"right"
            );
            this.standardFontSize = old;
        };
        refresh.call(this._dummyWindow);
    }

    Scene_MenuExp.prototype.onExpOk = function(){
        const item  = this._expWindow.expItem();
        const actor = this._expWindow.members()[this._expWindow.index()];
        if (item && actor && this._expWindow.isEnable(actor)){
            const effect = isItemGainer(item);
            if (effect){
                actor.addParam(effect.dataId, Math.floor(effect.value1));
            }else{
                actor.changeExp(actor.currentExp() + Number(item.meta.EXP));
            }
            $gameParty.gainItem(item, -1);
            this._expWindow.refresh();
            this.refreshDummy();
        }
        this._expWindow.activate();
    };

})();