(function(){
    const __create = Scene_Load.prototype.create;
    Scene_Load.prototype.create = function(){
        __create.apply(this, arguments);
        this.fadeInSprite = new Sprite();
        this.addChild(this.fadeInSprite);
        this.fadeInSprite.scale.x = this.fadeInSprite.scale.y = 2;
        this.fadeOutCnt = 0;
        this.inScene = true;
    }

    Scene_Load.prototype.isBusy = function() {
        return this.inScene;
    };

    Scene_Load.prototype.popScene = function() {
        this.inScene = false;
        Scene_File.prototype.popScene.call(this);
    };

    const __update = Scene_Load.prototype.update;
    Scene_Load.prototype.update = function() {
        __update.apply(this, arguments);
        if (this.fadeOutCnt != 0){
            switch (this.fadeOutCnt--){
                case 30: this.fadeInSprite.bitmap = ImageManager.loadPicture("fade4");break;
                case 25: this.fadeInSprite.bitmap = ImageManager.loadPicture("fade3");break;
                case 20: this.fadeInSprite.bitmap = ImageManager.loadPicture("fade2");break;
                case 15: this.fadeInSprite.bitmap = ImageManager.loadPicture("fade1");break;
                case 10:
                    this.fadeInSprite.scale.x = this.fadeInSprite.scale.y = 20;
                    this.fadeInSprite.bitmap = ImageManager.loadPicture("fade5");
                    break;
                case 5:
                    this.inScene = false;
                    break;
            }
        }
    };

    Scene_Load.prototype.onLoadSuccess = function() {
        this.fadeOutCnt = 30;
        SoundManager.playLoad();
        AudioManager.fadeOutBgm(this.slowFadeSpeed() / 60);
        this.reloadMapIfUpdated();
        SceneManager.goto(Scene_Map);
        this._loadSuccess = true;
    };


    DataManager.makeSavefileInfo = function() {
        var info = {};
        info.globalId = this._globalId;
        info.title    = $dataSystem.gameTitle;
        info.faces    = $gameParty.facesForSavefile();
        info.playtime  = $gameSystem.playtimeText();
        info.clearFlag = $gameSwitches.value(4);
        info.timestamp = Date.now();
        return info;
    };

    Game_Party.prototype.facesForSavefile = function() {
        const list = $gameParty.battleMembers().map(function(a){
            return [a.faceName(), a.faceIndex()]
        });
        list[0].push($gameActors.actor(1).name());
        return list;
    };

    Window_SavefileList.prototype.maxCols = function(){
        return 1;
    }

    Window_SavefileList.prototype.maxVisibleItems = function() {
        return 3;
    };
    
    Window_SavefileList.prototype.drawContents = function(info, rect, valid) {
        const bottom = rect.y + rect.height;
        const y2 = bottom - this.lineHeight();
        let x = rect.x+46;
        if (valid && info.faces){
            info.faces.forEach(function(face){
                this.drawFace(face[0], face[1], x+=100, rect.y+8);
            }, this);
            const size = this.contents.fontSize;
            if(romanLanguage()){
                this.contents.fontSize = 20;
            }else{
                this.contents.fontSize = 10;
            }
            this.changeTextColor(!info.clearFlag ? "#fff" : "#ff0");
            this.drawText(info.faces[0][2], rect.x, y2-32, rect.width);
            this.changeTextColor("#fff");
            this.contents.fontSize = size;
        }
        if (info.playtime) {
            this.drawText(info.playtime, rect.x, y2, rect.width);
        }
    };
})();